/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.instructions;

import org.zmpp.base.MemoryAccess;
import org.zmpp.encoding.ZCharEncoder;
import org.zmpp.instructions.AbstractInstruction;
import org.zmpp.instructions.InstructionStaticInfo;
import org.zmpp.instructions.VariableStaticInfo;
import org.zmpp.media.SoundSystem;
import org.zmpp.vm.Machine;
import org.zmpp.vm.ScreenModel;
import org.zmpp.vm.TextCursor;
import org.zmpp.vm.ZObject;

public class VariableInstruction
extends AbstractInstruction {
    private AbstractInstruction.OperandCount operandCount;

    public VariableInstruction(Machine machine, AbstractInstruction.OperandCount operandCount, int n) {
        super(machine, n);
        this.operandCount = operandCount;
    }

    public AbstractInstruction.InstructionForm getInstructionForm() {
        return AbstractInstruction.InstructionForm.VARIABLE;
    }

    public AbstractInstruction.OperandCount getOperandCount() {
        return this.operandCount;
    }

    protected InstructionStaticInfo getStaticInfo() {
        return VariableStaticInfo.getInstance();
    }

    private MemoryAccess getMemoryAccess() {
        return this.getMachine().getGameData().getMemoryAccess();
    }

    protected AbstractInstruction.InstructionResult doInstruction() {
        switch (this.getOpcode()) {
            case 0: {
                this.call();
                break;
            }
            case 12: {
                this.call();
                break;
            }
            case 1: {
                this.storew();
                break;
            }
            case 2: {
                this.storeb();
                break;
            }
            case 3: {
                this.put_prop();
                break;
            }
            case 4: {
                this.sread();
                break;
            }
            case 5: {
                this.print_char();
                break;
            }
            case 6: {
                this.print_num();
                break;
            }
            case 7: {
                this.random();
                break;
            }
            case 8: {
                this.push();
                break;
            }
            case 9: {
                this.pull();
                break;
            }
            case 10: {
                this.split_window();
                break;
            }
            case 17: {
                this.set_text_style();
                break;
            }
            case 18: {
                this.buffer_mode();
                break;
            }
            case 11: {
                this.set_window();
                break;
            }
            case 19: {
                this.output_stream();
                break;
            }
            case 20: {
                this.input_stream();
                break;
            }
            case 21: {
                this.sound_effect();
                break;
            }
            case 13: {
                this.erase_window();
                break;
            }
            case 14: {
                this.erase_line();
                break;
            }
            case 15: {
                this.set_cursor();
                break;
            }
            case 16: {
                this.get_cursor();
                break;
            }
            case 22: {
                this.read_char();
                break;
            }
            case 23: {
                this.scan_table();
                break;
            }
            case 24: {
                this.not();
                break;
            }
            case 25: 
            case 26: {
                this.call();
                break;
            }
            case 27: {
                this.tokenise();
                break;
            }
            case 28: {
                this.encode_text();
                break;
            }
            case 29: {
                this.copy_table();
                break;
            }
            case 30: {
                this.print_table();
                break;
            }
            case 31: {
                this.check_arg_count();
                break;
            }
            default: {
                this.throwInvalidOpcode();
            }
        }
        return new AbstractInstruction.InstructionResult(1, false);
    }

    private void call() {
        this.call(this.getNumOperands() - 1);
    }

    private void storew() {
        MemoryAccess memoryAccess = this.getMemoryAccess();
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        short s = this.getValue(2);
        memoryAccess.writeShort(n + n2 * 2, s);
        this.nextInstruction();
    }

    private void storeb() {
        MemoryAccess memoryAccess = this.getMemoryAccess();
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        byte by = (byte)this.getValue(2);
        memoryAccess.writeByte(n + n2, by);
        this.nextInstruction();
    }

    private void put_prop() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        short s = this.getValue(2);
        if (n > 0) {
            ZObject zObject = this.getObjectTree().getObject(n);
            if (zObject.isPropertyAvailable(n2)) {
                if (zObject.getPropertySize(n2) == 1) {
                    zObject.setPropertyByte(n2, 0, (byte)(s & 0xFF));
                } else {
                    zObject.setPropertyByte(n2, 0, (byte)(s >> 8 & 0xFF));
                    zObject.setPropertyByte(n2, 1, (byte)(s & 0xFF));
                }
                this.nextInstruction();
            } else {
                this.getMachine().getCpu().halt("put_prop: the property [" + n2 + "] of object [" + n + "] does not exist");
            }
        } else {
            this.getMachine().warn("@put_prop illegal access to object " + n);
            this.nextInstruction();
        }
    }

    private void print_char() {
        short s = this.getValue(0);
        this.getMachine().getOutput().printZsciiChar(s, false);
        this.nextInstruction();
    }

    private void print_num() {
        short s = this.getValue(0);
        this.getMachine().getOutput().printNumber(s);
        this.nextInstruction();
    }

    private void push() {
        short s = this.getValue(0);
        this.getCpu().setVariable(0, s);
        this.nextInstruction();
    }

    private void pull() {
        int n = this.getUnsignedValue(0);
        short s = this.getCpu().getVariable(0);
        if (n == 0) {
            this.getCpu().setStackTopElement(s);
        } else {
            this.getCpu().setVariable(n, s);
        }
        this.nextInstruction();
    }

    private void output_stream() {
        short s = this.getValue(0);
        if (s < 0 && s >= -3) {
            this.getMachine().getOutput().selectOutputStream(-s, false);
        } else if (s > 0 && s <= 3) {
            if (s == 3) {
                int n = this.getUnsignedValue(1);
                this.getMachine().getOutput().selectOutputStream3(n);
            } else {
                this.getMachine().getOutput().selectOutputStream(s, true);
            }
        }
        this.nextInstruction();
    }

    private void input_stream() {
        this.getMachine().getInput().selectInputStream(this.getUnsignedValue(0));
        this.nextInstruction();
    }

    private void random() {
        short s = this.getValue(0);
        this.storeResult(this.getMachine().random(s));
        this.nextInstruction();
    }

    private void sread() {
        int n = this.getStoryFileVersion();
        if (n <= 3) {
            this.getMachine().updateStatusLine();
        }
        int n2 = this.getUnsignedValue(0);
        int n3 = 0;
        int n4 = 0;
        short s = 0;
        if (this.getNumOperands() >= 2) {
            n3 = this.getUnsignedValue(1);
        }
        if (this.getNumOperands() >= 3) {
            n4 = this.getUnsignedValue(2);
        }
        if (this.getNumOperands() >= 4) {
            s = this.getValue(3);
        }
        short s2 = this.getMachine().readLine(n2, n4, s);
        if (n < 5 || n >= 5 && n3 > 0) {
            this.getMachine().tokenize(n2, n3, 0, false);
        }
        if (this.storesResult()) {
            this.storeResult(s2);
        }
        this.nextInstruction();
    }

    private void sound_effect() {
        int n = 1;
        int n2 = 2;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        if (this.getNumOperands() >= 1) {
            n = this.getUnsignedValue(0);
        }
        if (this.getNumOperands() >= 2) {
            n2 = this.getUnsignedValue(1);
        }
        if (this.getNumOperands() >= 3) {
            int n6 = this.getUnsignedValue(2);
            n3 = n6 & 0xFF;
            n4 = n6 >>> 8 & 0xFF;
            if (n4 <= 0) {
                n4 = 1;
            }
        }
        if (this.getNumOperands() == 4) {
            n5 = this.getUnsignedValue(3);
        }
        System.out.printf("@sound_effect n: %d, fx: %d, vol: %d, rep: %d, routine: $%04x\n", n, n2, n3, n4, n5);
        if (this.getStoryFileVersion() == 3) {
            n4 = 1;
        }
        SoundSystem soundSystem = this.getMachine().getSoundSystem();
        soundSystem.play(n, n2, n3, n4, n5);
        this.nextInstruction();
    }

    private void split_window() {
        ScreenModel screenModel = this.getMachine().getScreen();
        if (screenModel != null) {
            screenModel.splitWindow(this.getUnsignedValue(0));
        }
        this.nextInstruction();
    }

    private void set_window() {
        ScreenModel screenModel = this.getMachine().getScreen();
        if (screenModel != null) {
            screenModel.setWindow(this.getUnsignedValue(0));
        }
        this.nextInstruction();
    }

    private void set_text_style() {
        ScreenModel screenModel = this.getMachine().getScreen();
        if (screenModel != null) {
            screenModel.setTextStyle(this.getUnsignedValue(0));
        }
        this.nextInstruction();
    }

    private void buffer_mode() {
        ScreenModel screenModel = this.getMachine().getScreen();
        if (screenModel != null) {
            screenModel.setBufferMode(this.getUnsignedValue(0) > 0);
        }
        this.nextInstruction();
    }

    private void erase_window() {
        ScreenModel screenModel = this.getMachine().getScreen();
        if (screenModel != null) {
            screenModel.eraseWindow(this.getValue(0));
        }
        this.nextInstruction();
    }

    private void erase_line() {
        ScreenModel screenModel = this.getMachine().getScreen();
        if (screenModel != null) {
            screenModel.eraseLine(this.getValue(0));
        }
        this.nextInstruction();
    }

    private void set_cursor() {
        ScreenModel screenModel = this.getMachine().getScreen();
        if (screenModel != null) {
            short s = this.getValue(0);
            short s2 = 0;
            int n = -3;
            if (this.getNumOperands() >= 2) {
                s2 = this.getValue(1);
            }
            if (this.getNumOperands() >= 3) {
                n = this.getValue(2);
            }
            if (s > 0) {
                screenModel.setTextCursor(s, s2, n);
            }
        }
        this.nextInstruction();
    }

    private void get_cursor() {
        ScreenModel screenModel = this.getMachine().getScreen();
        if (screenModel != null) {
            TextCursor textCursor = screenModel.getTextCursor();
            MemoryAccess memoryAccess = this.getMemoryAccess();
            int n = this.getUnsignedValue(0);
            memoryAccess.writeShort(n, (short)textCursor.getLine());
            memoryAccess.writeShort(n + 2, (short)textCursor.getColumn());
        }
        this.nextInstruction();
    }

    private void scan_table() {
        MemoryAccess memoryAccess = this.getMemoryAccess();
        short s = this.getValue(0);
        int n = this.getUnsignedValue(1);
        int n2 = this.getUnsignedValue(2);
        int n3 = 130;
        if (this.getNumOperands() == 4) {
            n3 = this.getUnsignedValue(3);
        }
        int n4 = n3 & 0x7F;
        boolean bl = (n3 & 0x80) > 0;
        int n5 = n;
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            short s2;
            short s3 = s2 = bl ? memoryAccess.readShort(n5) : (short)memoryAccess.readByte(n5);
            if (s2 == s) {
                this.storeResult((short)n5);
                bl2 = true;
                break;
            }
            n5 += n4;
        }
        if (!bl2) {
            this.storeResult((short)0);
        }
        this.branchOnTest(bl2);
    }

    private void read_char() {
        int n = 0;
        short s = 0;
        if (this.getNumOperands() >= 2) {
            n = this.getUnsignedValue(1);
        }
        if (this.getNumOperands() >= 3) {
            s = this.getValue(2);
        }
        this.storeResult(this.getMachine().readChar(n, s));
        this.nextInstruction();
    }

    private void not() {
        int n = ~this.getUnsignedValue(0);
        this.storeResult((short)(n & 0xFFFF));
        this.nextInstruction();
    }

    private void tokenise() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        int n3 = 0;
        int n4 = 0;
        if (this.getNumOperands() >= 3) {
            n3 = this.getUnsignedValue(2);
        }
        if (this.getNumOperands() >= 4) {
            n4 = this.getUnsignedValue(3);
        }
        this.getMachine().tokenize(n, n2, n3, n4 != 0);
        this.nextInstruction();
    }

    private void check_arg_count() {
        int n;
        int n2 = this.getUnsignedValue(0);
        this.branchOnTest(n2 <= (n = this.getCpu().getCurrentRoutineContext().getNumArguments()));
    }

    private void copy_table() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        int n3 = this.getValue(2);
        MemoryAccess memoryAccess = this.getMemoryAccess();
        if (n2 == 0) {
            n3 = Math.abs(n3);
            for (int i = 0; i < n3; ++i) {
                memoryAccess.writeByte(n + i, (byte)0);
            }
        } else if (n3 < 0 || n > n2) {
            n3 = Math.abs(n3);
            for (int i = 0; i < n3; ++i) {
                memoryAccess.writeByte(n2 + i, memoryAccess.readByte(n + i));
            }
        } else {
            n3 = Math.abs(n3);
            for (int i = n3 - 1; i >= 0; --i) {
                memoryAccess.writeByte(n2 + i, memoryAccess.readByte(n + i));
            }
        }
        this.nextInstruction();
    }

    private void print_table() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        int n3 = 1;
        int n4 = 0;
        if (this.getNumOperands() >= 3) {
            n3 = this.getUnsignedValue(2);
        }
        if (this.getNumOperands() == 4) {
            n4 = this.getUnsignedValue(3);
        }
        short s = 0;
        MemoryAccess memoryAccess = this.getMemoryAccess();
        TextCursor textCursor = this.getMachine().getScreen().getTextCursor();
        int n5 = textCursor.getColumn();
        int n6 = textCursor.getLine();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n7 = n2 * i + j;
                s = memoryAccess.readUnsignedByte(n + n7);
                this.getMachine().getOutput().printZsciiChar(s, false);
            }
            this.getMachine().getScreen().setTextCursor(n6 += n4 + 1, n5, -3);
        }
        this.nextInstruction();
    }

    private void encode_text() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        int n3 = this.getUnsignedValue(2);
        int n4 = this.getUnsignedValue(3);
        ZCharEncoder zCharEncoder = this.getMachine().getGameData().getZCharEncoder();
        zCharEncoder.encode(this.getMemoryAccess(), n + n3, n2, n4);
        this.nextInstruction();
    }
}

