[This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see http://www.gnu.org/licenses/]

Part 1 - Introducción

The story title is "Mars Menace From Outer Space".
The  story author is "Le Cabre / Phil Spectrum".
The story headline is "(C) Copyright 2015. Distribuido bajo licencia GPL[line break]Una aventura pulp nuclear".
The story genre is "Sci-fi".
The release number is 2.
The story creation year is 2015.
The story description is "Fuentes verificadas de #CONFIDENCIAL#, confirman detección de actividad anómala de naturaleza #CONFIDENCIAL# en inmueble residencial ubicado en #CONFIDENCIAL#".

Section 1 - Extensiones

Include Spanish Language by Sebastian Arg.
Include Basic Help Menu SP by Emily Short.
Include Basic Screen Effects SP by Emily Short.

Section 2 - Mensaje inicial

When play begins:
	clear the screen;
	display the boxed quotation
		"Mars Menace From Outer Space 
		por Le Cabre & Phil Spectrum";
	show the current quotation;
	wait for any key;
	clear the screen;
	say "[paragraph break][bold type]***ACTIVIDAD DETECTADA EN SECTOR OBJETIVO. PROCEDA SEGÚN PROTOCOLO XR-043T***";
	wait for any key;
	say "[paragraph break][roman type]Las órdenes... [no line break]"; 
	wait for any key; 
	say " son las órdenes.[paragraph break]";
	wait for any key;
	say "[italic type]**Toc** **Toc**[paragraph break]";
	wait for any key;
	say "[roman type]La puerta se abre, mostrando al sujeto. La descripción corresponde con precisión a la adjuntada en el informe.[paragraph break]";
	wait for any key;
	say "-¿Qué es lo que desea? Oh... no, no estoy interesado en comprar una enciclo...[italic type] AAAARRRRRRGHHH!!!![paragraph break]";
	wait for any key;
	say "[roman type]En cuestión de segundos, la descarga del paralizador deja frito al objetivo que se desmorona sin remedio. Procedes a hacer entrada en el inmueble. Cierras la puerta, posas el maletín y compruebas la estancia. Despejado.[paragraph break]";
	wait for any key;
	say "Apenas queda tiempo. La principal prioridad es la misión...[paragraph break]";
	wait for any key;
	say "La misión...";
	wait for any key;
	clear the screen;
	say "Teclea 'AYUDA' durante el juego para recibir instrucciones.[paragraph break]";	
	choose row 1 in Table of Basic Help Options;
	now description entry is "[story description][paragraph break]Esta es una de las aventuras presentadas a la XComp 2015. Para más información visita la web del CAAD: http://www.caad.es".

Table of Basic Help Options (continued)
title	subtable	description
"Contactar con los autores"	--	"Si tienes dificultades con [story title], contacta con nosotros a través del e-mail: philspectrum13@gmail.com o entra en los foros del portal CAAD: http://www.caad.es"
"Agradecimientos"	--	"- A la comunidad del CAAD, por su difusión del mundo de las aventuras conversacionales[line break]- A los creadores del juego de rol: Paranoia, indiscutible influencia en esta historia[line break]- A dddddd, por su paciencia y ayuda durante el desarrollo.[line break]- A edlobez, Chus, Javi, Víctor, Javi Guti y todo el improvisado equipo de betatesters.[line break]- A Valvanuz por esa maravillosa portada."
"Acuerdo de licencia"	--	"GNU General Public License[paragraph break]This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.[paragraph break]This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.[paragraph break]You should have received a copy of the GNU General Public License
	along with this program.  If not, see http://www.gnu.org/licenses/".
	
Part 2 - Escenario

Section 0 - Backdrop

La pared is backdrop. Pared is everywhere. The description is "[if laboratorio is mapped north of pasillo and player is in pasillo]En una de las paredes parece haber una entrada secreta entreabierta.[otherwise]No parece que las paredes tengan nada de interés.". Understand "paredes" as pared.
El suelo is backdrop. Suelo is everywhere. The description is "No arreglarás nada mirando al suelo.". 
El techo is backdrop. Techo is everywhere. The description is "No arreglarás nada mirando al techo.".

Understand "mira [a thing]" as examining.

Section 1 - Salón

El salon is a room. The printed name is "Salón". The description is "Un enorme sofá ocupa la mayor parte de esta habitación, que hace las veces de recibidor. Frente a el, un austero mueble soporta un televisor de tubo conectado a un reproductor de vídeo. Hay una colección de películas en VHS justo encima de ellos, sobre un estante. Al otro lado un mueble bar completa el menaje de esta sala, que conecta al oeste con la cocina y al este con un pasillo. Al norte hay una puerta.".
Salon contains a sofa, a televisor, a video, some peliculas(f) and a mueble bar.

Sofa is scenery. The printed name of sofa is "sofá". The description is "El sofá es amplio y parece cómodo.".
Instead of taking, pushing or dropping sofa:
	say "Recolocar el mobiliario no está entre tus prioridades en este momento.".
Instead of entering sofa:
	say "No hay tiempo para descansar, deberías centrarte en la misión.".
	
Televisor is scenery. The description is "A juzgar por su aspecto, parece que el televisor y el vídeo son utilizados con bastante frecuencia." Understand "television", "televisión", "tele", "tv" as televisor.
Instead of taking televisor:
	say "Por supuesto, claro. Y después el sofá y el mueble bar...".
Instead of pushing, pulling or dropping televisor:
	say "Deshacerte del televisor no implicará una reducción de la ingente cantidad de telebasura. Tu intención es buena, pero inútil.".
Instead of switching on televisor:
	say "Un programa de peleas de robots del canal cocina se sintoniza al encender el televisor. Hoy: [italic type]Turbochef 3000 vs. Sumilleitor II[roman type]. Por el bien de tu salud mental, decides apagarlo.".
Instead of switching off televisor:
	say "Ya está apagado.".

Video is scenery. The printed name of video is "vídeo". The description is "A juzgar por su aspecto, parece que el televisor y el vídeo son utilizados con relativa frecuencia.". Understand "reproductor" as video.
Instead of taking video:
	say "Tu salario neto como agente de gobierno, aunque ajustado, es suficiente. No necesitas llevarte el vídeo.".
Instead of pushing, pulling or dropping video:
	say "¿Qué tienes en contra del vídeo?".
Instead of switching on video:
	say "Pulsas el botón del play. El aparato emite un sonido y después se para. Parece atascado.".
	
Peliculas are scenery. The printed name of peliculas are "películas". The description is "La colección de VHS no deja lugar a duda del riguroso adiestramiento de estos seres: [italic type]'La Guerra de los Mundos', 'La Invasión de los Ultracuerpos', 'Plan 9 del Espacio Exterior', 'Ultimátum a la Tierra', 'Invasores de Marte'[roman type]... son solo algunos de los títulos que pueden encontrarse, todos en versión original.". Understand "vhs", "videos", "estante", "pelicula" as peliculas.
Instead of taking peliculas:
	say "Eso sería lo más parecido a llevarte el trabajo a casa.".
Instead of pushing, pulling or dropping peliculas:
	say "Vale, está claro que no es cine de autor, pero eso sería excesivo.".
	
Mueble bar is scenery. The description is "Unas botellas de [italic type]Space Tonic (tm)[roman type] son la única bebida que hay en el mueble bar.". Understand "mueble", "bar", "botella", "botellas", "space tonic", "space", "tonic", "bebida" as mueble bar.
Instead of taking or drinking mueble bar:
	say "Tu primer y único contacto con la [italic type]Space Tonic (tm)[roman type] fue en el 85, en aquella misión en la estación espacial P.A.R.S.E.R. Aquello te produjo una resaca espacio-temporal de tales magnitudes que prometiste no volver a probarla.".
Instead of pushing, pulling or dropping mueble bar:
	say "Será mejor dejarlo donde está.".
Instead of opening mueble bar:
	say "Ya está abierto.".
Instead of putting a thing on mueble bar:
	say "Las botellas de [italic type]Space Tonic (tm)[roman type] no dejan espacio a nada más.".
Instead of inserting a thing into mueble bar:
	say "Las botellas de [italic type]Space Tonic (tm)[roman type] no dejan espacio a nada más.".
	
Instead of going south when player is in salon:
	say "Negativo. El futuro del planeta depende de esta misión. Abandonar no es una opción.".
	
Section 1.1 - Puerta salon/despacho

La puerta de madera is north of salon and south of despacho. The printed name is "puerta". The description is "[if player is in salon]Una puerta de madera comunica el salón con otra estancia al norte.[otherwise]Una puerta de madera comunica el despacho con el salón.[end if][if locked] Está cerrada.". La puerta de madera is a door and scenery. It is lockable and locked. The matching key of la puerta de madera is la llave.
Instead of unlocking puerta de madera with llave:
		now puerta de madera is unlocked;
		now puerta de madera is open;
		say "[italic type]*Click*[line break][roman type]Introduces la llave de cobre en la cerradura y, con un suave giro, esta se desbloquea, permitiéndote abrir la puerta.";
		rule succeeds.
Instead of opening la puerta de madera:
	if llave is carried by player:
		try unlocking puerta de madera with llave;
	otherwise:
		say "La puerta está cerrada con llave.".
Instead of dropping, pulling, attacking or pushing puerta de madera:
	say "Con que eres un tipo duro... ¿eh?".
Instead of taking puerta de madera:
	say "Negativo. El robo de puertas está considerado una falta grave según el artículo 33.2 sección 4 del reglamento básico de operaciones.".

Section 2 - Despacho

El despacho is a room. The printed name is "Despacho". The description is "Un escritorio de corte clásico sobre una enorme alfombra de horrendo aspecto preside el centro de esta estancia. Detrás de ello una enorme estantería plagada de libros. En una de las paredes distingues una pequeña rejilla metálica. Al sur se encuentra el salón.".
Despacho contains a rejilla(f), a escritorio, a alfombra(f), a estanteria(f).

Instead of listening when player is in despacho and extraterrestre is despierto:
	say "Unos extraños ruidos parecen provenir de la rejilla.".
Instead of listening to rejilla when player is in despacho and extraterrestre is despierto:
	say "Oyes un chillido agudo, bastante molesto y estridente."

Estanteria is scenery. The printed name is "estantería". The description is "[roman type]Libros y revistas de todo tipo de temáticas agrupados con una absoluta falta de criterio. Desde [italic type]La Odisea [roman type]de Homero hasta los últimos números de [italic type]Año Cero [roman type]con el especial de abducidos en entornos rurales. Fascinante.". Understand "libros", "revista", "libro", "revista", "estante" as estanteria.
Instead of taking estanteria:
	say "Lo cierto es que no necesitas llevarte eso.".
Instead of dropping, pulling or pushing estanteria:
	say "Empujas y mueves la estantería y todos los libros uno a uno. ¿Buscabas algo?".

Rejilla is scenery. The description is "[if open]El estrecho conducto comunica con una habitación al este.[otherwise]Ves lo que parece una pequeña rejilla de ventilación en la pared.[end if][if extraterrestre is despierto] Se oyen extraños ruidos al otro lado.". Rejilla is openable, container and locked. The matching key of rejilla is el destornillador. Understand "conducto", "metalica", "metálica" as rejilla.
Instead of unlocking rejilla with destornillador for the first time:
	now rejilla is unlocked;
	now rejilla is open;
	say "Con cuidado, giras los tornillos y abres la rejilla, dejando al descubierto un pequeño conducto.";
	rule succeeds.
Instead of unlocking rejilla with destornillador:
	say "Ya está abierta.".
Instead of opening, desatornillaring or turning rejilla:
	if destornillador is carried by player:
		try unlocking rejilla with destornillador;
	otherwise:
		say "Tal vez con un destornillador.".
Instead of entering rejilla:
	if rejilla is open:
		say "Difícilmente cabrías por ahí.";
	otherwise:
		say "La rejilla está cerrada.".
Instead of closing or atornillaring rejilla when rejilla is open:
	say "¿Volver a atornillarlo? Ni pensarlo...";
	rule succeeds.
Instead of closing or atornillaring rejilla when rejilla is closed:
	if destornillador is carried by the player:
		say "Ya está atornillado.";
		rule succeeds;
	otherwise:
		say "Tal vez con un destornillador.";
		rule succeeds.
Instead of inserting vaporizador into rejilla when rejilla is closed:
	if vaporizador is activado:
		say "¿Bromeas? El vapor de la doxilamina podría no filtrarse por la rejilla con terribles consecuencias. Será mejor buscar una manera de abrirla.";
	otherwise:
		say "Quizás si estuviese cargado...".
Instead of inserting vaporizador into rejilla when rejilla is open:
	if vaporizador is activado:
		now vaporizador is desactivado;
		now vaporizador is in rejilla;
		now extraterrestre is dormido;
		say "Colocas el vaporizador en el conducto y lo pones en marcha. El humo de las pastillas de doxilamina se filtra a través del tubo. Los ruidos, que ahora distingues como extraños chillidos, crecen en intensidad al otro lado. Minutos después: el silencio.";
	otherwise:
		say "Quizás si estuviese cargado...".
Instead of switching on vaporizador when player is in despacho:
	[if rejilla is open:]
	try inserting vaporizador into rejilla.
	[otherwise:
		say "Tal vez a través de la rejilla...".]
Instead of inserting a thing into rejilla when rejilla is closed:
	say "La rejilla está cerrada.";
	rule succeeds.
Instead of inserting a thing into rejilla when rejilla is open:
	say "No necesitas poner [the noun] en el conducto.";
	rule succeeds.

Escritorio is scenery. The description is "Un escritorio de madera en tonos caoba, de aspecto un tanto kitsch aunque no parezca tener grandes signos de desgaste. Hay un pequeño cajón en su parte derecha.". Understand "mesa" as escritorio.
Instead of taking, dropping, pulling or pushing escritorio:
	say "En el fondo podría ser una antigüedad. Mejor dejarlo como está.".
El cajon is part of escritorio. The printed name of cajon is "cajón". The description is "Un pequeño cajón de madera.[if closed] Está cerrado.". It is openable and closed. Understand "cajón" as cajon.
Instead of taking cajon:
	say "No es necesario pasarse el tiempo por ahí robando cajones.".
Instead of opening cajon when agenda is in cajon:
		now cajon is open;
		say "Abres el cajón, descubriendo lo que parece una agenda en su interior.";
		rule succeeds.
		
Alfombra is scenery. The description is "Una serie de motivos florares y figuras geométricas esparcidos sobre el tapíz sin ningún orden aparente. La auténtica definición del mal gusto.".
Instead of taking alfombra:
	say "Podrías regalársela a alguien, pero no conoces a nadie a quien quieras tan poco.".
Instead of dropping, pulling or pushing alfombra:
	say "Quemarla sería mejor que eso.".
Instead of burning alfombra:
	say "Es tentador, pero aún tienes que cumplir una misión.".

Instead of examining pared when player is in despacho:
	try examining rejilla.


Section 3 - Cocina

La Cocina is west of salon. The description is "Una mesa de comedor y un par de sillas presiden el ala este de la cocina. Frente a ellos, el extractor y unos armarios bajo los que se sitúan la encimera, el fregadero y los fogones. Al fondo hay un frigorífico, con aspecto de no haber sido utilizado en mucho tiempo. Al este se encuentra el salón. Hay una entrada hacia lo que parece ser una despensa, al norte.".
Cocina contains a mesa(f), some sillas(f), a extractor, some armarios, a encimera(f), a fregadero, some fogones and a frigorifico. 

Mesa is scenery. The description is "Procedes a la inspección rutinaria de la mesa y las sillas. El análisis indica que son de madera.". Understand "comedor", "madera" as mesa. It is supporter.
Instead of taking mesa:
	say "Se que en el fondo no quieres llevarte una mesa.".
Instead of dropping, pulling or pushing mesa:
	say "Seguro que eres un gran interiorista, pero eso no salvará a la humanidad de una invasión extraterrestre.".

Sillas are scenery. The description is "Procedes a la inspección rutinaria de la mesa y las sillas. El análisis indica que son de madera.". Understand "silla" as sillas. Sillas are supporter.
Instead of taking, dropping, pulling or pushing sillas:
	say "Las sillas no representan un elemento relevante para tu informe.".
Instead of entering sillas:
	say "No hay tiempo para descansar, deberías centrarte en la misión.".

Extractor is scenery. The description is "Una filtración estuvo a punto de hacer pública la existencia de vida en Marte en el 83, nada en comparación a lo que podría encontrarse en este extractor.".
Instead of taking, dropping, pulling or pushing extractor:
	say "Aunque desde un punto de vista biológico resulte interesante, no necesitas hacer nada con el extractor.".
Instead of smelling extractor:
	say "Ni por asomo pondrías tu nariz ahí cerca.".
	
Armarios are scenery. The description is "Lo que te temías: montones de latas de comida prefabricada se acumulan por los estantes. A los tipos del espacio les encanta esa mierda.". Understand "armario", "estante", "estantes", "lata", "latas" as armarios.
Instead of opening armarios:
	try examining armarios.
Instead of taking, dropping, pulling or pushing armarios:
	say "La estoica estructura de latas se desmoronaría de faltar una sola de ellas. Eso sería el fin.".
Instead of putting a thing on armarios:
	say "¿Bromeas? no cabe nada aquí.".
Instead of inserting a thing into armarios:
	say "¿Bromeas? no cabe nada aquí.".
	
Encimera is scenery. The description is "Una superficie plana de madera plastificada. A primera vista no parece hostil.". It is supporter.
Instead of taking, dropping, pulling or pushing encimera:
	say "No recuerdas haber sido preparado para trabajar con encimeras en la academia de agentes del gobierno.".
	
Fogones are scenery. The description is "Cuatro fogones de distintos tamaños componen una cocina de gas, de aspecto un tanto precario.". Understand "cocina", "fogón", "fogon", "gas" as fogones.
Instead of taking, dropping, pulling or pushing fogones:
	say "Se te ocurren mil maneras de hacer uso de unos fogones. Ninguna de ellas útil para tu misión.".
Instead of switching on fogones:
	say "Recuerdas el taller de cocina en pareja de la terapia matrimonial de la agencia y, por un instante, la tentación de dar rienda suelta a tus habilidades culinarias se apodera de ti. Llegas a la conclusión de que no es el momento.".
Instead of switching off fogones for the first time:
	say "Tratas de apagar unos fogones apagados. Venga, inténtalo otra vez...".
Instead of switching off fogones for the second time:
	say "Ya están apagados. De verdad.".
Instead of switching off fogones:
	say "Te empeñas una vez más en apagar unos fogones apagados. En serio, piensa en ello.".

Frigorifico is scenery. The printed name of frigorifico is "frigorífico". The description is "Parece uno de esos modelos rusos de principios de siglo.[if postal is part of frigorifico] Hay una postal pegada en la puerta.". Understand "frigorífico", "nevera", "frigo" as frigorifico.
Instead of taking frigorifico:
	say "Parece ruso, pero no portátil".
Instead of dropping or pushing, pulling frigorifico:
	say "Mover el frigorífico no es una acción a valorar en el contexto de la misión.".
Instead of opening frigorifico:
	say "Si el frigorífico parece de principios de siglo, lo que alberga en su interior no podía ser menos.".
Instead of putting a thing on frigorifico:
	say "Jamás pondrías nada por lo que tuvieses aprecio ahí dentro.".
Instead of inserting a thing into frigorifico:
	say "Jamás pondrías nada por lo que tuvieses aprecio ahí dentro.".
Instead of closing frigorifico:
	say "Ya está cerrado.".
Instead of smelling frigorifico:
	say "Dejémoslo en que no huele a nuevo.".

Fregadero is scenery. The description is "[if fregadero contains something]Parece que alguien se haya dejado algo en la pila.[otherwise]Un fregadero corriente, de aluminio.". It is container. Understand "pila", "lavadero" as fregadero.
Before examining fregadero for the first time:
	now guantes are in fregadero.
Instead of taking, dropping, pulling or pushing fregadero:
	say "No parece que el fregadero tenga la más mínima intención de moverse.".

Section 4 - Despensa

La Despensa is north of cocina. The description is "En su momento este habitáculo puede haber sido una despensa, ahora recuerda más bien a uno de esos trasteros de subasta televisada. Varias cajas de cartón se amontonan entre trastos viejos y algunos productos de limpieza, todo ello esparcido por el suelo y los estantes sin ningún tipo de armonía ni ordenación lógica. Al sur puedes ver la cocina.".
Despensa contains some cajas(f), some productos and some estantes.

Las cajas are scenery. The description is "Unas cajas de cartón de embalaje. Están vacías, aunque parecen haber contenido equipos de alta tecnología en su momento.". Understand "cartón", "caja" as cajas.
Instead of taking cajas:
	say "No necesitas unas cajas de cartón en este momento.".
Instead of dropping, pulling or pushing cajas:
	say "Mover las cajas no va a ayudarte en tu misión en absoluto.".
Instead of putting a thing on cajas:
	say "Poner [the noun] ahí dentro no serviría de nada.".
Instead of inserting a thing into cajas:
	say "Poner [the noun] ahí dentro no serviría de nada.".
	
Los estantes are scenery. The description is "Entre los estantes, observas todo un abanico de cachivaches inservibles que, sencillamente, no tienes ni idea de lo que son.". Understand "trastos", "estante", "cachivaches", "baldas", "balda" as estantes.
After examining estantes for the first time:
	say "Al apoyarte para examinarlos, escuchas un pequeño ruido metálico. Parece que algo se ha caído al suelo.";
	now destornillador is in despensa.
Instead of examining suelo when destornillador is in despensa:
	say "Hay algo en el suelo, parece un destornillador.".
Instead of taking, dropping, pulling or pushing estantes:
	say "No parece que nada en los estantes tenga mayor interés.".
	
Los productos are scenery. The description is "Lejía, abrillantador, lavavajillas, limpiacristales... todo lo necesario para fabricar una bomba.". Understand "lejía", "abrillantador", "lavavajillas", "limpiacristales", "limpieza" as productos.
Instead of taking, dropping, pulling or pushing productos for the first time:
	say "Tal vez si hubieses atendido en el curso de química de la agencia...".
Instead of taking, dropping, pulling or pushing productos:
	say "Olvídalo, no vas a fabricar una bomba.".

Section 5 - Pasillo

El Pasillo is east of salon. The description is "Este estrecho pasillo conduce al resto de habitaciones de la casa. El único mobiliario de la estancia es un recibidor, que descansa sobre una de las paredes. Al sur se encuentra la entrada a la habitación. Al este el baño. [if laboratorio is mapped north of pasillo]Una puerta conduce a lo que parece un laboratorio secreto, al norte.". 
Pasillo contains a recibidor and a entrada(f).

Recibidor is scenery. The description is "Un pequeño recibidor de madera sobre el que descansa el teléfono.". It is supporter.
Instead of taking, dropping or pushing recibidor:
	say "Probablemente, mover el recibidor es tan posible como innecesario.".
	
Entrada is scenery. Entrada can be abierta or cerrada. The description is "[if cerrada]No veo eso que dices.[otherwise]La entrada al laboratorio secreto.". Entrada is cerrada. Understand "puerta" as entrada.
Instead of opening entrada:
	if entrada is cerrada:
		say "No veo eso que dices.";
	otherwise:
		if entrada is abierta and extraterrestre is despierto:
			say "Está entreabierta, pero algo te dice que es mejor así.";
		if entrada is abierta and extraterrestre is dormido:
			say "Ya está abierta.".
Instead of closing entrada:
	say "Mejor no. Podría bloquearse.".



Section 6 - Baño

El Bano is east of pasillo. The printed name is "Baño". The description is "Un plato de ducha, el inodoro, un lavabo y un espejo de baño componen esta pequeña estancia. Al oeste está el pasillo.".
Bano contains a ducha(f), a inodoro, a lavabo and a espejo.

La ducha is scenery. The description is "Una mampara de cristal abierta rodea al plato de ducha, con el cabezal fijo a la pared.". Understand "mampara", "plato", "cabezal" as ducha.
Instead of taking, opening, closing or switching on ducha:
	say "Será mejor reservar la ducha para después de la misión.".
Instead of dropping, pulling or pushing ducha:
	say "Seguro que lo que estás pensando es ingenioso, tanto como inoportuno.".
Instead of drinking ducha:
	say "¿Beber de la ducha? ¿en serio?".
Instead of putting a thing on ducha:
	say "No necesitas poner nada en la ducha.".
Instead of inserting a thing into ducha:
	say "No necesitas poner nada en la ducha.".
	
El inodoro is scenery. The description is "Es blanco, está cerrado y no estás muy seguro de querer llegar más al fondo de esto.". Understand "water", "wc" as inodoro.
Instead of taking inodoro:
	say "Llevarse el inodoro no parece una gran idea.".
Instead of opening, smelling or drinking inodoro:
	say "No quiero saber lo que estás pensando. Mejor dejémoslo estar.".
Instead of putting a thing on inodoro:
	say "No quiero saber lo que estás pensando. Mejor dejémoslo estar.".
Instead of inserting a thing into inodoro:
	say "No quiero saber lo que estás pensando. Mejor dejémoslo estar.".
Instead of closing inodoro:
	say "Ya está cerrado.".
Instead of pulling or pushing inodoro:
	say "No quiero saber lo que estás pensando. Mejor dejémoslo estar.".
	
El lavabo is scenery. The description is "Parece que el grifo está goteando.". El lavabo is supporter. Understand "grifo" as lavabo.
Instead of taking, dropping, pulling or pushing lavabo:
	say "Será mejor dejarlo ahí.".
Instead of opening, smelling or drinking lavabo for the first time:
	say "Abres el grifo y bebes un trago de agua. Afortunadamente, el sabor no te recuerda a nada extraterrestre.".
Instead of opening, smelling or drinking lavabo:
	say "No entra entre tus planes volver a exponerte a posibles peligrosas enfermedades bacterianas alienígenas. Además, ya no tienes sed.".
Instead of closing lavabo:
	say "Aprietas el grifo, pero sigue goteando.".

El espejo is scenery. 
Instead of examining espejo:
	say "Puedes ver [a random thing in the location] reflejándose en el espejo.".
Instead of taking, dropping, pulling or pushing espejo:
	say "¿Y que tal si dejamos el espejo en su sitio?".

Section 7 - Habitación

La Habitacion is south of pasillo. The printed name is "Habitación". The description is "La austeridad y el desorden presentes en la habitación encajan a la perfección con el contexto general del inmueble. Una cama deshecha y una simple cajonera. Tan sospechoso como poco reseñable. Al norte está el pasillo.".
Habitacion contains a cama(f) and a cajonera(f).

La cama is scenery. The description is "Un par de sábanas y la almohada amontonadas sobre el colchón.". La cama is supporter. Understand "sabanas", "sábanas", "sabana", "sábana", "almohada", "colchon", "colchón" as cama.
After examining la cama for the first time:
	now el disquete is on cama;
	say "Espera, hay algo entre las sábanas, parece... ¿un disquete?";
	rule succeeds. 
Instead of taking, pushing, pulling or dropping cama:
	say "La cama ya ha manifestado su posicionamiento al respecto de eso: no desea moverse.".
	
La cajonera is scenery. The description is "Un mueble de madera con cajones que parece decorado a mano.". Understand "mueble", "cajón", "cajon", "madera", "cajones" as cajonera.
Instead of opening cajonera:
	say "Registras los cajones en busca de algo de utilidad. Sábanas y algo de ropa, nada que resulte necesario en tu misión.".
Instead of taking, pushing, pulling or dropping cajonera:
	say "Tras varios esfuerzos para mover la cajonera, terminas por dejarla donde está.".
	
	[seguir por aqui]

Section 8 - Laboratorio

El Laboratorio is a room. The description is "Tal y como describían los informes: la base de operaciones extraterrestre se encuentra frente a tus ojos. El gas parece haber dejado noqueado al ser, que ahora duerme como un cachorro. Puedes ver un computador y un teleportador aquí. Al sur está el pasillo. El tiempo corre, es el momento de una entrega especial: esta noche esos malditos bichos cenarán plutonio.". Laboratorio contains a computador and a teleportador.

Instead of going to el laboratorio when extraterrestre is despierto for the first time:
	say "Te dispones a cruzar la puerta...[paragraph break]";
	wait for any key;
	say "...de pronto, te percatas de la existencia de un extraño ser enjaulado al otro lado. Sujetando con sus manos los barrotes, te observa con los ojos inyectados en sangre, mientras emite un estridente sonido que te obliga a tapar tus oídos con fuerza...[paragraph break][italic type]-CHSSSSSZZZZZZXXXX@@####???!!!![paragraph break][roman type]A toda prisa, regresas al pasillo.".

Instead of going to el laboratorio when extraterrestre is despierto:
	say "A pesar de estar enjaulado, aquel bicho continúa acechando. No parece buena idea provocarlo...".
	
El teleportador is scenery. Teleportador can be encendido or apagado. El teleportador is apagado. The description is "Un enorme círculo metálico en el suelo, conectado al computador mediante unos cables conforma el teleportador. [if apagado]Una luz roja en su borde indica que está apagado.[otherwise]La luz verde que lo bordea indica ahora que está encendido.".
Instead of switching on or switching off teleportador:
	say "Prueba desde el computador.".
Instead of putting a thing on teleportador:
	say "No necesitas teleportar [the noun].".
Instead of putting bomba nuclear on teleportador:
	if teleportador is encendido:
		now bomba nuclear is off-stage;
		clear the screen;
		say "Con la precisión que caracteriza a un agente del gobierno manejando un dispositivo nuclear, activas la bomba y la colocas sobre el teleportador. El objeto no tarda en descomponerse en partículas y desaparecer bajo un haz de luz que emerge desde la peana.[paragraph break]";
		wait for any key;
		say "Envías una señal a la Agencia desde tu localizador mientras recoges tu maletín y abandonas el inmueble. La entrada a la casa no tarda en llenarse de agentes de la división bacteriológica del SAB que acordonan la zona y proceden al protocolo de cuarentena.[paragraph break]";
		wait for any key;
		say "Una luz desde el cielo nocturno se refleja en tus gafas de sol. Probablemente una explosión nuclear...";
		wait for any key;
		end the story saying "MISIÓN CUMPLIDA: ENHORABUENA AGENTE KXT-1450";
	otherwise:
		say "Primero deberías encender el teleportador.".
Instead of switching on bomba nuclear:
	if player is in laboratorio:
		try putting bomba nuclear on teleportador;
	otherwise:
		say "El informe de misión era claro al respecto: encontrar la base de operaciones alienígena, establecer conexión con su centro de mando y enviar la bomba. Activarla arbitrariamente en un inmueble residencial no parece lo más apropiado.".
Instead of taking, dropping, pulling or pushing teleportador:
	say "No entra entre tus funciones interactuar con tecnología alienígena más allá de tu misión. Mejor dejar eso para el STA.".
Instead of entering teleportador:
	say "En las películas los héroes se teleportan a las naves alienígenas y la emprenden a cañonazos con los seres galácticos. Pero esto es la vida real amigo, concéntrate, el planeta entero depende de ti...".
	
El computador is scenery. Computador can be activado or desactivado. Computador is desactivado. The description is "[if desactivado][roman type]Desde aquí parece controlarse el teleportador. Bajo la pantalla hay una ranura para disquetes. El terminal muestra el siguiente mensaje: [paragraph break][italic type]Introduzca disquete de acceso.[roman type][otherwise]El terminal muestra el siguiente mensaje: ". Understand "ordenador", "pantalla", "ranura", "terminal" as computador. 
Instead of putting a thing on computador:
	say "No puedes poner [the noun] en la ranura.".
Instead of putting disquete on computador:
	now disquete is off-stage;
	now computador is activado;
	say "La ranura se cierra tragándose el disquete, mientras el terminal comienza a desplegar un nuevo mensaje.".
After examining computador:
	if teleportador is encendido:
		say "[paragraph break][italic type]** PROTOCOLO DE TELEPORTACIÓN ACTIVADO **[roman type]";
	otherwise if computador is activado and teleportador is apagado:
		say "Pulsa (0) para salir";
		now the command prompt is ">Introduzca coordenadas de activación del teleportador: ";
		rule succeeds.
After reading a command when the command prompt is ">Introduzca coordenadas de activación del teleportador: ":
	if the player's command exactly matches the text "83Z57B" for the first time or the player's command exactly matches the text "83z57b" for the first time:
		now teleportador is encendido;
		now the command prompt is ">";
		say "[paragraph break][italic type]** PROTOCOLO DE TELEPORTACIÓN ACTIVADO **[roman type][paragraph break]El teleportador comienza a emitir una luz verde, que ves ahora reflejada en la pantalla.";
	otherwise if the player's command exactly matches the text "0":
		say "Apartas la vista de la pantalla.";
		now the command prompt is ">";
	otherwise:
		now the command prompt is ">";
		say "[paragraph break][italic type]** COORDENADAS INCORRECTAS **[roman type]";
	reject the player's command. [seguir por aquí, aun hay mucho que hacer]
	
Instead of inserting disquete into computador:
	try putting disquete on computador.
Instead of inserting a thing into computador:
	try putting on computador.

Part 3 - Objetos

Section 1 - Maletín

El maletin is in salon. The printed name of maletin is "maletín". The description is "[if open]La herramienta estándar del agente del gobierno estándar. Un maletín. Negro. Abierto.[otherwise]La herramienta estándar del agente del gobierno estándar. Un maletín. Negro. Cerrado.". Understand "maleta" as maletin. Maletin is container, openable and closed.

Rule for printing room description details of maletin:
	if maletin is open, say " abierto";
	omit contents in listing.

Section 1.1 - Bomba nuclear

La bomba nuclear is in maletin. The description is "Un pequeño dispositivo nuclear portatil con capacidad de destrucción masiva, listo para ser activado.". Understand "bomba", "nuclear", "portatil" and "dispositivo" as bomba nuclear.

Section 1.2 - Vaporizador

El vaporizador is in maletin. The description is "Tu querido vaporizador. Si hay algo que has aprendido en todos estos años en la agencia es a no olvidar nunca el vaporizador. Un vaporizador nunca te abandonaría.[if activado] Una luz verde indica carga activa.". Vaporizador is container. Vaporizador can be activado or desactivado. Vaporizador is desactivado.
Instead of inserting a thing into vaporizador:
	say "No necesitas vaporizar [the noun].".
Instead of inserting bote into vaporizador:
	now bote is off-stage;
	now vaporizador is activado;
	say "Pones las pastillas en el vaporizador y este emite el típico ruido de procesado. Al poco una luz verde se enciende, indicando que la carga está activa.".
Instead of switching on vaporizador:
	if vaporizador is activado:
		say "Será mejor reservar la carga para algo más efectivo.";
	otherwise:
		say "El vaporizador necesita una recarga.".

Section 2 - Llave

Una llave is a thing. The printed name is "llave de cobre". The description is "Una pequeña llave de cobre.". 

Section 3 - Guantes

Los guantes are a thing. The printed name is "guantes de cocina". The description is "Unos guantes de cocina.". Guantes are wearable.

Section 4 - Postal

La postal is part of frigorifico. The description is "[if postal is part of frigorifico][roman type]El llamativo frente de la postal capta tu atención: dos alienígenas con camisas hawaianas sobre un fondo paradisíaco saludan bajo un rótulo que reza [italic type]'Greetings from Mars'.[otherwise][roman type]Dos alienígenas con camisas hawaianas sobre un fondo paradisíaco saludan bajo un rótulo que reza [italic type]'Greetings from Mars'[roman type].[paragraph break]En el reverso se distingue algo escrito a mano: [italic type]'83Z57B'.".

Instead of taking postal:
	move postal to player;
	say "Cogida.".
	
Section 5 - Telefono

El telefono is on recibidor. The printed name is "teléfono". The description is "Se trata de un modelo estándar de teléfono de disco, de un llamativo color rojo.". Understand "tfno" as telefono.

Instead of llamaring telefono:
	say "Coges el teléfono y te dispones a hacer una llamada.[paragraph break]";
	say "Pulsa (0) para colgar";
	now the command prompt is ">Introduce el número a marcar: ";
	rule succeeds.
After reading a command when the command prompt is ">Introduce el número a marcar: ":
	if the player's command exactly matches the regular expression "\d\d\d-\d\d\d" or the player's command exactly matches the regular expression "\d\d\d\d\d\d":
		if the player's command exactly matches the text "314-159" for the first time or the player's command exactly matches the text "314159" for the first time:
			say "Al girar el disco por última vez, escuchas un [italic type]*Click* [roman type]en el teléfono. Acto seguido, un mecanismo interno parece activarse, descubriendo una entrada hasta ahora oculta en la pared norte del pasillo.";
			now laboratorio is mapped north of pasillo;
			now pasillo is mapped south of laboratorio;
			now entrada is abierta;
			now the command prompt is ">";
		otherwise if the player's command matches "314-159" or the player's command matches "314159":
			say "No parece que [the player's command] sea un número de teléfono.";
			now the command prompt is ">";
		otherwise if the player's command matches "471-322" or the player's command matches "471322":
			say "[roman type]Llamas al [the player's command]... [paragraph break]Una extraña aunque familiar voz te responde en un idioma que identificas como francés. No entiendes a que se refiere, pero repite una y otra vez:[paragraph break][italic type]-Le chose grise, le chose grise... LE CHOSE GRISE!!![paragraph break][roman type]Cuelgas el teléfono.";
			now the command prompt is ">";
		otherwise if the player's command matches "616-431" for the first time or the player's command matches "616431" for the first time:
			say "[roman type]Llamas al [the player's command]...[paragraph break]Una vocecilla de universitario responde al otro lado:[paragraph break][italic type]-Pizza Cosmic ¿qué desea?[paragraph break][roman type]Encargas cuatro Marte-Pizzas tamaño familiar con extra de salsa Cosmic, dos granizados Vía Láctea y una ración de Plutonitos que te ofrecen en promoción. Das los datos de tu superior, confirmas el pedido y cuelgas el teléfono. Alguien va a cenar caro esta noche...";
			now the command prompt is ">";
		otherwise if the player's command matches "616-431" or the player's command matches "616431":
			say "[roman type]Llamas al [the player's command]...[paragraph break]Una vocecilla de universitario responde al otro lado:[paragraph break][italic type]-Pizza Cosmic ¿qué desea?[paragraph break][roman type]Aunque estuvo bien, decides que no sería buena idea repetir la broma de la pizza y cuelgas el teléfono.";
			now the command prompt is ">";
		otherwise if the player's command matches "829-331" or the player's command matches "829331":
			say "[roman type]Llamas al [the player's command]...[paragraph break]Una voz con aire sugerente responde al otro lado. La agencia no te preparó para reaccionar ante ciertos estímulos.[paragraph break][roman type]Cuelgas el teléfono.";
			now the command prompt is ">";
		otherwise if the player's command matches "722-518" or the player's command matches "722518":
			say "[roman type]Llamas al [the player's command]...[paragraph break]Una voz que denota omnipresencia responde al otro lado. Habla de bucles y estructuras condicionales, localidades, objetos y funciones. Por un momento, sientes como si tu interlocutor supiese todo sobre ti y entras en conexión total con el universo. Decides cortar pronto con toda esta mierda new age, antes de que sea demasiado tarde.[paragraph break][roman type]Cuelgas el teléfono.";
			now the command prompt is ">";
		otherwise if a random chance of 1 in 6 succeeds:
			say "Llamas al [the player's command]... una voz desconocida saluda al otro lado.[paragraph break]Cuelgas el teléfono.";
			now the command prompt is ">";
		otherwise if a random chance of 1 in 4 succeeds:
			say "Llamas al [the player's command]... parece estar comunicando.[paragraph break]Cuelgas el teléfono.";
			now the command prompt is ">";
		otherwise:
			say "Llamas al [the player's command]... pero no hay respuesta.[paragraph break]Cuelgas el teléfono.";
			now the command prompt is ">";
	otherwise if the player's command exactly matches the text "0":
		say "Cuelgas el teléfono.";
		now the command prompt is ">";
	otherwise:
		say "No parece que [the player's command] sea un número de teléfono.";
		now the command prompt is ">";
	reject the player's command.
	
Instead of taking telefono:
	try llamaring telefono.
	
Instead of throwing, pulling or pushing telefono:
	say "Cargar tus frustraciones con el teléfono no va a solucionar las cosas.".
	
Section 6 - Destornillador

El destornillador is a thing. The description is "[roman type]Un destornillador rojo, de la marca [italic type]BetaTester (tm)[roman type], un clásico entre los manitas espaciales.".

Section 7 - Agenda

La agenda is in cajon. The description is "[roman type]Una agenda de teléfonos. Tiene anotados los siguientes números:[paragraph break][italic type]Pizza Cosmic: 616-431[line break]Wendy's Club: 829-331[line break]Phil Spectrum: 722-518[line break]Le Cabre: 471-322[line break]Laboratorio Secreto: 314-159". Understand "telefonos" as agenda.

Section 8 - Bote de pastillas

El bote is on lavabo. The printed name of bote is "bote de pastillas". The description is "Un pequeño bote de pastillas. En la etiqueta puede leerse: doxilamina.". Understand "pastillas", "bote de pastillas", "doxilamina" as bote.
Instead of opening, eating bote:
	say "No es un buen momento para tomar doxilamina.".
	
Section 9 - Disquete

El disquete is a thing. The description is "[roman type]Un disquete de 5 pulgadas, tiene escrito: [italic type]'MAIN' [roman type]a rotulador en la etiqueta".


	

Part 4 - Reparto

Section 1 - Jugador

El agente is a man in el salon. The printed name of agente is "KXT-1450". The description is "Tu nombre en clave es KXT-1450. Te fue asignado en homenaje a un contestador automático. Has puesto todo tu empeño en no parecer un agente del gobierno aunque... pareces un agente del gobierno.". The player is agente.

Section 2 - Sujeto

El sujeto is a man in el salon.  The printed name of el sujeto is "sujeto". The description is "Para tratarse de una forma de vida extraterrestre, el aspecto del sujeto parece completamente humano.". Understand "hombre", "humano", "cuerpo", "extraterrestre", "inconsciente", "alien" and "tendido" as sujeto. 

Instead of taking, kissing, pushing, tasting or touching sujeto:
	say "¡¿Estás loco?! El contacto físico directo con un ente del tipo EXT-224 está tipificado como potencialmente peligroso según el artículo 92.7 sección 3 del reglamento básico de operaciones.".
Instead of touching, pushing or taking sujeto when player have guantes:
	try searching sujeto.
Instead of attacking sujeto:
	say "Negativo. La eliminación de una forma de vida apta para experimentación sin el consentimiento expreso del SCI mediante una orden B-52 modelo A7 debidamente compulsada por el BEC está terminántemente prohibida.".
Instead of smelling sujeto:
	say "El sujeto desprende un olor decidídamente alienígena. Como a pollo.".

Instead of telling someone about something, try asking the noun about it. Instead of answering the noun that something, try asking the noun about it.

After asking sujeto about something when sujeto is inconsciente:
	say "Tratas de hablar con un sujeto inconsciente, y obtienes la respuesta de un sujeto inconsciente.".

Check searching sujeto:
	if player have guantes and llave is off-stage:
		now llave is carried by player;
		now player is wearing guantes;
		say "Con los guantes puestos, registras meticulosamente al sujeto, encontrando una pequeña llave en uno de sus bolsillos que decides guardarte.";
		rule succeeds;
	if player have guantes:
		now player is wearing guantes;
		say "Con los guantes puestos, registras meticulosamente al sujeto, pero no encuentras nada interesante.";
		rule succeeds;
	otherwise:
		try taking sujeto;
		rule succeeds.

El sujeto can be inconsciente or consciente. El sujeto is inconsciente.

Rule for printing room description details of el sujeto:
	if el sujeto is inconsciente, say " inconsciente, tendido en el suelo";
	
Section 3 - Extraterrestre

El extraterrestre is a person in laboratorio. The printed name of el extraterrestre is "ser extraterrestre". The description is "Sin duda, lo que hay en la jaula es un EXT-24B7, probablemente destinado a la experimentación genética. Será mejor no despertarlo.". Understand "ser", "bicho", "marciano", "EXT-24B7", "jaula", "alien" as extraterrestre.

El extraterrestre can be despierto or dormido. El extraterrestre is despierto.

Rule for printing room description details of el extraterrestre:
	if el extraterrestre is dormido, say " que parece dormido".
	
Instead of taking, kissing, pushing, tasting or touching extraterrestre:
	say "Cualquier movimiento extraño alrededor de la jaula podría despertar a esa criatura. Mejor no tentar a la suerte.".
Instead of attacking extraterrestre:
	say "Negativo. La eliminación de una forma de vida apta para experimentación sin el consentimiento expreso del SCI mediante una orden B-52 modelo A7 debidamente compulsada por el BEC está terminántemente prohibida.".
Instead of smelling extraterrestre:
	say "Eso es completamente gratuito e innecesario. Pero si, también huele a pollo.".

After asking extraterrestre about something:
	say "Será mejor mantenerse en silencio y no provocar a ese bicho.".

Part 6 - Vocabulario

Section 1 - Direcciones
	
Understand "norte" as north.
Understand "oeste" as west.
Understand "sur" as south.
Understand "este" as east.

Section 2 - Contenedores y objetos vestibles

Understand "pon [a wearable thing]" as wearing.
Understand "pon [a wearable thing] en [a container]" as inserting it into.
Understand "pon [a wearable thing] dentro de [a container]" as inserting it into.

Section 3 - Verbos

Section 3.1 - Llamar

Llamaring is an action applying to one thing.
Understand "llama [a thing]" as llamaring.
Understand "llama en [a thing]" as llamaring.
Understand "marca [a thing]" as llamaring.
Understand "marca en [a thing]" as llamaring.
Understand "descolgar [a thing]" as llamaring.
Report llamaring:
	say "No puedes marcar nada en [the noun].".
	
Section 3.2 - Encender
	
Understand "enciende [a thing]" as switching on.
Understand "encender [a thing]" as switching on.

Section 3.3 - Atornillar

Atornillaring is an action applying to one thing.
[Understand "atornilla [rejilla]" as closing.]
Understand "atornilla [a thing]" as atornillaring.
Report atornillaring:
	if destornillador is carried by player:
		say "No necesitas atornillar [the noun].";
	otherwise:
		say "Dificilmente sin un destornillador.".

Section 3.4 - Desatornillar

Desatornillaring is an action applying to one thing.
Understand "desatornilla [a thing]" as desatornillaring.
Instead of desatornillaring destornillador:
	say "Desatornillar un destornillador parece desternillante.";
	rule succeeds.
Report desatornillaring:
	if destornillador is carried by player:
		say "No necesitas desatornillar [the noun].";
	otherwise:
		say "Dificilmente sin un destornillador.".
		
Section 3.5 - Activar

Understand "activa [something]" as switching on.

Section 3.6 - Mear

Mearing is an action applying to nothing.
Understand "mea" as mearing.
Understand "hacer pis", "haz pis" as mearing.
Report mearing:
	say "Una flota de platillos volantes está a punto de invadir el planeta ¿de verdad te parece un buen momento para ponerse a mear?".
	
Section 3.7 - Disparar

Dispararing is an action applying to one thing.
Understand "dispara [something]" as dispararing.
Report dispararing:
	say "No parece que [the noun] pueda dispararse.".
Understand "dispara [vaporizador]" as switching on.

Section 3.8 - Vaporizar

Vaporizaring is an action applying to one thing.
Understand "vaporiza [something]" as vaporizaring.
Instead of vaporizaring rejilla:
	if vaporizador is carried by player:
		try inserting vaporizador into rejilla;
	otherwise:
		say "No puedes vaporizar nada sin tu vaporizador.";
		rule succeeds.
Report vaporizaring:
	if vaporizador is carried by player:
		try switching on vaporizador;
	otherwise:
		say "No puedes vaporizar nada sin tu vaporizador.".
		
Section 3.9 - Introducir

Understand "introduce [a thing] en [something]" as inserting it into.
Understand "introducir [a thing] en [something]" as inserting it into.