!
! Teletipo v1.0 biplataforma
!
! Visualizacin de mensajes carcter a carcter
!
! Modificacin (y en cierta medida, simplificacin) del mdulo Cortos
! v2.0 de Mel Hython.
!
! Para documentacion y ejemplo de uso ver cortodem.inf
!

! Las dos lineas siguientes son para que esto siga funcionando con el
! antiguo compilador inform 6.15, que no define la constante
! TARGET_ZCODE.
#ifndef WORDSIZE;
Constant WORDSIZE = 2;
Constant TARGET_ZCODE;
#endif;

!=========================================================
! Variables y funciones auxiliares
!=========================================================

Array TTStringAux -> 1000;

!=========================================================
! FUNCIONES de inters para el usuario
!=========================================================


!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Versin de PrintPausa y Erase_Window para la mquina Z 
!
#ifdef TARGET_ZCODE;
! Funcion "tonta" necesaria para una lectura de teclado temporizada
[ TTCortos_Volver;
    rtrue;
];

! PrintPausa
!
! La siguiente funcin imprime "msg" y despues espera
! "delay" decimas de segundo
[ TTPrintCharPausa msg delay k;
    if (msg ~= 0) print (char) msg;
    if (delay == 0)
    	@read_char 1 0 0 k;
    else
	@read_char 1 delay TTCortos_Volver k;
    return k;
];

! Erase_Window
!
! Borrar la pantalla
[ TTErase_Window;
    @erase_window -1;
];
#ifnot;

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Versin  de PrintPausa y Erase_Window para la mquina Glulx
!
! PrintPausa
!
! La siguiente funcin imprime "msg" y despues espera
! "delay" decimas de segundo
[ TTPrintCharPausa s delay;
    if (s) print (char) s;
    ! print "^[Esperando ", delay, " dcimas de segundo]^";
    glk($00D2, gg_mainwin); ! glk_request_char_event(gg_mainwin);
    glk($00D6, delay * 100); ! request_timer_events
    while(1) 
    {
	glk($00C0, gg_arguments); ! glk_select(gg_arguments);
	if ((gg_arguments-->0) == 2) break; ! 2=evType_CharInput
	if ((gg_arguments-->0) == 1) ! evType_Timer
	{
	    	glk($00D3, gg_mainwin); ! cancel_char_event
    	    	glk($00D6, 0); ! request_timer_events (cancelados)
!	    	print "[Timeout]^";
	    	return 0;
	}
    }
    glk($00D6, 0); ! request_timer_events (cancelados)
    return gg_arguments-->2;
];

! Erase_Window
! Borra la pantalla y cierra la ventana de citas (boxes)
[ TTErase_Window;
    if (gg_quotewin) ! Cerrar la ventana de boxes
    {
    	glk($0024, gg_quotewin, 0); ! close_window
    	gg_quotewin = 0;
    }
    glk($002A, gg_mainwin);  ! window_clear
    if (gg_statuswin) glk($002A, gg_statuswin); ! window_clear
];
#endif;
!
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


[ TTPrintPausa msg delay
    j d t;
    msg.print_to_array(TTStringAux);
    for (j = WORDSIZE : j <= TTStringAux-->0 : j++) 
    {
	if (delay == -1)
	    d = random(1, 2, 3);
	t = TTPrintCharPausa(TTStringAux->j, d);
	if (t == 'q' or 'Q') 
	{
	    for (j++ : j <= TTStringAux-->0 : j++)
		print (char) TTStringAux->j;
	    print_ret " ";
	}
    }
    if (t == 'q' or 'Q') print_ret " ";
];

!=======================================================
! CLASE Teletipo
!=======================================================

Class 	Teletipo
 with  	proyeccion [i j t;
	    if (~~i) 
	    {
		TTErase_Window();
		j = 0->33; if (j == 0) j = 80; j = (j - 50) / 2;
    		spaces(j);
		print "[ Mantener tecla pulsada = Ms deprisa | 'Q' =
		    Saltar ]^^";
	    }
    	    if (self provides descripcion) {
	    	for (i = 0 : i < (self.#descripcion) / WORDSIZE : i++) {
		    if ((self.&descripcion)-->i ofclass string) 
			t = TTPrintPausa((self.&descripcion)-->i,
					 self.delay);
		    else if ((self.&descripcion)-->i ofclass routine)
		    {
		    	indirect((self.&descripcion)-->i);
			t = TTPrintPausa(0, self.delay);
		    }
		    else jump error; 
	    	}
		return;
	    }
	    .error;
	    
	    #ifdef DEBUG;
	    print "Error: Teletipo sin descripcin.^";
	    #endif;
	],
	delay -1,
 has 	propio;


