; Standard macros for Frolg. Public domain.
; version 1.2

MAKE_2OP -1 AS EQUAL?
MAKE_2OP -2 AS LESS?
MAKE_2OP -3 AS GRTR?
MAKE_2OP -4 AS DLESS?
MAKE_2OP -5 AS IGRTR?
MAKE_2OP -6 AS IN?
MAKE_2OP -7 AS BTST
MAKE_2OP 8 AS BOR
MAKE_2OP 9 AS BAND
MAKE_2OP -10 AS FSET?
MAKE_2OP 11 AS FSET
MAKE_2OP 12 AS FCLEAR
MAKE_2OP 13 AS SET
MAKE_2OP 14 AS MOVE
MAKE_2OP 15 AS GET
MAKE_2OP 16 AS GETB
MAKE_2OP 17 AS GETP
MAKE_2OP 18 AS GETPT
MAKE_2OP 19 AS NEXTP
MAKE_2OP 20 AS ADD
MAKE_2OP 21 AS SUB
MAKE_2OP 22 AS MUL
MAKE_2OP 23 AS DIV
MAKE_2OP 24 AS MOD
MAKE_2OP 25 AS CALL2
MAKE_2OP 26 AS ICALL2
MAKE_2OP 27 AS COLOR
MAKE_2OP 28 AS THROW
MAKE_2OP 29 AS BXOR ;(version 9)
MAKE_1OP -128 AS ZERO?
MAKE_1OP -129 AS NEXT?
MAKE_1OP -130 AS FIRST?
MAKE_1OP 131 AS LOC
MAKE_1OP 132 AS PTSIZE
MAKE_1OP 133 AS INC
MAKE_1OP 134 AS DEC
MAKE_1OP 135 AS PRINTB
MAKE_1OP 136 AS CALL1
MAKE_1OP 137 AS REMOVE
MAKE_1OP 138 AS PRINTD
MAKE_1OP 139 AS RETURN
MAKE_1OP 141 AS PRINT
MAKE_1OP 142 AS VALUE
MAKE_1OP 143 AS ICALL1
MAKE_0OP 176 AS RTRUE
MAKE_0OP 177 AS RFALSE
MAKE_0OP 178 AS PRINTI
MAKE_0OP 179 AS PRINTR
MAKE_0OP 180 AS NOOP
MAKE_0OP 183 AS RESTART
MAKE_0OP 184 AS RSTACK
MAKE_0OP 185 AS DISCARD
MAKE_0OP 185 AS CATCH
MAKE_0OP 186 AS QUIT
MAKE_0OP 187 AS CRLF
MAKE_0OP 188 AS USL
MAKE_0OP -189 AS VERIFY
MAKE_0OP -191 AS ORIGINAL?
MAKE_VAR 224 AS CALL_VS
MAKE_VAR 224 AS GETX ;(version 9)
MAKE_VAR 225 AS PUT
MAKE_VAR 226 AS PUTB
MAKE_VAR 227 AS PUTP
MAKE_VAR 228 AS READ
MAKE_VAR 229 AS PRINTC
MAKE_VAR 230 AS PRINTN
MAKE_VAR 231 AS RANDOM
MAKE_VAR 232 AS PUSH
MAKE_VAR 233 AS PULL
MAKE_VAR 234 AS SPLIT
MAKE_VAR 235 AS SCREEN
MAKE_VAR 236 AS CALL_VS2
MAKE_VAR 236 AS XCALL
MAKE_VAR 237 AS CLEAR
MAKE_VAR 238 AS ERASE
MAKE_VAR 239 AS CURSET
MAKE_VAR 240 AS CURGET
MAKE_VAR 241 AS HLIGHT
MAKE_VAR 242 AS BUFOUT
MAKE_VAR 243 AS DIROUT
MAKE_VAR 244 AS DIRIN
MAKE_VAR 245 AS SOUND
MAKE_VAR 246 AS INPUT
MAKE_VAR -247 AS INTBL?
MAKE_VAR 249 AS CALL_VN
MAKE_VAR 249 AS PUTX ;(version 9)
MAKE_VAR 250 AS CALL_VN2
MAKE_VAR 250 AS IXCALL
MAKE_VAR 251 AS LEX
MAKE_VAR 252 AS ZWSTR
MAKE_VAR 253 AS COPYT
MAKE_VAR 254 AS PRINTT
MAKE_VAR -255 AS ASSIGNED?
MAKE_EXT 2 AS SHIFT
MAKE_EXT 3 AS ASHIFT
MAKE_EXT 4 AS FONT
MAKE_EXT 5 AS DISPLAY
MAKE_EXT -6 AS PICINF
MAKE_EXT 7 AS DCLEAR
MAKE_EXT 8 AS MARGIN
MAKE_EXT 9 AS ISAVE
MAKE_EXT 10 AS IRESTORE
MAKE_EXT 11 AS CALLB ;(version 9)
MAKE_EXT 12 AS REF ;(version 9)
MAKE_EXT 13 AS GETV ;(version 9)
MAKE_EXT 14 AS PUTV ;(version 9)
MAKE_EXT 15 AS XGETPB ;(version 9)
MAKE_EXT 16 AS WINPOS
MAKE_EXT 17 AS WINSIZE
MAKE_EXT 18 AS WINATTR
MAKE_EXT 19 AS WINGET
MAKE_EXT 20 AS SCROLL
MAKE_EXT 21 AS POP_STACK
MAKE_EXT 22 AS MOUSE-INFO
MAKE_EXT 23 AS MOUSE-LIMIT
MAKE_EXT -24 AS PUSH_STACK
MAKE_EXT -24 AS XPUSH
MAKE_EXT 25 AS WINPUT
MAKE_EXT 26 AS PRINTF
MAKE_EXT -27 AS MENU
MAKE_EXT 28 AS PICSET
MAKE_EXT 29 AS XGETP ;(version 9)

MACRO VER@
  MRETURN 0 C@
ENDMAC

MACRO USING_OFFSETS
  MRETURN VER@ 6 = VER@ 7 = VER@ 9 = VER@ 10 = OR_ OR_ OR_
ENDMAC

MACRO HERE_EX
  IF VER@ 10 =
    IF HERE 3 AND_
      DB 0
    ENDIF
    IF HERE 3 AND_
      DB 0
    ENDIF
    IF HERE 3 AND_
      DB 0
    ENDIF
    MRETURN HERE 2 RSH
  ELSE
    IF VER@ 9 =
      IF HERE 1 AND_
        DB 0
      ENDIF
      MRETURN HERE 1 RSH
    ELSE
      MRETURN HERE
    ENDIF
  ENDIF
ENDMAC

MACRO @_EX
  IF VER@ 10 =
    MRETURN @ 2 LSH
  ELSE
    IF VER@ 9 =
      MRETURN @ 1 LSH
    ELSE
      MRETURN @
    ENDIF
  ENDIF
ENDMAC

MACRO VERSION
  CALC ARGS 0 C!
ENDMAC

MACRO BCOM
  IF VER@ 5 <
    1OP 143 ARGS
  ELSE
    VAR 248 ARGS
  ENDIF
ENDMAC

MACRO JUMP
  DB $8C
  DW ARGS HERE -
ENDMAC

MACRO SAVE
  IF VER@ 5 < VER@ 8 > OR_ ARGC 3 < AND_
    0OP 181 ARGS
  ELSE
    EXT 0 ARGS
  ENDIF
ENDMAC

MACRO RESTORE
  IF VER@ 5 < VER@ 8 > OR_ ARGC 3 < AND_
    0OP 182 ARGS
  ELSE
    EXT 1 ARGS
  ENDIF
ENDMAC

MACRO FSTACK
  IF VER@ 6 =
    POP_STACK ARGS
  ELSE
    DISCARD ARGS
  ENDIF
ENDMAC

MACRO POP
  IF ARGC
    PULL ARGS
  ELSE
    DISCARD
  ENDIF
ENDMAC

MACRO CALL
  IF VER@ 8 >
    CALL2 ARGS
  ELSE
    CALL_VS ARGS
  ENDIF
ENDMAC

MACRO ICALL
  IF VER@ 8 >
    ICALL2 ARGS
  ELSE
    CALL_VN ARGS
  ENDIF
ENDMAC

MACRO PACK_SHIFT
  IF VER@ 4 <
    MRETURN 1
  ENDIF
  IF VER@ 8 <
    MRETURN 2
  ENDIF
  IF VER@ 10 <
    MRETURN 3
  ENDIF
  MRETURN 4
ENDMAC

MACRO RPACK
  IF USING_OFFSETS
    CALC 1 EXP@ $28 @ VER@ 7 > 1+ LSH - 1 EXP!
  ENDIF
  MRETURN PACK_SHIFT RSH
ENDMAC

MACRO SPACK
  IF USING_OFFSETS
    CALC 1 EXP@ $2A @ VER@ 7 > 1+ LSH - 1 EXP!
  ENDIF
  MRETURN PACK_SHIFT RSH
ENDMAC

MACRO ROUTINE
  ALIGNPACKED
  DB ARGC
  IF VER@ 5 <
    DW ARGS
  ENDIF
ENDMAC

MACRO STRING
  ALIGNPACKED
  DW ARGS
ENDMAC

MACRO BEGIN_ROUTINES
  IF USING_OFFSETS
    IF VER@ 10 =
      CALC HERE 4 RSH 1- $28 !
    ELSE
      CALC HERE 3 RSH 1- $28 !
    ENDIF
  ENDIF
ENDMAC

MACRO BEGIN_STRINGS
  IF USING_OFFSETS
    IF VER@ 10 =
      CALC HERE 4 RSH $2A !
    ELSE
      CALC HERE 3 RSH $2A !
    ENDIF
  ENDIF
ENDMAC

MACRO FLAG+
  CALC 1 $10 @ ARGS LSH OR_ $10 !
ENDMAC

MACRO TERMINATORS
  CALC HERE_EX $2E !
  DB ARGS 0
ENDMAC

MACRO START
  IF VER@ 6 =
    ALIGNPACKED
    CALC HERE RPACK 6 !
    DB 0
  ELSE
    CALC HERE_EX 6 !
  ENDIF
ENDMAC

MACRO ABBREVIATIONS
  CALC HERE_EX $18 !
  DW ARGS
ENDMAC

MACRO LENGTH
  DB ARGC
ENDMAC

MACRO GLOBAL
  CALC HERE_EX $0C !
  :_GSTART IS HERE
ENDMAC

MACRO VARIABLE
  IS HERE :_GSTART - 1 RSH 16 +
  DW ARGS
ENDMAC

MACRO STATIC
  CALC HERE_EX $0E !
ENDMAC

MACRO HIGH
  CALC HERE_EX $04 !
ENDMAC

MACRO SEPARATORS
  CALC HERE_EX $08 !
  DB ARGC ARGS
  :_DICT_SIZE DB 0
  :_DICT_COUNT DW 0
ENDMAC

MACRO DICT
  CALC :_DICT_COUNT @ 1+ :_DICT_COUNT !
  DW ARGS
  CALC ARGC :_DICT_SIZE C!
ENDMAC

; Compiler info: 'Fr' and major and minor version in binary.
CALC 'F' $3C C! 'r' $3D C! 1 $3E C! 2 $3F C!

ORG 64
