/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.encoding;

import org.zmpp.base.MemoryAccess;
import org.zmpp.encoding.AlphabetElement;
import org.zmpp.encoding.AlphabetTable;
import org.zmpp.encoding.ZCharTranslator;

public class ZCharEncoder {
    private ZCharTranslator translator;
    private static final int MAX_ENTRY_LENGTH = 9;
    private static final int NUM_TARGET_BYTES = 6;
    private static final int TARGET_LAST_WORD = 4;

    public ZCharEncoder(ZCharTranslator zCharTranslator) {
        this.translator = zCharTranslator;
    }

    public void encode(MemoryAccess memoryAccess, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = Math.min(n2, 9);
        EncodingState encodingState = new EncodingState();
        encodingState.source = n;
        encodingState.target = n3;
        encodingState.targetStart = n3;
        encodingState.memaccess = memoryAccess;
        while (encodingState.source < n + n6) {
            this.processChar(encodingState);
        }
        if (encodingState.wordPosition <= 2 && encodingState.target <= encodingState.targetStart + 4) {
            n5 = encodingState.currentWord;
            for (n4 = encodingState.wordPosition; n4 < 3; ++n4) {
                n5 = ZCharEncoder.writeByteToWord(n5, (short)5, n4);
            }
            encodingState.memaccess.writeUnsignedShort(encodingState.target, n5);
            encodingState.target += 2;
        }
        for (n4 = n5 = encodingState.target - n3; n4 < 6; n4 += 2) {
            encodingState.memaccess.writeUnsignedShort(n3 + n4, 5285);
        }
        n4 = memoryAccess.readUnsignedShort(n3 + 4);
        memoryAccess.writeUnsignedShort(n3 + 4, n4 | 0x8000);
    }

    private void processChar(EncodingState encodingState) {
        short s;
        AlphabetElement alphabetElement;
        if ((alphabetElement = this.translator.getAlphabetElementFor(s = encodingState.memaccess.readUnsignedByte(encodingState.source++))).getAlphabet() == null) {
            short s2 = alphabetElement.getZCharCode();
            int n = this.getSlotsLeft(encodingState);
            if (n >= 4) {
                this.processWord(encodingState, (short)5);
                this.processWord(encodingState, (short)6);
                this.processWord(encodingState, this.getUpper5Bit(s2));
                this.processWord(encodingState, this.getLower5Bit(s2));
            } else {
                for (int i = 0; i < n; ++i) {
                    this.processWord(encodingState, (short)5);
                }
            }
        } else {
            AlphabetTable.Alphabet alphabet = alphabetElement.getAlphabet();
            short s3 = alphabetElement.getZCharCode();
            if (alphabet == AlphabetTable.Alphabet.A1) {
                this.processWord(encodingState, (short)4);
            } else if (alphabet == AlphabetTable.Alphabet.A2) {
                this.processWord(encodingState, (short)5);
            }
            this.processWord(encodingState, s3);
        }
    }

    private int getSlotsLeft(EncodingState encodingState) {
        int n = (encodingState.target - encodingState.targetStart) / 2;
        return (2 - n) * 3 + (3 - encodingState.wordPosition);
    }

    private void processWord(EncodingState encodingState, short s) {
        encodingState.currentWord = ZCharEncoder.writeByteToWord(encodingState.currentWord, s, encodingState.wordPosition++);
        this.writeWordIfNeeded(encodingState);
    }

    private void writeWordIfNeeded(EncodingState encodingState) {
        if (encodingState.wordPosition > 2 && encodingState.target <= encodingState.targetStart + 4) {
            encodingState.memaccess.writeUnsignedShort(encodingState.target, encodingState.currentWord);
            encodingState.target += 2;
            encodingState.currentWord = 0;
            encodingState.wordPosition = 0;
        }
    }

    private short getUpper5Bit(short s) {
        return (short)(s >>> 5 & 0x1F);
    }

    private short getLower5Bit(short s) {
        return (short)(s & 0x1F);
    }

    private static short writeByteToWord(int n, short s, int n2) {
        int n3 = (2 - n2) * 5;
        return (short)(n | (s & 0x1F) << n3);
    }

    class EncodingState {
        public MemoryAccess memaccess;
        public int source;
        public int target;
        public int targetStart;
        public int currentWord;
        public int wordPosition;

        EncodingState() {
        }
    }
}

