!-------------------------------------------------------------------------
! Versin 1.00 Marzo de 2001
!-------------------------------------------------------------------------
! Motivacin:
!-------------------------------------------------------------------------
! Estas son unas sencillas clases que me permiten olvidarme de
! como es la sintaxis de Inform para arrays/vectores.
!-------------------------------------------------------------------------
! Uso:
!-------------------------------------------------------------------------
! vector naturales
! private
!     elementos 1 2 3 4 5 6 7 8 9 10
! ;
! print naturales.elemento(2);
! naturales.longitud();
! naturales.escribe(2,99); ! en C++ es: naturales.escribe[2] = 99;
!-------------------------------------------------------------------------

System_file;

! Clase base abstracta ----Collection-------------------------------------

class colleccion
private
      elementos 0,
public
      elemento [;
          return (null);
      ],
      longitud [;
          return 0;
      ],
      escribe [;
          return;
      ]
;

! Clase ----Vector-------------------------------------------------------

class vector
class colleccion,
 with
      elemento [i;
         if (i<=self.longitud() 
          || i>=1)
          return self.&elementos-->i;
         else
          return (null);
      ],
      longitud [;
          return (self.#elementos/WORDSIZE)-1;
      ],
      escribe [ i x;
          self.&elementos-->i = x;
      ]
;

! Clase ----Array---------------------------------------------------------

class array
class colleccion
 private
      dimx 0,
      dimy 0,
 with
      longitud [;
          return (self.#elementos/WORDSIZE)-1;
      ],
      elemento [x y;
          if (x>=1 
           && x<=dimx
           && y>=1
           && y<=dimy)
              return (self.&elementos-->((x-1)*dimy + y));
          else return (null);
      ],
      escribe [ x y v;
          if (x>=1 
           && x<=dimx
           && y>=1
           && y<=dimy)
              return (self.&elementos-->((x-1)*dimy + y) = v);
          else return (null);
      ],
      dev_dimx [; return dimx; ],
      dev_dimy [; return dimy; ]
;
      
      
       
