!--------------------------------------------------!
!                                                  !
! ZORKLAMP.H - The Zork Brass Lantern              !
!                                                  !
! Library file by Joe Merical (python_q@email.com) !
! Last modified: 6/28/02                           !
!                                                  !
! See Zork.html for more information               !
!                                                  !
!--------------------------------------------------!


System_file;

! The brass lantern
! The lantern has general when it is burned out.

Attribute light_source;

Object zork_lamp "lamp"
	with name "brass" "lantern" "lamp" "light",
	initial "A strangely familiar brass lantern is lying on the ground.",
	describe [;
		if (self has moved) {
			print "^There is a lamp here";
			if (self has light) " (providing light).";
			else "."; }
		rfalse; ],
	description [;
		if (self has general) "The lamp is burned out.";
		if (self has light) "The lamp is on.";
		if (self hasnt light) "The lamp is turned off."; ],
	number 385,
	before [;
		Examine: self.description(); rtrue;
		switchOn: 
			if (self has general) "A burned-out lamp won't light.";
			if (self has light) "It is already on.";
			if (self hasnt light) { give self light;
			StartDaemon(self); "The brass lantern is now on."; }
		switchOff:
			if (self has general) "The lamp has already burned out.";
			if (self hasnt light) "It is already off.";
			if (self has light) { give self ~light;
			StopDaemon(self); "The brass lantern is now off."; }
		Burn:
			if (verb_word=='light') <<SwitchOn Zork_lamp>>;
			else rfalse; ],
	daemon [; self.number--;
		switch(self.number) {
		185: "The lamp appears a bit dimmer.";
		85: "The lamp is definitely dimmer now.";
		15: "The lamp is nearly out.";	
		0: give self general ~light;
			"You'd better have more light than from that brass lantern."; } ],
	has switchable light_source;

Extend only 'light' first * switchable -> SwitchOn;