!--------------------------------------------------!
!                                                  !
! ZORKLIB.H -  Zork Library Messages and           !
!              Custom Verbs (XYZZY, etc.)          !
!                                                  !
! Library file by Joe Merical (python_q@email.com) !
! Last modified: 6/28/02                           !
!                                                  !
! See Zork.html for more information               !
!                                                  !
!--------------------------------------------------!


System_file;

Global randomVar;

! Custom Verbs

[ XyzzySub; "A hollow voice says ~Fool.~"; ];
[ PlughSub; "A hollow voice says ~Fool.~"; ];
[ MumbleSub; "You'll have to speak up if you expect me to hear you!"; ];
[ WinSub; "Naturally!"; ];
[ LoseSub; "Preposterous!"; ];
[ ChompSub; "Preposterous!"; ];
[ HelloSub; switch(random(4)) {
	1: "Hello.";
	2: "Good day.";
	3: "Goodbye.";
	4: "Nice weather we've been having lately."; }
];
[ HelloToSub; 
	if (noun has animate) {
		print (The) noun, " bows ";
		if (noun has female) print "her";
		else {
			if (noun has neuter) print "its";
			else print "his";
		}
		print_ret " head to you in greeting.";
	}
	else "It's a well-known fact that only schizophrenics say ~Hello~ to ", (a) noun, ".";
];
[ HelloSailorSub; "Nothing happens here."; ];
[ ScreamSub; "Aaaarrrrgggghhhh!"; ];
[ EchoSub; "echo echo ..."; ];

Verb 'xyzzy' * -> Xyzzy;
Verb 'plugh' * -> Plugh;
Verb 'mumble' 'sigh' * -> Mumble;
Verb 'win' * -> Win;
Verb 'chomp' * -> Chomp;
Verb 'lose' * -> Lose;
Verb 'hello'
	* -> Hello
	* noun -> HelloTo
	* 'sailor' -> HelloSailor;
Verb 'scream' 'yell' * -> Scream;
Verb 'echo' * -> Echo;

! Library Messages

Object LibraryMessages
	with before [;
		
		Attack: if (lm_o == player) "Suicide is not the answer.";
			else "I've known strange people, but fighting ", (a) lm_o, "?";
		
		Burn: if (second) "With ", (a) second,"??!?";
			rfalse;

		Close: switch(lm_n) {
				1: "You must tell me how to do that to ", (a) lm_o,".";
				2: if (lm_o hasnt pluralname) "It is already closed.";
					else "They are already closed.";
				default: rfalse;
			}

		Drink: "I don't think that ", (the) noun, " would agree with you.";

		Eat: switch(lm_n) {
				1: if (lm_o == player || lm_o == selfobj) "Auto-cannibalism is not the answer.";
					else "I don't think that ", (the) lm_o, " would agree with you.";
				2: "Thank you very much. It really hit the spot."; 
				default: rfalse;
			}
		
		Taste: <<EAT NOUN>>;

		Jump: switch(random(5)) {
				1: "Are you enjoying yourself?";
				2: "Do you expect me to applaud?";
				3: "Wheeeeeeeeee!!!!!";
				4: "Very good! Now you can pass the second grade.";
				5: "Have you tried hopping around the dungeon, too?";
			}

		Kiss: "I'd sooner kiss a pig.";

		Listen: if (noun == nothing) "You hear nothing unexpected.";
			if (noun == player || noun == selfobj) "You make no sound.";
			if (noun hasnt pluralname) print_ret (The) noun, " makes no sound.";
			else print_ret (The) noun, " make no sound.";

		LookUnder: switch (lm_n) {
				2: "There is nothing but dust there.";
				default: rfalse;
			}

		Open: switch(lm_n) {
				1: "You must tell me how to do that to ", (a) lm_o,".";
				2: print_ret (The) lm_o, " ", (isorare) lm_o, " locked.";
				3: if (lm_o hasnt pluralname) "It is already open.";
					else "They are already open.";
				default: rfalse;
			}


		Pull: switch(lm_n) {
				1, 2: "You can't move ", (the) lm_o, ".";
				3: if (lm_o notin player) "Moving ", (the) lm_o, " reveals nothing.";
					else "You aren't an accomplished enough juggler.";
				default: rfalse;
			}

		Push: print "Pushing ", (the) lm_o, " ";
			switch(random(3)) {
				1: "doesn't seem to work.";
				2: "isn't notably helpful.";
				3: "has no effect.";
			}
		
		Rub: if (verb_word == 'clean') "If you wish, but heaven only knows why.";
			else <<TOUCH NOUN>>;

		Smell:  if (noun == nothing) rfalse;
			if (noun == player || noun == selfobj) "It smells like yourself.";
			if (noun hasnt pluralname) "It smells like ", (a) noun,".";
			else "They smell like ", (a) noun,".";

		Squeeze: switch(lm_n) {
				1: if (lm_o==player||lm_o==selfobj) "You do not understand this.";
					else print_ret (The) lm_o, " does not understand this.";
				2: "How singularly useless.";
				default: rfalse;
			}

		Strong: if (consult_words == 0) "Such language in a high-class establishment like this!";
			else "What a loony!";
		
		Swim: if (verb_word == 'swim') "Go jump in a lake!"; else <<JUMP>>;
		
		Swing: "Whoosh!";

		Take: switch(lm_n) {
				2: "How romantic!";
				10,11: switch(random(4)) {
					1: "A valiant attempt.";
					2: "What a concept!";
					3: "An interesting idea...";
					4: "You can't be serious."; }
				default: rfalse;
			}
		
		Tell: switch(lm_n) {
				1: "Talking to yourself is said to be a sign of impending mental collapse.";
				default: rfalse;
			}

		Tie: if (second) "You can't tie ", (the) noun ," to ", (thatorthose) second, ".";
			rfalse;

		Touch: print "Fiddling with ", (the) noun, " ";
			switch(random(3)) {
				1: "doesn't seem to work.";
				2: "isn't notably helpful.";
				3: "has no effect.";
			}

		Wait: "Time passes...";
		
		WakeOther: if (lm_o has neuter) print "It";
			else { if (lm_o has female) print "She";
				else print "He"; }
			"'s wide awake, or haven't you noticed...";

		Wave: switch(lm_n) {
				1: "You don't have ", (the) lm_o, ".";
				2: "Waving ", (the) lm_o, " has no effect.";
				default: rfalse;				
			}
		
		Miscellany: switch(lm_n) {
				19: "That's difficult unless your eyes are prehensile.";
				default: rfalse;
			}
	];
