/*
 * Decompiled with CFR 0.152.
 */
package zpplet.iff;

import java.io.File;
import java.io.IOException;
import zpplet.iff.IFF;

public class IFFInput
extends IFF {
    public IFFInput(File file) throws IOException {
        super(file, "r");
    }

    public IFFInput(String name) throws IOException {
        super(name, "r");
    }

    public synchronized IFF.ChunkInfo openChunk() throws IOException {
        IFF.ChunkInfo result = new IFF.ChunkInfo(this);
        result.start = this.getFilePointer();
        result.type = this.read4Chars();
        result.length = this.readInt();
        result.composite = result.type.equals("FORM");
        if (result.composite) {
            result.type = String.valueOf(result.type) + this.read4Chars();
        }
        this.openchunks.push(result);
        return result;
    }

    public synchronized IFF.ChunkInfo skipToChunk(String type) throws IOException {
        while (true) {
            IFF.ChunkInfo ci = (IFF.ChunkInfo)this.openchunks.peek();
            long chunkend = ci.start + (long)ci.length + 8L;
            if (this.getFilePointer() >= chunkend) {
                return null;
            }
            ci = this.openChunk();
            if (ci.type.equals(type)) {
                return ci;
            }
            this.closeChunk();
        }
    }

    public synchronized void closeChunk() throws IOException {
        IFF.ChunkInfo ci = (IFF.ChunkInfo)this.openchunks.pop();
        this.seek(ci.start + (long)ci.length + 8L + 1L & 0xFFFFFFFFFFFFFFFEL);
    }

    public synchronized void close() throws IOException {
        this.openchunks.clear();
        super.close();
    }
}

