/*
 * Decompiled with CFR 0.152.
 */
package zpplet.iff;

import java.io.File;
import java.io.IOException;
import zpplet.iff.IFF;

public class IFFOutput
extends IFF {
    public IFFOutput(File file) throws IOException {
        super(file, "rw");
    }

    public IFFOutput(File file, String type) throws IOException {
        this(file);
        this.openChunk(type);
    }

    public IFFOutput(String name) throws IOException {
        super(name, "rw");
    }

    public IFFOutput(String name, String type) throws IOException {
        this(name);
        this.openChunk(type);
    }

    public synchronized void openChunk(String type) throws IOException {
        IFF.ChunkInfo ci = new IFF.ChunkInfo(this);
        ci.start = this.getFilePointer();
        ci.length = 0;
        ci.type = type;
        ci.composite = type.length() > 4;
        this.write(type.getBytes(), 0, 4);
        this.writeInt(0);
        if (ci.composite) {
            this.write(type.getBytes(), 4, 4);
        }
        this.openchunks.push(ci);
    }

    public synchronized void closeChunk() throws IOException {
        IFF.ChunkInfo ci = (IFF.ChunkInfo)this.openchunks.peek();
        long pos = this.getFilePointer();
        ci.length = this.getChunkPosition();
        this.seek(ci.start + 4L);
        this.writeInt(ci.length);
        this.openchunks.pop();
        this.seek(pos);
        if ((ci.length & 1) != 0) {
            this.writeByte(0);
        }
    }

    public synchronized void close() throws IOException {
        while (!this.openchunks.empty()) {
            this.closeChunk();
        }
        super.close();
    }

    public void writeShortAt(short n, long location) throws IOException {
        long save = this.getFilePointer();
        this.seek(location);
        this.writeShort(n);
        this.seek(save);
    }
}

