/*
 * Decompiled with CFR 0.152.
 */
package zpplet.machine;

import zpplet.data.ZDictionary4;
import zpplet.data.ZObjectTree4;
import zpplet.header.ZHeader5;
import zpplet.machine.ZMachine4;
import zpplet.misc.ZState;
import zpplet.ops.ZInstruction5;
import zpplet.system.ZColor;
import zpplet.system.ZScreen;

public class ZMachine5
extends ZMachine4 {
    ZState undo = null;

    public ZMachine5(byte[] mem, ZScreen screen) {
        super(mem, screen);
    }

    protected void initStructures() {
        this.hd = new ZHeader5(this.m);
        this.objs = new ZObjectTree4(this);
        this.zd = new ZDictionary4(this);
        this.zi = new ZInstruction5(this);
    }

    protected void initWindows() {
        this.makeTwoWindows();
        this.w[0].moveTo(1, 1);
        this.w[0].resize(this.s.getChars(), this.s.getLines());
        this.w[0].moveCursor(1, 1);
        this.w[1].moveTo(1, 1);
        this.w[1].resize(0, 0);
    }

    public void setHeaderFlags() {
        super.setHeaderFlags();
        ZHeader5 header = (ZHeader5)this.hd;
        header.setColorsAvailable(true);
        header.setPicturesAvailable(this.media != null);
        header.setUndoAvailable(true);
        header.setMouseAvailable(true);
        header.setSoundAvailable(this.media != null);
        header.setScreenHeightUnits(this.s.getLines());
        header.setScreenWidthUnits(this.s.getChars());
        header.setFontHeightUnits(1);
        header.setFontWidthUnits(1);
        ZColor z = new ZColor();
        header.setDefaultForegroundColor(z.zfg);
        header.setDefaultBackgroundColor(z.zbg);
        int alphabase = header.getAlphaCustomBase();
        int terminatorbase = header.getTerminatorsBase();
        int unicodebase = header.getUnicodeBase();
        this.zc.setCustomAddresses(alphabase, terminatorbase, unicodebase);
    }

    public void restart() {
        super.restart();
        this.w[0].moveTo(1, 1);
        this.w[0].resize(this.s.getChars(), this.s.getLines());
        this.w[0].moveCursor(1, this.w[0].getLines());
        this.w[1].moveTo(1, 1);
        this.w[1].resize(0, 0);
    }

    public short restoreUndo() {
        if (this.undo != null) {
            boolean trans = this.hd.getTranscripting();
            this.undo.restoreSnapshot();
            this.undo = null;
            this.hd.setTranscripting(trans);
            return 2;
        }
        return 0;
    }

    public short saveUndo() {
        this.undo = new ZState(this);
        return 1;
    }

    public void resize() {
        super.resize();
        ZHeader5 h = (ZHeader5)this.hd;
        h.setScreenHeightUnits(this.s.getLines());
        h.setScreenWidthUnits(this.s.getChars());
    }
}

