/*
 * Decompiled with CFR 0.152.
 */
package zpplet.ops;

import java.io.IOException;
import zpplet.machine.ZMachine;
import zpplet.misc.ZError;
import zpplet.misc.ZState;
import zpplet.ops.ZInstruction;
import zpplet.ops.ZInstruction3;

public class ZInstruction4
extends ZInstruction3 {
    protected static final int SCREEN_UNSPLIT = -1;
    protected static final int SCREEN_NOUNSPLIT = -2;

    public ZInstruction4(ZMachine zm) {
        super(zm);
    }

    protected void initOps() {
        super.initOps();
        this.ops[25] = new ZInstruction.OP_CALL(this);
        this.ops[136] = new ZInstruction.OP_CALL(this);
        this.ops[188] = new ZInstruction.OP_NOP(this);
        this.ops[236] = new ZInstruction.OP_CALL(this);
        this.ops[237] = new OP_ERASE_WINDOW();
        this.ops[238] = new OP_ERASE_LINE();
        this.ops[239] = new OP_SET_CURSOR();
        this.ops[240] = new OP_GET_CURSOR();
        this.ops[241] = new OP_SET_TEXT_STYLE();
        this.ops[242] = new OP_BUFFER_MODE();
        this.ops[246] = new OP_READ_CHAR();
        this.ops[247] = new OP_SCAN_TABLE();
    }

    int scanTable() {
        int advance = 2;
        int location = this.o[1];
        int len = this.o[2];
        boolean words = true;
        if (this.noperands == 4) {
            advance = this.o[3] & 0x7F;
            boolean bl = words = (this.o[3] & 0x80) != 0;
        }
        if (words) {
            int lastloc = location + len * 2;
            while (location < lastloc) {
                if (this.zm.getWord(location) == this.o[0]) {
                    return location;
                }
                location += advance;
            }
        } else {
            int lastloc = location + len;
            while (location < lastloc) {
                if (this.zm.getByte(location) == this.o[0]) {
                    return location;
                }
                location += advance;
            }
        }
        return 0;
    }

    protected void doSave() {
        try {
            String fname = this.zm.s.getFileName("Save Game", true);
            if (fname != null) {
                new ZState(this.zm).saveQuetzalFile(fname);
                this.doStore(1);
                return;
            }
        }
        catch (IOException iOException) {}
        this.doStore(0);
    }

    protected void doRestore() {
        try {
            String fname = this.zm.s.getFileName("Load Game", false);
            if (fname != null) {
                new ZState(this.zm).loadQuetzalFile(fname);
                this.doStore(2);
                return;
            }
        }
        catch (Exception exception) {}
        this.doStore(0);
    }

    protected void doEraseWindow() {
        short n = (short)this.o[0];
        if (n == -1) {
            this.zm.s.clear();
            this.doSplitWindow(0);
            this.zm.w[0].moveCursor(1, this.zm.w[0].getLines());
        } else if (n == -2) {
            this.zm.s.clear();
            this.zm.w[0].moveCursor(1, 1);
            this.zm.w[1].moveCursor(1, 1);
        } else {
            this.zm.w[this.o[0]].clear();
            if (this.o[0] == 0) {
                this.zm.w[0].moveCursor(1, this.zm.w[0].getLines());
            } else {
                this.zm.w[this.o[0]].moveCursor(1, 1);
            }
        }
    }

    protected void doEraseLine() {
        if (this.o[0] == 1) {
            this.zm.curw.eraseLine();
        }
    }

    class OP_ERASE_WINDOW
    implements ZInstruction.IOP {
        OP_ERASE_WINDOW() {
        }

        public void x() {
            ZInstruction4.this.doEraseWindow();
        }
    }

    class OP_ERASE_LINE
    implements ZInstruction.IOP {
        OP_ERASE_LINE() {
        }

        public void x() {
            ZInstruction4.this.doEraseLine();
        }
    }

    class OP_SET_CURSOR
    implements ZInstruction.IOP {
        OP_SET_CURSOR() {
        }

        public void x() {
            if (ZInstruction4.this.zm.curw == ZInstruction4.this.zm.w[1]) {
                ZInstruction4.this.zm.curw.moveCursor(ZInstruction4.this.o[1], ZInstruction4.this.o[0]);
            }
        }
    }

    class OP_GET_CURSOR
    implements ZInstruction.IOP {
        OP_GET_CURSOR() {
        }

        public void x() {
            ZInstruction4.this.zm.curw.flush();
            ZInstruction4.this.zm.setWord(ZInstruction4.this.o[0], ZInstruction4.this.zm.curw.getCursorY());
            ZInstruction4.this.zm.setWord(ZInstruction4.this.o[0] + 2, ZInstruction4.this.zm.curw.getCursorX());
        }
    }

    class OP_SET_TEXT_STYLE
    implements ZInstruction.IOP {
        OP_SET_TEXT_STYLE() {
        }

        public void x() {
            ZInstruction4.this.zm.curw.setStyle(ZInstruction4.this.o[0]);
        }
    }

    class OP_BUFFER_MODE
    implements ZInstruction.IOP {
        OP_BUFFER_MODE() {
        }

        public void x() {
            ZInstruction4.this.zm.w[0].setBufferMode(ZInstruction4.this.o[0] != 0);
        }
    }

    class OP_READ_CHAR
    implements ZInstruction.IOP {
        OP_READ_CHAR() {
        }

        public void x() throws ZError {
            ZInstruction4.this.zm.curw.flush();
            ZInstruction4.this.zm.curw.resetLineCount();
            if (ZInstruction4.this.noperands < 2) {
                ZInstruction4.this.o[1] = 0;
            }
            if (ZInstruction4.this.noperands < 3) {
                ZInstruction4.this.o[2] = 0;
            }
            ZInstruction4.this.zm.s.repaint();
            int ch = ZInstruction4.this.zm.getInput(false, ZInstruction4.this.o[1], ZInstruction4.this.o[2]);
            if (ch == -1) {
                throw new ZError(null);
            }
            ZInstruction4.this.doStore(ch);
        }
    }

    class OP_SCAN_TABLE
    implements ZInstruction.IOP {
        OP_SCAN_TABLE() {
        }

        public void x() {
            int r = ZInstruction4.this.scanTable();
            ZInstruction4.this.doStore(r);
            ZInstruction4.this.doBranch(r != 0);
        }
    }
}

