/*
 * Decompiled with CFR 0.152.
 */
package zpplet.system;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;

class ZCursor
extends Thread {
    private Color color;
    private boolean visible;
    private boolean showing;
    int top;
    int left;
    int width;
    int height;
    private Component parent;

    ZCursor(Component parent) {
        this.parent = parent;
        this.color = Color.BLACK;
        this.visible = false;
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        this.showing = true;
        while (true) {
            try {
                this.refresh();
                if (this.visible) {
                    Thread.sleep(this.showing ? 500 : 300);
                    this.showing = !this.showing;
                    continue;
                }
                Thread.sleep(Long.MAX_VALUE);
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.showing = true;
                continue;
            }
            break;
        }
    }

    synchronized void setVisible(boolean value) {
        this.visible = value;
        this.interrupt();
    }

    boolean isVisible() {
        return this.visible;
    }

    private synchronized void refresh() {
        if (this.visible && this.showing && this.parent.isFocusOwner()) {
            this.draw(this.parent.getGraphics());
        } else {
            this.parent.repaint(this.left, this.top, this.width, this.height);
        }
        Toolkit.getDefaultToolkit().sync();
    }

    synchronized void draw(Graphics g) {
        g.setColor(this.color);
        g.fillRect(this.left, this.top, this.width, this.height);
    }

    void paint(Graphics g) {
        if (this.visible && this.showing && this.parent.isFocusOwner()) {
            this.draw(g);
        }
    }

    synchronized void setBounds(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    void move(int left, int top) {
        if (left == this.left && top == this.top) {
            return;
        }
        boolean v = this.visible;
        if (v) {
            this.setVisible(false);
        }
        this.left = left;
        this.top = top;
        if (v) {
            this.setVisible(true);
        }
    }

    void setColor(Color color) {
        this.color = color;
    }
}

