/*
 * Decompiled with CFR 0.152.
 */
package zpplet.system;

import java.awt.Color;
import java.awt.Font;
import zpplet.ZUserConfig;
import zpplet.system.ZColor;
import zpplet.system.ZScreen;

public class ZFont {
    public static final int ROMAN = 0;
    public static final int REVERSE = 1;
    public static final int BOLD = 2;
    public static final int ITALIC = 4;
    public static final int FIXED = 8;
    public static final int PREVIOUS_FONT = 0;
    public static final int NORMAL_FONT = 1;
    public static final int PICTURE_FONT = 2;
    public static final int GRAPHICS_FONT = 3;
    public static final int FIXED_FONT = 4;
    private Font font;
    private int zfont = 1;
    private int zstyle = 0;
    public ZColor color = new ZColor();
    private boolean dirty = true;

    public ZFont(ZScreen screen) {
    }

    public Font getFont() {
        if (this.dirty) {
            int style;
            String name = this.zfont == 4 || (this.zstyle & 8) != 0 ? ZUserConfig.fixedfont : ZUserConfig.normalfont;
            int n = style = (this.zstyle & 4) == 0 ? 0 : 2;
            if ((this.zstyle & 2) != 0) {
                style |= 1;
            }
            this.font = new Font(name, style, ZUserConfig.fontsize);
        }
        return this.font;
    }

    public void touch() {
        this.dirty = true;
    }

    public Color getForeground() {
        Color result = (this.zstyle & 1) == 0 ? this.color.fg : this.color.bg;
        if ((this.zstyle & 2) != 0) {
            return result.brighter();
        }
        return result;
    }

    public int getZFont() {
        return this.zfont;
    }

    public int getZStyle() {
        return this.zstyle;
    }

    public Color getBack() {
        if ((this.zstyle & 1) == 0) {
            return this.color.bg;
        }
        return this.color.fg;
    }

    public int getColorBytes() {
        return (this.color.zfg & 0xFF) + ((this.color.zbg & 0xFF) << 8);
    }

    public boolean isFixed() {
        return this.zfont == 4 || (this.zstyle & 8) != 0;
    }

    public void setStyle(int style) {
        this.zstyle = style == 0 ? 0 : (this.zstyle |= style);
        this.dirty = true;
    }

    public int set(int font) {
        switch (font) {
            case 0: {
                return this.zfont;
            }
            case 1: 
            case 4: {
                int old = this.zfont;
                this.zfont = font;
                this.dirty = true;
                return old;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
        }
        System.err.println("Illegal font value " + font);
        return 0;
    }
}

