-- meta.i
-- version for skipbrek, sjg 

-- with score incorporating turn count
-- amended other meta verbs to not increment turn count

-- added score change notification and a player 'notify' verb to
-- turn it off and on

-- made 'again' text more flippant

-- added a customised <MORE> message


SYNONYMS
    q = quit.

SYNTAX
    quit = quit.

VERB quit
    DOES
    	QUIT.
END VERB.

----

SYNTAX
    save = save.

VERB save
    DOES
    DECREASE Turns OF Hero.
	SAVE.
	"Done."
END VERB.

----

SYNTAX
    restore = restore.

VERB restore
    DOES
    	RESTORE.
    	"Done.$n"
    DECREASE Turns OF Hero.
	LOOK.
END VERB.

----

SYNTAX
    restart = restart.

VERB restart
    DOES
        RESTART.
END VERB.

----

SYNTAX
    'score' = 'score'.

VERB 'score' DOES
    DECREASE Turns OF Hero.
    "You have scored"
    SAY points OF hero.
    "point"
    IF points OF hero <> 1 THEN
       "$$s"
    END IF.
    "out of" SAY max_points OF hero.
    "$$. (In "
    SAY Turns OF Hero.
    "turn"
    IF turns OF hero <> 1 THEN
       "$$s"
    END IF.
    "$$.)"
END VERB.

----

SYNONYMS
    z = wait.

SYNTAX
    wait = wait.

VERB wait
    DOES
    	"Time passes..."
END VERB.

----

SYNONYMS
    g = again.

SYNTAX
    again = again.

VERB again
    DOES
        "The 'again' command doesn't work, sorry. You can press the F3 key
        to repeat your last command. (Though, of course, that won't help
        just now because your last command was 'again' and that command
        doesn't work but I think I mentioned that.)
        $iYou can also try the up and down arrow keys to scroll through
        your previous commands - that works on some operating systems."
    DECREASE Turns OF Hero.
END VERB.

----

SYNTAX
    undo = undo.

VERB undo
    DOES
        "Unfortunately you cannot 'undo' commands in this game."
    DECREASE Turns OF Hero.
END VERB.

----

SYNTAX
    notify = notify.

VERB notify
    DOES
        IF hero IS notify_on THEN
            MAKE hero NOT notify_on.
            "Score notification is now disabled. (You can turn it back
            on using the NOTIFY command again.)"
        ELSE
            MAKE hero notify_on.
            "Score notification is now enabled. (You can turn it off
            using the NOTIFY command again.)"
        END IF.
    DECREASE Turns OF Hero.
END VERB.

----

EVENT TurnTick
    INCREASE Turns OF Hero.
    SCHEDULE TurnTick AFTER 1.
END EVENT.

----

EVENT checkscore
    IF previous_points OF hero < points OF hero THEN
        IF hero IS notify_on THEN
            "$p (Your score just went up by"
            SAY (points OF hero - previous_points OF hero).
            "point"
            IF (points OF hero - previous_points OF hero) <> 1 THEN
               "$$s"
            END IF.
            "$$."
            IF hero IS NOT seen_notify THEN
                MAKE hero seen_notify.
                "You can use the NOTIFY command to disable score change
                messages like this one."
            END IF.
            "$$)"
        END IF.
        SET previous_points of Hero to points OF hero.
    END IF.
    SCHEDULE checkscore AT hero AFTER 1.
END EVENT.

----

MESSAGE MORE : " ... Press 'Enter' key ... "
