/*
   winglk_startup.c: Windows-specific code for the Floo interpreter.
*/

#define _WIN32_WINNT 0x0400
#include <windows.h>

#include "glk.h"
#include "gi_blorb.h"
#include "WinGlk.h"

extern strid_t gamefile; /* This is defined in main.c. */

UINT APIENTRY OFNHookProc(HWND hdlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

int winglk_startup_code(const char* cmdline)
{
	OPENFILENAME OpenInfo;
	char strFileName[256];
	char* pszExt;
	static char* strResFile = "Floo.blb";

	winglk_app_set_name("Floo");
	winglk_window_set_title("Floo Interpreter");

	strFileName[0] = '\0';
	ZeroMemory(&OpenInfo,sizeof(OPENFILENAME));
	OpenInfo.lStructSize = sizeof(OPENFILENAME);
	OpenInfo.lpstrFile = strFileName;
	OpenInfo.nMaxFile = 256;
	OpenInfo.lpstrFilter = "Floo Files (*.floo;*.flo)\0*.floo;*.flo\0All Files (*.*)\0*.*\0";
	OpenInfo.lpstrTitle = "Select a floo source file to interpret";
	OpenInfo.Flags = OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_ENABLEHOOK|OFN_EXPLORER;
	OpenInfo.lpfnHook = OFNHookProc;
	if (GetOpenFileName(&OpenInfo) != 0)
	{
		frefid_t gameref = glk_fileref_create_by_name(fileusage_BinaryMode|fileusage_Data,strFileName,0);
		if (gameref)
		{
			gamefile = glk_stream_open_file(gameref,filemode_Read,0);
			glk_fileref_destroy(gameref);
		}
		else
			return 0;
	}
	else
		return 0;

	/* Attempt to load the Blorb resource file, if any */
	pszExt = strrchr(strFileName,'\\');
	if (pszExt)
	{
		if ((pszExt-strFileName+1) + strlen(strResFile) < 256)
		{
			frefid_t resref;
			strid_t resfile;

			*pszExt = '\0';
			winglk_set_resource_directory(strFileName);
			*pszExt = '\\';

			strcpy(pszExt+1,strResFile);
			resref = glk_fileref_create_by_name(fileusage_BinaryMode|fileusage_Data,strFileName,0);
			if (resref)
			{
				resfile = glk_stream_open_file(resref,filemode_Read,0);
				if (resfile)
					giblorb_set_resource_map(resfile);
				glk_fileref_destroy(resref);
			}
		}
	}

  return 1;
}

UINT APIENTRY OFNHookProc(HWND hdlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	if (uiMsg == WM_NOTIFY)
	{
		LPOFNOTIFY pNotify = (LPOFNOTIFY)lParam;
		if (pNotify->hdr.code == CDN_INITDONE)
		{
			HWND hExplorer = GetParent(hdlg);

			RECT ExplorerRect;
			int iWidth = GetSystemMetrics(SM_CXSCREEN);
			int iHeight = GetSystemMetrics(SM_CYSCREEN);
			int iDlgWidth, iDlgHeight;
			int iOffsetX, iOffsetY;

			GetWindowRect(hExplorer,&ExplorerRect);
			iDlgWidth = ExplorerRect.right - ExplorerRect.left;
			iDlgHeight = ExplorerRect.bottom - ExplorerRect.top;
			iOffsetX = (iWidth - iDlgWidth) / 2;
			iOffsetY = (iHeight - iDlgHeight) / 2;

			MoveWindow(hExplorer,iOffsetX,iOffsetY,iDlgWidth,iDlgHeight,1);
			return 1;
		}
	}
	return 0;
}
