/*
 * Decompiled with CFR 0.152.
 */
package iageserver;

import iageserver.character;
import iageserver.constant;
import iageserver.data;
import iageserver.game;
import iageserver.iagecode;
import iageserver.iagecollection;
import iageserver.interpreter;
import iageserver.item;
import iageserver.location;
import iageserver.message;
import iageserver.namevaluepair;
import iageserver.parsestring;
import iageserver.processor;
import iageserver.serverlistenthread;
import iageserver.vdu;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;

public class player {
    public String Name = "";
    public String DisplayName = "";
    public long Score;
    public long Turns;
    public long CurrentLocation;
    public String IPAddress = "";
    public int Index;
    public byte State = ST_NORMAL;
    public item StateItem;
    public long WeightCarried;
    public long ItemsCarried;
    public long SizeCarried;
    public long LastNoun;
    public String LastNounText = "";
    public boolean CanSee = true;
    public String LastCommand = "";
    public iagecollection LocationsSeen = new iagecollection();
    public boolean VerboseMode = true;
    public Socket PlayerSocketHandle;
    public DataInputStream socket_inputstream;
    public PrintWriter socket_outputstream;
    public serverlistenthread serverthread;
    public boolean OutputToPlayer = false;
    public long HitPoints;
    public long DamageIndicator;
    public long Money;
    public long ChanceOfHitting = 60L;
    public iagecollection NameValues = new iagecollection();
    public String CP1 = "";
    public String CP2 = "";
    public String CP3 = "";
    public String CP4 = "";
    public String CP5 = "";
    public String CP6 = "";
    public String CP7 = "";
    public String CP8 = "";
    public String CP9 = "";
    public String CP10 = "";
    public String CP11 = "";
    public String CP12 = "";
    public String CP13 = "";
    public String CP14 = "";
    public String CP15 = "";
    public String CP16 = "";
    public String CP17 = "";
    public String CP18 = "";
    public String CP19 = "";
    public String CP20 = "";
    public String CP21 = "";
    public String CP22 = "";
    public String CP23 = "";
    public String CP24 = "";
    public String CP25 = "";
    public String CP26 = "";
    public String CP27 = "";
    public String CP28 = "";
    public String CP29 = "";
    public String CP30 = "";
    public int AskProgramCounter;
    public String UserResponseToAsk = "";
    public boolean WaitingForAskResponse = false;
    public iagecode AskCode;
    public String AskCodeSource = "";
    public interpreter AskInterpreter;
    public boolean LastParserAskedQuestion = false;
    public parsestring LastParser;
    public int LastQReplacesNoun;
    public static byte ST_NORMAL = 1;
    public static byte ST_SITTING = (byte)2;
    public static byte ST_LYING = (byte)3;
    public static byte ST_STOODON = (byte)4;
    public static byte ST_INSIDE = (byte)5;
    public boolean TextOnly = false;

    public void quit(boolean bl) {
        interpreter interpreter2 = new interpreter(this, null);
        interpreter2.runcode(data.ogame.OnQuit, "Game.OnQuit");
        if (!bl) {
            vdu.TransmitAll(processor.smake(message.getMessage(constant.MSG_PLAYERQUIT), this.Name));
        }
        vdu.println("Connection " + Integer.toString(this.Index) + " - " + this.Name + " (" + this.IPAddress + ") has quit.");
        vdu.Transmit("QUIT: DIE|", this);
        item.MoveAll((long)this.Index + location.PLAYERBASE, this.CurrentLocation);
        if (!bl) {
            vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERDROPSTHEIROBJECTS), this.Name), this, this.CurrentLocation);
        }
        try {
            this.serverthread.isFinished = true;
            this.serverthread = null;
        }
        catch (Exception exception) {}
        int n = 1;
        player player2 = null;
        while (n <= data.oplayers.getCount()) {
            player2 = (player)data.oplayers.get(n);
            if (player2.Index == this.Index) {
                data.oplayers.remove(n);
                break;
            }
            ++n;
        }
        vdu.updateconnectionlist();
    }

    public void MarkLocationAsSeen(long l) {
        this.LocationsSeen.add(new Long(l));
    }

    public boolean HasSeenLocation(long l) {
        int n = 1;
        while (n <= this.LocationsSeen.getCount()) {
            Long l2 = (Long)this.LocationsSeen.get(n);
            if (l2 == l) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void showscore() {
        interpreter interpreter2 = new interpreter(this, null);
        interpreter2.runcode(data.ogame.OnScore, "Player(" + Integer.toString(this.Index) + ").OnScore");
    }

    public void showstatus() {
        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_STATUS), Long.toString(this.HitPoints), Long.toString(this.DamageIndicator), Long.toString(this.ChanceOfHitting)), this);
    }

    public void SaveState(String string, String string2) {
        Closeable closeable;
        if (!data.ogame.AllowPersist) {
            vdu.Transmit("You cannot save your position in this game.", this);
            return;
        }
        if (data.ogame.SinglePlayerGame) {
            vdu.Transmit("Saving state for single player game...", this);
        } else {
            vdu.Transmit("Saving state for multi-player game...", this);
        }
        String string3 = String.valueOf(data.gamepath) + "." + this.Name + "_" + string2 + ".state";
        File file = new File(string3);
        if (file.exists()) {
            vdu.Transmit("File exists, checking security...", this);
            try {
                closeable = new FileInputStream(file);
                String string4 = data.readline((FileInputStream)closeable);
                string4 = data.readline((FileInputStream)closeable);
                string4 = data.readline((FileInputStream)closeable);
                data.isencrypted = true;
                string4 = data.decrypt(string4);
                if (!string.equals(string4)) {
                    vdu.Transmit("Security check failed - incorrect password. Save state failed.", this);
                    return;
                }
                vdu.Transmit("Security check passed...", this);
            }
            catch (IOException iOException) {
                vdu.println("Unable to check security in file: " + string3);
                vdu.Transmit("Unable to read file, save state failed.", this);
                iOException.printStackTrace();
            }
        }
        try {
            int n;
            closeable = new FileOutputStream(file);
            this.writelineunencrypted((FileOutputStream)closeable, "IAGE 2 SAVE");
            this.writelineunencrypted((FileOutputStream)closeable, "1");
            this.writeline((FileOutputStream)closeable, string);
            if (data.ogame.SinglePlayerGame) {
                this.writeline((FileOutputStream)closeable, "1");
            } else {
                this.writeline((FileOutputStream)closeable, "0");
            }
            this.writeline((FileOutputStream)closeable, "PLAYER");
            this.writeline((FileOutputStream)closeable, "Name = " + this.Name);
            this.writeline((FileOutputStream)closeable, "CanSee = " + data.booleanToString(this.CanSee));
            this.writeline((FileOutputStream)closeable, "ChanceOfHitting = " + Long.toString(this.ChanceOfHitting));
            this.writeline((FileOutputStream)closeable, "CurrentLocation = " + Long.toString(this.CurrentLocation));
            this.writeline((FileOutputStream)closeable, "DamageIndicator = " + Long.toString(this.DamageIndicator));
            this.writeline((FileOutputStream)closeable, "DisplayName = " + this.DisplayName);
            this.writeline((FileOutputStream)closeable, "HitPoints = " + Long.toString(this.HitPoints));
            this.writeline((FileOutputStream)closeable, "ItemsCarried = " + Long.toString(this.ItemsCarried));
            this.writeline((FileOutputStream)closeable, "Money = " + Long.toString(this.Money));
            this.writeline((FileOutputStream)closeable, "Score = " + Long.toString(this.Score));
            this.writeline((FileOutputStream)closeable, "SizeCarried = " + Long.toString(this.SizeCarried));
            this.writeline((FileOutputStream)closeable, "Turns = " + Long.toString(this.Turns));
            this.writeline((FileOutputStream)closeable, "WeightCarried = " + Long.toString(this.WeightCarried));
            this.writeline((FileOutputStream)closeable, "CP1 = " + this.CP1);
            this.writeline((FileOutputStream)closeable, "CP2 = " + this.CP2);
            this.writeline((FileOutputStream)closeable, "CP3 = " + this.CP3);
            this.writeline((FileOutputStream)closeable, "CP4 = " + this.CP4);
            this.writeline((FileOutputStream)closeable, "CP5 = " + this.CP5);
            this.writeline((FileOutputStream)closeable, "CP6 = " + this.CP6);
            this.writeline((FileOutputStream)closeable, "CP7 = " + this.CP7);
            this.writeline((FileOutputStream)closeable, "CP8 = " + this.CP8);
            this.writeline((FileOutputStream)closeable, "CP9 = " + this.CP9);
            this.writeline((FileOutputStream)closeable, "CP10 = " + this.CP10);
            this.writeline((FileOutputStream)closeable, "CP11 = " + this.CP11);
            this.writeline((FileOutputStream)closeable, "CP12 = " + this.CP12);
            this.writeline((FileOutputStream)closeable, "CP13 = " + this.CP13);
            this.writeline((FileOutputStream)closeable, "CP14 = " + this.CP14);
            this.writeline((FileOutputStream)closeable, "CP15 = " + this.CP15);
            this.writeline((FileOutputStream)closeable, "CP16 = " + this.CP16);
            this.writeline((FileOutputStream)closeable, "CP17 = " + this.CP17);
            this.writeline((FileOutputStream)closeable, "CP18 = " + this.CP18);
            this.writeline((FileOutputStream)closeable, "CP19 = " + this.CP19);
            this.writeline((FileOutputStream)closeable, "CP20 = " + this.CP20);
            this.writeline((FileOutputStream)closeable, "CP21 = " + this.CP21);
            this.writeline((FileOutputStream)closeable, "CP22 = " + this.CP22);
            this.writeline((FileOutputStream)closeable, "CP23 = " + this.CP23);
            this.writeline((FileOutputStream)closeable, "CP24 = " + this.CP24);
            this.writeline((FileOutputStream)closeable, "CP25 = " + this.CP25);
            this.writeline((FileOutputStream)closeable, "CP26 = " + this.CP26);
            this.writeline((FileOutputStream)closeable, "CP27 = " + this.CP27);
            this.writeline((FileOutputStream)closeable, "CP28 = " + this.CP28);
            this.writeline((FileOutputStream)closeable, "CP29 = " + this.CP29);
            this.writeline((FileOutputStream)closeable, "CP30 = " + this.CP30);
            int n2 = 1;
            namevaluepair namevaluepair2 = null;
            while (n2 <= this.NameValues.getCount()) {
                namevaluepair2 = (namevaluepair)this.NameValues.get(n2);
                this.writeline((FileOutputStream)closeable, "NV " + namevaluepair2.Name + " " + namevaluepair2.Value);
                ++n2;
            }
            this.writeline((FileOutputStream)closeable, "END");
            if (!data.ogame.SinglePlayerGame) {
                vdu.Transmit("Save successful.", this);
                return;
            }
            location location2 = null;
            item item2 = null;
            character character2 = null;
            this.writeline((FileOutputStream)closeable, "");
            this.writeline((FileOutputStream)closeable, "LOCATIONS");
            this.writeline((FileOutputStream)closeable, "");
            n2 = 1;
            while (n2 <= data.olocations.getCount()) {
                location2 = (location)data.olocations.get(n2);
                this.writeline((FileOutputStream)closeable, "ID = " + Long.toString(location2.ID));
                this.writeline((FileOutputStream)closeable, "Name = " + location2.Name);
                this.writeline((FileOutputStream)closeable, "ImagePath = " + location2.ImagePath);
                this.writeline((FileOutputStream)closeable, "Description = " + location2.Description);
                this.writeline((FileOutputStream)closeable, "IsDark = " + data.booleanToString(location2.IsDark));
                this.writeline((FileOutputStream)closeable, "CustomProperties = " + location2.CustomProperties);
                this.writeline((FileOutputStream)closeable, "N = " + Long.toString(location2.N));
                this.writeline((FileOutputStream)closeable, "S = " + Long.toString(location2.S));
                this.writeline((FileOutputStream)closeable, "E = " + Long.toString(location2.E));
                this.writeline((FileOutputStream)closeable, "W = " + Long.toString(location2.W));
                this.writeline((FileOutputStream)closeable, "U = " + Long.toString(location2.U));
                this.writeline((FileOutputStream)closeable, "D = " + Long.toString(location2.D));
                this.writeline((FileOutputStream)closeable, "NE = " + Long.toString(location2.NE));
                this.writeline((FileOutputStream)closeable, "NW = " + Long.toString(location2.NW));
                this.writeline((FileOutputStream)closeable, "SE = " + Long.toString(location2.SE));
                this.writeline((FileOutputStream)closeable, "SW = " + Long.toString(location2.SW));
                n = 1;
                while (n <= location2.NameValues.getCount()) {
                    namevaluepair2 = (namevaluepair)location2.NameValues.get(n);
                    this.writeline((FileOutputStream)closeable, "NV " + namevaluepair2.Name + " " + namevaluepair2.Value);
                    ++n;
                }
                if (n2 < data.olocations.getCount()) {
                    this.writeline((FileOutputStream)closeable, "BREAK");
                }
                ++n2;
            }
            this.writeline((FileOutputStream)closeable, "");
            this.writeline((FileOutputStream)closeable, "END");
            this.writeline((FileOutputStream)closeable, "");
            this.writeline((FileOutputStream)closeable, "ITEMS");
            this.writeline((FileOutputStream)closeable, "");
            n2 = 1;
            while (n2 <= data.oitems.getCount()) {
                item2 = (item)data.oitems.get(n2);
                this.writeline((FileOutputStream)closeable, "ID = " + Long.toString(item2.ID));
                this.writeline((FileOutputStream)closeable, "Name = " + item2.Name);
                this.writeline((FileOutputStream)closeable, "CurrentLocation = " + Long.toString(item2.CurrentLocation));
                this.writeline((FileOutputStream)closeable, "Weight = " + Long.toString(item2.Weight));
                this.writeline((FileOutputStream)closeable, "Description = " + item2.Description);
                this.writeline((FileOutputStream)closeable, "CustomProperties = " + item2.CustomProperties);
                this.writeline((FileOutputStream)closeable, "UserBooleans = " + item2.UserBooleans);
                this.writeline((FileOutputStream)closeable, "NounID = " + Long.toString(item2.NounID));
                this.writeline((FileOutputStream)closeable, "IsLightSource = " + data.booleanToString(item2.IsLightSource));
                this.writeline((FileOutputStream)closeable, "IsLit = " + data.booleanToString(item2.IsLit));
                this.writeline((FileOutputStream)closeable, "IsWorn = " + data.booleanToString(item2.IsWorn));
                this.writeline((FileOutputStream)closeable, "IsWeapon = " + data.booleanToString(item2.IsWeapon));
                this.writeline((FileOutputStream)closeable, "HasSurface = " + data.booleanToString(item2.HasSurface));
                this.writeline((FileOutputStream)closeable, "CanBeLaidOn = " + data.booleanToString(item2.CanBeLaidOn));
                this.writeline((FileOutputStream)closeable, "CanBeStoodOn = " + data.booleanToString(item2.CanBeStoodOn));
                this.writeline((FileOutputStream)closeable, "CanBeSatOn = " + data.booleanToString(item2.CanBeSatOn));
                this.writeline((FileOutputStream)closeable, "CanBeGotIn = " + data.booleanToString(item2.CanBeGotIn));
                this.writeline((FileOutputStream)closeable, "DefaultExamine = " + item2.DefaultExamine);
                this.writeline((FileOutputStream)closeable, "IsContainer = " + data.booleanToString(item2.IsContainer));
                this.writeline((FileOutputStream)closeable, "IsEdible = " + data.booleanToString(item2.IsEdible));
                this.writeline((FileOutputStream)closeable, "EdibleHitPoints = " + Long.toString(item2.EdibleHitPoints));
                this.writeline((FileOutputStream)closeable, "IsWearable = " + data.booleanToString(item2.IsWearable));
                this.writeline((FileOutputStream)closeable, "IsReadable = " + data.booleanToString(item2.IsReadable));
                this.writeline((FileOutputStream)closeable, "ReadableText = " + item2.ReadableText);
                this.writeline((FileOutputStream)closeable, "Size = " + Long.toString(item2.Size));
                this.writeline((FileOutputStream)closeable, "DamageIndicator = " + Long.toString(item2.DamageIndicator));
                this.writeline((FileOutputStream)closeable, "Invisible = " + data.booleanToString(item2.Invisible));
                this.writeline((FileOutputStream)closeable, "IsFixed = " + data.booleanToString(item2.IsFixed));
                this.writeline((FileOutputStream)closeable, "CanOpenClose = " + data.booleanToString(item2.CanOpenClose));
                this.writeline((FileOutputStream)closeable, "OpenCloseState = " + data.booleanToString(item2.OpenCloseState));
                this.writeline((FileOutputStream)closeable, "FixedMessage = " + item2.FixedMessage);
                this.writeline((FileOutputStream)closeable, "IsSubItem = " + data.booleanToString(item2.IsSubItem));
                this.writeline((FileOutputStream)closeable, "SubItemOf = " + Long.toString(item2.SubItemOf));
                n = 1;
                namevaluepair2 = null;
                while (n <= item2.NameValues.getCount()) {
                    namevaluepair2 = (namevaluepair)item2.NameValues.get(n);
                    this.writeline((FileOutputStream)closeable, "NV " + namevaluepair2.Name + " " + namevaluepair2.Value);
                    ++n;
                }
                if (n2 < data.oitems.getCount()) {
                    this.writeline((FileOutputStream)closeable, "BREAK");
                }
                ++n2;
            }
            this.writeline((FileOutputStream)closeable, "");
            this.writeline((FileOutputStream)closeable, "END");
            this.writeline((FileOutputStream)closeable, "");
            this.writeline((FileOutputStream)closeable, "CHARACTERS");
            this.writeline((FileOutputStream)closeable, "");
            n2 = 1;
            while (n2 <= data.ocharacters.getCount()) {
                character2 = (character)data.ocharacters.get(n2);
                this.writeline((FileOutputStream)closeable, "ID = " + Long.toString(character2.ID));
                this.writeline((FileOutputStream)closeable, "Name = " + character2.Name);
                this.writeline((FileOutputStream)closeable, "CurrentLocation = " + Long.toString(character2.CurrentLocation));
                this.writeline((FileOutputStream)closeable, "Description = " + character2.Description);
                this.writeline((FileOutputStream)closeable, "NounID = " + Long.toString(character2.NounID));
                this.writeline((FileOutputStream)closeable, "TimerInterval = " + Long.toString(character2.TimerInterval));
                this.writeline((FileOutputStream)closeable, "DefaultExamine = " + character2.DefaultExamine);
                this.writeline((FileOutputStream)closeable, "HitPoints = " + Long.toString(character2.HitPoints));
                this.writeline((FileOutputStream)closeable, "DamageIndicator = " + Long.toString(character2.DamageIndicator));
                this.writeline((FileOutputStream)closeable, "AutoAttack = " + data.booleanToString(character2.AutoAttack));
                this.writeline((FileOutputStream)closeable, "AttackWhenAttacked = " + data.booleanToString(character2.AttackWhenAttacked));
                this.writeline((FileOutputStream)closeable, "Money = " + Long.toString(character2.Money));
                n = 1;
                while (n <= character2.NameValues.getCount()) {
                    namevaluepair2 = (namevaluepair)character2.NameValues.get(n);
                    this.writeline((FileOutputStream)closeable, "NV " + namevaluepair2.Name + " " + namevaluepair2.Value);
                    ++n;
                }
                if (n2 < data.ocharacters.getCount()) {
                    this.writeline((FileOutputStream)closeable, "BREAK");
                }
                ++n2;
            }
            this.writeline((FileOutputStream)closeable, "");
            this.writeline((FileOutputStream)closeable, "END");
            this.writeline((FileOutputStream)closeable, "");
            this.writeline((FileOutputStream)closeable, "FLAGS");
            this.writeline((FileOutputStream)closeable, "");
            n2 = 1;
            while (n2 <= data.maxflags - 1) {
                this.writeline((FileOutputStream)closeable, "Index = " + Integer.toString(n2));
                this.writeline((FileOutputStream)closeable, "Value = " + data.oflags[n2].Value);
                if (n2 < data.maxflags) {
                    this.writeline((FileOutputStream)closeable, "BREAK");
                }
                ++n2;
            }
            this.writeline((FileOutputStream)closeable, "");
            this.writeline((FileOutputStream)closeable, "END");
            vdu.Transmit("Save successful.", this);
            game.displaylocation(this);
            return;
        }
        catch (IOException iOException) {
            vdu.println("Unable to write to file: " + string3);
            vdu.Transmit("Unable to write to file, save state failed.", this);
            iOException.printStackTrace();
            return;
        }
    }

    public boolean RestoreState(String string, String string2) {
        if (!data.ogame.AllowPersist) {
            vdu.Transmit("You cannot restore your position in this game.", this);
            return false;
        }
        String string3 = String.valueOf(data.gamepath) + "." + this.Name + "_" + string2 + ".state";
        File file = new File(string3);
        if (!file.exists()) {
            vdu.Transmit("File does not exist - restore state failed.", this);
            return false;
        }
        vdu.Transmit("Found state file, checking security...", this);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            data.fileeof = false;
            String string4 = data.readline(fileInputStream);
            if (!string4.equalsIgnoreCase("IAGE 2 SAVE")) {
                vdu.Transmit("Bad file format - restore state failed.", this);
                return false;
            }
            string4 = data.readline(fileInputStream);
            data.isencrypted = true;
            string4 = data.decrypt(data.readline(fileInputStream));
            if (!string4.equals(string)) {
                vdu.Transmit("Incorrect password - restore state failed.", this);
                return false;
            }
            vdu.Transmit("Security check passed, restoring position...", this);
            while (!data.fileeof) {
                string4 = data.decrypt(data.readline(fileInputStream));
                if (string4.trim().equalsIgnoreCase("PLAYER")) {
                    this.restoreplayer(fileInputStream);
                }
                if (string4.trim().equalsIgnoreCase("LOCATIONS")) {
                    this.restorelocations(fileInputStream);
                }
                if (string4.trim().equalsIgnoreCase("ITEMS")) {
                    this.restoreitems(fileInputStream);
                }
                if (string4.trim().equalsIgnoreCase("FLAGS")) {
                    this.restoreflags(fileInputStream);
                }
                if (!string4.trim().equalsIgnoreCase("CHARACTERS")) continue;
                this.restorecharacters(fileInputStream);
            }
            vdu.Transmit("Restore successful.", this);
            game.displaylocation(this);
            return true;
        }
        catch (IOException iOException) {
            vdu.Transmit("Unable to read from file - restore state failed.", this);
            iOException.printStackTrace();
            return false;
        }
    }

    private void restoreplayer(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (string.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(string, "Name")) {
                this.Name = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CanSee")) {
                this.CanSee = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "ChanceOfHitting")) {
                this.ChanceOfHitting = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "CurrentLocation")) {
                this.CurrentLocation = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "DamageIndicator")) {
                this.DamageIndicator = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "DisplayName")) {
                this.DisplayName = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "HitPoints")) {
                this.HitPoints = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "ItemsCarried")) {
                this.ItemsCarried = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "Money")) {
                this.Money = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "Score")) {
                this.Score = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "SizeCarried")) {
                this.SizeCarried = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "Turns")) {
                this.Turns = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "WeightCarried")) {
                this.WeightCarried = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "CP1")) {
                this.CP1 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP2")) {
                this.CP2 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP3")) {
                this.CP3 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP4")) {
                this.CP4 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP5")) {
                this.CP5 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP6")) {
                this.CP6 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP7")) {
                this.CP7 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP8")) {
                this.CP8 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP9")) {
                this.CP9 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP10")) {
                this.CP10 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP11")) {
                this.CP11 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP12")) {
                this.CP12 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP13")) {
                this.CP13 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP14")) {
                this.CP14 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP15")) {
                this.CP15 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP16")) {
                this.CP16 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP17")) {
                this.CP17 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP18")) {
                this.CP18 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP19")) {
                this.CP19 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP20")) {
                this.CP20 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP21")) {
                this.CP21 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP22")) {
                this.CP22 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP23")) {
                this.CP23 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP24")) {
                this.CP24 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP25")) {
                this.CP25 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP26")) {
                this.CP26 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP27")) {
                this.CP27 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP28")) {
                this.CP28 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP29")) {
                this.CP29 = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CP30")) {
                this.CP30 = data.getpropvalue_string(string);
            }
            if (string.trim().startsWith("NV")) {
                parsestring parsestring2 = new parsestring(string, this, " ");
                String string2 = (String)parsestring2.vwords.get(2);
                String string3 = (String)parsestring2.vwords.get(3);
                this.setNameValue(string2, string3);
            }
            string = data.decrypt(data.readline(fileInputStream));
        }
    }

    private void restorelocations(FileInputStream fileInputStream) {
        location location2 = null;
        String string = data.decrypt(data.readline(fileInputStream));
        while (string.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(string, "ID")) {
                int n = 1;
                long l = data.getpropvalue_long(string);
                while (n <= data.olocations.getCount()) {
                    location2 = (location)data.olocations.get(n);
                    if (location2.ID == l) break;
                    ++n;
                }
            }
            if (data.comparebuff(string, "Name")) {
                location2.Name = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "ImagePath")) {
                location2.ImagePath = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "Description")) {
                location2.Description = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "IsDark")) {
                location2.IsDark = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "N")) {
                location2.N = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "S")) {
                location2.S = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "E")) {
                location2.E = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "W")) {
                location2.W = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "U")) {
                location2.U = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "D")) {
                location2.D = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "NE")) {
                location2.NE = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "NW")) {
                location2.NW = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "SE")) {
                location2.SE = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "SW")) {
                location2.SW = data.getpropvalue_long(string);
            }
            if (string.trim().startsWith("NV")) {
                parsestring parsestring2 = new parsestring(string, new player(), " ");
                String string2 = (String)parsestring2.vwords.get(2);
                String string3 = (String)parsestring2.vwords.get(3);
                location2.setNameValue(string2, string3);
            }
            string = data.decrypt(data.readline(fileInputStream));
        }
    }

    private void restoreitems(FileInputStream fileInputStream) {
        item item2 = null;
        String string = data.decrypt(data.readline(fileInputStream));
        while (string.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(string, "ID")) {
                int n = 1;
                long l = data.getpropvalue_long(string);
                while (n <= data.oitems.getCount()) {
                    item2 = (item)data.oitems.get(n);
                    if (item2.ID == l) break;
                    ++n;
                }
            }
            if (data.comparebuff(string, "Name")) {
                item2.Name = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CurrentLocation")) {
                item2.CurrentLocation = data.getpropvalue_long(string);
            }
            if (item2 != null && item2.CurrentLocation > location.PLAYERBASE && item2.CurrentLocation < location.CONTAINERBASE) {
                item2.CurrentLocation = location.PLAYERBASE + (long)this.Index;
            }
            if (data.comparebuff(string, "Weight")) {
                item2.Weight = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "Description")) {
                item2.Description = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "UserBooleans")) {
                item2.UserBooleans = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "NounID")) {
                item2.NounID = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "IsLightSource")) {
                item2.IsLightSource = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "IsLit")) {
                item2.IsLit = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "IsWorn")) {
                item2.IsWorn = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "IsWeapon")) {
                item2.IsWeapon = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "HasSurface")) {
                item2.HasSurface = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "CanBeLaidOn")) {
                item2.CanBeLaidOn = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "CanBeStoodOn")) {
                item2.CanBeStoodOn = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "CanBeGotIn")) {
                item2.CanBeGotIn = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "CanBeSatOn")) {
                item2.CanBeSatOn = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "DefaultExamine")) {
                item2.DefaultExamine = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "IsContainer")) {
                item2.IsContainer = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "IsEdible")) {
                item2.IsEdible = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "EdibleHitPoints")) {
                item2.EdibleHitPoints = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "IsWearable")) {
                item2.IsWearable = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "IsReadable")) {
                item2.IsReadable = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "ReadableText")) {
                item2.ReadableText = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "Size")) {
                item2.Size = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "DamageIndicator")) {
                item2.DamageIndicator = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "Invisible")) {
                item2.Invisible = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "IsFixed")) {
                item2.IsFixed = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "CanOpenClose")) {
                item2.CanOpenClose = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "FixedMessage")) {
                item2.FixedMessage = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "IsSubItem")) {
                item2.IsSubItem = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "SubItemOf")) {
                item2.SubItemOf = data.getpropvalue_long(string);
            }
            if (string.trim().startsWith("NV")) {
                parsestring parsestring2 = new parsestring(string, new player(), " ");
                String string2 = (String)parsestring2.vwords.get(2);
                String string3 = (String)parsestring2.vwords.get(3);
                item2.setNameValue(string2, string3);
            }
            string = data.decrypt(data.readline(fileInputStream));
        }
    }

    private void restorecharacters(FileInputStream fileInputStream) {
        character character2 = null;
        String string = data.decrypt(data.readline(fileInputStream));
        while (string.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(string, "ID")) {
                int n = 1;
                long l = data.getpropvalue_long(string);
                while (n <= data.ocharacters.getCount()) {
                    character2 = (character)data.ocharacters.get(n);
                    if (character2.ID == l) break;
                    ++n;
                }
            }
            if (data.comparebuff(string, "Name")) {
                character2.Name = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "CurrentLocation")) {
                character2.CurrentLocation = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "Description")) {
                character2.Description = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "NounID")) {
                character2.NounID = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "TimerInterval")) {
                character2.TimerInterval = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "DefaultExamine")) {
                character2.DefaultExamine = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "HitPoints")) {
                character2.HitPoints = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "DamageIndicator")) {
                character2.DamageIndicator = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "AutoAttack")) {
                character2.AutoAttack = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "AttackWhenAttacked")) {
                character2.AttackWhenAttacked = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "Money")) {
                character2.Money = data.getpropvalue_long(string);
            }
            if (string.trim().startsWith("NV")) {
                parsestring parsestring2 = new parsestring(string, new player(), " ");
                String string2 = (String)parsestring2.vwords.get(2);
                String string3 = (String)parsestring2.vwords.get(3);
                character2.setNameValue(string2, string3);
            }
            string = data.decrypt(data.readline(fileInputStream));
        }
    }

    private void restoreflags(FileInputStream fileInputStream) {
        int n = 1;
        String string = data.decrypt(data.readline(fileInputStream));
        while (string.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(string, "index")) {
                n = (int)data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "Value")) {
                data.oflags[n].Value = data.getpropvalue_string(string);
            }
            string = data.decrypt(data.readline(fileInputStream));
        }
    }

    private void writeline(FileOutputStream fileOutputStream, String string) {
        string = data.encrypt(string);
        byte[] byArray = string.getBytes();
        try {
            fileOutputStream.write(byArray);
            byte[] byArray2 = new byte[]{13, 10};
            fileOutputStream.write(byArray2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vdu.println("Error writing to file - " + exception.getMessage());
            return;
        }
    }

    private void writelineunencrypted(FileOutputStream fileOutputStream, String string) {
        byte[] byArray = string.getBytes();
        try {
            fileOutputStream.write(byArray);
            byte[] byArray2 = new byte[]{13, 10};
            fileOutputStream.write(byArray2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vdu.println("Error writing to file - " + exception.getMessage());
            return;
        }
    }

    public String getNameValue(String string) {
        int n = 1;
        namevaluepair namevaluepair2 = null;
        while (n <= this.NameValues.getCount()) {
            namevaluepair2 = (namevaluepair)this.NameValues.get(n);
            if (namevaluepair2.Name.equalsIgnoreCase(string)) {
                return namevaluepair2.Value;
            }
            ++n;
        }
        return "0";
    }

    public void setNameValue(String string, String string2) {
        int n = 1;
        namevaluepair namevaluepair2 = null;
        while (n <= this.NameValues.getCount()) {
            namevaluepair2 = (namevaluepair)this.NameValues.get(n);
            if (namevaluepair2.Name.equalsIgnoreCase(string)) {
                namevaluepair2.Value = string2;
                return;
            }
            ++n;
        }
        namevaluepair2 = new namevaluepair();
        namevaluepair2.Name = string;
        namevaluepair2.Value = string2;
        this.NameValues.add(namevaluepair2);
    }

    public void askParserQuestion(parsestring parsestring2, int n) {
        this.LastParser = parsestring2;
        this.LastQReplacesNoun = n;
        this.LastParserAskedQuestion = true;
    }
}

