/***************************************************************************
 *                                                                         *
 * Copyright (C) 2006 by Mark J. Tilford                                   *
 *                                                                         *
 * This file is part of Geas.                                              *
 *                                                                         *
 * Geas is free software; you can redistribute it and/or modify            *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation; either version 2 of the License, or       *
 * (at your option) any later version.                                     *
 *                                                                         *
 * Geas is distributed in the hope that it will be useful,                 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with Geas; if not, write to the Free Software                     *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *                                                                         *
 ***************************************************************************/

#include <set>
#include "geasfile.hh"
#include "reserved_words.hh"
#include "readfile.hh"
#include "geas-util.hh"
#include "geas-impl.hh"
#include "general.hh"

using namespace std;

void report_error(string s);

reserved_words obj_tag_property ("look", "examine", "speak", "take", "alias", "prefix", "suffix", "detail", "displaytype", "gender", "article", "hidden", "invisible", (char *) NULL);

reserved_words room_tag_property ("look", "alias", "prefix", "indescription", "description", "north", "south", "east", "west", "northwest", "northeast", "southeast", "southwest", "up", "down", "out", (char *) NULL);

/*
const GeasBlock *find_by_name (const vector<GeasBlock> &v, string name)
{
  for (uint i = 0; i < v.size(); i ++)
    if (v[i].name == name)
      return &v[i];
  return NULL;
}
*/

const GeasBlock *GeasFile::find_by_name (string type, string name) const 
{
  //name = lcase (name);
  for (uint i = 0; i < size(type); i ++)
    {
      //cout << "find_by_name (" << type << ", " << name << "), vs. '" 
      //     << block(type, i).name << "'\n";
      //if (block(type, i).lname == name)
      if (block(type, i).name == name)
	return &block(type, i);
    }
  return NULL;
}

const GeasBlock &GeasFile::block (std::string type, uint index) const { 
  std::map<std::string, std::vector<int> >::const_iterator iter;
  iter = type_indecies.find(type);
  if (!(iter != type_indecies.end() && index < (*iter).second.size()))
    cout << "Unable to find type " << type << "\n";
      
  assert (iter != type_indecies.end() && index < (*iter).second.size());
  //assert (index >= 0 && index < size(type));
  return blocks[(*iter).second[index]]; 
}

/*
ostream &operator<< (ostream &o, const vector<int> &v)
{
  o << "{";
  for (uint i = 0; i < v.size(); i ++)
    {
      if (i > 0)
	o << ", ";
      o << v[i];
    }
  o << "}";
  return o;
}
*/
//template<class T, class U> ostream &operator<< (ostream &o, const map<T, U> &m)
/*
ostream &operator<< (ostream &o, const map<string, vector<int> >& m)
{
  for (map<string, vector<int> >::const_iterator i = m.begin(); 
  //for (map<T, U>::const_iterator i = m.begin(); 
       i != m.end(); i ++)
    {
      o << "     " << (*i).first << " -> " << (*i).second << "\n";
    }
  return o;
}
*/

uint GeasFile::size (std::string type) const {
  //cout << "GeasFile::size (" << type << ")" << endl;

  std::map<std::string, std::vector<int> >::const_iterator iter;
  //cout << type_indecies << endl;
  iter = type_indecies.find(type);
  if (iter == type_indecies.end())
    {
      //cout << "  returning 0" << endl;
      return 0;
    }
  //cout << "  returning " << (*iter).second.size() << endl;
  return (*iter).second.size(); 
}


bool GeasFile::obj_has_property (string objname, string propname) const
{
  string tmp;
  return get_obj_property (objname, propname, tmp);
}

ostream &operator<< (ostream &, const set<string>&);

/**
 * Currently only works for actual objects, not rooms or the game
 */
set<string> GeasFile::get_obj_keys (string obj) const
{ 
  set<string> rv;
  get_obj_keys (obj, rv);
  return rv;
}

void GeasFile::get_obj_keys (string obj, set<string> &rv) const
{
  cout << "get_obj_keys (gf, <" << obj << ">)\n";
  //set<string> rv;

  uint c1, c2;
  string tok, line;
  reserved_words *rw = NULL;

  const GeasBlock *gb = find_by_name ("object", obj);
  rw = &obj_tag_property;

  if (gb == NULL)
    {
      cout << "No such object found, aborting\n";
      //return rv;
      return;
    }

  for (uint i = 0; i < gb->data.size(); i ++)
    {
      line = gb->data[i];
      cout << "  handling line <" << line << ">\n";
      tok = first_token (line, c1, c2);
      if (tok == "properties")
	{
	  tok = next_token (line, c1, c2);
	  if (is_param(tok))
	    {
	      vector<string> params = split_param (param_contents (tok));
	      for (uint j = 0; j < params.size(); j ++)
		{
		  cout << "   handling parameter <" << params[j] << ">\n";
		  uint k = params[j].find('=');
		  if (starts_with (params[j], "not "))
		    {
		      rv.insert (trim (params[j].substr(4)));
		      cout << "     adding <" << trim (params[j].substr(4))
			   << ">\n";
		    }
		  else if (k == string::npos)
		    {
		      rv.insert (params[j]);
		      cout << "     adding <" << params[j] << ">\n";
		    }
		  else
		    {
		      rv.insert (trim (params[j].substr(0, k)));
		      cout << "     adding <" << trim (params[j].substr(0, k))
			   << ">\n";
		    }
		}
	    }
	}
      else if (tok == "type")
	{
	  tok = next_token (line, c1, c2);
	  if (is_param (tok))
	    get_type_keys (param_contents(tok), rv);
	}
      //else if (has (tag_property, tok) && tag_property[tok])
      else if (rw != NULL && rw->has(tok)) 
	{
	  string tok1 = next_token (line, c1, c2);
	  if (is_param (tok1))
	    rv.insert (tok);
        }
    }

  cout << "Returning (" << rv << ")\n";
}

void GeasFile::get_type_keys (string typen, set<string> &rv) const
{
  cout << "get_type_keys (" << typen << ", " << rv << ")\n";
  const GeasBlock* gb = find_by_name ("type", typen);
  if (gb == NULL)
    {
      cout << "  g_t_k: Nonexistent type\n";
      return;
    }
  string line, tok;
  uint c1, c2;
  for (uint i = 0; i < gb->data.size(); i ++)
    {
      line = gb->data[i];
      //cout << "    g_t_k: Handling line '" << line << "'\n";
      tok = first_token (line, c1, c2);
      if (tok == "type")
	{
	  tok = next_token (line, c1, c2);
	  if (is_param(tok))
	    {
	      get_type_keys (param_contents(tok), rv);
	      cout << "      g_t_k: Adding <" << tok << "> to rv: " << rv << "\n";
	    }
	}
      else if (tok == "action")
	{
	  cout << "       action, skipping\n";
	}
      else
	{
	  uint ch = line.find ('=');
	  if (ch != string::npos)
	    {
	      rv.insert (trim (line.substr (0, ch)));
	      cout << "      adding <" << trim (line.substr (0, ch)) << ">\n";
	    }
	}
    }
  cout << "Returning (" << rv << ")\n";
}

bool GeasFile::get_obj_property (string objname, string propname, string &string_rv) const
{
  //cout << "g_o_p: Getting prop <" << propname << "> of obj <" << objname << ">\n";
  string_rv = "!";
  bool bool_rv = false;

  //cout << "obj_types == " << obj_types << endl;
  /*
  cout << "obj_types == \n";
  for (map<string, string>::const_iterator iter = obj_types.begin();
       iter != obj_types.end(); iter ++)
    cout << "  " << (*iter).first << " -> " << (*iter).second << "\n";
  cout << ".\n";
  */

  if (!has (obj_types, objname))
    {
      //gi->debug_print ("Checking property of nonexistent object " + objname);
      cerr << "Checking property of nonexistent object " + objname << endl;
      return false;
    }
  string objtype = (*obj_types.find(objname)).second;

  const GeasBlock *block = find_by_name (objtype, objname);

  string not_prop = "not " + propname;
  uint c1, c2;
  assert (block != NULL);
  //assert (block->data != NULL);
  for (uint i = 0; i < block->data.size(); i ++)
    {
      string line = block->data[i];
      //cout << "  g_o_p: Handling line <" << line << ">\n";
      string tok = first_token (line, c1, c2);
      if (tok == "type")
	{
	  tok = next_token (line, c1, c2);
	  if (is_param (tok))
	    get_type_property (param_contents(tok), propname, bool_rv, string_rv);
	  else
	    {
	      //gi->debug_print ("Expected parameter for type in " + line);
	      cerr << "Eg_o_p: xpected parameter for type in " + line << endl;
	    }
	}
      else if (tok == "properties")
	{
	  tok = next_token (line, c1, c2);
	  if (!is_param(tok))
	    {
	      //gi->debug_print ("Expected param on line " + line);
	      cerr << "g_o_p: Expected param on line " + line << endl;
	      continue;
	    }
	  vector<string> props = split_param (param_contents (tok));
	  for (uint j = 0; j < props.size(); j ++)
	    {
	      //cerr << "    g_o_p: Comparing against <" << props[j] << ">\n";
	      uint index;
	      if (props[j] == propname)
		{
		  //cerr << "      g_o_p: Present but empty, blanking\n";
		  string_rv = "";
		  bool_rv = true;
		}
	      else if (props[j] == not_prop)
		{
		  //cerr << "      g_o_p: Negation, removing\n";
		  string_rv = "!";
		  bool_rv = false;
		}
	      else if ((index = props[j].find ('=')) != string::npos &&
		       (trim (props[j].substr (0, index)) == propname))
		{
		  string_rv = props[j].substr (index+1);
		  bool_rv = true;
		  //cout << "      g_o_p: Normal prop, now to <" << string_rv << ">\n";
		}
	    }
	}
    }
  //cout << "g_o_p: Ultimately returning " << (bool_rv ? "true" : "false")
  //     << ", with string <" << string_rv << ">\n\n";
  return bool_rv;
}

void GeasFile::get_type_property (string typenamex, string propname, bool &bool_rv, string &string_rv) const
{
  cout << "  Checking type <" << typenamex << "> for prop <" << propname 
       << ">\n";
  const GeasBlock *block = find_by_name ("type", typenamex);
  if (block == NULL)
    {
      //gi->debug_print ("Object of nonexistent type " + typenamex);
      cerr << "Object of nonexistent type " + typenamex << endl;
      return;
    }
  for (uint i = 0; i < block->data.size(); i ++)
    {
      string line = block->data[i];
      //cout << "    Comparing vs. line <" << line << ">\n";
      uint c1, c2;
      string tok = first_token (line, c1, c2);
      if (tok == propname)
	{
	  //cout << "      match...";
	  tok = next_token (line, c1, c2);
	  if (tok == "")
	    {
	      bool_rv = true;
	      string_rv = "";
	      //cout << " present but empty\n";
	    }
	  else if (tok == "=")
	    {
	      bool_rv = true;
	      string_rv = trim (line.substr (c2));
	      //cout << " now <" << string_rv << ">\n";
	    }
	  else
	    {
	      cerr << "Bad line while checking " << typenamex << " for prop "
		   << propname << ": " << line << endl;
	    }
	}
      else if (tok == "type")
	{
	  tok = next_token (line, c1, c2);
	  if (is_param (tok))
	    get_type_property (param_contents(tok), propname, bool_rv, string_rv);
	}
    }
}
	      



bool GeasFile::get_obj_action (string objname, string propname, string &string_rv) const
{
  //cout << "g_o_a: Getting action <" << propname << "> of object <" << objname << ">\n";
  string_rv = "!";
  bool bool_rv = false;

  //cout << "obj_types == " << obj_types << endl;
  /*
  cout << "obj_types == \n";
  for (map<string, string>::const_iterator iter = obj_types.begin();
       iter != obj_types.end(); iter ++)
    cout << "  " << (*iter).first << " -> " << (*iter).second << "\n";
  cout << ".\n";
  */
  if (!has (obj_types, objname))
    {
      //gi->debug_print ("Checking property of nonexistent object " + objname);
      cerr << "Checking action of nonexistent object " + objname << endl;
      return false;
    }
  string objtype = (*obj_types.find(objname)).second;

  //reserved_words *rw;

  const GeasBlock *block = find_by_name (objtype, objname);
  string not_prop = "not " + propname;
  uint c1, c2;
  for (uint i = 0; i < block->data.size(); i ++)
    {
      string line = block->data[i];
      //cout << "  g_o_a: Handling line <" << line << ">\n";
      string tok = first_token (line, c1, c2);
      if (tok == "type")
	{
	  tok = next_token (line, c1, c2);
	  if (is_param (tok))
	    get_type_action (param_contents(tok), propname, bool_rv, string_rv);
	  else
	    {
	      //gi->debug_print ("Expected parameter for type in " + line);
	      cerr << "Expected parameter for type in " + line;
	    }
	}
      /*
      else if (rw != NULL && tok == propname && rw->has(propname))
	{
	  tok = next_token (line, c1, c2);
	  if (is_param(tok))
	    {
	      cout << "   Parameter, skipping\n";
	    }
	  else
	    {
	      //cout << "   Action, skipping\n";
	      cout << "   Action, string_rv is now <" << string_rv << ">\n";
	      string_rv = line.substr (c1);
	      bool_rv = true;
	    }
	}
      */
      else if (tok == "action")
	{
	  tok = next_token (line, c1, c2);
	  if (is_param(tok) && param_contents(tok) == propname)
	    {
	      if (c2 + 1 < line.length())
		string_rv = line.substr (c2 + 1);
	      else
		string_rv = "";
	      bool_rv = true;
	      //cout << "   Action line, string_rv now <" << string_rv << ">\n";
	    }
	}
    }

  //cout << "g_o_a: Ultimately returning value " << (bool_rv ? "true" : "false")  << ", with string <" << string_rv << ">\n\n";

  return bool_rv;
}

void GeasFile::get_type_action (string typenamex, string propname, bool &bool_rv, string &string_rv) const
{
  cout << "  Checking type <" << typenamex << "> for prop <" << propname 
       << ">\n";
  const GeasBlock *block = find_by_name ("type", typenamex);
  if (block == NULL)
    {
      //gi->debug_print ("Object of nonexistent type " + typenamex);
      cerr << "Object of nonexistent type " + typenamex << endl;
      return;
    }
  for (uint i = 0; i < block->data.size(); i ++)
    {
      string line = block->data[i];
      cout << "    Comparing vs. line <" << line << ">\n";
      uint c1, c2;
      string tok = first_token (line, c1, c2);
      if (tok == propname)
	{
	  cout << "      match...";
	  tok = next_token (line, c1, c2);
	  if (tok == "")
	    {
	      bool_rv = true;
	      string_rv = "";
	      cout << " present but empty\n";
	    }
	  else if (tok == "=")
	    {
	      bool_rv = true;
	      string_rv = trim (line.substr (c2));
	      cout << " now <" << string_rv << ">\n";
	    }
	  else
	    {
	      cout << " huh?\n";
	    }
	}
      else if (tok == "type")
	{
	  tok = next_token (line, c1, c2);
	  if (is_param (tok))
	    get_type_property (param_contents(tok), propname, bool_rv, string_rv);
	}
    }
}
 
void GeasFile::register_block (string blockname, string blocktype)
{
  //cout << "registering block " << blockname << " / " << blocktype << endl;
  if (has (obj_types, blockname))
    throw string ("Trying to register block of named <") + blockname +
     "> of type <" + blocktype + "> when there is already one, of type <" +
      obj_types[blockname] + ">";
  obj_types[blockname] = blocktype;
}

string GeasFile::static_svar_lookup (string varname) const
{
  cout << "static_svar_lookup(" << varname << ")" << endl;
  //varname = lcase (varname);
  for (uint i = 0; i < size("variable"); i ++)
    //if (blocks[i].lname == varname)
    if (blocks[i].name == varname)
      {
	string rv;
	string tok;
	uint c1, c2;
	bool found_typeline;
	for (uint j = 0; j < blocks[i].data.size(); j ++)
	  {
	    string line = blocks[i].data[j];
	    tok = first_token (line, c1, c2);
	    if (tok == "type")
	      {
		tok = next_token (line, c1, c2);
		if (tok == "numeric")
		  throw string ("Trying to evaluate int var '" + varname + 
				"' as string");
		if (tok != "string")
		  throw string ("Bad variable type " + tok);
		found_typeline = true;
	      }
	    else if (tok == "value")
	      {
		tok = next_token (line, c1, c2);
		if (!is_param (tok))
		  throw string ("Expected param after value in " + line);
		rv = param_contents (tok);
	      }
	  }
	if (!found_typeline)
	  throw string (varname + " is a numeric variable");
	cout << "static_svar_lookup(" << varname << ") -> \"" << rv << "\"" << endl;
	return rv;
      }
  cerr << "Variable '" << varname << "' not found" << endl;
  return "";
}

string GeasFile::static_ivar_lookup (string varname) const
{
  //varname = lcase (varname);
  for (uint i = 0; i < size("variable"); i ++)
    //if (blocks[i].lname == varname)
    if (blocks[i].name == varname)
      {
	string rv;
	string tok;
	uint c1, c2;
	for (uint j = 0; j < blocks[i].data.size(); j ++)
	  {
	    string line = blocks[i].data[j];
	    tok = first_token (line, c1, c2);
	    if (tok == "type")
	      {
		tok = next_token (line, c1, c2);
		if (tok == "string")
		  throw string ("Trying to evaluate string var '" + varname + 
				"' as numeric");
		if (tok != "numeric")
		  throw string ("Bad variable type " + tok);
	      }
	    else if (tok == "value")
	      {
		tok = next_token (line, c1, c2);
		if (!is_param (tok))
		  throw string ("Expected param after value in " + line);
		rv = param_contents (tok);
	      }
	  }
	return rv;
      }
  cerr << "Variable '" << varname << "' not found" << endl;
  return "-32768";
}

string GeasFile::static_eval (string input) const
{
  //cout << "static_eval (" << input << ")" << endl;
  string rv = "";
  for (uint i = 0; i < input.length(); i ++)
    {
      if (input[i] == '#')
	{
	  uint j;
	  for (j = i+1; j < input.length() && input[j] != '#'; j ++)
	    ;
	  if (j == input.length())
	    throw string ("Error processing '" + input + "', odd hashes");
	  uint k;
	  for (k = i + 1; k < j && input[k] != ':'; k ++)
	    ;
	  if (k == ':')
	    {
	      string objname;
	      if (input[i+1] == '(' && input[k-1] == ')')
		objname = static_svar_lookup (input.substr (i+2, k-i-4));
	      else
		objname = input.substr (i+1, k-i-2);
	      cout << "  objname == '" << objname << endl;
	      //rv += get_obj_property (objname, input.substr (k+1, j-k-2));
	      string tmp;
	      bool had_var;
	      
	      string objprop = input.substr (k+1, j-k-2);
	      cout << "  objprop == " << objprop << endl;
	      had_var = get_obj_property (objname, objprop, tmp);
	      rv += tmp;
	      if (!had_var)
		cerr << "Requesting nonexistent property '" + objprop +
		  "' of object '" + objname + "'." << endl;
	    }
	  else
	    {
	      cout << "i == " << i << ", j == " << j << ", length is " << input.length() << endl;
	      cout << "Looking up static var " << input.substr (i+1, j-i-1) << endl;
	      rv += static_svar_lookup (input.substr (i+1, j-i-1));
	    }
	  i = j;
	}
      else if (input[i] == '%')
	{
	  uint j;
	  for (j = i; j < input.length() && input[j] != '%'; j ++)
	    ;
	  if (j == input.length())
	    throw string ("Error processing '" + input + "', unmatched %");
	  rv += static_ivar_lookup (input.substr (i+1, j-i-2));
	  i = j;
	}
      else
	rv += input[i];
    }
  if (rv != input)
    cout << "*** CHANGED ***\n";
  //cout << "static_eval (" << input << ") --> \"" << rv << "\"" << endl;
  return rv;
}
