Property follow_action 0;
Property follow_object 0;
Attribute followable;

Class   followclass
 has    followable,
 with   follow_action 0,
        follow_object 0;

class Bulkhead 
  with
    name "emergency" "bulkhead" "bulk" "yellow" "letter" "letters"
         "door" "hatch", 
    article "an",
    before
    [;Open: 
      OpenBulkMsg (); rtrue;    
      Unlock:
        if ((second == Steel1) || (second == Steel2))
        {
          "", (The) second, " doesn't seem to be able to exert enough force 
          or leverage on it's own, to open ", (the) Bulkhead, ".";
        }
      Close: if (self has open)
               "I don't think you want to do that, if you close it, it's so
                mangled you'll probably never get it open again.";
      ThrownAt:
      if (noun has worn)
        "You will have to remove ", (the) noun, " first.";
       move noun to Location;
      if ((noun has big) || (noun has huge)) 
        "", (The) second, " is built to withstand hull breaches and radiation
         leaks, so ", (the) noun, " has no effect what so ever and drops
         uselessly on the deck.";
      "", (The) Noun, " is too small to have any effect, bounces off ",
       (the) Viewport, " and drops uselessly on the deck.";    
    ],
    has static concealed ~open openable legible;

[OpenBulkMsg;
 "Bulkheads are computer controlled, and too strong to be opened 
  by hand. The only way to open them is to find the controlling 
  computer, which may not be in this section, unless of course you 
  happen to have a hydraulic ram."; 
];

Class Map with name "map" "maps" "plan" "holo" "holographic";

class Room
  with
    name "room",
    has light;

class Book
  has legible;

class Class_Table 
  with
    name "table",
    description "Standard Patrol Issue.",
    has scenery supporter; 

class Class_Chair 
  with
    name "chair" "seat" "couch",
    description "Standard Patrol Issue. It looks very comfortable.",
    before
    [; Exit: if (Player notin self)
               "You're not in ", (the) self, "."; ],
    has scenery supporter enterable open;

Class Steel 
  with name "sawn" "bar",
       short_name "sawn bar",
       plural "sawn bars",
       description "The bar is about a metre long, and both its ends 
                    have been roughly sawn.",
       parse_name
       [ i j w;
         if (parser_action==##TheSame)
         { if ((parser_one.&name)-->0 == (parser_two.&name)-->0) return -1;
           return -2;
         }
         w=(self.&name)-->0;
         for (::i++)
         {   j=NextWord();
             if (j=='bars') 
               parser_action=##PluralFound;
             else if ((j~='bar' or w) && (j~='sawn' or w)) 
               return i;
         }
       ],
       before
       [; cut: "You've removed this one already."; ],
  has big is_bar;

Object Lock1 "lock"
  with
    name "lock",
    before
    [;lock: <<LOCK CABINET SECOND>>;
      unlock: <<UNLOCK CABINET SECOND>>;
      receive: 
      if (Cabinet has locked)
      {
        print "(to unlock ", (the) Cabinet, ")^";
        <<UNLOCK CABINET NOUN>>;
      }
      print "(to lock ", (the) Cabinet, ")^";
      <<LOCK CABINET NOUN>>;
      take: "That's part of ", (the) Cabinet, "."; 
    ],
    found_in Cabinet,
    has scenery;

Object Lock2 "lock"
  with
    name "lock",
    before
    [;lock: <<LOCK DENTIST_DOOR SECOND>>;
      unlock: <<UNLOCK DENTIST_DOOR SECOND>>;
      receive: 
      if (Dentist_Door has locked)
      {
        print "(to unlock ", (the) Dentist_Door, ")^";
        <<UNLOCK DENTIST_DOOR NOUN>>;
      }
      print "(to lock ", (the) Dentist_Door, ")^";
      <<LOCK DENTIST_DOOR NOUN>>;
      take: "That's part of ", (the) Dentist_Door, "."; 
    ],
    found_in Waiting_Room,
    has scenery;

Object Lock3 "lock"
  with
    name "lock",
    before
    [;lock: <<LOCK TOOLBOX SECOND>>;
      unlock: <<UNLOCK TOOLBOX SECOND>>;
      receive: 
      if (Toolbox has locked)
      {
        print "(to unlock ", (the) Toolbox, ")^";
        <<UNLOCK TOOLBOX NOUN>>;
      }
      print "(to lock ", (the) Toolbox, ")^";
      <<LOCK TOOLBOX NOUN>>;
      take: "That's part of ", (the) Toolbox, "."; 
    ],
    has scenery;

Object Lock4 "lock"
  with
    name "lock",
    description 
      "It looks like one of those new sophisticated all-purpose-key-proof
       locks.",
    before
    [;lock: <<LOCK CAGE SECOND>>;
      unlock: <<UNLOCK CAGE SECOND>>;
      receive: 
      if (Cage has locked)
      {
        print "(to unlock ", (the) Cage, ")^";
        <<UNLOCK CAGE NOUN>>;
      }
      print "(to lock ", (the) Cage, ")^";
      <<LOCK CAGE NOUN>>;
      take: "That's part of ", (the) Cage, "."; 
    ],
    found_in Cage,
    has scenery;

