/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import java.util.ArrayList;
import java.util.List;
import org.zmpp.encoding.ZsciiString;
import org.zmpp.vm.InputLine;
import org.zmpp.vmutil.RingBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHistory {
    private static final int NUM_ENTRIES = 5;
    private RingBuffer<HistoryEntry> history = new RingBuffer(5);
    private int historyIndex;
    private int historySizeAtReset;
    private InputLine inputline;

    public CommandHistory(InputLine inputLine) {
        this.inputline = inputLine;
    }

    public int getCurrentIndex() {
        return this.historyIndex;
    }

    public boolean isHistoryChar(short s) {
        return s == 129 || s == 130;
    }

    public void reset() {
        this.historySizeAtReset = this.historyIndex = this.history.size();
        for (int i = 0; i < this.history.size(); ++i) {
            HistoryEntry historyEntry = this.history.get(i);
            historyEntry.edited.clear();
            historyEntry.edited.addAll(historyEntry.original);
        }
    }

    public void addInputLine(List<Short> list) {
        HistoryEntry historyEntry = new HistoryEntry();
        historyEntry.original.addAll(list);
        historyEntry.edited.addAll(list);
        if (this.history.size() > this.historySizeAtReset) {
            this.history.set(this.history.size() - 1, historyEntry);
        } else {
            this.history.add(historyEntry);
        }
    }

    public int switchHistoryEntry(List<Short> list, int n, int n2, short s) {
        if (s == 129) {
            return this.processHistoryUp(list, n, n2);
        }
        return this.processHistoryDown(list, n, n2);
    }

    private int processHistoryUp(List<Short> list, int n, int n2) {
        int n3 = n2;
        if (this.historyIndex > 0) {
            this.storeCurrentInput(list);
            --this.historyIndex;
            n3 = this.fillInputLineFromHistory(list, n, n2);
        }
        return n3;
    }

    private int processHistoryDown(List<Short> list, int n, int n2) {
        int n3 = n2;
        if (this.historyIndex < this.history.size() - 1) {
            this.storeCurrentInput(list);
            ++this.historyIndex;
            n3 = this.fillInputLineFromHistory(list, n, n2);
        }
        return n3;
    }

    private int fillInputLineFromHistory(List<Short> list, int n, int n2) {
        int n3 = this.deleteInputLine(list, n2);
        if (this.history.size() > this.historyIndex) {
            List<Short> list2 = this.history.get((int)this.historyIndex).edited;
            for (int i = 0; i < list2.size(); ++i) {
                n3 = this.inputline.addChar(list, n, n3, list2.get(i));
            }
        }
        return n3;
    }

    private void storeCurrentInput(List<Short> list) {
        if (this.historyIndex < this.history.size()) {
            this.history.get((int)this.historyIndex).edited.clear();
            this.history.get((int)this.historyIndex).edited.addAll(list);
        } else {
            HistoryEntry historyEntry = new HistoryEntry();
            historyEntry.original.addAll(list);
            historyEntry.edited.addAll(list);
            this.history.add(historyEntry);
        }
    }

    private int deleteInputLine(List<Short> list, int n) {
        int n2 = list.size();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            n3 = this.inputline.deletePreviousChar(list, n3);
        }
        return n3;
    }

    private class HistoryEntry {
        public List<Short> original = new ArrayList<Short>();
        public List<Short> edited = new ArrayList<Short>();

        public String toString() {
            int n;
            short[] sArray = new short[this.original.size()];
            short[] sArray2 = new short[this.edited.size()];
            for (n = 0; n < this.original.size(); ++n) {
                sArray[n] = this.original.get(n);
            }
            for (n = 0; n < this.edited.size(); ++n) {
                sArray2[n] = this.edited.get(n);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" (" + new ZsciiString(sArray));
            stringBuilder.append(", ");
            stringBuilder.append(new ZsciiString(sArray2) + " )");
            return stringBuilder.toString();
        }
    }
}

