/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.instructions;

import org.zmpp.base.MemoryReadAccess;
import org.zmpp.instructions.AbstractInstruction;
import org.zmpp.instructions.InstructionStaticInfo;
import org.zmpp.instructions.PrintLiteralStaticInfo;
import org.zmpp.vm.Machine;

public class PrintLiteralInstruction
extends AbstractInstruction {
    private int instructionAddress;
    private MemoryReadAccess memaccess;

    public PrintLiteralInstruction(Machine machine, int n, MemoryReadAccess memoryReadAccess, int n2) {
        super(machine, n);
        this.memaccess = memoryReadAccess;
        this.instructionAddress = n2;
    }

    protected String getOperandString() {
        String string = this.getMachine().getGameData().getZCharDecoder().decode2Zscii(this.memaccess, this.instructionAddress + 1, 0).toString();
        return "\"" + string + "\"";
    }

    public AbstractInstruction.InstructionForm getInstructionForm() {
        return AbstractInstruction.InstructionForm.SHORT;
    }

    public AbstractInstruction.OperandCount getOperandCount() {
        return AbstractInstruction.OperandCount.C0OP;
    }

    public void setLength(int n) {
    }

    public int getLength() {
        return this.getLiteralLengthInBytes() + 1;
    }

    protected InstructionStaticInfo getStaticInfo() {
        return PrintLiteralStaticInfo.getInstance();
    }

    public AbstractInstruction.InstructionResult doInstruction() {
        if (this.getOpcode() == 3) {
            this.getMachine().getOutput().printZString(this.instructionAddress + 1);
            this.getMachine().getOutput().newline();
            this.returnFromRoutine((short)1);
        } else if (this.getOpcode() == 2) {
            this.getMachine().getOutput().printZString(this.instructionAddress + 1);
            this.nextInstruction();
        } else {
            this.throwInvalidOpcode();
        }
        return new AbstractInstruction.InstructionResult(1, false);
    }

    public int getLiteralAddress() {
        return this.instructionAddress + 1;
    }

    private int getLiteralLengthInBytes() {
        int n = this.instructionAddress + 1;
        int n2 = 0;
        do {
            n2 = this.memaccess.readUnsignedShort(n);
            n += 2;
        } while ((n2 & 0x8000) == 0);
        return n - (this.instructionAddress + 1);
    }
}

