/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import org.zmpp.base.MemoryAccess;
import org.zmpp.encoding.ZCharDecoder;
import org.zmpp.vm.ZObject;

public abstract class AbstractZObject
implements ZObject {
    private static final int MAX_NUM_PROPERTIES = 32;
    private MemoryAccess memaccess;
    private int address;
    private PropertyTable propertyTable;
    private ZCharDecoder decoder;

    public AbstractZObject(MemoryAccess memoryAccess, int n, ZCharDecoder zCharDecoder) {
        this.memaccess = memoryAccess;
        this.address = n;
        this.propertyTable = this.createPropertyTable();
        this.decoder = zCharDecoder;
    }

    protected abstract PropertyTable createPropertyTable();

    protected MemoryAccess getMemoryAccess() {
        return this.memaccess;
    }

    protected int getObjectAddress() {
        return this.address;
    }

    public boolean isAttributeSet(int n) {
        short s = this.memaccess.readUnsignedByte(this.address + n / 8);
        return (s & 128 >> (n & 7)) > 0;
    }

    public void setAttribute(int n) {
        int n2 = this.address + n / 8;
        short s = this.memaccess.readUnsignedByte(n2);
        s = (short)(s | 128 >> (n & 7));
        this.memaccess.writeUnsignedByte(n2, s);
    }

    public void clearAttribute(int n) {
        int n2 = this.address + n / 8;
        short s = this.memaccess.readUnsignedByte(n2);
        s = (short)(s & ~(128 >> (n & 7)));
        this.memaccess.writeUnsignedByte(n2, s);
    }

    public int getPropertiesDescriptionAddress() {
        return this.propertyTable.getDescriptionAddress();
    }

    public int getNumProperties() {
        return this.propertyTable.getNumProperties();
    }

    public int getPropertySize(int n) {
        short s = this.propertyTable.getPropertyIndex(n);
        return this.propertyTable.getSize(s);
    }

    public byte getPropertyByte(int n, int n2) {
        short s = this.propertyTable.getPropertyIndex(n);
        return this.propertyTable.getPropertyByte(s, n2);
    }

    public int getPropertyAddress(int n) {
        short s = this.propertyTable.getPropertyIndex(n);
        int n2 = this.propertyTable.getNumSizeBytesForPropertyIndex(s);
        return this.propertyTable.getPropertyAddressAt(s) + n2;
    }

    public boolean isPropertyAvailable(int n) {
        return this.propertyTable.getPropertyIndex(n) >= 0;
    }

    public int getNextProperty(int n) {
        if (n == 0) {
            return this.propertyTable.getPropertyNum(0);
        }
        short s = this.propertyTable.getPropertyIndex(n);
        return this.propertyTable.getPropertyNum(s + 1);
    }

    public void setPropertyByte(int n, int n2, byte by) {
        short s = this.propertyTable.getPropertyIndex(n);
        this.propertyTable.setPropertyByte(s, n2, by);
    }

    public String toString() {
        String string = this.decoder.decode2Zscii(this.memaccess, this.getPropertiesDescriptionAddress(), 0).toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("parent: " + this.getParent());
        stringBuilder.append(" sibling: " + this.getSibling());
        stringBuilder.append(" child: " + this.getChild());
        StringBuilder stringBuilder2 = new StringBuilder("attributes: [");
        for (int i = 0; i < 48; ++i) {
            if (!this.isAttributeSet(i)) continue;
            if (stringBuilder2.length() > "attributes: [".length()) {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(i);
        }
        stringBuilder2.append("]");
        StringBuilder stringBuilder3 = new StringBuilder();
        int n = 0;
        stringBuilder3.append(String.format("property table address: %04x\n", this.getPropertyTableAddress()));
        do {
            if ((n = this.getNextProperty(n)) == 0) continue;
            stringBuilder3.append("[" + n + "] ");
            int n2 = this.getPropertySize(n);
            for (int i = 0; i < n2; ++i) {
                stringBuilder3.append(String.format("%02x", this.getPropertyByte(n, i)) + " ");
            }
            stringBuilder3.append("\n");
        } while (n != 0);
        return "Description: \"" + string + "\"\n" + stringBuilder.toString() + "\n" + stringBuilder2.toString() + "\n" + stringBuilder3.toString();
    }

    abstract class PropertyTable {
        private int[] propertyAddresses = new int[32];
        private int numProperties = -1;

        public int getDescriptionAddress() {
            return AbstractZObject.this.getPropertyTableAddress() + 1;
        }

        private int getPropertyEntriesStart() {
            return AbstractZObject.this.getPropertyTableAddress() + this.getDescriptionHeaderSize();
        }

        private int getDescriptionHeaderSize() {
            int n = AbstractZObject.this.getPropertyTableAddress();
            return AbstractZObject.this.memaccess.readUnsignedByte(n) * 2 + 1;
        }

        protected abstract int getPropertySizeAtAddress(int var1);

        protected abstract int getNumPropertySizeBytes(int var1);

        protected int getPropertyAddressAt(int n) {
            if (n < 0) {
                return this.getPropertyEntriesStart();
            }
            if (this.propertyAddresses[n] == 0) {
                int n2 = this.getPropertyEntriesStart();
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    n3 = this.getPropertySizeAtAddress(n2);
                    n2 += n3 + this.getNumPropertySizeBytes(n2);
                }
                this.propertyAddresses[n] = n2;
            }
            return this.propertyAddresses[n];
        }

        public int getNumProperties() {
            if (this.numProperties < 0) {
                int n = 0;
                while (AbstractZObject.this.memaccess.readUnsignedByte(this.getPropertyAddressAt(n)) > 0) {
                    ++n;
                }
                this.numProperties = n;
            }
            return this.numProperties;
        }

        public int getSize(int n) {
            return this.getPropertySizeAtAddress(this.getPropertyAddressAt(n));
        }

        public byte getPropertyByte(int n, int n2) {
            int n3 = this.getPropertyAddressAt(n);
            return AbstractZObject.this.memaccess.readByte(n3 + this.getNumPropertySizeBytes(n3) + n2);
        }

        public void setPropertyByte(int n, int n2, byte by) {
            int n3 = this.getPropertyAddressAt(n);
            AbstractZObject.this.memaccess.writeByte(n3 + this.getNumPropertySizeBytes(n3) + n2, by);
        }

        public int getNumSizeBytesForPropertyIndex(int n) {
            return this.getNumPropertySizeBytes(this.getPropertyAddressAt(n));
        }

        public abstract short getPropertyNum(int var1);

        public short getPropertyIndex(int n) {
            for (int i = 0; i < this.getNumProperties(); ++i) {
                if (this.getPropertyNum(i) != n) continue;
                return (short)i;
            }
            return -1;
        }

        public int getDataLength() {
            int n = this.getDescriptionHeaderSize();
            for (int i = 0; i < this.getNumProperties(); ++i) {
                n += this.getSize(i) + 1;
            }
            return n;
        }
    }
}

