/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import org.zmpp.base.MemoryAccess;
import org.zmpp.encoding.ZCharDecoder;
import org.zmpp.vm.AbstractZObject;

public class ModernZObject
extends AbstractZObject {
    private static final int OFFSET_PARENT = 6;
    private static final int OFFSET_SIBLING = 8;
    private static final int OFFSET_CHILD = 10;
    private static final int OFFSET_PROPERTYTABLE = 12;

    public ModernZObject(MemoryAccess memoryAccess, int n, ZCharDecoder zCharDecoder) {
        super(memoryAccess, n, zCharDecoder);
    }

    protected AbstractZObject.PropertyTable createPropertyTable() {
        return new ModernPropertyTable();
    }

    public int getParent() {
        return this.getMemoryAccess().readUnsignedShort(this.getObjectAddress() + 6);
    }

    public void setParent(int n) {
        this.getMemoryAccess().writeUnsignedShort(this.getObjectAddress() + 6, n);
    }

    public int getSibling() {
        return this.getMemoryAccess().readUnsignedShort(this.getObjectAddress() + 8);
    }

    public void setSibling(int n) {
        this.getMemoryAccess().writeUnsignedShort(this.getObjectAddress() + 8, n);
    }

    public int getChild() {
        return this.getMemoryAccess().readUnsignedShort(this.getObjectAddress() + 10);
    }

    public void setChild(int n) {
        this.getMemoryAccess().writeUnsignedShort(this.getObjectAddress() + 10, n);
    }

    public int getPropertyTableAddress() {
        return this.getMemoryAccess().readUnsignedShort(this.getObjectAddress() + 12);
    }

    public static int getPropertyLengthAtData(MemoryAccess memoryAccess, int n) {
        if (n == 0) {
            return 0;
        }
        short s = memoryAccess.readUnsignedByte(n - 1);
        if ((s & 0x80) > 0) {
            int n2 = s & 0x3F;
            if (n2 == 0) {
                n2 = 64;
            }
            return n2;
        }
        return (s & 0x40) > 0 ? 2 : 1;
    }

    class ModernPropertyTable
    extends AbstractZObject.PropertyTable {
        ModernPropertyTable() {
        }

        protected int getNumPropertySizeBytes(int n) {
            short s = ModernZObject.this.getMemoryAccess().readUnsignedByte(n);
            return (s & 0x80) > 0 ? 2 : 1;
        }

        public short getPropertyNum(int n) {
            int n2 = this.getPropertyAddressAt(n);
            return (short)(ModernZObject.this.getMemoryAccess().readUnsignedByte(n2) & 0x3F);
        }

        protected int getPropertySizeAtAddress(int n) {
            return ModernZObject.getPropertyLengthAtData(ModernZObject.this.getMemoryAccess(), n + this.getNumPropertySizeBytes(n));
        }
    }
}

