/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.encoding;

import org.zmpp.base.MemoryReadAccess;
import org.zmpp.encoding.AccentTable;

public class CustomAccentTable
implements AccentTable {
    private MemoryReadAccess memaccess;
    private int tableAddress;

    public CustomAccentTable(MemoryReadAccess memoryReadAccess, int n) {
        this.memaccess = memoryReadAccess;
        this.tableAddress = n;
    }

    public int getLength() {
        int n = 0;
        if (this.tableAddress > 0) {
            n = this.memaccess.readUnsignedByte(this.tableAddress);
        }
        return n;
    }

    public short getAccent(int n) {
        short s = 63;
        if (this.tableAddress > 0) {
            s = this.memaccess.readShort(this.tableAddress + n * 2 + 1);
        }
        return s;
    }

    public int getIndexOfLowerCase(int n) {
        char c = (char)this.getAccent(n);
        char c2 = Character.toLowerCase(c);
        int n2 = this.getLength();
        for (int i = 0; i < n2; ++i) {
            if (this.getAccent(i) != c2) continue;
            return i;
        }
        return n;
    }
}

