!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.10.13 ORPrefixSuffix
! Allows the use of prefixes and suffixes that are followed by periods (for example,
! "Dr. Bob" or "Col. Mustard" or "Dan Jr." or "Mr. Armstrong")
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! When creating an object with a period in the name -- like "Mrs. Robinson" --  the 
! player often has issues.  For instance:
!
!     >examine Mrs. Robinson
!
! will cause the parser to stop parseing the input at the period and treat it as two 
! seperate commands.  "examine mrs" and "Robinson."  Thus, assuming there is only one
! object which the word "Mrs" can refer to, then you will get the description followed
! by the the "That's not a verb I recognize" error message. The parser fails entirely
! if the prefix can refer to multiple objects ("Mrs. Robinson" standing next to 
! "Mrs. Baker").
!
! This module scans the input and removes periods that follow general prefixes, such as 
! "Mr" "Mrs" "Dr" "Col", etc...
!--------------------------------------------------------------------------------------
! AutoDep:	
!	ORObjectInitialise
!	ORRoutinesList
!	OREntryPoints
!
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORPrefixSuffix; #include "ORPrefixSuffix"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORPrefixSuffix; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.10.13	Initial Creation
!--------------------------------------------------------------------------------------
#ifdef USE_ORPrefixSuffix;message "          Processing library extension ORPrefixSuffix...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 
	#ifndef USE_OREntryPoints; Constant USE_OREntryPoints; message "          ****Forcing inclusion of OREntryPoints****"; #include "OREntryPoints"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORPrefixSuffix_DONEREPLACE; constant ORPrefixSuffix_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORPrefixSuffix_DONEMESSAGE; constant ORPrefixSuffix_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORPrefixSuffix requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORPrefixSuffix_DONECODE;constant ORPrefixSuffix_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	object with object_initialise[; ORBeforeParsing.add_routine(self.bp);]
	,	bp[pos lstwrd curwrd; 
		wn=1;
		while(wn<=num_words){ !--search for a period
			curwrd = NextWord();
			pos=WordAddress(wn-1);
			if (curwrd == THEN1__WD && lstwrd=='lt' or 'bro' or 'capt' or 'cmdr' or 'col' or 'dr' or 'mrs' or 'mr' or 'ms' or 'rev' or 'sgt' or 'jr' or 'sr') {
				0->pos=' '; !--turn the period into a space
			}
			lstwrd=curwrd;
		}
		Tokenise__(buffer, parse);		
		rfalse; !-- Normally BeforeParsing return values are ignored, but plugging this into the ORRoutineList object to simulate Additive routines looks at the return value to decide whether or not to continue calling other registered BeforeParsing routines. (Like additive properties, true means we've done something so discontinue) We should probably always return false here, so that other registered handlers can have a go at the input as well
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORPrefixSuffix_DONEGRAMMAR; constant ORPrefixSuffix_DONEGRAMMAR; #ifdef ORPrefixSuffix_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;