!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.02.26 ORRedefineObject	[Z, GLULX]
! Redefine an object's routines at runtime.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	ORObjectInitialise
!--------------------------------------------------------------------------------------
! ORLibDev: Note, that this module is not useful as a library extension alone.  By 
!     itself it provides no new functionality for the IF developer. Instead it provides
!     a basis for other module to be built upon and will primarily be useful to those 
!     who are developing ORLibrary entrys of their own.
!--------------------------------------------------------------------------------------
! The DM4 doth proclaim (section 25 pg. 191):
!
! "...to edit and change the library files themselves is an inconvenience and an 
! inelegant way to carry on, because it would lead to needing a separate copy of 
! all the files for each project you work on."
!
! This is, after all, what library extensions often do.  They alter the standard 
! library's behavior.  To accomplish this, library extensions have traditionally 
! leveraged Inform's REPLACE directive to replace standard library routines with 
! altered ones.  This works reasonably well with stand alone routines, but there is a 
! great deal of code in the standard library that is NOT contained in stand alone 
! routines and so cannot be replaced.  Instead, this code is contained in objects. The 
! InformLibrary object is particularly noteworthy for this, and historically it has 
! not been an easy task to write a library extension which modifies the code contained 
! in the InformLibrary object.  Instead, modifications were often written down as 
! instructions for modifications that had to be made to a standard library file, like 
! "First change line 638 of the parserm file from THIS to read as THAT. Now change 
! line..." 
!
! ORRedefineObject eliminates this need.  Simply define a replacement routine on 
! an instance of the ORRedefineObject class and specify the object to change in the 
! "dest_object" property.  Before Initialise() is called, the ORRedefineObject will 
! replace the same-named properties from the destination object with its own. 
!
! It should be noted that unlike the REPLACE directive, this process tends to 
! bloat code since the object routines are redefined at runtime and the previous 
! definitions continue to exist in memory.  However to avoid this, the standard 
! library files must be altered directly.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORRedefineObject";					!Constant USE_ORRedefineObject; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORRedefineObject; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.06	Initial Creation
! 2002.02.13	Added GLULX Support
! 2002.02.26	Fit to new template
!--------------------------------------------------------------------------------------
#ifdef USE_ORRedefineObject;message "          Processing library extension ORRedefineObject...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORRedefineObject_DONEREPLACE; constant ORRedefineObject_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORRedefineObject_DONEMESSAGE; constant ORRedefineObject_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORRedefineObject requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	class ORRedefineObject
		with dest_object 0 
		,	after_init 0
		,	object_initialise[i count;
#ifndef TARGET_GLULX;
			   count = #identifiers_table-->0;
#ifnot; 
				count = INDIV_PROP_START + #identifiers_table-->3;
#endif; 
		for (i=4:i<=count:i++){   !--ignore basic properties (like name and class list)
					if (self provides i && self.dest_object provides i){   
						(self.dest_object).i=self.i;
					}
				}
				if(self.after_init~=0) self.after_init();
			]
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORRedefineObject_DONECODE;constant ORRedefineObject_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORRedefineObject_DONEGRAMMAR; constant ORRedefineObject_DONEGRAMMAR; #ifdef ORRedefineObject_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;