! ==============================================================================
! Simpler ENGLISH for Triform 1.2a
!
! If you do not wish to make use of the past tense in your game, you can use
! this language file to reduce the size of your game file by roughly 1.3 Kb.
!
! Define the constant DIALECT_US before including to obtain American English.
!
! Nearly all of this file is copyrighted by Graham Nelson, 1993-2004, or David
! Griffith, 2012-2014, and licensed under the traditional Inform license:
!
! Copyright on Inform, the program and its source code, its example
! games and documentation (including this book) is retained by Graham
! Nelson, who asserts the moral right to be identified as the author
! under the Copyrights, Designs and Patents Act 1988.  Having said
! this, I am happy for it to be freely distributed to anybody who wants
! a copy, provided that: (a) distributed copies are not substantially
! different from those archived by the author, (b) this and other
! copyright messages are always retained in full, and (c) no profit is
! involved.  (Exceptions to these rules must be negotiated directly
! with the author.)  However, a story file produced with the Inform
! compiler (and libraries) then belongs to its author, and may be sold
! for profit if desired, provided that its game banner contains the
! information that it was compiled by Inform, and the Inform version
! number.

! All code contributed by myself and not appearing in any of the standard Inform
! libraries is public domain.
! ==============================================================================

System_file;

#Message " Compiling with present tense only...";

! ------------------------------------------------------------------------------
!   Part I.   The Compass Directions
! ------------------------------------------------------------------------------

Class CompassDirection
with	number 0, article "the",
	description
	[ j;
	  j = actor.location;
	  if (j provides compass_look && j.compass_look(self)) rtrue;
	  if (self.compass_look()) rtrue;
	  return L__M(##Look, 7);
	],
	compass_look false,
	before
	[ x;
	   Examine, Go, Listen, Smell: ;
	   Take:
		if (self ~= u_obj) return L__M(##Miscellany, 68);
		x = parent(actor);
		if (verb_word == 'get') {
		if (x ofclass Room) {
			if (actor.posture == 1) <<Go u_obj>>;
			else <<Stand>>;
			}
		if (actor.posture == 1) <<Exit>>;
		switch (x.preferred_posture) {
			1: if (actor.posture == 1) <<Exit>>;
				<<Stand>>;
			2: if (actor.posture == 2) <<Exit>>;
				<<Sit>>;
			3: <<Exit>>;
			}
		}
		else return L__M(##Miscellany, 68);
	   default:
		if (self == d_obj && action == ##Receive or ##GetOn) ;
		else return L__M(##Miscellany, 68);
	],
has	scenery;

Object Compass "compass" has transparent concealed;

#Ifndef WITHOUT_DIRECTIONS;
CompassDirection -> n_obj
	with door_dir n_to, name 'n//' 'north',
		n_to "north",
		short_name "north";
CompassDirection -> s_obj
	with door_dir s_to, name 's//' 'south',
		s_to "south",
		short_name "south";
CompassDirection -> e_obj
	with door_dir e_to, name 'e//' 'east',
		e_to "east",
		short_name "east";
CompassDirection -> w_obj
	with door_dir w_to, name 'w//' 'west',
		w_to "west",
		short_name "west";
CompassDirection -> ne_obj
	with door_dir ne_to, name 'ne' 'northeast',
		ne_to "northeast",
		short_name "northeast";
CompassDirection -> nw_obj
	with door_dir nw_to, name 'nw' 'northwest',
		nw_to "northwest",
		short_name "northwest";
CompassDirection -> se_obj
	with door_dir se_to, name 'se' 'southeast',
		se_to "southeast",
		short_name "southeast";
CompassDirection -> sw_obj
	with door_dir sw_to, name 'sw' 'southwest',
		sw_to "southwest",
		short_name "southwest";
CompassDirection -> u_obj
	with door_dir u_to, name 'u//' 'up' 'upwards' 'above' 'sky' 'ceiling',
		u_to "up",
		short_name "up above",
		parse_name
		[;	if (verb_word ~= 'pick') return -1;
			if (grammar_line == 6) rfalse; return -1;
		],
		before
		[ x; Take: x = parent(actor);
			if (verb_word == 'get') {
			if (parent(actor) ofclass Room)
				if (actor.posture == 1) <<Go u_obj>>;
				else <<Stand>>;
			if (actor.posture == 1) <<Exit>>;
			switch (x.preferred_posture) {
				1: if (actor.posture == 1) <<Exit>>;
					<<Stand>>;

				2: if (actor.posture == 2) <<Exit>>;
					<<Sit>>;

				3: <<Exit>>;
				}
			}
		];
CompassDirection -> d_obj
	with door_dir d_to, name 'd//' 'down' 'downwards' 'below' 'ground' 'floor',
		d_to "down",
		short_name "ground",
		floor 0,
		parse_name
		[ wd;
			!if (verb_word ~= 'put') return -1;
			!if (grammar_line == 8) rfalse;

			wd = NextWord();
			if (wd == 'floor' or 'ground') { self.floor = true; rtrue; }

			wn--; return -1;
		],
		before
		[;
			Dig, LookUnder: <<Dig>>;
			GetBeneath:
				if (self.floor) {
					self.floor--;
					"It's not clear how to do that.";
				}
		];
CompassDirection -> back_obj
	with name 'back',
		short_name "the back direction";
#endif;

CompassDirection -> in_obj
	with door_dir in_to,
		in_to "in",
		short_name "inside",
		parse_name
		[; if (verb_word == 'get' or 'take' or 'carry' or 'hold' or 'grab' or 'pick' or 'put'
			or 'place' or 'insert' or 'leave' or 'drop' or 'throw' or 'discard'
			or 'lob' or 'toss' or 'jam' or 'ram' or 'shove' or 'stick' or 'stuff'
			or 'thrust' or 'slide' or 'slip') return 0;
		   if (NextWord() == 'in' or 'inside') return 1;
		];
CompassDirection -> out_obj
	with door_dir out_to, name 'out' 'outside',
		out_to "out",
		short_name "outside";

CompassDirection -> left_obj
	with	name 'left',
		short_name "left";
CompassDirection -> right_obj
	with	name 'right',
		short_name "right";


! ------------------------------------------------------------------------------
!   Part II.   Vocabulary
! ------------------------------------------------------------------------------

Constant AGAIN1__WD     = 'again';
Constant AGAIN2__WD     = 'g//';
Constant AGAIN3__WD     = 'repeat';
Constant OOPS1__WD      = 'oops';
Constant OOPS2__WD      = 'o//';
Constant OOPS3__WD      = 'whoops';
Constant UNDO1__WD      = 'undo';
Constant UNDO2__WD      = 'undo';
Constant UNDO3__WD      = 'undo';

Constant ALL1__WD       = 'all';
Constant ALL2__WD       = 'each';
Constant ALL3__WD       = 'every';
Constant ALL4__WD       = 'everything';
Constant ALL5__WD       = 'both';
Constant AND1__WD       = 'and';
Constant AND2__WD       = 'and';
Constant AND3__WD       = '&//';
Constant BUT1__WD       = 'but';
Constant BUT2__WD       = 'except';
Constant BUT3__WD       = 'besides';
Constant ME1__WD        = 'me';
Constant ME2__WD        = 'myself';
Constant ME3__WD        = 'self';
Constant ME4__WD        = 'i//';
Constant YOU1__WD	= 'you';
Constant YOU2__WD	= 'yourself';
Constant OF1__WD        = 'of';
Constant OF2__WD        = 'of';
Constant OF3__WD        = 'of';
Constant OF4__WD        = 'of';
Constant OTHER1__WD     = 'another';
Constant OTHER2__WD     = 'other';
Constant OTHER3__WD     = 'other';
Constant SELF1__WD	= 'herself';
Constant SELF2__WD	= 'himself';
Constant SELF3__WD	= 'itself';
Constant THEN1__WD      = 'then';
Constant THEN2__WD      = 'then';
Constant THEN3__WD      = 'then';

Constant NO1__WD        = 'n//';
Constant NO2__WD        = 'no';
Constant NO3__WD        = 'nope';
Constant YES1__WD       = 'y//';
Constant YES2__WD       = 'yes';
Constant YES3__WD       = 'yeah';

Constant AMUSING__WD    = 'amusing';
Constant FULLSCORE1__WD = 'fullscore';
Constant FULLSCORE2__WD = 'full';
Constant QUIT1__WD      = 'q//';
Constant QUIT2__WD      = 'quit';
Constant REMOVE__WD	= 'remove';
Constant RESTART__WD    = 'restart';
Constant RESTORE__WD    = 'restore';

Array LanguagePronouns table

  ! word        possible GNAs                   connected
  !             to follow:                      to:
  !             a     i
  !             s  p  s  p
  !             mfnmfnmfnmfn

    'it'      $$001000111000                    NULL
    'him'     $$100000000000                    NULL
    'her'     $$010000000000                    NULL
    'them'    $$000111000111                    NULL
    'he'      $$100000000000			NULL
    'she'     $$010000000000			NULL;

Array LanguageDescriptors table

  ! word        possible GNAs   descriptor      connected
  !             to follow:      type:           to:
  !             a     i
  !             s  p  s  p
  !             mfnmfnmfnmfn

    'my'      $$111111111111    POSSESS_PK      0
    'this'    $$111111111111    POSSESS_PK      0
    'these'   $$000111000111    POSSESS_PK      0
    'that'    $$111111111111    POSSESS_PK      1
    'those'   $$000111000111    POSSESS_PK      1
    'his'     $$111111111111    POSSESS_PK      'him'
    'her'     $$111111111111    POSSESS_PK      'her'
    'their'   $$111111111111    POSSESS_PK      'them'
    'its'     $$111111111111    POSSESS_PK      'it'
    'the'     $$111111111111    DEFART_PK       NULL
    'a//'     $$111000111000    INDEFART_PK     NULL
    'an'      $$111000111000    INDEFART_PK     NULL
    'some'    $$000111000111    INDEFART_PK     NULL;

Array LanguageNumbers table
    'one' 1 'two' 2 'three' 3 'four' 4 'five' 5
    'six' 6 'seven' 7 'eight' 8 'nine' 9 'ten' 10
    'eleven' 11 'twelve' 12 'thirteen' 13 'fourteen' 14 'fifteen' 15
    'sixteen' 16 'seventeen' 17 'eighteen' 18 'nineteen' 19 'twenty' 20
    'thirty' 30 'forty' 40 'fifty' 50 'sixty' 60 'seventy' 70
    'eighty' 80 'ninety' 90 'hundred' 100 'thousand' 1000;

! ------------------------------------------------------------------------------
!   Part III.   Translation
! ------------------------------------------------------------------------------

[ LanguageToInformese;
];

! ------------------------------------------------------------------------------
!   Part IV.   Printing
! ------------------------------------------------------------------------------

Constant LanguageAnimateGender   = male;
Constant LanguageInanimateGender = neuter;

Constant LanguageContractionForms = 2;     ! English has two:
                                           ! 0 = starting with a consonant
                                           ! 1 = starting with a vowel

[ PrefaceByArticle o acode pluralise capitalise  i artform findout artval;
    if (o provides articles) {
        artval=(o.&articles)-->(acode+short_name_case*LanguageCases);
        if (capitalise)
            print (Cap) artval;
        else
            print (string) artval;
        if (pluralise) return;
        print (PSN__) o; return;
    }

    i = GetGNAOfObject(o);
    if (pluralise) {
        if (i < 3 || (i >= 6 && i < 9)) i = i + 3;
    }
    i = LanguageGNAsToArticles-->i;

    artform = LanguageArticles
        + 3*WORDSIZE*LanguageContractionForms*(short_name_case + i*LanguageCases);

    #Iftrue LanguageContractionForms == 2;
    if (artform-->acode ~= artform-->(acode+3)) findout = true;
    #Endif; ! LanguageContractionForms
    #Iftrue (LanguageContractionForms == 3);
    if (artform-->acode ~= artform-->(acode+3)) findout = true;
    if (artform-->(acode+3) ~= artform-->(acode+6)) findout = true;
    #Endif; ! LanguageContractionForms
    #Iftrue (LanguageContractionForms == 4);
    if (artform-->acode ~= artform-->(acode+3)) findout = true;
    if (artform-->(acode+3) ~= artform-->(acode+6)) findout = true;
    if (artform-->(acode+6) ~= artform-->(acode+9)) findout = true;
    #Endif; ! LanguageContractionForms
    #Iftrue (LanguageContractionForms > 4);
    findout = true;
    #Endif; ! LanguageContractionForms

    #Ifdef TARGET_ZCODE;
    if (standard_interpreter ~= 0 && findout) {
        StorageForShortName-->0 = 160;
        @output_stream 3 StorageForShortName;
        if (pluralise) print (number) pluralise; else print (PSN__) o;
        @output_stream -3;
        acode = acode + 3*LanguageContraction(StorageForShortName + 2);
    }
    #Ifnot; ! TARGET_GLULX
    if (findout) {
        if (pluralise)
            PrintAnyToArray(StorageForShortName, 160, EnglishNumber, pluralise);
        else
            PrintAnyToArray(StorageForShortName, 160, PSN__, o);
        acode = acode + 3*LanguageContraction(StorageForShortName);
    }
    #Endif; ! TARGET_

    Cap (artform-->acode, ~~capitalise); ! print article
    if (pluralise) return;
    print (PSN__) o;
];

[ LanguageContraction text;
    if (text->0 == 'a' or 'e' or 'i' or 'o' or 'u'
                or 'A' or 'E' or 'I' or 'O' or 'U') return 1;
    return 0;
];

Array LanguageArticles -->

 !   Contraction form 0:     Contraction form 1:
 !   Cdef   Def    Indef     Cdef   Def    Indef

     "The " "the " "a "      "The " "the " "an "          ! Articles 0
     "The " "the " "some "   "The " "the " "some ";       ! Articles 1

                   !             a           i
                   !             s     p     s     p
                   !             m f n m f n m f n m f n

Array LanguageGNAsToArticles --> 0 0 0 1 1 1 0 0 0 1 1 1;

[ LanguageDirection d;
    switch (d) {
      n_to, s_to, e_to, w_to, ne_to, nw_to, se_to, sw_to, u_to, d_to, in_to, out_to: print (address) d;
      default: return RunTimeError(9,d);
    }
];

[ LanguageNumber n f;
    if (n == 0)    { print "zero"; rfalse; }
    if (n < 0)     { print "minus "; n = -n; }
    if (n >= 1000) { print (LanguageNumber) n/1000, " thousand"; n = n%1000; f = 1; }
    if (n >= 100)  {
        if (f == 1) print ", ";
        print (LanguageNumber) n/100, " hundred"; n = n%100; f = 1;
    }
    if (n == 0) rfalse;
    #Ifdef DIALECT_US;
    if (f == 1) print " ";
    #Ifnot;
    if (f == 1) print " and ";
    #Endif;
    switch (n) {
      1:    print "one";
      2:    print "two";
      3:    print "three";
      4:    print "four";
      5:    print "five";
      6:    print "six";
      7:    print "seven";
      8:    print "eight";
      9:    print "nine";
      10:   print "ten";
      11:   print "eleven";
      12:   print "twelve";
      13:   print "thirteen";
      14:   print "fourteen";
      15:   print "fifteen";
      16:   print "sixteen";
      17:   print "seventeen";
      18:   print "eighteen";
      19:   print "nineteen";
      20 to 99: switch (n/10) {
      2:  print "twenty";
      3:  print "thirty";
      4:  print "forty";
      5:  print "fifty";
      6:  print "sixty";
      7:  print "seventy";
      8:  print "eighty";
      9:  print "ninety";
      }
      if (n%10 ~= 0) print "-", (LanguageNumber) n%10;
    }
];

[ LanguageTimeOfDay hours mins i;
    i = hours%12;
    if (i == 0) i = 12;
    if (i < 10) print " ";
    print i, ":", mins/10, mins%10;
    if ((hours/12) > 0) print " pm"; else print " am";
];

[ LanguageVerb i;
    switch (i) {
      'i//','inv','inventory':
               print "take inventory";
      'l//':   print "look";
      'x//':   print "examine";
      'z//':   print "wait";
      default: rfalse;
    }
    rtrue;
];

#Ifdef TARGET_ZCODE;

[ LowerCase c;
   switch (c) {
     'A' to 'Z':
       c = c + 32;
     202, 204, 212, 214, 221:
       c--;
     217, 218:
       c = c - 2;
     158 to 160, 167, 168, 208 to 210:
       c = c - 3;
     186 to 190, 196 to 200:
       c = c - 5 ;
     175 to 180:
       c = c - 6;
   }
   return c;
];

[ UpperCase c;
   switch (c) {
     'a' to 'z':
       c = c - 32;
     201, 203, 211, 213, 220:
       c++;
     215, 216:
       c = c + 2;
     155 to 157, 164, 165, 205 to 207:
       c = c + 3;
     181 to 185, 191 to 195:
       c = c + 5 ;
     169 to 174:
       c = c + 6;
   }
   return c;
];

#Ifnot; ! TARGET_GLULX

[ LowerCase c; return glk($00A0, c); ];
[ UpperCase c; return glk($00A1, c); ];

#Endif; ! TARGET_

! ----------------------------------------------------------------------------
!  LanguageVerbIsDebugging is called by SearchScope.  It should return true 
!  if word w is a debugging verb which needs all objects to be in scope.
! ----------------------------------------------------------------------------

#Ifdef DEBUG;
[ LanguageVerbIsDebugging w;
    if (w == 'purloin' or 'tree' or 'abstract'
                       or 'gonear' or 'scope' or 'showobj')
        rtrue;
    rfalse;
];
#Endif;

[ Banner i;
   if (Story ~= 0) {
        #Ifdef TARGET_ZCODE;
        #IfV5; style bold; #Endif;
        print (string) Story;
        #IfV5; style roman; #Endif;
        #Ifnot; ! TARGET_GLULX;
        glk($0086, 3); ! set header style
        print (string) Story;
        glk($0086, 0); ! set normal style
        #Endif; ! TARGET_
    }
    if (Headline ~= 0) print (string) Headline;
    #Ifdef TARGET_ZCODE;
    print "Release ", (HDR_GAMERELEASE-->0) & $03ff, " / Serial number ";
    for (i=0 : i<6 : i++) print (char) HDR_GAMESERIAL->i;
    #Ifnot; ! TARGET_GLULX;
    print "Release ";
    @aloads ROM_GAMERELEASE 0 i;
    print i;
    print " / Serial number ";
    for (i=0 : i<6 : i++) print (char) ROM_GAMESERIAL->i;
    #Endif; ! TARGET_
    print " / Inform v"; inversion;
    print " Triform ", (string) LibRelease, " ";
    #Ifdef STRICT_MODE;
    print "S";
    #Endif; ! STRICT_MODE
    #Ifdef INFIX;
    print "X";
    #Ifnot;
    #Ifdef DEBUG;
    print "D";
    #Endif; ! DEBUG
    #Endif; ! INFIX
    new_line;
];

[ VersionSub ix;
    Banner();
    #Ifdef TARGET_ZCODE;
    ix = 0; ! shut up compiler warning
    if (standard_interpreter > 0) {
        print "Standard interpreter ", standard_interpreter/256, ".", standard_interpreter%256,
            " (", HDR_TERPNUMBER->0;
        #Iftrue (#version_number == 6);
        print (char) '.', HDR_TERPVERSION->0;
        #Ifnot;
        print (char) HDR_TERPVERSION->0;
        #Endif;
        print ") / ";
        }
    else {
        print "Interpreter ", HDR_TERPNUMBER->0, " Version ";
        #Iftrue (#version_number == 6);
        print HDR_TERPVERSION->0;
        #Ifnot;
        print (char) HDR_TERPVERSION->0;
        #Endif;
        print " / ";
    }

    #Ifnot; ! TARGET_GLULX;
    @gestalt 1 0 ix;
    print "Interpreter version ", ix / $10000, ".", (ix & $FF00) / $100,
    ".", ix & $FF, " / ";
    @gestalt 0 0 ix;
    print "VM ", ix / $10000, ".", (ix & $FF00) / $100, ".", ix & $FF, " / ";
    #Endif; ! TARGET_;
    print "Library Release ", (string) LibSerial, "^";
    #Ifdef LanguageVersion;
    print (string) LanguageVersion, "^";
    #Endif; ! LanguageVersion
];

! ----------------------------------------------------------------------------
!  PrintCommand reconstructs the command as it presently reads, from
!  the pattern which has been built up.
!
!  If from is 0, it starts with the verb: then it goes through the pattern.
!  The other parameter is "emptyf" - a flag: if 0, it goes up to pcount:
!  if 1, it goes up to pcount-1.
!
!  Note that verbs and prepositions are printed out of the dictionary:
!  and that since the dictionary may only preserve the first six characters
!  of a word (in a V3 game), we have to hand-code the longer words needed.
!
!  (Recall that pattern entries are 0 for "multiple object", 1 for "special
!  word", 2 to REPARSE_CODE-1 are object numbers and REPARSE_CODE+n means the
!  preposition n)
! ----------------------------------------------------------------------------

[ PrintCommand from i k spacing_flag;
    #Ifdef LanguageCommand;
    LanguageCommand(from);
    i = k = spacing_flag = 0;   ! suppress warning
    #Ifnot;
    if (from == 0) {
	if (LanguageVerbIsLookMode() ~= false) return;

	if (verb_word == 'score' or 'full' or 'fullscore')
	  { print "print the score"; rtrue; }

	if (verb_word == 'no')
	  { print "say no"; rtrue; }

	if (verb_word == 'yes')
	  { print "say yes"; rtrue; }

        i = verb_word;
#IFDEF USE_LIBRARY_EXTENSIONS;
        if (LanguageVerb(i) == 0 && PrintVerb(i) == false && LibraryExtensions.RunWhile(ext_printverb, false, i) == 0)
            print (address) i;
#IFNOT;
        if (LanguageVerb(i) == 0)
            if (PrintVerb(i) == 0) print (address) i;
#ENDIF;
        from++; spacing_flag = true;
    }

  if (action_to_be == ##Answer or ##Tell && consult_words == 0) return;

    for (k=from : k<pcount : k++) {
        i = pattern-->k;
	  if (i == -1) break;
        if (i == PATTERN_NULL) continue;
        if (spacing_flag) print (char) ' ';
        if (i == 0) { print (string) THOSET__TX; jump TokenPrinted; }
        if (i == 1) { print (string) THAT__TX;   jump TokenPrinted; }
        if (i >= REPARSE_CODE)
            print (address) No__Dword(i-REPARSE_CODE);
        else
            if (i in compass && verb_word  == 'look' or 'go' or 'push' or 'walk')
                LanguageDirection (i.door_dir); ! the direction name as adverb
            else
                { if (i == player && actor ~= player) print "you"; else print (the) i; }
      .TokenPrinted;
        spacing_flag = true;
    }
    #Endif;
];

[ LanguageVerbIsLookMode flag;
  switch (verb_word)
  { 'normal', 'standard':
	if (flag == 0) print "change the printing mode";
	return 4;
    'brief':
	if (flag == 0) print "change the printing mode";
	return 1;
    'superbrief', 'short':
	if (flag == 0) print "change the printing mode";
	return 2;
    'verbose', 'long':
	if (flag == 0) print "change the printing mode";
	return 3;
  }
  rfalse;
];

[ LanguageVerbIsPosture;
  switch(verb_word) {
	'stand': return 1;
	'sit': return 2;
	'lie': return 3;
  }
  rfalse;
];

! ----------------------------------------------------------------------------
!  LanguageVerbMayBeName is called by NounDomain when dealing with the 
!  player's reply to a "Which do you mean, the short stick or the long
!  stick?" prompt from the parser. If the reply is another verb (for example,
!  LOOK) then then previous ambiguous command is discarded /unless/
!  it is one of these words which could be both a verb /and/ an
!  adjective in a 'name' property.
! ----------------------------------------------------------------------------

[ LanguageVerbMayBeName w;
    if (w == 'long' or 'short' or 'normal'
                    or 'brief' or 'full' or 'verbose')
        rtrue;
    rfalse;
];

Constant NKEY__TX       = "N = next subject";
Constant PKEY__TX       = "P = previous";
Constant QKEY1__TX      = "  Q = resume game";
Constant QKEY2__TX      = "Q = previous menu";
Constant RKEY__TX       = "RETURN = read subject";

Constant NKEY1__KY      = 'N';
Constant NKEY2__KY      = 'n';
Constant PKEY1__KY      = 'P';
Constant PKEY2__KY      = 'p';
Constant QKEY1__KY      = 'Q';
Constant QKEY2__KY      = 'q';

Constant SCORE__TX      = "Score: ";
Constant MOVES__TX      = "Moves: ";
Constant TIME__TX       = "Time: ";
Constant FORMER__TX     = "your former self";
Constant YOURSELF__TX   = "yourself";
Constant YOU__TX        = "You";
Constant DARKNESS__TX   = "Darkness";
Constant INDARKNESS__TX	= "(in darkness)";

Constant NORMAL__TX	= "normal";
Constant ALREADY__TX	= " is already in its ";
Constant ISNOW__TX	= " is now in its ";

Constant THOSET__TX     = "those things";
Constant THAT__TX       = "that";
#Ifdef SERIAL_COMMAS;
Constant OR__TX		= ", or ";
Constant OR2__TX	= " or ";
Constant AND__TX	= ", and ";
Constant AND2__TX	= " and ";
#Ifnot;
Constant OR__TX		= " or ";
Constant OR2__TX	= OR__TX;
Constant AND__TX	= " and ";
Constant AND2__TX	= AND__TX;
#Endif;
Constant NOTHING__TX    = "nothing";
Constant IS__TX         = " is";
Constant ARE__TX        = " are";
Constant WAS__TX	= " was";
Constant WERE__TX	= " were ";
Constant IS2__TX        = "is ";
Constant ARE2__TX       = "are ";
Constant WAS2__TX	= "was ";
Constant WERE2__TX	= "were ";
Constant WHOM__TX       = "whom ";
Constant WHICH__TX      = "which ";
Constant COMMA__TX      = ", ";
Constant COLON__TX      = ": ";

! Irregular verbs

[ Has x1;
 if (x1 == player || x1 has pluralname) print "have"; else print "has";
];

[ Get;
  if (verb_word == 'sit' or 'lie' or 'stand') print (address) verb_word;
  else print "get";
  CaseEndings();
];

[ CaseEndings;
  if (actor ~= player && actor hasnt pluralname) print "s";
];

[ ThatorThose obj;      ! Used in the accusative
    if (obj == player)		{ if (action == ##Cut) print "yourself"; else print "you"; return; }
    if (obj has pluralname)	{ print "them"; return; }
    if (obj has male)		{ print "him"; return; }
    if (obj has female)		{ print "her"; return; }
    if (obj has animate)	{ print "it"; return; }
    print "that";
];

[ TheyreorThats obj;
    if (obj == player)		{ print "you're"; return; }
    if (obj has pluralname)	{ print "they're"; return; }
    if (obj has male)		{ print "he's"; return; }
    if (obj has female)		{ print "she's"; return; }
    if (obj has animate)	{ print "it's"; return; }
    print "that's";
];

[ TheyAreorThatIs obj;

    if (obj == player)        { print "you are"; return; }
    if (obj has pluralname)   { print "they are"; return; }
    if (obj has male)		{ print "he is"; return; }
    if (obj has female)       { print "she is"; return; }
    if (obj has animate)	{ print "it is"; return; }
    print "that is";
];

[ HeorShe obj;
    if (obj == player)		{ print "you"; return; }
    if (obj has pluralname)	{ print "they"; return; }
    if (obj has male)		{ print "he"; return; }
    if (obj has female)		{ print "she"; return; }
    print "it";
];

[ CHeorShe obj;
    if (obj == player)		{ print "You"; return; }
    if (obj has pluralname)	{ print "They"; return; }
    if (obj has male)		{ print "He"; return; }
    if (obj has female)		{ print "She"; return; }
    print "It";
];

[ IsorAre obj;
if (obj == player) print "are";
	     else  { if (obj has pluralname) print "are";
    		else print "is";
		}

];

[ IsntorArent obj;
if (obj == player || obj has pluralname) print "aren't";
		 else print "isn't";

];

[ IsNotorAreNot obj;
if (obj == player || obj has pluralname) print "are not";
		else print "is not";

];

[ CThatorThose obj;     ! Used in the nominative
    if (obj == player)		{ print "You"; return; }
    if (obj has pluralname)	{ print "They"; return; }
    if (obj has male)		{ print "He"; return; }
    if (obj has female)		{ print "She"; return; }
    print "That";
];

[ CTheyreorThats obj;
	if (obj == player)		{ print "You're"; return; }
	if (obj has pluralname)		{ print "They're"; return; }
	if (obj has male)		{ print "He's"; return; }
	if (obj has female)		{ print "She's"; return; }
	if (obj has animate)		{ print "It's"; return; }
	print "That's";
];

[ CTheyAreorThatIs obj;
	if (obj == player)              { print "You are"; return; }
	if (obj has pluralname)         { print "They are"; return; }
	if (obj has male)		{ print "He is"; return; }
	if (obj has female)		{ print "She is"; return; }
	if (obj has animate)		{ print "It is"; return; }
	print "That is";

];

[ HimselforHerself i;
  if (i == player)	{ print "yourself"; return; }
  if (i has male)	{ print "himself"; return; }
  if (i has female)	{ print "herself"; return; }
  print "itself";
];

[ HisorHer i;
  if (i == player)		print "your";
  else if (i has male)		print "his";
  else if (i has female)	print "her";
  else print "it's";
];

[ ItorThem obj;
    if (obj == player)		{ print "yourself"; return; }
    if (obj has pluralname)	{ print "them"; return; }
    if (obj has male)		{ print "him"; return; }
    if (obj has female)		{ print "her"; return; }
    print "it";
];

[ CItorThem obj;
    if (obj has pluralname)	{ print "They"; return; }
    if (obj has male)		{ print "Him"; return; }
    if (obj has female)		{ print "Her"; return; }
    print "It";
];

[ RunTimeError n p1 p2;
    #Ifdef DEBUG;
    print "** Library error ", n, " (", p1, ",", p2, ") **^** ";
    switch (n) {
      1:    print "preposition not found (this should not occur)";
      2:    print "Property value not routine or string: ~", (property) p2, "~ of ~", (name) p1,
                  "~ (", p1, ")";
      3:    print "Entry in property list not routine or string: ~", (property) p2, "~ list of ~",
                  (name) p1, "~ (", p1, ")";
      4:    print "Too many timers/daemons are active simultaneously.
                  The limit is the library constant MAX_TIMERS (currently ",
                  MAX_TIMERS, ") and should be increased";
      5:    print "Object ~", (name) p1, "~ has no ~time_left~ property";
      7:    print "The object ~", (name) p1, "~ can only be used as a player object if it has
                  the ~number~ property";
      8:    print "Attempt to take random entry from an empty table array";
      9:    print p1, " is not a valid direction property number";
      10:   print "The player-object is outside the object tree";
      11:   print "The room ~", (name) p1, "~ has no ~description~ property";
      12:   print "Tried to set a non-existent pronoun using SetPronoun";
      13:   print "A 'topic' token can only be followed by a preposition";
      14:   print "SetPronoun() failed.";
      20:   print "DescribeChildren(", (the) p1, ") called with flag value ", p2;
      21:   print "IsVisible() called with no object";
      23:   print "LightToSeeBy() called with no object";
      24:   print "Move() called with no arguments";
      25:   print "Move(", (the) p1, ") called without a target";
      26:   print "Move() called to target ", (the) p1," but no object";
      27:   print "Remove() called without an object";
      28:   print "CountChildren(", (the) p1, ") called with wrong flag value";
      default:
            print "(unexplained)";
    }
    " **";
    #Ifnot;
    "** Library error ", n, " (", p1, ",", p2, ") **";
    #Endif; ! DEBUG
];

[ LanguageLM n x1 x2 i j;
  if (keep_silent == 2) return;
  if (failed_action) failed_action = n;
  if (actor ~= player) {
	if (action == ##Go && n == 7) { if (actor.old_loc ~= player.location) return; }
	else if (IsVisible(actor, player) == false) return;
	if (failed_action) switch(action) {
		##Disrobe: if (n ~= 3 or 4 or 5) return;
		##Lock: if (n ~= 1 or 2 or 4) return;
		##Push, ##Pull, ##Turn: if (n ~= 1 or 2) return;
		##Unlock: if (n ~= 1 or 2 or 3 or 7) return;
		##Wear: if (n ~= 9 or 11 or 12) return;
	}
	if (action_mode == 4 or 0) {
		switch (action) {
		##Disrobe: if (n ~= 2) return;
		##Drop: if (n ~= 3) return;
		##Eat: if (n ~= 2) return;
		##Enter: if (n ~= 5) return;
		##Examine: if (n ~= 2) return;
		##Exit: if (n ~= 3) return;
		##Give: if (n ~= 4) return;
		##Go: if (n ~= 7 or 8) return;
		##Insert: if (n ~= 8) return;
		##Jump: ;
		##Lie: ;
		##Lock: if (n ~= 5) return;
		##Open: if (n ~= 2 or 4 or 5) return;
		##Pull, ##Push, ##Turn: if (n ~= 4) return;
		##Search: ;
		##Show: if (n ~= 2) return;
		##Smell: ;
		##Squeeze: if (n ~= 2) return;
		##SwitchOff: if (n ~= 3) return;
		##SwitchOn: if (n ~= 3) return;
		##Take: if (n ~= 1 or 6) return;
		##Taste: ;
		##Touch: ;
		##Tell: if (n ~= 1 or 2) return;
		##Unlock: if (n ~= 4 or 7) return;
		##Wave: if (n ~= 2) return;
		##Wear: if (n ~= 4or 13 or 14) return;
		default: return;
		}
	new_line;
	}
  }

  Answer, Ask: "There is no reply.";
  Attack: switch (n) {
	1: "Violence isn't the answer to this one.";
	2: "Attacking ", (HimselforHerself) actor, " would be fruitless.";
    }
  Blow:     print_ret (CHeorShe) actor, " can't usefully blow ", (ThatorThose) x1, ".";
  Burn:     print_ret (CHeorShe) actor, " lack", (CaseEndings) actor, " anything with which to set a fire.";
  Buy: switch (n) {
		1: "You're clearly not in a shop.";
		2: "You can't buy people.";
	}
  Climb:    print_ret (CHeorShe) actor, " can't climb ", (ThatorThose) x1, ".";
  Close: switch (n) {
        1:  print_ret (CTheyreorThats) x1, " not something ", (HeorShe) actor, " can close.";
        2:  print_ret (CTheyreorThats) x1, " already closed.";
        3:  print_ret (CHeorShe) actor, " close", (CaseEndings) x1, " ", (the) x1, ".";
    }
  CommandsOff: switch (n) {
        1: "[Command recording off.]";
        #Ifdef TARGET_GLULX;
        2: "[Command recording already off.]";
        #Endif; ! TARGET_
    }
  CommandsOn: switch (n) {
        1: "[Command recording on.]";
        #Ifdef TARGET_GLULX;
        2: "[Commands are currently replaying.]";
        3: "[Command recording already on.]";
        4: "[Command recording failed.]";
        #Endif; ! TARGET_
    }
  CommandsRead: switch (n) {
        1: "[Replaying commands.]";
        #Ifdef TARGET_GLULX;
        2: "[Commands are already replaying.]";
        3: "[Command replay failed.  Command recording is on.]";
        4: "[Command replay failed.]";
        5: "[Command replay complete.]";
        #Endif; ! TARGET_
    }
! Consult: see Miscellany 71
  Cut:      "Cutting ", (ThatorThose) x1, " up would achieve little.";
  Dig:      "Digging would achieve nothing here.";
  Disrobe: switch (n) {
        1:  print_ret (CHeorShe) actor, " ", (IsntorArent) actor, " wearing ", (ThatorThose) x1, ".";
        2:  print (CHeorShe) actor, " take", (CaseEndings) x1, " off ", (the) x1, ". ";
		if (lookmode == 2) { if (DescribeClothes(actor, true) == false) new_line; }  else new_line;
	#IFDEF COMPLEXCLOTHING;
	3:  print_ret (CHeorShe) actor, " can't, because ", (the) x1, " ", (IsorAre) x1, " locked.";
	4:  print_ret (CHeorShe) actor, " can't, because ", (the) x1, " ", (IsorAre) x1, " in the way.";
	5:  print_ret (CHeorShe) actor, " can't, because ", (HisorHer) actor, " hands are too full.";
	#ENDIF;
	6:  print_ret (CThatorThose) x1, " ", (IsntorArent) x1, " something ", (HeorShe) actor, " can put on, much less take off.";
    }
  Drink: print_ret (CHeorShe) actor, " can't drink ", (a) x1, ".";
  Drop: switch (n) {
        1:  print_ret (The) x1, " ", (IsorAre) x1, " already there.";
        2:  print (CHeorShe) actor, " ", (IsntorArent) actor, " holding ";
		if (original_noun > 0) { original_noun = 0; "any of those."; }
		if (original_noun < 0) { original_noun = 0; "anything."; }
		print_ret (ThatorThose) x1, ".";
        3:  "(first taking ", (the) x1, " off)";
	4:  print (CHeorShe) actor, " drop", (CaseEndings) actor, " ";
		if (successful_action && x1 provides plural) "the ", (string) x1.plural, ".";
		print_ret (the) x1, ".";
    }
  Eat: switch (n) {
        1:  print_ret (CTheyreorThats) x1, " plainly inedible.";
        2:  print_ret (CHeorShe) actor, " eat", (CaseEndings) actor, " ", (the) x1, ".";
    }
  EmptyT: switch (n) {
        1:  print_ret (The) x1, " can't contain things.";
        2:  print_ret (The) x1, " ", (IsorAre) x1, " closed.";
        3:  print_ret (The) x1, " ", (IsorAre) x1, " empty already.";
    }
  Enter: switch (n) {
        1:  print "But ", (HeorShe) actor, " ", (IsorAre) actor, " already";
            switch (verb_word) {
              'stand': if (actor.posture == 1) print " standing";
              'sit': if (actor.posture == 2) print " sitting";
              'lie': if (actor.posture == 3) print " lying";
            }
		if (actor.insideofparent == true) print " in ";
		if (actor.ontopofparent == true) print " on ";
		if (actor.behindparent == true) print " behind ";
		if (actor.beneathparent == true) print " beneath ";
            print_ret (the) x1, ".";
        2:  print (CTheyreorThats) x1;
            print " not something ", (HeorShe) actor, " can";
            switch (verb_word) {
              'stand':  print " stand ";
              'sit':    print " sit down ";
              'lie':    print " lie down ";
              default:  print " get ";
            }
	    switch (action) {
	      ##GetOn: "on top of.";
	      ##GetBehind: "behind.";
	      ##GetBeneath: "under.";
	      default: "into.";
	    }
        4:  print_ret (CHeorShe) actor, " can only get into something free-standing.";
        5:  print (CHeorShe) actor, " ", (Get) actor, " ";
            switch (action)
		{ ##GetInside: print "in ";
		  ##GetOn: print "on ";
		  ##GetBehind: print "behind ";
		  ##GetBeneath: print "beneath ";
		}
            print_ret (the) x1, ".";

	6: "(first entering ", (the) x1, ")";
	8:  print "There isn't ";
	    print "enough space for ", (ThatorThose) actor, " ";
		switch (action)
		{ ##Enter: ".";
		  ##GetInside: print "in";
		  ##GetOn: print "on";
		  ##GetBehind: print "behind";
		  ##GetBeneath: print "beneath";
		}
		" ", (the) x1, ".";
	10: print "(first getting ";
		if (actor.ontopofparent == true) print "off of ";
		if (actor.insideofparent == true) print "out of ";
		if (actor.beneathparent == true) print "out from under ";
		if (actor.behindparent == true) print "out from behind ";
	    print_ret (the) x1, ")";
    }
  Examine: switch (n) {
        1:  "There is not enough light to see by.";
        2:  if (actor == player) {
		print "You see nothing unexpected about ";
		if (noun == player) print "yourself.";
		else print (the) x1, ".";
		}
		else print (The) actor, " look", (CaseEndings) actor, " at ", (the) x1, ".";
        3:  print (The) x1, " ", (IsorAre) x1, " currently ";
		if (PrintorRun(x1, switched_desc, true) == 1) "."; else print "switched";
            if (x1 has on) print " on."; else print " off.";
	4: "But ", (the) x1, " isn't accessible right now.";
	#IFDEF TRACK_LOCATIONS;
	5:
		i = x1.&last_seen-->0; ! Room

		if (i == 0) {
			i = noun.last_known;

			"You have not seen ", (the) x1, " but you have reason to believe",
			(HeorShe) x1, " may be in ", (the) i.travel_name, ".";
		}

		print "You last saw ";
		if (x2 == true && x1 provides plural) print "the ", (string) x1.plural, " in the ";
			else print (the) x1, " in the ";
		if (i.travel_name ~= 0 or NULL)
			print (string) i.travel_name;
		else print (name) i;

		i = x1.&last_seen-->1; ! Parent

		j = x1.&last_seen-->2; ! Parent relationship

		if (i ofclass Container) {
			switch (j) {
				1: print ", in ";
				2: print ", on ";
				3: print ", behind ";
				4: print ", under ";
				5: print ", attached to ";
			}
			print (the) i, ",";
		}

		if (i ofclass Person && i ~= player) {
			print " being carried by ", (the) i;
		}

		i = x1.&last_seen-->3; ! Time

		if (the_time ~= NULL)
			print " at ", (i/60), ":", (i%60)/10, i%10;
		else print " ", (turns-i), " turns ago";

		i = noun.&last_known-->0;

		if (noun.&last_seen-->0 ~= i) {
			print ", but you have reason to believe ", (HeorShe) x1, " may be in ";
			if (i.travel_name ~= 0 or NULL)
				print (string) i.travel_name;
			else print (name) i;
		}

		".";
	#ENDIF;
    }
  Exit: switch (n) {
        1:  "But ", (HeorShe) actor, " ", (IsntorArent) actor, " in anything.";
        2:  print_ret (CHeorShe) actor, " can't get out of the closed ", (name) x1, ".";
        3:  print (CHeorShe) actor, " get", (CaseEndings) actor, " ";
	    switch (x2) {
             1: print "out of ";
	     2: print "off of ";
             3: print "out from behind ";
             4: print "out from under ";
	    }
            print_ret (the) x1, ".";
        4:  print (CHeorShe) actor, " ", (IsorAre) actor, " already not ";
		switch (grammar_line) {
			5, 9: print "in";
			6, 7, 11, 12: print "on";
			8: print "under";
			10: print "behind";
			default: "there.";
		}
    }
  Face:	"In this game, you will always be facing the necessary direction.";
  Fill: "But there ", (IsorAre) 1, " no water to carry.";
  #Ifndef NO_SCORE;
  FullScore: switch (n) {
        1:  if (gameover) print "The score was "; else print "The score is ";
            "made up as follows:^";
        2:  "finding sundry items";
        3:  "visiting various places";
        4:  print "total (out of ", MAX_SCORE; ")";
    }
  #Endif;
  Give: switch (n) {
        3: if (actor ~= player) {
		print (The) actor, " offers ";
		print (the) noun, " to ", (the) x1, ", but ", (HeorShe) x1;
		}

		else print (The) x1;

	    if (x1 has pluralname) print " don't"; else print " doesn't";

	    " seem interested.";
	4:  print_ret (CHeorShe) actor, " give", (CaseEndings) actor, " ", (the) noun, " to ", (ThatorThose) second, ".";
    }
  Go: switch (n) {
        1:  print (CHeorShe) actor, " will have to get";
            if (actor.insideofparent  || actor.behindparent) print " out of ";
            if (actor.ontopofparent) print " off of ";
            if (actor.beneathparent) print " out from under ";
            if (x1) print_ret (the) x1, " first.";
		else print_ret (the) parent(actor), " first.";
        2:  print_ret (CHeorShe) actor, " can't go that way.";
        3:  print_ret (CHeorShe) actor, " ", (IsorAre) actor, " unable to climb ", (the) x1, ".";
        4:  print_ret (CHeorShe) actor, " ", (IsorAre) actor, " unable to descend by ", (the) x1, ".";
        5:  print_ret (CHeorShe) actor, " can't, because ", (the) x1, " ", (IsorAre) x1, " in the way.";
        6:  print (CHeorShe) actor, " can't, since ", (the) x1;
		if (x1 has pluralname) " lead nowhere."; else " leads nowhere.";
	7:  x2 = actor.location; print (The) actor, " walk";
		CaseEndings(actor);
		switch (x1) {
			e_obj: print " east";
			w_obj: print " west";
			n_obj: print " north";
			s_obj: print " south";
			se_obj: print " southeast";
			sw_obj: print " southwest";
			ne_obj: print " northeast";
			nw_obj: print " northwest";
			u_obj: print " up";
			d_obj: print " down";
			in_obj: print " inside";
			out_obj: print " out";
		}
		if (x2.visited && x2.travel_name ~= 0 or NULL)
			{ print " to the "; if (PrintorRun(x2, travel_name, true) == 0) print (name) x2; ".";
			}
		".";
	8: x2 = actor.old_loc;
	   print (The) actor, " walk";
		CaseEndings(actor); print " in from ";
		if (x2.visited == true) {
			print "the ";
			if (PrintorRun(x2, travel_name, true) == 0) print (name) x2; ".";
		}
		switch (x1) {
			e_obj: "the east.";
			w_obj: "the west.";
			n_obj: "the north.";
			s_obj: "the south.";
			se_obj: "the southeast.";
			sw_obj: "the southwest.";
			ne_obj: "the northeast.";
			nw_obj: "the northwest.";
			u_obj: "above.";
			d_obj: "below.";
			default: print (the) x1; ".";
		}
	10:  print (CHeorShe) actor, " will have to get";
           if (actor.insideofparent == true || actor.behindparent == true) print " out of ";
           if (actor.ontopofparent == true) print " off of ";
           if (actor.beneathparent == true) print " out from under ";
           print_ret (the) parent(actor), " first.";
	11: "You can travel using compass directions.";
	12: print_ret (The) actor, " ", (Has) actor, " not gone anywhere yet.";
    }
! Hug: see Miscellany 59
  Insert: switch (n) {
        2:  print_ret (CThatorThose) x1, " can't have things inside of ", (ItorThem) x1, ".";
        3:  print_ret (The) x1, " ", (IsorAre) x1, " closed.";
        4:  print_ret (CHeorShe) actor, " will need to take ", (ItorThem) x1, " off first.";
        8:  "Done.";
        10: "There isn't enough space for ", (the) x1, " inside ", (the) x2, ".";
    }
  Inv: switch (n) {
        2:  print (CHeorShe) player, " ", (IsorAre) player, " carrying";
        3:  ":";
        4:  ".";
    }
  Jump:     print_ret (CHeorShe) actor, " jump", (CaseEndings) actor, " on the spot, fruitlessly.";
  JumpOver, Rub:
	print_ret (CHeorShe) actor, " would achieve nothing by this.";
  Kick: switch (n) {
	  1: print_ret (CHeorShe) actor, " would only make an enemy by kicking ", (the) x1, ".";
 	  2: "Kicking ", (the) x1, " would be fruitless.";
	  3: "Kicking oneself would be fruitless.";
    }
! Kiss: see Miscellany 59
  Kill: switch (n) {
	  1: "Death is not the answer here.";
	  2: print_ret (CThatorThose) x1, " ", (IsntorArent) x1, " alive to begin with.";
    }
  Lie: switch (n) {
	1: print_ret (CHeorShe) actor, " lie", (CaseEndings) actor, " down.";
    }
  Listen: switch (n) {
	1: print_ret (CheorShe) actor, " hear", (CaseEndings) actor, " nothing unexpected.";
	2: print (CHeorShe) actor, " can't hear ", (the) x1, " from ";
		if (actor == player) "here.";
		"there.";
    }
  ListMiscellany: switch (n) {
	11:	if (~~parent(x1) ofclass Container) return;
		if (x1.insideofparent) print " (in ", (the) parent(x1);
		if (x1.ontopofparent) print " (on ", (the) parent(x1);
		if (x1.behindparent) print " (behind ", (the) parent(x1);
		if (x1.beneathparent) print " (under ", (the) parent(x1);
		if (x1.attachedtoparent) print " (attached to ", (the) parent(x1);
		if (x2) print " [", parent(x1), "] ) ";
		else print ")";
	12: if (PrintorRun(x1, open_desc, true) == 0) print "open";
	13: if (x2 == 0) print ", but empty";
		else print " but empty";
	14: if (PrintorRun(x1, open_desc, true) == 0) print "closed";
	18: print " containing ";
	19: print "on ";
	22: print "in ";
	24: print "behind ";
	28: print "sitting";
	29: print "standing";
	30: print "laying";
	33: print "; inside ", (HeorShe) actor, " can see ";
	34: print "; underneath ", (HeorShe) actor, " can see ";
	35: print "; and behind ", (ItorThem) x1, " ", (HeorShe) actor, " can see ";
	36: 
		if (PrintorRun(x1, worn_desc, true) == 0)
		   { if (x1 in player) print "which you are wearing";
			else print "which is being worn";
		   }
	37: if (PrintorRun(x1, light_desc, true) == 0) print "providing light";
	38: if (PrintorRun(x1, switched_desc, true) == 0) {
		if (x1 has on) print "switched on"; else print "switched off"; }
	39: print "under ";
	44: print "attached to ";
    }
  Lock: switch (n) {
	1: print (The) x1; if (x1 has pluralname) print " don't "; else print " doesn't ";
		"seem to be something ", (HeorShe) actor, " can lock.";
	2: print_ret (CTheyreorThats) x1, " locked at the moment.";
	3: "First ", (HeorShe) actor, "'ll have to close ", (the) x1, ".";
	5: print_ret (CHeorShe) actor, " lock", (CaseEndings) actor, " ", (the) x1, ".";
	6: "First ", (HeorShe) actor, "'ll have to open ", (the) x1, ".";
    }
  Look: switch (n) {
        1:  print " (";
	    switch(actor.posture) {
		1: L__M(##ListMiscellany, 29);
		2: L__M(##ListMiscellany, 28);
		3: L__M(##ListMiscellany, 30);
	    }
	    print " on ", (the) x1, ")";
        2:  print " (";
	    switch(actor.posture) {
		1: L__M(##ListMiscellany, 29);
		2: L__M(##ListMiscellany, 28);
		3: L__M(##ListMiscellany, 30);
	    }
	    print " in ", (the) x1, ")";
        3:  print " (as ", (object) x1, ")";
        4:  print "^On ", (the) x1;
            WriteListFrom(child(x1),
              ENGLISH_BIT + RECURSE_BIT + PARTINV_BIT + TERSE_BIT + CONCEAL_BIT + ISARE_BIT);
            ".";
        6:  if (x1 ~= player.location)
		{ DescribeChildren(x1, 2); return; }

		objectloop (i in x1 && i hasnt concealed && i hasnt scenery && i hasnt animate &&
			i has workflag) x2++;

	if (x2) {
            print "^", (CHeorShe) actor, " can see ";
            WriteListFrom(child(x1),
              ENGLISH_BIT+RECURSE_BIT+PARTINV_BIT+TERSE_BIT+CONCEAL_BIT+WORKFLAG_BIT);
            if (x1 ~= player.location) print ".^"; else print " here.^"; }
        7:  print_ret (CHeorShe) actor, " see", (CaseEndings) actor, " nothing unexpected in that direction.";
	8:  print " (";
	    switch(actor.posture) {
		1: L__M(##ListMiscellany, 29);
		2: L__M(##ListMiscellany, 28);
		3: L__M(##ListMiscellany, 30);
	    }
	    print " behind ", (the) x1, ")";
	9:  print " (";
	    switch(actor.posture) {
		1: L__M(##ListMiscellany, 29);
		2: L__M(##ListMiscellany, 28);
		3: L__M(##ListMiscellany, 30);
	    }
	    print " under ", (the) x1, ")";
	10: print "^In the darkness, ", (HeorShe) actor, " can see ";
		WriteListFrom(child(x1), TERSE_BIT + ENGLISH_BIT + WORKFLAG_BIT); ".";
	11: print (The) x1, " ", (IsorAre) x1;
		switch (x1.posture) {
			1: print " standing";
			2: print " sitting";
			3: print " lying down";
		}
		if (x1.ontopofparent) print " on";
		if (x1.insideofparent) print " in";
		if (x1.behindparent) print " behind";
		if (x1.beneathparent) print " under";
	     if (parent(x1) == x1.location) print " here.";
	     else print " ", (the) parent(x1), ".";
    }
  LookAttached: switch (n) {
	  1: print "There ";
		if (CountChildren(x1, 5, 3) < 2)
			print "is"; else print "are";
		print " nothing attached to ", (ItorThem) x1, ".";
	  2: "Attached to ", (ItorThem) x1, " ", (HeorShe) actor, " can see ";
    }
  LookBehind: switch (n) {
	  1: print_ret (CHeorShe) actor, " cannot see behind ", (the) x1, ".";
	  2: print_ret (CThatorThose) x1, " can't have things behind ", (ItorThem) x1, ".";
	  3: print "There ";
		if (CountChildren(x1, 1, 3) < 2)
			print "is"; else print "are";
		print " nothing behind ", (ItorThem) x1, ".";
	  5: print "Behind ", (the) x1, " ", (HeorShe) actor, " can see ";
    }
  LookInside: switch (n) {
	  1: print "There ";
		if (CountChildren(x1, 3, 3) < 2)
			print "is"; else print "are";
		print " nothing inside of ", (ItorThem) x1, ".";
	  3: print "Inside ", (the) x1, " ", (HeorShe) actor, " can see ";
	  4: print_ret (CHeorShe) actor, " can't see inside ", (the) x1, " from underneath ", (the) parent(x1), ".";
	}
  LookMode: switch (n) {
	  1: " ~brief~ printing mode, which gives long descriptions
            of places never before visited and short descriptions otherwise.]";
	  2: " ~verbose~ printing mode, which always gives long descriptions
             of locations (even if you've been there before).]";
	  3: "  ~superbrief~ printing mode, which always gives short descriptions
             of locations (even if you haven't been there before).]";
	}
  LookOnTop: switch (n) {
	1: print "There ";
		if (CountChildren(x1, 4, 3) < 2)
			print "is"; else print "are";
		print " nothing on top of ", (HeorShe) x1, ".";
	3: print "On top of ", (the) x1, " ", (HeorShe) actor, " can see ";
	}
  LookUnder: switch (n) {
	4: print "There ";
		if (CountChildren(x1, 2, 3) < 2)
			print "is"; else print "are";
		print " nothing underneath ", (HeorShe) x1, ".";
	5: print_ret (CHeorShe) actor, " cannot see under ", (the) x1, ".";
	6: print "Beneath ", (the) x1, " ", (HeorShe) actor, " can see ";
	}
  Mild:     "Quite.";
  Miscellany: switch (n) {
        1:  "(considering the first sixteen objects only)^";
        2:  "Nothing to do!";
        3:  print " You have died ";
        4:  print " You have won ";
        5:  print "^Would you like to RESTART, RESTORE a saved game";
            #Ifdef DEATH_MENTION_UNDO;
            print ", UNDO your last move";
            #Endif;
            if (TASKS_PROVIDED == 0) print ", give the FULL score for that game";
		#Ifdef AMUSING_PROVIDED;
            if (gameover == 2 && AMUSING_PROVIDED == 0)
                print ", see some suggestions for AMUSING things to do";
		#Endif;
            " or QUIT?";
        6:  "[Your interpreter does not provide ~undo~.  Sorry!]";
            #Ifdef TARGET_ZCODE;
        7:  "~Undo~ failed.  [Not all interpreters provide it.]";
            #Ifnot; ! TARGET_GLULX
        7:  "[You cannot ~undo~ any further.]";
            #Endif; ! TARGET_
        8:  "Please give one of the answers above.";
        9:  print "^It is ";

	if (actor.&last_action-->0 ~= ##Enter or ##GetInside or ##GetBeneath or
		##GetBehind or ##GetOn or ##Exit) print "now ";

	if (player.visibility_ceiling == player.location)
			"pitch dark in here.";
	    else {	print "pitch dark ";
			if (player.insideofparent == true) "in here.";
			if (player.beneathparent == true) "down here.";
			if (player.behindparent == true) "back here.";
			if (player.ontopofparent == true) "up here.";
		}
        10: "[No command entered.]";
        11: "[You can't ~undo~ on the first turn.]";
        12: "[Can't ~undo~ twice in succession.]";
        13: "[Previous turn undone.]";
        14: "[There is nothing to correct.]";
        15: "Think nothing of it.";
        16: "[~Oops~ can only correct a single word.]";
        17: "It is pitch dark, and you can't see a thing.";
        18: print "yourself";
        19: "As good-looking as ever.";
        20: "[To repeat a command like ~frog, jump~, just say ~again~, not ~frog, again~.]";
        21: "[You can hardly repeat that.]";
        22: "[You can't begin with a comma.]";
        23: "You seem to want to talk to someone, but I can't see whom.";
        24: "You can't talk to ", (the) x1, ".";
        25: "[To talk to someone, try ~someone, hello~ or some such.]";
        26: print "(first taking ", (the) x1;
		if (~~parent(x1) ofclass Room) print " from ", (the) parent(x1), ")";
		else print ")"; if (~~multiflag) new_line; else print " ";
        27: "[I didn't understand that sentence.]";
        28: print "I only understood you as far as wanting to ";
        29: "[I didn't understand that number.]";
        30: "You can't see any such thing.";
        32: "An impossibility.";
        33: "[You can't use multiple objects with that verb.]";
        34: "[You can only use multiple objects once on a line.]";
        35: "[Right now, ~", (address) pronoun_word, "~ does not refer to anything.]";
        36: "[You excepted something not included anyway.]";
        37: print_ret (CHeorShe) actor, " can only do that to a person.";
        38: print "[This game does not know the verb ~";
		#Ifdef TARGET_ZCODE;
		x1 = parse->(4*verb_wordnum + 1);    ! start posn in buffer
		x2 = parse->(4*verb_wordnum);        ! number of characters
		#Ifnot; ! TARGET_GLULX
		x1 = parse-->(3*verb_wordnum);       ! start posn in buffer
		x2 = parse-->(3*verb_wordnum - 1);   ! number of characters
		#Endif; ! TARGET_
		for (i=0 : i<x2 : i++) print (char) Lowercase(buffer->(i+x1));
		 "~.]";
        39: "That's not something you need to refer to in this game.";
        40: "You can't see ~", (address) pronoun_word, "~ (", (the) pronoun_obj, ") at the moment.";
        41: "[I didn't understand the way that finished.]";
        42: if (x1 == 0) print "None"; else print "Only ", (number) x1;
            print " of those ";
            if (x1 == 1) print "is"; else print "are";
            " available.";
        43: "There is nothing there to ", (address) verb_word, ".";
	44: if (x1) {
			if (x2 == 0)
				"(", (CHeorShe) actor, " ", (IsorAre) actor, " only carrying ", (number) x1, ".)";

			print "(Only ", (number) x1, " ";
			if (x2 == 1) print "is"; else print "are";
			" available.)";
		}
		print_ret (CHeorShe) actor, " ",  (IsntorArent) actor, " carrying anything.";
        45: print "Whom do you mean, ";
        46: print "Which do you mean, ";
        47: "Sorry, you can only have one item here. Which exactly?";
        48: print "Whom do you want";
            if (actor ~= player) print " ", (ThatorThose) actor;
            print " to "; PrintCommand(); print "?^";
        49:
            if (action_to_be == ##Answer or ##Tell && consult_words ~= 0) print "Who";
            else if (action_to_be == ##Insert or ##PutOn) print "Where";
            else print "What";
            print " do you want";
            if (actor ~= player) print " ", (ThatorThose) actor;
            print " to "; PrintCommand(); print "?^";
        50: print "Your score has just gone ";
            if (x1 > 0) print "up"; else { x1 = -x1; print "down"; }
            print " by ", (number) x1, " point";
            if (x1 > 1) print "s";
        51: "[Since something dramatic has happened, your list of commands has been cut short.]";
        52: "^Type a number from 1 to ", x1, ", 0 to redisplay or press ENTER.";
        53: "^[Please press SPACE.]";
        54: "[Comment recorded.]";
        55: "[Comment NOT recorded.]";
        56: print ".^";
        57: print "?^";
	58: print (CHeorShe) actor, " can't put anything ";
            switch (action)
		{ ##PutOn: print "onto ";
		  ##Insert: print "into ";
		  ##PutBehind: print "behind ";
		  ##PutUnder: print "beneath ";
		}
		print (HimselforHerself) actor; ".";
	59: print_ret (The) x1, " probably wouldn't care for that right now.";
	#IFDEF GRADUAL_LIGHT;
	60: if (actor.&last_action-->0 ~= ##Go or ##Enter or ##GetInside or ##GetBeneath or
		##GetBehind or ##GetOn or ##Exit) "^The light here has brightened.";
	61: if (actor.&last_action-->0 ~= ##Go or ##Enter or ##GetInside or ##GetBeneath or
		##GetBehind or ##GetOn or ##Exit) "^The light here has dimmed.";
	#ENDIF;
	62: print_ret (CHeorShe) actor, " already ", (IsorAre) actor, ".";
	63: print_ret (CHeorShe) actor, " can't get at ", (the) x1, ".";
	64: "[But you haven't done anything yet!]";
	65: "(first opening ", (the) x1, ")";
	66: print "[", (string) Story, " is already in its";
	67: print "[", (string) Story, " is now in its";
	68: "That doesn't make sense.";
	69: "You'll need something to do that with.";
	70: if (player.insideofparent) print "In ";
	    if (player.ontopofparent) print "On ";
	    if (player.beneathparent) print "Under ";
	    if (player.behindparent) print "Behind ";
	71: if (action == ##Search) "Nothing of interest."; "There's nothing to be read there.";
	72: print_ret "But ", (the) x1, " ", (IsorAre) x1, " opaque.";
	73: print_ret (The) x1, " ", (IsntorArent) x1, " here to be consulted.";
	74: "(first closing ", (the) x1, ")";
	75: "You were able to ", (address) verb_word, " ", x2, " of them.";
    }
  No, Yes:  "No question has been asked.";
  #Ifndef NO_SCORE;
  NotifyOff:
            "[Score notification off.]";
  NotifyOn: "[Score notification on.]";
  #Endif;
  Objects: if (action == ##Objects) print "   "; switch (n) {
        1:  "Objects you have handled:^";
        2:  "None.";
        3:  print "(worn)";
        4:  print "(held)";
        5:  print "(given away)";
        6:  print "(in ", (name) x1, ")";
        7:  print "(in ", (the) x1, ")";
        8:  print "(inside ", (the) x1, ")";
        9:  print "(on ", (the) x1, ")";
        10: print "(lost)";
        11: print "(behind ", (the) x1, ")";
        12: print "(under ", (the) x1, ")";
	13: print "(attached to ", (the) x1, ")";
    }
  Open: switch (n) {
        1:  print_ret (CTheyreorThats) x1, " not something ", (HeorShe) actor, " can open.";
        2:  if (actor == player) print_ret (CItorThem) x1, " seems to be locked.";
			print_ret (The) actor, " unsuccessfully tries to open ", (the) x1, ".";
        3:  print_ret (CTheyreorThats) x1, " already open.";
        4:  print (The) actor, " open", (CaseEndings) actor, " ", (the) x1, ", revealing ";
		objectloop(i && (IndirectlyContains(x1, i)))
		{ if (IsVisible(i, player) && i.insideofparent)
			{ give i workflag; if (i hasnt topic) give i topic; j++; }
		  else give i ~workflag;
		}
		if(j == 0) "nothing.";
		WriteListFrom(child(x1), TERSE_BIT + ENGLISH_BIT + RECURSE_BIT + WORKFLAG_BIT);
		".";
        5:  print_ret (The) actor, " open", (CaseEndings) actor, " ", (the) x1, ".";
    }
  Order: print (The) n; if (n has pluralname) print " have"; else print " has";
            " better things to do.";
  Places: switch (n) {
        1:  print "You have visited: ";
        2:  print ".^";
    }
  Pray:  "Nothing practical results from ", (HisorHer) actor, " prayer.";
  Prompt:   print "^>";
  Pronouns: switch (n) {
        1:  print "At the moment, ";
        2:  print "means ";
        3:  print "is unset";
        4:  "no pronouns are known to the game.";
        5:  ".";
    }
  Pull, Push, Turn: switch (n) {
        1:  if (actor == player) print_ret (CThatorThose) x1, " ", (IsorAre) x1, " fixed in place.";
		else print_ret (The) actor, " tries to move ", (the) noun, " unsuccessfully.";
        2:  print_ret (CHeorShe) actor, " ", (IsorAre) actor, " unable to.";
        3:  "Nothing obvious happens.";
        4:  "That would be less than courteous.";
    }
  Punch: switch (n) {
	  1: "Punching ", (Thatorthose) x1, " would be fruitless.";
	  2: print_ret (CHeorShe) actor, " would only make an enemy by punching ", (the) x1, ".";
	  3: "Punching oneself would be fruitless.";
    }
! Push: see Pull
  PushDir: switch (n) {
        1:  "Is that the best you can think of?";
        2:  "That's not a direction.";
        3:  "Not that way ", (HeorShe) actor, " can't.";
    }
  PutOn: switch (n) {
	2: "But ", (the) x1, " ", (IsorAre) x1, " already ", (string) i, " ", (the) x2, "!";
	3:  print_ret (CThatorThose) x1, " can't have things ", (string) x2, " ", (ItorThem) x1, ".";
        4:  print_ret (CHeorShe) actor, " lack", (CaseEndings) actor, " the dexterity.";
        5:  "There is no more room ", (string) x2, " ", (the) x1, ".";
        8:  print_ret (CHeorShe) actor, " put", (CaseEndings) actor, " ", (the) x1, " ", (string) x2, " ", (the) second, ".";
	9:  "Because ", (HeorShe) x1, " ", (IsorAre) x1, " open, there ", (IsorAre) x1, " no room ", (string) x2, " of ", (ItorThem) x1, ".";
	10: "There isn't enough space for ", (the) noun, " ", (string) x1, " ", (the) second, ".";
	11: print_ret (CHeorShe) actor, " can't put anything ", (string) x1, " something ", (HeorShe) actor, " ", (IsorAre) actor, " carrying.";
	12: "One can't put anything ", (string) x1, " itself.";
	}
  PutUnder: print_ret (CThatorThose) x1, " can't have things underneath ", (ItorThem) x1, ".";
  Quit: switch (n) {
        1:  print "[Please answer yes or no.]";
        2:  print "[Are you sure you want to quit?] ";
    }
  Restart: switch (n) {
        1:  print "[Are you sure you want to restart? You will lose all progress since your last save.] ";
        2:  "[Failed.]";
    }
  Restore: switch (n) {
        1:  "[Restore failed.]";
        2:  "[Ok.]";
    }
  Save: switch (n) {
        1:  "[Save failed.]";
        2:  "[Ok.]";
    }
  #Ifndef NO_SCORE;
  Score: switch (n) {
        1:  if (gameover) print "In that game you scored "; else print "You have so far scored ";
            print score, " out of a possible ", MAX_SCORE, ", in ", turns, " turn";
            if (turns ~= 1) print "s";
            return;
        2:  "There is no score in this game.";
    }
  #Endif;
  ScriptOff: switch (n) {
        1:  "[Transcripting is already off.]";
        2:  "[^End of transcript.]";
        3:  "[Attempt to end transcript failed.]";
    }
  ScriptOn: switch (n) {
        1:  "[Transcripting is already on.]";
        2:  "[Start of a transcript of";
        3:  "[Attempt to begin transcript failed.]";
    }
  Search: switch (n) {
        1:  "It's too dark.";
	  2:  print_ret (The) actor, " looks over ", (the) noun, ".";
        3:  print "On ", (the) x1;
            WriteListFrom(child(x1), ENGLISH_BIT + TERSE_BIT + CONCEAL_BIT + ISARE_BIT);
            ".";
        5:  print (CHeorShe) actor, " can't see inside, since ", (the) x1, " ", (IsorAre) x1, " closed.";
        7:  print "In ", (the) x1;
            WriteListFrom(child(x1), ENGLISH_BIT + TERSE_BIT + CONCEAL_BIT + ISARE_BIT);
            ".";
    }
  Set:	if (x1 == actor) "One can't set oneself.";
	print_ret (CHeorShe) actor, " can't set ", (ThatorThose) x1, ".";
  SetTo:
	if (x1 == actor) "One can't set oneself to anything.";
	print_ret (CHeorShe) actor, " can't set ", (ThatorThose) x1, " to anything.";
  Show: switch (n) {
        2:  print_ret (The) x1, " ", (IsorAre) x1, " unimpressed.";
    }
  Sing:     "The occasion doesn't call for it.";
  Sit: switch (n) {
	1: print (CHeorShe) actor, " sit", (CaseEndings) actor, " down.";
	2: print (CHeorShe) actor, " sit", (CaseEndings) actor, " up.";
    }
  Sleep:    print_ret (CHeorShe) actor, " ", (IsntorArent) actor, " feeling especially drowsy.";
  Smell: switch (n) {
	1: print_ret (CHeorShe) actor, " smell", (CaseEndings) actor, " nothing unexpected.";
	2: print (CHeorShe) actor, " can't smell ", (the) x1, " from ";
		if (actor == player) "here.";
		"there.";
    }
            #Ifdef DIALECT_US;
  Sorry:    "Oh, don't apologize.";
            #Ifnot;
  Sorry:    "Oh, don't apologise.";
            #Endif;
  Squeeze: switch (n) {
        1:  "Keep your hands to yourself.";
        2:  print (CHeorShe) actor, " achieve";
		CaseEndings (actor);
	    print_ret " nothing by this.";
    }
  Stand: switch (n) {
	1: print (CHeorShe) actor, " stand", (CaseEndings) actor, " up";
		if (actor.behindparent) print " behind ", (the) parent(actor);
		if (actor.beneathparent) print " under ", (the) parent(actor);
		if (actor.insideofparent) print " inside ", (the) parent(actor);
		if (actor.ontopofparent) print " on ", (the) parent(actor);
		".";
	2: print_ret (CHeorShe) actor, " ", (IsorAre) actor, " already standing.";
    }
  Strong:   "Real adventurers do not use such language.";
  Swim:     "There's nothing to swim in.";
  Swing:    "Nothing obvious happens.";
  SwitchOff: switch (n) {
        1:  print_ret (CTheyreorThats) x1, " not something ", (HeorShe) actor, " can switch.";
        2:  print_ret (CTheyreorThats) x1, " already off.";
        3:  print_ret (CHeorShe) actor, " switch", (CaseEndings) actor, " ", (the) x1, " off.";
    }
  SwitchOn: switch (n) {
        2:  print_ret (CTheyreorThats) x1, " already on.";
        3:  print_ret (CHeorShe) actor, " switch", (CaseEndings) actor, " ", (the) x1, " on.";
	4:  print_ret "You can't see ", (the) x1, " right now.";
    }
  Take: switch (n) {
        1:  if (behindorbeneath == 0) {
			if (multiflag) "Taken.";
			else print (The) actor, " take", (CaseEndings) actor, " ", (the) x1, ".^"; return;
		}
	    	print (The) actor, " pick", (CaseEndings) actor, " up ", (the) x1, ", revealing ";
            WriteListFrom(child(x2),
              ENGLISH_BIT+RECURSE_BIT+PARTINV_BIT+TERSE_BIT+CONCEAL_BIT+WORKFLAG_BIT);
		behindorbeneath = 0; ".";
	2:  print_ret (The) x1, " ", (IsorAre) x1, " not there.";
        3:  if (x1 == actor) "An impossibility.";
	    if (x1 == player) "You can't be taken.";
	    print_ret (The) x1, " would certainly object to that.";
        5:  print_ret (CHeorShe) x2, " already ", (Has) x2, " ", (ThatorThose) x1, ".";
        6:  if (actor == player) {
		print (CThatorThose) noun, " seem";
		if (noun hasnt pluralname) print "s"; " to belong to ", (the) x1, ".";
		}
	    print (The) actor, " seems to want ", (the) noun;
	    if (x1 == player) "."; else " but ", (the) x1, " ", (IsorAre) x1, " keeping ", (ItorThem) noun, ".";
        7:  print (CThatorThose) x1, " seem";
		if (x1 hasnt pluralname) print "s";
            " to be a part of ", (the) x2, ".";
        9:  print_ret (The) x1, " ", (IsntorArent) x1, " open.";
        10: print_ret (CTheyreorThats) x1, " hardly portable.";
        11: print_ret (CTheyreorThats) x1, " fixed in place.";
        12: print_ret (CHeorShe) actor, " ", (IsorAre) actor, " carrying too much already.";
        13: "(first putting ", (the) x1, " into ", (the) x2, " to make room)^";
    }
  Taste:    print_ret (CHeorShe) actor, " taste", (CaseEndings) actor, " nothing unexpected.";
  Tell: switch (n) {
        1:  print_ret (CHeorShe) actor, " talk", (CaseEndings) actor, " to yourself a while.";
        2:  "This provokes no reaction.";
    }
  Tie: print_ret (CThatorThose) x1, " ", (IsntorArent) x1, " tieable.";
  Think:   "What a good idea.";
  ThrowAt: "There's no need for that.";
! Tie:  see JumpOver.
  Torture: "That's horrible!";
  Touch: switch (n) {
        1:  "Keep your hands to yourself!";
        2:  print_ret (CHeorShe) actor, " feel", (CaseEndings) actor, " nothing unexpected.";
	4:  print(The) actor, " can't ", (PrintCommand) 0, " from ";
		switch (IndirectlyContains(x1, actor)) {
			1: print "inside of";
			2: print "on top of";
			3: print "behind";
			4: print "beneath";
		}
 		" ", (the) x1, ".";
    }
! Turn: see Pull.
  Unlock:  switch (n) {
	1:  "(first unlocking ", (the) x1, ")";
	2:  print_ret (CTheyreorThats) x1, " already unlocked.";
	3:  if (x1 has pluralname) print "They don't ";
		else print "That doesn't ";
		"seem to be able to do the job.";
	4:  print (The) actor, " unlock", (CaseEndings) actor, " ", (the) x1;
		if (x2) " using ", (the) x2, ".";
		else ".";
	5:  "(with ", (the) x1, ")^";
	6:  "(trying ", (the) x1, ")^";
	7:  print (The) actor, " tries to unlock ", (the) noun;
	    if (second) print " with ", (the) second; ".";
    }
  Use: "[I'm not sure what you mean by ~", (address) verb_word, "~. Please try a more specific verb.]";
  VagueGo:  "You'll have to say which compass direction to go in.";
  Verify: switch (n) {
        1:  "The game file has verified as intact.";
        2:  "The game file did not verify as intact, and may be corrupt.";
    }
  Wait:     "Time passes.";
  Wake:     "The dreadful truth is, this is not a dream.";
  WakeOther: "That seems unnecessary.";
  Wave: switch (n) {
        2:  print_ret (CHeorShe) actor, " look", (CaseEndings) actor, " ridiculous waving ", (the) x1, ".";
    }
  WaveHands: print_ret (CHeorShe) actor, " wave", (CaseEndings) actor, ", feeling foolish.";
  Wear: switch (n) {
        1:  print_ret (CHeorShe) actor, " can't wear ", (ThatorThose) x1, "!";
        3:  print_ret (CHeorShe) actor, " ", (IsorAre) actor, " already wearing ", (ThatorThose) x1, "!";
        4:  print (CHeorShe) actor, " put", (CaseEndings) actor, " ", "on ", (the) x1, ". ";
		if (lookmode == 2) DescribeClothes(actor, true); else print "^";
	#IFDEF COMPLEXCLOTHING;
        5:  print_ret (CTheyreorThats) x1, " for girls.";
        6:  print_ret (CTheyreorThats) x1, " for boys.";
	7:  print_ret (CTheyreorThats) x1, " not for humans.";
	9:  print (CThatorThose) x1, " won't fit over all that ", (CHeorShe) actor, " ", (IsorAre) actor, " wearing.";
	10: print_ret (CHeorShe) actor, " ", (IsntorArent) actor, " wearing enough yet.";
	11: print_ret (CHeorShe) actor, " can't, because ", (HeorShe) actor, " ",
		(IsorAre) actor, " wearing too much underneath ", (the) x1, ".";
	12: print_ret (CHeorShe) actor, " can't, because ", (the) x1, " ", (IsorAre) x1, " too bulky.";
	13: print (CHeorShe) actor, " slip", (CaseEndings) actor, " ", (the) noun, " on underneath ", (the) x1, ". ";
		if (lookmode == 2) DescribeClothes(actor, true); else print "^";
	14: print (CHeorShe) actor, " put", (CaseEndings) actor, " ", (the) noun, " on over ", (the) x1, ". ";
		if (lookmode == 2) DescribeClothes(actor, true); else print "^";
	#ENDIF;
	15: if (x1 == player) {
		print (CHeorShe) actor, " ", (IsorAre) actor, " ";
		if (x2) print "now "; print "wearing ";
	    }
	    else { 
		print "You can "; if (x2) print "now "; print "see that ", (TheyAreorThatIs) x1, " wearing ";
	    }
    }
! Yes:  see No.
];

! ==============================================================================

Constant LIBRARY_ENGLISH;       ! For dependency checking.

! ==============================================================================