#ifndef FUNCS
#define FUNCS
#pragma C+

/*
** Funcs.t contains several functions which I've found useful.  They are:
**
** moveAllCont(src, dest) -- takes all of the contents in object src and
**                           moves them into dest.
** uberloc(obj) -- Returns the room an object is in, no matter how deeply
**                 nested that object is in other objects.  Note that if
**                 an object has isUber = true, then uberloc considers
**                 that object to be the top of the location tree.
** inside(obj, loc) -- Returns true if obj is contained in loc, false if
**                     it isn't.
** deepcont(objs) -- Returns all contents of an object (or list of objects),
**                   no matter how deep in the content tree they are.
** deeplistcont(objs) -- Returns all *listable* contents of an object or
**                       list of objects.
** Copyright (c) 1995, 1996 Stephen Granade
** You are permitted to distribute this module freely, as long as 1) my name
** is left on it, and 2) you keep all files together.  You may also use
** this module in any game you like in any form you like.  Hack away at
** it, if you so desire.  All I ask is that you credit me in some way in your
** game.
** I would welcome any comments on or suggestions for this module.  I can be
** reached at:
**  Duke University Physics Department
**  Box 90305
**  Durham, NC  27708-0305
**  U.S.A.
**  sgranade@phy.duke.edu
**
** Version history:
**  29 Dec 95 -- Initial release
**   8 Jan 96 -- bug fix: moveallCont no longer moves fixeditems.
*/

#include "version.t"

funcsVersion: versionTag
    id="$Id: funcs.t v 1.1  8 Jan 96\n"
;

// moveAllCont takes all the contents in the object src and moves them into
//  dest.  It checks for fixeditems, &c.
moveAllCont: function(src, dest)
{
    local cont, i, len;

    cont = src.contents;
    len = length(cont);
    for (i = 1; i <= len; i++)
        if (!cont[i].isfixed)
            cont[i].moveInto(dest);
}

// uberloc returns the room an object is in, no matter how deeply nested
uberloc: function(ob)
{
    local loc;

    loc = ob;
    while (loc.location) {
        if (loc.isUber) return loc;
        loc = loc.location;
    }
    return loc;
}

// inside returns true if obj is contained in loc, no matter how deeply nested
inside: function(ob, loc)
{
    local cur_loc;

    cur_loc = ob.location;
    while (cur_loc) {
        if (cur_loc == loc)
            return true;
        cur_loc = cur_loc.location;
    }
    return nil;
}

// deepcont returns ALL contents of an object, however deep in the content tree
deepcont : function(objs)
{
    local i, len, contcont;

    i = datatype(objs);
    if (i == 5) return ([]);
    if (i == 2) {
        if (length(objs.contents) == 0)
            return ([]);
        return ([] + objs.contents + deepcont(objs.contents));
    }
    len = length(objs);
    contcont = [];
    for (i = 1; i <= len; i++)
        contcont += objs[i].contents + deepcont(objs[i].contents);
    return ([] + contcont);
}

// deeplistcont returns ALL listable contents of an object, however deep
deeplistcont : function( objs )
{
    local contents, viscontents, i, len;

    contents = deepcont(objs);
    viscontents = [];
    len = length(contents);
    for (i = 1; i <= len; i++) {
        if (contents[i].isListed)
            viscontents += contents[i];
    }
    return viscontents;
}

#endif
