#include "adv.t"
#include "clothing.t"
#include "std.t"

/*
 *	The first two items are there to demonstrate clothingItem objects with
 *	default behavior--they use none of the new features.
 */
shirtItem: clothingItem
	sdesc = "Hawaiian shirt"
	ldesc = "This is a gaudy Hawaiian shirt, like those classically
			worn by tourists. Must have been a costume. "
	noun = 'shirt'
	adjective = 'Hawaiian' 'gaudy'
	location = startroom
;

pantsItem: clothingItem
	// an unabashed Seinfeld reference
	sdesc = "pair of tan Dockers"
	ldesc = "This is a pair of casual pants, of the most boring shade
			of tan that you could possibly imagine. "
	noun = 'pants' 'dockers' 'jeans' 'slacks'
	adjective = 'pair of' 'tan'
	location = startroom
;

/*
 *	Here, I subclass clothingItem to create a clothing family.  I use the
 *	family feature, and I also provide a couple of custom messages to add
 *	some texture to the experience of using this kind of clothing.
 */
class maskItem: clothingItem
	family = 1
	noun = 'mask'
	beingWornDesc = "(on your face)"
	putOnDesc = { "%You% gingerly place "; self.thedesc; " over %your% eyes. "; }
	takeOffDesc = { "%You% carefully remove "; self.thedesc; " from %your% face. "; }
	autoTakeOffDesc = { "(Carefully taking off "; self.thedesc; " first)\n"; }
	// Uncomment the next line to demonstrate autoTakeOff
	// autoTakeOff = nil  
;

tragicMask: maskItem
	sdesc = "tragic mask"
	ldesc =	"This is a full tragic mask, of the sort described by
			Keith Johnstone in his book, \"Impro.\" "
	adjective = 'tragic' 'full'
	location = startroom
;

comicMask: maskItem
	sdesc = "comic mask"
	ldesc = "This is a comic half-mask, of the sort described by Keith
			Johnstone in his book, \"Impro.\" "
	adjective = 'comic' 'half'
	location = startroom
;

/*
 *	You may want to see yourself in costume...
 */
mirrorItem: fixeditem
	sdesc = "mirror"
	ldesc = "This full length mirror has an ornate wooden frame, and is
			quite something to behold. "
	noun = 'mirror'
	adjective = 'ornate' 'full length'
	location = startroom
	verDoTake( actor ) = {
		"The mirror is far too heavy to budge.  Better to content yourself
		with looking in it.  That what it's for. ";
	}
	verDoLookin( actor ) = {}
	doLookin( actor ) = { Me.doInspect( actor ); }
;

startroom: room
	sdesc = "Theater"
	ldesc = "You are in a magnificent old theater, which has evidently seen
			better days; the few remaining lighting instruments are clearly
			beyond repair, and dust covers every visible surface.  But you
			feel the power of this place in your spine.\nTo the side stands
			an old, large, and very ornate mirror. ";
;

/*
 *  The following is just for fun.  It is ugly, but it makes sense
 *  in the scenario.  I am not proud of it.  Back off, man.
 */
modify Me
	replace ldesc = {
		if (tragicMask.isworn) {
			"You look as if you were beset by all of the world's sorrows. ";
			if (shirtItem.isworn) {
				" This is in shocking contrast with the garish Hawaiian shirt
					you're sporting. ";
				if (pantsItem.isworn)
					" But those pants seem to match your expression. ";
			} else if (pantsItem.isworn)
				" This explains your choice of pants. ";
		} else if (comicMask.isworn) {
			"You look rather amused. ";
			if (shirtItem.isworn) {
				" Your expression matches your shirt quite well. ";
				if (pantsItem.isworn)
					" But those pants... I dunno. ";
			} else if (pantsItem.isworn)
				" This is in stark contrast with your stodgy pair of pants. ";
		} else
			pass ldesc;
	}
;
