#include <ADV.T>
#include <STD.T>
#include <DIALOG.T>

startroom: room
        sdesc = "Barracks"
        ldesc = "Red lights fly across the room and the red alert klaxon wails
                loudly.  All the beds are empty.  A doorway is leads out to the
                 west."
        west = hallway
;

Tom:  TalkingActor
        sdesc = "Tom"
        ldesc = "It\'s Tom, your best army buddy."

        openremark = &greet

        greet = ['\"C\'mon, let\'s get out of here!  The internal reactor
                core is about to blow!\" Urges Tom.', nil,
                '\"Can\'t someone stop it?\"', true, &stopit, '\"Okay, let\'s
                 go!\"', true, &bye]
        stopit = ['\"All the failsafes gave out!  Let\'s get going!\"', &runout]
        bye = ['\"Let\'s get going!\"', &runout]

        runout =
        {
                "Tom dashes out of the room.";
                Tom.moveInto( nil );
        }

        noun = 'Tom' 'friend' 'buddy'
        location = startroom
;

hallway: room
        sdesc = "Hallway"
        ldesc = "This hallways stretches to the north and south.  A doorway to
                the reactor core lies to the west."
        times = 0
        east = startroom
        west = outercore
        north = 
        { 
                if (self.times = 0)
                {
                        "Suddenly you feel constrained by some inane plot point, as
                                if some nerdy programmer decided he didn\'t want to come up with a
                                reason why you couldn\'t go north or south, and you suddenly have
                                an incredible urge to head west into the reactor core to stop the
                                reaction!";
                }
                if (self.times > 0 and self.times < 5)
                {
                        "Really!  I wouldn't kid you about something like this!  You
                        want to go west!";
                }
                if (self.times >4 )
                {
                        "Directed Dialog code by Trevor Powell";
                }
                self.times ++;
                return (nil);
        }
        south = 
        { 
                if (self.times = 1)
                {
                        "Suddenly you feel constrained by some inane plot point, as
                                if some nerdy programmer decided he didn\'t want to come up with a
                                reason why you couldn\'t go north or south, and you suddenly have
                                an incredible urge to head west into the reactor core to stop the
                                reaction!";
                }
                if (self.times > 2 and self.times < 5)
                {
                        "Really!  I wouldn't kid you about something like this!  You
                        want to go west!";
                }
                if (self.times >4 )
                {
                        "Directed Dialog code by Trevor Powell";
                }
                self.times++;
                return (nil);
        }
;

outercore:  room
        sdesc = "Outer Core"
        ldesc = "You're in a small room, separated from the inner core by a small
                non-descript doorway to the west."
        east = hallway
        west = innercore
;

oldman:  TalkingActor
        sdesc = "old man"
        adesc = "an old man"
        thedesc = "the old man"
        openremark = &greet
        greet = ['\"Ah, hello..\" mumbles the old man, peering closely at you.
                \"How may I help you?\"', &nada, '\"Who are you?\"', true, &notimp,
                '\"How can I stop the reactor from exploding?\"',
                (cork.location = nil), &reactor, '\"What am I supposed to do with
                 this cork?\"', (cork.location = Me), &whatdo,
                '\"Say, did I ever tell you about how I killed LeChuck?\"',
                (cork.location = nil),
                &notimp, '\"Excuse me.. I thought I wanted to talk to you, but I
                 don\'t.\"', true, &bye]
        notimp = ['\"That\'s no time for that now..  What is important is
                that you stop the inner core from exploding!\"', nil, '\"How can I
                do that?\"', true, &reactor, '\"Uh, I have to go now.. I think I
                hear my mother calling.\"', true, &bye]
        reactor = ['\"Here, take this!  You\'ll need it!\" He hands you an
                oversize cork.', &givecork, '\"What do I do with this?\"', true,
                 &whatdo, '\"Thanks!  Bye!\"', true, &bye]
        whatdo = ['The old man rolls his eyes and mumbles, \"Youth today... they
                want everything handed to them...\"  He looks back at you and says,
                \"You\'ll figure it out.\"  He turns away.', nil]
        bye = ['\"Bye.\"', nil]
        givecork =
        {
                cork.moveInto(Me);
        }
        noun = 'man'
        adjective = 'old'
        location = outercore
;

cork:  item
        sdesc = "cork"
        ldesc = "It's a large cork."
        noun = 'cork'
        adjective = 'large'
        location = nil
        doPutIn( actor, io ) =
        {
                if (io = pipe)
                {
                        "There's a loud grinding noise from inside the reactor core,
                        and suddenly all the lights go out.  Congratulations!  You've
                        disabled the reactor!";
                        quit();
                }
                else
                {
                        pass doPutIn;
                }
        }
;

innercore:  room
        sdesc = "Inner Core"
        ldesc = "This is the room where the inner reactor core is kept."
        east = outercore
;

pipe: container
        sdesc = "exhaust pipe"
        ldesc = "It\'s the exhaust pipe for the reactor core."
        noun = 'pipe'
        adjective = 'exhaust'
        verDoTake = nil
        location = innercore
;
