/* $Id: aayela.t 1.20 2001/08/16 19:18:52 mol Exp $
 * --------------------------------------------------------------
 * Main program for Aayela 1.2
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

#include "verbs.t"
#include "dark.t"
#include "tunnels.t"
#include "cave.t"
#include "daemon.t"
#include "items.t"
#include "endgame.t"
#include "intro.t"

#ifdef __DEBUG
// wizard.t contains a set of debugging verbs written by
// Neil K. Guy. It should be available from the IF archive;
// if you don't have it, just leave the next line commented
// out. 
//#include <wizard.t>
#endif

modify version
    name = "\(Aayela\)"
    sdesc = "<< self.name >>, an Interactive Vision.
        Release 1.2 / 010815\b
        Copyright (c) 1996, 2001 by Magnus Olsson. 
	All rights reserved.\n
        Developed with TADS, the Text Adventure Development System.\b"
;

info : object
    infotext = "\b<< version.name >> was written by Magnus Olsson
        (mol@pobox.com) for the Second Annual IF Competition, 1996.
        Release 1.1 (1996) was a post-competition release with minor bug
        fixes. Release 1.2 (2001) was updated for the TADS 2.5.5 compiler
        and the code was cleaned up for public release.\b
	Copyright (c) 1996, 2001 by Magnus Olsson. All rights reserved.\b
	This program is freeware. It is \(not\) in the public domain.
	You may copy and distribute it as long as it is not modified
	in any way. It may not be sold for profit, though a nominal 
	distribution fee may be charged. Please contact the author
	for more information.\b
	Disclaimers:\n
	This game is a piece of fiction. All characters, places and
	situations are figments of the author's imagination. 
	Any similarities
	between characters in the game and real persons, living or
	dead, are purely coincidental.\b
        http://www.pobox.com/~mol/if.html\n"
	
    helptext = "\bThis is a slightly experimental game, which means
        that not everything may work exactly as you are used to from
	other adventures (the differences are slight, though).\b
	There is an official walkthrough for this
        game, which should be inlcuded in the program distribution.
	If you have not received it, please notify the author
	by sending email to mol@pobox.com. "
;	


/*
 * Some minor modifications to the player.
 */
modify Me
    noun = 'me' 'myself' // This seems to be a bug in TADS: these
			 // nouns are already defined but get forgotten!
    verDoEat(actor) = {
        "That doesn't seem very productive. ";
    }
;
    
    	
    