/* $Id: d_std.t 1.22 2001/08/16 19:18:52 mol Exp $
 * --------------------------------------------------------------
 * Addenda to std.t for Aayela 1.2. (Note: based on the std.t
 * that was current in 1996 - not everything may be necessary
 * with newer versions of std.t)
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

#include <adv.t>
#include <std.t>

/* 
 * Prompt and wait for a keypress
 */
more : function
{
     "\b[More]";
     inputkey();
     "\b";
}

/*
 * Return the outermost encapsulating location of an object
 * (for an object in the pocket of an actor who's on a chair in a room,
 * the return value is the room).
 */
outerLoc : function(obj)
{
    local loc;
    if (obj = nil)
        return nil;

    loc := obj;
    while (loc.location <> nil)
        loc := loc.location;
    return loc;
}

/* 
 * Utility functions for adding a list of new adjectives or nouns
 * to an object.
 */
addAdjectives : function(obj, adjectives) 
{
    local i;
 
    for (i := 1; i <= length(adjectives); ++i)
	addword(obj, &adjective, adjectives[i]);
}
	
addNouns : function(obj, nouns) 
{
    local i;
 
    for (i := 1; i <= length(nouns); ++i)
	addword(obj, &noun, nouns[i]);
}

/*
 * Don't display any score, just the number of turns, on the status line.
 */
replace scoreStatus : function(points, turns)
{
    setscore('Turns: ' + cvtstr(turns));
}


/*
 * Change the way room descriptions are displayed to make it more
 * Infocom-like.
 */
modify room
    statusLine = {
        "\("; self.sdesc; "\)";
    }
    
    nrmLkAround(verbosity) = {
        local l, cur, i, tot;

        if (verbosity) {
 	    "\n";
            self.ldesc;

            l := self.contents;
	    tot := length(l);
	    i := 1;
            while (i <= tot) {
	        cur := l[i];
                if (cur.isfixed) 
		    cur.heredesc;
                i := i + 1;
            }
        }

        l := self.contents;
	tot := length(l);
	if (tot > 0)
            "\b";

        if (itemcnt(self.contents)) {
            "You see "; listcont( self ); " here. ";
        }
        listcontcont( self ); "\n";

	i := 1;
        while (i <= tot) {
	    cur := l[i];
            if (cur.isactor) {
                if (cur <> Me) {
                    "\b";
                    cur.actorDesc;
                }
            }
            i := i + 1;
        }

 	// message can be used to show for instance a message about
	// a pervasive smell
	if (defined(self, &message)) {
	    "\b";
	    self.message;
	}
    } 
;
    
modify nestedroom
    statusLine = {
        "\(";
	"<<self.location.sdesc>>, <<self.statusPrep>> <<self.thedesc>>\n\t";
	"\)\b";
    }
;

/*
 * A floor class. It fixes three bugs in the standard theFloor:
 * 1) "throw <dobj> at ground" used to give the embarrassing 
 *    message "you miss".
 * 2) Getting up from the ground when sitting on it used to
 *    give the message "you're no longer in the ground".
 * 3) The floor's ldesc would try to list the contents of the floor
 *    itself - but the floor is always empty! List the containing
 *    room's contents instead.
 * Also provide the option to have an alternate floor object in a 
 * room, by setting that room's floorobj property to the relevant
 * object. Setting floorobj to nil means that the room has no floor.
 */

class floor : beditem, floatingItem
    sdesc = "ground"
    adesc = "the ground"
    ldesc = {
        "There's nothing unusual about << self.thedesc >>. ";
    }

    statusPrep = "on"
    outOfPrep = "off of"

    locationOK = true

    doSiton(actor) = {
        "Okay, %you're% now on << self.thedesc >>. ";
        self.sitloc := actor.location;
        actor.moveInto(self);
    }
    doLieon(actor) = {
        self.doSiton(actor);
    }
    ioPutOn(actor, dobj) = {
        dobj.doDrop(actor);
    }
    ioPutIn(actor, dobj) = {
        dobj.doDrop(actor);
    }

    ioThrowAt(actor, dobj) = {
        "OK. ";
        dobj.moveInto(actor.location);
    }
    ioSynonym('ThrowAt') = 'ThrowTo'

    doUnboard(actor) = {
        if (self.fastenitem) 
 	    pass doUnboard;
	else {
            "%You% get%s% up from "; self.thedesc; ". ";
            self.leaveRoom(actor);
	    actor.moveInto(self.location);
	}
    }

    verDoDigIn(actor) = { }
    doDigIn(actor) = {
	"\^<< self.thedesc >> is too hard to dig in. ";
    }
    location = {
        local loc;

        if (Me.location = self)
            loc := self.sitloc;
        else
            loc := Me.location;

	if (loc.floorobj = self)
	    return loc;
	else
	    return nil;
    }
;

replace theFloor : floor
    noun = 'floor' 'ground'
;

modify room
    floorobj = theFloor
; 

/*
 * A class for walls.
 */
class wall : fixeditem, floatingItem
    darkReachable(verb, actor) = {
        return true;
    }
    location = {
        local loc := outerLoc(Me);
	if (loc.wallobj = self)
	    return loc;
	else
	    return nil;
    }
    verDoFollow(actor) = {
        "Just tell me in which direction you want to go. ";
    }
;
    
modify container 
    verDoEmpty(actor) = {
        "%You% will have to remove things from << self.thedesc >> one
        at a time. ";
    }
;

/*
 * Make 'enter door' work in an intuitive fashion.
 */
modify doorway
    verDoEnter(actor) = {
    }
    doEnter(actor) = {
        actor.travelTo(self);
    }
;

/*
 * There is no score in this game.
 */    
replace scoreRank : function
{
    "You have played for "; 
    say(global.turnsofar);
    " turns.\n";
}

modify scoreVerb
    showScore(actor) = {
 	"Sorry, but there is no score in this game.\n";
    }
;
    
/* 
 * Introduce the "no_all" property of objects.
 * Each object should have a method called no_all which will be called
 * during disambiguation. If the method returns true, the object will
 * be matched by the word 'all'. 
 */
check_no_all : function(verb, prep, io, list) 
{
    local l := list;
    local i;
    local len := length(list);
	
    for (i := 1; i <= len; ++i)
        if (list[i].no_all(verb, prep, io))
            l -= list[i];
    return l;
}

modify deepverb
    doDefault(actor, prep, io) = {
        return check_no_all(self, prep, io, 
		inherited.doDefault(actor, prep, io));
    }
;

/*
 * Unfortunately, there are quite a few verbs that override deepverb's
 * doDefault method completely (without calling inherited.doDefault),
 * so we'll have to replace it in many places.
 */
modify dropVerb
    doDefault(actor, prep, io) = {
        return check_no_all(self, prep, io, 
		inherited.doDefault(actor, prep, io));
    }
;
modify putVerb
    doDefault(actor, prep, io) = {
        return check_no_all(self, prep, io, 
		inherited.doDefault(actor, prep, io));
    }
;
modify takeVerb
    doDefault(actor, prep, io) = {
        return check_no_all(self, prep, io, 
		inherited.doDefault(actor, prep, io));
    }
;
modify giveVerb
    doDefault(actor, prep, io) = {
        return check_no_all(self, prep, io, 
		inherited.doDefault(actor, prep, io));
    }
;
modify showVerb
    doDefault(actor, prep, io) = {
        return check_no_all(self, prep, io, 
		inherited.doDefault(actor, prep, io));
    }
;

/*
 * Fix a bug in thing, and make "throw" require an indirect object.
 */
modify thing
    verDoTakeOut(actor, io) =
    {
        if (io <> nil and not self.isIn(io)) {
            caps(); self.thedesc; " isn't in "; io.thedesc; ". ";
        }
	else
	    self.verDoTake(actor);   /* ensure object can be taken at all */
    }

    verDoSearch(actor) = {
	self.verDoInspect(actor);
    }
    doSearch(actor) = {
        self.doInspect(actor);
    }
 
    doBreak(actor) = {
  	"That wouldn't help you. ";
    }
    
    doThrow(actor) = {
        askio(atPrep);
    }
;

/*
 * Fix a bug in showcontcont: the test of the isqsurface flag is backwards
 * in the adv.t packaged with TADS 2.2!
 */
replace showcontcont : function(obj)
{
    if (itemcnt(obj.contents)) {
        if (obj.issurface) {
	    if (not obj.isqsurface) 
		"On << obj.thedesc >> you see << listcont(obj) >>. ";
 	}
        else if (obj.contentsVisible and not obj.isqcontainer) 
            "\^ << obj.thedesc >> seems to contain << listcont(obj) >>. ";
    }
    if (obj.contentsVisible and not obj.isqcontainer)
        listfixedcontcont(obj);
}
   
/*
 * New die() function that calls game_over.
 */
replace die : function
{
    "\b*** You have died ***\n";
    game_over();
}

/*
 *  The game_over function takes over most of the functionality
 *  of die(), for cases where the game ends without the player's
 *  actually dying.
 */
game_over : function
{
    "\bYou may restore a saved game, start over, quit, or undo
    the current command.\n";
    while (true) {
        local resp;

	"\nPlease enter RESTORE, RESTART, QUIT, or UNDO: >";
        resp := upper(input());
        if (resp = 'RESTORE') {
	    resp := askfile('File to restore');
	    if (resp = nil) 
 	 	"Restore failed. ";
	    else if (restore(resp)) 
		"Restore failed. ";
	    else {
	        Me.location.lookAround(true);
	        scoreStatus( global.score, global.turnsofar );
		abort;
	    }
	}
        else if (resp = 'RESTART') {
	    scoreStatus( 0, 0 );
            restart();
	}
	else if (resp = 'QUIT') {
   	    "\b";
	    terminate();
            quit();
	    abort;
        }
	else if (resp = 'UNDO')	{
	    if (undo()) {
		"(Undoing one command)\b";
		Me.location.lookAround(true);
	        scoreStatus(global.score, global.turnsofar);
		abort;
	    }
	    else
		"Sorry, no undo information is available. ";
	}
    }
}

replace incscore : function(amount)
{
    "\b[Your score just went << amount > 0 ? "up" : "down" >> ";
    say(amount);
    " points]\n";
    
    global.score += amount;
    scoreStatus( global.score, global.turnsofar );
}

// Forward declaration of intro - will be called by init
intro : function; 

/*
 *   Modified version of init() - doesn't start sleep and hunger daemons,
 *   calls intro() to print introduction, etc.
 */
replace init : function
{
    local startloc := startroom;
  
    intro();
    version.sdesc;         // display the game's name and version number
    if (global.wizard)
        "Compiled in WIZARD mode\b";
    "Please type \(about\) for credits and general release 
    information.\b";

    setdaemon(turncount, nil);         // start the turn counter daemon
    randomize();
    
    Me.location := startloc;          // move player to initial location
    startloc.lookAround(true);      // show player where he is
    if (defined(startloc, &darkseen) and not startloc.islit)
        startloc.darkseen := true;
    else
        startloc.isseen := true;
    
    scoreStatus(0, 0);
}


/*
 * Change the doGiveTo method of thing so that we don't get the
 * "Done" message by default; instead, we'll let the receiver
 * handle that.
 */
modify thing
    doGiveTo(actor, io) = {
        self.moveInto(io);
    }
;


/*
 * A class of fixed items that can be accessed by the player if he's in
 * any of a list of locations.
 */
class fixedfloater : floatingItem, fixeditem
    llist = [] // List of possible locations
    locationOK = true
    location = {
	if (find(llist, Me.location))
	    return Me.location;
	else
	    return nil;
    }
;

modify class decoration
    isplural = nil
    not_important = "\^<< self.thedesc >> << isplural ? "are" : "is" >>n't 
    	important. "
    ldesc = {
        self.not_important;
    }
    dobjGen(a, v, i, p) = {
        if (v <> inspectVerb) {
            self.not_important;
	    exit;
	}
    }
    iobjGen(a, v, d, p) = {
        if (v <> askVerb and v <> tellVerb) {
            self.not_important;
 	    exit;
	}
    }
;

modify movableActor
    verDoSearch(actor) = {
        "I don't think << self.thedesc >> would agree to that. ";
    }
;
   
