/* $Id: verbs.t 1.15 2001/08/16 19:18:52 mol Exp $
 * --------------------------------------------------------------
 * Verb definitions for Aayela 1.2
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

#include "d_std.t"

/*
 * Make 'inside' a synonym for 'in'
 */
modify inPrep
    preposition = 'inside'
;

/*
 * We must be able to parse 'away' as a preposition (though it's an adverb)
 */
awayPrep : Prep
    preposition = 'away'
    sdesc = "away"
;
    
/*
 * Make 'feel' a synonym for 'touch'
 */
modify touchVerb
    verb = 'feel'
;

/*
 * Make 'taste', 'nibble' and 'bite' synonyms for 'eat'
 */
modify eatVerb
    verb = 'taste' 'nibble' 'bite'
;

/*
 * A new magic word
 */
queltuyaVerb : deepverb, darkVerb
    verb = 'queltuya'
    sdesc = "queltuya"
    action(actor) = {
        if (stone.isIn(endgame) and actor.isIn(endgame))
	    stone.queltuya(actor);
	else 
	    "Nothing happens.";
    }
;

/*
 * And some old magic words, just for fun
 */
xyzzyVerb : deepverb, darkVerb
    verb = 'xyzzy' 'plugh'
    sdesc= "xyzzy"
    action(actor) = {
        "You are suddenly overcome with nostalgia
        for the good old days, when adventurers 
	who spoke in two-word sentences and slew dragons with their
	bare hands... ";
    }
;

magicVerb : deepverb, darkVerb
    verb = 'yoho' 'necken-sway'
    	   'abracadabra' 'hocus' 'pocus' 'shazam'
    sdesc= "shazam"
    action(actor) = {
        "Sure you're in the right universe? ";
    }
;

frotzVerb : deepverb, darkVerb
    verb = 'frotz'
    sdesc = "frotz"
    action(actor) = {
        magicVerb.action(actor);
    }
    doAction = 'Frotz'
;

modify thing
    verDoFrotz(actor) = {
        magicVerb.action(actor);
    }
;

modify sayVerb
    isDarkVerb = true
    validDo(actor, obj, seqno) = {
        return true;
    }
    action(actor) = {
        "To say a magic word, just type it at the prompt (just \"shazam\", 
	not \"say shazam\").
	To say something to somebody, first type the person's name, 
	(\"wizard, give me the scroll\").";
	abort;
    }
    doDefault(actor, prep, io) = {
    	if (objwords(1) = ['A']) {
            global.allMessage := 'You can\'t use "all" with this verb.';
	    return [];
	}
	pass doDefault;
    }
;

modify thing
    verDoSay(actor) = {
        sayVerb.action(actor);
    }
;    
        
modify strObj
    doSay(actor) = {
        if (find(['XYZZY' 'PLUGH' 'ABRACADABRA' 'HOCUS' 'POCUS' 'SHAZAM'],
	         upper(self.value)))
	    xyzzyVerb.action(actor);
	else if (upper(self.value) = 'QUELTUYA')
	    queltuyaVerb.action(actor);
	else
	    sayVerb.action(actor);
    }
;
    
/*
 * Make 'dig' work without an indirect object, and in the dark
 */
replace digVerb : deepverb
    verb = 'dig' 'dig in'
    isDarkReachableVerb = true
    sdesc = "dig in"
    doAction = 'DigIn'
    doDefault(actor, prep, io) = {
	local lst := inherited.doDefault(actor, prep, io);
	if (actor.location.floorobj <> nil)
	    lst += actor.location.floorobj;
	return lst;
    }
;

modify thing 
    verDoDigIn(actor) = {
        "I don't know how to << digVerb.sdesc >> << self.thedesc >>. ";
    }
;

singVerb : deepverb, darkVerb
    verb = 'sing' 'chant'
    sdesc = "sing"
    action(actor) = {
        "What with the tension or the moisture, you only manage to
	produce a hoarse, entirely unmusical, croaking.";
    }
;
    
modify yellVerb
    verb = 'scream' 'holler'
    isDarkVerb = true
    action(actor) = {
	local loc := outerLoc(actor);
	    
        if (defined(loc, &shout))
	    loc.shout(actor);
	else
	    pass action;
    }	   
;

smellVerb : deepverb, darkVerb
    verb = 'smell'
    sdesc = "smell"
    doAction = 'Smell'

    doDefault(actor, prep, io) = {
        return inherited.doDefault(actor, prep, io) + [air];
    }
;

modify thing
    verDoSmell(actor) = {
        // It is important that this message is printed by verDoSmell 
	// rather than by doSmell: otherwise, the default action on
	// just 'smell' (without direct object) could be to smell
	// whatever uninteresting object was at hand.
        "\^<< self.thedesc >> doesn't smell unusual.";
    }
;

listenVerb : deepverb, darkVerb
    verb = 'listen' 'hear' 'listen to'
    sdesc = "listen to"
    doAction = 'Listento'

    doDefault(actor, prep, io) = {
        local lst := inherited.doDefault(actor, prep, io);
	
	if (music.state > 0)
	    lst += music;
	return lst;
    }  
;
    
modify thing
    verDoListento(actor) = {
        "\^<< self.thedesc >> doesn't make any sound. ";
    }
;

modify doorway
    verDoListento(actor) = { }
    doListento(actor) = {
        "%You% %do%n't hear anything unusual. ";
    }
;
    
lightVerb : deepverb
    verb = 'light' 'ignite' 'burn'
    sdesc = "light"
    isDarkReachableVerb = true 
    doAction = 'Light'
;

extinguishVerb : deepverb
    verb = 'extinguish' 'douse' 'dowse' 'unlight'
    sdesc = "extinguish"
    isDarkReachableVerb = true
    doAction = 'Extinguish'
;

/*
 * Some new system verbs
 */
helpVerb : sysverb
    verb = 'help' 'hint' 'hints'
    sdesc = "help"
    action(actor) = {
        info.helptext;
	abort;
    }
;

infoVerb : sysverb
    verb = 'info' 'credits' 'about'
    sdesc = "info"
    action(actor) = {
        info.infotext;
	abort;
    }
;

/*
 * And some new abbreviations and synonyms
 */
modify takeVerb
    verb = 't' 'clear away' 'take away'
;

modify dropVerb
    verb = 'throw away' 'discard'
;

modify quitVerb
    verb = 'q'
;

        
sneezeVerb : deepverb
    verb = 'sneeze'
    sdesc = "sneeze"
    action(actor) = {
        "Gesundheit! ";
    }
;

playVerb : deepverb, darkVerb
    verb = 'play'
    sdesc = "play"    
    doAction = 'Play'
;
    
blowVerb : deepverb, darkVerb
    verb = 'blow'
    sdesc = "blow"    
    doAction = 'Blow'
;
    
pourVerb : deepverb
    verb = 'pour' 'decant' 'spill'
    sdesc = "pour"
    doAction = 'Pour'
    ioAction(onPrep) = 'PourOn'
    ioAction(inPrep) = 'PutIn'
;

modify thing
    verIoPourOn(actor) = { }
    ioPourOn(actor, dobj) = {
        dobj.doPourOn(actor, self);
    }
;
    
emptyVerb : deepverb
    verb = 'empty' 'evacuate' 'drain'
    sdesc = "empty"
    doAction = 'Empty'
;

flipThruVerb : deepverb
    verb = 'leaf through' 'leaf thru' 'flip through' 'flip thru'
    sdesc = "flip through"
    doAction = 'FlipThru'
;
    
modify throwVerb 
    doAction = 'Throw'
    ioAction(thruPrep) = 'ThrowThru'
    ioAction(inPrep) = 'PutIn'
    rejectMultiDobj(prep) = {
        "You can only throw one thing at a time. ";
        return true;
    }
;


modify fixeditem 
    verDoThrow(actor) = {
        "%You% can't throw << self.thedesc >>. ";
    }
;


/*
 * Allow "attack <dobj>" without any indirect object - silly to ask for
 * one when no weapon is sufficient anyway.
 */
modify attackVerb 
    doAction = 'Attack'
;

modify thing 
    verDoAttack(actor) = {
        "Attacking "; self.thedesc; " doesn't appear productive. ";
    }
    verIoAttackWith(actor) = {
        if (not self.isIn(actor))
	    "But %you% %are%n't holding << self.thedesc >>!";
	else
	    "\^<< self.thedesc >> doesn't look very efficient as a weapon.";
    }
;

acceptVerb : deepverb
    verb = 'accept'
    sdesc = "accept"
    doAction = 'Take'
    ioAction(fromPrep) = 'TakeOut'
;
    
fillVerb : deepverb
    verb = 'fill'
    sdesc = "fill"
    doAction = 'Fill'
;

modify container
    verDoFill(actor) = {
        "%You% must tell me what %you% want to put in << self.thedesc >>. ";
    }
;

kickVerb : deepverb
    verb = 'kick' 
    sdesc = "kick"
    doAction = 'Kick'
;

modify thing
    verDoKick(actor) =
    {
        "Attacking "; self.thedesc; " doesn't appear productive. ";
    }
;    
    
    
untwistVerb : deepverb
    verb = 'untwist' 'untangle'
    sdesc = "untwist"
    doAction = 'Untwist'
;

insertVerb : deepverb
    verb = 'insert'
    sdesc = "insert"
    prepDefault = inPrep
    ioAction(inPrep) = 'PutIn'
    doDefault(actor, prep, io) = {
        return(takeVerb.doDefault( actor, prep, io ) + actor.contents);
    }
    rejectMultiDobj(prep) = {
        "You can't use multiple direct objects with the verb 'insert' "; 
        return true;
    }
;

modify putVerb
    rejectMultiDobj(prep) = {
        if (prep <> inPrep)
	    return nil;
	   
        "You can only do that to one thing at a time. ";
        return true;
    }
;
    
modify lookInVerb
    verb = 'look inside' 'l inside' 'gaze into' 
;

modify plugVerb 
    verb = 'plug in'
;

modify wearVerb
    verb = 'don'
;

modify removeVerb
    verb = 'doff'
;

undressVerb : deepverb
    verb = 'undress' 'strip'
    sdesc = "undress"
    action(actor) = {
        "There's no reason why you should undress in this game. ";
    }
    doAction = 'Undress'
;

dressVerb : deepverb
    verb = 'dress'
    sdesc = "dress"
    action(actor) = {
        "%You% will have to tell me what %you% want to wear. ";
    }
    doAction = 'Dress'
;

unwrapVerb : deepverb
    verb = 'unwrap' 'unwind'
    sdesc = "unwrap"
    doAction = 'Unwrap'
;


modify attachVerb 
    verb = 'join'
    doAction = 'Attach'
;

modify detachVerb
    verb = 'separate'
;
    
modify breakVerb
    verb =  'smash'
;

modify thing
    verDoBreak(actor) = {
 	if (not actor.isCarrying(self))
	    "But %you% %are% not holding << self.thedesc >>.";
    }
;
    
modify lookInVerb
    verb = 'look into' 'l into'
;

modify inspectVerb
;

modify turnVerb
    rejectMultiDobj(prep) = {
        "You can only turn one thing at a time. ";
        return true;
    }
;

modify openVerb
    rejectMultiDobj(prep) = {
        "You can only << self.sdesc >> one thing at a time. ";
        return true;
    }
;

modify searchVerb
    rejectMultiDobj(prep) = {
        "You can only << self.sdesc >> one thing at a time. ";
        return true;
    }
;

modify removeVerb
    doDefault(actor, prep, io) = {
    	if (objwords(1) = ['A']) {
            global.allMessage := 'You can\'t use "all" with this verb.';
	    return [];
	}
	pass doDefault;
    }
;



modify knockVerb
    verb = 'knock' 'knock on' 'knock at'
    sdesc = "knock on"
    doAction = 'KnockOn'
    isDarkReachableVerb = true
;

modify thing
    verDoKnockOn(actor) = { 
        "Nothing happens. ";
    }
;

modify doorway
    verDoKnockOn(actor) = {
    }
    doKnockOn(actor) = {
        "There is no answer.";
    }
;
    
modify movableActor
    verDoKnockOn(actor) = {
        "I don't think << self.thedesc >> would appreciate that. ";
    }
;

modify basicMe
    verDoKnockOn(actor) = {
        "Please concentrate on your task, will you?";
    }
;

