#ifndef ADV3_H
#include <adv3.h>
#endif

#ifndef _BIGNUM_H_
#include <bignum.h>
#endif

// checks for if a variable was NOT defined from file en_us.h
// .. and if so then include the file to define that variable, method, etc.
#ifndef singleDir
#include <en_us.h>
// //#error "You can put an error here too if the variable <> something. "
#endif

/* Will probably not use this flag but putting it here in case we wish to 
 * conditionally include startrooms.t or not. This idea could be used to
 * offer a different random set of start rooms, perhaps from another include
 * file. 
 */
#ifndef START_ROOMS
#define START_ROOMS
#endif

// --------  B E G I N    R O O M S  --------
//  
//  RRRRR     OOOO     OOOO    M   M    SSSS 
//  R    R    O  O     O  O    MM MM   S   
//  RRRRR    O    O   O    O   M M M    SSS 
//  R    R    O  O     O  O    M   M       S
//  R     R   OOOO     OOOO    M   M   SSSS 

warpTunnel: Hidden, ThroughPassage, TravelMessage
 vocabWords = '(warp) tunnel'
 name = 'warp tunnel'
 destination = pixyland // lgBadGuyHideoutCloset
 travelDesc = "An orange cloud of smoke engulfs you for a moment and when the
              smoke clears you find yourself someplace else....\n<br> ";
;
 
/*-----------------------------------------------------------------\
| room obj name: introRoom                                         |
| room name: ''                                                    |
| notes: Hide status line things during introduction.              |
|        Player gets sent to startRoom after intro.                |
\_________________________________________________________________*/
introRoom: OldRoom '' ''
  " "
;

/*-----------------------------------------------------------------\
| room obj name: pixyland                                          |
| room name: Pixyland                                              |
| notes: temp object storage                                       |
\_________________________________________________________________*/
pixyland : OldRoom 'Pixyland'   
   "This room is for holding various objects
    and should never be seen by the player. "
   roomParts = [] 
;

/* *** A FOOTNOTE OBJECT! 
 * Use in a string of text like so:  " <<myMMMFootnote.noteRef>> ";
 */
myMMMFootnote: Footnote "This old mansion belongs to Mr. Ian Banten, 
                  retired sheriff of Browningsdale County. He is a bit
                  of a recluse these days and is seldom seen outside
                  his enormous estate. From the rumors you\'ve heard,
                  it is likely he does not appreciate unexpected visitors. ";

noLeprechaun: Unthing '(little) (green) (jacketed) (coated) (suited) leprechaun' 'leprechaun'
  'You don\'t see him anymore. He made off with your traveler\'s check and is long gone. '
  location = pixyland  
  isHim = true
;

// use this way: smartyPantsAchievement.awardPointsOnce();
smartyPantsAchievement: Achievement
  desc {  
         "having such a fine eye for detail you discovered actual splinters on the dock (super sleuth award). ";
  }
  points = 1  
;

islandJungleTrees: MultiLoc, Decoration
    disambigName = 'jungle trees'
    vocabWords = '(very) (tall) (high) (huge) (enormous) (island) (lake) (jungle) tree*trees'
    name = 'trees'
    desc = "Just some jungle trees. "
    isPlural = true
    locationList = [startRoom, deepJungle, millHouse, mansionPorch, westOfMansion]
;

/*
 * Added on 6/6/209 by Cleo Kraft
 *
 * We could go pretty crazy with this and add other outdoor rooms to the room list
 * especially if we mention a breeze in the room description. Just update the 
 * locationList array below with any outdoor rooms you like. 
 *
 */
islandBreezeNorthWind: MultiLoc, Distant 
    disambigName = 'north wind'
    vocabWords = '(ocassional) (occasional) (occassional) (fresh) (north) (northern) (big) (small) (medium) (huge) 
        (tiny) (light) (strong) (pleasant) (empty) (cold) (luke) (warm) (lukewarm) (cool) (hot) (lake) (shore) 
        (jungle) (island) (isle) (outdoor) (outdoors) (beach) (tree) (trees) air/breeze/wind' 
    name = 'north wind'
    desc = "Every now and then you feel a northern breeze blowing in. "
    dobjFor(Feel){
        preCond=[]
        verify(){ 
            illogical('You feel it blow on your hand. ');
        }
    }
    dobjFor(Taste){
        preCond=[]
        verify(){
            illogical('You can\'t taste the air. ');
        }
    }
    dobjFor(Smell){
        preCond=[]
        verify(){}
        check(){}
        action(){
            self.smellDesc;
        }
    }
    dobjFor(Eat){
        preCond=[]
        verify(){
            illogical('You can\'t eat the air. Well... technically you could but then you\'d burp. ');
        }
    }
    smellDesc = "Smells like fresh air. "
    // tasteDesc = "You can\'t taste the air. " // won't run on a Distant obj. normally so we can override
    touchDesc = "If it\'s a strong breeze you can feel it against your hand. Otherwise it\'s just empty air. "
    locationList = [startRoom, deepJungle, millHouse, mansionPorch, westOfMansion]
;



/*-----------------------------------------------------------------\
| room obj name: startRoom                                         |
| room name: Front Path                                            |
\_________________________________________________________________*/
startRoom: OutdoorRoom 'dock'     
    destName = 'dock' // normally nil - if valid then connectors can use to get here quickly
    desc {     
         if(!gPlayerChar.hasSeen(self)){
                "<i>October 30th: What am I doing here? What was I thinking? This place isn\'t
                safe at night. What if the legends are right? What if I run into a vampire out
                here?</i><.p>";
         }    
         "Here on the wooden dock of an isolated, lonely island in the center of a vast
          mountain lake you stand beside a small gravel trail leading into the jungle. ";
          if(gPlayerChar.hasSeen(self)){
                 "It is night time";
          }else{
                 "It is just after sunset";
          }
          " and a light breeze blows gently over the lake. The sandy shoreline stretches out
          over two kilometers in both directions. ";
          if(gameMain.allowHtmlLinks){
                "You can <a href=\"follow the trail\">follow the trail</a> <a href=\"north\">north</a> from here. ";
          }else{
                "You can follow the trail north from here. "; 
          }           
    }// end desc
    
    /* NOTE: See lookDir.t (module from IF-Archive)  
     * Our "frontGateBars" are our sense connector object to look through to the north...
     */
    northLook = "You see the gravel trail vanish into the jungle in that direction. "
    westLook = "You see the glowing yellow lights of tiny village way off on the horizon on the far end of the lake. "
    southLook = "You see the lake stretch out for several kilometers in that direction and vanish on the horizon
                 at the base of a tall looming snow capped mountain. The snow glistening brightly in the full moon. "
    eastLook = "You see the lake vanish off into the horizon. The boundary of the lake in that direction is uncertain.
               You\'re not from this place so you really have no idea but you\'ve been told this lake is <i>huge</i>. "
    roomBeforeAction(){
            // if(gActionIs(Jump)){ }
    } 
    roomAfterAction(){
            // if(gActionIs(Look) || gActionIs(Examine)){ }
    }
    /* 
     * Default for enteringRoom(traveler) is an empty method that must be overriden by
     * classes. We will use the startRoom's enteringRoom method for resetting flags 
     * and so on. 
     */
    enteringRoom(traveler){
            if(traveler == gPlayerChar){
           }
    }
    north = junglePath1
    south: NoTravelMessage {
         travelDesc { 
                 "You\'re a pretty decent swimmer but there\'s no way you\'re swimming all that way in the tretcherous waters of this lake. ";
         }
    }
    east : NoTravelMessage {
         travelDesc { 
                 "You consider walking along the beach for a moment but then quickly change your mind. You came here for a reason and that trail
                 seems to be the only safe bet. ";
         }
    }
    west : NoTravelMessage {
         travelDesc { 
                 "What, and miss out on all the fun? Walks on the beach might be fun to try later but right now you just want to get to that mansion
                 and the trail here seems an obvious choice, don\'t you think? ";
                 local sYes = 'Exactly. So let\'s get hopping, buddy. The trail\'s a\'waitin\'. ';
                 local sNo = 'Now\'s not the time to go changing your mind. It\'s spur of the moment change of plan ideas like this that probably got
                             your girlfriend to consider dumping you to begin with. You paid the boat captain plenty to drop you off out here. The mansion\'s
                             been on your mind since talking with the old man in the tavern last night. The trail seems a whole lot easier to navigate
                             than that sandy beach at night. So let\'s quit stalling around and get this over with already. ';
                 local sMaybe = 'And maybe I\'m the man from Mars. Of course it\'s a good decision! Let\'s follow that trail already. ';
                 myNarrator.setNarratorQuestion(sYes,sNo,sMaybe);
         }
    }
    down = junglePath1
;
+ junglePath1: TravelWithMessage, PathPassage 
   masterObject = junglePath1
   otherSide = junglePath2
   vocabWords = '(small) (jungle) (northbound) (north) (bound) (gravel) (gravelly) (rocky) (sandy) (rock) (sand) path/trail'
   name ='gravelly trail'
   desc = "The gravelly trail heads north into the darkened jungle. "
   travelDesc = "You walk along the little path and head into the dark jungle. "
   travelBarrier = [noLantern, lanternNotOn]
;
+ Distant '(lonely) (mountain) (lake) (west) (western) (shore) village town' 'village'
    "You can just barely see the glowing lights of the village off to the west from here. "
;
+ Distant '(lonely) (mountain) (lake) (glowing) (yellow) (white) (bright) (dim) (village) (town) light*lights' 'village lights'
    "The village lights are dim off in the distance and coming from the village. "
;
+ Decoration '(lonely) (lakeside) (lake) (side) (island) (shore) (jungle) (trail) gravel' 'trail gravel'
    "Just some gravel on the trail. "
;
+ Decoration '(lonely) (lakeside) (lake) (side) (center) island' 'island'
  "It\'s an island all right. A lonely island in the middle of a mountain lake. You can\'t believe you came all this way
  just to see if some stupid rumor was true. "
;
// Bug Fix - 6/6/2019 by Cleo Kraft. Unthing wasn't working but Distant class works for the boat
+ Distant '(captain\'s) (captain) (rented) (hired) (tourist) (little) (distant) (water) (motor) (ferry) (ferrie) ship/craft/watercraft/raft/motorboat/boat' 'motor boat'
  "The motor boat is too far away to make out clearly anymore. "
    disambigName = 'motor boat'
;
+ Unthing '(the) (bright) (dim) (red) (orange) (yellow) (sun) set/sunset' 'sunset'
    "It was beautiful but the sun has set now and it\'s just after dark. "
;
+ Unthing '(the) (bright) (yellow) (white) sol sun star' 'sun'
    "You don\'t see it now as it\'s just after sunset. "
;
+ Unthing '(the) (bright) (yellow) (white) (sun) (star) light' 'sunlight'
    "You can\'t see any sunlight right now as it\'s just after sunset. "
    disambigName = 'sun light'
;
+ Distant '(the) (bright) (white) (moon) light' 'moonlight'
    "There is moonlight all around you here. "
    disambigName = 'moon light'
;
+ Distant '(the) satellite/moon' 'moon'
    "You see the moon off in the distance just over the mountains. "
;
+ Unthing '(motor) (boat) (ferry) (ship) (craft) (watercraft) captain' 'captain'
  "You can\'t see the boat captain from here. He\'s long gone. "    
  isHim = true
;
+ Decoration '(thick) (mysterious) (wild) (mountain) (island) jungle' 'jungle'
  "The jungle is mysterious, thick and wild. "
;
+ Decoration '(wood) (wooden) plank*planks' 'planks'
  "They look like ordinary wooden planks apart from some of them have lots of tiny little cracks in them. "
;
+ Decoration '(aged) (weathered) (tiny) (little) (wooden) (wood) (plank) (planks) crack*cracks' 'plank cracks'
  "These just make the planks look weathered but some are downright fractures. "
  isPlural = true
;
+ Decoration '(down) (right) (downright) (weird) (strange) (wooden) (wood) (plank) fracture*fractures' 'plank fractures'
  "Now isn\'t that something? Squinting to make them out as best you can you get closer and closer for a deeper and
  deeper examination until you\'re just about cross eyed from such intense and meaningful concentration. Some of these
  plank fractures have miraculously evolved into splinters. Maybe you should check those out too (you know you want to). "
;
+ lookingTooClose: Decoration 
  vocabWords = '(weird) (strange) (wood) (wooden) (plank) (nasty) splinter*splinters' 
  name = 'wood splinters'
  desc { "Gathering up courage you investigate the wood splinters. Summoning up near super hero-like ability you try and gaze 
         down even deeper into the wood. ";
         if(lookingTooClose.iFlag == nil){
            lookingTooClose.iFlag = true;
            "While fidgeting with a particularly nasty variety of splinter as you try and seperate them out one from the
            other for deeper categorization you feel what feels like a tiny hand slip into your back trouser pocket and make
            off with your traveler\'s check. You spin around and see a little leprechaun standing there chuckling at you and
            kissing the traveler\'s check he\'s so cleverly stolen from you during your deep moment of distraction.<.p>
            \"You like to check? Ha! I <i>got</i> the check! Hee-hee, didly dee! Got your check, you can\'t catch me!\" he
            cries running off into the woods waving it proudly above his head as though it\'s some sort of sick and twisted
            trophy. ";
            travelersCheck.moveIntoForTravel(pixyland);
            travelersCheck.isListed = nil;
            noLeprechaun.moveIntoForTravel(startRoom);
            smartyPantsAchievement.awardPointsOnce();
         }
  }
  iFlag = nil
;
+ Decoration '(wooden) (wood) dock' 'dock'
  "The dock is made up of some old wooden planks. There\'s not much to it. It\'s a rather small dock. Just about big
  enough for a little boat on either side. "
;
++ modernSupportBeam: Surface, Fixture '(wood) (wooden) (circular) (round) (support) pole/beam/log' 'support beam'
   "It\'s a round log, really, like all the others holding up the dock. "
   bulkCapacity = 5 
;
+ Decoration '(splintery) (wood) (wooden) (circular) (round) (support) poles/beams/logs' 'support beams'
  "You see nothing unusual about them. "
  isPlural = true
  feelDesc = "Feels like wood. A bit splintery in spots. " 
;
+ Decoration '(splintery) (wood) (wooden) spot*spots' 'wood spots'
  "Just some splintery wood spots here and there. "
  isPlural = true
  feelDesc = "Feels splintery. "
;
+ Decoration '(island) (snow) (capped) (big) (large) (giant) (gigantic) (huge) (vast) (enormous) mountain/mountains' 'mountains'
  "There are many mountains visible along the southern edge of the lake. "
  isPlural = true
;
+ Decoration '(white) (yellow) (sandy) shore sand beach' 'beach'
  "The white sandy beach stretches out for two kilometers to the left and right of the dock. "
;
+ Unthing '(scurvy) pirate' 'pirate'
  "You don\'t see a pirate around here anywhere but it\'s not too much of a stretch of the imagination to think one could be lurking
  just around the corner. "
;
+ Decoration '(old) (worn) (weathered) (dirty) (island) (lake) (lakeside) (side) (dock) wood' 'dock wood'
  "The dock wood looks pretty weathered. "
  disambigName = 'old worn dock wood'
;
+ Unthing 
    vocabWords = '(strange) (generic) (plain) (ordinary) corner' 
    name = 'corner'
    desc = "There\'s no corners out here (unless you count the corners of the dock. "  
    notHereMsg = 'You don\'t see any corners out here (unless you mean the corners of the dock.) '
    disambigName = 'generic corner'
;
+ Decoration 'dock corner corners (of) (the) (old) (wood) (wooden)' 'dock corners'
  "Aye, thar be dock corners all right. You see nothing unusual about \'em. "
    disambigName = 'dock corners'
    isPlural = true
;
+ Decoration '(mountain) water lake' 'lake'
  "The lake stretches out for many kilometers all around the island. "
  dobjFor(SwimIn){
      verify(){ logicalRank(110,'likely'); }
      action(){ 
               "You\'re not even wearing a bathing suit to do that. Besides, you\'d rather explore that jungle path up ahead than go
               swimming in the lake. ";
      }
  }
;
+ Unthing 'Will Crowther' 'Will Crowther'
    "You don\'t see him. Oh if only he were here!"
;
+ Unthing 'Don Woods' 'Don Woods'
    "You don\'t see him here."
;

// the bonus game has brassLanternTwo, which is also Attachable (to the iron hook) - this version isn't
brassLantern: Flashlight 
  name = 'brass lantern'
  vocabWords = '(small) (nifty) (rusty) (dusty) (dust) (covered) (scratched) (weathered) (brass) (latn) lantern/lamp/light/flashlight/linterna/lmpara/ligero/antorcha/torch'   
  desc = "It is a rather heavy duty brass lantern. It looks a bit weathered and 
          scratched from so much use. There/'s some scratchy writing on the side. "    
  location = startRoom
  touchInfo = true // testing to see if we can get it in the dark
  dobjFor(Read){ preCond=[touchObj,objHeld]
                 verify(){}
                 check(){ inherited; }
                 action(){ 
                    "<i>Crowther and Woods - I still have your lantern if you want it back.</i> ";
                    /*
                     *   Will Crowther wrote "Colossal Cave Adventure" with
                     *   expansion help from Don Woods in the 1970's (1975-1977)
                     *   The brass lantern/lamp in this game is just a tribute to them,
                     *   for who's text adventure inspired me to write my own.
                     *   Changed it so there's writing on the lamp now. Originally
                     *   if you tried to read the lamp (in my game here) it would 
                     *   say "There is nothing written on the brass lantern."
                     *             - Cleo Kraft
                     * 
                     *             6 JUN 2019
                     */
                 }
               }  
  disambigName = 'dusty brass lantern' // optional - helps better identify an item if other items are like it nearby
  brightnessOn = 4
  bulk = 5
  weight = 2
  dobjFor(TurnOn) {
        preCond = [touchObj,objHeld]
        verify() { inherited;  }
        check(){ inherited; }
        action(){ inherited; }
  }
  dobjFor(Drop){
        preCond=[objHeld]
        verify(){  if(
                      (gActor.location.ofKind(OutdoorRoom)) &&
                      (gameMain.generalTime == 'night')
                     ) illogicalNow('Not out here. You\'ll need it in the dark to see your way. '); 
        }
  }
; 
+ Decoration '(etched) (metal) (plaque) (plack) (brass) (lamp) (lantern) (tribute) writing' 'brass lantern writing'
    "Someone etched some writing into the side of the brass lantern. It reads: <i>Crowther & Woods - I still have your lantern if you want it back.</i> "
;

noLantern : TravelBarrier 
   canTravelerPass(traveler) { return brassLantern.isIn(traveler); } 
   explainTravelBarrier(traveler) { "You probably shouldn\'t go in the dark jungle without a good light source. "; } 
; 

lanternNotOn: TravelBarrier
   canTravelerPass(traveler) {return (brassLantern.isLit); } 
   explainTravelBarrier(traveler) { "The brass lantern isn\'t on. You\'ll need it lit to navigate through the dark jungle. "; }
;



deepJungle: DarkRoom, OutdoorRoom 
  name = 'jungle'
  desc {
        // if(!gPlayerChar.hasSeen(self)){
        //          "<i>Sure is spooky out here at night. I wonder if there\'s anything to that story I heard about the sex change machine. 
        //         If I manage to sneak in the mansion and use it I only hope I don\'t get caught before I get a chance to change back to
        //         normal.</i><.p>";
        // }
        "The light from your brass lantern eerily flickers every now and then, causing the shadows to jump around
        on the path before you. A bleached white animal skeleton lies on the side of the trail with a wooden sign jammed
        through its rib cage. The path winds its way "; 
        if((gActor.lastTravelBack == junglePath2) || (gActor.lastTravelBack == startRoom)){
            if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a> deeper into the jungle or you could go <a href=\"south\">south</a> back to the docks. ";
            }else{
               "north deeper into the jungle or you could go south. ";
            }
        }else{
            if(gameMain.allowHtmlLinks){
               "back to the docks from here to the <a href=\"south\">south</a> or you could go back to the <a href=\"north\">north</a>. ";
            }else{
               "back to the docks from here to the south. You can also go north. ";
            }
        }
   }
   east : NoTravelMessage {
         travelDesc { 
                 "Nothing doing. It\'s a jungle out there! ";
         }
   }
   west : NoTravelMessage {
         travelDesc { 
                 "There\'s nothing but dark spooky jungle in that direction. You don\'t fancy the idea of leaving the relative
                 safety of the trail just yet. ";
         }
   }
  down = junglePath3
  south = junglePath2
  north = junglePath3
;
+ cowSkeleton: Decoration '(cattle) (heffer) (heffy) (bleach) (bleached) (white) (moo) (cownable) skull bone bones animal rib ribs cage bovine cow skeleton' 'cow skeleton'
  "A bleached white cow skeleton lies beside the path with a sign protruding through its rib cage. "
  dobjFor(Kiss){
       verify(){}
       check(){}
       action(){
               "That\'s not for kissing. ";
               gameMain.zort += 17;
       }
  }
;
+ deepJungleObj: Decoration '(deep) (green) (leafy) jungle' 'jungle'
    "Just a bunch of jungle trees all around you. A trail leads through it to the north and south from here. "
;
+ cowSign: Readable, Fixture
  name = 'wooden sign'
  vocabWords = '(old) (faded) (danger) (warning) sign'
  desc = "The red letters painted on it are old, faded and spelled incorrectly.
         It originally read \"Dane-Jer! No Tres-Pas!\" "
  readDesc =  "<i>Dane-Jer! No Tres-Pas!</i> "
;
+ junglePath2: TravelWithMessage, PathPassage
   masterObject = junglePath1
   otherSide = junglePath1
   vocabWords = '(jungle) (southbound) (south) (bound) (gravel) (gravelly) (rocky) (sandy) (rock) (sand) path/trail'
   name ='southbound gravelly trail'
   desc = "The gravelly path heads south out of the jungle and back to the dock. "
   travelDesc = "You head back to the dock. "
   travelBarrier = [noGoingBackNowBarrier]
;
+ junglePath3: PathPassage 
   masterObject = junglePath3
   otherSide = junglePath4
   vocabWords = '(jungle) (northound) (north) (bound) (gravel) (gravelly) (rocky) (sandy) (rock) (sand) path/trail'
   name ='northbound gravelly trail'
   desc = "The gravelly path heads north, deeper into the jungle. "
;

noGoingBackNowBarrier : TravelBarrier 
   canTravelerPass(traveler) { 
        // ** allow the player to go back for the lantern if necessary
        if(!brassLantern.isHeldBy(gPlayerChar)){ 
               if((brassLantern.location == modernSupportBeam) ||
                  (brassLantern.location == startRoom)){
                   "Right, can\'t go annywhere without the brass lantern in this dark jungle. ";
                   return true;
               }
        }
        return (gameMain.is_a_girl == true); 
   }
   explainTravelBarrier(traveler) { "Not now. You have all night before you have to be back at the docks again. Right now the only thing really
                                    on your mind is getting in that mansion and toying around with some of those incredible machines you heard 
                                    stories about"; 
                                    if((brassLantern.isHeldBy(gPlayerChar)) && 
                                       (!brassLantern.isLit)){
                                          " and the first thing you need to do is turn on the brass lantern so you can see your way along this path"; 
                                    }
                                    ". ";
   } 
; 

twistyPassageOne: Room 'twisty passage'
  desc { 
        "You are in a maze of twisty little passages, all the same but 
        appearances aren\'t everything. This one leads ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a> and <a href=\"west\">west</a>";
        }else{
                "east and west"; 
        }           
        ". ";
  }
  east = twistyPassageTwo
  west = twistyPassageThree
;

twistyPassageTwo: Room 'twisty passage'
    desc {
        "You are in a maze of twisty little passages, all the same. This one leads ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a> and <a href=\"north\">north</a>";
        }else{
                "west and north";
        }           
        ". ";
    }
  west = twistyPassageOne
  north = twistyPassageFour
;

twistyPassageThree: Room 'twisty passage'
    desc {
        "You are in a maze of twisty little passages, some different. This one leads ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a> and <a href=\"west\">west</a>";
        }else{
                "east and west"; 
        }           
        ". You see light coming from the west. ";
    }
  east = twistyPassageOne
  west = twistyPassageFive
;
+ Distant 
    vocabWords = '(strange) (west) (western) light' 
    name = 'light'
    desc = "Just some light to the west. "
;

twistyPassageFour: Room 'twisty passage'
    desc {
        "You are in a maze of twisty little passages, this one\'s crampt. It leads ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a> and <a href=\"west\">west</a>";
        }else{
                "south and west";
        }           
        ". ";
    }
  south = twistyPassageTwo
  west = twistyPassageSix
;

twistyPassageFive: Room 'maze exit'
    desc { 
        "You are at the exit of a maze of twisty little passages. You can go ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"out\">out</a> or <a href=\"east\">east</a>";
        }else{
                "out or east"; 
        }
        ". ";
    }
  annoyedDwarf = nil
  out : TravelWithMessage, ThroughPassage {
      desc = "A passage leading out of the maze of twisty little passages. "
      travelDesc {
            if(shovel.isHeldBy(gPlayerChar)){
                  "As you go to leave a little dwarf appears in a puff of orange smoke and
                  grabs your shovel. He waggs it in the air at you and says,\"I\'ll take that! Because of people
                  like you I\'ve got to go fix the hole in the south chamber again. Thanks a lot buddy. You should
                  get a job as a home wrecker. You\'re really good at it.\"<.p>The dwarf takes the shovel and heads
                  west. You shrug and leave the passage. As you leave the wall closes up behind you. ";
                  shovel.moveIntoForTravel(pixyland);
                  twistyPassageFive.annoyedDwarf = true;
                  gameMain.zort += 4;// increments egg number variable "zort" 
            }else{
                  "As you leave the passage the wall closes up behind you. ";                
            } 
      }
      destination = basementDressingRoom
  }
  south = out
  east = twistyPassageThree
;

twistyPassageSix: Room 'dead end'
    desc { 
        "You are in a maze of twisty little passages, this one has a low ceiling and comes to a dead end. You can only go ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
          }else{
                "east"; 
          }
        " from here. ";
    }
  east = twistyPassageFour
;


millHouseDirtMound: Floor
  name = 'dirt mound'
  vocabWords = '(mill) (house) dirt mound/ground/floor'
  desc = "The mound of dirt looks freshly dug. "
  dobjFor(DigWith) { 
    preCond = [objVisible, touchObj]     
    verify() {} 
    check() {} 
    action(){ 
       // we'll let the shovel handle the message
    } 
  } 
;

millHouse: DarkRoom, OutdoorRoom
  roomParts = [millHouseDirtMound, defaultSky]
  name = 'mill house'
  vocabWords = '(abandoned) (old) (creepy) mill house'
  desc {
        if(!gPlayerChar.hasSeen(self)){
                "<i>An old boarded up mill house? This place is creepy. Too late to go back now. I can\'t stop thinking about that sex
                change machine. If it\'s true, I wonder if I\'ll get away with it.</i><.p>";
        }
        "The mill house is absolutely ancient looking, weathered and boarded up. A small creek runs alongside it, still turning the cranky, creaky old
        water wheel but it\'s obvious the place hasn\'t been used in ages. One of the windows hasn\'t been boarded up and sits open nearby. ";
        "The path continues ";
        if((gActor.lastTravelBack == junglePath4) || (gActor.lastTravelBack == deepJungle)){
               if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
               }else{
                "north"; 
               }
               " to a mansion off in the distance. You can just barely make out the faint yellow glow of light coming from all the little windows. ";
        }else{
               if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
               }else{
                "south"; 
               }
               " into the jungle and back toward the docks. ";
        }
   }
   east : NoTravelMessage {
         travelDesc { 
                 "You bonk your head on the mill house. Beyond that it\'s just jungle in that direction and you\'d rather stick to the
                 trail for now. ";
         }
   }
   west : NoTravelMessage {
         travelDesc { 
                 "There\'s nothing but dark spooky jungle in that direction. ";
         }
   }
  in : NoTravelMessage {
         travelDesc {
                 "The door\'s boarded up. ";
         }
  }  
  south = junglePath4
  north = junglePath5
  up = junglePath4
  travelBarrier = [noLantern, lanternNotOn]
;
+ Decoration '(many) (several) (boarded) (up) windows' 'boarded windows'
  "There are several boarded up windows on the mill house. "
  isPlural = true
;
+ millHouseWindow: Decoration '(mill) (house) (open) window' 'window'
  "An open window on the side of the mill house. "
  dobjFor(Enter){ verify(){ illogical('Not on your life. Could be spiders inside - or worse yet, monsters with fangs that bite and nasty claws that 
                                       could scratch your eyeballs out!'); }
  }
  dobjFor(LookThrough) remapTo(LookIn,millHouseWindow)
  dobjFor(LookIn){
        verify(){ }
        check(){ }
        action(){
            millHouseWindow.millhouseWindowTable.doScript();
        }
  }   
  millhouseWindowTable: StopEventList {
        eventList = [
            'You get up on tiptoe and look in the open window.<.p> 
            A creepy old man with a white beard, bald head and wide eyes peers back out 
            at you and he smiles a toothless smile and waves with one hand while sipping
            a cup of coffee with the other.<.p>\"Woah! Sorry. I didn\'t know anybody lived in
            there,\" you say.<.p>"Oh I don\'t live here,\" he says. \"I\'m looking for sea shells.\"
            <.p>...and just like that he slowly lowers his entire body downward and out of view. ',
            'You look in the open window again and see a spider scurry by. ',
            'You look in the open window again but don\'t see anything. '
        ]
  }
;
+ Decoration '(small) (little) (mill) creek water' 'creek'
  "A little creek running alongside the mill. "
;
+ Decoration '(mill) (water) wheel' 'water wheel'
  "An old water wheel. You see that it still works. The creek nearby is turning it. "
;
+ Unthing '(creepy) (spooky) (black) (widow) (creepy) (crawly) gru grue crawlies spider*spiders' 'spiders'
  'They\'re out and about, that\'s for sure. You\'re pretty certain that mill house is jam packed full of creepy crawly things. '
  isPlural = true
;
+ Unthing '(creepy) (old) (white) (bearded) man' 'creepy old man'
  'You could have sworn you saw a white bearded old man in the window a second ago but he\'s not there now. 
  Maybe it was all just your imagination. Could be you\'re getting the night before Halloween jitters. '
;
+ Decoration '(boarded) (up) (wood) (wooden) (old) (mill) (house) (millhouse) door' 'door'
  "A door on the side of the mill house. It\'s all boarded up. "
 dobjFor(Enter){ verify(){ illogical('The door is boarded up. You can\'t enter it. Not that you\'d want to. That mill house is
                                     probably loaded with creepy crawlies.'); 
                         }
 }  
 dobjFor(Open){ verify(){ illogical('You can\'t open it. It\'s boarded up.'); }
 }                    
;
+ millHouseJungleObj: Decoration '(deep) (green) (leafy) jungle' 'jungle'
    "Just a bunch of jungle trees all around you. A trail leads through it to the north and south from here. "
;
+ junglePath4: PathPassage 
   masterObject = junglePath3
   otherSide = junglePath3
   vocabWords = '(jungle) (southbound) (south) (bound) (gravel) (gravelly) (rocky) (sandy) (rock) (sand) path/trail'
   name ='southbound gravelly trail'
   desc = "The gravelly path heads south into the jungle. "
   travelBarrier = noGoingBackNowBarrierTwo
;
+ junglePath5: PathPassage 
   masterObject = junglePath5
   otherSide = junglePath6
   vocabWords = '(jungle) (northbound) (north) (bound) (gravel) (gravelly) (rocky) (sandy) (rock) (sand) path/trail'
   name ='northbound gravelly trail'
   desc = "The gravelly path heads north to the mansion. "
;

brokenShovel: Decoration
  name = 'rusty shovel'
  vocabWords = '(rusty) (rust) (coated) (old) (iron) (metal) (broke) (broken) (discarded) (useless) handle shovel'
  desc = "A rusty old shovel. It\'s handle has broken off and it lies here discarded and useless. "
  initSpecialDesc = "A broken shovel lies in pieces on the ground here beside a pile of dirt. "
  specialDesc = initSpecialDesc
  location = pixyland
;

shovel: Thing
  location = millHouse
  name = 'rusty shovel'
  vocabWords = '(old) (ancient) (pretty) (weathered) (rusty) (rust) (coated) (old) (iron) (metal) shovel'
  desc = "A rusty old shovel. "
  initSpecialDesc = "Jammed point downward into the ground beside a mound of dirt is a rusty old shovel. "
  hasDugW = nil
  digCounter = 0 
  hasDugMH = nil
  iobjFor(BreakWith){
    verify(){ 
        if(gDobj != nil){
            if(gDobj == porchDoor01){
                nonObvious;
            }
        }
    }
    check(){}
    action(){}
  }
  iobjFor(AttackWith){
    verify(){ 
        if(gDobj != nil){
                if(gDobj == porchDoor01){
                    nonObvious;
                }
        }        
    }
    check(){}
    action(){}
  }
  iobjFor(DigWith){
        verify(){ logicalRank(110,'likely'); }
        check(){
                if(gActor.location == formSaverRoom){
                      "Not in here. You\'ll make a mess. ";
                      exit;
                }
                if(!gActor.location.ofKind(OutdoorRoom)){
                     "Not here. You\'ll have to try that outside. ";
                      exit;
                 }
        }
        action(){ 
               if(gActor.location == westOfMansion){
                     shovel.digCounter++;
                     if(shovel.hasDugW == nil){
                          shovel.hasDugW = true;
                          "You dig a little in the garden. It\'s a toilsome task. You don\'t even know really why you\'re
                           digging or what you hope to discover. If anyone sees you they\'ll think you\'re digging a grave or
                           something out here. After awhile you stop digging. You find nothing. ";
                     }else{
                          "You dig some more in the garden. ";
                          if(shovel.digCounter == 2){
                               "You dig and dig and dig and finally the ground gives out beneath you and you go tumbling down
                               into a passageway. ";
                               gPlayerChar.moveIntoForTravel(twistyPassageOne);
                               gPlayerChar.lookAround(true);
                          }else{
                               "You find nothing. ";
                          }
                     }
               }else if(gActor.location == millHouse){
                     if(shovel.hasDugMH == nil){
                            "You dig a little but find nothing of interest and give up. ";
                            shovel.hasDugMH = true;
                     }else{
                            "You dig a little... The ground\'s too hard. You have broken your shovel!<.p>An old man with a white beard peers out through 
                            the mill house window at you, laughs and says,\"Shovels! Har, har, har, har.... shovels!\" And slowly
                            receeds out of sight. ";
                            shovel.isListed = nil;
                            shovel.moveIntoForTravel(pixyland);
                            brokenShovel.moveIntoForTravel(millHouse);
                     }
               }else{
                     "You dig a little but find nothing of interest and give up. ";
               }
        }
  }
    feelDesc = "The tip feels rusty. The handle feels weathered. "
    tasteDesc = "Probably the best example of what an old shovel ought to taste like. In other words... it tastes much as you expected. "
    dobjFor(Eat){
        preCond=[objVisible, objHeld]
        verify(){ }
        check(){ }
        action(){
            if((sleepingDragon.canSee(gPlayerChar)) && (sleepingDragon.woken == true)){
                "The dragon frowns down at you in concern as you attempt to shove the shovel tip in your
                mouth. \"Mortal? What do you think you\'re doing? Whatever it is I am not amused by it,\" the dragon says and when he 
                sees you aren\'t stopping he swoops his claw down and takes the shovel away,\"Give me that before you hurt yourself!\"<.p>";
                shovel.moveInto(sleepingDragon);
                "The dragon ponders something for awhile as he strokes his chin, then he mutters something about foolish mortals
                and steps to one side to let you pass. \"It would best my conscience to kill such a fool. The way north is clear
                for you. Now... GO! And never come back lest you anger me again.\" ";
                sleepingDragon.pityTheFool = true;
                sleepingDragon.setConvNode('i-pity-the-fool');
            }else{
                "I\'ve heard of sword swallowers but this is ridiculous! ";
            }
        }
    }
;
+ Component 
    name = 'rusty shovel tip'
    vocabWords = '(old) (ancient) (pretty) (weathered) (rusty) (rust) (coated) (old) (shovel) (pointed) (pointy) (sharp) iron metal end tip'
    desc = "The tip of the shovel is amazingly sharp despite all the rust. "
    feelDesc = "Feels rusty. "
    tasteDesc = "If this is how you intend on getting iron in your diet, you\'ve got issues. "
;
+ Component
    name = 'rusty shovel handle'
    vocabWords = '(old) (ancient) (pretty) (weathered) (rusty) (rust) (coated) (old) (iron) (metal) (splintered) (wooden) (shovel) splinters wood handle'
    desc = "The handle of the rusty shovel looks pretty weathered. It\'s made of wood and seems to have had many years of use. "
    feelDesc = "Feels weathered. "
    tasteDesc = "You\'d probably get splinters. "
;
+ oldShovelRust: Component, Thing '(old) (ancient) (pretty) (weathered) (rusty) (aged) (coated) (old) (iron) (metal) (shovel) (little) (bumpy) rust' 'shovel rust'
    "The old shovel\'s covered in rust and looks pretty weathered. Digging in anything but soft ground could easily break it. "    
    feelDesc = "Feels a little bumpy. "
    tasteDesc = "You might get sick tasting that. "
;
+ oldShovelBumps: Component, Thing '(old) (ancient) (pretty) (weathered) (rusty) (aged) (coated) (old) (iron) (metal) (shovel) (little) (bumpy) (rust) bump*bumps' 'shovel rust bumps'
    "There are rust bumps all over the tip of the shovel. "    
    isPlural = true
    feelDesc = "Feels bumpy all right. "
;

noGoingBackNowBarrierTwo : TravelBarrier 
   canTravelerPass(traveler) { 
        return (gameMain.is_a_girl == true);
   }
   explainTravelBarrier(traveler) { "Not now. You have all night before you have to be back at the docks again. Right now the only thing really
                                    on your mind is getting in that mansion and toying around with some of those incredible machines you heard 
                                    stories about"; 
                                    if((brassLantern.isHeldBy(gPlayerChar)) && 
                                       (!brassLantern.isLit)){
                                          " and the first thing you need to do is turn on the brass lantern so you can see your way along this path"; 
                                    }
                                    ". ";
   } 
; 

theMainButler: Unthing
    name = 'butler'
    vocabWords = '(the) (master\'s) (head) (mansion) (estate) (house) man butler'
    disambigName = 'the butler'
    theName = 'the butler'
    isHim = true
    isHer = nil
    isIt = nil
    notHereMsg = 'You don\'t see him here anymore. He\'s inside there somewhere, probably peeking at you through a window. '
    location = pixyland
;

mansionPorch: OutdoorRoom 'porch'
   vocabWords = '(creepy) (spooky) (old) (mansion) (house) (estate) (front) porch'
   desc {
        if(!gPlayerChar.hasSeen(self)){
                "<i>This sure seems like a mistake. I can\'t go in the house this way. I\'ve got to find a way around. That garden path to the west
                looks like a good choice. I should take that.</i><.p>";
        }
        "The sea green painted boards creak underfoot on this little porch. The mansion seems oddly silent.
        The porch light is off but the porch itself is fairly well lit from the light coming in through the window beside you. The door is closed
        and though back in your home town you don\'t mind party crashing too much, it seems like the wrong thing to
        do here. Better find another way inside and quick, before you\'re caught.<.p>";
        if((gActor.lastTravelBack == junglePath6) || (gActor.lastTravelBack == millHouse)){
               "The path you arrived on leads ";
               if(gameMain.allowHtmlLinks){
                  "<a href=\"south\">back</a>";
               }else{
                  "back";
               }
               " to the jungle, but you really don\'t want to go back now that you\'ve
               come this far. The one leading ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
            }else{
                "west";
            }
            " seems like the better choice. ";
        }else{
            "A path leads ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
            }else{
                "west"; 
            }
            " from here to the front garden and another leads ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
            }else{
                "south"; 
            }                
            ". ";
        }
   }
   south = junglePath6
   west = gardenPath1
;
+ Decoration '(pretty) (creepy) (eerie) (erie) (old) (ancient) (worn) (weathered) (spooky) mansion house estate' 'mansion'
  "Here on the porch the mansion looks pretty spooky. "
;
+ Decoration '(island) (lake) (green) (thriving) (living) jungle trees (and) bushes jungle' 'jungle'
    "Just some thriving trees and bushes. "
;
+ mnsnPorchWindows: Decoration '(mansion) (porch) room rooms window windows light lights' 'mansion windows'
  "The are many windows visible along the front of the mansion. Most of the rooms seem to have their lights on but
  you don\'t hear a sound coming from inside so it\'s hard to really tell if anyone is home or not. "
  isPlural = true
;
+ mnsnPorchBoards: Decoration '(old) (sea) (green) (painted) (porch) (floor) boards' 'porch boards'
  "Just some sea green painted old boards. The porch is made up of them. "
  isPlural = true
;
+ junglePath6: PathPassage 
   masterObject = junglePath5
   otherSide = junglePath5
   vocabWords = '(jungle) (southbound) (south) (bound) (gravel) (gravelly) (rocky) (sandy) (rock) (sand) path/trail'
   name ='southbound gravelly trail'
   desc = "The gravelly path heads south into the jungle. "
   travelBarrier = noGoingBackNowBarrierThree
;
+ gardenPath1: PathPassage 
   masterObject = gardenPath1
   otherSide = gardenPath2
   vocabWords = '(garden) (westbound) (west) (bound) (gravel) (gravelly) (rocky) (sandy) (rock) (stone) (sand) trail/path'
   name ='westbound garden path'
   desc = "The gravelly path heads west to a little garden. "
   dobjFor(Enter){
      verify(){ logicalRank(80,'somewhat likely'); 
                // inherited;
      }
      check(){ inherited; }
      action(){ inherited; }
  }
;
+ porchDoor01 : LockableWithKey, Door 
  vocabWords = '(shovel) (damaged) (dented) (scratched) (Easter) (Island) (wood) (wooden) (hardwood) (worn) (mansion) (front) (porch) door'
  name = 'front door'
  desc = "<<doorDesc>> "
  doorDesc = 'The front door is made of hardwood and is locked. '
  keyList = [gmDmSkeletonKey]
  initiallyLocked = true
  dobjFor(Enter){
        verify(){ logicalRank(120,'likely'); 
                  inherited;
        }
        check(){ inherited; }
        action(){ inherited; }
  }
  dobjFor(TravelVia){
      verify(){ logicalRank(130,'very likely'); 
                // inherited;
      }
      check(){ inherited; }
      action(){ inherited; }
  }
  dobjFor(Open){ verify(){ illogical('It\'s locked and you don\'t have the key. '); } }
  dobjFor(Unlock){ verify(){ illogical('You don\'t have the key. '); } }
  dobjFor(KnockOn){
                   verify(){ logicalRank(110,'likely');
                   }
                   check(){
                           say('Bad idea. You\'re on a private island showing up to Dracula\'s house for all you know.
                                You\'re uninvited and just being here on this person\'s island at all might make
                                the owner mad at you. If you\'re discovered it\'s sure to raise questions you\'re not 
                                willing to answer right now. You\'re here to snoop around and see if those strange 
                                inventions really exist, not get your head bitten off by vampires. ');
                           exit;
                   }
  }
  dobjFor(Break){
      verify(){ nonObvious; }
      check(){ }
      action() { 
          askForIobj(BreakWith); 
      }
  }
  // added Attack & AttackWith - 3JUL2019 Cleo Kraft
  dobjFor(Attack){
      verify(){ nonObvious; }
      check(){ }
      action(){
          tryImplicitAction(BreakWith,self,askForIobj(BreakWith));
          // askForIobj(BreakWith);// ask for what to attack the door with, then remap to BreakWith          
      }
  }
  dobjFor(AttackWith) maybeRemapTo((gIobj !=nil),BreakWith,gDobj,gIobj)
  dobjFor(BreakWith){
    verify(){ logicalRank(110,'likely'); }
    check(){ 
          if(gIobj != shovel){
                reportFailure('The front door is too strong to break with that. ');
                exit;
          }
    }
    action(){
          "You pound and pound and pound on the front door with the shovel, trying to break it.
          After awhile the door opens and you stop mid-swing, shovel in hand and the butler stares at you, stares at the
          shovel, then stares at all the damage you\'ve caused to the front door. He grabs your shovel away from you and
          shouts,\"Lunatic! Maniac! Give me that. How dare you, sir! How dare you come here with your rusty shovel and 
          willfully, and without regard for other people\'s property, repeatedly dent in the Master\'s door? You have all
          the nerve of an ill tempered electric eel. Did you know that the Master had this door imported all the way from
          Easter Island? Do you realize how <i>rare</i> this wood is? The Master will be very upset when he finds out... and just
          how am I going to explain all these shovel marks?\"<.p>";
          theMainButler.moveIntoForTravel(mansionPorch);// move the Unthing here so the player can maybe refer to him after encounter
          shovel.moveIntoForTravel(pixyland);
          shovel.isListed = nil;
          porchDoor01.doorDesc = 'The front door is made of hardwood and is locked. It\'s rather dented, scratched and scraped up from your damaging it with the rusty shovel. ';
          if(travelersCheck.isHeldBy(gPlayerChar)){
                 "\"I\'m sorry about that,\" you say taking out your traveler\'s check. \"I\'ll write you a check for the damages. How about
                 that?\"<.p>The butler frowns then says,\"Well I suppose it\'s all right... but I\'m <i>still</i> going to keep the shovel.\"<.P>
                 You borrow a pen from the butler and fill out a sizeable check of two hundred thousand Kinets, the local currency,
                 which seems like quite a bit. You\'re not absolutely sure on the rate of exchange but you think you\'re getting a pretty good 
                 deal. The butler takes the check, keeps your shovel and shuts and locks the door again. ";
                 travelersCheck.moveIntoForTravel(pixyland);
                 travelersCheck.isListed = nil;
          }else{
                 "\"I\'m sorry about that,\" you say checking your pockets but coming up without anything to really offer him for the
                 damages. \"I don\'t seem to have any money right now. Maybe we could work out some kind of an arrangement where you send
                 me the bill for all this.\"<.p>The butler shakes his head no and says,\"I\'ve a much better idea. We\'re always in need
                 of test subjects for the Master\'s experiments. You shall become a test subject and work off what you owe. If you disagree
                 you go to jail. So what will it be?\"<.p> ";
                 local iDone = 0;
                 local s0 = '';
                 do{
                                  "<br> 1. agree to become a test subject
                                   <br> 2. go to jail
                                   <br> 3. make a run for it
                                   <br> Please select (1, 2 or 3) : ";
                                  s0 = inputManager.getInputLine(nil, nil);
                                  if((s0 == '1') || 
                                     (s0 == '2') ||
                                     (s0 == '3') 
                                  ){ 
                                  iDone++;
                                }else{
                                   "Please select <b>1</b> or <b>2</b> or <b>3</b><br>";
                                } 
                                "\n";
                 }while(iDone==0);
                 if(s0=='2'){ 
                         "<.p>Not trusing what kind of creepy experiments you\'d be in for as a test subject, you decide 
                         to go to jail instead. You are detained and led to the dock where you wait until the police arrive by boat to
                         take you to jail in the village where you rented a villa. You spend a night in jail and are released the next
                         day with a heavy fine which your girlfriend back home kindly pays for. She demands
                         you explain everything and return home on the very next flight, which you do. You eventually patch up things between
                         the two of you.<.p>When the zombie army attacks and takes over the world you see in the news that the new world leader
                         is a man from that island you visited. Perhaps even the mad scientist who lived in that mansion. You get stuck at the drive-through
                         one day when you\'re attacked by zombies and turned into one yourself. That\'s sort of when your girlfriend decideds to break up with 
                         you - which is a real bummer because even zombies have needs and feelings and deserve respect and consideration and love even if they 
                         don\'t always show it. Sure brains and blood are nifty treats for you now but it\'s always nice to know you\'ve got a significant other
                         to come home to after a hard day of shuffling slowly through one burning town after another with your arms outstretched, waiting to hug 
                         a new friend. For some reason all the non-zombie people shun you and run away screaming. You try to go after your girlfriend, Sherry, and
                         beg her to take you back but you\'re miles away from where she lives now and you\'ve got no thumbs anymore. A mean old lady cut them off
                         with a buzz saw last week when you tried to befriend her pet poodle Fifi, so you can\'t even hitchhike your way back to the land of love. 
                         It\'s just one bad day after another now. People coming at you with torches and pitchforks. It\'s like no fun at all and when you really think
                         about it the life of a zombie isn\'t what it\'s all cracked up to be, not to mention the worms that keep multiplying. It\'s getting hard to
                         tell them apart anymore. You tried to name each and every one of them. Herman, Melvin, Joey, Louis, Percy, Stephen... but now it seems like
                         an enormous waste of effort. Still, they\'re among the only friends in the world you have left and they\'re eating yout out of house and 
                         home, among other things, and they\'re really getting under your nerves. It\'ll be a miracle when all this is over and you can just relax
                         and retire but until then you\'ve got a lot of work to do. A zombie\'s day is never over. It\'s just work, work, work. All the time work
                         but at least you\'ve got your worms and memories of the good old days when it didn\'t take any brains at all to cook dinner. Ah, the good old days...<.p> ";
                         inputManager.pauseForMore(true);// better than using just the morePrompt()
                         "<HR ALIGN=CENTER NOSHADE><br>
                         <b>The End</b>";
                         finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);
                         exit;
                 }else if(s0=='3'){
                         "<.p>You turn and run away. The butler runs after you swinging the shovel, trying to hit you but he\'s not as fast as you are. You 
                         make it to the dock and hide in the jungle until morning. The boat that dropped you off arrives to pick you up again and you get on
                         board. The boat captain asks,\"So, what was it like?\"<.p>You shrug and say,\"Nothing much happened. Just met a crazy butler who tried
                         to kill me with a shovel, that\'s all.\"<.p>\"Too bad,\" the boat captain says. \"Was hoping you\'d have a better story than that. Most
                         people who visit the island and return to tell a tale have much better stories than that. Better luck next time, right?\"<.p>You finish
                         your vacation and go home. A few months later an army of zombies takes over the world led by a mad scientist who claims to have been from
                         the very island you visited. Perhaps if only you\'d snuck in the mansion another way you could have tried to stop him.<.p>The job market
                         has radically changed since zombies took over. All there is for work are supervisory positions over zombies. You become a manager of a car
                         wash. The pay is all right but you have to keep beating the zombie workers with a stick to keep them in line. They\'re always goofing off
                         and taking extra long breaks and whipping each other with wet shammies, thinking it\'s funny or something. You\'d fire them but all you\'d
                         ever get for replacement workers are more zombies - it\'s a union thing. It\'s quite a headache. You break up with your girlfriend and wind
                         up toiling through life at the mercy of a diabolical world dictator who keeps coming up with new and crazy laws which always seem to favor
                         zombies over the living. You wish you\'d tried to stop the madman on his island while you had the chance. Maybe you could have saved the 
                         world. Now it seems you\'ve got to play by his game. It\'s Friday and every Friday it\'s be kind to zombies day. So you can\'t even beat them
                         with a stick to make them work so it\'s no fun at all. You hate Fridays. You used to look forward to Friday but now it\'s the worst day of
                         the week and all on account of you tried going in the front door of the mansion the night before Halloween when you probably should have 
                         tried sneaking in through the basement instead.<.p>";
                         "<HR ALIGN=CENTER NOSHADE><br>
                         <b>The End</b>";
                         finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);
                         exit;
                 }else{
                         "<.p>You agree to become a test subject. The butler couldn\'t be happier about your decision. He doesn\'t look all that threatening with
                         a shovel for a weapon. You probably should have tried to run away but being a test subject intrigues you so you go along with the idea.
                         He leads you upstairs to the attic and makes you crouch in a machine half your size. He closes the door and presses a button and you 
                         shrink and hair all over your body. When the transformation finishes all your clothes have been reduced to dust and you have grown a tail.
                         He picks you up and holds you before a mirror. He says,\"See? You\'re a monkey. Now I\'ll put you in a cage and we\'ll begin running some
                         tests on you starting tomorrow. The Master will be pleased to have a new monkey to inject his experimental zombie serum into.\"<.p>He 
                         places you in a small cage and locks the door. After he leaves you glance down at your crotch and see that you\'ve still got boy parts.
                         You were kind of hoping he\'d have at least turned you into a girl just to see what it\'s like but instead you\'ve kept your sex and were
                         turned into a monkey. Tomorrow\'s Halloween and it looks like this year you\'re going as a monkey and all you\'ll be getting for a treat
                         is probably a bunch of banannas. You try to call for help but you can\'t form words anymore. All that comes out of your mouth are screaches
                         and ridiculous monkey sounds. You rattle the cage and yell. Eventually the butler comes back and wags a stern finger at you and says,\"Don\'t
                         be bad or I\'ll have to punish you. It would be a real shame if you made me hit you. I hate it when I have to spank the monkey.\"<.p>Looks 
                         like things haven\'t ended well for you. Maybe next time you\'ll try sneaking in through the basement or something instead of trying to go
                         through the front door. Spooky mansions probably should be avoided entirely, especially with all the rumors about what goes on in the place.
                         Maybe next time you\'ll be more careful.<.p>";
                         "<HR ALIGN=CENTER NOSHADE><br>
                         <b>The End</b>";
                         finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);
                         exit;
                 }
          }
    }    
  }
;
+ littleRedDoorbell: Decoration '(little) (red) (metal) (mansion) (front) (porch) (door) doorbell/button/bell' 'doorbell'
  "A little red metal doorbell mounted beside the door. "
  dobjFor(Ring){ verify(){ logicalRank(110,'likely');
                 }
                 check(){
                           say('You\'d rather not. You want to sneak in there secret-like and unnoticed to snoop around. 
                                      If you rang the doorbell you\'d be in a heap of trouble, showing up here on their private island
                                      unannounced and uninvited. ');
                           exit;
                 }
  }
  dobjFor(Push) remapTo(Ring, littleRedDoorbell)
;

noGoingBackNowBarrierThree : TravelBarrier 
   canTravelerPass(traveler) { 
        return (gameMain.is_a_girl == true);
   }
   explainTravelBarrier(traveler) { "Not now. You have all night before you have to be back at the docks again. Right now the only thing really
                                    on your mind is getting in that mansion without getting caught and then experimenting with some of those
                                    strange machines you\'ve heard so much about. The path leading west seems like the only choice. ";
   } 
; 

// placeholder room - unused in the game. only here for expansion and otherside of front door object
mansionFrontRoom: Room 'front room'
  "The front room of the mansion. "
;
+ porchDoor02 : LockableWithKey, Door -> porchDoor01
  vocabWords = '(mansion) (front) (porch) (inside) (room) door'
  name = 'front door'
  desc = "The front door is made of hardwood and is closed and locked. "
  keyList = [gmDmSkeletonKey]
  initiallyLocked = true
;

mansionGarden: Floor
  name = 'garden'
  vocabWords = 'garden dirt/ground/floor' 
  desc = "The garden is mostly dirt but there are a few flowers here and there. "
  dobjFor(DigWith) { 
    preCond = [objVisible, touchObj]     
    verify() {} 
    check() {} 
    action(){ 
       // we'll let the shovel handle the message
    } 
  } 
;

westOfMansion: OutdoorRoom 'front garden'
   roomParts = [defaultSky, mansionGarden, defaultEastWall, defaultNorthWall]
   desc {
        if(!gPlayerChar.hasSeen(self)){
                "<i>Okay, that\'s more like it. There\'s a basement door here I can use. I just hope I don\'t get caught.</i><.p> ";
        }
        "A small garden leads through here to a large wooden fence surrounding the backyard. 
        A tall vine covered brick chimney stands up against the side of the mansion. A garden path leads ";
        if(gameMain.allowHtmlLinks){
            "<a href=\"east\">east</a>";
        }else{
            "east";
        }           
        " from here back to the porch. A basement ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"enter door\">door</a>";
        }else{
                "door"; 
        }           
        " is here. ";
   }  
   east = gardenPath2 
   down = mansionBasementDoor01
   atmosphereList : ShuffledEventList {
        eventList = [
                    'You hear the howling of wolves off in the distance. ',
                    'You hear what sounds like <i>Ooooooooooooooooooooooooooooooo!</i> coming from far away. ',
                    'A strong breeze causes the window eaves to clatter a little. ',
                    'A little bat flys past you, makes a sudden left hand turn and vanishes over the back fence. ',
                    'A little rabbit pops its head out of a rabbit hole nearby, chomps on a carrot for a moment
                    as it looks up at you contemplating what to say. It thinks better of it after awhile and vanishes
                    back down into the rabbit hole. ',
                    'A flying squirrel goes swooping down from the trees, nearly flys right into your head, then darts
                    up and over the fence in a loop-de-loop and is gone. Was he... wearing a... cape? ',
                    'You hear the howling of wolves. ',
                    'You hear the window eaves clatter in the wind. ',
                    'You glance up at one of the windows for a moment and there staring down at you is what appears to be
                    a ghost. It floats away after a moment and is gone. '
                   // 'A tiny flying snake goes spiraling through the air and vanishes over the fence dragging along a 
                   // banner which reads \"paranormal raceway.\" '
        ]
   }
   /*
    *  Easter egg
    */
   enteringRoom(traveler){
      if(statisticsObj.restartCount > 2){
            if(largeCorkPlug.location != mansionBasement){
                 largeCorkPlug.moveIntoForTravel(mansionBasement);
                 corkPlugDrain.moveIntoForTravel(mansionBasement);
                 largePlugChain.moveIntoForTravel(mansionBasement);
            }
      }
   }
;
+ vineCoveredChimney: Decoration '(vine) (covered) (coated) (red) (brick) chimney/chimeny' 'chimney'
  "A vine coated red brick chimney on the side of the house. "
  dobjFor(Climb){
       verify(){ illogical('You are not a monkey. '); }
  }
;
+ Decoration '(bright) (green) (chimeny) (chimney) ivy vine/vines' 'chimney vines'
  "Some bright green vines have grown up around the chimeny on the side of the house. "
  isPlural = true
  dobjFor(Climb){
       verify(){ illogical('You are not a monkey. '); }
  }
;
+ mnsnGardenGhost: Unthing '(garden) (white) (sheet) (wearing) ghost/ghosts' 'ghost'
  'You could have sworn you saw one peering down at you from one of the windows a second ago. Probably was just a man wearing
  a sheet with two eye holes poked out. It\'s probably nothing to worry about. It\'s the night before Halloween after all. Maybe
  they\'re just in the holiday spirit. ' 
;
+ mnsnGardenWind: Unthing '(garden) (light) (strong) breeze/wind' 'wind'
  'Feels like a light breeze blowing through the garden. From time to time it picks up, causing the window eaves to bang
  against the house. '
;
+ mnsnFlyingSquirrel: Unthing '(flying) (rocky) (the) squirrel/squirrels' 'flying squirrel'
  'You could have sworn you saw him a second ago buzzing you but he\'s not here right now. '
;
+ mnsnFlyingSquirrelCape: Unthing '(flying) (rocky) (rocky\'s) (squirrel) (squirrel\'s) (bright) (yellow) cape' 'squirrel cape'
  'If your eyes didn\'t deceive you, you could have sworn it was a bright yellow cape but you don\'t see
  it nor the squirrel around here anywhere right now. Weird. '
;
+ mnsnRabbitHole: Fixture, RestrictedContainer
  name = 'rabbit hole'
  vocabWords = '(small) (little) (rabbit) hole'
  desc = "A small rabbit hole in the garden. "
  validContents = [formCube]
  dobjFor(LookThrough) remapTo(LookIn,mnsnRabbitHole)
  dobjFor(LookIn){
      verify(){ }
      check(){ }
      action(){
              "You look in the little rabbit hole but don\'t see anything. If there\'s a rabbit inside he
              probably thinks he\'s being clever hiding from you like this. Maybe if you had your trusty shotgun with you,
              you could teach him a lesson, <i>huh-huh-huh-huh-huh</i>! ";
      }
  }
  dobjFor(Enter){
      verify(){ logicalRank(90,'somewhat likely'); 
      }
      check(){
              "Just who do you think you are, Alice in Wonderland? ";
              local sYes = 'Well you\'re not, so stop trying to cram yourself into every rabbit hole you see. It\'s not conducive to
                            sane behavior. ';
              local sNo = 'That\'s right, so stop trying to cram yourself into rabbit holes three times half your size. You\'d never
                           fit, it\'s dirty and what will the neighbors think? You\'ve got to pull yourself together here and find a
                           way in the house and this rabbit hole\'s not going to cut it. Maybe if you tried that basement door instead. ';
              local sMaybe = 'And maybe I\'m the Queen of Hearts but that still doesn\'t solve your problem of getting into the house. ';
              myNarrator.setNarratorQuestion(sYes,sNo,sMaybe);
      }
  }
;
+ myTrustyShotgun: Unthing '(my) (your) (trusty) (little) (shot) shotgun/rifle/gun' 'shotgun'
  'You left your shotgun at home. Too bad. Looks like rabbit season here. '
;
+ mnsnRabbit: Unthing '(little) (small) (tiny) (white) (gray) (grey) bugger rabbit' 'rabbit'
  'You could have sworn the little bugger was there a second ago but you don\'t see him now. Maybe you\'re just seeing things. '
;
+ mnsnGardenBats: Unthing '(little) (small) (tiny) (scary) (spooky) bat/bats' 'bats'
  'On occasion a bat flys past, heading into the backyard but at present you see no bats hovering about. '
  isPlural = true
;
+ mnsnGardenVampire: Unthing 'vampire/vampires/Dracula' 'vampires'
  'You certainly hope there are no vampires around tonight. It would certainly spoil your plans of having
  a good time. '
  isPlural = true
;
+ mnsnGardenWindowEaves: OutOfReach, Decoration
  name = 'window eaves'
  vocabWords = '(window) (windows) eave/eaves'
  desc = "Some window eaves on the side of each window. "
  tooDistantMsg = 'You can\'t reach the window eaves from here. They\'re too high up off the ground. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        return nil;
  }
;
+ mnsnGardenWindows: OutOfReach, Decoration 
  name = 'windows'
  vocabWords = 'window/windows'
  desc = "Just some windows on the side of the house. "
  tooDistantMsg = 'You can\'t reach the windows from here. They\'re too high up off the ground. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        return nil;
  }
;
+ mnsnGardenNoises: Unthing 'wolf wolves' 'wolves'
  'You hear the occasional howling of wolves off in the distance. They\'re out there all right. 
  Probably sneaking around scheming your demise with their sharp pointy teeth. '
  isPlural = true
;
+ mnsnGardenWolfNoises: Unthing '(wolf) (wolves) (wolf\'s) howling noise/noises/sound/sounds' 'wolf noises'
 'Sounds like: <i>Ooooooooooooooooooooooooooooooooooooooooooooooooo!</i> Maybe they\'re getting ready to do 
  a chorous. '
  isPlural = true
;
+ mnsnGardenWereWolf: Unthing 'werewolf/werewolves' 'werewolf'
  "You certainly hope there aren\'t any werewolves out there. "
;
+ mnsnGardenDec: Decoration '(mansion) (small) (black) (white) (yellow) flower flowers lillies/lillys' 'garden flowers'
  "A small garden on the side of the house. Hard to tell for sure at night but you think the flowers 
  are lillies. "
;
+ mnsnGardenFence: Decoration '(backyard) (wood) (wooden) fence/gate' 'fence'
  "A wooden fence surrounding the backyard. You\'ll not be getting in that way. There\'s a basement door right here
  that looks inviting enough. "
;
+ gardenPath2: PathPassage 
   masterObject = gardenPath1
   otherSide = gardenPath1
   vocabWords = '(garden) (eastbound) (east) (bound) (gravel) (gravelly) (rocky) (sandy) (rock) (stone) (sand) trail/path'
   name ='southbound garden path'
   desc = "The gravelly path heads east back to the porch. "
   dobjFor(Enter){
      verify(){ illogicalNow('You should follow the path. ');// fixes a bug where enter by itself defaults always to southern path, not basement door
                // inherited;
      }
      check(){ inherited; }
      action(){ inherited; }
  }
   dobjFor(TravelVia){
      verify(){ logicalRank(80,'somewhat likely'); 
                // inherited;
      }
      check(){ inherited; }
      action(){ inherited; }
  }
;
+ mansionBasementDoor01 : LockableWithKey, Door '(wood) (wooden) (mansion) (basement) (side) door/hatch' 'basement door'
     "A wooden basement door. "
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  dobjFor(Enter){
        verify(){ logicalRank(120,'likely'); 
                  inherited;
        }
        check(){ inherited; }
        action(){ inherited; }
  }
  dobjFor(TravelVia){
      verify(){ logicalRank(130,'very likely'); 
                // inherited;
      }
      check(){ inherited; }
      action(){ inherited; }
  }
;

class ClackShoes: AdvancedCromexxClothing
;    

/*
 * Added on 6/9/2019 by Cleo Kraft
 * 
 * ClackRoom is a room that makes click-clack sounds if you're wearing
 * the pumps. It's easier to have rooms declared this way vs. having the
 * shoes check a huge array of indoor rooms where they'd clack. 
 * 
 */
class ClackRoom: Room
  roomBeforeAction() {
    // NOTE: actionOfKind is a method in the Action class
    if (gAction.actionOfKind(TravelAction) && gAction.getDirection() != nil) {
        // loop through player inventory
        local oObj1 = nil;
        foreach(local obj in gPlayerChar.contents){
                if(obj.ofKind(ClackShoes) && obj.isWornBy(gPlayerChar)){
                    oObj1 = obj;
                }
        }
        if(oObj1 != nil && oObj1.isWornBy(gPlayerChar)){
                local sName = oObj1.name;
                local s0 = 'You hear your ' + sName + ' click-clack as you walk.<.p>';
                say(s0);
        }
        //if(strangeFemShoes.isWornBy(gPlayerChar)){
        //        say('You hear your pumps click-clack as you walk.<.p>');
        //}
    }
  }
;

largeCorkPlug: Decoration '(old) (rather) (large) (big) cork plug' 'cork plug'
  "A rather large cork plug. It\'s plugging a hole in the center of the room. An iron chain runs from the cork to the floor. "
  dobjFor(Pull) remapTo(Pull, largePlugChain)
  dobjFor(Unplug) remapTo(Pull, largePlugChain)
  dobjFor(Use) remapTo(Pull, largePlugChain)
  dobjFor(Take) remapTo(Pull, largePlugChain)
  location = pixyland
;
corkPlugDrain: Decoration '(cork) (plug) drain hole' 'drain'
  "A drain hole in the center of the room. A cork plug is plugging it up currently. "
  location = pixyland
;
largePlugChain: Decoration '(plug) (iron) (metal) chain' 'iron chain'
  "An iron chain dangling over the edge of a rather large cork plug in the floor. "
  dobjFor(Unplug) remapTo(Pull, largePlugChain)
  dobjFor(Use) remapTo(Pull, largePlugChain)
  dobjFor(Pull){
         verify(){ logicalRank(110,'likely'); }
         check(){  
               if(gameMain.is_a_girl == true){
                      "You haven\'t the arm strength anymore for such a task. If you were still a boy you might be able to
                      pull the large plug but not anymore. ";
                      exit;
               }
         }
         action(){
               // ** Non TG route
               "Half expecting the room to flood up with water you pull the plug.<.p> 
               Your ears pop as the air pressure in the room drastically changes. The plug hole suddenly pulls in everything
               it can in an enormous vacume. You scrape and claw your fingernails on the floor as you feel yourself being
               pulled slowly towards the opening. The basement door which was locked just a moment ago bursts open under all
               the horrible stress of suction and in comes a bat, a flying squirrel and half a dozen fruits and vegetables 
               along with a rather annoyed looking rabbit and they all get sucked away down the drain. Still clinging on to
               an ounce of hope you watch as a tub full of kindling and a rather large portrait of Ben Franklin holding a kite
               momentarily clog the hole, swirling around and around faster and faster until a large wooden rocking chair knocks
               them all away, freeing passage once again. You feel your legs dangling over the edge of the plug hole. Unable to hold
               on any longer you are suddenly falling down into darkness, emerging through the ceiling hole of a rather large
               cavern. You fall for another hundred meters and land bouncing back up on a greenish spongey surface. When you
               stop bouncing up and down all over the place you land in a trash heap in the center of an eerily green glowing
               cavern. ";
               // inputManager.pauseForMore(true);// better than using just the morePrompt()
               if(mansionBasement.contents != nil){
                  foreach(local obj in mansionBasement.contents){
                       if(
                          (!obj.ofKind(Door)) && (!obj.ofKind(Decoration))
                       )obj.moveIntoForTravel(greenCave);
                  }
               }
               gPlayerChar.moveIntoForTravel(greenCave);
               gPlayerChar.makePosture(sitting);
               gPlayerChar.lookAround(true);
         }
  }
  location = pixyland
;


transient statisticsObj: object 
   restartCount = 0
; 

PreRestartObject 

  execute() { 
    statisticsObj.restartCount++;    
  } 
; 

// NOTE: (pardon the pun there..) the desc below NEEDS to be in single quotes (other than Room object template format) or else this won't work
noRailroadingNote: Unthing '(dungeon) (and) (dragons) (D&D) (GM) (DM) (DM\'s) (GM\'s) (game) (master) (master\'s) (basement) (green) (glowing) (radioactive) (radio) (active) (magic) (magical) note paper' 'green glowing note'
  'It vanished into thin air but strangely left behind no trace of ashes. '
  location = pixyland  
;

noRailroadNoteAshes: Unthing '(dungeon) (and) (dragons) (D&D) (GM) (DM) (DM\'s) (GM\'s) (game) (master) (master\'s) (basement) (green) (glowing) (radioactive) (radio) (active) (magic) (magical) (note) (paper) ashes' 'green glowing note ashes'
  'That\'s just it - there ARE no ashes left behind of the green glowing note. '
  location = pixyland  
;

noOrangeSmoke: Unthing '(greasy) (orange) smoke' 'orange smoke'
  'It was here a second ago but it\'s gone now. '
  location = pixyland
;

noGlassVial: Unthing '(small) (little) glass potion vial' 'glass vial'
  'You could have sworn it was here a moment ago but it\'s gone now. '
  location = pixyland 
;

noCleoKraft: Unthing 'author programmer Cleo Cleopatra Kraft' 'Cleo Kraft'
  'You have no idea where Cleo is right now but you\'ve a sneaky suspicion she could be invisible and watching at any given moment. '
  isHer = true
  isHim = nil 
  location = pixyland 
;

noDungeonMaster: Unthing '(silly) (funny) (little) (dungeon) (and) (dragons) (D&D) (game) (train) GM DM Master/Referee/conductor/engineer/man/guy' 'dungeon master'
  'You see no dungeon master here... although the note you read makes you somewhat suspicious that maybe you\'re being watched. '
  location = pixyland
;

noPlayers: Unthing '(dungeon) (and) (dragons) (D&D) (game) (nerdy) nerd nerds player players' 'players'
  'You see no players here... though that note you read makes you wonder. '
  disambigName = 'nerd players'
  location = pixyland
;

mansionBasement: ClackRoom, DarkRoom 
  name = 'basment'
  desc {
      if(!gPlayerChar.hasSeen(self)){
                "The basement door slams shut behind you and you try and open it again but find to your dismay that it is locked. 
                <i>Wow, just like in all those old movies. Can always get in a house through the basement door but not back out that
                way it seems.</i><.p>";
             mnsnBasementDoorInner.makeOpen(nil);
             mnsnBasementDoorInner.makeLocked(true);
             mansionBasementDoor01.makeOpen(nil);
             mansionBasementDoor01.makeLocked(true);
      }
      "This must be the junk heap end of the basement. There\'s boxes upon boxes of stuff in here. Old crates, wooden and cardboard boxes
      and tons of old furniture stacked clear up to the ceiling. Aside from the locked basement door there\'s a way through another door
      to an adjacent room ";
      if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
      }else{
                "north"; 
      }           
      " of here. ";
      /*
       *  Easter egg - for the rest of setup see enteringRoom script in room: westOfMansion
       */
      if(statisticsObj.restartCount > 2){
            "There is a rather large cork plug in the center of the room here with a little chain attached. ";
      }
  }
  north = girlifyingLab
;
+ railRoadingNote: Readable, Thing '(dungeon) (and) (dragons) (D&D) (GM) (DM) (DM\'s) (GM\'s) (game) (master) (master\'s) (basement) (green) (glowing) (radioactive) (radio) (active) (magic) (magical) note paper' 'green glowing note'
  "Someone has hastily scribbled something on a green glowing piece of paper. "
    dobjFor(Read){
        preCond=[objVisible, touchObj, objHeld]
        verify(){ inherited; }
        check(){ inherited; }
        action(){ inherited; }
    }
    readDesc {
        "...The players are growing suspicious that I\'m doing some sketchy things
        as dungeon master. They think I\'m fudging rolls behind the DM screen but 
        that\'s nothing compared to their latest gripe. They actually feel I\'m
        <i>railroading</i> them from place to place in order to progress the campaign.
        Alas, perhaps it was a bad idea to wear my train engineer\'s cap to the game
        today.... Choo-Chooooooo!<.p>";
        "The note bursts into flames and vanishes in a cloud of greasy orange smoke...";
        // the note is never actually destroyed - it merely teleports from one place to another with the *illusion* of being destroyed
        if(railRoadingNote.location == pixyland){
            railRoadingNote.moveInto(mansionBasement);
        }else{
            railRoadingNote.moveInto(pixyland);
        }
        noRailroadingNote.moveInto(gPlayerChar.location.getOutermostRoom());
        noRailroadNoteAshes.moveInto(gPlayerChar.location.getOutermostRoom());
        noDungeonMaster.moveInto(gPlayerChar.location.getOutermostRoom());
        noPlayers.moveInto(gPlayerChar.location.getOutermostRoom());
        noCleoKraft.moveInto(gPlayerChar.location.getOutermostRoom()); 
    }
;
+ Decoration '(basement) box boxes junk heap heaps barrel barrels crate crates trunk trunks' 'basement junk'
  "It\'s just somebody else\'s basement junk. It\'s not important. "
    // isPlural = true // NOT plural because it'll say "The basement junk aren't important." Singular: "The basement junk isn't important."
;
+ mnsnBasementDoorInner : LockableWithKey, Door -> mansionBasementDoor01 
  vocabWords = '(wood) (wooden) (mansion) (basement) (side) door/hatch' 
  name = 'basement door'
  desc = "A wooden basement door. "
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
;

gmDmSkeletonKey: Key 
  vocabWords = '(GM) (DM) (game) (master) (dungeon) (master) (skeleton) key' 
  name = 'skeleton key'
  desc = "A standard game master skeleton key for which the player should never have. "
  location = pixyland
;




girlifyingLab: ClackRoom
  name = 'girling lab'
  desc {
      if(gPlayerChar.location == girlingBooth){
                 local tokList = Tokenizer.tokenize('examine booth');
                 executeCommand(gPlayerChar, gPlayerChar, tokList,nil);// nil = start of sentence (true/nil)      
                 exit;
      }
      if(!gPlayerChar.hasSeen(self)){
                "<i>Is that what I think it is? A strange looking machine with a booth you can enter? It is! 
                 Maybe the old man wasn\'t so crazy after all. I wonder which machine this one is.</i><.p>";
      }
      "Unlike the other side of the basment, this room is clean, neat, uncluttered and well lit. ";
      if(gameMain.is_a_girl != true){
                 "The strange machine is clearly the centerpiece of the room. ";
                 if(!gPlayerChar.hasSeen(self)){
                       "Excitement mounting, you rush over to it for closer examination. ";
                 }
                 "There are buttons, dials and knobs on it everywhere and inside it\'s
                 lined completely wall to wall with a soft pink fabric. The smell
                 coming from within is definately feminine. It enchants you with
                 the scent of sweetness, the kind of captivating fragrance that young women\'s
                 bodies naturally give off. Baby fresh, new and mesmerizingly wonderful. 
                 If the stories are true there is only one thing this can be and that\'s
                 a sex change machine. The outer surface is fine smooth white metal and on
                 it just above the controls in bright pink letters it reads: \"girl maker.\" ";
                 if(!gPlayerChar.hasSeen(self)){
                       "You realize this is the machine for turning guys into girls but you look
                       around and don\'t see any machine in here that indicates it does the opposite. ";                 
                 } 
      }else{
                 "The girl maker stands ominously before you. You can\'t help but tremble a
                 little in its presence and feel a deep sense of respect for whoever invented
                 such a remarkable machine. The machine responsible for turning you into a girl.
                 There are buttons, dials and knobs on it everywhere and inside it\'s
                 lined completely wall to wall with a soft pink fabric. The smell
                 coming from within is definately feminine. The outer surface is fine smooth white metal and on
                 it just above the controls in bright pink letters it reads: \"girl maker.\" ";
      }
        if(gPlayerChar.location != girlingBooth){
            "Exits lead ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a> or <a href=\"north\">north</a>";
            }else{
                "south or north"; 
            }                
            " from here or you go ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"in\">in</a>";
            }else{
                "in"; 
            }
            " the girl maker. ";
        }else{
            "You can exit the booth by going ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"out\">out</a>";
            }else{
                "out"; 
            }
            ". "; 
        }
  }
  roomBeforeAction {
        local iActionFlag = ((gAction.ofKind(TakeAction)) || 
                                    (gAction.ofKind(FeelAction)) ||
                                    (gAction.ofKind(SmellAction))||
                                    (gAction.ofKind(PushAction)) ||
                                    (gAction.ofKind(PullAction)) ||
                                    (gAction.ofKind(MoveAction)) ||
                                    (gAction.ofKind(EatAction))  ||
                                    (gAction.ofKind(TasteAction))||
                                    (gAction.ofKind(KissAction)) );
        if(gDobj!= nil){
                if(
                    (gDobj.location == girlingBooth) &&
                    (gActor.location != girlingBooth) &&
                    (iActionFlag == true)
                  ){
                        local s0 = (gDobj.location == girlingBooth) ? 'inside' : 'outside';
                        local s1 = '{You/he} {cannot} reach {the dobj/he}. {It\'s} ' + s0 + ' the booth. ';
                        reportFailure(s1);
                        exit;
                }
        }
  }
  receiveDrop(obj, desc){
        if(gActor.location == girlingBooth){
            obj.moveInto(girlingBooth);
        }else{
            obj.moveInto(self);
        }
        desc.standardReport(obj, self);
  }
  south = mansionBasement
  north = formSaverRoom
  // dobjFor(Examine) maybeRemapTo(isDirectlyIn(girlMaker), Examine, girlMaker, gActor)
;
+ Odor 'strong feminine female girly womanly body smell/scent' 'feminine scent'
  descWithSource { if(gActor.location == girlingBooth){
                     if(gameMain.is_a_girl==nil){
                           "It smells like a girl in here. ";
                     }else{
                           "It smells like a girl in here even more so than before. Maybe because you\'re a girl now. ";
                     }
                 }
  }
  hereWithSource = descWithSource
  displaySchedule = [2, 3, 3, 5] 
  noLongerHere = "The feminine scent diminishes a little. " 
; 
+ girlMaker: Fixture, Readable, Heavy '(strange) (girl) (sex) (change) (sexchange) (tg) (tf) (tgtf) (transformation) (woman) (female) machine/device/invention/maker' 'girl maker'
  "It\'s got a sleek outer appearance with white metal everywhere and knobs, dials and buttons
  all over. Just above the control panel in bright pink letters it reads \"girl maker.\" The inside
  is nicely decorated with wall to wall pink fabric. "
  /* player tries to put something in the machine... reroute it to "put gDobj in slot" */
  iobjFor(PutIn) maybeRemapTo((gDobj !=nil),PutIn,gDobj,girlingBooth)
  readDesc = "<i>girl maker</i> "
  dobjFor(Use) remapTo(Use, boothControls)
  dobjFor(Enter) remapTo(Enter, girlingBooth)
  dobjFor(Board) remapTo(Enter, girlingBooth)
; 
+ boothScreen: Decoration '(view) (display) (black) (and) (green) monitor/screen/viewscreen' 'view screen'
  "An ordinary view screen on the side of the machine. Black with green letters. Below it sits a keyboard ready for use.  "
;
+ boothControls: Fixture 
  vocabWords = '(main) (strange) (sexchange) (sex) (change) (girl) (tg) (tf) (tgtf) (transformation) (machine) (device) (invention) (maker) (view) screen viewscreen key keys keypad keyboard board button buttons lever levers switch switches panel control*controls' 
  name = 'controls'
  desc = "Though there are buttons, levers and switches all over the outside of the booth of various colors, sizes and shapes, 
          the main control panel is fairly straightforward enough. A simple keyboard and viewscreen. "
  dobjFor(Use){
         verify(){ logicalRank(110,'');
         }
         action(){
               if(gameMain.is_a_girl){
                      "You\'ve got no business messing around with the girl maker controls.
                      You\'ve already turned yourself into a girl and you really don\'t think this
                      thing would turn you back to normal again anyway. Better try something else. ";
                      exit;            
               }
               // we never used the girling booth on others in the game so remming this out - plus it's buggy - Cleo Kraft 6/13/2019
               /*
                *   if(girlingBooth.contents != nil){ local obj = nil; local
                *   oActor = nil; foreach(obj in girlingBooth.contents){
                *   if(obj.ofKind(Actor)) oActor = obj; } if(obj != nil){
                *   if(oActor != nil){ gMessageParams(oActor); local s0 = '';
                *   if(oActor.ofKind(Female)){ s0 = '\^{subj oActor}{the/he} is
                *   already a girl. '; }else{ s0 = 'It\'s probably not a good
                *   idea to turn {subj oActor}{the/he} into a girl without his
                *   permission. '; } say(s0); exit; }else{ gMessageParams(obj);
                *   local s1 = 'You can\'t turn {subj obj}{the/he} into a girl!
                *   {It\'s} not even alive! Before you use the machine better
                *   make sure it\'s empty first. Don\'t want any unexpected
                *   disasters to happen. '; say(s1); exit; } } // if obj is nil
                *   it should skip to hasUsed check below }
                */
               if(formSaver.hasUsed == nil){
                          if(gActor.hasSeen(formSaver)){
                                "You consider setting the controls but decide it\'s best to wait until you figure out how to use that
                                form saver machine you saw. Turning into a girl is one thing but doing so with no way back to normal doesn\'t
                                sound too safe. ";
                          }else{
                                "You mess with the controls a little but then stop and ask yourself <i>what in the world am I doing? I haven\'t even figured out if
                                there\'s even a way to change back to normal again. I can\'t go turning myself into a girl without taking precautions. I\'ve
                                got to find out if there\'s another machine that can normalize me once I do this.</i> ";
                          }
                          exit;
               }else{
                          /* Let's do it! */
                          if(girlingBooth.girlingSet){
                               "You\'ve already set the controls. The automatic timer is ticking. Now you\'ve just got to enter the booth and wait
                               for this machine to do its thing. ";
                          }else{
                               "Unaware of what you\'re really doing, as many of the controls aren\'t even labeled with anything that makes sense,
                               you set the controls for a standard male to female sex change. It seems the preselected girl model for this is blonde but
                               you\'ve got two choices for I.Q., <b>normal</b> or <b>abysmal</b>, whatever that means. Make your selection: ";
                                local iDone = 0;
                                local s0 = '';
                                do{
                                  "<br> Please choose <b><a href=\"normal\">normal</a></b> or <b><a href=\"abysmal\">abysmal</a></b> : ";
                                  s0 = inputManager.getInputLine(nil, nil);
                                  s0 = s0.toLower();
                                  if((s0 == 'a') || 
                                     (s0 == 'normal') ||
                                     (s0 == 'n') ||
                                     (s0 == 'abysmal')
                                  ){ 
                                  iDone++;
                                }else{
                                   "Please choose <b><a href=\"normal\">normal</a></b> or <b><a href=\"abysmal\">abysmal</a></b><br>";
                                } 
                                "\n";
                               }while(iDone==0);
                               "<br>\nA warning pops up that indicates \"form already in use\" but you ignore it. It\'s probably nothing important. ";
                               "<br>\nThe display indicates the form is set. "; 
                               girlingBooth.warningSeen = true;
                               girlingBooth.girlingSet = true;
                               girlingBooth.playerGirlified = nil;
                               if((s0=='n') || (s0=='normal')){
                                      girlingBooth.girlType = 'normal';
                               }else{
                                      girlingBooth.girlType = 'abysmal';
                                      "You grin slightly at what you\'re about to do to yourself. Turn yourself into a girl with an abysmal I.Q. 
                                      You figure if you\'ve got to be a blonde, why not go all the way and be the stereotypical dumb blonde, right? 
                                      You\'re going for the real girl experience. Submersing yourself into the world of women, turning yourself into
                                      the weaker sex. Hopefully the mental changes work and you\'ll actually <i>think</i> like a girl a little bit
                                      more this way. If not, you\'re not worried a bit. You were always great in math but you\'re on vacation and this
                                      little one-night adventure probably won\'t require you to do any math anyway. What\'s the <i>worst</i> that could
                                      happen? You suddenly become afraid of mice? You give the side of the machine a little pat. Now all you\'ve got to
                                      do is enter it and wait. ";
                               }
                          }
               }
         }
  }  
;
/*
 *   OutOfReach conditionally... if we are inside it we can not interact with objects outside of it
 */
+ girlingBooth:  OutOfReach, Heavy, Openable, LockableWithKey, Booth 
  warningSeen = nil
  girlingSet = nil
  playerGirlified = nil
  girlType = 'normal' // 'normal' or 'abysmal' (abysmal is dumb blonde model)
  name = 'girling booth'
  vocabWords = '(girling) (girlifying) (transformation) booth'  
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  initiallyOpen = true
  
  dobjFor(Close){
         verify(){ if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. '); 
                   inherited(); 
         }
  }
  dobjFor(Open){
         verify(){ if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. '); 
                   inherited(); 
         }
  }
  actorTravelingWithin(origin, dest){
        // "origin: <<origin.name>>...<br>dest: <<dest.name>> ";  
        if((dest == girlingBooth) &&
           (girlingBooth.girlingSet == true) &&
           (girlingBooth.playerGirlified == nil)
          ){
                       "You enter the booth. The door slides shut, closing you in the dark and you hear a click. ";
                       inputManager.pauseForMore(true);// better than using just the morePrompt()
                       "<HR ALIGN=CENTER NOSHADE><br>";
                        girlingBooth.makeOpen(nil);
                        girlingBooth.makeLocked(true);
                        "There\'s a brief spark of light and then darkness once more. You feel a sudden wave of energy 
                        flow downward through your body.<.p>";
                        "You can\'t see a thing but you feel yourself changing.
                        You get the sense you\'re melting into the floor - it\'s quite disorienting and it takes 
                        a moment or so to realize you\'re actually shrinking down in size.
                        You hear a hiss as vents open up in the walls and floor and blow air on you.
                        It feels warm but you quickly realize that your entire body has become heated up
                        due to whatever strange process is going on and a few breaths of cold air tells you
                        that the vents are trying frantically to keep your body temperature from getting too hot. 
                        You imagine the energy involved in transforming all the matter in a human body from one
                        form to another must put out a tremendous amout of heat.<.p>";
                        // ** string break
                        "You feel the shaft of your penis pull slowly inward all the way to the base of the 
                        head of your cock. It remains that way for a few moments as your ball sack is sucked in
                        and then your pee hole splits in two as your plumbing is rewired. The original pee hole
                        grows bigger, forming the lips of your new vagina. You don\'t see all this because it\'s 
                        so dark in the booth but you feel and sense everything that is happening.<.p>";
                        // ** string break
                        inputManager.pauseForMore(true);// better than using just the morePrompt()
                        "<HR ALIGN=CENTER NOSHADE><br>";
                        "As all this is happening you feel your chest expand as you grow breasts. The entire 
                        transformation finishes up in twenty seconds though it feels almost like an eternity.
                        Finally it\'s done and the vents shut down and withdraw back into hidden compartments
                        and the booth door slides back open. You\'re nude - the process somehow dissolved all your
                        clothes. You hear a pleasant female voice crackle in over the speaker,\"Male to female conversion complete. Have a nice day.\"<.p>";
                        // ** string break
                        "You\'re a girl now";
                        if(girlingBooth.girlType == 'abysmal'){
                               " and it feels oddly <i>normal</i>. You think it might have something to do
                               with setting the machine to abysmal blonde. You quickly try to think of something
                               complicated, like math, and discover a vast emptiness replacing the skill you had
                               before. Simple addition, subraction and multiplication seems okay but the other stuff
                               like calculus and algebra is hauntingly absent. You try to test your memory further
                               but it\'s like trying to guess at something that isn\'t or wasn\'t ever there. Skills
                               seem to be the only thing really affected but if you had to stay this way you know you
                               could probably just relearn them. Memory of everything else seems to be okay. You remember
                               your girlfriend, your family and even the place you grew up. You remember everything 
                               but you lost entire skill sets. You <i>feel</i> like the dumb blonde you\'ve turned yourself
                               into, ditsy and care free and it feels great";
                        }else{
                               " and you can tell because there\'s an uneasy <i>wrongness</i> about your body. The jiggly
                               breasts, the soft smooth skin all over, the curves... everything\'s different and all out of
                               place. You glance down at the absence of your penis and note how your new part just sits
                               there and does nothing, like an over grown belly button all stretched out, it just <i>sits</i> 
                               there doing nothing. You hop up and down and the only thing that moves afterwards are your
                               breasts, bouncing up and down ridiculously. The constant smell of girl-body permeates your
                               senses. You didn\'t expect to feel so overwhelmingly different. You feel sickeningly good,
                               not good as in you like what\'s happened but good as in goody-goody-two-shoes kind of good. 
                               You don\'t think your mind\'s been tampered with exactly because you can still act how you
                               please but something\'s definately wired up differently in this female mind you\'ve inherited.
                               A certain self consciousness of your actions and the thought out reactions of others, if you will, 
                               that you didn\'t have before. You can\'t quite put your finger on it because it\'s something
                               you think all girls must have. The reason why you\'ve always thought, at the core, all girls
                               are nice, at least except the ones that are bitches. There\'s a sense of kindness in you that
                               you\'ve never felt before and it feels unnatural.<.p>";
                               // ** string break
                               "You think for a moment, testing your memory. Everything's intact but now you\'ve got another problem.
                               You still like girls but if you stay this way you\'ll have to explain to every guy you meet who tries to hit on you that
                               you\'re not into guys and the prospect of <i>that</i> seems like a constant chore laid out before
                               you.<.p>";
                               // ** string break
                               "<i>All right, let\'s do this. I\'ll need to find some clothes that fit. Then maybe I can have a peek
                               at that party. Hope I don\'t get caught. Hope nobody finds out I\'m not me</i>";
                       }
                       ".<.p>";
                       tempPlayerClothes.moveInto(pixyland);
                       tempPlayerClothes.makeWornBy(nil);
                       gameMain.girlType = girlingBooth.girlType;
                       gPlayerChar.girlType = girlingBooth.girlType; // added this line in an attempt to fix the bug, appears to work. - Lashek
                       mePenis.moveIntoForTravel(pixyland);
                       noPenis.moveInto(gPlayerChar);
                       me.is_A_Girl = true;
                       gPlayerChar.is_A_Girl = true; // CromexxHuman class needs this set for clothes handling
                       gameMain.is_a_girl = true; // this is the KEY variable to set for sex changing player
                       girlingBooth.playerGirlified = true;
                       me.pcAge = 18;
                       me.pcHeight = '5\' 3\"';
                       me.pcHair = 'blond';
                       me.pcEyes = 'blue';

                       // create female body parts and give them to the gActor
                       local oStrangeFemLegs = new AdultFemaleLegs();
                       local oStrangeFemArms = new AdultFemaleArms();
                       local oStrangeFemChest = new AdultFemaleBreasts();
                       local oStrangeFemSkin = new AdultFemaleSkin();
                       local oStrangeFemNipples = new AdultFemaleNipples();
                       local oStrangeFemShoulders = new AdultFemaleShoulders();
                       local oStrangeFemTorso = new AdultFemaleTorso();
                       local oStrangeFemBellyButton = new AdultFemaleBellybutton();
                       local oStrangeFemHips = new AdultFemaleHips();
                       local oStrangeFemWaist = new AdultFemaleWaist();
                       local oStrangeFemToes = new AdultFemaleToes();
                       local oStrangeFemMouth = new AdultFemaleMouth();
                       local oStrangeFemNose = new AdultFemaleNose();
                       local oStrangeFemHair = new AdultFemaleBlondeHair();
                       local oStrangeFemEyeLashes = new AdultFemaleEyeLashes();
                       local oStrangeFemEyeBrows = new AdultFemaleEyeBrows();
                       local oStrangeFemBlueEyes = new AdultFemaleBlueEyes();
                       local oStrangeFemEars = new AdultFemaleEars();
                       local oStrangeFemHead = new AdultFemaleHead();
                       local oStrangeFemHands = new AdultFemaleHands();
                       local oStrangeFemFingers = new AdultFemaleFingers();
                       local oStrangeFemFingerNails = new AdultFemaleFingerNails();
                       local oStrangeFemFeet = new AdultFemaleFeet();
                       local oStrangeFemToeNails = new AdultFemaleToeNails();
                       local oStrangeFemVagina = new AdultFemaleVagina();
                       // move them to gActor..
                       oStrangeFemLegs.moveInto(gPlayerChar);
                       oStrangeFemArms.moveInto(gPlayerChar);
                       oStrangeFemChest.moveInto(gPlayerChar);
                       oStrangeFemSkin.moveInto(gPlayerChar);
                       oStrangeFemNipples.moveInto(gPlayerChar);
                       oStrangeFemShoulders.moveInto(gPlayerChar);
                       oStrangeFemTorso.moveInto(gPlayerChar);
                       oStrangeFemBellyButton.moveInto(gPlayerChar);
                       oStrangeFemHips.moveInto(gPlayerChar);
                       oStrangeFemWaist.moveInto(gPlayerChar);
                       oStrangeFemToes.moveInto(gPlayerChar);
                       oStrangeFemMouth.moveInto(gPlayerChar);
                       oStrangeFemNose.moveInto(gPlayerChar);
                       oStrangeFemHair.moveInto(gPlayerChar);
                       oStrangeFemEyeLashes.moveInto(gPlayerChar);
                       oStrangeFemEyeBrows.moveInto(gPlayerChar);
                       oStrangeFemBlueEyes.moveInto(gPlayerChar);
                       oStrangeFemEars.moveInto(gPlayerChar);
                       oStrangeFemHead.moveInto(gPlayerChar);
                       oStrangeFemHands.moveInto(gPlayerChar);
                       oStrangeFemFingers.moveInto(gPlayerChar);
                       oStrangeFemFingerNails.moveInto(gPlayerChar);
                       oStrangeFemFeet.moveInto(gPlayerChar);
                       oStrangeFemToeNails.moveInto(gPlayerChar);
                       oStrangeFemVagina.moveInto(gPlayerChar);   
                       // open and unlock booth
                       girlingBooth.makeOpen(true);
                       girlingBooth.makeLocked(nil);
                       inputManager.pauseForMore(true);// better than using just the morePrompt()
                       "<HR ALIGN=CENTER NOSHADE><br>";
        }
  }
  desc {
     if(gActor.isDirectlyIn(self)){
           if(gameMain.is_a_girl == nil){
                 "Pink fabric is on the walls and floor in this little transformation booth.
                 A strange array up above and just in reach seems to contain the beam device or ray gun or
                 whatever that allegedly turns boys into girls. ";
                 if(formSaver.hasUsed){
                         if(girlingBooth.girlingSet){
                                "Now all you have to do is wait for the machine to transform you. ";
                         }else{
                                "You saved your old male form using the form saver machine, now all you
                                have to do is go outside the booth and use the control panel, then run
                                back in here and wait for your transformation. ";
                         }                    
                 }else{
                       if(!gActor.hasSeen(formSaver)){
                             "You\'re not stupid. You know you\'d better find the normalizer 
                             machine first, wherever it is, before using this thing. Oh sure,
                             you could turn yourself into a girl right now if this thing works
                             but why take a chance? You\'d feel a whole lot safer knowing behforhand
                             that you could undo the transformation. Just standing in here right now
                             kind of gives you the creeps. It would be fun all right but <i>permanently</i> a girl?
                             That\'s a scary proposition and you\'re just not ready for anything like that yet. ";       
                       }else{
                             "You\'re not comfortable standing in here. You saw that form saver back there and
                             know you\'d better use it before fooling around in this girl maker. If you turned
                             into a girl and couldn\'t change back again you don\'t know what in the world you\'d
                             do. ";
                       }
                 }
           }else{
                 "The ceiling is higher than you remember it when you were a boy. 
                 The transformation array mounted up there is out of your reach now,
                 though you could easily reach it before. The walls and floor have soft
                 pink fabric all over but it\'ll do you no good just standing in here gawking 
                 at your surroundings. This is the inside of a girl maker. A machine that clearly
                 has one purpose. That sole purpose of turning you into a girl, which it did 
                 just as its outer lettering advertised. You\'ll not be changing back to normal 
                 in this thing. That\'s for sure. "; 
           }
           if(gPlayerChar.location == girlingBooth){
                "<.p>You can exit the booth by going ";
                if(gameMain.allowHtmlLinks){
                    "<a href=\"out\">out</a>";
                }else{
                    "out";
                }           
                ". ";  
           }
     }else{
           "From outside you can see the booth is lined with smooth, delicate pink fabric. ";
     }
  }
  tooDistantMsg = (gPlayerChar.location == girlingBooth) ? 'You can\'t reach anything from inside the booth. ' : 'You need to go in the booth first to reach {that dobj/him}. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        if(gPlayerChar.location == girlingBooth) return nil;
        if((gPlayerChar.location != girlingBooth) && (obj.location == girlingBooth)) return nil;
        return true;
  }
  iobjFor(TakeFrom)
    {
        verify()
        {
            /* check what we know about the dobj */
            if (gDobj == nil)
            {
                /* 
                 *   We haven't yet resolved the direct object; check the
                 *   tentative direct object list, and count us as
                 *   illogical if none of the possible direct objects are
                 *   in me.  
                 */
                if (gTentativeDobj.indexWhich({x: x.obj_.isIn(self)}) == nil)
                    illogicalAlready(takeFromNotInMessage);
                else if (gTentativeDobj.indexWhich(
                    {x: x.obj_.isDirectlyIn(self)}) != nil)
                    logicalRank(150, 'directly in');
            }
            else if (!gDobj.isIn(self))
            {
                /* 
                 *   the dobj isn't in me, so it's obviously not logical
                 *   to take the dobj out of me 
                 */
                illogicalAlready(takeFromNotInMessage);
            }
            else if (gDobj.isDirectlyIn(self))
            {
                /* 
                 *   it's slightly more likely that they want to remove
                 *   the object from its direct container 
                 */
                logicalRank(150, 'directly in');
            }
        }
        check(){
            if((gDobj.location == girlingBooth) &&
               (gActor.location != girlingBooth)
               ){
                "You can\'t reach it from outside the booth. ";
                exit;
            }
            inherited();
        }
    }
    dobjFor(Use) remapTo(Use, boothControls)
;
++ Unthing '(girling) (transformation) (booth) (machine) control*controls' 'controls'
    'You can\'t see the controls from in here. '
;

formCube: Readable, Thing 
    bulk = 2
    location = pixyland
    vocabWords = '(little) (black) (your) (old) (series) (one) (1) (revision) (0) (zero) (male) (human) (man\'s) (man) (body) (form) (square) M23D478XYA9 data disc/disk/box/block/cube' 
    name = 'form cube'
    desc { "It\'s a little black cube with writing on the side. ";
            if(gameMain.is_a_girl == true){
                   "It\'s got a copy of your old male body stored in there. Better not lose it! ";
            }else{
                   "It\'s got a copy of your current form stored in there somehow. ";
            }
    }    
    disambigName = 'your form cube'
    readDesc = "<i>Form cube<br>\n
                   Serial: M23D478XYA9<br>\n
                   Adult human male<br>\n
                   August 27, 2034<br>\n
                   Series 1, revision 0<br>\n</i>"
;




cellarFloor: RoomPart
  name = 'cellar floor'
  vocabWords = '(cellar) (brown) (dirty) (dusty) dirt floor'
  desc = "The cellar floor is entirely dirt except for around the booth itself which is sitting on
         a large piece of plywood. "
;

noUpUntilGirlified : TravelBarrier 
   canTravelerPass(traveler) { 
        return (gameMain.is_a_girl == true);
   }
   explainTravelBarrier(traveler) { "Not like this. If you get caught you don\'t want anyone recognizing who you really are. Better
                                    try disguising yourself or something first. ";
   } 
; 

noUpWithoutOutfit: TravelBarrier
   canTravelerPass(traveler) { 
        local iPass = 0;
        if(strangeFemPanties.isWornBy(gPlayerChar)) iPass++;
        if(strangeFemBra.isWornBy(gPlayerChar)) iPass++;
        if(strangeFemDress.isWornBy(gPlayerChar)) iPass++;
        if(strangeFemShoes.isWornBy(gPlayerChar)) iPass++;
        return (iPass == 4);
   }
   explainTravelBarrier(traveler) { "You need to get properly dressed before going upstairs. If someone should see you, you don\'t want
                                    to make a bad first impression. You don\'t want anyone becomming suspicious of you either. ";
   } 
;

noUpWithoutHairBrushed: TravelBarrier
   canTravelerPass(traveler) { 
        return (dressingRoomHairbrush.hasUsed == true);
   }
   explainTravelBarrier(traveler) { "You haven\'t even brushed your hair. You need to look presentable. If someone catches you in the
                                    mansion upstairs you don\'t want them suspecting you\'re a sloppy male intruder who\'s used the
                                    girl maker and decided on blundering through the house with wild hair sticking up all over the place 
                                    like the bride of Frankenstein or something. ";
   }
;

noUpWithoutMakeUpOn: TravelBarrier
   canTravelerPass(traveler) { 
        return (dressingRoomMakeup.hasUsed == true);
   }
   explainTravelBarrier(traveler) { "You haven\'t used any makeup. You need to look as presentable as possible if you go upstairs and want to
                                    pull off this disguise. ";
   }
;

noUpIfHiding: TravelBarrier
   canTravelerPass(traveler) { 
        return (tellOnYouAgent.isActive != true);
   }
   explainTravelBarrier(traveler) { "You don\'t want to go back upstairs. You\'d rather hide down here now that the Master\'s been alerted. 
                                    In fact, better find a good hiding place quick before he catches you. ";
   }
;

formSaverRoom: ClackRoom 
   roomParts = [cellarFloor, defaultNorthWall, defaultSouthWall, defaultEastWall, defaultWestWall]
   name = 'cellar'
   desc { "There are crumbly stone walls in this old dirt floor cellar. 
          In the middle of the room is a white metal booth. It\'s circular and
          has a control panel on it and a little slot on the side. The booth
          has writing on it inidcating it\'s a form saver. ";
          if(!gPlayerChar.hasSeen(formCube)){
            "This machine looks like it could come in handy. Maybe you should use
            it before experimenting with any others. ";   
          }
          if(gPlayerChar.location == formSaverBooth){
            "You can exit the form saver by going ";
             if(gameMain.allowHtmlLinks){
                "<a href=\"out\">out</a>";
             }else{
                "out"; 
             }           
             ". ";
          }else{
            if(gameMain.allowHtmlLinks){
                "An open doorway leads to the main lab to the <a href=\"south\">south</a> while another one
                leads <a href=\"north\">north</a> into a dressing room and an old wooden staircase 
                leads <a href=\"up\">up</a> into a pantry. You can enter the form saver by going <a href=\"in\">in</a>. ";
            }else{
                "An open doorway leads to the main lab to the south while another one
                leads north into a dressing room and and old wooden staircase
                leads up into a pantry. You can enter the form saver by going in. ";
            }           
          }
   }
   up = cellarStairsUp
   south = girlifyingLab
   north = basementDressingRoom
;
+ formSaverPantry: Decoration '(little) (empty) (kitchen) (mansion) pantry' 'pantry'
  "From here you can\'t see much detail but it appears the stairs lead up into a little pantry. "
;
+ cellarStairsUp :  StairwayUp  
  destination = mansionPantry
  otherSide = cellarStairsDown
  vocabWords = '(old) (wood) (wooden) (stair) case/staircase/stairs' 
  name = 'stairs'
  desc = "The old wooden staircase leads up into a pantry above. "
  travelBarrier = [noUpIfHiding,noUpUntilGirlified,noUpWithoutOutfit,noUpWithoutHairBrushed,noUpWithoutMakeUpOn]
  noteTraversal(traveler) {  
    if(!climbed) { 
      "You climb the stairs and arrive in a little pantry. ";
      climbed = true; 
    } 
  } 
  climbed = nil 
; 
/*
 *   OutOfReach conditionally... if we are inside it we can not interact with objects outside of it
 */
+ formSaverBooth:  OutOfReach, Heavy, LockableWithKey, Readable, Occluder, OpenableContainer, Booth
  name = 'form saver booth'
  vocabWords = '(human) (body) (form) (saver) scanner booth'
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  initiallyOpen = true
  readDesc = "<i>Form Saver</i>"
  actorTravelingWithin(origin, dest){
        if((dest == formSaverBooth) &&
           (formSaver.controlsSet == true) &&
           (formSaver.hasUsed == nil)
          ){
              "You enter the booth. The door slides shut, closing you in the dark and you hear a click. ";
              inputManager.pauseForMore(true);// better than using just the morePrompt()
              "<HR ALIGN=CENTER NOSHADE><br>";
              "There\'s a brief spark of light and then darkness once more. You feel a sudden wave of energy 
              flow downward through your body and the machine shuts off again.<.p>
              You think: <i>that was certainly quick!</i><.p>The machine shuts off again
              and the door slides open. A moment later you hear a rattle and clunk somewhere
              outside. You hear a pleasant female voice say,\"Adult human male body successfully scanned. 
              Please step outside and withdraw form cube from the receptical. Thank you.\" ";
              formSaver.hasUsed = true;
              formCube.moveIntoForTravel(formSaverReceptical);
              formSaverBooth.makeOpen(true);
              formSaverBooth.makeLocked(nil);
          }
  }
  dobjFor(Close)
    {
        verify()
        {
            if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. ');

            /* it makes no sense to close something that's already closed */
            if (!isOpen)
                illogicalAlready(&alreadyClosedMsg);
        }
        action()
        {
            /* make it closed */
            makeOpen(nil);

            /* show the default report */
            defaultReport(&okayCloseMsg);
        }
    }
  dobjFor(Open){
         verify(){ if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. '); 
                   inherited(); 
         }
         check(){ inherited(); }
         action(){ inherited(); }         
  }
  desc {
     if(gActor.isDirectlyIn(self)){
           if(gActor.ofKind(Male)){
                 "The inside of the booth has plain white metal walls. 
                 A strange array up above and just in reach seems to contain the beam device or ray gun or
                 whatever that allegedly saves copies of peoples bodies. ";
                 if(formSaver.hasUsed){
                         "You\'ve arleady made a copy of your original self so there\'s really no need for you to be in here anymore. ";
                 }
           }else{
                 "The ceiling is higher than you remember it when you were a boy. 
                 The form saver array mounted up there is out of your reach now,
                 though you could easily reach it before. The ceiling, walls and floor 
                 are made up of plain white metal. You realize you have no need to be
                 in here except perhaps to reflect upon the past a little. You\'ve saved
                 your old male form using this machine";
                 if(gActor.hasSeen(bodyRestorer)){
                        " now you just have to use the body restorer machine when ever you\'re
                        ready to turn back to normal again";
                 }else{
                        " but you still don\'t know where the normalizer machine is. At least
                        you have the peace of mind that you\'ve made a backup of yourself before
                        turning into a girl";
                 }
                ". <.p>You can exit the booth by going ";
                if(gameMain.allowHtmlLinks){
                    "<a href=\"out\">out</a>";
                }else{
                    "out";
                }           
                ". ";  
           }
     }else{
           "From outside you can see the booth has white metal walls. There is a control panel on it and on the side there\'s a little receptical. 
            There\'s writing in green letters above the door that indicate this is a form saver. ";
     }
  }
  tooDistantMsg = (gPlayerChar.location == formSaverBooth) ? 'You can\'t reach anything from inside the booth. ' : 'You need to go in the booth first to reach {that dobj/him}. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        if(gPlayerChar.location == formSaverBooth) return nil;
        if((gPlayerChar.location != formSaverBooth) && (obj.location == formSaverBooth)) return nil;
        if((gPlayerChar.location == formSaverBooth) && (obj == formSaverReceptical)) return nil;
        return true;
  }
  iobjFor(TakeFrom)
    {
        verify()
        {
            /* check what we know about the dobj */
            if (gDobj == nil)
            {
                /* 
                 *   We haven't yet resolved the direct object; check the
                 *   tentative direct object list, and count us as
                 *   illogical if none of the possible direct objects are
                 *   in me.  
                 */
                if (gTentativeDobj.indexWhich({x: x.obj_.isIn(self)}) == nil)
                    illogicalAlready(takeFromNotInMessage);
                else if (gTentativeDobj.indexWhich(
                    {x: x.obj_.isDirectlyIn(self)}) != nil)
                    logicalRank(150, 'directly in');
            }
            else if (!gDobj.isIn(self))
            {
                /* 
                 *   the dobj isn't in me, so it's obviously not logical
                 *   to take the dobj out of me 
                 */
                illogicalAlready(takeFromNotInMessage);
            }
            else if (gDobj.isDirectlyIn(self))
            {
                /* 
                 *   it's slightly more likely that they want to remove
                 *   the object from its direct container 
                 */
                logicalRank(150, 'directly in');
            }
        }
        check(){
            if((gDobj.location == formSaverBooth) &&
               (gActor.location != formSaverBooth)
               ){
                "You can\'t reach it from outside the booth. ";
                exit;
            }
            inherited();
        }
    }
    dobjFor(Use) remapTo(Use, formSaverControls)
    // from the Occluder class... - remove if you remove Occluder from this object
    occludeObj(obj, sense, pov){
        /* by default, simply ask the object what it thinks */
        // return obj.isOccludedBy(self, sense, pov);// the default
        // we override the default for special occluded objects
        if(obj != nil){
               if(pov.isIn(formSaverBooth)){
                    // if point of view is on roof then the desk is occluded (blocked) from view
                    if(obj == formSaverReceptical) return true; 
                    if((obj == formCube) && (formCube.isIn(formSaverReceptical))) return true;
                    if(obj == formSaverControls) return true;
                    if((obj.isIn(formSaverRoom)) && (formSaverBooth.isOpen == nil)) return true;
               }
               if(pov.isIn(formSaverRoom)){
                    if((obj.isIn(formSaverBooth)) && (formSaverBooth.isOpen != true) ) return true;
               } 
                         
        }
        // Note: Thing.t returns nil by default on a call to occludeObj(obj, sense, pov)
        // ...however we will return the default at this point for the Occluder class, which is to ask the object what to do
        return obj.isOccludedBy(self, sense, pov);// the default
    }
;
++ Unthing '(form) (saver) (booth) (machine) control*controls' 'controls'
    'You can\'t see the controls from in here. '
;

plywoodBase: Fixture, Surface '(wooden) wood plywood base' 'plywood'
    "It looks like ordinary plywood. The booth is on top of it and it appears the plywood is there to help keep the dirt out. "
  location = formSaverRoom
;


formSaver: Fixture, Readable, Heavy '(strange) (body) (form) saver recorder device/machine/invention' 'form saver'
  "A form saver. "   
  location = formSaverRoom
  
  controlsSet = nil
  hasUsed = nil
;
+ formSaverReceptical : RestrictedContainer, Component '(form) (saver) (recorder) (device) (machine) (invention) (booth) slot/hole/aperature/receptical' 'receptical'
  "A little slot located on the side of the machine. "
   validContents = [formCube] 
; 
+ formSaverControls: Fixture 
  vocabWords = '(main) (strange) (form) (saver) (machine) (device) (invention) (view) key keys keypad keyboard board button buttons lever levers switch switches panel screen viewscreen control*controls' 
  name = 'controls'
  desc = "Though there are buttons, levers and switches all over the outside of the booth of various colors, sizes and shapes, 
          the main control panel is fairly straightforward enough. A simple keyboard and viewscreen. "
  dobjFor(Use){
         verify(){ logicalRank(110,'');
         }
         action(){
               if(gameMain.is_a_girl){
                      /*
                       *  To DO: 
                       *       1. allow the player to save an adult woman form cube to mess around with later (might introduce bugs or extra stuff to code)
                       */ 
                      "There\'s no reason to mess with the controls. You already saved your original form 
                      and you can just use the girl maker to turn back into your current form whenever you want. ";
                      exit;            
               }
               // We never use the form saver on anyone but the player in this game so remming this out (plus it's buggy) - Cleo Kraft 6/13/2019
               /*
                *   if(formSaverBooth.contents != nil){ local obj = nil; local
                *   oActor = nil; foreach(obj in formSaverBooth.contents){
                *   if(obj.ofKind(Actor)) oActor = obj; } if(obj != nil){
                *   if((oActor != nil) && (oActor != formSaverControls)){
                *   gMessageParams(oActor); local s0 = 'You don\'t need to form
                *   save \^{subj oActor}{the/he}. '; say(s0); exit; }else{
                *   gMessageParams(obj); local s1 = 'You can\'t form save {subj
                *   obj}{the/he}. '; say(s1); exit; } } }
                */
               if(formSaver.hasUsed == nil){
                          /* Let's do it! */
                          if(formSaver.controlsSet != nil){
                               "You\'ve already set the controls. The automatic timer is ticking. Now you\'ve just got to enter the booth and wait
                               for this machine to do its thing. ";
                          }else{
                               "The controls on this machine are rather simple. You set them to record a standard human body. The timer\'s set. Now it\'s
                               time for you to enter the booth to record your form. ";
                               formSaver.controlsSet =  true;
                          }
               }else{
                           "You\'ve already stored your original form once. You don\'t need to do it again. ";
                           exit;
               }
         }
  }  
;

/*
 *   To DO: 
 *      1. add in wall objects to accurately show the wallpapered walls
 *      2. add in decoration objects for the cupids & "light pink background", doorway, etc. 
 */
basementDressingRoom: ClackRoom, ClothingRemovalRoom 
   name = 'dressing room'
   desc { 

          "Female clothes abound on the wooden racks in here. 
           There must be well over one hundred different kinds of womens shoes
           lined up neatly along the wallpapered walls. The wallpaper is pink hearts
           with little dancing cupids on a light pink background. The exit is to the ";
           if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
           }else{
                "south"; 
           }           
           " through an open doorway leading back to the cellar.<.p>";
           if(gameMain.is_a_girl){
              if(!gPlayerChar.hasSeen(strangeFemPanties)){
                          strangeFemPanties.discover();
                          strangeFemBra.discover();
                          strangeFemDress.discover();
                          strangeFemShoes.discover();
                          "You notice some pink satin panties lying on the floor that catch your eye,
                          beside them are some nice black leather pumps and beside those is a pink silk bra and on the wooden rack above is hanging a black dress. 
                          Though the selection of clothes in here is pretty large these seem to be a nice start. 
                          Maybe you\'d better pick them up and <a href=\"wear outfit\">wear</a> them to see if they will fit. There is also a <a href=\"brush hair\">hair brush</a> and 
                          some <a href=\"use makeup\">makeup</a> on the dressing table.<.p>";
              }           
          }
   }
   south = formSaverRoom  
;
+ Unthing '(twisty) (little) passage/passages' 'passage'
  'You see no passage here though there is a way to the south into the cellar. '
;
+ Decoration '(assorted) (assortment) (various) (varieties) (of) (girl) (girl\'s) (women\'s) (women) clothes' 'assorted women\'s clothes'
  "There are too many to choose from. "
;
+ Decoration '(wood) (wooden) (little) (clothes) rack*racks' 'clothes racks'
  "Some wooden clothes racks in the dressing room. "
;
+ assortedShoes: Decoration '(assorted) (assortment) (of) (girl) (girl\'s) (women) (women\'s) (high) (heeled) heels shoe pump/pumps/sandal/sandals/flats/shoes' 'assorted shoes'
  "There is a fine selection of women\'s shoes here ranging from flats and sandals to high heels. 
  <<(gameMain.is_a_girl == nil) ? 'None of them really interest you too much as you\'re not a girl. ' : ''>> " 
;
// The panties are hidden until the player is a girl and we reveal them
+ strangeFemPanties: Hidden, AdvancedCromexxClothing
  isWet = nil // you can get them wet in the swimming pool
  name = 'pink satin panties'  
  isPlural = true
  disambigName = 'Lexilah\'s brand pink satin panties'
  girl_only = true
  teen_only = true
 
  // these are for 1st person only. there are 3rd person versions too but we don't normally need to worry about that.
  specialWearDesc = "You slip on the panties and feel how nice and comfy they are. "
  specialRemoveDesc = "You pull the panties down to your ankles and step out of 
                     them one foot then the other. "  
  vocabWords = '(Lexilah) (Lexilah\'s) (brand) (pink) (pair) (of) (satin) panties/Arbinkers/panty/underwear/underpants/underdrawers'
  desc = "Ordinary satin panties for a girl. They have a small inner crotch lining sewn in made of cotton. <<strangeFemPanties.isWet ? 'Your panties are wet from your swim in the pool. ' : ''>>"
  wornBy = nil
  //  location = tiffanyMeadows
  clothLevel = 3 // panties
  collectiveGroup = strangeFemClothes
;
// the bra is hidden until the strange machine produced it
+ strangeFemBra: Hidden, AdvancedCromexxClothing
  name = 'pink silk bra'  
  isPlural = nil
  disambigName = 'Lexilah\'s brand pink silk bra'
  girl_only = true
  teen_only = true
  // these are for 1st person only. there are 3rd person versions too but we don't normally need to worry about that.
  specialWearDesc = "You pull on the pink silk bra and fasten the straps in the back. It
                     nestles snugly against your breasts and pushes them up together, making 
                     them look pretty and pert. "
  specialRemoveDesc = "You unfasten the straps in the back of the pink silk bra and remove 
                     it from your breasts and slip your arms out of the hoops. "  
  vocabWords = '(Lexilah) (Lexilah\'s) (brand) (pink) (satin) bra/brassiere/Zellas/supporter'
  desc = "Ordinary silk bra for a girl. It\'s pink. "
  wornBy = nil
  //  location = tiffanyMeadows
  clothLevel = 5 // bra
  collectiveGroup = strangeFemClothes
  sayBeforeTravel { 
         say(rand(nil,nil,nil,nil,
            'Your bra strap slips off your shoulder as you walk. 
             You stop for a moment to readjust it and continue on your way.<.p> ',
            nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,
            nil,nil,nil,nil,nil,nil,nil,nil,nil,nil
         ));         
  }  
;
+ strangeFemDress: Hidden, AdvancedCromexxClothing
  name = 'black cotton dress'
  disambigName = 'Lexilah\'s brand black cotton dress'
  girl_only = true
  teen_only = true
  specialWearDesc = "You slip into the black cotton dress, putting your arms through the little sleeves and
                    hiking the dress up about your waist. You turn to one side and reach around
                    and zip up the back and fasten the tiny clasp above it. "
  specialRemoveDesc = "You reach back and undo the clasp, then unzip the back of the dress and let
                    it fall to the floor briefly before picking it back up again. "
  vocabWords = '(Lexilah) (Lexilah\'s) (brand) (black) (cotton) dress'
  desc = "A black cotton short sleeved dress with a zipper in the back. "
  clothLevel = 12 // dress
  collectiveGroup = strangeFemClothes
  sayBeforeTravel {
           say(rand(nil,nil,'You feel your dress swish lightly against your thighs as you walk.<.p>',
                    nil,nil,nil,nil,nil,nil,nil,nil,nil,
                    nil,nil,nil,nil,nil,nil,nil,nil,nil,
                    nil,nil,nil,nil,nil,nil,nil,nil,nil
              ));

  }    
;
+ strangeFemShoes: Hidden, ClackShoes
  name = 'black pumps'
  disambigName = 'Lexilah\'s brand black pumps'
  isPlural = true
  girl_only = true
  teen_only = true
  specialWearDesc = "You slip on the black shiny pumps, one foot then the other. A perfect fit.
                    You\'re glad you chose these ones, they\'re really nice. "
  specialRemoveDesc = "You reach down with your thumb and pry the pumps off your heels, then flick your
                      feet, one after the other to remove the pumps. You gather them up in your arms until you
                      decide what to do with them. Better put them somewhere safe if you\'re done with them for
                      now. You never know if you might need them later. "
  vocabWords = '(pretty) (Lexilah) (Lexilah\'s) (brand) (shiny) (black) (leather) (two) (inch) (tall) (high) (heeled) heels/shoe/shoes/pump*pumps'
  desc = "Some black leather pumps with two inch heels. Real pretty ones. "
  clothLevel = 1 // shoes
  collectiveGroup = strangeFemClothes
;
+ dressingTable: Heavy, Surface '(pink) (painted) (wood) (wooden) (dressing) desk table' 'dressing table'
  "A wooden dressing table painted pink. There\'s a hairbrush on the table and all kinds of makeup arranged neatly on it and it has
  a<<(dressingTableDrawer.isOpen) ? 'n open drawer' : ' drawer which is closed'>>. "
  dobjFor(Open) remapTo(Open,dressingTableDrawer)
  dobjFor(Close) remapTo(Close,dressingTableDrawer)
;
++ dressingTableMirror: Component '(shiny) (reflective) (pink) (wood) (wooden) (framed) (rectangular) (desk) (dressing) (table) glass mirror' 'mirror'
  "A pink wooden framed rectangular mirror attached to the dressing table. "
    disambigName = 'dressing table mirror'
    dobjFor(LookIn) remapTo(Examine,dressingTableReflection)
;
+++ dressingTableReflection: Component '(your) (my) (shiny) (reflective) (dressing) (table) (glass) (mirror) (beautiful) (pretty) (young) (blonde) (blond) (woman) (woman\'s) (girl) (girl\'s) reflection' 'reflection'
    desc {
        if(gameMain.is_a_girl){
            "You see a blonde girl in your reflection. ";
        }else{
            "You see your normal male self in your reflection. ";
        }
        local myList = dressingTableReflection.getClothingWornList();
        if(myList != nil){
            local sWho = 'man';
            if(gameMain.is_a_girl){
                sWho = 'girl'; 
            }
            local s0 = 'You see the ' + sWho + ' in your reflection wearing ';                   
            say(s0);
            local myWearingLister = new WearingLister();// see List.t 
            /* 
             *  WearingLister.showListAll(list,options,indent) where:
             *
             *  list = the List object you are passing to the routine for listing
             *  options = ListContents (comma seperated), ListTall (semicolon seperated)
             *  indent = only for ListLong (long lists), if 0 then no indentation
             */               
            myWearingLister.showListAll(myList,ListContents,0);
            ". ";
        }
        
    }
    
    getClothingWornList(){
              local vList = new List();
              if(gPlayerChar.contents == nil) return nil;
              foreach(local obj in gPlayerChar.contents){
                    if(obj.isWornBy(gPlayerChar))
                       vList += obj;
              }
              return vList;
   }
;
/* Component class from objects.t - just means the object is non-portable and belongs to another.
 * Openable class from objects.t - note: do NOT set "isOpen = nil"... that overwrites 
 *                                       some "isOpen" code if you do. Also the default 
 *                                       "isInitiallyOpen" setting is nil (i.e. closed).
 */ 
++ dressingTableDrawer: Openable, RestrictedContainer, Component  '(wood) (wooden) (dressing) (table) drawer' 'drawer'
   "An ordinary wooden dressing table drawer. "
   validContents=[blackLeatherPurse]
   /* Here we override the "cannotPutInMsg" function 
    * to say something than the default "&cannotPutInRestrictedMsg" library message.
    */
   cannotPutInMsg(obj) { return 'You shouldn\'t go putting things in there that don\'t belong. 
                                 You\'re not the owner of this place and leaving all kinds of subtle little clues behind isn\'t
                                 exactly a wise thing to do. ';
                       }
;
+++ blackLeatherPurse: Openable, Wearable, RestrictedContainer '(black) (leather) (hand) bag/handbag/purse' 'black leather purse'
  "It\'s a black leather purse with long thin straps. "
   dobjFor(Wear){
          preCond=[touchObj,objHeld]
          verify(){
                    if(gameMain.is_a_girl != true){
                        illogicalNow('Wearing purses is not for boys. ');
                    }
                    inherited();
          }
          check(){ inherited(); }
          action(){ inherited(); }
   }
   validContents = [formCube]
;

// moved dressingRoomHairBrush to file: crom_body.t


dressingRoomHairbrush: Decoration '(brown)  (used) (old) (communal) (community) (wide) (woman\'s) (girl\'s) (hair) brush/hairbrush' 'hairbrush'
   "A brown hairbrush. "
   location = dressingTable
   hasUsed = nil
  dobjFor(Take){
    verify(){ if(gameMain.is_a_girl == nil){
                  illogicalNow('You\'re not a girl so you don\'t need it. ');
              }else{
                  illogical('You don\'t need to take the hairbrush with you though you can <a href=\"use hairbrush\">use</a> it if you feel the need.
                            It\'s old and used. Probably lots of girls before you used it. The idea here seems to be to leave it so others going 
                            through the girling machine can use it too. ');
              }
            }
  }
  dobjFor(Use){
    verify(){ if(gameMain.is_a_girl == nil){
                  illogicalNow('You don\'t have long hair and you\'re not a girl. You don\'t need to use it. ');
              }else{
                  logicalRank(110,'likely');
              }
    }
    check(){
             if(dressingRoomHairbrush.hasUsed == true){
                 "You\'ve already done your hair. You don\'t need to fuss with it anymore right now. ";
                 exit;
             }
    }
    action(){
             dressingRoomHairbrush.hasUsed = true;
             "You use the hairbrush, brushing your long blonde hair. The tangles come right out without much fuss and though
             you really don\'t know what you\'re doing and never brushed hair this long on your head before you eventually
             get it to a point where it looks at least presentable. You set the brush back down on the dressing table. You won\'t
             need it anymore for now. ";
    }
  }
  iobjFor(BrushWith){ 
         verify(){ logicalRank(110,'likely'); }
  } 
;

dressingRoomMakeup: Decoration '(used) (old) (communal) (community) (wide) (assortment) (assorted) (dressing) (room) (table) (eye) (women\'s) (girl\'s) (face) makeup lipstick shadow liner blush base' 'makeup'
  "Assorted makeup ranging from various colors of lipstick to eye liner, blush, and base. "
  location = dressingTable
  hasUsed = nil
  dobjFor(Take){
    verify(){ if(gameMain.is_a_girl == nil){
                  illogicalNow('You\'re not a girl so you don\'t need that stuff. ');
              }else{
                  illogical('You don\'t need to take the makeup with you. It\'s old and used looking stuff. Probably lots of girls before
                            you used it. The idea here seems to be to leave it so others going through the girling machine can use it too. ');
              }
            }
  }
  dobjFor(Wear) remapTo(Use,dressingRoomMakeup)
  dobjFor(Use){
    verify(){ if(gameMain.is_a_girl == nil){
                  illogicalNow('You\'re not a girl. You\'d look pretty silly with makeup on. ');
              }else{
                  logicalRank(110,'likely');
              }
    }
    check(){
             if(dressingRoomMakeup.hasUsed == true){
                 "You\'ve got enough makeup on already. You don\'t need any more right now. ";
                 exit;
             }
    }
    action(){
             dressingRoomMakeup.hasUsed = true;
             "You use the makeup, applying a little here and there. You do your eyes, put on some ruby red lipstick. 
             It takes a few tries to get it right since you\'ve never done this before and you avoid over doing it because
             you\'re not sure how much to use. So you dabble on some makeup here and there, use some eye shadow and do your lips
             until you seem satisfied that you look pretty. ";
    }
  }
; 


/*
 * Note: don't set a location or owner for this manually.
 * The strange machine (above in the code) will set an owner,
 * and "ClothingOutfit" objects should never have a location
 * value. This is to keep them global reference points seperate
 * from the actual items in the myCromOutfitList, which should
 * each have locations set.
 */
strangeFemClothes: ClothingOutfit 
  vocabWords = '(Lexilah\'s) (brand) (girls) (girl\'s) clothes/outfit' 
  name = 'Lexilah\'s brand girls clothes'
  desc = "These are the girls clothes that you found in the changing room. "
  owner = nil
  myCromOutfitList = [strangeFemPanties,strangeFemBra,strangeFemDress,strangeFemShoes]
;

mansionPantry: ClackRoom
  name = 'pantry'
  desc {
         if(!gPlayerChar.hasSeen(self)){
                if( 
                   (formCube.isHeldBy(gPlayerChar)) &&
                   (formCube.location != blackLeatherPurse)
                  ){
                        "You turn the little form cube over in your hands and are comforted by
                        the thought of having it with you. ";
                  }else if(
                           (formCube.location == blackLeatherPurse) &&
                           (blackLeatherPurse.isWornBy(gPlayerChar))
                          ){
                        "You pat the side of your purse, comforted in the thought of having
                        your form cube with you and tucked safely away in there. ";
                  }else if(
                           (formCube.location == blackLeatherPurse) &&
                           (blackLeatherPurse.isHeldBy(gPlayerChar))
                          ){
                        "You pat the side of your purse, comforted in the thought of having
                        your form cube with you and tucked safely away in there. As an afterthought
                        you sling your purse over your slender shoulder. ";
                        blackLeatherPurse.makeWornBy(gPlayerChar);
                  }
         }
         if(gameMain.allowHtmlLinks){
            "The shelves in this pantry are completely devoid of supplies and are over run with cobwebs.
            Some stairs lead <a href=\"down\">down</a> into the cellar from here or there is an open doorway leading into the
            kitchen to the <a href=\"east\">east</a>. ";
         }else{
            "The shelves in this pantry are completely devoid of supplies and are over run with cobwebs.
            Some stairs lead down into the cellar from here or there is an open doorway leading into the
            kitchen to the east. ";
         }           
  }
  down = cellarStairsDown
  east = kitchen
;
+ pantryShelves: Decoration '(spooky) (scary) (cobweb) (web) (coated) (white) (painted) (wooden) (wood) (pantry) shelf/shelves/shelfs' 'pantry shelves' 
  "The shelves are made of wood and painted white and are covered in cobwebs. "
  isPlural = true
;
+ pantryCobwebs: Decoration '(white) (spider) (cob) web/webs/cobweb/cobwebs' 'cobwebs'
  "Spooky white cobwebs. They\'re everywhere in here. "
  isPlural = true
;
+ cellarStairsDown :  StairwayDown  
  destination = formSaverRoom
  otherSide = cellarStairsUp
  vocabWords = '(old) (wood) (wooden) (stair) case/staircase/stairs' 
  name = 'stairs'
  desc = "The old wooden staircase leads down into the cellar. "
  //  travelBarrier = [noUpUntilGirlified,noUpWithoutOutfit,noUpWithoutHairBrushed,noUpWithoutMakeUpOn]
  noteTraversal(traveler) {  
    if(!climbed) { 
      "You climb the stairs and arrive in the cellar. ";
      climbed = true; 
    } 
  } 
  climbed = nil 
; 

kitchen: ClackRoom 
  name = 'kitchen'
  desc {
          "This room is strangely absent of a kitchen table and chairs. It seems like more of a food preperation room than
          anything else. A stove sits in one corner beside a large white refrigerator. Some wooden cupboards over a counter top line the north
          wall. ";
          "<.p>There is a way ";
          if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
          }else{
                "east"; 
          }
          " to a dining room or "; 
          if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
          }else{
                "west"; 
          }
          " into the pantry. ";
          if(!gPlayerChar.hasSeen(self)){
                 "<.p>An attractive blonde woman in a black dress spots you coming out of the pantry and says,\"I heard you use the
                 machines. The Master doesn\'t allow anyone to use the machines without permission. You could be in a lot of trouble
                 you know.\"<.p>";
                 local iAsk = nil;
                 if(formCube.isHeldBy(gPlayerChar)){
                       "She spots the form cube in your hand and adds,\"That must be very valuable to you. I\'ll tell you what I\'ll do.
                       I\'ll make your intrusion on the property and your little transformation our little secret if you give me that. 
                       Otherwise I\'ll have no choice but to go an alert the Master and he can be very unforgiving.\" ";
                       iAsk = true;
                 }else if(
                           (formCube.location == blackLeatherPurse) &&
                           ( (blackLeatherPurse.isHeldBy(gPlayerChar)) || 
                             (blackLeatherPurse.isWornBy(gPlayerChar)) 
                           )
                         ){
                       "Before you can stop her she quickly rummages through your purse and finds your form cube. She holds it up before your
                       eyes. You grab it back and toss it back in your purse and say,\"That\'s not yours.\"<.p>She says,\"You were trying to 
                       hide it, weren\'t you? Tell you what, if you let me keep it I\'ll keep your questionable activities thus far a secret. 
                       It\'ll just be between you and me. If you refuse then I\'ll have no choice but to alert the Master and he can be very
                       unforgiving.\" ";
                       iAsk = true;
                 }
                 if(iAsk == true){
                                "<b>Do you agree to the woman\'s proposal and let her have your form cube? (y/n)</b> ";
                                local iDone = 0;
                                local s0 = '';
                                do{
                                  "<br> >";
                                  s0 = inputManager.getInputLine(nil, nil);
                                  s0 = s0.toLower();
                                  if((s0 == 'y') || 
                                     (s0 == 'yes') ||
                                     (s0 == 'n') ||
                                     (s0 == 'no')
                                  ){ 
                                  iDone++;
                                }else{
                                   "Please select <b>yes</b> or <b>no</b><br>";
                                } 
                                "\n";
                               }while(iDone==0);
                               if((s0=='n') || (s0=='no')){
                                      if(gPlayerChar.girlType == 'abysmal'){
                                         formCube.isListed = nil;
                                         formCube.moveIntoForTravel(pixyland);
                                         "<br>You try to say no but something in you just doesn\'t feel right about it.
                                         You\'re having a so <i>totally</i> blonde moment, shrug, smile, cock your head to one side
                                         and say,\"O-kee-doh-kee, nice lady!\" and hand the form cube over to her. It feels so 
                                         <i>totally</i> righteous. It\'s, like, your boy form all stored up in there or something 
                                         but you don\'t care. If she could use it she could have it and if she could have it she could
                                         keep it. 
                                         <br>\"Wow....\" she says taking the cube from you. \"That... was... amazingly easy. Thanks? I think?\"
                                         <br>\"I\'m a girl,\" you announce feeling confident and a bit over assured. 
                                         <br>She stares at you for a long moment and asks,\"Are you feeling all right?\"
                                         <br>You shake your head enthusiastically yes and say,\"I could use a man\'s attention but otherwise I feel
                                         totally presto ta-dah. Like, tie a ribbon on my head and call me a present. I feel so horny if I don\'t get
                                         a man soon just kill me, all right?\" 
                                         <br>You can\'t believe the words coming out of your mouth. Inside you\'re not thinking any of that but
                                         the words are slipping out anyway. It\'s torture. You know you still are attracted to women but your
                                         mouth seems to have a mind of its own and is saying things you can\'t believe. It must be that darn
                                         \"abysmal\" setting you used when you transformed yourself into a girl. You\'re abysmally blonde. 
                                         For a few moments you have absolutely no control over your body. Your hands are gesturing girlishly out
                                         of control, your hips swaying this way and that as you talk and your mouth is uttering the most ridiculous
                                         lines of vocabulary you think you\'ve ever heard. \"...and so I was like, no freaking <i>way</i> and he was
                                         like, yeah way, and I was like, no freaking <i>way</i> and he was nodding his head like this and saying,
                                         yeah way. That\'s when I broke a nail and had to go to the girl\'s bathroom to fix it. Then there was, like,
                                         this big hunking explosion outside and someone said they flushed a cherry bomb in, like, the boy\'s bathroom
                                         and I was like, no freaking way.\"<br>";
                                         inputManager.pauseForMore(true);// better than using just the morePrompt()
                                         "<HR ALIGN=CENTER NOSHADE><br>The woman stares at you for awhile and then says,\"You used the abysmal setting
                                         on that machine didn\'t you? You did. I can tell. Boy oh boy, what an idiot. I should do us all a favor and
                                         put you out of your misery. On second thought, I\'ve changed my mind about you. I\'m going to tell Master
                                         what you did and then <i>he</i> can decide what to do with you. Don\'t move, honey. I\'ll be right back.\"<.p>
                                         She runs out of the kitchen. ";
                                         tellOnYouAgent.startMyDaemon();
                                      }else{
                                         "<br>The woman stomps a foot angrily at you and says,\"You\'ll be sorry! I\'m going to tell the Master about
                                         you and you\'ll be sorry!\"<.p>She turns and runs out of the kitchen. ";
                                         tellOnYouAgent.startMyDaemon();
                                      }
                               }else{
                                      formCube.moveIntoForTravel(pixyland);
                                      formCube.isListed = nil;
                                      "<br>The woman smiles and takes the cube from you and says,\"Nice. A male form cube. I like collecting these. 
                                      This\'ll make a nice trophy. As for <i>you</i>, sweetie, you\'ll mention nothing about this to the Master or
                                      anyone else around here or I can promise you, you\'ll never see <i>this</i> again. I don't
                                      know what you looked like before but you certainly turned out nice as a girl. You can\'t mention any of this
                                      to anyone or it could spell trouble. As far as you\'re concerned, you were always a girl. Got that? <i>Always</i>
                                      a girl. You never saw this place. You never got transformed and you were never a man before. There\'s a little
                                      community on the north side of the island that I want you to join. You\'ll be staying there for awhile. I'll
                                      drive you over there in my jeep right away and leave you there but I\'ll check up on you from time to time.
                                      There are lots of women there but men visit from time to time. Mostly tourists. Some of the men are here 
                                      looking for girlfriends or wives. Some of the men are just after a one night stand. Looking like you do now
                                      it\'s almost certain you\'ll get hit on by these men so you\'d better get used to the idea right now because
                                      you\'re staying female until I say so. Got that? The normalizer machine is locked up and I have no idea when
                                      I\'ll be able to steal the key from the Master, so don\'t be surprised if you don\'t hear from me for a few
                                      days, weeks or even months from now. Are there any questions?\"<.p>";
                                      // ** string break
                                      "\"What\'s your name and what name should I be called?\" you ask.<.p>She says,\"My name\'s Kristy and I work
                                      here as the maid. That\'s all you need to know about me for now. You can call yourself whatever you\'d like.
                                      I think you look like an Audrey or Kimberly. What name do you want to call yourself?\" ";
                                      iDone = 0; 
                                      local sName = '';
                                      do{
                                        "<br>Choose your female first name: ";
                                        sName = inputManager.getInputLine(nil, nil);
                                        sName = sName.toLower();
                                        if(sName != ''){
                                          sName = '\^' + sName;
                                          "You wish to be called <b><<sName>></b>, is this correct? ";
                                          s0 = inputManager.getInputLine(nil, nil);
                                          s0 = s0.toLower();
                                          if((s0 == 'y') || 
                                             (s0 == 'yes')
                                            ){ 
                                              iDone++;
                                          }
                                        }
                                      }while(iDone==0);
                                      gameMain.femaleFirstName = sName;
                                      "<br>\n\"Call me <<gameMain.femaleFirstName>>,\" you say.<.p> ";
                                      "\"Good,\" she says,\""; 
                                      "<<gameMain.femaleFirstName>> it is. ";
                                      "Now it\'s time to take you to your new home. Remember, <<gameMain.femaleFirstName>>, ";
                                      "you\'re a natural born girl and you must act that way. That includes having
                                      or at least pretending to have a sexual preference for men. You seem to have a foreign accent. Remember, in
                                      this country lesbians are a rarity and socially unaccepted. Your safest bet is to pretend to have an attraction
                                      towards men. No one must know who you really were before. Be careful though. There are wealthy men who visit 
                                      that village and they\'re there for one reason and one reason only: to get married. That
                                      means you\'ve got to be extra careful not to get too involved or the next thing you\'ll know you\'ll be on a 
                                      plane ride to a wedding in another country and then you\'ll <i>never</i> get your old male body back.\"<.p>";
                                      // ** string break
                                      "She leads you out to the garage and you both get in a jeep. She drives you to a small village on the north
                                      shore of the island. Within half an hour you arrive and she drops you off outside a villa and says,\"For now 
                                      this is your new home. You be a good girl and maybe I\'ll change you back to normal. If you do anything stupid
                                      like try to escape this island or tell people who you were before I can assure you, you\'ll never see this form
                                      cube again. If you think I\'m being mean you should be thankful because the Master would have erased your
                                      form cube right away, trapping you as a girl. Be grateful, <<gameMain.femaleFirstName>>. If it were any of the
                                      other house servants you wouldn\'t be getting an offer this good. Now if you don\'t mind, I need to get back
                                      to the mansion. Bye-bye, honey. With any luck I\'ll contact you soon and then we can discuss a deal on what I
                                      expect from you before changing you back into a man.\"<.p>With that she waves goodbye and drives away. ";
                                      gPlayerChar.moveIntoForTravel(yourVillaOuter);
                                      gPlayerChar.lookAround(true);
                               }
                 }else{
                       // iAsk != true
                       if( (blackLeatherPurse.isHeldBy(gPlayerChar)) || 
                           (blackLeatherPurse.isWornBy(gPlayerChar)) 
                       ){
                           "Without warning she grabs hold of your purse and frantically rummages through it, then hands it back to you
                           disappointedly and asks,\"Where is it? Your form cube? Stupid girl. How do you ever expect to change back into a man
                           again without it? I bet you didn\'t even bother to make a copy of your boy-self before using the girling booth, did you?
                           Or maybe you left it downstairs. Either way, not very bright, are you? Or maybe you hid it. Wait right here. Let me check.\"
                           <.p>She hurries off downstairs and returns again a few minutes later with the form cube in her hand. She smiles, holding it
                           up to you teasingly.<.p>\"Hey, that\'s mine! Give it back!\" you say but she pulls it back out of your reach.<.p>She says,\"Finders
                           keepers. I\'m going to add this to my collection and I\'m <i>still</i> going to tell the Master about you. Hahahaha!\"<.p>
                           With that she runs out of the kitchen, taking your form cube with her. ";
                           formCube.isListed = nil;
                           formCube.moveIntoForTravel(pixyland);
                           tellOnYouAgent.startMyDaemon();
                       }else{
                           "The woman looks you up and down and says,\"You don\'t look like you can offer me anything so I think I\'ll go and 
                           tell the Master what you\'ve done and then you\'ll see. You\'re in big trouble, girl. Big, big trouble. <i>I\'m telling
                           on you!</i> Hahahahahahaha!\"<.p>With that she runs out of the kitchen. ";
                           tellOnYouAgent.startMyDaemon();
                       } 
                 }
          }          
  }// end desc
  east : NoTravelMessage {
         travelDesc { 
                 "You\'d better think again. That woman just went to <i>tell</i> on you. If you go out of the kitchen into the main part of 
                 the house you might get caught. Maybe you\'d better try hiding in the basement instead before that \"Master\" or whoever 
                 comes and finds you. ";
         }
  }
  west = mansionPantry 
;

kitchenStoveTop: Surface, Fixture
   name = 'stove'
   vocabWords = '(kitchen) (stove) (oven) top' 
   isIt = true
   location = kitchen
;

kitchenStove: Heavy, Openable, Container
  name = 'stove' 
  vocabWords = '(kitchen) (white) (metal) stove oven'
  desc =  "A white metal stove. "
  noun ='stove'
  isIt = true
  location = kitchen
  iobjFor(PutOn) maybeRemapTo((gDobj !=nil),PutOn,gDobj,kitchenStoveTop)
  iobjFor(TakeFrom) maybeRemapTo(((gDobj !=nil) && (gDobj.isOn(kitchenStoveTop))),TakeFrom,gDobj,kitchenStoveTop)
  dobjFor(LookOn) remapTo(LookOn,kitchenStoveTop)
  // iobjFor(PutIn) maybeRemapTo((gDobj !=nil),PutIn,gDobj,sophiesTopDrawer)
  // dobjFor(Open) remapTo(Open,sophiesTopDrawer)
  // dobjFor(Close) remapTo(Close,sophiesTopDrawer)
;

kitchenFridge: Heavy, Openable, Container
  name = 'refrigerator'
  vocabWords = '(kitchen) (white) (metal) fridge/refrigerator'
  desc = "A white metal refrigerator. "
  location = kitchen
;

kitchenCupboard: Fixture, Openable, Container
  name = 'cupboard'
  vocabWords = '(kitchen) (white) (painted) (wood) (wooden) cupboards/cupboard'
  desc = "The cupboard is made of wood and painted white. "
  location = kitchen
;

kitchenCounterTop: Surface, Fixture
  name = 'counter'
  vocabWords = '(kitchen) (white) (marble) counter top'
  desc = "A white marble counter top. "
  location = kitchen
;

mastersRoom: Room 'The Master\'s Room'
  "A holding room for the form cube if the Master has posession of it. "
;


// tellOnYouAgent: RealTimeDaemon // note: do NOT call it as a RealTimeEvent!!! Even though it is one (call it as a RealTimeDaemon or else your program could lock up and crash!)
tellOnYouAgent: PromptDaemon
 name = 'tellonyouAgent'
 eventTime = 1000 // nil // 10000  
 myMessageList : StopEventList {
                  eventList = ['','','You hear a woman shout,\"Master! Master! An intruder\'s in the kitchen!\" ','','',
                               new function(){
                                  if((gPlayerChar.location == kitchen) || (gPlayerChar.location == mansionPantry)){
                                         "You\'d better go hide downstairs in the basement before they find you! ";                                  
                                  }                                 
                              },
                               '','','',
                               new function(){
                                  if((gPlayerChar.location == kitchen) || (gPlayerChar.location == mansionPantry)){
                                         "You hear voices in the other room.<.p>\"Master, he used your machine and turned himself into a girl.\"
                                         <.p>\"That\'s disgusting, Kristy. I almost forgot about my girl maker. Are we still running experiments with it?\"
                                         <.p>\"The project\'s in the end stages. It\'s been three years, Master.\"<.p>\"Three years already? My, my, my.
                                         No wonder I\'d forgotten about the girl maker. Three whole years...\" ";
                                  }
                               },
                               '','','','','','',
                               new function(){
                                 /*
                                     // commenting out - save for post-contest east isle expansion
                                     if(
                                        (gPlayerChar.location == basementDressingRoom) && 
                                        (shovel.location == pixyland) &&
                                        (twistyPassageFive.annoyedDwarf == true)
                                       ){
                                                if(gameMain.is_a_girl == true){
                                                      "A panel in the wall opens up and there\'s the dwarf again with your shovel slung over his shoulder. He glances up and
                                                      around at the sound of the maid hollaring about intruders in the house and looks right at you and says,\"Great, first 
                                                      a clumsy oaf caves in the south chamber, now he\'s gone and riled up the maid. Look, you don\'t look like you\'re from 
                                                      around here. You\'d better come with me before you get in trouble.\"<.p>
                                                      local iDone = 0; 
                                                      local s0 = '';
                                                      do{
                                                         "<br>Do you go with the dwarf? (yes/no) : ";
                                                         s0 = inputManager.getInputLine(nil, nil);
                                                         s0 = s0.toLower();
                                                         if((s0 == 'y') || 
                                                            (s0 == 'yes') ||
                                                            (s0 == 'n') ||
                                                            (s0 == 'no')
                                                         ){ 
                                                            iDone++;
                                                         }
                                                      }while(iDone==0);
                                                      if(s0 == 'n' || s0 == 'no'){
                                                                "\"Sorry,\" you say to him. \"I\'ll take my chances in here.\"<.p>
                                                                \"Suit yourself but don\'t say that I didn\'t warn you. The Master can be downright mean when 
                                                                it comes to punishing intruders,\" the dwarf says retreating back into the secret passage as it shuts
                                                                behind him, leaving you alone in the dressing room once more.\"<.p> ";
                                                                exit;
                                                      }
                                                      tellOnYouAgent.stopMyDaemon();
                                                      "You say \"lead the way\" and the dwarf takes you by the hand and leads you into the twisty little passages.<.p>
                                                      \"A woman type,\" he says glancing up at you as he presses his hand upon a rock wall and a panel opens, revealing
                                                      a set of stairs leading deeper underground. \"And by the clumsy way you\'re walking I\'d gather you used to be a man
                                                      before and had just used the girling booth, haven\'t you? Don\'t deny it. I\'ve seen this sort of thing before. You\'re
                                                      probably the same fellow who caved in the south chamber, aren\'t you.\"<.p>
                                                      \"How did you know?\" you ask, admitting it.<.p>
                                                      \"You aren\'t the first, you know. As I said, I\'ve seen this sort of thing before,\" ";
                                                      local iCubeWithPlayer = nil;
                                                      if(formCube.isHeldBy(gPlayerChar)){
                                                               he glances over at the form cube in your hand and asks,\"Is that yours?\"<.p>
                                                               You nod yes and he says,\"Smart girl. You\'d do well not to lose it. It\'s your only way
                                                               back to normal you know.\"<.p>";
                                                               iCubeWithPlayer = true;
                                                      }else if(
                                                               (formCube.location == blackLeatherPurse) && (blackLeatherPurse.isHeldBy(gPlayerChar)) ||
                                                               (formCube.location == blackLeahterPurse) && (blackLeatherPurse.isWornBy(gPlayerChar)) 
                                                              ){
                                                                   he glances over at your purse and asks,\"You got your form cube in there?\"<.p>
                                                                   \"Yep,\" you reply patting the side of your purse.<.p>
                                                                   \"Smart girl,\" he says. \"You\'d do well not to lose sight of it. Without it you\'ll never
                                                                   be able to change back to normal again.\"<.p>";     
                                                               iCubeWithPlayer = true;
                                                      }else{
                                                              "he glances over at you and asks,\"Where\'s your form cube?\"<.p>
                                                              \"I left it behind,\" you say shrugging.<.p>
                                                              \"Too bad,\" he says with a chuckle. \"Without it you\'ll never be able to change back to normal.\"<.p> ";
                                                      }                  
                                                      "\"Where are you taking me?\" you ask.<.p>
                                                      The red bearded dwarf regards you with one eye half squinting and replies,\"This tunnel leads to a small bay on the
                                                      eastern shore of the island. There\'s a sort of pirate town there. It\'s really not safe for a free woman to go there but
                                                      at least it\'s better than being caught by the Master.\"<.p> ";
                                                      inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                      "<HR ALIGN=CENTER NOSHADE><br>";
                                                      "\"Why isn\'t it safe for women?\" you ask with growing concern. You begin to think that maybe the dwarf is trying to trick you.<.p>
                                                      He glances up at you with a slight sneer and says,\"You may not know this but there are wealthy men who visit this island intent on
                                                      bringing home brides, either the traditional way or through less known contractual arrangements.\"<.p>
                                                      \"You mean like mail order brides?\" you ask with a bad feeling growing in the pit of your stomach.<.p>
                                                      \"Something like that, yes,\" the dwarf says.<.p>
                                                      \"Is that what you have planned for me then?\" you ask.<.p>
                                                      \"I will put it to you this way,\" he says pondering just how to break it to you as he strokes his beard deep in 
                                                      thought. He stops in the passageway and turns to face you and says,\"From what I gather until just a little while
                                                      ago you were a man. The Master isn\'t known to turn men into women, even though the name of his machine seems to
                                                      indicate otherwise. The girling booth used to be used for limited research that the Master has since given up as
                                                      he has moved to other areas, such as a machine used for zombification and control of the undead.\"<.p>
                                                      \"How do you know so much about the Master\'s projects?\" you ask.<.p>
                                                      \"I used to work for him. Who do you think built all these tunnels around his mansion?\" the dwarf replies. \"At any
                                                      rate the point I\'m trying to make is you saw \"girl maker\" written on the side of one of his machines and for whatever
                                                      reason decided to turn yourself into a full or part time member of the fair sex.\"<.p>
                                                      inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                      "<HR ALIGN=CENTER NOSHADE><br>";
                                                      "\"So?\" you say blushingly trying to come up with some reason why none of his accusations about you are true but you are
                                                      unable to think of anything offhand.<.p>
                                                      \"Come on,\" the dwarf says. \"Don\'t try and fool me. I\'m a man, too, just like you were. Well... a dwarf anyway. Point is
                                                      I\'m male and I know how men think. Now not every man\'s going to go jumping into a machine like that and turn himself into
                                                      a woman but enough are at least curious enough to give it a go if only just to see some pussy, even if that pussy\'s going to
                                                      be a part of you. Now don\'t lie, if you were curious enough to go this far you\'re curious enough to go all the way. You\'re
                                                      eager to test out that new body of yours aren\'t you, princess? Well in Pirate Town there\'s a way if you\'re up to it. I\'ll 
                                                      work out a contract to sell you as a bride. Now hear me out before you disagree completely. I stand to make a sack of gold off
                                                      you, maybe more. I\'ll cut you in for some of that and even help you escape your own wedding. In the mean time you get the chance
                                                      to satisfy your curiosity about your new sex a little better, if you catch my drift.\"<.p> ";
                                                      iDone = 0;
                                                      s0 = '';
                                                      do{
                                                         "<br>Are you interested in the dwarf\'s idea (careful, he could be lying to you about the money or helping you later on)? (yes/no) : ";
                                                         s0 = inputManager.getInputLine(nil, nil);
                                                         s0 = s0.toLower();
                                                         if((s0 == 'y') || 
                                                            (s0 == 'yes') ||
                                                            (s0 == 'n') ||
                                                            (s0 == 'no')
                                                         ){ 
                                                            iDone++;
                                                         }
                                                      }while(iDone==0);
                                                      if(s0 == 'n' || s0 == 'no'){
                                                             "<br>\"Clever little minx. You\'ve just wasted my time,\" the dwarf spits turning you both around and leading
                                                             you quickly back to the masnion. He shoves you back through the moving wall and into the dressing room
                                                             and says,\"And good riddance. I hope the Master sells you off anyway!\"<.p>";
                                                             tellOnYouAgent.startMyDaemon();
                                                             exit;
                                                      }
                                                      "<br>\"How much money are we talking about?\" you ask intrigued by the idea.<.p>
                                                      \"I\'ll cut you in for ten percent. Before you say no, rememeber it\'s gold and that\'s still a lot of money and
                                                      I\'m the one with the connections to make this deal, not you, so take it or leave it. Then next time you play the
                                                      game you can run things yourself and take all the profit. But to learn this game you\'ve got to pay the teacher, and that\'s me,\" the Dwarf says.<.p>
                                                      <br>\"So you\'re some kind of a rogue then?\" you ask. \"What\'s your name? Mine\'s Jake.\"<.p>
                                                      <br>\"Bah! That\'s a <i>terrible</i> name for a girl,\" the dwarf says. \"From now on you\'ll go by Audrey. At 
                                                      least for this deal. Got that? And as for my name. I don\'t give it usally to passing aquaintences but you can call me
                                                      Dindrig\"<.p>";
                                                      gameMain.femaleFirstName = 'Audrey';
                                                      "He leads you out of the tunnel system and out into a back alley in a small town on the eastern side of the island.
                                                      You follow him to a little back door of a run down old building and he turns to you and asks,\"You stay here while I go in and set this up.
                                                      One thing I\'ve got to know - are you a... you know?\"<.p>
                                                      \"What?\" you ask.<.p>
                                                      \"You know... did you have time to pop your... you know what?\" he asks but you still shrug. \"Are you a virgin?\"<.p>
                                                      You shrug, blushing and laughing a little. You reply,\"I guess. What I mean is, I didn\'t have time to explore myself <i>that</i> way yet.
                                                      How can I tell?\"<.p>
                                                      He waves it off and says,\"Bah! Don\'t worry about it. I happen to know that when that machine turns boys into girls it cranks out virgins. 
                                                      Reason it\'s important is you\'re worth more as a virgin bride in this sort of market. If I was buying me a wife I\'d want her untouched by
                                                      men too. Now wait right here. Hide behind those wooden crates until I get back. Don\'t get caught now.\"<.p>";
                                                      inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                      "<HR ALIGN=CENTER NOSHADE><br>";
                                                      "You hide as instructed and after awhile Drindrig returns for you and says,\"They can use you right away. Customer list is pretty big for this
                                                      sort of thing and there\'s a paying customer waiting for you in the lobby. There\'s a catch - you have to be a princess. Don\'t ask why. The guy is rich and
                                                      wants to marry royalty for some reason. So you\'re a princess. Got that?\"<.p>
                                                      You nod your head yes.<.p>
                                                      \"Few other things you should know. These pirates run a pretty sophisticated operation,\" Dindrig explains. \"Usually once you\'re sold, you\'re sold and that\'s
                                                      it. No refunds but this particular customer wants a trial period. The pirates will give him one night with you to try you out. If in the morning he\'s not 
                                                      completely satisfied he may return you in exchange for another girl. If that happens I\'m going to lose a lot of money on you because by then you won\'t be 
                                                      a virgin anymore, you\'ll be used merchandise. If he agrees to keep you then you\'ll both be leaving out of here on a plane in the morning and you\'ll probably
                                                      be married to him within a week. I\'m going to try and intercept you at the airport if that happens and there you\'ll get your cut of the loot and you can do with
                                                      it what you want, you\'ll never see me again. Is that understood?\"<.p>
                                                      You nod yes.<.p>
                                                      Dindrig reaches up and places a silver collar around your neck and fastens the clasp in the back. Before you get a chance to ask what it\'s for he
                                                      explains,\"This is magical. It will block out all but the simplest forms of verbal communication for you while you\'re wearing it. You will normally not be able
                                                      to speak at all until spoken to. You will wear it at least until after your wedding when you say \"I do\" but I should have rescued you at the airport way before
                                                      then.\"<.p>";
                                                      inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                      "<HR ALIGN=CENTER NOSHADE><br>";
                                                      "You reach up to feel for the clasp in the back of the necklace but it won\'t unfasten. You try to ask him about that but all that comes from your lips is
                                                      a squeaky \"Eeep!\" almost imprceptible like a baby mouse. Every tenth or twelfth word comes out that way but all other words from your mouth come out as
                                                      dead silence. The dwarf laughs and says,\"Here\'s the kicker. Only a woman may wear it but only a man may unclasp it from your neck to remove it. The pirates
                                                      have obtained crates full of the things from an enchanter. It\'s a real top quality spell, my princess. Now it\'s time for me to take you inside and complete the
                                                      transaction.\"<.p> ";
                                                      
 
                                                      

. So they\'re giving him three nights with you to test you out.
                                                      

                                                                                                         


Slavers might snatch you up and try and sell you as a bride. If you used the
                                                      girling booth there\'s a good chance the Master\'s going to eventually find out who you really were before and send bounty hunters
                                                      to round you up but if you go to the slavers you might get a better chance of survival.\"<.p>
                                                      \"And be somebody\'s bride?\" you ask horrified.<.p>
                                                      The dwarf chuckles. \"Look on the bright side. At least it comes with a free name change,\" he says adjusting the shovel he\'s resting
                                                      on his shoulder before he pauses to touch a dead end wall and open up another secret passage. \"Through here, my princess.\"<.p>
                                                      \"And what if I refuse? Or what if I try and stop you?\" you ask.<.p>
                                                      He eyes you with a frowned expression for a moment then shakes his head no and says,\"You had me for a second there. Naw, I know you\'re
                                                      not the fightin\' type. Even if you were before, the machine sucked up all the agression clean out of you when it turned you into a skirt
                                                      wearin\' harmless little, scrawny armed, boob bearin\' damsel.\"<.p>";
                                                      if(strangeFemDress.isWornBy(gPlayerChar)){
                                                                "\"This isn\'t a skirt, it\'s a dress,\" you correct him.<.p>
                                                                \"Ha-ha-har!\" he laughs. \"Same difference. Either way you\'re a woman now and you haven\'t got the balls and even if you
                                                                did you still couldn\'t beat a dwarf.\"<.p> ";
                                                      }
                                                      "\"So you intend on selling me to the slavers?\" you ask, starting to get the picture why he\'s trying to help you.<.p>
                                                      \"Now you understand. I\'me going to make a nice little pouch of gold off you, princess,\" he replies nodding.<.p>
                                                      \"What if I make a run for it?\" you ask.<.p> ";
                                                      if(strangeFemShoes.isWornBy(gPlayerChar)){
                                                             "He glances down at your pumps, laughs and says,\"In <i>those</i> things? Ha-ha-har! You can\'t be serious.";
                                                      }else{
                                                             "He glances down at your shoeless feet, laughs and says,\"Right. A barefoot woman\'s going to outrun a dwarf wearing boots of speed.
                                                             Not a chance!";
                                                      }
                                                      " I\'d catch you and cut your throat before you knew it. Your choice of course. You could die as a woman but then they\'d have to bury you
                                                      that way and it would even go on your grave that you were a woman. No one would ever know you used to be a man. How\'s that sound? The chance
                                                      do die in anonymous lady-land. You\'d be just another Jane Doe to anyone you knew before. ";
                                                      if(iCubeWithPlayer == true){
                                                             "But if you do as I say and go with the slavers I might even let you keep your form cube. I get the money and you get the man. After that
                                                             you can do as you please and I won\'t try and get in the way. If you don\'t agree then you <i>still</i> get sold to be somebody\'s wife
                                                             and I keep your cube.\"<.p> ";
                                                      }else{
                                                             "You have no form cube but if you agree with this and let me sell you to the slavers I might be persuaded to later on help you get back to
                                                             the mansion and try and get your form cube back.\"<.p>";
                                                      }
                                                      inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                      "<HR ALIGN=CENTER NOSHADE><br>";
                                                             
                                              
                                             
                                                   
                                                   
// ** bookmark!

                                                }   
                                       }
                                       */
                               },
                               new function(){
                                     if((gPlayerChar.location != kitchen) && (gPlayerChar.location != mansionPantry)){
                                          "<br>You hear voices upstairs.<.p>\"He was right here, Master, I swear. He was wearing a girl\'s body.\"<.p>
                                          \"He\'s probably hiding in the basement alert the butler and have all the exits sealed and report
                                          back to me when you\'re through.\"<.p>\"Yes Master.\" ";
                                     }else{
                                          "<br>You hear voices in the next room.<.p>\"Master, he\'s right in here, in the kitchen. He was wearing a girl\'s
                                          body.\"<.p>\"Is that right? He broke in here and was using my invention was he?\"<.p>\"Oooooo, Master! You 
                                          sound really, really upset. What are you going to do with him?\"<.p>\"I have a good mind to change him back
                                          to normal and turn him over to the authorities for trespassing but I think I have a better idea.\"<.p>\"What
                                          Master? Tell me! Tell me!\"<.p>\"Patience, Maid, you\'ll see soon enough.\" ";
                                     }
                               },
                               '','','','',
                               new function(){
                                     "The woman who told on you returns with a tall dark haired gentleman who\'s wearing a black suit. 
                                     The man introduces himself as the Master";
                                     if(formCube.location != pixyland){
                                            if(formCube.isHeldBy(gPlayerChar)){
                                                   " who roughly grabs your form cube away from you. ";
                                            }else if(
                                              (formCube.location == blackLeatherPurse) &&
                                              ( (blackLeatherPurse.isHeldBy(gPlayerChar)) || 
                                              (blackLeatherPurse.isWornBy(gPlayerChar)) )
                                             ){
                                                   " who grabs hold of your purse and plucks the form cube from it. ";
                                            }else{
                                                   " who quickly searches for and finds your form cube. ";
                                            }
                                    }else{
                                            " turns to the maid and asks,\"Did you look to see if he\'s stored a form cube?\"<.p>
                                            Blushing, the maid produces the cube from her purse and says,\"Yes, sorry Master. I took it from
                                            him already. Here you go.\" ";
                                    }
                                    "<.p>The Master waggs the cube in your face and says,\"Do you realize how expensive these are? They contain
                                     radioactive elements not easy to obtain nor manufacture into the final product. It takes weeks
                                     to hand craft one of these and my supply on them is by no means unlimited. You have taken the
                                     liberty of breaking into my home and turning yourself into a girl. Actions which are intolerable
                                     in and of themselves but nothing compared to wasting one of <i>these</i>. You\'re a foreigner, I
                                     presume. An American perhaps? No local would dare trespass in my island home due to the legends 
                                     so you\'re definately not from around here. This cube costs over one million U.S. dollars just
                                     in materials alone. Who\'s going to pay for this? Do you have any money? No? I thought not. I\'ll
                                     have to have this cube erased and re-fit. That\'s going to take some time. My machines are not 
                                     toys for you to play with. Sex change is serious business and something I keep track of and monitor
                                     closely on my island. It\'s a good thing I caught you. I have a community of natural born girls living
                                     in a small village on north shore. If you\'d have gotten there you might have contaminated them with
                                     bad ideas about what\'s going on here. I keep another, rather small community of women in a compound
                                     near the center of the island. They, like you, were formerly male. They are all there for various 
                                     reasons. Some voluntary, others are not. You will be put through some training and I have doctors 
                                     there who will study you. The data they collect will aid me in furthering my research on the effects
                                     of male to female sex change. By your actions you have nullified your rights and have by implication
                                     chosen to become my newest test subject. You have cost me a great deal of money by wasting this form
                                     cube and I intend on making you pay for its erasure and re-fitting cost. My maid, Kristy, here will
                                     escort you to the compound where you will be staying. I will check up on you from time to time so
                                     behave yourself. Goodbye now.\"<.p>The maid takes you to the garage and you both get in a jeep. She
                                     drives you to a fenced off compound where you\'ll be staying. She honks and waves goodbye as you watch
                                     her drive off into the jungle.<.p>";
                                     formCube.moveInto(mastersRoom);    
                                     "You have become trapped on the island as a test subject of the Master\'s diabolical experiments. Trapped
                                     in his heavily guarded jungle compound you have no way of escaping back to civilization. Without your form
                                     cube you have no way of transforming back to normal and leaving the island back to the life you had before. ";
                                     inputManager.pauseForMore(true);// better than using just the morePrompt()
                                     "<HR ALIGN=CENTER NOSHADE><br>";
                                     if(gPlayerChar.girlType == 'abysmal'){
                                           "You\'ve turned yourself into a woman and the only consolation is you chose the abysmally blonde model
                                     which eases your acceptance little by little until one day you wake up without any desire what-so-ever to change
                                     back into a man again. ";
                                     }else{
                                           "You\'ve turned yourself into a woman to see how the other half lives but the novelty of the idea quickly
                                           wears off and you realize what a horrible mistake you\'ve made. Trapped halfway between heaven and hell, between
                                           paradise and punishment, you live the remainder of your days out in misery and regret. You\'ve left behind your
                                           dear girlfriend Sherrie who you never see again. You\'re forced to go through training to learn how to be a woman
                                           and before it\'s all through you are pushed into numerous relationships with men. You don\'t like it,  nor do you
                                           have to. You just have to do as you\'re told and cooperate with what your superiors tell you to do. You wind up
                                           pretending to love men just to keep yourself out of trouble. In the end you\'ve become a bitter, broken woman
                                           mechanically carrying out her instructions to the letter if only to avoid a slap in the face. The Master visits
                                           you from time to time to check on your progress. It\'s no consolation prize that he often tells you you\'re the
                                           last man to have gone through the girl maker and that you\'re also the last one to have entered into his little
                                           training camp. He informs you one day that your form cube had long ago been erased and that you can never return
                                           to being a man again.<.p>";
                                           // ** string break
                                           "After many years of being an involuntary test subject the experiments finally cease. The Master has been
                                           caught and defeated by someone but in the process his mansion hideout has been burned to the ground. The 
                                           transformation machines have all been destroyed and you, along with all the other women trapped here on the
                                           island take a long boat ride across the lake back to civilization.<.p>
                                           Technology has advanced tremendously during your absence and you discover that men have actually been to
                                           Mars and there\'s even a moon base now. Rejuvination treatments can guarantee virtual immortality and the 
                                           government quickly sees to it that you and all the other victims of the Master are rejuvinated back to age
                                           twenty-one. You\'re a beautiful young woman and have a bright future to look forward to but you\'ll never ever
                                           forget the life you left behind. Many men approach you, some even try to propose marriage to you but you can never
                                           fully accept the idea and you\'re too afraid of rejection to tell others who you were before. You only wish all those
                                           years ago you\'d been more careful about your form cube. If only you could have made some kind of deal to get it
                                           back. Alone, depressed and forever detached from society you waste away your days wishing none of this ever 
                                           happened. Then one day the Master makes a come back. It\'s in all the news. The Master\'s escaped prison and
                                           is on the loose once again, freely making new and more devious and diabolical schemes. If only you could get
                                           back to him somehow, maybe you could get changed back into a man again.<.p>If only, if only, if only.<.p><b>The End</b>";
                                           tellOnYouAgent.stopMyDaemon();
                                           finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);
                                     }
                               }
                  ]
 }
 masterFoundYou = nil
 myDaemon(){  
              // ** do something
              tellOnYouAgent.myMessageList.doScript();
 }
 isActive = nil
 myDaemonRunning = nil
 startMyDaemon(){
       if(tellOnYouAgent.myDaemonRunning != true){
            /* start daemon */
            // new RealTimeDaemon(tellOnYouAgent,&myDaemon,eventTime);// there are other ways to initialize this but this calls self & a method in self
            new PromptDaemon(tellOnYouAgent, &myDaemon);
            /* set that the daemon is running (so we can keep track easy) */
            tellOnYouAgent.myDaemonRunning = true;
       }
       // make sure we are active
       tellOnYouAgent.isActive = true;
   }
   /*
    *  VERY IMPORTANT!!!!
    *
    *      NOTE: do NOT use eventManger for tracking and removing RealTimeEvents!!!
    *            Do use realTimeManager for this purpose, and use eventManager for
    *            all other agents (one time fuses, turn based events, etc.).
    *
    */
   stopMyDaemon(){
        eventManager.removeMatchingEvents(tellOnYouAgent, &myDaemon);// Make sure - use this for PromptDaemon, etc. NOT RealTimeEvent!
        // realTimeManager.removeMatchingEvents(tellOnYouAgent, &myDaemon);// Use for RealTimeEvent, NOT PromptDaemon
        tellOnYouAgent.removeEvent();
        tellOnYouAgent.myDaemonRunning = nil;
        tellOnYouAgent.isActive = nil;
   }
;


// ** ------------------------ NORTH SHORE VILLAGE -----------------------

yourVillaOuter: OutdoorRoom 'front of villa'
   desc { 
        "This is the front of your new home. A small thatched hut more than anything else.
        There is a gravelly road out front winding its way down the dark jungle hillside past other
        huts. The front door is rather primitive, being comprised up of hundreds of pink and white beads
        hanging on strings. The front window has white drapes with big pink polkadots all over. The road is
        to the east. The main way in is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
        }else{
                "north"; 
        }    
        ". There is a bath house to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
        }else{
                "west"; 
        }
        ". The town is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"south\">east</a>";
        }else{
                "east"; 
        }
        " from here. ";
   }
   east : NoTravelMessage {
         travelDesc { 
           if(gameMain.generalTime == 'night'){
                "It\'s night, your tired from your transformation and just want to get some rest.
                There\'s really no hurry. The road will be there in the morning. ";
           }else if(
                    (gameMain.generalTime == 'morning') &&
                    (bathHouseBath.bathingTable.getScriptState() == 1)
                   ){
                "You should probably take a bath first before venturing into town. ";
           }else if(tiffys.bigfootSeen != true){
                "You follow the road out of your little gated community and into town. It\'s a nice long walk
                but it\'s morning and you could use the fresh air. You arrive outside a little restaraunt and
                decide to go in for a bite to eat.<.p>";
                "As you walk in the door a waitress greets you with a smile and a hearty good morning hello. 
                She leads you over to a little booth and hands you the menu. ";
                if(
                   (travelersCheck.isHeldBy(gPlayerChar)) || 
                   ((travelersCheck.location == blackLeatherPurse) && (blackLeatherPurse.isHeldBy(gPlayerChar))) ||
                   ((travelersCheck.location == blackLeatherPurse) && (blackLeatherPurse.isWornBy(gPlayerChar)))
                  ){
                      "You feel embarrassed as you have no money with you. You ask,\"Do you accept traveler\'s checks?\"<br>\n";
                }else{
                      "You feel embarrassed as you have no money with you. You say,\"Look. I\'m real sorry. I completely forogt. I don\'t have any
                      cash on me right now. Maybe just a glass of water.\"<br>\n";
                }
                "\"Honey, you must be new. The meals are paid for by the Escort Agency,\" the waitress explains.<br>\n
                \"Pardon? The what?\" you ask.<br>\n\"Boy you really <i>are</i> new, aren\'t you? The Escort Agency. They own
                and run this entire village.\"<br>\n";
                gPlayerChar.moveIntoForTravel(tiffysBoothChair);
                gPlayerChar.makePosture(sitting); // tiffysBoothChair.performEntry(sitting);
                gPlayerChar.lookAround(true);
           }else{
                "You follow the road back to the plaza. ";
                gPlayerChar.moveIntoForTravel(centerVillagePlaza);
                gPlayerChar.lookAround(true);
           }            
         }
   }
   west : NoTravelMessage {
         travelDesc {
           if(gameMain.generalTime == 'night'){
                "It\'s night, your tired from your transformation and just want to get some rest.
                There\'s really no hurry. You can use the bath house in the morning. ";
           }else if(gameMain.generalTime == 'morning'){
                gPlayerChar.moveIntoForTravel(bathHouse);
                gPlayerChar.lookAround(true);                     
           }            
         }
   }
   north = yourFrontDoorOuter
   in = yourFrontDoorOuter
;
+ bathHouseDecOneA: Distant, Decoration 'bathhouse bath house' 'bath house'
  "A bath house is to the west. "
;
+ townDecOneA: Distant, Decoration '(distant) (far) (away) (faraway) (island) town/city/village/ville' 'town'
  "You can barely see the town off in the distance to the east. "  
;
+ yourFrontDoorOuter: PathPassage '(my) (your) (front) (pink) (and) (white) (villa) (thatched) (hut) (plastic) bead beads door' 'door'
  "Your door is made of pink and white beads hanging on threads. The beads themselves look like they\'re made of plastic. "
   masterObject = yourFrontDoorOuter
   otherSide = yourFrontDoorInner
;

basicallyClothed: TravelBarrier
   justWearingPantiesCheck {
      // checks to see if the pc/npc is wearing clothing or not and returns true or nil
      local clothingTally = 0;
      local iFail = nil;
      if(gPlayerChar.contents == nil) return nil;// if you're carrying nothing, you're nude, so return 0 or false
      foreach(local obj in gPlayerChar.contents){
           if(obj.ofKind(CromexxClothing)){               
               if(obj.clothLevel != nil){
                  if(obj.isWornBy(gPlayerChar)){
                        clothingTally++;
                        if(obj.clothLevel != 3) iFail = true;
                  }
               }
           }       
      }   
      if(iFail == true) return nil;
      /*
       * If the clothing tally is just 1 item
       * and we passed the fail comparison check,
       * then this 1 item must be our panties.
       * So therefor we're just wearing panties.
       */
      local myReturner = ((clothingTally == 1) ? true : nil);
      return myReturner;
   }
   bottomlessAccessCheck{
       // checks to see if you are not wearing anything covering your... ahem...
       local isCovered = 0;
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(3); // underpants/panties
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(4); // swimsuit (1-piece)
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(9); // pants/shorts
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(12); // dress (i.e. evening gown)
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(22); // body stocking
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(23); // regular stockings
       return ((isCovered == 0) ? true : nil); 
   }
   toplessCheck{
       // checks to see if you are topless (i.e. exposing breasts if you're a girl)
       local isCovered = 0;
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(4); // swimsuit 1-piece
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(5); // bra
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(6); // t-shirt (undershirt)
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(7); // shirt/blouse
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(8); // coat
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(12); // dress (full gown)
       isCovered = isCovered + gPlayerChar.clothingLevelCheck(22); // body stocking (full body stocking)       
       return ((isCovered == 0) ? true : nil); 
   }
   nudeCheck {
      // checks to see if the pc/npc is wearing clothing or not and returns true or nil
      local clothingTally = 0;
      if(gPlayerChar.contents == nil) return true;// if you're carrying nothing, you're nude, so return 1 or true
      foreach(local obj in gPlayerChar.contents){
           if(obj.ofKind(CromexxClothing)){
               if(obj.isWornBy(gPlayerChar)) clothingTally++;
           }       
      }   
      local myReturner = (clothingTally == 0) ? true : nil;
      return myReturner; 
   }
   canTravelerPass(traveler) { 
        local iPanties = justWearingPantiesCheck;
        local iBottomless = bottomlessAccessCheck;
        local iTopless = toplessCheck;
        local iNude = nudeCheck;
        if(iPanties || iBottomless || iTopless || iNude) return nil;
        return true;
   }
   explainTravelBarrier(traveler) { 
        local iPanties = justWearingPantiesCheck;
        local iBottomless = bottomlessAccessCheck;
        local iTopless = toplessCheck;
        local iNude = nudeCheck;
        if(iPanties){
             "You can\'t go walking out of here in just your panties. You should put on something more. ";
        }else if(iBottomless){
             "You can\'t go out there like that. You need more clothes on. ";
        }else if(iTopless){
             "You can\'t go out there topless like that. You\'ll need to put on some more clothes first. ";
        }else if(iNude){
             "You can\'t go running around out there in the nude. You need to get dressed before going out. ";
        }
   }
;

yourVillaInner: ClothingRemovalRoom 
  name = 'your villa'
  desc { "This is nothing more than a simple little bedroom.
         There\'s no kitchen, livingroom or even bathroom here.
         This is purely a place for you to change clothes and 
         sleep. The front door, if you can call it that, is
         just a series of beads hanging on string. Anyone at all
         could come barging in here at any time and there\'s nothing
         you could do to stop it. You\'ve got a bed and a dressing table
         and that\'s it. Not even a closet with which to hang your clothes. ";
         if(!gPlayerChar.hasSeen(self)){
                "<.p>It\'s night time though not too late. Even still you feel a bit tired. Having your entire body transformed
                 from a man into a woman has certainly taken its toll. There\'s an inviting looking
                 bed right here. Maybe after some <a href=\"sleep\">sleep</a> you can recoperate your wits a little and decide
                 what to do. ";
                me.readyToSleep = true;
         }
         "<.p>You can leave by going ";
         if(gameMain.allowHtmlLinks){
                "<a href=\"out\">out</a>";
         }else{
                "out"; 
         }
         " (or ";
         if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
         }else{
                "south"; 
         }
         "). ";
  } 
  south = yourFrontDoorInner
  out = yourFrontDoorInner
   
;
+ yourFrontDoorInner: PathPassage '(my) (your) (front) (pink) (and) (white) (villa) (thatched) (hut) (plastic) bead beads door' 'door'
  "Your door is made of pink and white beads hanging on threads. The beads themselves look like they\'re made of plastic. "
   masterObject = yourFrontDoorOuter
   otherSide = yourFrontDoorOuter
   travelBarrier = [basicallyClothed]
;
+ yourBed: Bed, Heavy '(large) (single) (twin) (mattress) (pink) (painted) bed' 'bed' 
  "It\'s a wooden bed painted pink, single sized with white bed sheets and a big pink blanket. "
; 
+ myBedSheets: Decoration '(white) (cotton) (bed) sheet/sheets' 'sheets'
  "White cotton bed sheets. "
  isPlural = true
;
+ myBlanket: Decoration '(pink) (wool) covers blanket' 'blanket'
  "A pink wool blanket. "
;

myDressingTable: Heavy, Surface '(pink) (painted) (wood) (wooden) (dressing) desk table' 'dressing table'
  "A wooden dressing table painted pink. It has a<<(myDressingTableDrawer.isOpen) ? 'n open drawer' : ' drawer which is closed'>>. "
  location = yourVillaInner
  dobjFor(Open) remapTo(Open,myDressingTableDrawer)
  dobjFor(Close) remapTo(Close,myDressingTableDrawer)
;
+ dressingTableMirrorB: Component '(shiny) (reflective) (pink) (wood) (wooden) (framed) (rectangular) (desk) (dressing) (table) glass mirror' 'mirror'
  "A pink wooden framed rectangular mirror attached to the dressing table. "
    disambigName = 'dressing table mirror'
    dobjFor(LookIn) remapTo(Examine,dressingTableReflectionB)
;
++ dressingTableReflectionB: Component '(your) (my) (shiny) (reflective) (dressing) (table) (glass) (mirror) (beautiful) (pretty) (young) (blonde) (blond) (woman) (woman\'s) (girl) (girl\'s) reflection' 'reflection'
    desc {
        if(gameMain.is_a_girl){
            "You see a blonde girl in your reflection. ";
        }else{
            "You see your normal male self in your reflection. ";
        }
        local myList = dressingTableReflectionB.getClothingWornList();
        if(myList != nil){
            local sWho = 'man';
            if(gameMain.is_a_girl){
                sWho = 'girl'; 
            }
            local s0 = 'You see the ' + sWho + ' in your reflection wearing ';                   
            say(s0);
            local myWearingLister = new WearingLister();// see List.t 
            /* 
             *  WearingLister.showListAll(list,options,indent) where:
             *
             *  list = the List object you are passing to the routine for listing
             *  options = ListContents (comma seperated), ListTall (semicolon seperated)
             *  indent = only for ListLong (long lists), if 0 then no indentation
             */               
            myWearingLister.showListAll(myList,ListContents,0);
            ". ";
        }
        
    }
    
    getClothingWornList(){
              local vList = new List();
              if(gPlayerChar.contents == nil) return nil;
              foreach(local obj in gPlayerChar.contents){
                    if(obj.isWornBy(gPlayerChar))
                       vList += obj;
              }
              return vList;
   }
;
/* Component class from objects.t - just means the object is non-portable and belongs to another.
 * Openable class from objects.t - note: do NOT set "isOpen = nil"... that overwrites 
 *                                       some "isOpen" code if you do. Also the default 
 *                                       "isInitiallyOpen" setting is nil (i.e. closed).
 */ 
+ myDressingTableDrawer: Openable, RestrictedContainer, Component  '(wood) (wooden) (dressing) (table) drawer' 'drawer'
   "An ordinary wooden dressing table drawer. "
   validContents=[blackLeatherPurse]
   /* Here we override the "cannotPutInMsg" function 
    * to say something than the default "&cannotPutInRestrictedMsg" library message.
    */
   cannotPutInMsg(obj) { return 'You shouldn\'t go putting things in there that don\'t belong. ';
                       }
;

noBathUntilNude: TravelBarrier
   canTravelerPass(traveler) { 
      local clothingTally = 0;
      if(traveler.contents == nil) return true;// if you're carrying nothing, you're nude, so return 1 or true
      foreach(local obj in traveler.contents){
           if(obj.ofKind(CromexxClothing)){
               if(obj.isWornBy(traveler)) clothingTally++;
           }       
      }   
      local myReturner = (clothingTally == 0) ? true : nil;
      return myReturner;
   }
   explainTravelBarrier(traveler) { "You can\'t go in there with clothes on. ";
   }
;

noBathWithPosessions: TravelBarrier
   canTravelerPass(traveler) { 
      local iFail = nil;
      if(traveler.contents == nil) return true;// if you're carrying nothing, you're nude, so return 1 or true
      foreach(local obj in traveler.contents){
           if(obj.isHeldBy(traveler)) iFail = true;
           if(obj.isWornBy(traveler)) iFail = true;
      }   
      local myReturner = (iFail == true) ? nil : true;
      return myReturner;
   }
   explainTravelBarrier(traveler) { "You can\'t go in there carrying posessions with you in the water. You don\'t want your stuff to get wet. ";
   }
;

       
// This is so the player can take a quick bath, vs. the slow route (removing clothes, talking to npc and stuff, etc) i.e. "take bath"
bathHouseBathOuter: Unthing 'bath' 'bath'
  notHereMsg = 'The bath is in the other room. '
  location = bathHouse
  dobjFor(Take) remapTo(Use,bathHouseBathOuter)
  dobjFor(Use){
          verify(){ logicalRank(110,'likely'); }
          check(){ }
          action(){
                local iClothed = nil;
                foreach(local obj in gPlayerChar.contents){
                      if(obj.isWornBy(gPlayerChar)) iClothed = true;
                }
                if(iClothed == true){
                     "You change out of your clothes, take a quick bath, dry off and get dressed again. Now you\'re ready to go to town. ";
                }else{
                    "You take a quick bath then get out and dry off and get dressed again. Now you\'re ready to go to town. ";
                } 
                bathHouseBath.bathingTable.advanceState(); // doScript();//  getScriptState() 
          }
  }
 // bathingTable : StopEventList {
 //         eventList = [
 //                  'You ease yourself down into the warm bath water and begin washing
 //                   your new female body. ',
 //                  'You bathe yourself. '
 //         ]
 // }  
;


bathHouse: ClothingRemovalRoom 
  name = 'changing room'
  desc { "This is a small changing room in a women\'s only ";
         if(bathHouseBath.bathingTable.getScriptState() <= 1){
             "<a href=\"take bath\">bath</a> house";
         }else{
             "bath house";
         }
         ". There are some lockers here and a bench. The way into the bath house is through a door to the ";
         if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
         }else{
                "north"; 
         }
         ". The exit is ";
         if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
         }else{
                "east"; 
         }
         ". ";
  }
  east = yourVillaOuter
  north = doorwayToBath
  in = doorwayToBath
  out = yourVillaOuter
;
+ doorwayToBath :  Passage
  destination = bathHouseMainRoom
  otherSide = doorwayToBathLockers
  vocabWords = '(bath) (house) (bathhouse) doorway/door'
  name = 'door'
  desc = "An open doorway leading into the bathing area of the bath house. "
  travelBarrier = [noBathUntilNude,noBathWithPosessions]
  noteTraversal(traveler) {  
    if(!entered) { 
      "You enter the main bath house. ";
      entered = true; 
    } 
  } 
  entered = nil 
; 
+ bathLockers: Decoration '(pink) (metal) (women\'s) (girl\'s) lockers' 'lockers'
  "Just some pink metal lockers. "
;
+ bathBench: Fixture, Chair '(bath) (bathhouse) (house) (wood) (wooden) bench/chair/seat' 'bench'
  "A wooden bench with nothing really remarkable about it. "
;
+ bathTowel: Thing '(fluffy) (white) (bath) towel' 'bath towel'
  "A fluffy white bath towel. "
;

bathHouseMainRoom: Room 'bathing room'
  desc { "A large bath house. ";
        "You can leave by going ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"out\">out</a>";
        }else{
                "out"; 
        }  
        " (or ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
        }else{
                "south"; 
        }
        "). "; 
  }
  south = doorwayToBathLockers
  out = doorwayToBathLockers
;
+ bathHouseBath: Decoration 'bath' 'bath'
  dobjFor(Take) remapTo(Use,bathHouseBath)
  dobjFor(Use){
          verify(){ logicalRank(110,'likely'); }
          check(){ }
          action(){
                bathHouseBath.bathingTable.doScript();//  getScriptState() 
          }
  }
  bathingTable : StopEventList {
          eventList = [
                   'You ease yourself down into the warm bath water and begin washing
                    your new female body. ',
                   'You bathe yourself. '
          ]
  }  
;
+ doorwayToBathLockers :  Passage
  destination = bathHouse
  otherSide = doorwayToBath
  vocabWords = '(bath) (house) (bathhouse) doorway/door'
  name = 'door'
  desc = "An open doorway leading back into the changing room. "
  noteTraversal(traveler) {  
    if(!entered) { 
      "You leave back into the changing room. ";
      entered = true; 
    } 
  } 
  entered = nil 
; 


noTownWithoutBreakfast: TravelBarrier
   canTravelerPass(traveler) { 
       return (waitress.playerOrderedBreakfast == true); 
   }
   explainTravelBarrier(traveler) { "You should get a bite to eat first before venturing into town. "; 
   }
;

dollyUnzipped : PreCondition
  checkPreCondition(obj, allowImplicit){
        if(dollyCostume.zipped){
            if(dollyCostume.isWornBy(gPlayerChar)){
                  reportFailure('You need someone\'s help unzipping you before you can get out of the dolly costume. ');
            }else{
                  reportFailure('You need to unzip the dolly costume first before wearing it. ');
            }
            exit;
        }
        return nil; // nil is okay - check passed
  }
;

// ** allows for panties and/or bra on 
mostlyNudeToWearCostume: PreCondition
  checkPreCondition(obj, allowImplicit){
      local clothingTally = 0;
      if(gPlayerChar.contents == nil) return true;// if you're carrying nothing, you're nude, so return 1 or true
      foreach(local obj in gPlayerChar.contents){
           if(obj.ofKind(CromexxClothing)){
               if(obj.isWornBy(gPlayerChar)) clothingTally++;
           }       
      }   
      local myReturner = (clothingTally == 0) ? true : nil;
      if(myReturner == nil){
         if(clothingTally == 1){
              if(strangeFemPanties.isWornBy(gPlayerChar)) myReturner = true;
         }else if(clothingTally == 2){
              if(
                 (strangeFemPanties.isWornBy(gPlayerChar)) &&
                 (strangeFemBra.isWornBy(gPlayerChar))
                ) myReturner = true;
         }
      }     
      /* it's not held and we can't take it - fail */
      if(myReturner == nil){
            reportFailure('You need to be mostly nude if not all the way to wear the costume. ', obj);
            exit;
      }
      return myReturner;
   }
;

notHoldingAnythingForCostume: PreCondition
  checkPreCondition(obj, allowImplicit){
      local iFail = nil;
      if(gPlayerChar.contents == nil) return true;// if you're carrying nothing, you're nude, so return 1 or true
      local iTally = 0;
      foreach(local obj in gPlayerChar.contents){
           if(obj.isHeldBy(gPlayerChar)){
               iFail = true;
               iTally++;
           }
      }   
      local myReturner = (iFail == true) ? nil : true;

      if((iTally == 1) && (dollyCostume.isHeldBy(gPlayerChar))) myReturner = true;
      if((iTally == 1) && (pirateWenchCostume.isHeldBy(gPlayerChar))) myReturner = true;
      if(myReturner == nil){ reportFailure('You need to have your hands free before putting on the costume. Try dropping your
                                           posessions first. ');
                             exit;
      } 
      return myReturner;
   }
;

noTownWithoutDollyCostume: TravelBarrier
   canTravelerPass(traveler) { 
       return (dollyCostume.isWornBy(gPlayerChar) == true);
   }
   explainTravelBarrier(traveler) { "You need to be wearing a costume for the celebration. "; 
   }
;

costumeChangingRoom: ClothingRemovalRoom
  name = 'changing room'
  desc { "A small changing room in the costume shop. You can leave here by going ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
        }else{
                "north"; 
        }   
        ". ";
  }
  out = north
  north : TravelWithMessage, ThroughPassage {
        desc = "A door leading out of the changing room. "
        travelDesc {

        }
        destination = costumeShop
        travelBarrier = [basicallyClothed]
  }
;

hermitPoolJerks: Person
  vocabWords = '(pool) (poolside) (side) (stupid) people jerk jerks girl/girls/women/woman'
  name = 'pool side jerks'
  location = poolSide
  isPlural = true
;
+ HermitActorState 
  specialDesc = "A bunch of jerks are here laughing at you. "
  noResponse : ShuffledEventList {
            eventList = [
                      '\"Look at the big fat dolly! Miss Muffett\'s got fleas! Hahahahaha!\"',
                      '\"Where\'s your life preserver, Muffett baby? Hahahahaha!\" ',
                      '\"Real original costume there, stitch-girl. Look at her, she walks like Frankenstein! Hahahahaha!\"',
                      '\"Were\'d you find the doll suit, the city dump? Hey look, I think she\'s molting! Hahahahaha!\"',
                      '\"Hey doll girl, fetch! What\'s the matter, cat got your tongue? Hahahahaha!\" '
            ]
  }
  isInitState = true 
; 

poolSide: OutdoorRoom
  name = 'poolside'
  desc {
        "Patio furniture abounds along this sunny poolside area. The costume shop is to the south across the street. A girls locker room is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
        }else{
                "north"; 
        }   
        ". The boys locker room is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
        }else{
                "east"; 
        }
        ". The costume shop is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
        }else{
                "south"; 
        }
        ". ";
        if(!gPlayerChar.hasSeen(self)){
               "As you look around you realize you are the only one wearing a costume. The guy
               in the bigfoot outfit must have been crazy. You wish now you\'d never listened to
               him.<.p>A young woman with dark hair and brown eyes who\'s wearing a bright yellow
               one-piece swimsuit spots you and laughs, pointing,\"Hey Tina, get a load of Miss 
               Muffett! Hey Miss Muffett baby, where\'s your horse? Hahahahahahaha!\"<.p>\"Hahahahaha! She
               waddles around like she\'s wearing a diaper! Hahahahahaha!\"<.p>\"Hey costume freak. The party\'s
               not until tonight you know.\"<.p>You wag your doll fists at them in anger but it only makes them
               laugh even harder. <i>It might be a good idea to go back to the costume shop and change out of 
               the doll suit before you suffer any more undue embarrassment.</i> ";
        } 
  }
  north : NoTravelMessage {
      travelDesc {
           "You consider going into the girls locker room for a moment but really want to just go back south to the costume shop and
           return this abomination. You\'re on the verge of tears from all the teasing you\'ve got and the sooner you return this awful
           dolly suit the better. ";
      }
  }
  east : NoTravelMessage {
      travelDesc {
           "You can\'t go in there. You\'re not a boy anymore so you don\'t belong. There\'s a girls locker room to the north you can use but 
            right now you feel like just going back and returning this awful costume. ";
      }
  }  
  southwest : NoTravelMessage {
      travelDesc {
            if(dollyCostume.isWornBy(gPlayerChar)){ 
                "You consider going to the plaza for a moment but look back south at the costume shop. You just want to go 
                back and return this stupid thing before all the teasing gets out of hand. ";
            }else{
                "You head back to the plaza. ";
                gPlayerChar.moveIntoForTravel(centerVillagePlaza);
            }
      }
  }
  south : TravelWithMessage, ThroughPassage {
      desc = "A door leading out of the costume shop. "
      travelDesc {
               "Sulking from all the teasing you got you turn back around and shuffle silently away back
               across the street to the costume shop. You hear laughter all the while behind you.<.p>
               You get in the shop and the shop keeper says,\"What? Back already? Oh yeah. The party\'s not
               until tonight. Well you can come pick this up later. Here, I\'ll unzip you.\"<.p>
               You go back to the changing room and change back into your clothes and gather your
               posessions and come back out. You glare at the old man and say,\"Worst costume... ever.\"<.p>
               \"Hey,\" he says shrugging. \"What can I tell you? If you\'d have gotten here sooner the selection
               would have been better but it looks like you waited until the last minute.\"<.p>
               \"You should take that thing out back and burn it. It\'s just awful,\" you say almost breaking
               down into tears over your ordeal just now.<.p>\"Well... it\'s certainly an unusual request, but... okay,\" he
               leaves out a side door with the costume and comes back a few minutes later empty handed. You give him a
               suspicious look and he shrugs and says,\"It\'s taken care of.\"<.p>\"Well that\'s just great,\" you say. \"Now
               what am I supposed to wear for a Halloween costume?\"<.p>\"Beats the heck out of me,\" he says shrugging. \"Guess
               you\'ll have to just make one from scratch or something. How should I know?\"<.p> ";
               hermitShopKeeper.setCurState(hermitKeeperStateTwo);
               dollyCostume.zipped = nil;
               dollyCostume.makeWornBy(nil);
               dollyCostume.moveInto(pixyland);
               strangeFemPanties.moveInto(gPlayerChar);
               strangeFemBra.moveInto(gPlayerChar);
               strangeFemDress.moveInto(gPlayerChar);
               strangeFemShoes.moveInto(gPlayerChar);
               strangeFemPanties.makeWornBy(gPlayerChar);
               strangeFemBra.makeWornBy(gPlayerChar);
               strangeFemDress.makeWornBy(gPlayerChar);
               strangeFemShoes.makeWornBy(gPlayerChar);
               blackLeatherPurse.moveInto(gPlayerChar);
               blackLeatherPurse.makeWornBy(gPlayerChar);
               if(costumeChangingRoom.contents != nil){
                 foreach(local obj in costumeChangingRoom.contents){
                       if(!obj.ofKind(Decoration)){
                             obj.moveInto(gPlayerChar);
                       }
                 }
               }

      }
      destination = costumeShop
   }
;
+ poolsidePatioStuff: Decoration '(patio) (lounge) table tables chair/chairs/furniture' 'patio furniture'
  "Just some lounge chairs and tables here and there. "
;
+ poolsidePool: Decoration '(blue) (painted) (cement) (built-in) (swimming) water pool' 'swimming pool'
  "A large blue painted swimming pool. "
  dobjFor(Enter){
      verify(){ logicalRank(75,'likely'); }
      check(){}
      action(){ 
                   "Now\'s not the time for swimming. ";
                   if(dollyCostume.isWornBy(gPlayerChar)){
                         "You\'d sink like a rock if you went in there with your dolly costume on. ";
                   }
      }
  }
;


escortAgencyLobby: Room 
   name = 'escort agency'
   desc {
          if(!gPlayerChar.hasSeen(self)){
              "As you enter a receptionist looks up and asks,\"Uh... is there a problem?\"<.p>
               You look around to make sure she\'s not talking to someone else. Finding no one you reply,\"Uh... what do you mean by
               that?\"<.p>She looks you over for a moment, judging you based on your current dress and appearance and answers,\"Well 
               just the way you burst in here off the street like that makes me wonder. Are you being treated all right? Is there anything
               the matter?\"<.p>\"Yeah,\" you say putting your foot down with this place. You point outside and say,\"As a matter of fact, 
               there is. There\'s people laughing and picking on me at me out there because of my bad judgement in choosing the right
               costume. ";
               if(gPlayerChar.girlType == 'abysmal'){
                     "I\'m having weird dreams about men. ";
               }else{
                     "I\'m having bad dreams about my mother\'s meat loaf. ";
               }
               "An evil maid in the mansion dumped me off here last night and I\'ve had nothing but trouble ever since setting
               foot on this crazy island and to be quite Frank, I want out.\"<.p>";
               if(gPlayerChar.girlType == 'abysmal'){
                     "The receptionist is quiet for a moment as she takes that all in, then asks,\"What is it about the men, exactly, that\'s
                     been bothering you?\"<.p>";
               }else{
                     "The receptionist is quiet for a moment as she takes that all in, then says,\"We don\'t serve meat loaf. All our food
                     is imported from surrounding countries. We fly it in guaranteed fresh each and every day.\"<.p>";
               }
               "You give her an icy cold stare for a long while then say at last,\"You don\'t get it. You just don\'t get it, do you? ";
               if(gPlayerChar.girlType == 'abysmal'){
                     "I\'m not concerned with the men. ";
               }else{
                     "I\'m not concerned about the meat loaf. ";
               }
               "All I want is to get off this crazy island.\"<.p>";
               inputManager.pauseForMore(true);// better than using just the morePrompt()
               "<HR ALIGN=CENTER NOSHADE><br>";
               "The receptionist thinks about what you said and shakes her head no and says,\"You don\'t realize where you are, do you, dear?
               This whole village is a secret from the world you know and love out there. Few people know of its location. We fly in wealthy
               men from around the world to meet our girls. Girls like you. You should have known that when you signed the contract.\"<.p>
               \"Contract? What contract? I didn\'t sign any contract,\" you argue.<.p>
               She lifts apart a stack of papers, peering down at something and pretending it\'s important, then lowers the stack of papers
               back in place and says,\"We\'ve got it right here.\"<.p>\"You liar! That was nothing!\" you say pointing at her. \"You just
               pretended you found it but all you were really looking at was probably a blank piece of paper.\"<.p>She shakes her head
               no and says,\"Nope. Got it right here and you signed it. Sorry, you can\'t leave. It\'s in your contract.\"<.p>\"Oh, you
               dirty little liar! Let me see that!\" you demand grabbing for the stack of papers but she clutches it all to her chest in
               a bundle.<.p>\"You\'ll muss up my work. I can\'t let you see it. Besides which, reading your contract\'s against your 
               contract,\" she says.<.p>\"Don\'t be ridiculous, woman, let me see that,\" you say slamming your little fists down on the
               counter.<.p>\"No and get out before I\'m forced to alert security and have you dragged out,\" she warns pointing to the
               door.<.p> ";              
          }
          "This is the lobby of the Escort Agency. The strange organization that runs this little village you\'re stuck in. 
           The exit is to the south. ";
   } 
   south : TravelWithMessage, ThroughPassage {
      desc = "A door leading out of the Escort Agency. "
      travelDesc {
               "You head out of the Escort Agency disappointed you were unable to resolve your problem. 
               After awhile you arrive in the center plaza. ";
      }
      destination = centerVillagePlaza
   }
;

hermitSecretary: Female, Person
  name = 'receptionist'
  vocabWords = '(pretty) (beautiful) (young) (blonde) woman girl lady secretary/receptionist'
  location = escortAgencyLobby
;
+ HermitActorState 
  specialDesc = "A pretty blonde secretary sits behind the counter. "
  noResponse = "\"Out I say!\" she points to the door. \"Out or you\'ll be sorry.\" "
  isInitState = true 
; 

hermitShopKeeper: Male, Person
  name = 'shop keeper'
  vocabWords = '(shop) (store) (old) man guy dude boy keeper/owner'
  location = costumeShop
;
+ HermitActorState 
  specialDesc = "A shop keeper stands nearby. "
  noResponse = "\"Just take the costume and go,\" he says. \"I haven\'t got all day.\" "
  isInitState = true 
; 
+ hermitKeeperStateTwo: HermitActorState
  specialDesc = "A shop keeper stands nearby. "
  noResponse = "\"Sorry about your costume troubles. Come back soon!\" the old shop keeper says cheerily. "
;

costumeShop: Room 'costume shop'
  desc {
        "There\'s a wide variety of costumes hanging on the racks in this tiny little
        corner store. <<gPlayerChar.hasSeen(self) ? '' : '\"Those are reserved. You should have
        come by sooner. The only thing we have left in your size is the stuffed dolly one
        over there in the corner,\" the shop keeper says in his scratchy old voice. '>> There
        is a changing room to the south. The plaza is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
        }else{
                "west"; 
        }
        " and the pool is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
        }else{
                "north"; 
        }  
        ". ";
  }
  in = costumeChangingRoom
  west : TravelWithMessage, ThroughPassage {
      desc = "A plaza door leading out of the costume shop. "
      travelDesc {
          if(dollyCostume.location != pixyland){
            "You shuffle out of the costume shop in your dolly suit and out into the plaza. One thing\'s for sure,
            it\'s early morning and already this thing feels hot inside. You glance down as best
            you can at yourself and realize there\'s probably no flap or zipper or pee hole or anything in
            case of an emergency. Communication in this thing is going to be impossible. Whoever designed
            the dolly suit forgot to make the mouth hole large enough to get words through without everything
            sounding all muffled out. You can still breathe but it\'s unbearably hot in here and you want out
            of this ridiculous thing. You hear a diving board being used and discover a swimming pool to the northeast of the plaza.
            You decide to head over there to see what\'s going on. ";
         }else{
            "You head out into the plaza. ";
         }
      }
      destination = (dollyCostume.location != pixyland) ? poolSide : centerVillagePlaza
      travelBarrier = [ (dollyCostume.location != pixyland) ? noTownWithoutDollyCostume : basicallyClothed] 
  } 
  south = costumeChangingRoom
  north : TravelWithMessage, ThroughPassage {
      desc = "A door leading out of the costume shop. "
      travelDesc {
         if(dollyCostume.location != pixyland){
            "You shuffle out of the costume shop in your dolly suit. One thing\'s for sure,
            it\'s early morning and already this thing feels hot inside. You glance down as best
            you can at yourself and realize there\'s probably no flap or zipper or pee hole or anything in
            case of an emergency. Communication in this thing is going to be impossible. Whoever designed
            the dolly suit forgot to make the mouth hole large enough to get words through without everything
            sounding all muffled out. You can still breathe but it\'s unbearably hot in here and you want out
            of this ridiculous thing. You hear a diving board being used and discover a swimming pool nearby.
            You decide to head over there to see what\'s going on. ";
         }else{
            "You head across the street back towards the pool. ";
             // but after hearing laughter still going on you
             // quickly duck into a nearby establishment before anyone realizes you were the person wearing the doll suit 
             // or anything. ";
         }
      }
      destination = (dollyCostume.location != pixyland) ? poolSide : poolSideTwo // escortAgencyLobby
      travelBarrier = [ (dollyCostume.location != pixyland) ? noTownWithoutDollyCostume : basicallyClothed]
   }
   enteringRoom(traveler) { 
      if(
         (dollyCostume.isWornBy(gPlayerChar)) && (dollyCostume.zipped == nil)
        ){
            "The shop keeper spots you coming out of the dressing room and says,\"You look like you could
            use a little help with that.\"<br>\nHe zips up your back and gives you a gentle pat on the shoulder 
            and adds,\"Have fun now.\" ";
            dollyCostume.zipped = true;
      }
   }
;
+ Decoration '(assorted) (rented) (reserved) costume*costumes' 'reserved costumes'
  "You check out the reserved costumes for awhile, whishing you\'d gotten here sooner but nothing
  seems to strike your fancy. "
  isPlural = true
;
+ dollyCostume: AdvancedCromexxClothing
  weight = 10
  bulk = 10
  name = 'dolly costume'
  vocabWords = '(yellow) (blonde) (blond) (haired) (black) (button) (eyed) (raggedy) (rag) (raggy) (anne) (ann) (stuffed) (body) (Miss) (mrs.) muffett mufett muffet doll dolly suit costume'
  sayBeforeTravel {
           say(rand('Your big flippity-floppity dolly legs shuffle a bit as you walk.<.p>',
                    '','','',
           ));
  }    
  beforeAction() {
        if(gAction.ofKind(WearAction)){
             if(dollyCostume.isWornBy(gPlayerChar)){
                  "You can\'t wear anything over the dolly costume. ";
                  exit;
             }
        }
        if(gAction.ofKind(OpenAction)){
             if(dollyCostume.isWornBy(gPlayerChar)){
                  "You can\'t manage opening things with your big floppy rag doll hands. ";
                  exit;
             }
        }
        if(gAction.ofKind(CloseAction)){
             if(dollyCostume.isWornBy(gPlayerChar)){
                  "You can\'t close anything too well with your big floppy rag doll hands. ";
                  exit;
             }
        }        
        if(gAction.ofKind(TakeAction)){
             if(dollyCostume.isWornBy(gPlayerChar)){
                  "You can\'t take anything while wearing the dolly costume. The arms, hands and fingers
                  are too cumbersome to manipulate objects too well. ";
                  exit;
             }
        }
        if(gAction.ofKind(HelloAction) || gAction.ofKind(GoodbyeAction) || gAction.ofKind(TalkToAction) ||
           gAction.ofKind(YesAction) || gAction.ofKind(NoAction) || gAction.ofKind(AskForAction) ||
           gAction.ofKind(AskAboutAction) || gAction.ofKind(TellAboutAction) || gAction.ofKind(AskVagueAction) ||
           gAction.ofKind(TellVagueAction) || gAction.ofKind(YellAction)
          ){
             if(dollyCostume.isWornBy(gPlayerChar)){
                  dollyCostume.dollyMumble.doScript();
                  exit;
             }
        }
  }
  dollyMumble: ShuffledEventList {
      eventList = [
                  '\"Mmmmmmmph mmmmmmmmmmmph!\" you manage. Seems like communication\'s going to be a bit
                  of an issue. There\'s no way anybody\'s going to understand you while you\'re wearing this
                  dolly suit. ',
                  '\"Nmmmmmmmmmmmmmmmmmmm!\" you say with some difficulty. ',
                  '\"Mmmmmm nmmmmmm nmmmmminnnnnnnn!\" you say in a muffled voice. ',
                  '\'Gggggnnnnnn bnnnnnnnnn drrrrrrrrrrninnnnnnnnnnnn!\" you say flailing your big floppy doll arms about uselessly. ',
                  '\'Vvvvvvgnibit brrrrrrrrrrrrrrrrn drrrrrrrrrrrr drnnnn dinnnnnnnn dunnnnnn!\" you say with a shrug. It\'s pretty
                  hopeless. No one\'s going to be able to hear you through all that material. The dolly suit\'s not designed for
                  easy communication. ',
                  'Bpppppt! Pffffft! NNnnnnnnnnmmmmmmmmmnnnnnnnnnn blrrrrr grrrrnnnn rrr!\" you say hopping up and down in the dolly suit. '
      ]
  }
  desc {
         if(dollyCostume.isWornBy(gPlayerChar)){
              "A great big stuffed dolly costume that you\'re wearing. ";
         }else{
              "A great big stuffed dolly costume with a zipper in the back. ";
         }
         if(dollyCostume.zipped == true){
             "It\'s zipped up. ";
         }
         "She has long red yarn hair, button eyes with tiny little eye holes
         and has a big red dress on. Her black shoes and white socks are actually cloth
         patterns sewn into the doll. ";
  }
  girl_only = 1
  clothLevel = 12 // dress
  zipped = nil
  dobjFor(Wear){
       preCond=[touchObj,objHeld,objNotWorn,dollyUnzipped,mostlyNudeToWearCostume,notHoldingAnythingForCostume]
       verify(){ inherited; }
       check(){ inherited; }
       action(){ inherited; }
  }
  dobjFor(Doff){
       preCond=[dollyUnzipped]
       verify(){ inherited; }
       check(){ inherited; }
       action(){ inherited; }
  }
  dobjFor(Zip){
       verify(){ logicalRank(110,''); }
       check(){ if(self.zipped){
                     "It\'s already zipped up. ";
                }
                if(self.isWornBy(gPlayerChar)){
                     "You\'ll need somebody\'s help zipping up the back. You can\'t quite reach the
                     zipper. The doll costume\'s arms are too big and bulky to reach back around and
                     the doll fingers are too thick to work the zipper. ";
                     exit;
                }
       }
       action(){
                "You zip up the back of the doll costume. ";
                self.zipped = true;
       }
  }
  dobjFor(Unzip){
       verify(){ logicalRank(110,''); }
       check(){
               if(self.isWornBy(gPlayerChar)){
                    "You\'ll need somebody\'s help unzipping you. The doll arms are too big and bulky
                    to reach back there and the doll fingers are too thick to manage the zipper. ";
                    exit;
               }
       }
       action(){
               "You unzip the back of the doll costume. ";
               self.zipped = nil;
       }
  }
  dobjFor(Enter) remapTo(Wear,dollyCostume)
  dobjFor(GetOutOf) remapTo(Doff, dollyCostume)
  
;


// ** restaraunt 
tiffys: Room 
   name = 'tiffy\'s'
   bigfootSeen = nil
   desc { "A neat little mom and pop restaraunt on the edge of town. There are enough
           booths in here to seat over sixty people but right now the restaraunt\'s a
           bit slow. There is a booth here. The exit is to the ";
          if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
          }else{
                "north"; 
          }  
          ". ";
   }
   north : TravelWithMessage, ThroughPassage {
      desc = "A door leading out of the restaraunt. "
      travelDesc {
            if(tiffys.bigfootSeen == nil){
                 "You walk further down the hilly street into town. Along the way you spot
                 a strange man wearing a bigfoot costume who greets you,\"Hey there. What? No costume for
                 the big Halloween celebration?\"<br>\nYou look down at yourself and don\'t have the courage to tell him
                 your girl body <i>is</i> your costume. Instead you shrug and say no.<br>\n\"Well then,\" he says. \"Costume 
                 shop\'s just around the corner to the east of the plaza. The Escort Agency\'s footing the bill you know, so you really
                 have no excuse. Go get yourself a costume.\"<.p> ";
                 // <br>\nYou follow his direction and locate the costume
                 // shop. The door jingles as you enter.<.p> ";
                 tiffys.bigfootSeen = true;
            }else{
                 "You leave the little restaraunt.<.p> ";
            }
      }
      destination = centerVillagePlaza // costumeShop
      travelBarrier = [noTownWithoutBreakfast]
   }
;
+ Odor 'strong bacon fried egg eggs breakfast cooking smell/scent' 'cooking'
  descWithSource { 
            "Smells like bacon and eggs cooking. ";
  }
  hereWithSource = descWithSource
  displaySchedule = [2, 3, 3, 5] 
  noLongerHere = "The smell of cooking diminishes a little. "
; 
+ tiffysBoothChair: Chair 'chair/booth' 'chair'
  "A chair in a booth at Tiffy\'s restaraunt. "
  isListed = nil
;
+ tiffysTable: Fixture, Surface '(booth) (brown) (wood) (wooden) table' 'table'
  "A brown wooden table. "
;
++ tiffysMenu: Readable, Thing '(tiffy\'s) (green) (plastic) (breakfast) menu' 'menu'
  "Tiffy\'s Menu. You may <a href=\"read menu\">read</a> it if you\'d like. "
  readDesc = "There are many items on the menu but these catch your eye:<br>\n
              1. Bacon and eggs with a side of hashbrowns and toast.<br>\n
              2. A stack of buttermilk pancakes<br>\n
              3. Oatmeal and toast<br>\n
              4. Dieter\'s special: Yogert and fresh fruit<br>\n
              You may <a href=\"order food\">order</a> when ready. 
             "
;

noBarInBathingSuit: TravelBarrier
   canTravelerPass(traveler) { 
       return (strangeBathingSuit.isWornBy(gPlayerChar) != true);
   }
   explainTravelBarrier(traveler) { "You can\'t go walking in the bar dressed in your bathing suit. You should go back and change your clothes first. "; 
   }
;

centerVillagePlaza: OutdoorRoom 'plaza'
    desc { 
            "This is the center plaza of the little village. To the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
            }else{
                "north"; 
            }  
            " is the Escort Agency. To the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
            }else{
                "east"; 
            }  
            " is the costume shop. To the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"northwest\">northwest</a>";
            }else{
                "northwest"; 
            }  
            " is Lilliputian\'s. To the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"southeast\">southeast</a>";
            }else{
                "southeast"; 
            }
            " is the beauty parlor. To the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
            }else{
                "south"; 
            } 
            " is Tiffy\'s. The road to the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
            }else{
                "west"; 
            }  
            " leads back to your villa and the jungle is to the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"southwest\">southwest</a>";
            }else{
                "southwet"; 
            }  
            ". A little sign here displays a map of the village.<.p> ";
          townMapSign.readDesc();
  }
  south = tiffys
  north : TravelWithMessage, ThroughPassage {
        desc = "A gate leading into the swimming pool area. "
        travelDesc {
              if(dollyCostume.location != pixyland){
                   "You have no reason to visit the escort agency right now. Maybe you should check out the costume shop first like
                   the guy in the bigfoot costume suggested. Best get a costume while you can. Halloween\'s tonight. ";
                   exit;
              }
              "You walk into the swimming pool area. ";
        }
        destination = escortAgencyLobby
  }
  east = costumeShop // poolSideTwo
  west = yourVillaOuter
  northeast : TravelWithMessage, ThroughPassage {
        desc = "A gate leading into the swimming pool area. "
        travelDesc {
              if(dollyCostume.location != pixyland){
                   "You have no reason to visit the swimming pool just yet. Maybe you should check out the costume shop first like
                   the guy in the bigfoot costume suggested. Best get a costume while you can. Halloween\'s tonight. ";
                   exit;
              }
               "You walk into the swimming pool area. ";
        }
        destination = poolSideTwo 
  }
  northwest : TravelWithMessage, ThroughPassage {
        desc = "A door leading into the bar. "
        travelDesc {
              if(dollyCostume.location != pixyland){
                   "You have no reason to visit the bar right now. Maybe you should check out the costume shop first like
                   the guy in the bigfoot costume suggested. Best get a costume while you can. Halloween\'s tonight. ";
                   exit;
              }
              "You walk into the bar. ";
        }
        destination = lilliputians
        travelBarrier = [noBarInBathingSuit]
  }
  southeast = beautyParlor
  southwest : NoTravelMessage {
         travelDesc {
               "As you approach the edge of town a couple men in black uniforms turn you back around and say,\"Sorry, miss, but
                the jungle\'s off limits. You\'re not allowed to leave the village. The Master\'s orders.\" ";
         }
  }
  // south = northShoreBeach
; 
+ townMapSign: Readable, Fixture
  name = 'sign'
  vocabWords = '(little) (wood) (wooden) (brown) (town) map sign'
  desc = "A map of the town. You may <a href=\"read map\">read</a> it if you\'d like. "
  readDesc {
           local s = '&nbsp;';
           local s0 = '';
           local i = 0;
           for(i = 0; i < 29;i++) s0 += s;
           s0+='Girls lockers<br>';
           local s1 = '';
           for(i = 0; i < 17;i++) s1 += s;
           s1+='<a href=\"north\">Agency</a>';
           for(i = 0; i < 10; i++) s1+=s;
           s1+='|<br>';
           local s2 = '';
           for(i = 0; i < 7; i++) s2+=s;
           s2+='<a href=\"northwest\">Bar</a>________&nbsp;|&nbsp;________<a href=\"northeast\">Swimming pool</a>____Boys lockers<br>';
           local s3 = '';
           for(i = 0; i < 18;i++) s3+=s;
           s3+='\\|/';
           for(i = 0; i < 12;i++) s3+=s;
           s3+='|<br>';
           local a1 = '<font face=\'TADS-Typewriter\'>' + s0 + s1 + s2 + s3 + '</font>';
           say(a1);
           // ** 
           local s4 = '';
           for(i=0;i< 4;i++) s4+=s;
           s4+='<a href=\"west\">Villas</a>_______Plaza_______<a href=\"east\">Costume shop</a><br>';
           local s5 = '';
           for(i = 0;i < 18;i++) s5+=s;
           s5+='\/|\\<br>';
           local s6 = '';
           for(i = 0; i < 4;i++) s6+=s;
           s6+='<a href=\"southwest\">Jungle</a>_______\/&nbsp;|&nbsp;\\_______<a href=\"southeast\">Beauty parlor</a><br>';
           local s7 = '';
           for(i = 0;i < 15;i++) s7+=s;
           s7+='<a href=\"south\">Restaraunt</a><br>';
           local a2 = '<font face=\'TADS-Typewriter\'>' + s4 + s5 + s6 + s7 + '</font>';
           say(a2);
}           
/*        
   
"<PRE>  
 012345678901234567890123456789012345678901234567890123456789                         
                              fem lockers<br>
             agency..             |<br>
        bar........ | .......swimming-pool----male lockers<br>  
                   \|/            |<br>
 villas-----------plaza-----costume shop<br>
                   /|\<br>            
                  / | \<br>                
            jungle  |  beauty<br>      
                    |
                  tiffys<br>
                   <br>
                 2<br>
               villa<br>
                 |<br>
 bathhouse---front of villa---[east to town]<br>

</PRE> "
 */
;


hermitPoolJerksTwo: Person
  vocabWords = '(pool) (side) (stupid) people jerk jerks girl/girls/women/woman'
  name = 'women'
  location = poolSideTwo
  isPlural = true
;
+ HermitActorState 
  specialDesc = "There\'s the jerks who laughed at you before for wearing your dolly costume. "
  noResponse = "Best not bother with them. They\'re just a bunch of insensitive jerks who don\'t deserve the time of day from you. "
  isInitState = true 
; 

noPoolWithoutSwimSuit : PreCondition
  checkPreCondition(obj, allowImplicit){
        if(strangeBathingSuit.isWornBy(gPlayerChar)){
            local iClothes = 0;
            local iHeld = 0;
            foreach(local obj in gPlayerChar.contents){
                   if(obj.isWornBy(gPlayerChar)) iClothes++;
                   if(obj.isHeldBy(gPlayerChar)) iHeld++;
            }
            if(iHeld > 0){
                   reportFailure('You have no need to carry anything into the pool with you. Try dropping your posessions first. '); 
                   exit; 
            }
            if(iClothes > 1){
                   if(strangeFemBra.isWornBy(gPlayerChar)){
                         reportFailure('You shouldn\'t go in there with your bra on. You\'ll get it all wet and besides, your bathing suit has some cups built in for support. ');
                         exit;
                   }
                   if(strangeFemDress.isWornBy(gPlayerChar)){
                         reportFailure('You\'re dressed way too funny to swim the way you are, besides which you\'d get your dress all wet if you go in there like this. '); 
                         exit;
                   }
                   if(strangeFemShoes.isWornBy(gPlayerChar)){
                         reportFailure('Not with your shoes on! ');
                         exit;
                   }
            }
            return nil;// nil is okay - check passed
        }
        reportFailure('You\'re not about to go swimming in there without first changing into a bathing suit. You\'ll get your clothes all wet. ');
        exit;
  }
;

bottomOfPool: OutdoorRoom
  allowedPostures = [swimming]
  defaultPosture = swimming
  name = 'bottom of pool'
  desc { 
    "You are swimming underwater at the bottom of a swimming pool. ";
    "You can go ";
    if(gameMain.allowHtmlLinks){
                "<a href=\"up\">up</a>";
    }else{
                "up"; 
    }
    " from here. ";
  }
  roomParts = [defaultFloor]
  up = poolSideTwo
  isActorTravelReady(conn) { 
                   if(conn == up) return gActor.posture == swimming;// NOTE: if we DON'T do this, TADS will make the player stand up first by implication!
                   return gActor.posture == standing; 
  }
  enteringRoom(traveler) { 
      bottomOfPool.drowningCounter = 0;// reset the drowning counter
  }
  roomAfterAction(){
            bottomOfPool.drowningCounter++;
            switch(bottomOfPool.drowningCounter){
                   case 1:
                        "You\'re holding your breath. ";
                   break;
                   case 2:
                        "You\'re still holding your breath. ";
                   break;
                   case 3: 
                        "You\'re having difficulty holding your breath. Better swim back <a href=\"up\">up</a> or you\'ll drown. ";
                   break;
                   case 4:
                        "You\'re really having trouble holding your breath. ";
                   break;
                   case 5:
                        "You are drowning! ";
                   break;
                   case 6:
                        "You pass out from lack of oxygen...<.p> ";
                        inputManager.pauseForMore(true);// better than using just the morePrompt()
                        "<HR ALIGN=CENTER NOSHADE><br>";
                        if(bottomOfPool.almostDrowned == nil){
                            bottomOfPool.almostDrowned = true;
                            gPlayerChar.moveIntoForTravel(poolSideTwo);
                            gPlayerChar.makePosture(lying);
                            "<.p>You wake up lying on your back beside the pool. A tall dark and handsome man is giving you mouth to mouth resuscitation 
                            and a small crowd of people has gathered around. He turns to them and says,\"It\'s okay. She\'s all right now.\"<.p>\"I... huh? What
                            happened?\" you ask weakly.<.p>\"You almost drowned. If I hadn\'t jumped in when I did you\'d probably wouldn\'t have made it,\" the 
                            man replies.<.p>\"Wow, you saved my life! Is there anything I can ever do to repay you?\" you ask.<.p>He shakes his head no and 
                            says,\"Just don\'t go swimming again until you\'re a little more experienced. You had us all scared to death you\'d drowned.\"<.p>";
                            if(gPlayerChar.girlType == 'abysmal'){
                                 "You feel that strange abysmal part of you take over and you find yourself suddenly longing for the man who saved your life.
                                 You feel like you\'d do just about <i>anything</i> for him, anything at all and you feel madly in love. You can\'t stop the words
                                 now coming out of your mouth. \"Will you... will you marry me?\" you ask.<.p>He chuckles and shakes his head no and says,\"Sorry but
                                 I\'ve already got a girlfriend at the moment.\"<.p>\"Gee, that\'s too bad. I was kind of hoping to... you know... <i>repay</i> you,\" you say
                                 licking your lips seductively.<.p>He looks around, perhaps to see if his girlfriend is near, then turns to you and whispers,\"Meet me
                                 in the bar later on and we\'ll talk, okay?\"<.p>You nod yes and he quickly leaves the area and the crowd dispurses. ";
                                 lilliputians.heroWaiting = true;
                            }else{
                                 "You thank him as the crowd dispurses and you sit up. ";
                                 gPlayerChar.makePosture(sitting);
                            }
                        }else{
                               "You have drowned to death!<.p>Oh my, it seems that you have died. I can try and reincarnate you if you\'d like but I\'m not very
                               good at this. There\'s a chance you won\'t come back quite the same as before. ";
                               local iDone = 0; 
                               local s0 = '';
                               do{
                                            "<br>Do you wish for a reincarnation? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
                               }while(iDone==0);
                               if(s0 == 'n' || s0 == 'no'){
                                           finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                                           exit;
                               } 
                               idolOfZakra.moveInto(treasureChest);
                               treasureChestKey.moveInto(mastersDrawer);
                               gameMain.is_a_zombie = nil;
                               zombieBooth.hasUsed = nil;
                               me.pcHeight = '5\' 3\"';
                               "You are engulfed in a cloud of orange smoke....cough....cough....choke................choke.....<.p>";
                               inputManager.pauseForMore(true);// better than using just the morePrompt()
                               "...when the smoke clears you are someplace else.<.p> ";
                               local iForm = rand(100)+1;
                               if(iForm > 20){
                                           "You are standing in the woods on all fours. You are an adolescent female deer.<.p>
                                           From the look of your surroundings you would guess that you\'re many kilometers away from the island you were on 
                                           in the mountain lake. ";                                            
                                           setPlayer(doe);//see end of actor.t file for this command **** NOTE: this is better than just-> libGlobal.playerChar = actor; (because it does a PoV remap too)
                                           exit;
                               }else{
                                           "You are sitting on a white carpeted floor in a pink walled bedroom. You glance down at yourself and
                                           notice you have little hands, little fingers and little feet in little shoes. You\'re wearing a little white
                                           play dress and are carrying a baby doll.<.p>It looks like you\'ve reincarnated as a little girl. I\'m sorry but 
                                           I did warn you I\'m not very good at these. Unfortunately this only makes things worse for your ever being able to
                                           change back into a man again. Looks like this is....<b>The End</b> ";
                                           finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                                           exit;
                               }
                         }
            }
            // if(gActionIs(Look) || gActionIs(Examine)){ }
  }
  actorTravelingWithin(origin, dest){
              if(dest == bottomOfPool){
                   bottomOfPool.drowningCounter = 0;
              }
  }
  drowningCounter = 0
  almostDrowned = nil
;
+ lockerKey: Key
  name = 'small brass key'
  vocabWords = '(small) (brass) (girl\'s) (women\'s) (locker) (room) key'
  desc = "A small brass key. "
  dobjFor(Take){
     verify(){ inherited; }
     check(){ inherited; }
     action(){ 
           poolsideShiny.moveIntoForTravel(pixyland);// hide the decoration object
           inherited;
     }
  }
;


doeLandOne: OutdoorRoom 'forest'
   "There are pine trees everywhere here in the hilly woods. Exits lead in all directions. "
   south : NoTravelMessage {
      travelDesc {
           "You travel for a bit in the woods on your cute little doe hooves. ";
      }
   }
  up = south
  down = south
  north = south
  east = south
  west = south
  northwest = south
  northeast = south
  southwest = south
  southeast = south
  roomAfterAction(){
      doeLandOne.doeLandCounter++;
      if(doeLandOne.doeLandCounter >= 5){
            "Well, it certainly seems you\'re on your way to a bright new future as a pretty little woodland creature. 
            Unfortunately you are now unable to stop the mad scientist on the island from carrying out his diabolical plans. 
            Better luck next time.<br><b>The End</b> ";
            finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
            exit;
      }
  }
  doeLandCounter = 0
;
+ doeLandTrees: Decoration '(pine) tree*trees' 'trees'
    "Just some trees in the forest. "
;
+ SimpleOdor 'wolves wolf danger' 'danger'
  "You smell danger nearby. "
; 
+ SimpleNoise 'wolf wolves sound/sounds' 'sound'
  "You hear the sound of wolves off in the distance. "
; 


doe: Female, Person 
  location = doeLandOne
  name = 'doe'
  vocabWords = 'girl female me/myself/doe/deer'
  desc = "Thanks to a botched reincarnation you are an adolescent doe. "
  beforeAction() {
        if(gAction.ofKind(HelloAction) || gAction.ofKind(GoodbyeAction) || gAction.ofKind(TalkToAction) ||
           gAction.ofKind(YesAction) || gAction.ofKind(NoAction) || gAction.ofKind(AskForAction) ||
           gAction.ofKind(AskAboutAction) || gAction.ofKind(TellAboutAction) || gAction.ofKind(AskVagueAction) ||
           gAction.ofKind(TellVagueAction) || gAction.ofKind(YellAction)
          ){
                "All that comes from your mouth is a cute little \"bleet\" - the cry of a doe. Too bad, you\'ve lost the
                ability to talk due to this reincarnation. ";
        }
  }
;
+ FemaleBodyPart 
  vocabWords = '(cute) (little) (female) (my) (your) (doe) hoof*hooves'
  name = 'hooves'
  desc = "You\'ve got cute little doe hooves. "
;
+ FemaleBodyPart
  vocabWords = '(cute) (little) (doe) (girls) (girl\'s) (female) genetalia genitals vagina/pussy/cunt/slit/crotch'
  name = 'doe vagina'
  isPlural = true
  counter = 0
  desc { "You swing your cute little doe head down under your body and gaze at your female genetalia. 
         You wonder if now <i>all</i> your reincarnations, human or animal, will be on the female side of
         the fence. ";
  }
  dobjFor(Feel){
          precond = [objHeld]
          verify(){ illogicalNow('You have no hands to feel it with. ', 50); }
          check(){ }
          action(){ }
  }
  dobjFor(PlayWith) remapTo(Feel,self)
  dobjFor(Rub) remapTo(Feel,self)
;

noSwimWithoutBathingSuit: TravelBarrier
   canTravelerPass(traveler) { 
       return (strangeBathingSuit.isWornBy(gPlayerChar) == true);
   }
   explainTravelBarrier(traveler) { "You need a bathing suit on before you can swim. "; 
   }
;

poolSideTwo: OutdoorRoom
  name = 'poolside'
  desc {
        "Patio furniture abounds along this sunny poolside area. The costume shop is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
        }else{
                "south"; 
        }  
        " across the street. To the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"southwest\">southwest</a>";
        }else{
                "southwest"; 
        }  
        " is the plaza. There is a girls locker room to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
        }else{
                "north"; 
        }  
        " while the boys locker room is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
        }else{
                "east"; 
        }  
        ". <<(poolsideShiny.location == poolSideTwo) ? 'You see something shiny at the bottom of the pool. ' : ''>> ";
  }
  south  = costumeShop
  //: NoTravelMessage {
  //    travelDesc {
  //         "You don\'t need to go back to the costume shop right now. They don\'t have anything for you there anyway. ";
  //    }
  // }
  east : NoTravelMessage {
      travelDesc {
           "You can\'t go in there. You\'re not a boy anymore so you don\'t belong. There\'s a girls locker room to the north you can use if you\'d like. ";
      }
  }  
  southwest = centerVillagePlaza
  north = girlsLockerRoom
  enteringRoom(traveler) { 
      if( (lockerKey.location == bottomOfPool) &&
          (poolsideShiny.location != poolSideTwo)
        ){
           poolsideShiny.moveIntoForTravel(poolSideTwo);
      }
  }
;
+ poolsidePatioStuff2: Decoration '(patio) (lounge) table tables chair/chairs/furniture' 'patio furniture'
  "Just some lounge chairs and tables here and there. "
;
+ poolsideShiny: Decoration 'shiny brass object thing' 'shiny object'
  "You can\'t tell what it is. It\'s a shiny brass object down at the bottom of the pool. Perhaps you can <a href=\"swim down\">swim down</a> and have a look. "
;
+ poolsidePool2: Fixture, RestrictedContainer, Booth 
  isListed = nil
  down : TravelWithMessage, ThroughPassage {
        desc = "A swimming pool. "
        travelDesc {
               "You swim to the bottom of the pool. ";
        }
        destination = bottomOfPool
        travelBarrier = [noSwimWithoutBathingSuit]
  }
  contentsListedInExamine = nil // do NOT list contents in examine
  validContents=[me,fountainWater,brassLantern]
   /* Here we override the "cannotPutInMsg" function 
    * to say something than the default "&cannotPutInRestrictedMsg" library message.
    */
  cannotPutInMsg(obj) { 
           // you MUST send local TEMPORARY objects or bad things could happen
           local oSelf = self;
           local actor = gActor;
           gMessageParams(actor,obj,oSelf);// this sets variables for use with msg params
           // note the "\^" below is used to capitalize the next first letter encountered...
           local oWho = (gActor == gPlayerChar) ? 'you' : gActor.name;
           local s0 = '\^An invisible force blocks ' + oWho + '{subj actor} from 
           putting {that obj/him} in {the oSelf/him}. Evil magic is likely at work here. ';
           return s0;
  }
  iobjFor(PutIn) maybeRemapTo((gDobj!=nil),ThrowAt,gDobj,fountainWater)
  iobjFor(PutOn) maybeRemapTo((gDobj!=nil),ThrowAt,gDobj,fountainWater) 
  dobjFor(Drink) remapTo(Drink,fountainWater)
  dobjFor(Taste) remapTo(Taste,fountainWater)
  dobjFor(Smell) remapTo(Smell,fountainWater)
  dobjFor(Feel) remapTo(Feel,fountainWater)
  iobjFor(ThrowAt) maybeRemapTo((gDobj!=nil),ThrowAt,gDobj,fountainWater)
  allowedPostures = [swimming]
  defaultPosture = swimming
  vocabWords = '(blue) (painted) (cement) (built-in) (swimming) pool'
  name =  'swimming pool'
  desc = "A large blue painted swimming pool. <<(lockerKey.location == bottomOfPool) ? 'You notice something shiny at the bottom of the pool. ' : ''>> "
  actorTravelingWithin(origin, dest){
              if(dest == poolsidePool2){
                  if(!strangeBathingSuit.isWornBy(gPlayerChar)){
                        "You can\'t swim in there dressed the way you are right now. Better change into a bathing suit first. ";
                        if(gPlayerChar.location != poolSideTwo) gPlayerChar.moveIntoForTravel(poolSideTwo);
                        exit;
                   }
              }
  }
  isActorTravelReady(conn) { 
                   if(conn == down) return gActor.posture == swimming;// NOTE: if we DON'T do this, TADS will make the player stand up first by implication!
                   return gActor.posture == standing; 
  }
  swamInPool = nil
  dobjFor(SwimIn){
          preCond = [noPoolWithoutSwimSuit]
          verify(){ }
          check(){ 
                   if(gPlayerChar.posture == swimming){
                           "You are already swimming in the pool. ";
                           exit;
                   }
          }
          action(){ 
                   "You climb in the pool for a swim. ";
                   gPlayerChar.moveIntoForTravel(poolsidePool2);
                   gPlayerChar.makePosture(swimming);
                   if(strangeFemPanties.isWornBy(gPlayerChar)){
                           if(strangeFemPanties.isWet == nil){  
                                    strangeFemPanties.isWet = true;
                                    "Uh oh, you\'ve gotten your panties all wet! ";
                           }
                   }
          }
  }
;
+ fountainWater: FillMedium, Fixture
  name = 'water'
  disambigName = 'pool water'
  vocabWords = '(quite) (refreshing) (funny) (tasting) (swimming) (pool) (fountain) (fountain\'s) chlorine water'
  desc = "Just ordinary water in the pool. "
  material = glass // water's surface acts like glass
  // ** handle "take <something> from water"
  // iobjFor(TakeFrom) maybeRemapTo((gDobj!=nil),TakeFrom,gDobj,poolsidePool2)
  // ** handle "put <something> in water"
  // iobjFor(PutIn) maybeRemapTo((gDobj!=nil),PutIn,gDobj,poolsidePool2)
  iobjFor(PutIn) remapTo(PutOn,fountainWater)
  iobjFor(PutOn){
      verify(){ if(gDobj!=nil){
                   poolsidePool2.checkPutDobj(&cannotPutInMsg);
                }
      }
      check(){ }
      action(){
           local oSelf = self;
           local actor = gActor;
           gMessageParams(actor,gDobj,oSelf);// this sets variables for use with msg params
           // note the "\^" below is used to capitalize the next first letter encountered...
           local oWho = (gActor == gPlayerChar) ? 'you' : gActor.name;
           local s0 = '\^' + oWho + '{subj actor} put{s} {subj gDobj}{the/he} on the water....
                      and {subj gDobj}{it/he} sink{s} and vanishes to the bottom of the pool. ';
           say(s0);        
           gDobj.moveInto(bottomOfPool);
      }
  } 
  feelDesc = "It feels wet, just like water should. "
  tasteDesc = "The pool water tastes a bit funny but it\'s still quite refreshing. "
  smellDesc = "The pool water smells faintly of chlorine. "
  iDrankCounter = 0
  iobjFor(ThrowAt){
       verify(){
           if(gDobj!=nil){
               if(gDobj==brassLantern)
                   logicalRank(110,'Good match');
           }
       }
       check(){
           if(gDobj!=brassLantern) {
               /* Object falls short of the target.
                *
                * Here is an example of using the reportFailure's 
                * "params" seperate from the "throwShortMsg(obj,obj)" function.
                * i.e. &throwShortMsg(gDobj,self) seems to be the way to use that
                * function but instead we need to do this:
                *      reportFailure(&throwShortMsg,gDobj,self);
                */
                reportFailure(&throwShortMsg,gDobj,self); // Works!
                exit; // NOTE: exit required as "reportFailure" does not terminate the routine
           }           
       }
       action(){
           if(gDobj==brassLantern){
              brassLantern.moveInto(bottomOfPool);
              mainReport('You throw the brass lantern at the water and it sinks to the bottom of the pool. ',self);
              /* Tads Bug:
               *   if we do NOT put an "exit" command here then Tads
               *   will finish up the Throw command with the message:
               *     "The coin hits the water with no obvious effect,
               *     and falls to the ground. "
               */
              exit; // NOTE: exit required here! 
           }         
       }
  }
  dobjFor(Drink){
          preCond=[touchObj]
          verify(){ logicalRank(110,'yeah you can'); }
          check(){ if(iDrankCounter>5){
                     "You\'re too full from the stuff to stomach any more. You\'d probably
                     get sick anyway if you kept drinking it. ";
                     exit;
                   }
          }
          action(){
              iDrankCounter++;
              "You cup your hands and drink some pool water. The stuff tastes a bit
              funny but is still refreshing none the less. ";
          }
  }
  dobjFor(SwimIn) remapTo(SwimIn,poolsidePool2)
;

noSwimSuitWithBeautyTreatment : PreCondition
  checkPreCondition(obj, allowImplicit){
        if(beautyParlor.treatmentReceived == nil) return nil;// nil is okay - check passed
        if(beautyParlor.treatmentType == '5') return nil; // okay for bad beauty treatment
        reportFailure('You\'re not about to wear that thing and go for a swim after you\'ve already gotten your beauty treatment. You\'ll ruin your hair and face. ');
        exit;
  }
;

girlsLockerRoom: ClothingRemovalRoom
  name = 'girls locker room'
  desc {
          "There are many pink painted <a href=\"examine locker\">lockers</a> in here. 
          There is a large wall mirror where you can examine yourself more closely.
          The exit is to the ";
          if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
          }else{
                "south"; 
          }  
          " back to the swimming area. ";
  }
  south : TravelWithMessage, ThroughPassage {
        desc = "A door leading out of the changing room. "
        travelDesc {
               "You walk back out to the pool area. ";
        }
        destination = poolSideTwo
        travelBarrier = [basicallyClothed]
  }
  out = south
;
+ strangeBathingSuit: AdvancedCromexxClothing
  name = 'girl\'s light blue bathing suit'
  disambigName = 'Lexilah\'s brand light blue pink one piece bathing suit'
  girl_only = true
  teen_only = true
  // these are for 1st person only. there are 3rd person versions too but we don't normally need to worry about that.
  specialWearDesc = "You slip on the one piece bathing suit. It feels really nice and comfy. "
  specialRemoveDesc = "You slip out of the once piece bathing suit. "
  vocabWords = '(sexy) (smooth) (soft) (snug)(tight) (fitting) (Lexilah) (Lexilah\'s) (brand) (teenage) (teenaged) (girl\'s) (women\'s) (lady\'s) (light) (blue) (lightblue) (cotton) (nylon) (rayon) (silk) (silky) (one) (bathing) (swim) one-piece piece suit/swimsuit/bathingsuit'
  desc = "It\'s a girl\'s light blue one piece bathing suit. <<strangeBathingSuit.isWornBy(gPlayerChar) ? 'It looks and feels really nice on you. ' : ''>>"
  wornBy = nil
  //  location = tiffanyMeadows
  clothLevel = 4 // bathing suit
  dobjFor(Wear){ 
          preCond = [objHeld,noSwimSuitWithBeautyTreatment]
          verify(){ inherited; }
          check(){ inherited; }
          action(){ inherited; }
  }   
;
+ girlsLockerRoomMirror: Heavy, Decoration
  name = 'mirror'
  vocabWords = '(girls) (girl\'s) (womens) (women\'s) (ladys) (lady\'s) (locker) (room) (huge) (large) (pretty) (long) (wall) mirror'
  desc = "It\'s a large, long wall mirror. You may <a href=\"look in mirror\">look in</a> it if you\'d like. "
  dobjFor(LookIn){
      verify(){ logicalRank(110,'likely'); }
      check(){
               if(gActor.posture != standing){
                      "You\'ll need to stand up first for a better look. ";
                      exit;
               }
      }
      action(){
               local iClothingCount = 0;
               foreach(local obj in gPlayerChar.contents){
                       if(obj.isWornBy(gPlayerChar)){
                          iClothingCount ++;
                       }
               }
               if(beautyParlor.treatmentReceived == nil){
                      "You look in the mirror and see a beautiful blonde girl standing there staring back
                      at you in your reflection. Your hair\'s mussed up and tangly from your bath this morning.
                      It\'s no wonder the people in the bar were pointing and making comments at you when you
                      walked in. ";
                      exit;
               }
               if(
                  (strangeBathingSuit.isWornBy(gPlayerChar)) &&
                  (poolsidePool2.swamInPool != nil) 
                  ){
                       "You look in the mirror and see a sexy blonde girl in a light blue one-piece bathing suit staring back at you. "; 
                       if(beautyParlor.treatmentType == '5'){
                           "Your swim in the pool seems to have washed off your botched up beauty treatment. ";
                           beautyParlor.treatmentType = '6';
                       }  
                       if(
                           (iClothingCount == 1) &&
                           (gPlayerChar.girlType != 'abysmal')
                          ){
                               "You\'re amazed at how beautiful you look barefoot in a bathing suit like that. ";
                       }
                   
                       if(
                           (iClothingCount == 1) &&
                           (gPlayerChar.girlType == 'abysmal')
                          ){
                                    "You check yourself out, turning this way and that for a moment. You feel a strange overpowering sensation overtake your
                                     senses. Undoubtedly your abysmal side taking over again. You\'re not just looking in the mirror to admire your pretty self,
                                     you\'re making sure you look good for <i>boys</i>. You glance down at your bare feet and stretch out one leg, then the other,
                                     turning it this way and that in the mirror. You run a hand along your thigh to check for any hair or stubble. Nope - don\'t need
                                     to shave your legs. They\'re smooth and pretty and you know guys are gonna love \'em. ";
                       }
                       exit;
               }else if(
                  (strangeBathingSuit.isWornBy(gPlayerChar)) &&
                  (poolsidePool2.swamInPool == nil) 
                  ){
                           if(beautyParlor.treatmentType == '5'){
                                    "Your face and hair looks hideous from your botched up beauty treatment. 
                                    Even still you still look pretty underneith and definately from the neck 
                                    down you\'ve got curves in all the right places. ";
                           }  
                           if(
                             (iClothingCount == 1) &&
                             (gPlayerChar.girlType != 'abysmal')
                             ){
                                     "You\'re amazed at how beautiful you look barefoot in a bathing suit like that. ";
                           }
                           if(
                             (iClothingCount == 1) &&
                             (gPlayerChar.girlType == 'abysmal')
                             ){
                                     "You check yourself out, turning this way and that for a moment. You feel a strange overpowering sensation overtake your
                                     senses. Undoubtedly your abysmal side taking over again. You\'re not just looking in the mirror to admire your pretty self,
                                     you\'re making sure you look good for <i>boys</i>. You glance down at your bare feet and stretch out one leg, then the other,
                                     turning it this way and that in the mirror. You run a hand along your thigh to check for any hair or stubble. Nope - don\'t need
                                     to shave your legs. They\'re smooth and pretty and you know guys are gonna love \'em. ";
                           }
                           exit;
               }
               local s0 = beautyParlor.treatmentType;
               local iAll = nil;
               if((strangeFemPanties.wornBy == gPlayerChar) &&
                  (strangeFemBra.wornBy == gPlayerChar) &&
                  (strangeFemDress.wornBy == gPlayerChar) &&
                  (strangeFemShoes.wornBy == gPlayerChar)) iAll = true;
               local iPurse = (blackLeatherPurse.wornBy == gPlayerChar);
               if((iAll == true) && (s0 != '5')){
                      if(gPlayerChar.girlType != 'abysmal'){
                             "You look in the mirror and see a stunningly beautiful blonde girl standing there staring back
                             at you in your reflection. You can hardly believe she\'s you and that this is what you look like
                             now thanks to your trip through the girling booth. That\'s you there in the mirror. The girl wearing
                             a black dress and high heeled shoes";
                             if(iPurse==true){
                                 " and wearing a purse slung over her shoulder. ";
                             }else{
                                 ". ";
                             }
                             "If you were still a guy and saw a girl like this you\'d find it difficult not to fall in love at first
                             sight. You look even better than your girlfriend Sherrie and she\'s hot but you, you\'re sizzling hot. 
                             Slim, short but not too short and curves in all the right places. Narrow waist, smooth flat tummy, long
                             slender legs, dainty little feet in those cute shiny black pumps. You\'ve got pink lipstick on your lips
                             and the makeup on your face isn\'t over done at all. It\'s just perfect in every way just like the rest of
                             you. "; 
                      }else{
                             "You look in the mirror and see a pretty girl there. You feel strange, overpowering feelings overtake you
                             all of a sudden. <i>That darn \"abysmal\" setting acting up again</i>, you think. Your female reflection in
                             the mirror seems strangely like an old familiar friend even though you realize this isn\'t the real you you\'re
                             looking at but the transformed you. Even still, you feel as though you\'ve seen all this before. So much so that
                             instead of looking for differences between your old self and this one you start turning your head this way and that
                             and pose sideways in profile and spin around trying to look at your back in the mirror. Nothing is out of place.
                             Your face is \"on\" and your hair is done and that\'s all that matters. You quickly turn away even though you\'d
                             like to look at your pretty reflection longer. Any longer look, though, would seem almost perverse. You\'re not in
                             love with <i>you</i>, you realize, you\'re all dolled up like this to attract a <i>man</i> and that\'s what counts...
                             at least that\'s the overpowering feeling going through your head right now but the feeling subsides after awhile 
                             and you regain control of your thoughts and actions. <i>This \"abysmal\" thing\'s going to get me laid by a guy if
                             I\'m not careful</i>, you worry but there\'s nothing you can really do about it now unless you deliberately try avoiding
                             men but you doubt you can pull that off when you\'ve got two different minds at work in your head and one of them\'s clearly
                             female and she\'s the dominant one in your little arrangement. You look back at the mirror to check your hair again. ";
                      }
               }else{
                     "You see a pretty blonde girl in the mirror. ";
               }
               switch(s0){
                      case '1':
                           "You turn your head this way and that and look at your pretty ponytail. The beauty treatment chair did a nice job on you. ";
                      break;
                      case '2':
                           "You turn your head this way and that and look at your pretty pigtail. The beauty treatment chair did a nice job on you. ";
                      break;
                      case '3':
                           "You turn your head this way and that and marvel at your long straight blonde hair. The beauty treatment chair did a nice job on you. ";
                      break;
                      case '4':
                           "You turn your head this way and that and look at your curly blonde hair. The beauty treatment chair did a nice job on you. ";
                      break;
                      case '5':
                           "You look like a clown with makeup smeared all over your face at random. Lipstick lines everywhere and your hair has got that \"Einstein\" look
                           and it\'s not flattering... for a girl anyway. Below the neck you see a beautiful young woman. Everything above that looks like grandma Medusa or
                           worse than the bride of Frankenstein. ";
                           if(gPlayerChar.girlType == 'abysmal'){
                                 "It\'s so bad you start crying until you look away, ashamed of your reflection. ";
                           }else{
                                 "You seem to be rather indifferent to it though, shrugging and realizing the attendant in the beauty parlor was right. This <i>is</i> Halloween after all and
                                 a botched makeup and hair job could be just the thing for a Halloween costume. ";
                           }   
                      break;
                      case '6':
                           " ";// pool fixed botched hair style                                        
               }
      }
  }
;
+ girlsLockers: Decoration '(pink) (painted) (metal) (girls) (womens) (girl\'s) (women\'s) lockers' 'lockers'
  "Some pink painted metal lockers in the locker room. "
;
+ girlsLocker: Fixture, Openable, LockableWithKey, Container 
  name = 'girls locker'
  vocabWords = '(girls) (girl\'s) (women) (womens) (pink) (painted) (metal) locker'
  desc = "A pink painted metal locker. "  
  keyList = [lockerKey]
  initiallyLocked = true
;
++ pirateWenchCostume:  AdvancedCromexxClothing
  name = 'pirate wench costume'
  disambigName = 'Lexilah\'s brand pirate wench costume'
  // these are for 1st person only. there are 3rd person versions too but we don't normally need to worry about that.
  specialWearDesc = "You slip on the pirate wench costume. "
  specialRemoveDesc = "You remove the pirate wench costume. "
  vocabWords = '(Lexilah) (Lexilah\'s) (brand) (red) (black) (pirate) (wench) (wench\'s) (nice) (brass) (buckled) top dress costume suit'
  desc = "A pirate wench costume. It\'s got a black dress with red top. "
  wornBy = nil
  beforeAction() {
        if(gAction.ofKind(WearAction)){
             if(pirateWenchCostume.isWornBy(gPlayerChar)){
                 if(gDobj != nil){
                       if((gDobj != blackLeatherPurse) && (gDobj != strangeFemShoes)){
                             "You can\'t wear anything over the pirate wench costume. ";
                             exit;
                       }else{
                             // okay to wear a purse or shoes
                       }
                 }else{
                             "You can\'t wear anything over the pirate wench costume. ";
                             exit;
                 }
             }
        }
  }
  teen_only = true
  girl_only = 1
  clothLevel = 12 // dress
  dobjFor(Wear){
       preCond=[touchObj,objHeld,objNotWorn,mostlyNudeToWearCostume,notHoldingAnythingForCostume]
       verify(){ inherited; }
       check(){ inherited; }
       action(){ inherited; }
  }
  dobjFor(Doff){
       preCond=[dollyUnzipped]
       verify(){ inherited; }
       check(){ inherited; }
       action(){ inherited; }
  }
  dobjFor(Enter) remapTo(Wear,pirateWenchCostume)
  dobjFor(GetOutOf) remapTo(Doff, pirateWenchCostume)
;


noTownWithoutTreatment: TravelBarrier
   canTravelerPass(traveler) { 
       return (beautyParlor.treatmentReceived == true); 
   }
   explainTravelBarrier(traveler) { "You\'re here to get a beauty treatment. You should do that before going back outside. ";
   }
;

beautyParlor: Room 'beauty parlor'
  desc {
        "This place is state of the art. There\'s chairs in here with little domes that drop down from the ceiling completely 
        covering the head of the chair\'s occupant. Through the little vents in the side you hear the muffled sound of hair
        driers busily at work and the sound of robotic instruments quickly moving busily inside. Amazingly the treatment takes
        only a few minutes and when the domes are removed the woman\'s hair is done and her face is all dolled up with makeup. 
        There is a large mirror mounted on the wall behind the row of chairs. ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"northwest\">Northwest</a>";
        }else{
                "Northwest"; 
        }  
        " out the door is the plaza. ";
  }
  treatmentReceived = nil
  treatmentType = nil // '1' through '5'... ponytail, pigtail, straight, curled, works... '6' is after swimming off the works.
  out = doorwayOutOfBparlor
  northwest = doorwayOutOfBparlor
;
+ doorwayOutOfBparlor :  OneWayRoomConnector 
  destination = centerVillagePlaza
  vocabWords = '(beauty) (parlor) doorway/door'
  name = 'door'
  desc = "An open doorway leading out into the street. "
  travelBarrier = [noTownWithoutTreatment]
  noteTraversal(traveler) {  
    if(!entered) { 
      "You leave the beauty parlor. ";
      entered = true; 
    } 
  } 
  isListed = nil
  entered = nil 
  dobjFor(Enter) remapTo(TravelVia,doorwayOutOfBparlor)
; 
+ beautyParlorMirror: Heavy, Decoration
  name = 'mirror'
  vocabWords = '(beauty) (parlor) (large) (long) (wall) mirror'
  desc = "It\'s a large, long wall mirror. You may <a href=\"look in mirror\">look in</a> it if you\'d like. "
  dobjFor(LookIn){
      verify(){ logicalRank(110,'likely'); }
      check(){
               if((gActor.isIn(beautyChair)) ||
                  (gActor.posture == sitting)){
                      "You\'ll need to stand up first for a better look. ";
                      exit;
               }
      }
      action(){
               if(beautyParlor.treatmentReceived == nil){
                      "You look in the mirror and see a beautiful blonde girl standing there staring back
                      at you in your reflection. Your hair\'s mussed up and tangly from your bath this morning.
                      It\'s no wonder the people in the bar were pointing and making comments at you when you
                      walked in. ";
                      exit;
               }
               local s0 = beautyParlor.treatmentType;
               local iAll = nil;
               if((strangeFemPanties.wornBy == gPlayerChar) &&
                  (strangeFemBra.wornBy == gPlayerChar) &&
                  (strangeFemDress.wornBy == gPlayerChar) &&
                  (strangeFemShoes.wornBy == gPlayerChar)) iAll = true;
               local iPurse = (blackLeatherPurse.wornBy == gPlayerChar);
               if((iAll == true) && (s0 != '5')){
                      if(gPlayerChar.girlType != 'abysmal'){
                             "You look in the mirror and see a stunningly beautiful blonde girl standing there staring back
                             at you in your reflection. You can hardly believe she\'s you and that this is what you look like
                             now thanks to your trip through the girling booth. That\'s you there in the mirror. The girl wearing
                             a black dress and high heeled shoes";
                             if(iPurse==true){
                                 " and wearing a purse slung over her shoulder. ";
                             }else{
                                 ". ";
                             }
                             "If you were still a guy and saw a girl like this you\'d find it difficult not to fall in love at first
                             sight. You look even better than your girlfriend Sherrie and she\'s hot but you, you\'re sizzling hot. 
                             Slim, short but not too short and curves in all the right places. Narrow waist, smooth flat tummy, long
                             slender legs, dainty little feet in those cute shiny black pumps. You\'ve got pink lipstick on your lips
                             and the makeup on your face isn\'t over done at all. It\'s just perfect in every way just like the rest of
                             you. "; 
                      }else{
                             "You look in the mirror and see a pretty girl there. You feel strange, overpowering feelings overtake you
                             all of a sudden. <i>That darn \"abysmal\" setting acting up again</i>, you think. Your female reflection in
                             the mirror seems strangely like an old familiar friend even though you realize this isn\'t the real you you\'re
                             looking at but the transformed you. Even still, you feel as though you\'ve seen all this before. So much so that
                             instead of looking for differences between your old self and this one you start turning your head this way and that
                             and pose sideways in profile and spin around trying to look at your back in the mirror. Nothing is out of place.
                             Your face is \"on\" and your hair is done and that\'s all that matters. You quickly turn away even though you\'d
                             like to look at your pretty reflection longer. Any longer look, though, would seem almost perverse. You\'re not in
                             love with <i>you</i>, you realize, you\'re all dolled up like this to attract a <i>man</i> and that\'s what counts...
                             at least that\'s the overpowering feeling going through your head right now but the feeling subsides after awhile 
                             and you regain control of your thoughts and actions. <i>This \"abysmal\" thing\'s going to get me laid by a guy if
                             I\'m not careful</i>, you worry but there\'s nothing you can really do about it now unless you deliberately try avoiding
                             men but you doubt you can pull that off when you\'ve got two different minds at work in your head and one of them\'s clearly
                             female and she\'s the dominant one in your little arrangement. You look back at the mirror to check your hair again. ";
                      }
               }else{
                     "You see a pretty blonde girl in the mirror. ";
               }
               switch(s0){
                      case '1':
                           "You turn your head this way and that and look at your pretty ponytail. The beauty treatment chair did a nice job on you. ";
                      break;
                      case '2':
                           "You turn your head this way and that and look at your pretty pigtail. The beauty treatment chair did a nice job on you. ";
                      break;
                      case '3':
                           "You turn your head this way and that and marvel at your long straight blonde hair. The beauty treatment chair did a nice job on you. ";
                      break;
                      case '4':
                           "You turn your head this way and that and look at your curly blonde hair. The beauty treatment chair did a nice job on you. ";
                      break;
                      case '5':
                           "You look like a clown with makeup smeared all over your face at random. Lipstick lines everywhere and your hair has got that \"Einstein\" look
                           and it\'s not flattering... for a girl anyway. Below the neck you see a beautiful young woman. Everything above that looks like grandma Medusa or
                           worse than the bride of Frankenstein. ";
                           if(gPlayerChar.girlType == 'abysmal'){
                                 "It\'s so bad you start crying. The attendant comes over and pats you on the back and says,\"There, there... Don\'t fret. It\'ll be all right.
                                 You can always keep it and pretend it\'s part of your Halloween costume.\" But her concern for your feelings doesn\'t help. Instead you cry
                                 even harder until you have to look away entirely, ashamed of your reflection. ";
                           }else{
                                 "You seem to be rather indifferent to it though, shrugging and realizing the attendant\'s right. This <i>is</i> Halloween after all and
                                 a botched makeup and hair job could be just the thing for a Halloween costume. ";
                           }                     
               }
      }
  }
;
+ beautyChair: Fixture, Chair
  name = 'beauty chair'
  vocabWords = '(fine) (black) (leather) (beauty) (parlor) recliner/seat/chair/seats/recliners/chairs' 
  desc = "A fine black leather beauty chair with some controls on the side which you may <a href=\"use controls\">use</a>. "
  dobjFor(Use) remapTo(Use, beautyControls)
  // Use this notification method when gActor enters or exits a nested location like a chair, bed, platform, booth, etc.
  actorTravelingWithin(origin, dest){
           if((origin == beautyParlor) && 
              (dest == beautyChair) &&
              (gActor == gPlayerChar)){
                 "You sit down in the beauty chair. Now you just need to <a href=\"use controls\">use the controls</a>. ";
           } 
  }
;
+ beautyControls: Fixture 
  vocabWords = '(main) (strange) (beauty) (chair) (seat) (recliner) (machine) (device) (invention) (view) key keys keypad keyboard board button buttons lever levers switch switches panel screen viewscreen control*controls' 
  name = 'controls'
  desc = "Simple controls on the side of the chair. You can <a href=\"use controls\">use</a> them if you\'d like. "
  dobjFor(Use){
         verify(){ logicalRank(110,'');
         }
         action(){
               if(beautyParlor.treatmentReceived == true){
                      "There\'s no reason to mess with the controls. You\'ve already had your beauty treatment. ";
                      exit;            
               }
               if(gPlayerChar.location != beautyChair){
                      "You need to be sitting in the chair before you use the controls. ";
                      exit;
               }
               if(gPlayerChar.posture != sitting){
                      "You need to sit down first. ";
                      exit;
               }
               "You use the controls and find there are a few different settings for your hair. ";
               local iDone = 0; 
               local s0 = '';
               do{
                                        "<br>1. ponytail<br>2. pigtail<br>3. straight<br>4. curled<br>5. the works!<br>Enter your selection (1-5): ";
                                        s0 = inputManager.getInputLine(nil, nil);
                                        s0 = s0.toLower();
                                        if((s0 == '1') || 
                                           (s0 == '2') ||
                                           (s0 == '3') ||
                                           (s0 == '4') ||
                                           (s0 == '5')
                                          ){ 
                                              iDone++;
                                          }
                                    
               }while(iDone==0);
               beautyParlor.treatmentReceived = true;
               beautyParlor.treatmentType = s0;
               barWomenOne.moveIntoForTravel(pixyland);
               barMenOne.moveIntoForTravel(pixyland);
               barMenTwo.moveIntoForTravel(lilliputians);
               barWomenTwo.moveIntoForTravel(lilliputians);
               // find the player's hair object and change the description
               local oStrangeFemHair = nil;
               local oHead = nil;
               foreach(local obj in gPlayerChar.contents){
                       if(obj.ofKind(AdultFemaleBlondeHair)) oStrangeFemHair = obj;
                       if(obj.ofKind(AdultFemaleHead)) oHead = obj;
               }
               oHead.headDesc = 'Your face is very pretty with makeup on. You\'re lucky you went to the beauty parlor for that treatment. '; 
               switch(s0){
                     case '1':
                            "You select ponytail as your hair style. The beauty dome slides down over your head, covering it completely
                            and you hear the buzz and spin of robotic istruments hard at work. You feel water jets all around your hair
                            and feel scrubbing then rinsing then brushing. Then a mass of your hair is taken and twirled around and around
                            and you feel a rubber band being placed over it to secure your pony tail.<.p>";
                            oStrangeFemHair.hairDesc = 'Your long blonde hair is done up in a pretty ponytail. ';
                     break;
                     case '2':
                            "You select pigtail as your hair style. The beauty dome slides down over your head, covering it completely
                            and you hear the buzz and spin of robotic istruments hard at work. You feel water jets all around your hair
                            and feel scrubbing then rinsing then brushing. Then a mass of your hair is taken and twirled around and around
                            into a pigtail and you feel rubber bands being placed over it to secure it in place.<.p>";
                            oStrangeFemHair.hairDesc = 'Your long blonde hair is done up in a pretty pigtail. ';
                     break;
                     case '3':
                            "You select straight as your hair style. The beauty dome slides down over your head, covering it completely
                            and you hear the buzz and spin of robotic istruments hard at work. You feel water jets all around your hair
                            and feel scrubbing then rinsing then brushing. The brushing feels really good on your long soft hair.<.p>";
                            oStrangeFemHair.hairDesc = 'You have long, straight blonde hair. It\'s nice and soft and pretty. ';
                     break;
                     case '4':
                            "You select curled as your hair style. The beauty dome slides down over your head, covering it completely
                            and you hear the buzz and spin of robotic istruments hard at work. You feel water jets all around your hair
                            and feel scrubbing then rinsing then brushing. The brushing feels really good on your long soft hair and
                            then you hear little motors twirling your hair up into curlers and then there\'s a loud \"bang!\" and the smell
                            of smoke and the curlers are quickly undone. You feel more hair brushing to tidy things up.<.p>";
                            oStrangeFemHair.hairDesc = 'You have curly blonde hair. It\'s really nice and soft. ';
                     break;
                     case '5':
                            "You select \"the works.\" The beauty dome slides down over your head, covering it completely and you hear
                            gentle music playing and an announcement come in over some speakers,\"Brace yourself honey.\" You hear what sounds
                            like the backfire of a car go off and now you smell smoke. You feel water jets spray your hair and hear a hair
                            drier and feel your hair being brushed. The brushing feels really good on your long soft hair but you hear what sounds
                            like a spring pop and a screw or washer rattle and fall, brushing past your neck and now the machine is completely out
                            of control. Your hair is being brushed out in crazy patterns all over, the hair brush often times bopping you on the head
                            in between brushes, curlers go on, curlers come off, curlers back on again, off again... the machine has gone haywire!<.p>";
                            oStrangeFemHair.hairDesc = 'Your blonde hair has the \"Einstein\" look. It\'s jutting out in every which way direction. You\'re
                            sure to be the laughing stock of the party.';
                            oHead.headDesc = 'The beauty treatment machine smudged makeup randomly all over your face. Quite frankly you look clownish. '; 
               }
               if(s0 == '5'){
                            "You feel the tickle of lipstick go on your lips but now the lipstick is being smudged all over your face and
                            a powder puff is hitting you at random all over your head, even in your hair. You hear the splurt of makeup oozing
                            out of a squirt bottle and dripping down your nose but the powder puff takes it and spreads it everywhere with no trouble
                            at all. You feel a mascara curler on your <i>cheek</i>... This can\'t be good. Now it\'s smudging up and down the left
                            side of your face. Suddenly the dome lifts up off your head and more springs pop out and fall to the ground but an attendant
                            is already picking them up. \"Sorry honey,\" she says. \"Forgot to warn you. There\'s a few bugs in \"the works.\" Happens
                            every time. My apologies but now it looks like the entire system\'s down. Oh well, lucky break, right? It\'s Halloween.\" ";
               }else{
                  "You feel makeup being smudged on your face and the dabbing of powder here and there. Highly sensitive instruments
                   quickly locate your eyelashes and give them a few strokes of mascara, then you feel the cotton swabs of eye shadow being
                   applied at the same time the snip-snip sound of instruments cutting and plucking your eyebrows. You hear perfume being 
                   sprayed as lipstick is being applied to your lips. Suddenly the dome lifts up and off your head and your treatment is
                   complete. ";
               }
         }
  }  
;

beautyDome: Fixture
  location = beautyParlor
  name = 'beauty dome'
  vocabWords = '(beauty) (parlor) (robotic) (fully) (automated) (treatment) (silver) (silvery) (metal) dome*domes'
  desc = "A fully automated beauty treatment dome. There\'s one above each chair in here. "
  dobjFor(Wear){
       verify(){ illogical('It\'s all automated. You don\'t wear the dome. It slides over your head at the push of a button and
                           gives you a beauty treatment. '); 
       }
  }
;

timeTraveler: Male, Person
   name = 'time traveler'
   vocabWords = '(time) (handsome) (attractive) (mr.) (mister) Doctor Harstin Starhawk man guy dude boy traveler/traveller'
   properName = 'Harstin'
   isPropername = nil
   desc = "A man dressed up as a time traveler from a familiar TV series is here. "
   location = pixyland
;
+ timeTravelerTalking: InConversationState
  stateDesc = nil // " " // "A scarecrow is here. "
  attentionSpan = 99 // after x turns he goes back to looking
  nextState = timeTravelerLooking
  specialDesc {inherited; stateDesc; } 
;
++ timeTravelerLooking: ConversationReadyState
  specialDesc {inherited; stateDesc; } 
  stateDesc = nil // "A scarecrow is here. "
  isInitState = true  
;
+++ HelloTopic, StopEventList
  [
    '\"Hi there,\" you say to the man in the time traveler costume.<.p>\"Hello,\" he says looking you up and down. \"I like your
    costume. What are you supposed to be?\"<.p>\"A pirate wench,\" you explain.<.p>\"I like it!\" he says smiling.<.p> ',
    '\"Hi again,\" you say to the scarecrow. \"Ah yes, the pirate wench. How are you?\" he asks.<.p>\"Fine and yourself?\" you ask.<.p>
    \"Just great,\" he replies. '
  ]
;
+++ ByeTopic, StopEventList 
  [ 
    '\"Bye,\" you say to the time traveler.<.p>\"Have fun,\" he says waving. '
  ]  
; 
+++ ImpByeTopic
   topicResponse {
           "\"I\'ll see you... in the future,\" the time traveler says with a shrug. ";
   }
;
++ DefaultAskTellTopic
   topicResponse {
     "\"What do you think about <<gTopic.getTopicText>>?\" you ask.<.p>
      \"Sorry. I don\'t know right now,\" the time traveler replies.<.p> ";
   }
;
++ AskTellTopic @genericTopicTopic 
   topicResponse {
       "Some things you may talk to the time traveler about are: 
       <br><a href=\"ask for dance\">ask for a dance</a>
       <br><a href=\"ask for help\">ask for help</a> 
       <br><a href=\"ask for sex\">ask for sex</a> ";
   }
;
++ AskForTopic @genericDancingTopic
   topicResponse {
       "\"Would you like to dance with me, time traveler?\" you ask.<.p>
       \"I\'d be delighted,\" he says taking your hand and leading you to the dance floor.<.p>
       You both dance for awhile. You\'re a bit new at dancing as a girl but you give it your best shot.
       After a few songs you both return to the bar.<.p>
       \"I\'m not as good as you,\" you admit to him.<.p>He smiles and says,\"I think you did just fine. I like the way you 
       swing your hips.\"<.p> ";
   }
;
++ AskForTopic @genericAskForHelpTopic
   topicResponse {
         "It\'s clear that you need help getting your male body back but are you absolutely <i>sure</i> you
         want to go telling this guy about the trouble you\'re in, including your sex change? ";
         local iDone = 0; 
         local s0 = '';
         do{
                                            "<br>Tell the man in the time travel costume everything and ask for his help? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
         }while(iDone==0);
         if(s0 == 'n' || s0 == 'no'){
                "You decide against it. Maybe better safe than sorry. ";
                exit;
         }
         if(gPlayerChar.girlType == 'abysmal'){
                "You open your mouth to tell him everything but that strange feeling overtakes you and the words don\'t come out
                as planned. \"I... I need your help with... banannas! No, I mean... fruit cocktail. No, I really mean... the mah-muh-muhhhhhh....shun. 
                My bah.... my bahhhhh... my buuuuuuh...deeee.\"<.p>\"What are you saying? You want to be buddies?\" he asks puzzled.<.p>You say,\"No.
                You don\'t understand. I need help with banannas! Darn it, that\'s still not right. What I mean to say is... sex chahhhhhhh... be-nannas!\"
                <.p>\"You\'re not making any sense here. What is it you are trying to say?\" <<boyfriend.properName>> asks.<.p>You take a deep breath and
                try again. \"I\'m having trouble explaining it. I know what I want to tell you but the words don\'t come out,\" you explain. \"I\'m in 
                trouble though and I need your help but I can\'t seem to tell you what trouble I\'m in. You\'d just have to more or less, uh, help, if that
                makes sense.\"<.p>He scratches his head and replies,\"So, let me get this straight. You need me to help you but you can\'t tell me what
                kind of help you need but you want me to try anyway?\"<.p>\"Exactly,\" you say.<.p>\"You still don\'t make any sense!\" he says exasperated.
                \"How can I help you if you won\'t tell me what kind of help you need or what trouble you\'re in?\"<.p>You shrug and say,\"My banannas are
                bread baskets and my watermelons need taking out.\"<.p>He frowns at you, shakes his head and says,\"<<gameMain.femaleFirstName>>, you\'re
                the weirdest girl I\'ve ever met but I still like you anyway. You just need to see a doctor about your brain is all.\"<.p>You hear him mutter
                something under his breath about \"why me.\"";       
         }else{
                "You start out with \"I was a man before\" but he stops you and says,\"You don\'t have to go into that. I know all this already. I\'m a 
                time traveler, remember?\"<.p>";
         }
   }
;
/*

               if(boyfriend.isNerd == true){
                     "<.p>\"I hope not,\" he says. \"I was thinking \"why is Barney the dinosaur purple?\" did they even have purple dinosaurs?
                     I was also thinking of purchasing another action figure for my collection. I was also thinking \"why are you rubbing your foot
                     on my leg?\" Why? What were <i>you</i> thinking?\"<.p>\"<<boyfriend.properName>>!\" you say. \"Can\'t you even take a hint? I was thinking
                     of you and I going someplace nice and private. Maybe someplace with a bed if you can catch my drift.\"<.p>He shakes his head no and says,\"Never
                     on a first date and never before marriage. Mother always told me to watch out for women like you. Once we\'re married and after you cook a nice
                     dinner for me and wash and iron my clothes and do the dishes and make my bed and walk the dog and take out the trash then maybe we can talk about doing the <i>deed</i>. Do you think I even
                     <i>want</i> to be here trying to find a wife? Heck, no! My mother and father sent me here because they said I was getting too old to be living at
                     home and that I needed a wife to take care of me. So here I am and here you are and to tell you the truth I\'d rather be watching a science fiction
                     movie or playing a video game than sitting here in this bar a million miles from home talking to a dumb <i>girl</i>.\"<.p>\"Oh, so you think I\'m
                     dumb do you?\" you ask getting upset with him.<.p>\"I mean... <i>duh</i>! You\'re a blonde. Hello!\" he replies knocking on his forehead.<.p>\"<<boyfriend.properName>>, you\'ll
                     have sex with me and you\'ll love it... <i>or else</i>,\" you threaten him, slipping your hands out of his and grabbing and twisting his arm.<.p>\"Ow! Ow! Uncle! Uncle!\" he cries. \"Okay, okay.
                     I\'ll do it. I\'ll do it.... but I don\'t have to love it.\"<.p>You stomp on his foot and he adds,\"Okay, okay. I\'ll love it already, sheesh!\"<.p>";
                     inputManager.pauseForMore(true);// better than using just the morePrompt()
                     "<HR ALIGN=CENTER NOSHADE><br>\n ";
               }else{
                    "<.p>\"Yes, but do you really think that\'s wise before marriage?\" he asks.<.p>
                    \"You\'re not one of those religious freaks are you?\" you ask and he shakes his head no.<.p>
                    \"Not exactly but if I have sex with you you\'ll have to agree to marry me. Is that a deal?\" he asks. ";
                    local iDone = 0; 
                    local s0 = '';
                    do{
                                            "<br>Will you agree to his terms and marry him for some sex right now? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
                    }while(iDone==0);
                    if(s0 == 'n' || s0 == 'no'){
                            "\"Sorry, no deal,\" you decline.<.p>He asks,\"May I ask why?\"<.p>\"I like to know what I\'m getting into. If you\'re
                            no good in bed why would I want to marry you?\"<.p>He stands to leave and says,\"Why you little Bitch! You sleazy no good whore!
                            So you\'re just going to sleep with every man on the island until you get your way, aren\'t you? Well you can count me out! Goodbye!\"<.p>
                            He leaves. ";
                            boyfriend.moveIntoForTravel(pixyland); 
                    }else{
                            "Your abysmal side jumps at the offer. A sexy, wealthy, attractive man like that - it\'s too good an offer to pass up.
                            You feel yourself cringe inside, screaming, crying for help but your girl side\'s taken over again and reacting just the way
                            a real girl might. Your nipples are all achy, stiff and you feel a wetness growing in your crotch and a happy, yummy feeling
                            inside. This is what <<gameMain.femaleFirstName>> wants but not Jake, the real you, who\'s trapped inside a girl\'s body and
                            currently shoved aside in her head, acting merely as a silent observer. <<gameMain.femaleFirstName>>\'s going to get married
                            and that\'s bad news for Jake. That means going away and likely never coming back to this island. That means no chance of ever
                            changing back into a man again. You hear the words come out of your mouth but you can\'t believe you\'re saying them. \"Yes. That sounds
                            <i>delightful</i> <<boyfriend.properName>>! We\'ve only just met but already I feel like this could definately lead to something more
                            rewarding. Something like marriage. Sure, yeah, okay! Let\'s do it. Let\'s get married.\" ";
                            inputManager.pauseForMore(true);// better than using just the morePrompt()
                            "<HR ALIGN=CENTER NOSHADE><br>\n ";
                            "<.p>He produces an engagement ring from his pocket which he places upon your finger. You hug and kiss him and before you know it you\'re
                            on your way to his villa. You have sex as a woman for the first time but you don\'t remember much. It must have been too much for your 
                            male self to cope with and comprehend so the experience was mostly shoved aside. Before you know it you\'re on a plane ride to get married
                            and start a new life as <<boyfriend.properName>>\'s wife. Your abysmal side gradually trains you into acceptance of your fate, granting you
                            more and more control just so long as you play your role correctly. You never go back to the island. You never get changed back to normal again.
                            For you it\'s too late. It was always too late ever since you selected \"abysmal\" on the girl maker. You wonder what ever became of your 
                            girlfriend Sherrie. Did she miss you? Would she have wanted to get back with you after your vacation was over? Was she secretely seeing someone
                            else? You never find out the answers but you\'ll always wonder. Now you\'re lost in a new life. A female life. Things are much different than
                            before and things will never ever be the same. You eventually find a meager sort of happiness with your new life but there\'s no victory here,
                            just realization that you\'re just another victim of some mad man\'s diabolical plan...<.p><b>The End</b><.p> ";
                            abysmalEndingAchievement.awardPointsOnce();
                            finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);
                    }
               }
         }else{
               "You think about asking him for sex but the whole idea doesn\'t sit well with you. 
               You\'re a woman, sure, and he\'s a man but you just don\'t think that you\'re ready
               to go hopping into bed with a guy. You were a guy before and though experiencing being
               female has been fun so far this whole sex with men thing isn\'t registering with you
               just yet. Maybe the best you can do here is befriend him. Then maybe he can somehow help
               you get your old body back. Then again, going around telling every guy you meet that you 
               used to be a guy... maybe that\'s not such a good idea either. ";
         }
   }
;
*/

scarecrow: Male, Person
   name = 'scarecrow'
   vocabWords = '(scare) (handsome) (attractive) (mr.) (mister) Mark Holgriv man guy dude boy crow/scarecrow'
   properName = 'the scarecrow'
   isPropername = true
   desc = "A man dressed up as a scarecrow is here. "
   location = pixyland
;
+ scarecrowTalking: InConversationState
  stateDesc = nil // " " // "A scarecrow is here. "
  attentionSpan = 99 // after x turns he goes back to looking
  nextState = scarecrowLooking
  specialDesc {inherited; stateDesc; } 
;
++ scarecrowLooking: ConversationReadyState
  specialDesc {inherited; stateDesc; } 
  stateDesc = nil // "A scarecrow is here. "
  isInitState = true  
;
+++ HelloTopic, StopEventList
  [
    '\"Hi there,\" you say to the man in the scarecrow costume.<.p>\"Hello,\" he says looking you up and down. \"I like your
    costume. What are you supposed to be?\"<.p>\"A pirate wench,\" you explain.<.p>\"I like it!\" he says smiling.<.p> ',
    '\"Hi again,\" you say to the scarecrow. \"Ah yes, the pirate wench. How are you?\" he asks.<.p>\"Fine and yourself?\" you ask.<.p>
    \"A bit itchy with all this straw in my costume but what the hay,\" he jokes. '
  ]
;
+++ ByeTopic, StopEventList 
  [ 
    '\"Bye,\" you say to the scarecrow.<.p>\"Have fun,\" he says waving. '
  ]  
; 
+++ ImpByeTopic
   topicResponse {
           "\"Wenches...,\" the scarecrow says with a shrug. ";
   }
;
++ DefaultAskTellTopic
   topicResponse {
     "\"What do you think about <<gTopic.getTopicText>>?\" you ask.<.p>
      \"Sorry. I don\'t know right now,\" the scarecrow replies.<.p> ";
   }
;
++ AskTellTopic @genericTopicTopic 
   topicResponse {
       "Some things you may talk to the scarecrow about are: 
       <br><a href=\"ask for dance\">ask for a dance</a>
       <br><a href=\"ask for help\">ask for help</a> ";
   }
;
++ AskForTopic @genericDancingTopic
   topicResponse {
       "\"Would you like to dance with me, scarecrow?\" you ask.<.p>
       \"I\'d be delighted,\" he says taking your hand and leading you to the dance floor.<.p>
       You both dance for awhile. You\'re a bit new at dancing as a girl but you give it your best shot.
       After a few songs you both return to the bar.<.p>
       \"I\'m not as good as you,\" you admit to him.<.p>He smiles and says,\"I think you did just fine. I like the way you 
       swing your hips.\"<.p> ";
   }
;
++ AskForTopic @genericAskForHelpTopic
   topicResponse {
         "It\'s clear that you need help getting your male body back but are you absolutely <i>sure</i> you
         want to go telling this guy about the trouble you\'re in, including your sex change? ";
         local iDone = 0; 
         local s0 = '';
         do{
                                            "<br>Tell the man in the scarecrow costume everything and ask for his help? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
         }while(iDone==0);
         if(s0 == 'n' || s0 == 'no'){
                "You decide against it. Maybe better safe than sorry. ";
                exit;
         }
         if(gPlayerChar.girlType == 'abysmal'){
                "You open your mouth to tell him everything but that strange feeling overtakes you and the words don\'t come out
                as planned. \"I... I need your help with... banannas! No, I mean... fruit cocktail. No, I really mean... the mah-muh-muhhhhhh....shun. 
                My bah.... my bahhhhh... my buuuuuuh...deeee.\"<.p>\"What are you saying? You want to be buddies?\" he asks puzzled.<.p>You say,\"No.
                You don\'t understand. I need help with banannas! Darn it, that\'s still not right. What I mean to say is... sex chahhhhhhh... be-nannas!\"
                <.p>\"You\'re not making any sense here. What is it you are trying to say?\" <<boyfriend.properName>> asks.<.p>You take a deep breath and
                try again. \"I\'m having trouble explaining it. I know what I want to tell you but the words don\'t come out,\" you explain. \"I\'m in 
                trouble though and I need your help but I can\'t seem to tell you what trouble I\'m in. You\'d just have to more or less, uh, help, if that
                makes sense.\"<.p>He scratches his head and replies,\"So, let me get this straight. You need me to help you but you can\'t tell me what
                kind of help you need but you want me to try anyway?\"<.p>\"Exactly,\" you say.<.p>\"You still don\'t make any sense!\" he says exasperated.
                \"How can I help you if you won\'t tell me what kind of help you need or what trouble you\'re in?\"<.p>You shrug and say,\"My banannas are
                bread baskets and my watermelons need taking out.\"<.p>He frowns at you, shakes his head and says,\"<<gameMain.femaleFirstName>>, you\'re
                the weirdest girl I\'ve ever met but I still like you anyway. You just need to see a doctor about your brain is all.\"<.p>You hear him mutter
                something under his breath about \"why me.\"";       
         }else{
                "You start out with \"I was a man before\" but he stops you and says,\"Pardon?\"<.p>\"I was a man before,\" you say.<.p>He stares at you 
                for a long while, then says,\"You\'re kidding, right?\"<.p>\"No, I really was a man before. I got transformed into a woman in a machine in
                a mansion nearby and I need your help to change back to normal.\"<.p>\"Uh... I think you\'ve had enough to drink. You\'re starting to not make
                any sense at all.\"<.p> ";
         }
   }
;


robot: Male, Person
   name = 'robot'
   vocabWords = '(big) (metal) (plastic) (tall) (handsome) (attractive) (mr.) (mister) Jim Matterson man guy dude boy robot'
   properName = 'a robot'
   isPropername = true
   desc = "A man dressed up as a robot is here. "
   location = pixyland
;
+ robotTalking: InConversationState
  stateDesc = nil // "A robot man is here. "
  attentionSpan = 99 // after x turns he goes back to looking
  nextState = robotLooking
  specialDesc {inherited; stateDesc; } 
;
++ robotLooking: ConversationReadyState
  specialDesc {inherited; stateDesc; } 
  stateDesc = nil // "A robot man is here. "
  isInitState = true  
;
+++ HelloTopic, StopEventList
  [
    '\"Hi there,\" you say to the man in the robot costume.<.p>\"Hello,\" he says looking you up and down. \"I like your
    costume. What are you supposed to be?\"<.p>\"A pirate wench,\" you explain.<.p>\"I like it!\" he says smiling.<.p> ',
    '\"Hi again,\" you say to the robot man. \"Ah yes, the pirate wench. How are you?\" he asks.<.p>\"Fine and yourself?\" you ask.<.p>
    \"I\'m a robot. What can I say? My nuts need screwing,\" he jokes. '
  ]
;
+++ ByeTopic, StopEventList 
  [ 
    '\"Bye,\" you say to the robot man.<.p>\"See you around,\" he says. '
  ]  
; 
+++ ImpByeTopic
   topicResponse {
           "\"See you later I guess,\" the robot man says with a shrug. ";
   }
;
++ DefaultAskTellTopic
   topicResponse {
     "\"What do you think about <<gTopic.getTopicText>>?\" you ask.<.p>
      \"Sorry. I don\'t know right now,\" the robot man replies.<.p> ";
   }
;
++ AskTellTopic @genericTopicTopic 
   topicResponse {
       "Some things you may talk to the robot man about are: 
       <br><a href=\"ask for dance\">ask for a dance</a>
       <br><a href=\"ask for help\">ask for help</a> ";
   }
;
++ AskForTopic @genericDancingTopic
   topicResponse {
       "\"Would you like to dance with me, robot man?\" you ask.<.p>
       \"In this thing? Are you kidding me? I can barely walk let alone dance,\" he replies turning you down.<.p> ";
   }
;
++ AskForTopic @genericAskForHelpTopic
   topicResponse {
         "It\'s clear that you need help getting your male body back but are you absolutely <i>sure</i> you
         want to go telling this guy about the trouble you\'re in, including your sex change? ";
         local iDone = 0; 
         local s0 = '';
         do{
                                            "<br>Tell the man in the robot costume everything and ask for his help? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
         }while(iDone==0);
         if(s0 == 'n' || s0 == 'no'){
                "You decide against it. Maybe better safe than sorry. ";
                exit;
         }
         if(gPlayerChar.girlType == 'abysmal'){
                "You open your mouth to tell him everything but that strange feeling overtakes you and the words don\'t come out
                as planned. \"I... I need your help with... banannas! No, I mean... fruit cocktail. No, I really mean... the mah-muh-muhhhhhh....shun. 
                My bah.... my bahhhhh... my buuuuuuh...deeee.\"<.p>\"What are you saying? You want to be buddies?\" he asks puzzled.<.p>You say,\"No.
                You don\'t understand. I need help with banannas! Darn it, that\'s still not right. What I mean to say is... sex chahhhhhhh... be-nannas!\"
                <.p>\"You\'re not making any sense here. What is it you are trying to say?\" <<boyfriend.properName>> asks.<.p>You take a deep breath and
                try again. \"I\'m having trouble explaining it. I know what I want to tell you but the words don\'t come out,\" you explain. \"I\'m in 
                trouble though and I need your help but I can\'t seem to tell you what trouble I\'m in. You\'d just have to more or less, uh, help, if that
                makes sense.\"<.p>He scratches his head and replies,\"So, let me get this straight. You need me to help you but you can\'t tell me what
                kind of help you need but you want me to try anyway?\"<.p>\"Exactly,\" you say.<.p>\"You still don\'t make any sense!\" he says exasperated.
                \"How can I help you if you won\'t tell me what kind of help you need or what trouble you\'re in?\"<.p>You shrug and say,\"My banannas are
                bread baskets and my watermelons need taking out.\"<.p>He frowns at you, shakes his head and says,\"<<gameMain.femaleFirstName>>, you\'re
                the weirdest girl I\'ve ever met but I still like you anyway. You just need to see a doctor about your brain is all.\"<.p>You hear him mutter
                something under his breath about \"why me.\"";       
         }else{
                "You tell him everything and ask for help. He shakes his head no and says,\"Sorry but I don\'t want anything to do with it. I\'ve given up
                on spooky mansions three years ago. My doctor says it\'s bad for my condition.\"<.p>\"What condition?\" you ask.<.p>\"My phobia of ghosts,\" he
                replies. \"Sounds like that mansion you\'re talking about is jam packed full of \'em and I can\'t go near \'em. I wish I could help. Sorry.\"<.p> ";
         }
   }
;

lilliputians: Room 'Lilliputian\'s'
  desc {
        "The motiff in here is based on the story \"Gulliver\'s Travels.\" High on a shelf encircling the bar is a tiny model
        village. Hanging from the shelf is a row of glasses. In the center of the room is an odd statue of Gulliver tied down
        to the ground with string and surrounded by little people. There is a <a href=\"enter booth\">booth</a> here. The exit 
        is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"southeast\">southeast</a>";
        }else{
                "southeast"; 
        }  
        ". ";
  }
  // destName = 'lilliputians'
  southeast = centerVillagePlaza
  timesVisited = 0
  shownAboutBooth = nil
  shownWorksReaction = nil // bad reaction to messed up beauty treatment
  heroWaiting = nil // if you are saved from drowning and are abysmal the hero waits for you here
  leavingRoom(traveler) { 
         if(beautyParlor.treatmentReceived == nil){
                 "<.p>As you go to leave the bar a woman approaches you and says,\"You should come with me to the beauty parlor. Let\'s get our hair done, okay?\"<.p> ";
                 local iDone = 0; 
                 local s0 = '';
                 do{
                        
                                        "<br>Do you go to the beauty parlor with her? (yes/no) : ";
                                        s0 = inputManager.getInputLine(nil, nil);
                                        s0 = s0.toLower();
                                        if((s0 == 'y') || 
                                           (s0 == 'yes') ||
                                           (s0 == 'n') ||
                                           (s0 == 'no')
                                          ){ 
                                              iDone++;
                                          }
                                       
                 }while(iDone==0);
                 if((s0 == 'y') || (s0 == 'yes')){                     
                      "<br>You decide to go to the beauty parlor. ";
                      gPlayerChar.moveIntoForTravel(beautyParlor);  
                      gPlayerChar.lookAround(true); 
                      exit;
                 }
         }
  }

  enteringRoom(traveler) {
      lilliputians.timesVisited++;
      if((timesVisited == 1) && (beautyParlor.treatmentReceived == nil)){
                 "As you enter the room you get some odd stares from people and you see several
                 people talking amongst themselves about you. Some of them are even pointing at you and
                 commenting. Not just men but women too. One of the women comes up to you and takes you
                 aside quietly and says,\"Honey, don\'t take this the wrong way but you\'ve got to do 
                 something about your hair. Did you just get out of the pool or something? It\'s all a
                 tangly mess. There\'s a beauty parlor just down the street. I\'ll take you there if you
                 want. Believe me, it would be doing you a huge favor.\" ";
                 if(gPlayerChar.girlType == 'abysmal'){
                      "<.p>You feel a blonde moment overcome you and you feel raw emotion overpower your
                      senses so much you are on the verge of tears. You grab your hair and hold some of it
                      before your eyes for a better look. Sure enough it\'s all a mass of tangles. You took
                      a bath this morning but there was no hairbrush around to do your hair and no makeup to
                      do your face. \"Oh-mah-god! Oh-mah-god! Oh-mah-god!\" you cry hopping up and down out
                      of control crying. \"Everyone must think I look like trash! Yes, please, oh yes, please
                      let\'s go to the beauty parlor. You\'ve got to take me right now. Please!\"<.p>
                      The woman pats you on the back and says,\"It\'s okay.... everything will be all right.
                      Don\'t be so upset about it. Your hair just needs a little brushing is all.\"<.p>
                      \"But they were <i>pointing</i> at me, staring and laughing. I saw them,\" you cry as
                      you\'re being led out the door.<.p>\"Don\'t worry about them. It\'s a natural reaction, okay?\"
                      the woman says.<.p>\"But there were cute guys in there. Now I\'ll never have a chance. I\'ll never
                      be able to show my face in there again,\" you cry.<.p>The woman pats you again on the back and
                      says,\"You came here to get married like all us girls did.\"<.p>\"I did?\" you ask puzzled.<.p>
                      \"Yes, silly. We all did and believe me, as beautiful as you are you\'ll have absolutely no 
                      trouble finding a man. Now let\'s get to that beauty parlor and at least get your hair brushed
                      a little.\"<.p> ";
                      gPlayerChar.moveIntoForTravel(beautyParlor);   
                      gPlayerChar.lookAround(true); 
                      exit;
                 }
                 local iDone = 0; 
                 local s0 = '';
                 do{
                                        "<br>Do you go to the beauty parlor with her? (yes/no) : ";
                                        s0 = inputManager.getInputLine(nil, nil);
                                        s0 = s0.toLower();
                                        if((s0 == 'y') || 
                                           (s0 == 'yes') ||
                                           (s0 == 'n') ||
                                           (s0 == 'no')
                                          ){ 
                                              iDone++;
                                          }
                                       
                 }while(iDone==0);
                 if((s0 == 'y') || (s0 == 'yes')){                     
                      "<br>You decide to go to the beauty parlor. ";
                      gPlayerChar.moveIntoForTravel(beautyParlor);  
                      gPlayerChar.lookAround(true); 
                      exit;
                 }
      }else if(beautyParlor.treatmentReceived == nil){
               "You can\'t keep coming in here looking like a mess. Better get yourself to the beauty parlor as soon as possible. ";     
      }else if(
               (beautyParlor.treatmentReceived == true) && 
               (pirateWenchCostume.isWornBy(gPlayerChar))
              ){
               "As you walk in you notice a Halloween party in progress. ";
               attendedHalloweenPartyAchievement.awardPointsOnce();// ** player made it to the Halloween party - increase score for this
               scarecrow.moveIntoForTravel(lilliputians);// add the scarecrow to the party
               robot.moveIntoForTravel(lilliputians);// add the robot to the party
               barWomenTwo.moveIntoForTravel(pixyland);
               barWomenOne.moveIntoForTravel(pixyland);
               barMenOne.moveIntoForTravel(pixyland);
               barMenTwo.moveIntoForTravel(pixyland);
// ** bookmark

      }else if((beautyParlor.treatmentType == '5') &&
               (lilliputians.shownWorksReaction == nil)){
                lilliputians.shownWorksReaction = true;
               "As you walk in the bar everyone seems to look up at once and immediately peals of out of control laughter ensues. 
               People are laughing and pointing at you and the bar goes up in a boisterous commotion.<.p>
               \"Look everyone! The tooth fairy blew a fuse! Hahahahahaha!\"<.p>
               \"Look what the cat dragged in!\"<.p>
               \"Is that your costume or did you put on your makeup in a roller coaster? Hahahahahaha!\"<.p>
               \"I guess she was wrestling a mountain lion in the powder room. Hahahahahaha!\"<.p>
               It\'s most embarrassing. Maybe you should <a href=\"sit in booth\">sit</a> in a booth and hide your face for awhile. ";
      }else if((beautyParlor.treatmentReceived == true) && 
               (lilliputians.shownAboutBooth == nil)){
                lilliputians.shownAboutBooth = true;
               "Now that you\'ve been to the beauty parlor all you need to do is <a href=\"sit in booth\">sit</a> and wait for someone to try
               and pick you up. ";
      }
      
   }
;
+ Decoration '(interesting) (odd)(strange) (weird) (of) statue Gulliver' 'Gulliver'
  "A statue of Gulliver lying on his back and tied down with string. It\'s in the center of the room. "
  properName = 'Gulliver'
  isProperName = true
;
+ Decoration '(rope) string*strings' 'statue strings'
  "They\'re statue strings on the statue of Gulliver in the center of the room. "
;
+ lilliputianBooth: Fixture, Decoration
  name = 'booth'
  vocabWords = '(red) (leather) (bar) (room) booth chair/seat'
  dobjFor(Enter){
     verify(){ logicalRank(105,'likely'); }
     check(){ }
     action(){
             "You enter the booth. ";
             gPlayerChar.moveIntoForTravel(barRoomBoothRoom);
             gPlayerChar.makePosture(sitting);
             gPlayerChar.lookAround(true);
             if(lilliputians.heroWaiting == true){
                   "A tall, dark and handsome man approaches you. It\'s the hero who saved you from drowning!
                   <.p>He smiles and takes a seat opposite you and says,\"Good. I\'m glad you could make it. I\'ve been doing a lot of thinking about this
                   and I\'ve decided I\'d like to take you up on your offer. My girlfriend isn\'t aware of any of this. You can\'t tell anybody about it. This is
                   just between you and me and when you\'re through... <i>rewarding</i> me, you and I go our seperate ways and we never see each other again. Is that
                   understood?\"<.p>You nod yes, feeling your female half take over again. You hear yourself reply,\"I understand. I\'d do <i>anything</i> for you.
                   After what you did for me I\'d really like to do something <i>naughty</i> for you in return.\"<.p>You pucker your lips and make an \"O\" shape with your mouth and flicker your tongue seductively
                   at him. His eyes go wide and he says,\"I think I like what you have in mind.\"<.p>You hear him unzip his fly. The male side of your mind is screaming
                   to get out of this situation right <i>now</i> but your abysmal self is getting really turned on by the idea of sucking his cock and before you know it
                   you\'re under the table on your hands and knees doing just that. Nobody else in the bar seems to know what\'s going on in your private little booth.
                   Your hero even flags down a waitress and orders a beer with you down there. Your male half can\'t take it anymore and you feel yourself pass out. You
                   awaken some time later sitting back at the table with a funny taste in your mouth. Your abysmal self apparently never left consciousness and finished off
                   the act without you. The hero has apparently left already. Your abysmal self is still thinking about the guy who she gave a blowjob to and you feel your 
                   nipples harden and your pussy\'s getting wet.<.p> ";
                   inputManager.pauseForMore(true);// better than using just the morePrompt()
                   "<HR ALIGN=CENTER NOSHADE><br>";
                   lilliputians.heroWaiting = nil;
             }
             pickupLines.myMessageList.curScriptState = 1;
             pickupLines.startMyDaemon();   
     }
  } 
  dobjFor(SitOn) remapTo(Enter,lilliputianBooth)
  dobjFor(SitIn) remapTo(Enter,lilliputianBooth)
;
+ OutOfReach, Decoration 
  vocabWords = '(interesting) (cute) (little) (short) (small) (tiny) model models house houses village town Lilliput' 
  name = 'Lilliput'
  desc ="The tiny town sitting high on a shelf is quite cute but otherwise nothing more than decoration or a conversation piece like
        much of the rest of the interesting things around here. "
  tooDistantMsg = 'You can\'t reach the model town. It\'s high on a shelf. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        return nil;
  }
;
+ OutOfReach, Decoration '(high) shelf' 'high shelf'
  "It\'s a high shelf with a tiny model town on it. It\'s encircling the bar. "
  tooDistantMsg = 'You can\'t reach the high shelf surrounding the bar. It\'s too far out of reach. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        return nil;
  }
;


// pickupLines: RealTimeDaemon // note: do NOT call it as a RealTimeEvent!!! Even though it is one (call it as a RealTimeDaemon or else your program could lock up and crash!)
pickupLines: PromptDaemon
 name = 'pickuplinesAgent'
 eventTime = 1000 // nil // 10000  
 myMessageList : StopEventList { 
                  eventList = [ 
                                new function(){
                                        pickupLines.acceptPickup();
                                }// end function
                                ,'','','','','',
                                new function(){
                                          if(boyfriend.location == gPlayerChar.location){
                                              "<<boyfriend.name>> smiles at you. ";
                                          }else{
                                              "Doesn\'t seem like there\'s going to be any more guys trying to throw pick up lines on you right now.
                                              Maybe you should try someplace else or come back later. ";
                                          }
                                          pickupLines.myMessageList.curScriptState = 1;
                                          pickupLines.stopMyDaemon();   
                                }
                  ]
 }

 acceptPickup {
                                        pickupLines.stopMyDaemon();   
                                        local sHeight = rand('tall','tall','tall','tall','tall','tall','tall','short','tall','tall');
                                        local sBuild = rand('athletic','of average build','of medium build','stocky','fat');
                                        local sHair = rand('dark','black','brown','blond','red');
                                        local iGlasses = rand(nil,nil,nil,nil,nil,nil,nil,nil,nil,true); 
                                        local sName = rand('Stan','Tim','Ted','Nick','Brad','Brett','Dan','Todd','Troy','Sam','Steve','Bart','Jim','Jerry');
                                        local sDesc = '' + sName + '\'s a ' + sHeight + ', ' + sHair + ' haired man ' + sBuild + ((iGlasses)  ? ' with glasses. ' : '. ');
                                        if(iGlasses == true) boyfriend.isNerd = true;
                                        if(sName == 'Jerry') boyfriend.isNerd = true;
                                        if((sBuild == 'stocky') || (sBuild == 'fat')) boyfriend.isNerd = true;
                                        boyfriend.properName = sName;
                                        boyfriend.name = sName;
                                        boyfriend.boyfriendDesc = sDesc;
                                        if((sBuild == 'stocky') || (sBuild == 'fat')){
                                              sDesc += 'He\'s a little on the heavy side. You could definately do better unless you\'re warming up to him because 
                                                       you feel sorry for him or something. ';
                                        }else{
                                              sDesc += (gPlayerChar.girlType == 'abysmal') ? 'He\'s an all out <i>hunk</i>. You can hardly keep your eyes off him. ' : 'He\'s a good looking man and that kind of makes you feel uneasy being near him because, after all, you were a man before and do you <i>really</i> want to get involved? ';
                                        }
                                        "A <<sHeight>>, <<sHair>> haired man <<sBuild>><<(iGlasses == true) ? ' with glasses' : ''>> approaches you and says,\"";
                                        pickupLines.myPickupLines.doScript();
                                        "\"<.p>";
                                        // mention but don't penalize player for getting "the works"
                                        if(beautyParlor.treatmentType == '5'){
                                              "He then looks at your face and does a double take and says,\"Pardon me. From behind you looked like somebody
                                              else. I\'m very sorry. This is so embarrassing for me. What ever happened to your face and hair?\"<.p>
                                              \"Salon accident,\" you explain blushing.<.p>He squints at you, studying your features for a moment, then says,\"Well,
                                              underneith all that I can see you\'re still a very attractive woman and it is Halloween after all so what the heck. What
                                              do you say?\"<.p>";
                                        }
                                        local iDone = 0; 
                                        local s0 = '';
                                        do{
                                            "<br>Are you interested in him? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
                                        }while(iDone==0);
                                        if(s0 == 'n' || s0 == 'no'){
                                              if((sBuild == 'athletic') && (gPlayerChar.girlType == 'abysmal')){
                                                   "<.p>You shake your head in approval but say \"no\", which obviously confuses him. He asks,\"Well? Which is it? Yes or no?\"<.p>
                                                   This guy\'s <i>really</i> good looking. You\'re getting turned on just by being in his presence. It\'s going to be <i>real</i> difficult
                                                   saying no with your out of control <i>abysmal</i> side dictating some of your behavior. You shake your head yes but say \"no\" again,
                                                   then correct yourself and say,\"I mean yes... no. No, definately it\'s a yes. I mean no it\'s a... yes. I can\'t....but I want you soooo bad
                                                   right now. Oops! Did I just say that out loud?\"<.p>He frowns at you and says,\"You know what? I\'ve changed my mind. I think I\'ll leave.\"
                                                   <.p>He walks away. "; 
                                              }else{
                                                   "<.p>You shake your head no and say,\"No thanks. I\'m waiting for someone else.\"<.p>
                                                   He nods and leaves. ";
                                              }    
                                              pickupLines.startMyDaemon();                                                                                    
                                        }else{
                                              "<.p>You smile and say,\"That was a really clever line. Why don\'t you have a seat and we\'ll talk?\"<.p>
                                              He sits down in the seat across from you. ";
                                              if(gPlayerChar.girlType == 'abysmal'){
                                                    if((sBuild == 'stocky') || (sBuild == 'fat')){
                                                              "He\'s a bit on the heavy side but a part of you finds him kind of cute. Just like a big fat teddy bear. ";
                                                    }else{
                                                              "He\'s really attractive. Your heart\'s going pitter-patter over him already. Undoubtedly your <i>abysmal</i> half
                                                              favors him being here even though the part of your mind that\'s still you is scared to death at where this will
                                                              undoubtedly lead. You\'ve got a girlfriend back home. You love <i>her</i> not... him. Yet you\'re a girl now and
                                                              the domineering abysmal side of you is all over the idea of sleeping with him and like it or not you\'re stuck here
                                                              along for the ride. ";
                                                    }           
                                              }else{
                                                    "You can\'t believe what you\'re doing. You just let a guy <i>hit</i> on you and you said yes! 
                                                    You don\'t like guys, you like girls. You\'ve got a girlfriend back home. None of any of this 
                                                    feels right. You wanted to see what it was like having a girl\'s body but you <i>never</i> thought
                                                    it would lead up to this. From what you understand, these are wealthy single men looking for wives.
                                                    This guy doesn\'t just want to take you to bed, he wants to take you <i>home</i> with him. This isn\'t
                                                    a one night stand in the works. This guy\'s playing for keeps. This is one of the things Kristy the maid warned you
                                                    about. If you want to ever change back to normal again you\'ve got to stop this before it gets out of hand. 
                                                    Then again maybe having a guy like him for a friend and protector wouldn\'t be such a bad idea. Maybe he can
                                                    even <a href=\"ask for help\">help</a> you get your old body back somehow. ";
                                                    boyfriend.moveIntoForTravel(lilliputianBooth);
                                              }
                                              "<.p>\"My name\'s <<sName>>,\" he says introducing himself.<.p>\"And you can call me <<gameMain.femaleFirstName>>,\" you say.<.p>
                                              \"It\'s certainly a pleasure to meet you, <<gameMain.femaleFirstName>>,\" <<sName>> says. ";
                                              boyfriend.moveIntoForTravel(barRoomBoothRoom);
                                              boyfriend.makePosture(sitting);
                                              boyfriend.setCurState(boyfriendTalking);
                                        }                                           
 } 

 myPickupLines : ShuffledEventList {
                  eventList = [ 
                                'I\'m a raindrop and I\'m falling for you.',
                                'Baby, you must be a broom, cause you just swept me off my feet.',
                                'I must be a Snowflake, becuase I\'ve fallen for you.',
                                'I know somebody that thinks they might like you a lot. And if I wasn\'t so shy, I would tell you who it is.',
                                'Can I buy you a drink, or do you just want the money?',
                                'Can I lick that film off your teeth?',
                                'Can you give me directions...to your heart?',
                                'Don\'t be so picky... I wasn\'t!',
                                'Falling for you would be a very short trip.',
                                'Hershey factories make millions of kisses a day, but I\'m asking for only one.',
                                'I suffer from amnesia. Do I come here often?',
                                'Is it hot in here or is it just you?',
                                'Remember me? Oh, that\'s right, I\'ve met you only in my dreams.',
                                'Want to play conductor? You be the engineer and I\'ll go choo choo.',
                                'You be the tree, and I\'ll wrap you like a Koala.',
                                'You don\'t need car keys to drive me crazy.',
                                'You might not be the best looking girl here, but beauty is only a light switch away.',
                                'You sure have a great looking tooth.',
                                'I wish I were sine squared and you were cosined squared, because together we could be one.',
                                'I\'m feeling a little off today. Would you like to turn me on?',
                                'May I have some kisses up here, please.',
                                'If a star fell from the sky every time I thought about you, then tonight the sky would be empty.',
                                'My love for you is like diarrhea. I just can\'t hold it in.',
                                'Haven\'t I seen you before? Maybe in my dreams?',
                                'If home is where the heart is, then my home is in you.',
                                'You must be a magician, because everytime I look at you, everyone else disappears.',
                                'You want me. I can smell it.',
                                'If you were a drug, I would overdose!',
                                'If you gave me a penny for my thoughts I\'d have just one penny, because I only think about one thing and that\'s you.',
                                'I don\'t speak in tongues, but I kiss that way.',
                                'If I were to ask you for sex, would your answer be the same as the answer to this question?',
                                'If I bit my lip would you kiss it better?',
                                'Baby, you\'re sexier than socks on a rooster.',
                                'What do you say we play some football? You can have first down!',
                                'You\'re like pizza. Even when you\'re bad, you\'re good.',
                                'Do you believe in love at first sight or do I have to walk by again?',
                                'Are you a parking ticket? Cause you got <i>fine</i> written all over you.',
                                'I lost my teddy bear, can I sleep with you?',
                                'If I could rearrange the alphabet, I would put U and I together.',
                                'I lost my phone number. Can I have yours?'
                  ]
 }
 masterFoundYou = nil
 myDaemon(){  
              // ** do something
              pickupLines.myMessageList.doScript();
 }
 isActive = nil
 myDaemonRunning = nil
 startMyDaemon(){
       if(tellOnYouAgent.myDaemonRunning != true){
            /* start daemon */
            // new RealTimeDaemon(pickupLines,&myDaemon,eventTime);// there are other ways to initialize this but this calls self & a method in self
            new PromptDaemon(pickupLines,&myDaemon); 
            /* set that the daemon is running (so we can keep track easy) */
            pickupLines.myDaemonRunning = true;
       }
       // make sure we are active
       pickupLines.isActive = true;
   }
   /*
    *  VERY IMPORTANT!!!!
    *
    *      NOTE: do NOT use eventManger for tracking and removing RealTimeEvents!!!
    *            Do use realTimeManager for this purpose, and use eventManager for
    *            all other agents (one time fuses, turn based events, etc.).
    *
    */
   stopMyDaemon(){
        eventManager.removeMatchingEvents(pickupLines, &myDaemon);// BAD! This is a RealTimeEvent!
        // realTimeManager.removeMatchingEvents(pickupLines, &myDaemon);// Good!
        pickupLines.removeEvent();
        pickupLines.myDaemonRunning = nil;
        pickupLines.isActive = nil;
   }
;

boothSeatPart: Floor 
  name = 'chair'
  vocabWords =  '(cozy) (little) (bar) (red) (leather) (love) booth couch sofa chair/seat'
  desc = "A red leather booth seat. "
;

barRoomBoothRoom: Room 'booth'
  desc {
        "You are in a cozy little booth in the corner of a bar. From here you can\'t see much of the room but it\'s
        a nice and quiet little spot you\'ve found. Good for having private conversations and some privacy away from
        the noisy patrons. The booth seat itself is red leather and the table is finely polished oak wood. ";
        "You can leave the booth by going ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"out\">out</a>";
        }else{
                "out"; 
        }  
        ". ";
  }
  out = lilliputians
  roomParts = [boothSeatPart,defaultNorthWall, defaultSouthWall, defaultEastWall, defaultWestWall]
  defaultPosture = [sitting]

;
+ Fixture, Surface
  name = 'table'
  vocabWords = '(finely) (polished) (shined) (shiny) (oak) (oakwood) (wood) table'
  desc = "A finely polished oak wood table. "
;


// the women you see *after* beauty treatment
barWomenTwo: Person
  vocabWords = '(bar) female girls girl woman women lady ladies patrons' 
  name = 'female patrons'
  location = pixyland
  isPlural = true
  desc = "Just some women in the bar. Some are drinking, others are here to chat and hang out with the men. "
;
+ HermitActorState 
  specialDesc = "Some female patrons are here. "
  noResponse = myNoResp.doScript()
  myNoResp : StopEventList {
              eventList = [
                      'You try talking to one of the women in the bar. She turns to you and says,\"Shhh... Can\'t you see I\'m
                      talking with my boyfriend?\" ',
                      'You try talking to one of the women in the bar. She just smiles pleasantly, ignoring you and continues drinking. ',
                      'You try talking to one of the women in the bar. She smiles and says,\"I like your hair. It\'s pretty.\" ',
                      'You try talking to one of the women in the bar. She says,\"I like what you\'ve done with your hair.\" ',
                      'You try talking to one of the women in the bar. She smiles and says hi but otherwise seems preoccupied in conversation with the man she\'s with. ',
                      'You try talking to one of the women in the bar. She says in almost a whisper to you,\"Please don\'t bud in. No offense but this is my man and 
                      I\'m not going to chance loosing him to you.\" ',
                      'You try talking to one of the women in the bar but you get no response. Everyone\'s busy here doing their own thing. Maybe you\'d have
                      better luck talking to the men. '
              ]
  }
  isInitState = true 
; 

barWomenOne: Person
  vocabWords = '(bar) female girls girl woman women lady ladies patrons' 
  name = 'female patrons'
  location = lilliputians
  isPlural = true
  desc = "Just some women in the bar. Some are drinking, others are here to chat and hang out with the men. "
;
+ HermitActorState 
  specialDesc = "Some female patrons are here. "
  noResponse = myNoResp.doScript()
  myNoResp : StopEventList {
              eventList = [
                      'You try talking to one of the women in the bar. She turns to you and says,\"Shhh... Can\'t you see I\'m
                      talking with my boyfriend?\" ',
                      'You try talking to one of the women in the bar. She just smiles pleasantly, ignoring you and continues drinking. ',
                      'You try talking to one of the women in the bar. She gives you a sour expression and says,\"Augh... do something
                      with your hair already. You look like a train wreck.\" ',
                      'You try talking to one of the women in the bar. She says,\"Honey, unless you\'re going for the Medusa look for tonight\'s
                      Halloween party you\'d better do something about that hair of yours.\" ',
                      'You try talking to one of the women in the bar. She almost jumps in reaction to seeing you. She asks,\"Do you own a brush? You
                      just gave me the scare of my life.\" ',
                      'You try talking to one of the women in the bar. She says in almost a whisper to you,\"Please don\'t bud in. No offense but this is my man and 
                      I\'m not going to chance loosing him to you.\" ',
                      'You try talking to one of the women in the bar but you get no response. Everyone\'s busy here doing their own thing. Maybe you\'d have
                      better luck talking to the men but first you should do something about your appearance. '
              ]
  }
  isInitState = true 
; 

barMenTwo: Person
  vocabWords = '(bar) male men man boy boys guy guys dude dudes stud studs studds studd patrons'
  name = 'male patrons'
  location = pixyland
  isPlural = true
  desc = "Just some guys in the bar. Some are drinking, others are here to pick up women. "
;
+ HermitActorState 
  specialDesc = "Some male patrons are here. "
  noResponse = myNoResponse.doScript()
  myNoResponse : StopEventList {
              eventList = [
                      'You try talking to one of the men in the bar. He\'s too drunk to do anything but stare at your boobs and drool. ',
                      'You try talking to one of the men sitting at the bar. He nods but doesn\'t turn his gaze towards you. He only glimpses you out of the
                      corner of his eye and says in almost a whisper,\"You take all the fun out of it. Why don\'t you wait over there and let a guy approach you
                      the old fashioned way? And at any rate, I\'ve already got a girlfriend, sorry.\" ',
                      'You try talking to one of the men in the room. He points to the girl with him and says,\"Sorry but I\'m kind\'a busy, okay?\" ',
                      'You try talking to one of the men in the room. He misunderstands you for the waitress and says,\"How about that drink I ordered like ten minutes ago?\"
                      <.p>You say,\"I don\'t work here.\"<.p>He nods and says,\"No apology is necessary. Just get me that drink already. It\'s been so long since my last drink
                      that I\'m getting the shakes from alcohol withdrawl!\" ',
                      'You try talking to one of the men in the bar but you get no response. Everyone\'s busy here doing their own thing. Maybe you\'d have
                      better luck if you sat in a booth and just wait for one of the men to approach you. '
              ]
  }
  isInitState = true 
; 

barMenOne: Person
  vocabWords = '(bar) male men man boy boys guy guys dude dudes stud studs studds studd patrons'
  name = 'male patrons'
  location = lilliputians
  isPlural = true
  desc = "Just some guys in the bar. Some are drinking, others are here to pick up women. "
;
+ HermitActorState 
  specialDesc = "Some male patrons are here. "
  noResponse = myNoResponse.doScript()
  myNoResponse : StopEventList {
              eventList = [
                      'You try talking to one of the men in the bar. He turns to you and almost spits out his drink, then says,\"Lady, you\'ve got a very
                      pretty face but didn\'t you even look in the mirror this morning?\" ',
                      'You try talking to one of the men sitting at the bar. He nods but doesn\'t turn his gaze towards you. He only glimpses you out of the
                      corner of his eye and says in almost a whisper,\"This isn\'t how it works, you know. This is a traditional establishment. <i>Men</i> are
                      supposed to pick up the women, not the other way around. I don\'t like it when a girl tries to hit on me. It makes her look <i>easy</i> and
                      cheap and... why am I still talking to you? Leave me alone already.\" ',
                      'You try talking to one of the men in the room. He points to the girl with him and says,\"Sorry but I\'m kind\'a busy, okay?\" ',
                      'You try talking to one of the men in the room. He asks,\"They let you in here looking like that?\" ',
                      'You try talking to one of the men in the bar but you get no response. Everyone\'s busy here doing their own thing. Maybe you\'d have
                      better luck talking to the men if you did something about your appearance first. '
              ]
  }
  isInitState = true 
; 


/*
northShoreBeach: OutdoorRoom 'beach'
  "This is the northern most point on the island. The sandy white beach stretches out for over two kilometers in either
  direction. "
  south = centerVillagePlaza
;
*/

jungleCarWreck: OutdoorRoom 
  name = 'ravine'
  desc { 
        "This is the bottom of a jungle ravine. Just visible up above a steep embankment is what\'s left of <<boyfriend.properName>>\'s white
        pickup truck smashed into a tree. A creek flows ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
        }else{
                "south"; 
        }  
        " from here. ";  
  }
  enteringRoom(traveler) { 
        if(!gPlayerChar.hasSeen(jungleCarWreck)){
                  "You hide in the back seat of <<boyfriend.properName>>\'s truck. The ride is bumpy on the old dirt road
                  and suddenly the truck swerves and crashes into a ditch. You\'re thrown from the vehicle and go tumbling
                  into a ravine and lose consciousness. Awhile later you wake up and hear a man groaning nearby. ";
        }
  }
  south = jungleStreamOne
;
+ jungleStreamOne :  OneWayRoomConnector 
  destination = graveyard
  vocabWords = '(little) (small) (tiny) (jungle) water stream/creek'
  name = 'stream'
  desc = "A jungle stream leading south. "
  //  travelBarrier = []
  noteTraversal(traveler) {  
    if(!entered) { 
      "You follow the little stream out of the ravine. ";
      entered = true; 
    } 
  } 
  entered = nil 
  dobjFor(Follow) remapTo(TravelVia,jungleStreamOne)
  dobjFor(Take) remapTo(TravelVia,jungleStreamOne)
; 

// use this way: zombieImmunityAchievement.awardPointsOnce();
zombieImmunityAchievement: Achievement
  desc {  
         "discovering a bad hairdo and botched up facial is a huge plus vs. the undead (zombie immunity) ";
  }
  points = 1 
;

graveyard: OutdoorRoom
  name = 'graveyard'
  desc {
            if(!gPlayerChar.hasSeen(self)){
                   "<i>Uh oh! A spooky graveyard in the middle of the jungle!</i><.p> ";
            }
            "Portions of this graveyard are partially sunk in a sprawling swamp.
            There are headstones everywhere here. A little path leads out to the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
            }else{
                "east"; 
            }  
            ". ";
  }
  roomCounter = 0
  east = jungleGraveyardPath
  north: NoTravelMessage {
         travelDesc { 
                 "You don\'t feel like wasting time by going back to the crash scene. You\'ve got to press on and find some
                  help. The only way out of this spooky graveyard seems to be by going <a href=\"east\">east</a>. ";
         }
  }
  roomBeforeAction {
     graveyard.roomCounter++;
     if(graveyard.roomCounter == 3){
            if(beautyParlor.treatmentType == '5'){
                    "A vampire zombie grabs hold of your arm but as he gets a closer look at you he cringes and leaps back.
                    Another vampire zombie laughs at him and says,\"Sheeeeeeee\'s aaaaaaalready.... zombieeeeeeeeeeeee....\"<.p>
                    They must be referring to your botched up beauty treatment. At any rate apparently you\'ve got zombie immunity
                    with your current looks. ";
                    zombieImmunityAchievement.awardPointsOnce();
                    exit;
            }
            "A vampire zombie grabs hold of your arm. You try and struggle free but it\'s too
            late. He bites you on the neck and starts sucking your blood while at the same time
            he\'s pulling your hair, trying to get at your brains. He\'s a greedy little bugger.
            Persistant and rather annoying to say the least. He\'s dressed up as a bit of a nerd
            with glasses and a pocket protector and greasy unkempt hair.<.p>";
            "Oh dear, it seems you have died. I can try reincarnating you but I\'m not much good
            at this and there\'s a chance you might come back as a zombie. ";
            graveyard.roomCounter == 0;
             local iDone = 0; 
                    local s0 = '';
                    do{
                                            "<br>Do you wish for a reincarnation? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
                    }while(iDone==0);
                    if(s0 == 'n' || s0 == 'no'){
                         "<.p>You have died and as a result <<boyfriend.properName>> gradually dies from his injuries alone in the
                         jungle without help. The mad scientist living at the island mansion eventually takes over the world with his
                         inventions and his army of vampire zombies. With world domination out of the way the diabolical schemes
                         of the mad scientist continue starting with a plan to open a chain of sea food restaraunts staffed by vampire
                         zombies. The food sucks and so does the service and eventually the restaraunts go out of business. Shunned by
                         castrophic failure in the franchise business the mad scientist goes into retirement in a mobile home park for
                         the elderly. He goes fishing every Tuesday, wears funny white sneakers and is really lousy at shuffleboard but
                         worst of all he\'s a terrible chef and no one wants to attend his Kajun cook outs. He eventually dies from eating
                         an undercooked egg salad sandwich that had been sitting in the sun too long and all this happened because you
                         refused to take a chance and get a reincarnation. We at the Adventurer\'s Union sincerely hope you\'re happy for 
                         what you did.<.p><b>The End</b> ";
                         finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                         exit;
                    }  
                    "<br>You are engulfed in a cloud of orange smoke.... ";
                    timeDelay(200);
                    local iRoll = rand(100) + 1;
                    idolOfZakra.moveInto(treasureChest);
                    treasureChestKey.moveInto(mastersDrawer);
                    gameMain.is_a_zombie = nil;
                    zombieBooth.hasUsed = nil;
                    me.pcHeight = '5\' 3\"';
                    if(iRoll < 90){
                            "<.p>....you emerge from the smoke coughing and choking. When the smoke clears you\'re back at the
                            bottom of a ravine and what do you know, you\'re still a girl. <<boyfriend.properName>> spots you and 
                            asks,\"Did.... did you get help?\"<.p>\"Better than that, I got killed by zombies but I\'m back now, see? I got
                            an extra life,\" you reply.<.p><<boyfriend.properName>> moans and says,\"This bump on my head\'s giving me
                            hallucinations...\"<.p> "; 
                            gPlayerChar.moveIntoForTravel(jungleCarWreck);
                            inputManager.pauseForMore(true);// better than using just the morePrompt()
                            "<HR ALIGN=CENTER NOSHADE><br>";
                            gPlayerChar.lookAround(true);
                    }else{
                            "<.p>...you emerge from the smoke coughing and choking. When the smoke clears you find yourself still at the
                            graveyard.<.p>Oh dear, I\'m really sorry about that. It seems you\'ve turned into a vampire zombie after all.<.p>The 
                            nerd vampire zombie spots you and starts toying with your breasts but one of them falls off. It\'s a rather embarrassing
                            moment for the both of you but the nerd zombie picks it up and walks away with it like he\'s discovered a new toy to play
                            with. Eventually the mad scientist of the island rounds up you and the rest of his vampire zombie army and tries to take
                            over the world... but that\'s another story.<.p><b>The End</b> ";
                            finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                            exit;
                    }                
     }
  }  
;
+ jungleGraveyardPath :  OneWayRoomConnector 
  destination = southOfMansion
  vocabWords = '(little) (small) (tiny) (jungle) (dirt) (gravel) (gravely) (gravly) path/trail'
  name = 'path'
  desc = "A jungle path heading east. "
  //  travelBarrier = []
  noteTraversal(traveler) {  
    if(!entered) { 
      "You follow the little path out of the graveyard. ";
      entered = true; 
    } 
  } 
  isListed = nil
  entered = nil 
  dobjFor(Follow) remapTo(TravelVia,jungleStreamOne)
  dobjFor(Take) remapTo(TravelVia,jungleStreamOne)
; 
+ Decoration '(spooky) (swampy) (flooded) (out) graveyard graves' 'graves'
  "A bunch of graves in a swampy graveyard. "
;
+ Decoration '(spooky) (swampy) (flooded) (out) (head) headstones/stones' 'headstones'
  "Some spooky, swampy, flooded out headstones. "
;


vampireZombies: Person
  name = 'vampire zombies'
  isPlural = true
  vocabWords = '(big) (green) (fang) (toothed) undead vampire zombies vampires zombie monster monsters'
  desc = "A bunch of vampire fang toothed zombies. The worst kind! "
  location = graveyard
;
+ vampireZombiesWandering: HermitActorState 
  specialDesc = "There are vampire zombies roaming everywhere about the graveyard! "
  noResponse = myZombieResp.doScript()
  myZombieResp : StopEventList {
            eventList = [
                   'Braaaaaains.... bloooooooooood.....',
                   'Booooooooobies.....',
                   'Oiiiiiiil.... chaaaaaange....',
                   'Banannaaaaaaaas.... banannaaaaaaaaaaas.... ',
                   'Grrrrrrrrr..... grrrrrrrrrrrrr.... ',
                   'Kibbles..... kiiiiiiiiibles \'n biiiiiiiiiiiiiiiits...... ',
                   'Braaaaaains..... blooooooooooooood.... ',
                   'You\'d better not bother the vampire zombies anymore. They\'re clearly limited on dialogue. '                  
            ]
  }
  isInitState = true 
; 

southOfMansion: OutdoorRoom 
  name = 'side of the mansion'
  desc {
              "This is the southern edge of the mansion outer perimeter wall. There\'s a small hole leading under the fence. 
              It might be a tight fit but a girl like yourself should be able to squeeze through. ";
  }
  west: NoTravelMessage {
         travelDesc { 
                 "You don\'t feel like wasting time by going back to the graveyard or crash scene. You\'ve got to press on and find some
                  help. ";
         }
  }
  north = southWallHole
  in = southWallHole
;
+ southWallHole :  OneWayRoomConnector 
  destination = backyard
  vocabWords = '(little) (small) (tiny) (jungle) (dirt) (gravel) (gravely) (gravly) (crawl) (in) (the) (wall) hole/tunnel/space'
  name = 'hole'
  desc = "A hole in the wall. "
  //  travelBarrier = []
  noteTraversal(traveler) {  
    if(!entered) { 
      "You crawl through the hole in the wall and emerge out on the other side. ";
      entered = true; 
    } 
  } 
  isListed = nil
  entered = nil 
  dobjFor(Follow) remapTo(TravelVia,southWallHole)
  dobjFor(Take) remapTo(TravelVia,southWallHole)
  dobjFor(Enter) remapTo(TravelVia,southWallHole)
  dobjFor(Use) remapTo(TravelVia,southWallHole)
  dobjFor(GoThrough) remapTo(TravelVia,southWallHole)
;  
+ Decoration '(southern) (edge) (mansion) (perimeter) (black) (brick) wall' 'brick wall'
  "A black brick wall. There\'s a little hole under it leading into the mansion property. "
; 

backyard: OutdoorRoom 'backyard'
  desc {
        "The mansion\'s backyard has some trees and a grassy hill leading up to the estate itself. 
        A path leads ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
        }else{
                "north"; 
        }  
        " to the back porch while off to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
        }else{
                "west"; 
        }  
        " is a strange machine on the lawn. ";        
  }
  north: NoTravelMessage {
         travelDesc { 
                 "Going right up to the back porch seems like a pretty dangerous idea. If you\'re caught by the mansion occupants, especially
                 Kristy the maid, it could spell trouble. Maybe there\'s another way in, like through another basement door somewhere. ";
         }
  }
  west = backyardWest
  south: NoTravelMessage {
         travelDesc { 
                 "You don\'t feel like wasting time by going back to the graveyard or crash scene. You\'ve got to press on and find some
                  help. ";
         }
  }
  in = south
;
+ Decoration '(south) (wall) hole' 'hole'
  "The hole under the wall looks ordinary enough. "
;
+ Decoration '(south) (tall) (black) (brick) wall/fence/gate' 'brick wall'
  "A black brick wall surrounding the estate. "
;
+ Decoration '(tall) (big) (oak) (pine) tree*trees' 'trees'
  "Some pine trees in the backyard. "
  isPlural = true
;
+ Decoration '(tall) (green) grass' 'grass'
  "Some green grass in the backyard. "
  isPlural = true
;
+ Decoration '(grassy) (grass) (covered) hill/hillside' 'hill'
  "A grassy hill in the backyard with some trees on it. On top is the mansion itself. ";
;
+ Decoration '(big) (spooky) (old) (haunted) mansion/house' 'mansion'
  "The mansion is big and spooky. "
;
+ Decoration '(mansion) (back) porch' 'porch'
  "Looks like an ordinary back porch. "
; 
+ Decoration '(mansion) (strange) (looking) (shrink) (shrinking) (ray) machine' 'machine'
  "A strange looking machine to the west on the lawn. "
;

// use this way: zombieImmunityAchievement.awardPointsOnce();
wonTheGameAchievement: Achievement
  desc {  
         "for getting your old body back to normal and saving the world from the diabolical plans of the mad scientist (victory win) ";
  }
  points = 50 
;

// use this way: attendedHalloweenPartyAchievement.awardPointsOnce();
attendedHalloweenPartyAchievement: Achievement
  desc {  
         "for getting to the Halloween party in a pirate wench costume. ";
  }
  points = 1 
;



backyardWest: OutdoorRoom 
   name = 'backyard'
   desc {
           if(!gPlayerChar.hasSeen(self)){
            "As you arrive from the east your foot snags a hidden trip wire and
            a giant dish on the machine spins around and shoots you with a powerful
            bright blue-white energy beam. You feel yourself shrinking and you try to
            run away. You manage to escape the full effects but now you\'re just under
            three feet tall. You turn around and look back at where you stood just moments
            before under a large pine tree and see that the tree has been reduced to a few
            inches in height. You try not to think about what would have happened to yourself if you
            hadn\'t gotten out from under that beam. ";
            gPlayerChar.pcHeight = '2\' 8\"';
            /* beta-win - final release will have some puzzles in the house 
             */
            //"<table bgcolor=black><tr><td><font color=white>Beta Victory!</font></td></tr></table> ";
            //"You find your way in the mansion through another basement door and find the maid and ask her for help
            //at the accident scene nearby. While she\'s away you take the opportunity to locate your form cube and change
            //back to normal. You discover a zombification machine and destroy it, ruining the diabolical plans of the mad
            //scientist who lives here.<.p>Congradulations! You have changed back to normal and saved the world!<.p> ";
            //wonTheGameAchievement.awardPointsOnce();
            //finishGameMsg(ftVictory,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
            //exit;                          
           }
           "This is the west end of the backyard. There is a basement ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"enter door\">door</a>";
            }else{
                "door"; 
            }
            " door here. ";
   }

   east: NoTravelMessage {
         travelDesc { 
                 "You\'re cut off by that shrinking machine back there. You\'d do better to just go in the basement door. ";
         }
  }
; 
+ Decoration '(shrink) (shrinking) (big) (metal) (complex) computer array shrinker dish ray machine/device' 'shrinking machine'
  "From here it looks like a big metal dish attached to a complex computer array. " 
;
+ mansionBasementDoor04 : LockableWithKey, Door '(wood) (wooden) (mansion) (basement) (side) door/hatch' 'basement door'
     "A wooden basement door. "
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  dobjFor(Enter){
        verify(){ logicalRank(120,'likely'); 
                  inherited;
        }
        check(){ inherited; }
        action(){ inherited; }
  }
  dobjFor(TravelVia){
      verify(){ logicalRank(130,'very likely'); 
                // inherited;
      }
      check(){ inherited; }
      action(){ inherited; }
  }
;

// use this way: zombifiedTheMasterAchievement.awardPointsOnce();
zombifiedTheMasterAchievement: Achievement
  desc {  
         "for turning the Master into a zombie. ";
  }
  points = 5 
;

zombieMasterFem: Male, CromexxHuman
  name = 'Master zombie'
  vocabWords = '(the) Curly master girl woman female zombie'
  desc = "She\'s female thanks to your magic spell. This zombie, once known simply as the Master, has been zombified by you thanks your
         quick thinking by putting him through his own machine after he tripped and died. Now he lives again... as the undead. "
  sayDepartingDir(dir, conn) { "The Master zombie shuffles after you to the <<dir.name>>. "; }
  idleTurn(){
       inherited;
  }
  actorHereDesc { nil; }
  // isListed = nil
  iobjFor(AttackWith){
    preCond=[]
    verify(){ if(gDobj != nil){
                 if(gDobj == maidsRoomDoor) logicalRank(100,'likely'); 
              }
    }
    check(){ }
    action(){ 
           // "iobj AttackWith script - action() ... where gDobj == <<gDobj.name>><.p>";
    }
  }
  dobjFor(FrimpWith){
      verify(){ }
      check(){ }
      action(){
             if(
                (gActor == gPlayerChar) && (!wizardWand.isHeldBy(gPlayerChar))
               ){
                  "You can\'t cast the Frimp spell without a magic wand. ";
                  exit;
             }

             "You point the magic wand at the Master zombie and say,\"Frimp!\"...........<.p>";
             if(gameMain.is_a_little_girl == nil){
                      "...a spark shoots out from the wand but nothing else happens.<.p> ";
             }else{
                      "...the Master zombie\'s skin loses its green colorization and changes into a pale white
                      skin color as she shrinks down and changes into a cute little girl. Her male clothes wink out
                      of existance and are replaced with a little pink dress, white cotton socks and some shiny black flats.
                      She looks down at her tiny hands, realizing she is no longer a zombie nor a man anymore. She looks up at
                      you, stomps a foot angrily and says,\"You turn-did me into\'s a widdle gurrrrl! I\'m not \'posted to bees dis
                      way.\"<.p>She runs up to you and grabs the wand from your hands and hurries out of the room. ";
                      wizardWand.moveInto(pixyland);
                      zombieMaster.moveInto(pixyland);
             }
      }
  }
  dobjFor(BoyifyWith){
      verify(){ }
      check(){ }
      action(){
             "You point the magic wand at the Master zombie and say,\"Boyify!\"....<.p>";
             zombieMasterFem.moveIntoForTravel(pixyland);
             zombieMaster.moveIntoForTravel(gPlayerChar.location);
             "She grows, her curves vanish away and she\'s a man again but still a zombie. He glances down at himself
             to briefly take notice but otherwise he seems indifferent to what\'s happened. ";
      }
  }
  dobjFor(FemifyWith){
      verify(){ }
      check(){ }
      action(){
             "You point the magic wand at the Master zombie and say,\"Femify!\"....a small spark shoots out but otherwise nothing else happens.<.p>";
      }
  }
  dobjFor(NormalizeWith){
      verify(){ }
      check(){ }
      action(){
           "A blast of energy shoots out from the magic wand and engulfs the Master. Her skin loses its green colorization as
           the zombification is removed and she is changed back to her normal male self.<.p>He rushes over to you, grabs you by the throat, choking you
           as he grabs the magic wand away from you and says,\"Why you little no good rotten... I\'ll <i>kill</i> you for this! You\'ll not
           get in my way again.\"<.p>You can\'t breathe. You feel yourself slowly losing consciousness....<.p>Oh my, it appears that you have
           died. I can try reincarnating you but I\'m not much good at this and there\'s a chance you might come back as a zombie. ";
           local iDone = 0; 
           local s0 = '';
           do{
                                            "<br>Do you wish for a reincarnation? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
           }while(iDone==0);
           if(s0 == 'n' || s0 == 'no'){
                         "<.p>You have died and as a result <<boyfriend.properName>> gradually dies from his injuries alone in the
                         jungle without help. The mad scientist living at the island mansion eventually takes over the world with his
                         inventions and his army of vampire zombies. With world domination out of the way the diabolical schemes
                         of the mad scientist continue starting with a plan to open a chain of sea food restaraunts staffed by vampire
                         zombies. The food sucks and so does the service and eventually the restaraunts go out of business. Shunned by
                         castrophic failure in the franchise business the mad scientist goes into retirement in a mobile home park for
                         the elderly. He goes fishing every Tuesday, wears funny white sneakers and is really lousy at shuffleboard but
                         worst of all he\'s a terrible chef and no one wants to attend his Kajun cook outs. He eventually dies from eating
                         an undercooked egg salad sandwich that had been sitting in the sun too long and all this happened because you
                         refused to take a chance and get a reincarnation. We at the Adventurer\'s Union sincerely hope you\'re happy for 
                         what you did.<.p><b>The End</b> ";
                         finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                         exit;
           }  
           "<br>You are engulfed in a cloud of orange smoke.... ";
           timeDelay(200);
           local iRoll = rand(100) + 1;
           idolOfZakra.moveInto(treasureChest);
           treasureChestKey.moveInto(mastersDrawer);
           gameMain.is_a_zombie = nil;
           zombieBooth.hasUsed = nil;
           me.pcHeight = '5\' 3\"'; 
           if(iRoll < 90){
                            "<.p>....you emerge from the smoke coughing and choking. When the smoke clears you\'re back at the
                            bottom of a ravine and what do you know, you\'re still a girl. <<boyfriend.properName>> spots you and 
                            asks,\"Did.... did you get help?\"<.p>\"Better than that, I got killed by zombies but I\'m back now, see? I got
                            an extra life,\" you reply.<.p><<boyfriend.properName>> moans and says,\"This bump on my head\'s giving me
                            hallucinations...\"<.p> "; 
                            gPlayerChar.moveIntoForTravel(jungleCarWreck);
                            inputManager.pauseForMore(true);// better than using just the morePrompt()
                            "<HR ALIGN=CENTER NOSHADE><br>";
                            gPlayerChar.lookAround(true);
           }else{
                            "<.p>...you emerge from the smoke coughing and choking. When the smoke clears you find yourself at the
                            graveyard.<.p>Oh dear, I\'m really sorry about that. It seems you\'ve turned into a female vampire zombie.<.p>A 
                            nerd vampire zombie spots you and starts toying with your breasts but one of them falls off. It\'s a rather embarrassing
                            moment for the both of you but the nerd zombie picks it up and walks away with it like he\'s discovered a new toy to play
                            with. Eventually the mad scientist of the island rounds up you and the rest of his vampire zombie army and tries to take
                            over the world... but that\'s another story.<.p><b>The End</b> ";
                            finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                            exit;
           }  
      }// end action()
  }// end dobjFor(NormalizeWith)
;
+ zombieMasterWanderingTwo: HermitActorState 
  noResponse = myZombieResp.doScript()
  myZombieResp : StopEventList {
            eventList = [
                   'Braaaaaains.... bloooooooooood.....',
                   'Grrrrrrrrr..... grrrrrrrrrrrrr.... ',
                   'Braaaaaains..... blooooooooooooood.... '
            ]
  }
  isInitState = true 
;
+ zombieFollowingTwo: AccompanyingState 
  specialDesc = "The Master zombie is here. "
  stateDesc = "The Master zombie is here. "
  accompanyTravel(leadActor, conn){
     return ((leadActor == gPlayerChar) && 
             (idolOfZakra.isHeldBy(gPlayerChar))
            ); 
  } 
  takeTurn(){
          if(gPlayerChar.location == zombieMasterFem.location){
               if(!idolOfZakra.isHeldBy(gPlayerChar)){
                   zombieMasterFem.setCurState(zombieMasterEnragedTwo);
                   "The Master zombie growls and roars, swinging an arm towards you but misses. \"Diiiiiiiiiiiie!.....\"<.p> ";
               }
          } 
  }
; 
+ zombieMasterEnragedTwo: HermitActorState
  noResponse = myZombieRespTwoA.doScript()
  myZombieRespTwoA : ShuffledEventList {
            eventList = [
                   'Braaaaaains.... bloooooooooood.....',
                   'Grrrrrrrrr..... grrrrrrrrrrrrr.... ',
                   'Braaaaaains..... blooooooooooooood.... '
            ]
  } 
  takeTurn(){
          if(gPlayerChar.location == zombieMasterFem.location){
               if(idolOfZakra.isHeldBy(gPlayerChar)){
                    "The idol grows warm in your hands momentarily and the new zombie shuffles towards you and nods, waiting to follow.<.p>";
                     zombieMasterFem.setCurState(zombieFollowingTwo);
               }else{
                     zombieMasterEnragedTwo.zombieThrowFitTwo.doScript();
               }
          } 
  }
  zombieThrowFitTwo: StopEventList {
          eventList = [
                   'The zombie Master growls at you,\"Diiiiiiiiie!.....\" ',
                   new function(){
                          if(zombieMasterFem.location == mansionBasementBack){
                                "The Master zombie shuffles over to the zombification machine and grabs hold of it by the sides and begins to
                                violently shake it back and forth. ";
                          }
                   },
                   'The zombie Master spits and hisses at you. '
          ]
  }
;

zombieMaster: Male, CromexxHuman
  name = 'Master zombie'
  vocabWords = '(the) Curly master zombie'
  desc = "The Master\'s a zombie now thanks you quick thinking on your part by putting him through his own machine after he tripped and died. Now he lives again... as the undead. "
  sayDepartingDir(dir, conn) { "The Master zombie shuffles after you to the <<dir.name>>. "; }
  idleTurn(){
       inherited;
  }
  actorHereDesc { nil; }
  // isListed = nil
  iobjFor(AttackWith){
    preCond=[]
    verify(){ if(gDobj != nil){
                 if(gDobj == maidsRoomDoor) logicalRank(100,'likely'); 
              }
    }
    check(){ }
    action(){ 
           // "iobj AttackWith script - action() ... where gDobj == <<gDobj.name>><.p>";
    }
  }
  dobjFor(FrimpWith){
      verify(){ }
      check(){ }
      action(){
             if(
                (gActor == gPlayerChar) && (!wizardWand.isHeldBy(gPlayerChar))
               ){
                  "You can\'t cast the Frimp spell without a magic wand. ";
                  exit;
             }
             "You point the magic wand at the Master zombie and say,\"Frimp!\"...........<.p>";
             if(gameMain.is_a_little_girl == nil){
                      "...a spark shoots out from the wand but nothing else happens.<.p> ";
             }else{
                      "...the Master zombie\'s skin loses its green colorization and changes into a pale white
                      skin color as he shrinks down and changes into a cute little girl. Her male clothes wink out
                      of existance and are replaced with a little pink dress, white cotton socks and some shiny black flats.
                      She looks down at her tiny hands, realizing she is no longer a zombie nor a man anymore. She looks up at
                      you, stomps a foot angrily and says,\"You turn-did me into\'s a widdle gurrrrl! I\'m not \'posted to bees dis
                      way.\"<.p>She runs up to you and grabs the wand from your hands and hurries out of the room. ";
                      wizardWand.moveInto(pixyland);
                      zombieMaster.moveInto(pixyland);
             }
      }
  }
  dobjFor(FemifyWith){
      verify(){ }
      check(){ }
      action(){
             if(
                (gActor == gPlayerChar) &&
                (gameMain.is_a_girl == nil)
             ){
                    "You point the magic wand at the master zombie and say,\"Femify!\"....<.p>
                    ...nothing seems to happen. Perhaps you are using the spell incorrectly. ";
                    exit;
             }
             "You point the magic wand at the Master zombie and say,\"Femify!\"....<.p>";
             zombieMaster.moveIntoForTravel(pixyland);
             zombieMasterFem.moveIntoForTravel(gPlayerChar.location);
             "He sprouts breasts and shrinks a little, changing into a woman. The change happens rapidly and when it\'s finished the zombie glances down
             at herself briefly and takes notice but otherwise doesn\'t react to what\'s happened. ";
      }
  }
  dobjFor(BoyifyWith){
      verify(){ }
      check(){ }
      action(){
             "You point the magic wand at the Master zombie and say,\"Boyify!\"....A spark shoots out but otherwise nothing else happens.<.p>";
      }
  }
  dobjFor(NormalizeWith){
      verify(){ }
      check(){ }
      action(){
           "A blast of energy shoots out from the magic wand and engulfs the Master. His skin loses its green colorization as
           the zombification is removed and he is changed back to normal.<.p>He rushes over to you, grabs you by the throat, choking you
           as he grabs the magic wand away from you and says,\"Why you little no good rotten... I\'ll <i>kill</i> you for this! You\'ll not
           get in my way again.\"<.p>You can\'t breathe. You feel yourself slowly losing consciousness....<.p>Oh my, it appears that you have
           died. I can try reincarnating you but I\'m not much good at this and there\'s a chance you might come back as a zombie. ";
           local iDone = 0; 
           local s0 = '';
           do{
                                            "<br>Do you wish for a reincarnation? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
           }while(iDone==0);
           if(s0 == 'n' || s0 == 'no'){
                         "<.p>You have died and as a result <<boyfriend.properName>> gradually dies from his injuries alone in the
                         jungle without help. The mad scientist living at the island mansion eventually takes over the world with his
                         inventions and his army of vampire zombies. With world domination out of the way the diabolical schemes
                         of the mad scientist continue starting with a plan to open a chain of sea food restaraunts staffed by vampire
                         zombies. The food sucks and so does the service and eventually the restaraunts go out of business. Shunned by
                         castrophic failure in the franchise business the mad scientist goes into retirement in a mobile home park for
                         the elderly. He goes fishing every Tuesday, wears funny white sneakers and is really lousy at shuffleboard but
                         worst of all he\'s a terrible chef and no one wants to attend his Kajun cook outs. He eventually dies from eating
                         an undercooked egg salad sandwich that had been sitting in the sun too long and all this happened because you
                         refused to take a chance and get a reincarnation. We at the Adventurer\'s Union sincerely hope you\'re happy for 
                         what you did.<.p><b>The End</b> ";
                         finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                         exit;
           }  
           "<br>You are engulfed in a cloud of orange smoke.... ";
           timeDelay(200);
           local iRoll = rand(100) + 1;
           idolOfZakra.moveInto(treasureChest);
           treasureChestKey.moveInto(mastersDrawer);
           gameMain.is_a_zombie = nil;
           zombieBooth.hasUsed = nil;
           me.pcHeight = '5\' 3\"'; 
           if(iRoll < 90){
                            "<.p>....you emerge from the smoke coughing and choking. When the smoke clears you\'re back at the
                            bottom of a ravine and what do you know, you\'re still a girl. <<boyfriend.properName>> spots you and 
                            asks,\"Did.... did you get help?\"<.p>\"Better than that, I got killed by zombies but I\'m back now, see? I got
                            an extra life,\" you reply.<.p><<boyfriend.properName>> moans and says,\"This bump on my head\'s giving me
                            hallucinations...\"<.p> "; 
                            gPlayerChar.moveIntoForTravel(jungleCarWreck);
                            inputManager.pauseForMore(true);// better than using just the morePrompt()
                            "<HR ALIGN=CENTER NOSHADE><br>";
                            gPlayerChar.lookAround(true);
           }else{
                            "<.p>...you emerge from the smoke coughing and choking. When the smoke clears you find yourself at the
                            graveyard.<.p>Oh dear, I\'m really sorry about that. It seems you\'ve turned into a female vampire zombie.<.p>A 
                            nerd vampire zombie spots you and starts toying with your breasts but one of them falls off. It\'s a rather embarrassing
                            moment for the both of you but the nerd zombie picks it up and walks away with it like he\'s discovered a new toy to play
                            with. Eventually the mad scientist of the island rounds up you and the rest of his vampire zombie army and tries to take
                            over the world... but that\'s another story.<.p><b>The End</b> ";
                            finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                            exit;
           }  
      }// end action()
  }// end dobjFor(NormalizeWith)
;
+ zombieMasterWandering: HermitActorState 
  // specialDesc = "There are vampire zombies roaming everywhere about the graveyard! "
  noResponse = myZombieResp.doScript()
  myZombieResp : StopEventList {
            eventList = [
                   'Braaaaaains.... bloooooooooood.....',
                   'Grrrrrrrrr..... grrrrrrrrrrrrr.... ',
                   'Braaaaaains..... blooooooooooooood.... '
            ]
  }
  isInitState = true 
;
// setCurState(zombieFollowing); 
+ zombieFollowing : AccompanyingState 
  specialDesc = "The Master zombie is here. "
  stateDesc = "The Master zombie is here. "
  accompanyTravel(leadActor, conn){
     return ((leadActor == gPlayerChar) && 
             (idolOfZakra.isHeldBy(gPlayerChar))
            ); 
  } 
  takeTurn(){
          if(gPlayerChar.location == zombieMaster.location){
               if(!idolOfZakra.isHeldBy(gPlayerChar)){
                   zombieMaster.setCurState(zombieMasterEnraged);
                   "The Master zombie growls and roars, swinging an arm towards you but misses. \"Diiiiiiiiiiiie!.....\"<.p> ";
               }
          } 
          if(gPlayerChar.isIn(normalizerBooth) && idolOfZakra.isHeldBy(gPlayerChar)){
                       if(zombieMaster.location != normalizerBooth){
                                "The Master zombie enters the booth. ";
                                zombieMaster.moveIntoForTravel(normalizerBooth);
                       }
          }
  }
; 
++ CommandTopic @BoyifyWithAction
  matchDobj = gPlayerChar
  topicResponse {
           "Mindless zombies tend to not be able to cast spells too well. Best think of another way if you want to change back into a man again. ";
           //      wizardWand.moveInto(zombieMaster);
           //      local tokList = Tokenizer.tokenize('boyify Jake with magic wand');// works!
           //      executeCommand(zombieMaster, zombieMaster, tokList,nil);// nil = start of sentence (true/nil)   

  }
;
++ CommandTopic @BoyifyAction
  matchDobj = gPlayerChar
  topicResponse {
           "Mindless zombies aren\'t too good at spell casting. Better think of another way to do that. ";
  }
;
+ zombieMasterEnraged: HermitActorState
  noResponse = myZombieRespTwo.doScript()
  myZombieRespTwo : ShuffledEventList {
            eventList = [
                   'Braaaaaains.... bloooooooooood.....',
                   'Grrrrrrrrr..... grrrrrrrrrrrrr.... ',
                   'Braaaaaains..... blooooooooooooood.... '
            ]
  } 
  takeTurn(){
          if(gPlayerChar.location == zombieMaster.location){
               if(idolOfZakra.isHeldBy(gPlayerChar)){
                    "The idol grows warm in your hands momentarily and the new zombie shuffles towards you and nods, waiting to follow.<.p>";
                     zombieMaster.setCurState(zombieFollowing);
               }else{
                     zombieMasterEnraged.zombieThrowFit.doScript();
               }
          } 
  }
  zombieThrowFit: StopEventList {
          eventList = [
                   'The zombie Master growls at you,\"Diiiiiiiiie!.....\" ',
                   new function(){
                          if(zombieMaster.location == mansionBasementBack){
                                "The Master zombie shuffles over to the zombification machine and grabs hold of it by the sides and begins to
                                violently shake it back and forth. ";
                          }
                   },
                   'The zombie Master spits and hisses at you. '
          ]
  }
;



mansionBasementBack: ClothingRemovalRoom
  name = 'basment'
  desc {
      if(!gPlayerChar.hasSeen(self)){
                "The basement door slams shut behind you and you try and open it again but find to your dismay that it is locked.<.p> ";
             mnsnBasementDoorInnerTwo.makeOpen(nil);
             mnsnBasementDoorInnerTwo.makeLocked(true);
             mansionBasementDoor04.makeOpen(nil);
             mansionBasementDoor04.makeLocked(true);
      }
      "There is a green painted machine here in the center of this windowless room. A little chair 
      and workbench is nearby.<<(workbenchDevestation.location == mansionBasementBack) ? '' : ' On the workbench 
      are some beakers.'>> The only available exit, a small wooden staircase, winds its way ";
      if(gameMain.allowHtmlLinks){
                "<a href=\"up\">upstairs</a>";
      }else{
                "upstairs"; 
      }  
      ". ";  
  }
  up = cellarStairsUpThree
;

/*
 *   OutOfReach conditionally... if we are inside it we can not interact with objects outside of it
 */
+ zombieBooth:  OutOfReach, Heavy, LockableWithKey, Readable, Occluder, OpenableContainer, Booth
  controlsSet = nil
  hasUsed = nil
  name = 'zombification booth'
  vocabWords = '(human) (body) (zombie) (zomby) (zombification) (zombifyer) (making) machine invention chamber door zombifier booth'
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  initiallyOpen = true
  readDesc = "<i>Zombiefier</i>"
  actorTravelingWithin(origin, dest){
        if((dest == zombieBooth) &&
           (zombieBooth.controlsSet == true) &&
           (zombieBooth.hasUsed == nil) && 
           (mastersCorpse.location != zombieBooth)
          ){
              "You enter the booth. The door slides shut, closing you in the dark and you hear a click. ";
              inputManager.pauseForMore(true);// better than using just the morePrompt()
              "<HR ALIGN=CENTER NOSHADE><br>";
              gameMain.is_a_zombie = true;
              "A beam of energy shoots down at you from above. You feel sharp pain winding its way down through
              your body. You hear a sickening crunch in your back and you hunch over feeling sluggish but a little bit stronger than
              before. Your mind empties of all but the simplest of thoughts. Blood... brains... The transformation is
              complete and the machine shuts off and the door opens up again. You hear a nasaly male voice say,\"Zombification complete.\" ";
              zombieBooth.hasUsed = true;
              zombieBooth.makeOpen(true);
              zombieBooth.makeLocked(nil);
          }
  }
  dobjFor(Close)
    {
        verify()
        {
            if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. ');

            /* it makes no sense to close something that's already closed */
            if (!isOpen)
                illogicalAlready(&alreadyClosedMsg);
        }
        action()
        {
            /* make it closed */
            makeOpen(nil);

            /* show the default report */
            defaultReport(&okayCloseMsg);
        }
    }
  dobjFor(Open){
         verify(){ if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. '); 
                   inherited(); 
         }
         check(){ inherited(); }
         action(){ inherited(); }         
  }
  desc {
     if(gActor.isDirectlyIn(self)){
           if(gActor.ofKind(Male)){
                 "The inside of the booth has plain white metal walls. 
                 A strange array up above and just in reach seems to contain the beam device or ray gun or
                 whatever that allegedly saves copies of peoples bodies. ";
                 if(zombieBooth.hasUsed){
                         "You\'ve arleady turned yourself into a zombie so there\'s really no need for you to be in here anymore. ";
                 }
           }else{
                 "The ceiling is pretty high. The zombification array mounted up there is out of your reach now,
                 though you could easily reach it if you were still a boy. The ceiling, walls and floor 
                 are made up of plain white metal. ";
           }
     }else{
           "From outside you can see the booth has white metal walls. There is a control panel on it.
            There\'s writing in white letters above the door that indicate this is a zombification booth. ";
     }
  }
  tooDistantMsg = (gPlayerChar.location == zombieBooth) ? 'You can\'t reach anything from inside the booth. ' : 'You need to go in the booth first to reach {that dobj/him}. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        if(gPlayerChar.location == zombieBooth) return nil;
        if((gPlayerChar.location != zombieBooth) && (obj.location == zombieBooth)) return nil;
        return true;
  }
  iobjFor(TakeFrom)
    {
        verify()
        {
            /* check what we know about the dobj */
            if (gDobj == nil)
            {
                /* 
                 *   We haven't yet resolved the direct object; check the
                 *   tentative direct object list, and count us as
                 *   illogical if none of the possible direct objects are
                 *   in me.  
                 */
                if (gTentativeDobj.indexWhich({x: x.obj_.isIn(self)}) == nil)
                    illogicalAlready(takeFromNotInMessage);
                else if (gTentativeDobj.indexWhich(
                    {x: x.obj_.isDirectlyIn(self)}) != nil)
                    logicalRank(150, 'directly in');
            }
            else if (!gDobj.isIn(self))
            {
                /* 
                 *   the dobj isn't in me, so it's obviously not logical
                 *   to take the dobj out of me 
                 */
                illogicalAlready(takeFromNotInMessage);
            }
            else if (gDobj.isDirectlyIn(self))
            {
                /* 
                 *   it's slightly more likely that they want to remove
                 *   the object from its direct container 
                 */
                logicalRank(150, 'directly in');
            }
        }
        check(){
            if((gDobj.location == zombieBooth) &&
               (gActor.location != zombieBooth)
               ){
                "You can\'t reach it from outside the booth. ";
                exit;
            }
            inherited();
        }
    }
    dobjFor(Use) remapTo(Use, zombieControls)
    // from the Occluder class... - remove if you remove Occluder from this object
    occludeObj(obj, sense, pov){
        /* by default, simply ask the object what it thinks */
        // return obj.isOccludedBy(self, sense, pov);// the default
        // we override the default for special occluded objects
        if(obj != nil){
               if(pov.isIn(zombieBooth)){
                    // if point of view is on roof then the desk is occluded (blocked) from view
                    if(obj == zombieControls) return true;
                    if((obj.isIn(mansionBasementBack)) && (zombieBooth.isOpen == nil)) return true;
               }
               if(pov.isIn(mansionBasementBack)){
                    if((obj.isIn(zombieBooth)) && (zombieBooth.isOpen != true) ) return true;
               } 
                         
        }
        // Note: Thing.t returns nil by default on a call to occludeObj(obj, sense, pov)
        // ...however we will return the default at this point for the Occluder class, which is to ask the object what to do
        return obj.isOccludedBy(self, sense, pov);// the default
    }
;
+ zombieControls: Fixture 
  vocabWords = '(human) (body) (zombie) (zomby) (zombification) (zombifier) (zombifyer) (making) (booth) (machine) (device) (invention) (view) key keys keypad keyboard board button buttons lever levers switch switches panel screen viewscreen control*controls' 
  name = 'controls'
  desc = "Though there are buttons, levers and switches all over the outside of the booth of various colors, sizes and shapes, 
          the main control panel is fairly straightforward enough. A simple keyboard and viewscreen. "
  dobjFor(Use){
         verify(){ logicalRank(110,'');
         }
         action(){
               if((gameMain.is_a_zombie) && (mastersCorpse.location != zombieBooth)){
                      "There\'s no reason to mess with the controls. You already turned yourself into a zombie. ";
                      exit;            
               }
               if(zombieBooth.contents != nil){
                     local obj = nil;
                     local oActor = nil;
                     foreach(obj in zombieBooth.contents){
                          if(obj.ofKind(Decoration)) oActor = obj;
                     }
                     if(obj != nil){
                          if(oActor != nil){
                               if(mastersCorpse == oActor){
                                   "You set the controls to zombify a standard human body. You activate the machine and watch the little door close.
                                   You put the Master\'s corpse in there and now you\'re going to be giving him a little taste of his own medicine. 
                                   The machine hums to life for a minute and then shuts off again and the door slides open. You see the green skinned
                                   Master slowly climb back up to his feet. He shuffles out of the booth and looks down at himself and 
                                   screams,\"Rrrrrraaaaaaaaaaaarrrrr!\"<.p>";
                                   mastersCorpse.moveIntoForTravel(pixyland);
                                   zombieMaster.moveIntoForTravel(mansionBasementBack);
                                   if(gameMain.is_a_zombie != true){
                                          "\"That\'s right. You\'re a zombie now. How do you like it?\" you ask feeling rather proud of yourself for
                                          thinking of this. \"Now you\'re <i>my</i> slave. Obey me, zombie!\"<.p>"; 
                                   }
                                   if(idolOfZakra.isHeldBy(gPlayerChar)){
                                                    "The idol grows warm in your hands momentarily and the new zombie shuffles towards you and nods, waiting to follow.<.p>";
                                                    zombieMaster.setCurState(zombieFollowing); 
                                   }else{
                                                    "The zombie growls at you and slugs his arm towards you from the shoulder. \"Rrrrrrrrrraaaaaaa!\"<.p>
                                                    He walks over to the workbench and starts smashing things. He picks up a beaker and crams it up his nose
                                                    and sneezes it violently out again and flails his arms across the workbench, casting everything to the floor. 
                                                    He picks up the chair and waves it in the air. \"Rrrrrrrrrrrrrrrrrrrrraaaaaaaarrrrr!\"<.p>You\'d better do 
                                                    something fast before he runs out of stuff to destroy. That\'s one ticked off zombie you\'ve created.<.p>";
                                                    workbenchBeakers.moveInto(pixyland);
                                                    workBenchTools.moveInto(pixyland);
                                                    workbenchDevestation.moveInto(mansionBasementBack);
                                                    workbenchDevestationTwo.moveInto(mansionBasementBack);
                                                    zombieMaster.setCurState(zombieMasterEnraged);
                                   }
                                   zombifiedTheMasterAchievement.awardPointsOnce();
                                   exit;
                               }else{
                                   gMessageParams(oActor);
                                   local s0 = 'You don\'t need to zombify \^{subj oActor}{the/he}. ';
                                   say(s0);
                                   exit;                                
                               } 
                          }else{
                               gMessageParams(obj);
                               local s1 = 'You can\'t zombify {subj obj}{the/he}. ';
                               say(s1); 
                               exit;
                          }
                     }
               }
               if(zombieBooth.hasUsed == nil){
                          /* Let's do it! */
                          if(zombieBooth.controlsSet != nil){
                               "You\'ve already set the controls. The automatic timer is ticking. Now you\'ve just got to enter the booth and wait
                               for this machine to do its thing. ";
                          }else{
                               "The controls on this machine are rather simple. You set them to zombify a standard human body. The timer\'s set. Now it\'s
                               time for you to put somebody in there to turn them into a zombie. ";
                               zombieBooth.controlsSet =  true;
                          }
               }else{
                           "You\'ve already turned yourself into a zombie. ";
                           exit;
               }
         }
  }  
;
+ cellarStairsUpThree :  StairwayUp  
  destination = mansionBackHall
  otherSide = cellarStairsDownThree
  vocabWords = '(old) (wood) (wooden) (stair) case/staircase/stairs' 
  name = 'stairs'
  desc = "The old wooden staircase leads up into the mansion. "
  travelBarrier = [] // [noUpIfHiding,noUpUntilGirlified,noUpWithoutOutfit,noUpWithoutHairBrushed,noUpWithoutMakeUpOn]
  noteTraversal(traveler) {  
      if((gameMain.is_a_zombie) && (zombifiedTheMasterAchievement.scoreCount < 1)){
          "You shuffle up the stairs at a painfully slow zombie\'s pace. \"Grrrrrrrrrrrr....braaaaaaaaaains....\" ";
      }else if(!climbed) { 
         "You climb the stairs and arrive in a little hallway. ";
         climbed = true; 
      } 
  } 
  climbed = nil 
; 
+ mnsnBasementDoorInnerTwo : LockableWithKey, Door -> mansionBasementDoor04 
  vocabWords = '(wood) (wooden) (mansion) (basement) (side) door/hatch' 
  name = 'basement door'
  desc = "A wooden basement door. "
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
;
+ basementWorkBenchChair: Heavy, Chair '(big) (giant) (huge) (tall) (fancy) (work) (workbench) (bench) (wood) (wooden) (desk) chair/stool' 'workbench chair'
  "A wooden workbench chair. <<(gPlayerChar.pcHeight == '2\' 8\"') ? 'It\'s huge beside your tiny body. ' : ''>> "
  actorTravelingWithin(origin, dest){
        if((dest == basementWorkBenchChair) &&
           (gPlayerChar.pcHeight == '2\' 8\"')
          ){
                "You climb up onto the chair. It\'s a little difficult as you\'re so little now and the chair is so big but you manage it. ";
        }else if((dest == mansionParlor) && 
                 (origin == mastersChair) && 
                 (gPlayerChar.pcHeight == '2\' 8\"')
                ){
                "You climb down off the chair and slide down to the floor. ";
        }
  }
  dobjFor(Climb) maybeRemapTo((gPlayerChar.pcHeight == '2\' 8\"'),StandOn,basementWorkBenchChair)
;
+ basementWorkBench: Heavy '(brown) (stained) (wood) (wooden) (dressing) (master\'s) workbench table' 'workbench'
  "A wooden workbench <<(workbenchDevestation.location == mansionBasementBack) ? 'with everything that was on it now smashed all over the floor thanks to the Master zombie\'s fit. ' : 'with some beakers and other chemistry tools and supplies on it. '>>"
  iobjFor(PutOn) maybeRemapTo((gDobj !=nil),PutOn,gDobj,workBenchTop)
  iobjFor(TakeFrom) maybeRemapTo(((gDobj !=nil) && (gDobj.isOn(workBenchTop))),TakeFrom,gDobj,mastersDeskTop)
  dobjFor(LookOn) remapTo(LookOn,workBenchTop)
;
+ workBenchTop: OutOfReach, Heavy, Surface '(brown) (stained) (wood) (wooden) (dressing) (master\'s) (workbench) (table) top surface' 'workbench top'
  "The top of the workbench. "
  canObjReachContents(obj) { 
        if((obj == gPlayerChar) && (gPlayerChar.pcHeight == '2\' 8\"') && (gPlayerChar.location != basementWorkBenchChair)) return nil;
        return true;
  }
  tooDistantMsg = 'You\'re too short to reach the top of the workbench. Maybe if you climbed up into the chair you could reach. '
  cannotReachFromOutsideMsg(dest) { return &tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  &tooDistantMsg; }
;
++ workbenchBeakers: Decoration '(glass) (chemistry) (alchemy) chemical chemicals potion potions beaker*beakers' 'beakers'
  "Some glass beakers on top of the workbench. You have no idea what the chemicals are in them. "
  isPlural = true
;
++ workBenchTools: Decoration '(chemistry) (alchemy) (bunsen) burner burners tool*tools' 'tools'
  "Some chemistry tools on the workbench. You\'re not sure how to use them so it\'s best to leave them alone. "
  isPlural = true
;

/*
 *  The out of control Master zombie destroys everything on the workbench 
 */
workbenchDevestation: Decoration '(glass) (chemistry) (alchemy) (destroyed) (broken) (spilled) spill mess chemical chemicals potion potions beaker*beakers' 'broken beakers'
  "There are broken beakers and chemicals everywhere on the floor around the workbench. The Master zombie sure made a mess. "
  isPlural = true
  location = pixyland
;

workbenchDevestationTwo: Decoration '(chemistry) (alchemy) (destroyed) (broken) (bunsen) burner burners mess tool*tools' 'tools'
  "There are broken chemistry tools everywhere on the floor around the workbench thanks to the tantrum the Master zombie threw. "
  isPlural = true
  location = pixyland
;

mansionBackHall: Room 'hallway'
  askedForHelp = nil
  diedAsZombie = nil
  desc {
      "A back hallway in the mansion. There is a staircase leading ";
      if(gameMain.allowHtmlLinks){
            "<a href=\"down\">down</a>";
      }else{
            "down"; 
      }  
      " to the basement here. The red carpeted hallway heads ";
      if(gameMain.allowHtmlLinks){
            "<a href=\"south\">south</a>";
      }else{
            "south"; 
      }  
      " from here. ";
      if((gameMain.is_a_zombie==true) && (mansionBackHall.askedForHelp == nil)){
                       if(mansionBackHall.diedAsZombie == true){
                            "You see the severed remains of a zombie lying in a pool of blood on the floor.<.p> ";
                       }                       
                       "You see Kristy the maid. The woman who made you give her your form cube. She spots you and screams,\"Aaaaaa a zombie! Help!\"<.p>
                       She hits you on the head with a frying pan.<.p>Clang!<.p>Next thing you know, you\'re on the floor and she\'s severing your limbs with
                       a meat cleaver. Pretty gross stuff but you can\'t blame her. After all, you\'re a zombie and she\'s one tough cookie. She runs out and
                       comes back with a goldfish bowl and breaks it over your head, then leaves and comes back with a chainsaw to finish you off. You watch in
                       disbelief as the little woman somehow manages to get the thing started. She raises it high above her head and says,\"Die you hideous
                       fiend!\"<.p>
                       You feel the chainsaw cut into your neck and you die.<.p>                      
                       Well, it seems that you have met an untimely fate. I can try and reincarnate you but I\'m pretty rusty at it and I can\'t
                       guarantee I can put you back together again the way you were before. ";
                       local iDone = 0; 
                       local s0 = '';
                       do{
                                            "<br>Do you wish for a reincarnation? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
                       }while(iDone==0);
                       if(s0 == 'n' || s0 == 'no'){
                                           finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                                           exit;
                       } 
                       "You are engulfed in a cloud of orange smoke....cough....cough....choke................choke.....<.p>";
                       inputManager.pauseForMore(true);// better than using just the morePrompt()
                       gameMain.is_a_zombie = nil;
                       zombieBooth.controlsSet = nil;
                       zombieBooth.hasUsed = nil;
                       idolOfZakra.moveInto(treasureChest);
                       treasureChestKey.moveInto(mastersDrawer);
                       gameMain.is_a_zombie = nil;
                       zombieBooth.hasUsed = nil;
                       me.pcHeight = '5\' 3\"';
                       "...when the smoke clears you are someplace else.<.p> ";
                       local iForm = rand(100)+1;
                               if((mansionBackHall.diedAsZombie == true) || (iForm > 85)){
                                           "You are standing in the woods on all fours. You are an adolescent female deer.<.p>
                                           From the look of your surroundings you would guess that you\'re many kilometers away from the island you were on 
                                           in the mountain lake. ";    
                                           mansionBackHall.diedAsZombie = true;
                                           setPlayer(doe);//see end of actor.t file for this command **** NOTE: this is better than just-> libGlobal.playerChar = actor; (because it does a PoV remap too)
                                           exit;
                               }else if(iForm < 15){
                                           "You are sitting on a white carpeted floor in a pink walled bedroom. You glance down at yourself and
                                           notice you have little hands, little fingers and little feet in little shoes. You\'re wearing a little white
                                           play dress and are carrying a baby doll.<.p>It looks like you\'ve reincarnated as a little girl. I\'m sorry but 
                                           I did warn you I\'m not very good at these. Unfortunately this only makes things worse for your ever being able to
                                           change back into a man again. Looks like this is....<b>The End</b> ";
                                           finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                                           exit;
                               }else{
                                           mansionBackHall.diedAsZombie = true;
                                           "You are standing in the basement and you are no longer a zombie. You\'re still a girl and you still 
                                           need to find help for <<boyfriend.properName>> who lies in pain alone in the jungle.<.p>";
                                           formCubeTwo.moveInto(gPlayerChar);
                                           gPlayerChar.moveIntoForTravel(mansionBasementBack);
                                           gPlayerChar.lookAround(true);
                               }
                       exit;
      }else if((gameMain.is_a_zombie ==  nil) && (mansionBackHall.askedForHelp == nil)){
                        "You see Kristy the maid. The woman who made you give her your form cube. She spots you and says,\"I thought I told you to
                        stay put. What are you doing here? Why didn\'t you listen? I have half a mind to erase your form cube for this.\"<.p>\"My boyfriend
                        <<boyfriend.properName>> and I got in an auto accident. He crashed his truck into a tree and it threw us both down into a ravine. He\'s
                        hurt really bad. You\'ve got to send for help,\" you explain.<.p>\"That\'s terrible. Where at?\" she asks.<.p>\"Just past the graveyard.
                        Please, you\'ve got to help him,\" you plead.<.p>\"Okay, fine. You stay here. Don\'t go exploring the mansion or the Master or one of
                        the other servants will find you and you\'ll be in big trouble. I\'ll go phone for help then grab a first aid kit and head over to the
                        crash site and see what I can do for him. When I get back I\'ll give you a ride back into town,\" Kristy says heading off.<.p> ";
                        mansionBackHall.askedForHelp = true;
      }
  }
  down = cellarStairsDownThree
  south : TravelWithMessage, ThroughPassage {
      desc = "A long red carpeted hallway leading south into the mansion. "
      travelDesc {
                if(gameMain.is_a_zombie == true){
                        "You shuffle your zombie feet slowly down the hall. ";                  
                }else{
                        if(mansionBackHall.cookSawYou == nil){
                            "The cook spots you, runs away and screams,\"Intruder! Intruder in the house! Master, an intruder is in the house!\"<.p>";
                             mansionBackHall.cookSawYou = true;
                        }else{
                            "You head down the hall. ";
                        }
                }
      }
      destination = mansionBackHallSouth
  }
  cookSawYou = nil
;
+ Decoration '(red) carpet/rug' 'red carpet'
  "An ordinary red carpet lining the hallway. "
;
+ cellarStairsDownThree :  StairwayUp  
  destination = mansionBasementBack
  otherSide = cellarStairsUpThree
  vocabWords = '(old) (wood) (wooden) (stair) case/staircase/stairs' 
  name = 'stairs'
  desc = "The old wooden staircase leads down into the basement. "
  travelBarrier = [] 
  noteTraversal(traveler) {  
    if((gameMain.is_a_zombie) && (zombifiedTheMasterAchievement.scoreCount < 1)){
            "You shuffle down the stairs at a painfully slow zombie\'s pace. \"Grrrrrrrrr...... bloooooooood....\" ";
    }else if(!climbed) { 
          "You climb the stairs and arrive in the basement. ";
          climbed = true; 
    } 
  } 
  climbed = nil 
; 

mansionBackHallSouth: Room 'hall'
   desc {
        "This is the south end of a long red carpeted hallway. 
        The parlor is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
        }else{
                "east"; 
        }  
        ". There is a green painted door with a strange red and white target painted on it to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
        }else{
                "west"; 
        }  
        ". There is also a way to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
        }else{
                "north"; 
        }  
        " from here. ";
   }
   in = west
   east : TravelWithMessage, ThroughPassage {
      desc = "A long red carpeted hallway leading south into the mansion. "
      travelDesc {
                if(gameMain.is_a_zombie == true){
                        "You shuffle your zombie feet slowly out into the parlor. ";                  
                }else{
                        if(mansionBackHall.cookSawYou != nil){
                            "\"She\'s over here master, and she\'s <i>shrunk</i>!\" you hear the cook say in the next room. ";
                        }else{
                            "You head out into the parlor. ";
                        }
                }
      }
      destination = mansionParlor
  }
  north = mansionBackHall
  west = maidsRoomDoor.ofKind(Door) ? maidsRoomDoor : maidsRoom
;
+ Decoration '(red) carpet/rug' 'red carpet'
  "An ordinary red carpet lining the hallway. "
;
+ Decoration '(strange) (weird) (funny) (maid\'s) (room) (green) (door) (red) (and) (white) target' 'target'
  "A strange red and white target is painted on the green door. "
;
+ maidsRoomDoor : LockableWithKey, Door '(green) (painted) (maid\'s) (Kristy\'s) (Kristie\'s) (bedroom) (room) (wood) (wooden) (mansion) door' 'door'
  "A green painted wooden door with a red and white target painted on it. "
  keyList = [gmDmSkeletonKey,maidsRoomKey]
  initiallyLocked = true
  dobjFor(Enter){
        verify(){ logicalRank(120,'likely'); 
                  inherited;
        }
        check(){ inherited; }
        action(){ inherited; }
  }
  dobjFor(TravelVia){
      verify(){ logicalRank(130,'very likely'); 
                // inherited;
      }
      check(){ inherited; }
      action(){ inherited; }
  }
  dobjFor(Break) remapTo(Attack, maidsRoomDoor)
  dobjFor(BreakWith) maybeRemapTo((gDobj !=nil),AttackWith,gDobj,maidsRoomDoor)
  dobjFor(Attack){
    verify(){ logicalRank(110,'likely'); }
    check(){ }
    action() { 
          // battleHandler.attack(gActor,self);
          askForIobj(AttackWith); 
    }
  }
  dobjFor(AttackWith){ 
     verify(){ 
         
     } 
     check(){
         if(maidsRoomDoor.getSuperclassList() != [LockableWithKey, Door]){ 
             say('You don\'t think the deity Zakrataktilak would be pleased by your abusing the idol\'s power. Best be glad you 
                  were granted the strength to break that door down using the Master\'s zombie cranium. Anything more would be overkill. '); 
             exit; 
         }
     }
     action(){ 
        if((gIobj == zombieMaster) && (idolOfZakra.isHeldBy(gPlayerChar))){ 
            setSuperclassList([Decoration]); 
            moveInto(getOutermostRoom); 
            maidsRoomDoorInner.moveInto(pixyland);
            "The golden idol radiates sudden raw strength throughout your body...<.p>
             You pick up the Master zombie with one arm and use his body as a battering ram, ramming his head into the door. He screams,\"Rrrrrrrrrrraaaaaaaaeeeeeeeee????!\"<.p>
             It\'s no good so you try it again.<.p>Bang! Crash!<.p>Still no good. One more time for good measure....<.p>
             \"Rrrrrrrrrrrrrrrreeeeeeeeeeeeeeee!!!\"<.p>...you break the door and it falls down into the hall. You set the master
             zombie down again and he rubs his head and looks at you with a rather pained, confused expression. ";
        }else{ 
            "{The iobj/he} simply bounces off the door. ";
        } 
     } 
  } 
; 

maidsRoom: ClothingRemovalRoom
  name = 'maid\'s room'
  desc {
        "This is the maid\'s bedroom. A simple little room with a cute little bed. ";
        "The way out is to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
        }else{
                "east"; 
        }  
        ". ";
  }
  out = east        
  east = (maidsRoomDoorInner.location != pixyland) ? maidsRoomDoorInner : mansionBackHallSouth
;
+ maidsRoomDoorInner : LockableWithKey, Door -> maidsRoomDoor
  vocabWords = '(green) (painted) (maid\'s) (Kristy\'s) (Kristie\'s) (bedroom) (room) (wood) (wooden) (mansion) door'
  name = 'door'
  desc = "A green painted wooden door. "
  keyList = [gmDmSkeletonKey,maidsRoomKey]
  initiallyLocked = true
;


maidsBed : Heavy, Bed '(simple) (little) (cute) (maid\'s) bed' 'bed'
  "This is the maid\'s bed. "
  location = maidsRoom
;
+ formCubeTwo: Readable, Thing 
    bulk = 2
    vocabWords = '(little) (black) (your) (old) (series) (one) (1) (revision) (0) (zero) (male) (human) (man\'s) (man) (body) (form) (square) M23D478XYA9 data disc/disk/box/block/cube' 
    name = 'form cube'
    desc { "It\'s a little black cube with writing on the side. ";
            if(gameMain.is_a_girl == true){
                   "It\'s got a copy of your old male body stored in there. Better not lose it! ";
            }else{
                   "It\'s got a copy of your current form stored in there somehow. ";
            }
    }    
    disambigName = 'your form cube'
    readDesc = "<i>Form cube<br>\n
                   Serial: M23D478XYA9<br>\n
                   Adult human male<br>\n
                   August 27, 2034<br>\n
                   Series 1, revision 0<br>\n</i>"
;


maidsRoomKey: Key
  vocabWords = '(maid\'s) (Kristy\'s) (Kristie\'s) (bedroom) (room) (door) (small) silver key'
  name = 'silver key'
  desc = "A small silver key. "
;


// use this way: stoppedTheMasterAchievement.awardPointsOnce();
stoppedTheMasterAchievement: Achievement
  desc {  
         "for ending the Master\'s diabolical plans. ";
  }
  points = 25 
;

/*
 *   If the player is on a chair s/he will have to get off the chair first
 *   to reach the treasure chest
 */
noTreasureIfOnChair : PreCondition
  checkPreCondition(obj, allowImplicit){
        if(gPlayerChar.location.ofKind(Chair)){
             tryImplicitAction(GetOffOf, gPlayerChar.location);
        }
        return nil; // nil is okay - check passed
  }
;


/*
 *  KeyedContainer: combines Openable and LockableWithKey into one class
 */
treasureChest :  RestrictedContainer, KeyedContainer, Heavy 
  vocabWords = '(the) (large) (big) (giant) (red) (painted) (black) (iron) (Master\'s) (treasure) trunk/chest'
  name = 'black iron chest'
  initSpecialDesc = "A large black iron chest sits in the corner to the left of the hearth. "
  initiallyLocked = true 
  keyList = [treasureChestKey] 
  validContents = [idolOfZakra,me] 
  location = mansionParlor
  notifyRemove(obj){
       // inherited;
       if(
         (gActor == gPlayerChar) && 
         (gPlayerChar.pcHeight == '2\' 8\"') &&
         (obj == idolOfZakra)
         ){
            "You get up on tiptoe and reach down into the large black iron chest and
            retrieve the golden idol. It\'s rather heavy and you almost drop it as you
            take it out of the chest but with diligent concentration you manage the task. ";
       }
  }
  notifyInsert(obj, newCont){
       if(
         (gActor == gPlayerChar) && 
         (gPlayerChar.pcHeight == '2\' 8\"') &&
         (obj == idolOfZakra)
         ){
            "You get up on tiptoe and reach down into the large black iron chest and
            set down the golden idol back where you found it. ";
       }
  }
  dobjFor(Unlock){
       preCond = [touchObj,noTreasureIfOnChair] 
       verify(){ inherited; }
       check(){ inherited; }
       action(){ inherited; }
  }
  dobjFor(Open){
       preCond = [touchObj,noTreasureIfOnChair]
       verify(){ inherited; }
       check(){ inherited; }
       action(){ inherited; }
  }
; 
+ idolOfZakra: Thing 
  name = 'golden idol'
  vocabWords = '(Aztec) (Mayan) (expensive) (valuable) (small) (sized) (medium) (very) (fairly) (heavy) (cursed) (necromancer\'s) (necromatic) (deity\'s) (God\'s) (gold) (golden) (of) male totem figure figurine statue idol Zakrataktilak Zakra Zak King Mictlan Chicunauhmictlan Mictlantecuhtli'
  desc = "A golden idol of Zakrataktilak. You heard tales about him from the locals. He is supposed to be a deity of necromancy.
         There is much superstition connected with this idol. Many of the locals fear the very mention of his name and any idols or totems like
         this are said to be cursed. As it is made of solid gold it is fairly heavy to carry around. It must be worth a fortune. 
         The body is a normal human male body but the head is a skull with eyeballs. It looks almost Aztec in origin. "
  weight = 15
;


mansionParlor: ClothingRemovalRoom 
  name = 'parlor'
  west = mansionBackHallSouth
  east = mansionLibrary
  desc {        
           if((gameMain.is_a_zombie==true) && (mansionParlor.chokedMaster == nil)){
                  "You arrive in the parlor. The Master is sitting at a desk here with his back to you. You can tell he\'s the Master
                   because he\'s got \"Master\" sewn in bright yellow letters on the back of his blue sports coat. 
                   You slowly shuffle up behind him, arms outstretched, hands clawing the air. You can\'t wait to
                   see the look on his face when you strangle him to death. You\'re inches away now and suddenly you
                   sneeze. \"Bless you,\" the Master says without turning. Suddenly his head lifts up from the book he
                   was studying. It\'s as though he\'s just realized it was no ordinary sneeze that you made but a deeper
                   monsterous sounding one. He turns and his jaw drops in horror as he spots you standing there. It\'s too
                   late for him. You clamber up the back of the chair and grab his throat and start choking him. He panics and grabs a flower vase and smashes it
                   over your head. The vase is destroyed but now you\'ve got a clump of dirt and some daisies upon your head. 
                   \"No!\" he screams. \"Stop it. You\'ll spoil everything you fool! Obey me! Obey! Back, back! Obey me!\"<.p>
                   \"Rrrrrrraaaaaaaarrrrrrr,\" you growl resuming your choke hold on him.<.p>He struggles free momentarily, trying
                   to catch his breath and says,\"This can\'t be happening... I created my zombie army to conquer the world. I can\'t
                   be destroyed by my own creation....\"<.p> ";
                   local iDone = 0; 
                   local s0 = '';
                   do{
                                            "<br>Do you finish him off? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
                   }while(iDone==0);
                   if(s0 == 'n' || s0 == 'no'){
                            "You decide to spare the Master. He gets a good safe four feet away from you, just far enough that if you shuffle towards
                            him he can simply side step out of your way. He says,\"You pint sized little twirp. You nearly strangled me half to death. 
                            Obey me. Go to the graveyard and wait with the others... and don\'t go through the kitchen. The floor\'s just been mopped and
                            I don\'t need zombie footprints all over the place in there.\"<.p>You feel compelled to obey him and carry out his orders. You 
                            shuffle slowly out of the house and to the graveyard to be with the other zombies. Soon the Master uses his zombie army, with you in it,
                            to take over the world.<.p><b>The End</b><.p> ";
                            finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                            exit; 
                   }else{
                            "You choke the Master until his face turns purple. He struggles one last time and breaks free but trips and falls to the floor
                            and breaks his neck and <<(mastersCorpse.location != zombieBooth) ? '<a href=\"drag corpse\">dies</a>' : 'dies'>>. 
                            You have the urge to eat his brains now but somehow you manage to hold back. You climb back down off the back of the chair. You\'ve 
                            just saved the world from the Master\'s diabolical plans. All you need to do now is get your form cube back and find a way to 
                            change yourself back to normal again. You\'re female, shrunk and turned into a zombie. It\'s enough to make you cry, if zombies 
                            could cry that is.<.p>";
                            mansionParlor.chokedMaster = true;
                            mastersCorpse.moveIntoForTravel(mansionParlor);
                            stoppedTheMasterAchievement.awardPointsOnce();
                            // if(formCube.location != mastersDrawer){
                            //   formCube.moveIntoForTravel(mastersDrawer);
                            // }
                   }
           }else if((gameMain.is_a_zombie ==  nil) && (mansionParlor.chokedMaster == nil)){
                   "As you enter the room the Master grabs hold of your little arm and says,\"I caught you, you little twirp. Now what have you to say for 
                    yourself?\"<.p>\"Change me back to normal right now or you\'ll be sorry,\" you say.<.p>He laughs down at you and says,\"You are in no
                    position to be making demands. Obviously you\'ve been snooping around where you don\'t belong. I see you\'ve found my shrink ray. I presume
                    you enjoyed my little trap I set for intruders in the backyard?\"<.p>\"You\'re a very bad man,\" you say but he ignores you.<.p>He says,\"I\'m
                    going to put you in my zombification machine and turn you into a proper slave. You\'ll join my army of zombies and together we will conquer the
                    world.\"<.p>
                    It looks like this is the end.<.p> ";
                    finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                    exit; 
           }
           "This is a large parlor with a desk and desk drawer. There is also a large couch, desk chair and hearth here. To the left of the hearth is a black iron chest.
           Exits are ";
           if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a> and <a href=\"west\">west</a>";
           }else{
                "east and west"; 
           }  
           ". On the desk is a rather bizarre photograph. ";
  }
  chokedMaster = nil
;
+ Decoration '(large) (big) (huge) (red) (brick) (fire) place/hearth/fireplace' 'hearth'
  "A red brick fireplace. "
;
+ mastersSofa: Heavy, Chair '(big) (giant) (huge) (tall) (wide) (fancy) (antique) sofa/couch/seat' 'antique sofa'
  "A fancy antique sofa. <<(gPlayerChar.pcHeight == '2\' 8\"') ? 'It\'s huge beside your tiny body. ' : ''>> "
  actorTravelingWithin(origin, dest){
        if((dest == mastersSofa) &&
           (gPlayerChar.pcHeight == '2\' 8\"')
          ){
                "You climb up onto the sofa. It\'s a little difficult as you\'re so little now and the sofa is so big but you manage it. ";
        }else if((dest == mansionParlor) && 
                 (origin == mastersSofa) && 
                 (gPlayerChar.pcHeight == '2\' 8\"')
                ){
                "You climb down off the sofa and slide down to the floor. ";
        }
  }
;
+ mastersChair: Heavy, Chair '(big) (giant) (huge) (tall) (fancy) (master\'s) (wood) (wooden) (desk) chair' 'desk chair'
  "A wooden desk chair. <<(gPlayerChar.pcHeight == '2\' 8\"') ? 'It\'s huge beside your tiny body. ' : ''>> "
  actorTravelingWithin(origin, dest){
        if((dest == mastersChair) &&
           (gPlayerChar.pcHeight == '2\' 8\"')
          ){
                "You climb up onto the chair. It\'s a little difficult as you\'re so little now and the chair is so big but you manage it. ";
        }else if((dest == mansionParlor) && 
                 (origin == mastersChair) && 
                 (gPlayerChar.pcHeight == '2\' 8\"')
                ){
                "You climb down off the chair and slide down to the floor. ";
        }
  }
  dobjFor(Climb) maybeRemapTo((gPlayerChar.pcHeight == '2\' 8\"'),StandOn,mastersChair)
;
+ mastersDeskTop: OutOfReach, Heavy, Surface '(brown) (stained) (wood) (wooden) (dressing) (master\'s) (desk) (table) top surface' 'desk top'
  "The top of the desk. "
  canObjReachContents(obj) { 
        if((obj == gPlayerChar) && (gPlayerChar.pcHeight == '2\' 8\"') && (gPlayerChar.location != mastersChair)) return nil;
        return true;
  }
  tooDistantMsg = 'You\'re too short to reach the desk top. Maybe if you climbed up into the chair you could reach. '
  cannotReachFromOutsideMsg(dest) { return &tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  &tooDistantMsg; }
;
+ mastersDesk: Heavy '(brown) (stained) (wood) (wooden) (dressing) (master\'s) desk table' 'desk'
  "A wooden desk. It has a<<(mastersDrawer.isOpen) ? 'n open drawer' : ' drawer which is closed'>>. There is a rather bizarre photograph
  on the desk. "
  dobjFor(Open) remapTo(Open,mastersDrawer)
  dobjFor(Close) remapTo(Close,mastersDrawer)
  iobjFor(PutOn) maybeRemapTo((gDobj !=nil),PutOn,gDobj,mastersDeskTop)
  iobjFor(TakeFrom) maybeRemapTo(((gDobj !=nil) && (gDobj.isOn(mastersDeskTop))),TakeFrom,gDobj,mastersDeskTop)
  dobjFor(LookOn) remapTo(LookOn,mastersDeskTop)
  iobjFor(PutIn) maybeRemapTo((gDobj !=nil),PutIn,gDobj,mastersDrawer)
 
;
/* Component class from objects.t - just means the object is non-portable and belongs to another.
 * Openable class from objects.t - note: do NOT set "isOpen = nil"... that overwrites 
 *                                       some "isOpen" code if you do. Also the default 
 *                                       "isInitiallyOpen" setting is nil (i.e. closed).
 */ 
++ mastersDrawer: OutOfReach, Openable, RestrictedContainer, Component  
   vocabWords = '(wood) (wooden) (dressing) (table) (master\'s) (desk) drawer' 
   name = 'drawer'
   desc = "An ordinary wooden desk drawer. "
   validContents=[blackLeatherPurse,formCube]
   /* Here we override the "cannotPutInMsg" function 
    * to say something than the default "&cannotPutInRestrictedMsg" library message.
    */
   cannotPutInMsg(obj) { return 'You shouldn\'t go putting things in there that don\'t belong. '; }
    /*
     *  DUH!  This is ALL we have to DO to handle CONDITIONAL out of reach objects!
     *  Tads queries this method so you can return true to make *some* objects (i.e.
     *  characters) be able to reach and return nil for everything you DON'T want to
     *  be able to reach! 
     * 
     */
    canObjReachContents(obj) { 
        if((obj == gPlayerChar) && (gPlayerChar.pcHeight == '2\' 8\"') && (gPlayerChar.location != mastersChair)) return nil;
        return true;
    }
    tooDistantMsg = 'You\'re too short to reach the desk drawer. Maybe if you <a href=\"climb chair\">climbed</a> up into the chair you could reach. '
    cannotReachFromOutsideMsg(dest) { return &tooDistantMsg; }
    cannotReachFromInsideMsg(dest) { return  &tooDistantMsg; }
    dobjFor(Open){
          preCond = [touchObj]
          verify(){ inherited; }
          check(){ 
              if(gActor == gPlayerChar){
                  if(gPlayerChar.pcHeight == '2\' 8\"'){
                       if(gPlayerChar.location != mastersChair){
                                 "You can\'t reach the desk drawer from here. You\'re too short. Maybe if you 
                                 <a href=\"climb chair\">climbed</a> the chair you could reach. ";
                                 exit;
                       }
                  }
              }
          inherited; }
          action(){ inherited; }
    }
;
+++ treasureChestKey: Key 
  vocabWords = '(the) (Master\'s) (big) (large) (huge) (wooden) (wood) (treasure) (chest) (small) (little) (tiny) gold key'
  name = 'gold key'
  desc = "A tiny gold key. "
;

mastersCorpse: Decoration '(the) (dead) (Master\'s) (Curly\'s) Curly body Master corpse' 'corpse'
  "This is the <<(mastersCorpse.location != zombieBooth) ? '<a href=\"drag corpse\">corpse</a>' : 'corpse'>> of the Master. It\'s hard to believe this is the same man who invented all these transformation machines and wanted to take over the world. 
  He\'s gone now. "
  isListed = true
  dobjFor(Pull){
           verify(){ logicalRank(110,'likely'); }
           check(){ 
                  if(mastersCorpse.location == zombieBooth){
                        "You hve no need to further pull the corpse anywhere. ";
                        exit;
                  }
                  local iWeight = gPlayerChar.getWeightHeld();
                  if(iWeight > 5){
                        "Good idea. It\'s always nice to tidy up<<(gameMain.is_a_zombie==true) ? ', even if you are a zombie,' : ''>> but the corpse is pretty heavy. You\'ll need to drop something first or you\'ll never manage the task. ";
                        exit;
                  }
           }
           action(){
                  local oRoom = nil;
                  if(mastersCorpse.location == mansionParlor){
                      "You pull the corpse into the hall. ";
                      oRoom = mansionBackHallSouth;
                  }else if(mastersCorpse.location == mansionBackHallSouth){
                      "You pull the corpse further down the hall. ";
                      oRoom = mansionBackHall;
                  }else if(mastersCorpse.location == mansionBackHall){
                      "You pull the corpse down the stairs into the basement. ";
                      oRoom = mansionBasementBack;
                  }else if(mastersCorpse.location == mansionBasementBack){
                       "You pull the corpse into the zombie booth. ";
                       oRoom = zombieBooth;
                  }
                  mastersCorpse.moveIntoForTravel(oRoom);
                  gPlayerChar.moveIntoForTravel(oRoom);
                  gPlayerChar.lookAround(true);
           }
  }
  iobjFor(AttackWith){ 
     verify(){ 
        if(gDobj != nil){
              if(gDobj == maidsRoomDoor) illogicalNow('Great idea and it would serve him right but right now you don\'t have the strength to lift the corpse and use it as a battering ram on the door. ');
        }
     } 
  }
  dobjFor(Drag) remapTo(Pull,mastersCorpse)
;

mastersPhoto: Readable, Decoration 
  name = 'bizarre photograph'
  vocabWords = '(the) (diabolical) (bald) (headed) (chubby) (fat) (bizarre) (bizaare) (top) (hatted) (black) (and) (white) picture photo swimmer Master/Curly plaque photograph'
  desc = "It\'s a photograph of the Master. The plaque reads: <i>Halloween 1935. Curly, the Master</i>. Seems like a funny name for a diobolical mad
         scientist. The man in the photo is bald, chubby and wearing a monacle and top hat with striped swim trunks. He\'s leaning on
         an umbrella with one hand and carrying a cream pie with the other. It\'s a rather old photo. The Master apparently is much
         older now and has lost a considerable amount of weight. "
  readDesc = "<i>Halloween 1935. Curly, the Master</i> "
  location = mastersDeskTop
;
+ Decoration 'cream pie' 'cream pie'
  "You can\'t tell what kind it is from the photo. Just that it\'s a cream pie. "
;
+ Decoration '(glass) monacle' 'monacle'
  "Just a monacle on the man in the photograph. "
;
+ Decoration '(black) (top) hat' 'top hat'
  "A black top hat. The man in the photo is wearing it. "
;
+ Decoration '(black) umbrella' 'umbrella'
  "The man in the photograph is leaning on a black umbrella. ";
;

// use this way: gettingPastWerewolfAchievement.awardPointsOnce();
gettingPastWerewolfAchievement: Achievement
  desc {  
         "getting past the werewolf. ";
  }
  points = 1 
;

// use this way: littleGirlEndingAchievement.awardPointsOnce();
littleGirlEndingAchievement: Achievement
  desc {  
         "winning the game as a little girl. ";
  }
  points = 1 
;

werewolf: Male, CromexxHuman
  name = 'werewolf'
  vocabWords = '(large) (big) (giant) (huge) (mean) (snarling) (hairy) (furry) (were) guardian werewolf/wolf/beast/monster'
  desc = "A big hairy werewolf with sharp claws and pointy fangs. "
  location = mansionLibrary
;
+ werewolfWaiting: HermitActorState 
  specialDesc = "A guardian werewolf is here. "
  noResponse = 'He growls in response. You don\'t speak werewolf but you\'re pretty sure whatever he said isn\'t friendly in nature. '
  isInitState = true 
; 
+ killMasterZombie: AgendaItem
  initiallyActive = true
  isReady = (
             (gPlayerChar.canSee(werewolf)) && 
             (zombieMaster.location == werewolf.location)
            ) 
  invokeItem {
           "As you enter the room a guardian werewolf lunges for the Master, your new pet zombie. The Master groans and claws back at the werewolf, wrestling him to
           the ground and putting him in a half nelson then brutally twists the werewolf\'s foot and begins gnawing on its big toe. The werewolf slaps its hand 
           repeatedly flat on the floor for mercy and the Master lets go. The werewolf goes running at full speed out of the library. You probably won\'t have 
           to deal with <i>him</i> again for awhile. ";
           werewolf.moveIntoForTravel(pixyland);
           gettingPastWerewolfAchievement.awardPointsOnce();
  }  
;
+ killPlayer : AgendaItem 
  initiallyActive = true
  isReady = (
             (gPlayerChar.canSee(werewolf)) && 
             (zombieMaster.location != werewolf.location)
            ) 
  invokeItem  { 
    "A guardian werewolf lunges for your throat and tears into your flesh, ripping you to shreds.<.p> 
     Well, it seems that you have died. I can try and reincarnate you but I\'m not too good at these things. I can\'t
     guarantee how you\'ll turn out. ";
                       local iDone = 0; 
                       local s0 = '';
                       do{
                                            "<br>Do you wish for a reincarnation? (yes/no) : ";
                                            s0 = inputManager.getInputLine(nil, nil);
                                            s0 = s0.toLower();
                                            if((s0 == 'y') || 
                                               (s0 == 'yes') ||
                                               (s0 == 'n') ||
                                               (s0 == 'no')
                                            ){ 
                                              iDone++;
                                            }
                       }while(iDone==0);
                       if(s0 == 'n' || s0 == 'no'){
                                           finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                                           exit;
                       } 
                       "You are engulfed in a cloud of orange smoke....cough....cough....choke................choke.....<.p>";
                       inputManager.pauseForMore(true);// better than using just the morePrompt()
                       "...when the smoke clears you are someplace else.<.p> ";
                       idolOfZakra.moveInto(treasureChest);
                       treasureChestKey.moveInto(mastersDrawer);
                       gameMain.is_a_zombie = nil;
                       zombieBooth.hasUsed = nil;
                       me.pcHeight = '5\' 3\"';
                       local iForm = rand(100)+1;
                               if((mansionBackHall.diedAsZombie == true) || (iForm > 85)){
                                           gameMain.is_a_zombie = nil;
                                           "You are standing in the woods on all fours. You are an adolescent female deer.<.p>
                                           From the look of your surroundings you would guess that you\'re many kilometers away from the island you were on 
                                           in the mountain lake. ";    
                                           mansionBackHall.diedAsZombie = true;
                                           setPlayer(doe);//see end of actor.t file for this command **** NOTE: this is better than just-> libGlobal.playerChar = actor; (because it does a PoV remap too)
                                           exit;
                               }else if(iForm < 15){
                                           "You are sitting on a white carpeted floor in a pink walled bedroom. You glance down at yourself and
                                           notice you have little hands, little fingers and little feet in little shoes. You\'re wearing a little white
                                           play dress and are carrying a baby doll.<.p>It looks like you\'ve reincarnated as a little girl. I\'m sorry but 
                                           I did warn you I\'m not very good at these. Unfortunately this only makes things worse for your ever being able to
                                           change back into a man again. Looks like this is....<b>The End</b> ";
                                           finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                                           exit;
                               }else{
                                           mansionBackHall.diedAsZombie = true;
                                           "You are standing in the basement. You are still a zombie girl and you still 
                                           need to find help for <<boyfriend.properName>> who lies in pain alone in the jungle.<.p>";
                                           formCubeTwo.moveInto(gPlayerChar);
                                           gPlayerChar.moveIntoForTravel(mansionBasementBack);
                                           gPlayerChar.lookAround(true);
                               }
                       exit;
  } 
; 

mansionLibrary: Room 'library'
  desc {
        if(
           (gPlayerChar.ofKind(LittleGirl)) ||
           (gameMain.is_a_little_girl == true) ||
           (gPlayerChar.pcHeight == '2\' 8\"')
        ){
              "You\'re so short the rows and rows of bookshelves in here are are as tall to you as a house. 
              There\'s a way back to the parlor to the ";
              if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
              }else{
                "west"; 
              }  
              ". A hall leads ";
              if(gameMain.allowHtmlLinks){
                "<a href=\"north\">north</a>";
              }else{
                "north"; 
              }  
              ". to the front door from here. "; //  A tiny green painted wooden door leads north. ";         
        }else{
              "There are rows and rows of bookshelves in here. There is a way to the parlor by going ";
              if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
              }else{
                "west"; 
              }  
              " and a green painted little wooden door leads ";
              if(gameMain.allowHtmlLinks){
                "<a href=\"north\">out</a>";
              }else{
                "north"; 
              }  
              ". ";
        }
        "A white metal booth sits in the center of the room. There is a control panel on it and a little slot on the side. ";
  }
  west = mansionParlor
  north: NoTravelMessage {
         travelDesc { 
                 if((kimmy.location == pixyland) && (gameMain.is_a_little_girl == true)){
                        // player normalized kimmy and scared her away to pixyland
                        "You walk out the front door of the mansion. The sun\'s setting and you\'ve just saved the world from the mad scientist\'s
                        diabolical plans. You got turned into a little girl by magic but Kimmy ran off with the book and wand so you don\'t know if you\'ll
                        ever be able to change back to normal again. As the sun sets you wonder what you\'ll do next and what new adventures await. Maybe
                        you\'ll go on a quest to find a way back to normal or maybe you\'ll just stay this way for awhile. Either way you know you\'re in for
                        interesting times ahead.<br><b>The End</b><.p> ";
                        // ********* bookmark!!!
                        littleGirlEndingAchievement.awardPointsOnce();
                        finishGameMsg(ftVictory,[finishOptionUndo,finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart,finishOptionAmusing]); 
                 }else if((gameMain.is_a_little_girl != true) && (gameMain.is_a_girl == true)){
                        "Sure, and win the game by leaving the mansion. You\'ve got the right idea all right but you seem
                        to be forgetting something. You\'ve stopped the Master and saved the world, which is nice, but remaining stuck as a woman
                        for the rest of your life... you\'re not so sure about that. ";
                        if(!gPlayerChar.hasSeen(formCubeTwo)){
                               "There\'s sure to be your form cube around here somewhere. With it you can change back to normal and <i>then</i>
                               leave the mansion and live happily ever after.<.p> ";
                        }
                        exit;
                 }else if((gameMain.is_a_girl == true) && (gameMain.is_a_little_girl == true)){
                        if(kimmy.age == 6){
                               "You walk out the front door, hand in hand with your new friend Kimmy. She\'s still got her hand clinging tightly to the magic wand
                               which she used to turn you into a little girl like herself. The magic book is tucked securely under her arm. You both walk down the
                               front steps and turn around to face the enormous mansion one last time. ";
                               if(idolOfZakra.isHeldBy(gPlayerChar)){
                                       if(zombieMasterFem.location == gPlayerChar.location){
                                               "The Master zombie looks down at the both of you and smiles her toothy smile.<.p>\"What are ya gonna do with <i>her</i>?\" 
                                                Kimmy asks.<.p>\"I don\'t know. I suppose we could take her with us trick or treating tonight,\" you suggest.<.p> ";
                                       }else if(zombieMaster.location == gPlayerChar.location){
                                               "The Master zombie looks down at the both of you and grunts something incoherent.
                                                <.p>\"What are ya gonna do with <i>that thing</i>?\" Kimmy asks.
                                                <.p>\"I don\'t know. I suppose we could take him with us trick or treating tonight,\" you suggest.<.p>";
                                       }
                               }
                               "You saved the world from the mad scientist\'s diabolical plans and turned yourself back to normal but then at the last minute
                               you decided to ask Kimmy to turn you into a little girl, which she did. Maybe deep down this is what you\'ve always wanted. A chance
                               to start life over again but this time as a girl.<.p>A brand new adventure awaits you and already the possibilities seem new and exciting.
                               You wonder how long the two of you can sneak by without any parents or guardians looking over you. You wonder how much fun it\'ll be 
                               sneaking from place to place as little girls. With no money for food or clothes you\'ll have to be clever but you\'re sure with the
                               right words you can coax grownups into helping a couple of cute little street rats. You wonder how long a life like that could possibly
                               last before the two of you are caught and forced into foster homes. If you\'re clever, maybe a few months, maybe longer. Kimmy\'s always
                               got that book of spells though. You\'re sure to get out of just about any fix with a handy book like that and a nifty magic wand.<.p>
                               The sun is setting on the horizon and its getting dark. There\'s a village just north of here where you could go trick-or-treating.
                               Then in the morning the two of you could sneak off to the dock and catch a boat ride home.<.p>With a smile on your face you head off
                               towards town with your newfound friend.<.p><b>The End</b> ";
                               littleGirlEndingAchievement.awardPointsOnce();
                               finishGameMsg(ftVictory,[finishOptionUndo,finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart,finishOptionAmusing]);  
                               exit;   
                        }else{
                               // unreachable - if kimmy is a woman and player is a little girl... this event should never happen
                        }
                 }else{
                       // male ending
                       "You walk out the front door and take a deep breath of fresh air outside. It\'s good to be back to your normal male self again.
                       You\'ve saved the world from the diabolical plans of the Master by turning him into one of his own creations. ";
                       if(idolOfZakra.isHeldBy(gPlayerChar)){
                                       if(zombieMasterFem.location == gPlayerChar.location){
                                               "The Master zombie looks at you and grunts. ";
                                       }else if(zombieMaster.location == gPlayerChar.location){
                                               "The Master zombie looks at you, waiting to follow. ";
                                       }
                       }
                       "The sun is setting. It\'s Halloween and you know there\'s a party probably getting started right now in the little village just north of
                       here. The boat won\'t be here to pick you up until morning and there are plenty of beautiful young women just waiting for you at that 
                       Halloween party. You quicken your step and head in that direction. In the morning you\'ll go back to the main town on the western shore of
                       the lake and gather your things and take a taxi ride to the airport. Your girlfriend Sherry might have been avoiding you these past few weeks
                       but now, after a fantastic vacation like this, you think you\'re ready to confront her and patch things up. Maybe you\'ll even marry the girl.
                       Who knows? One thing\'s for sure, you\'ve obtained a newfound appreciation for women and now that you\'re a man again you intend to make things
                       right. This vacation was the best thing that ever happened to you but you\'re certain that more adventures lie ahead. The mansion\'s worthy of
                       further exploration and maybe some day you\'ll return again for some fun with those crazy machines. Until then you\'ve got a life to get back
                       to. Off in the distance you hear the howling of wolves and as the sun finishes setting you see there\'s a full moon out. A perfect night for
                       Halloween and still enough time for plenty of mischief.<.p><b>The End</b> ";
                       finishGameMsg(ftVictory,[finishOptionUndo,finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart,finishOptionAmusing]);  
                       exit;            
                 }                 
         }
  } 
;
+ Decoration '(front) (exit) (wood) (wooden) (heavy) door' 'front door'
  "An ordinary wooden front door. "
;
+ libraryBookCase: Fixture
 name = 'bookshelf'
 vocabWords = '(book) bookshelf/bookcase/case/shelf'
 desc = "A bookshelf with books on it. "
;
+ bookshelvesLib: Decoration 'bookshelves/shelves' 'bookshelves'
 "There are many bookshelves in this little mansion library. "
  isPlural = true
;
+ cubeSlot: Fixture, RestrictedContainer
 vocabWords = '(small) (tiny) (little) (cube) receptical chamber slot'
 name = 'cube slot'
 desc = "A small cube slot for inserting form cubes. "
 validContents = [formCubeTwo, formCube]
;
/*
 *   OutOfReach conditionally... if we are inside it we can not interact with objects outside of it
 */
+ normalizerBooth:  OutOfReach, Heavy, LockableWithKey, Readable, Occluder, OpenableContainer, Booth
  controlsSet = nil
  hasUsed = nil
  name = 'normalizer booth'
  vocabWords = '(human) (body) (normalizing) (normalization) machine invention chamber door normalizer booth'
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  initiallyOpen = true
  readDesc = "<i>Normalizerr</i>"
  actorTravelingWithin(origin, dest){
        if((dest == normalizerBooth) &&
           (normalizerBooth.controlsSet == true) &&
           (normalizerBooth.hasUsed == nil) && 
           (gActor == gPlayerChar) &&
           (cubeSlot.contents != nil)
          ){
              "You enter the booth. The door slides shut, closing you in the dark and you hear a click. ";
              inputManager.pauseForMore(true);// better than using just the morePrompt()
              "<HR ALIGN=CENTER NOSHADE><br>";
              gameMain.is_a_zombie = nil;
              "A beam of energy shoots down at you from above. You feel yourself changing ";
              if(gameMain.is_a_girl == true){
                    " back to into a man. ";
              }else{
                    " back to normal. ";
              }

              foreach(local obj in gPlayerChar.contents){
                      if(obj.isWornBy(gPlayerChar)){
                           obj.makeWornBy(nil);
                           obj.moveIntoForTravel(pixyland);
                      }
              }

              tempPlayerClothes.moveInto(gPlayerChar);
              tempPlayerClothes.makeWornBy(gPlayerChar);
              gameMain.girlType = girlingBooth.girlType;
              mePenis.moveIntoForTravel(gPlayerChar);
              noPenis.moveInto(pixyland);
              me.is_A_Girl = nil;
              gPlayerChar.is_A_Girl = nil; // CromexxHuman class needs this set for clothes handling
              gameMain.is_a_girl = nil; // this is the KEY variable to set for sex changing player
              girlingBooth.playerGirlified = nil;
              me.pcAge = 18;
              me.pcHeight = '6\' 0\"';
              me.pcHair = 'brown';
              me.pcEyes = 'blue';

              if(gameMain.is_a_zombie == true){
                gameMain.is_a_zombie = nil;
                zombieBooth.hasUsed = nil;
              }
              if(gPlayerChar.pcHeight == '2\' 8\"'){
                if(gameMain.is_a_girl==true){
                    me.pcHeight = '5\' 3\"';
                 }else{
                    me.pcHeight = '6\' 0\"';
                }                
              }
              if(gameMain.is_a_little_girl==true){
                   me.pcAge = 18;
                   gameMain.is_a_little_girl = nil;
                   me.pcHeight = '5\' 3\"';
              }
              
              "The transformation is complete. Your body has been restored to its original condition and the machine shuts off.
              A pleasant sounding female voice says,\"Normalization process complete.\"<.p> ";
              normalizerBooth.hasUsed = true;
              normalizerBooth.makeOpen(true);
              normalizerBooth.makeLocked(nil);
          }
  }
  dobjFor(Close)
    {
        verify()
        {
            if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. ');

            /* it makes no sense to close something that's already closed */
            if (!isOpen)
                illogicalAlready(&alreadyClosedMsg);
        }
        action()
        {
            /* make it closed */
            makeOpen(nil);

            /* show the default report */
            defaultReport(&okayCloseMsg);
        }
    }
  dobjFor(Open){
         verify(){ if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. '); 
                   inherited(); 
         }
         check(){ inherited(); }
         action(){ inherited(); }         
  }
  desc {
     if(gActor.isDirectlyIn(self)){
           if(gActor.ofKind(Male)){
                 "The inside of the booth has plain white metal walls. 
                 A strange array up above and just in reach seems to contain the beam device or ray gun or
                 whatever that allegedly restores peoples bodies to normal. ";
                 if(normalizerBooth.hasUsed){
                         "You\'ve arleady normalized yourself, using up your form cube. ";
                 }
           }else{
                 "The ceiling is pretty high. The transformation array mounted up there is out of your reach,
                 though you could easily reach it if you were still a boy. The ceiling, walls and floor 
                 are made up of plain white metal. ";
           }
     }else{
           "From outside you can see the booth has white metal walls. There is a control panel on it and a cube slot to put
            form cubes in. There\'s writing in white letters above the door that indicate this is a normalization booth. ";
     }
  }
  tooDistantMsg = (gPlayerChar.location == normalizerBooth) ? 'You can\'t reach anything from inside the booth. ' : 'You need to go in the booth first to reach {that dobj/him}. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        if(gPlayerChar.location == normalizerBooth) return nil;
        if((gPlayerChar.location != normalizerBooth) && (obj.location == normalizerBooth)) return nil;
        return true;
  }
  iobjFor(TakeFrom)
    {
        verify()
        {
            /* check what we know about the dobj */
            if (gDobj == nil)
            {
                /* 
                 *   We haven't yet resolved the direct object; check the
                 *   tentative direct object list, and count us as
                 *   illogical if none of the possible direct objects are
                 *   in me.  
                 */
                if (gTentativeDobj.indexWhich({x: x.obj_.isIn(self)}) == nil)
                    illogicalAlready(takeFromNotInMessage);
                else if (gTentativeDobj.indexWhich(
                    {x: x.obj_.isDirectlyIn(self)}) != nil)
                    logicalRank(150, 'directly in');
            }
            else if (!gDobj.isIn(self))
            {
                /* 
                 *   the dobj isn't in me, so it's obviously not logical
                 *   to take the dobj out of me 
                 */
                illogicalAlready(takeFromNotInMessage);
            }
            else if (gDobj.isDirectlyIn(self))
            {
                /* 
                 *   it's slightly more likely that they want to remove
                 *   the object from its direct container 
                 */
                logicalRank(150, 'directly in');
            }
        }
        check(){
            if((gDobj.location == normalizerBooth) &&
               (gActor.location != normalizerBooth)
               ){
                "You can\'t reach it from outside the booth. ";
                exit;
            }
            inherited();
        }
    }
    dobjFor(Use) remapTo(Use, normalizerControls)
    // from the Occluder class... - remove if you remove Occluder from this object
    occludeObj(obj, sense, pov){
        /* by default, simply ask the object what it thinks */
        // return obj.isOccludedBy(self, sense, pov);// the default
        // we override the default for special occluded objects
        if(obj != nil){
               if(pov.isIn(normalizerBooth)){
                    // if point of view is on roof then the desk is occluded (blocked) from view
                    if(obj == normalizerControls) return true;
                    if((obj.isIn(mansionLibrary)) && (normalizerBooth.isOpen == nil)) return true;
               }
               if(pov.isIn(mansionLibrary)){
                    if((obj.isIn(normalizerBooth)) && (normalizerBooth.isOpen != true) ) return true;
               } 
                         
        }
        // Note: Thing.t returns nil by default on a call to occludeObj(obj, sense, pov)
        // ...however we will return the default at this point for the Occluder class, which is to ask the object what to do
        return obj.isOccludedBy(self, sense, pov);// the default
    }
;
+ normalizerControls: Fixture 
  vocabWords = '(human) (body) (normalizer) (normalization) (making) (booth) (machine) (device) (invention) (view) key keys keypad keyboard board button buttons lever levers switch switches panel screen viewscreen control*controls' 
  name = 'controls'
  desc = "Though there are buttons, levers and switches all over the outside of the booth of various colors, sizes and shapes, 
          the main control panel is fairly straightforward enough. A simple keyboard and viewscreen. "
  dobjFor(Use){
         verify(){ logicalRank(110,'');
         }
         action(){
               if((kimmy.location != normalizerBooth) && (gameMain.is_a_girl == nil)){
                      "There\'s no reason to mess with the controls. You\'re already your normal male self. ";
                      exit;            
               }
               if(formCubeTwo.location != cubeSlot){
                      "There\'s no form cube in the cube slot. ";
                      exit;
               }
               if(normalizerBooth.contents != nil){
                     local obj = nil;
                     local oActor = nil;
                     foreach(obj in normalizerBooth.contents){
                          if(obj.ofKind(Person)) oActor = obj;
                     }
                     if(obj != nil){
                          if(oActor != nil){
                               if(kimmy == oActor){
                                   if((formCubeTwo.location != cubeSlot) || (cubeSlot.contents == nil)){
                                          "There\'s nothing in the cube slot. You\'ll need to put a form cube in there fist before using the machine.<.p> ";
                                          exit;
                                   }
                                   "You set the controls to turn Kimmy into a copy of your normal adult male self.
                                   You activate the machine and watch the little door close as Kimmy exclaims excitedly inside,\"Weeeeeeeeeeeeee!\"<.p>
                                   The process takes only a few moments and the door opens up again and out steps a copy of your old male self. ";
                                   if(gameMain.is_a_girl == nil){
                                          "He looks down at himself, then over at you and points right at you and says,\"Hey! You turned me into a copy of
                                          yourself. You turned me back into a boy! No fair!\"<.p>He goes running out of the room. ";
                                          kimmy.moveIntoForTravel(pixyland); 
                                          exit;
                                   }else if(gameMain.is_a_little_girl != true){
                                          "He looks down at himself, then over at you and says,\"Hey, no fair turning me into a boy!\"<.p>He goes running out of
                                          the room.<.p>";
                                          kimmy.moveIntoForTravel(pixyland);
                                          exit;
                                   }else if(gameMain.is_a_little_girl == true){
                                         //if(gameMain.zort == 21){
                                          //    normalizerControls.zort();
                                          //    exit;
                                         // }
                                          "He looks down at you and laughs and says,\"Think I\'ll keep this body. You\'re a little girl and I\'m a grown man again.
                                          Sure is good to be back as a man. Though what are we going to do with <i>you</i> little one?\"<.p>
                                          \"Well, that\'s my original body. I could coach you on how to be me and you could go back and live my life out and have
                                          my job, my house and my girlfriend if you want,\" you suggest.<.p>
                                          \"I think I\'d like that,\" he says rather pleased with the idea. \"And I can take you back to town with me and 
                                          drop you off at the orphanage and maybe someone will adopt you.\"<.p>
                                          \"Why not take me home with you? My girlfriend might want to adopt me,\" you suggest.<.p>
                                          \"I\'m afraid that would be a very bad idea, little one,\" he says scruffing up your hair playfully. \"We can\'t take
                                          any chances of her finding out who you or I really are. I frimped you because you <i>wanted</i> to be frimped, remember?
                                          You\'re a little girl and you need a proper home and it would be irresponsible of me to just leave you here.\"<.p>
                                          You watch him take the form cube out of the slot and toss it up and down in the palm of his hand for awhile. He considers
                                          something and says,\"Of course I\'ll have to have this erased so nobody else can use it ever again. You understand, honey,
                                          don\'t you?\"<.p> ";
                                          inputManager.pauseForMore(true);// better than using just the morePrompt()
                                          "<HR ALIGN=CENTER NOSHADE><br>";                                          
                                          "\"But what if I wanted to change back to normal sometime?\" you ask.<.p>
                                          He chuckles and says,\"Only one of us can be you at any given time, pumpkin. I\'ll be you and you\'ll be a nice little
                                          girl. That\'s not so bad, is it?\"<.p>
                                          You glance down at your little feet in their little shoes and kick a foot gently into the other and say,\"But what if I
                                          decided I don\'t like it this way? Then what?\"<.p>
                                          He kneels down to your level and gives you a mock punch to the chin and says,\"Cheer up, it\'ll be okay. You\'ll see. You
                                          haven\'t changed your mind about coaching me to be you, have you?\"<.p>
                                          You shake your head no and reply,\"No. I\'ll still teach you.\"<.p>
                                          \"Good girl,\" he says scruffing your hair up a bit. \"Now let\'s get out of this nasty old mansion and off this spooky old
                                          island before anything else goes wrong. Look on the bright side. It\'s Halloween and your a little girl so guess what? I\'m
                                          taking you trick-or-treating tonight. How does that sound? And then afterward we can decide where you\'ll live.\"<.p>
                                          He leads you by the hand down to the docks where a little boat picks you up. On the ride back to the village you glance back
                                          at the island and wonder if you\'ll ever see it again. There\'s all those nifty transformation machines still back at the
                                          mansion. You glance at the square shaped lump in your old body\'s coat pocket and wonder if you could get a chance to steal back
                                          your form cube.<.p>\"Sherry... My girlfriend\'s name is Sherry. I like that,\" he says preoccupied in thought.<.p>You fold your
                                          little hands in your lap and think of the big empty space now in existance between your legs. You\'ve always liked girls but you
                                          never thought you\'d actually get the chance to be one, let alone grow up all over again that way. With this new body you\'ve 
                                          got an innate fondness for boys. A kind of puppy love just waiting to be unleashed. You don\'t even have to think about it twice to
                                          know it\'s true. It\'s a part of you now. An inbuilt weakness. Your kriptonite. The one thing that might trap you utterly is your 
                                          inescapable brand new inbuilt appreciation for boys. The fact that you used to be one only adds insult to injury, for you know what
                                          it feels like to be a boy. Bigger, stronger, more authoritive and in control. The decision maker. The problem solver. Things that used to be familiar to
                                          you but are now horribly out of reach. The shoulder to lean on. It\'s almost too much for you to bear. The loss is too great. All the things you\'ve lost
                                          in that old male life of yours you want close by. It\'s not just a mere gap in your life but an enormous chasm that requires filling up again
                                          but you\'re no longer qualified to fill it on your own. You need the help of a boy to do that.<.p>";
                                          inputManager.pauseForMore(true);// better than using just the morePrompt()
                                          "<HR ALIGN=CENTER NOSHADE><br>";                                          
                                          "You feel along the bottom edges of your pink play dress with tiny little fingers. You\'re a six year old little girl and in
                                          six or seven years you\'ll hit puberty and start the process of maturing into a beautiful young woman. If your newfound fondness for
                                          boys grows as well you know you\'ll be hopelessly lost in your new role as a girl. Yet there\'s Kimmy, now <<gameMain.ProperName>>, taking your
                                          place as a man while you\'ve been coerced into going along with this mad scheme of his. Grown men aren\'t supposed to wind up
                                          stuck in little girl\'s bodies.<.p>\"Don\'t slouch. Sit up straight,\" he tells you and you correct your posture for him.<.p>
                                          You\'ve lost not only your sex but your independence as an adult. It\'s the price to pay for a shot at playing the best hide and
                                          go seek game of a lifetime, you suppose. Unless you plan on telling anyone about what happened no one will ever know or ever believe you used to
                                          be a man. You\'ve set foot in undiscovered territory where no man was ever meant to be. You\'ll be using the girls bathroom from
                                          now on and it won\'t just be like a creepy peeping Tom peering through a peep hole in the wall in there, it\'ll be more like a peeping Tom
                                          who got changed into a little girl and who now has free reign over the entire place and can run all the faucets if she likes 
                                          or run in and out of any stall or smear soap all over the mirrors and crumple up paper towels and toss them out at all the boys
                                          passing by. Like being a naughty little girl who\'s apt to get in trouble all the time and get put over her father\'s knee for
                                          a spanking. Seemingly unlimited fun until it\'s time to pay for all your trouble making.<.p> ";
                                          inputManager.pauseForMore(true);// better than using just the morePrompt()
                                          "<HR ALIGN=CENTER NOSHADE><br>";                                          
                                          "The boat arrives at a little dock on the shore of the lake and your old male body helps you out of the boat, holding your hand
                                          as he leads you up to the little sidewalk. You spot the villa you rented before you took your trip to the island. You point 
                                          and exclaim,\"There\'s where I was staying! Right there.\"<.p>He nods and looks down at you, smiles and says,\"Then I\'d better
                                          pack my things and catch that plane ride home tomorrow, shouldn\'t I?\"<.p>He feels around in his pockets and produces your
                                          little form cube and says,\"What do you know about that. I forgot to have it erased it before we left the island.\"<.p>A little
                                          old lady walkd by and he stops her for a moment and has a few words with her. You don\'t know what they\'re talking about but she
                                          nods and accepts the form cube, putting it away in her purse before leaving.<.p>\"What was that all about?\" you ask him when he
                                          returns.<.p>\"Now don\'t you worry your little head over that. I gave it to her as a gift. I don\'t know if she\'ll use it as a paperweight
                                          or sell it or what but none of that matters now,\" he explains. \"The fact is neither of us have to worry about it ever again.\"<.p>
                                          That night he takes you trick-or-treating just as he promised he would. You wear some bright orange jumpers and paint your face up like
                                          a kitten. You get plenty of candy and the following morning he takes you down to the orphanage to say goodbye.<.p>";
                                          inputManager.pauseForMore(true);// better than using just the morePrompt()
                                          "<HR ALIGN=CENTER NOSHADE><br>";                                          
                                          "\"This looks like this is it, pumpkin,\" he says kneeling down to your level to have a last talk with you. The taxi\'s waiting
                                          nearby to take him to the airport and the driver looks rather impatienty at his watch.<.p>You shyly glance down at your little feet 
                                          almost ready to cry. You\'re all choked up. None of this seems right. It\'s all happening too fast. One minute you\'re a guy who\'s just
                                          out here on vacation. A guy with a job, a girlfriend and everything. The next you feel like you\'ve traded places with a total stranger
                                          who any minute now will be on his way to take over your life where you left off. \"Won\'t I <i>ever</i> be a boy again?\" you cry and he
                                          hugs you goodbye for a moment.<.p>He taps you on the side of your head and says,\"Cheer up, sport. We\'ve already had this talk. Remember what I told you. Think of this as
                                          a game. Just like hide-and-go-seek. You\'re a boy in that pretty little head of yours. Only you and I know that. Nobody else has to. You\'re
                                          hiding in the most perfect hide out, the best hiding place in the whole wide world where nobody can find you. Every day when you put on
                                          that cute little dress and those cute, shiny little shoes and socks of yours on your tiny little feet you\'ll have the upper hand on everybody
                                          because hiding behind those cute little blue eyes is a boy who\'s playing the best game of hide-and-go-seek he\'s ever played. Remember what
                                          I told you? You have to play \"pretends.\" You know how to play pretends don\'t you?\"<.p>
                                          You nod your head slowly yes but are too choked up with tears to say an answer. You know you\'ll have to pretend you were always a little
                                          girl or else people might get suspicious there\'s something the matter with you.<.p>
                                          \"Now I\'ve already spoken with the nice lady in the orphanage who will take you in,\" he says. \"There\'ll be other little girls your own
                                          age. Some will be older than you. You must be mindful of what they say and always be careful how you act and behave. There\'ll be dolls to
                                          play with. You have to play pretends and play with them so nobody will know who you really are. Do you think you\'re up to it, honey?\"<.p>
                                          You again nod your head slowly yes, tears pooling up in the corner of your eyes. You look up at him and ask,\"How long do I have to play 
                                          hide-and-seek for?\"<.p>He chuckles at you and playfully scruffs up your hair a little and says,\"The rest of your life, little one. The
                                          rest of your adorable little life.\"<.p>He hugs you once more and gives you a goodbye kiss on the cheek then sends you running up
                                          the steps to the lady from the orphanage who\'s been waiting for you this whole time. You turn and wave goodbye but <<gameMain.ProperName>>\'s already in 
                                          the taxi and it\'s already on its way to the airport. <.p>";
                                          inputManager.pauseForMore(true);// better than using just the morePrompt()
                                          "<HR ALIGN=CENTER NOSHADE><br>";    
                                          "You glance down the front of your dress and take hold of it by the bottom edges, running
                                          your fingers nervously back and forth along the smooth soft material. Wearing skirts and dresses are something you know you\'ll have to get used to
                                          now that you\'re a girl for good. You realize you have the option of wearing shorts or bluejeans too but you feel it might be better for the sake
                                          of playing pretends if you stuck with skirts and dresses.<.p>Most of your old male identity and memories seem to have carried over into your
                                          new little girl brain but there are some noticable gaps that will need filling up again. The magic spell that did this to you didn\'t just turn
                                          you into a little girl on the outside, it did a good job of dumbing down your intelligence to that of a little girl too. Things have definately been
                                          rewired and having the emotions of a little girl certainly isn\'t a help if you want to maintain a shred of your old male identity. You remember who
                                          you were before but you\'ve got the I.Q. and mannerisms of a little girl. The magic spell even toyed with your sexual identity, taking away your attraction
                                          towards girls and seeding your head with this horrible new and uncanny affection for boys. If there\'s one reason that stands above all others for why you
                                          want to change back to normal again it\'s so you can think about girls again, not boys, and so you can act like yourself once more.<.p>
                                          The lady takes you inside and introduces you to the other little girls at the orphanage. Before you know it you\'re sitting cross legged on 
                                          the floor with them and playing with dolls. It comes easy for you and maybe that\'s part of the magic spell too or maybe you\'ve let yourself
                                          slip up and fall too deeply into your new role. The grown-ups who work here glance over and seem pleased anyway. Playing with dolls is okay because
                                          <i>it\'s what they want - what the grown-ups expect you to do</i> and you\'re only complying with what they think you should be doing.<.p>
                                          You\'re playing hide-and-go-seek now. Your boy side\'s huddled in the corner with fingers up to his giddy giggle ridden teeth. He\'s having so
                                          much fun he\'s almost biting his nails in delight. You\'re playing dollies with the others and they all think you\'re a little girl, just like them.
                                          You\'ve been accepted into the crowd as one of them. You\'re wearing a pink play dress and underneith are some white cotton panties all snug and comfy 
                                          and flat up against your new girl part. Your boy part\'s gone, now somebody else is wearing it and gets to take it home to his new girlfriend. It seems
                                          funny to think that somebody else has got your boy part and that you\'ll never get it back again.<.p>";
                                          inputManager.pauseForMore(true);// better than using just the morePrompt()
                                          "<HR ALIGN=CENTER NOSHADE><br>";    
                                /* <--- edited
                                          "You wonder if there might be a way you could sneak out of the orphanage sometime and find that little old lady who now has your form 
                                          cube. Then you\'d have to sneak out to the island somehow and see if you can get back in the mansion and restore yourself back
                                          to normal but that adventure is for another time.<.p>You saved the world from the diabolical plans of a mad scientist and effectively
                                          traded places with a little girl. It frees you up for new and interesting possibilities and maybe even some fun and exciting new 
                                          adventures. Maybe it\'s the magic spell or maybe you\'ve always wanted this but you think you\'re going to have lots and lots of fun
                                          being a girl and you\'re more than a little curious about what it might be like to be a mommy and grow a baby in your tummy. Changing
                                          back into a man might be nice but you\'ve only just started playing hide-and-seek and you think it might be fun just to see how many
                                          people you can fool. So far none of them suspect you were ever anything other than a little girl and that gives you a warm and yummy feeling
                                          inside or maybe you just need to go potty.<.p>
                                          You set your dolly down and excuse yourself to go down the hall to use the bathroom. It\'s a nice big hall with lofty rafters high above and
                                          big old doors three times your size. You arrive at the bathroom door and go up on tiptoe to reach the big brass handle and let yourself in.
                                          You find an empty stall and close the door. You raise your pink play dress and tuck it up under your little arms and slide your
                                          panties down all the way to your ankles and climb up on the toilet seat and sit down. You relieve your bladder, urinating for the
                                          very first time as a girl. It\'s fun and different this way and you have to wipe afterwards, which you do, and that\'s fun and different feeling
                                          too. You climb down off the toilet seat and flush it then take a moment to look down at your body as you pull your panties back
                                          into place. You\'ve got one hand on your smooth flat little tummy as you peer curiously down at yourself. Your dress is still
                                          lifted up and tucked in a bundle up under your arms. The sight below is as incredible as it is impossible to comprehend. Pale white, smooth 
                                          skin all the way down past your navel, vanishing momentarily beneath white cotton panties and reappearing below and stretching all
                                          the way down your skinny little legs to your ankles, vanishing into a pair of white cotton socks and hiding within those cute little shiny
                                          black flats. You reach down and tug on your panties a little until you can see the faint outline of your sex. There\'s a slit instead of the
                                          familiar lumpy maleness you\'ve become accustomed to seeing there your whole life. Your crotch feels all turned inside out and different than
                                          it did before when you were a boy. It\'s all layered and smushed together, all helpless and alienlike than what you were used to before.<.p>
                                          You adjust your panties and lower your dress down over your waist once more, smoothing out the fabric as you glance down with ever the eye
                                          for detail as you make sure your dress is nice and neat and in place again. You open the stall door and walk over and use the sink to wash
                                          your hands. You have to stand on a little stool to reach but you manage the job somehow. Afterward you walk back to the play room and resume
                                          playing dolls with the other little girls.<.p> ";
                                          inputManager.pauseForMore(true);// better than using just the morePrompt()
                                          "<HR ALIGN=CENTER NOSHADE><br>"; 
                                 ---> edited */ 
                                          "You get real good at playing hide-and-seek but the idea of getting your old body back never fully leaves your mind.
                                          Meanwhile your replacement is off living your male life for you while you\'re stuck here in an orphanage as a little girl. 
                                          You wake up bright and early one morning and sneak outside. With the sun on your back and a hopeful yearning for adventure
                                          in your heart you set out to find your form cube. The mansion\'s out there on the island in the lake waiting for your return.
                                          You can hardly wait. The lake is misty with fog clinging low to the water in long tendrils as you walk out onto the pier to
                                          reflect upon the journey ahead. You squint up at the sun and turn around to face the town again. It\'s going to be a wonderful
                                          day.<.p><b>The End</b>";
                                          littleGirlEndingAchievement.awardPointsOnce();
                                          finishGameMsg(ftVictory,[finishOptionUndo,finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart,finishOptionAmusing]);  
                                          exit;
                                   }// end  if(gameMain.is_a_little_girl == true)
                               }// end if(kimmy == oActor)
                               else if((zombieMaster == oActor) || (zombieMasterFem == oActor)){
                                      "You set the controls to turn the Master from a zombie into a copy of your normal adult male self.
                                      You activate the machine and watch the little door close as the zombie within groans and hisses.
                                      The process takes only a few moments and the door opens up again and out steps a copy of your old male self. ";
                                      if(gameMain.is_a_little_girl == nil){
                                           "He quickly sizes up the situation and rushes over to you and begins to choke you. \"Fool! Imbicile! How dare yoU!\" he 
                                           shouts. \"How dare you come into my home and kill me then turn me into a zombie and use my head as a battering ram! 
                                           Now that I am no longer a zombie under your control I am free to carry out my plan and rule the world.
                                           Muwhahahahahahahaha!\"<.p>
                                           You break free of his choke hold and say,\"You are a horrible person and you\'ll never get away with it.\"<.p>
                                           \"Oh, won\'t I?\" he sneers stroking what would be a waxed moustache if he had one. \"I\'ve already assembled my zombie army and after I\'ve dealt with
                                           you I plan on taking over the world tonight at the stroke of midnight on Halloween. But first... Reginald, Igor, come quickly!
                                           There\'s an intruder in the house!\"<.p> ";
                                           inputManager.pauseForMore(true);// better than using just the morePrompt()
                                           "<HR ALIGN=CENTER NOSHADE><br>";    
                                           "Two goons arrive seemingly out of a secret panel in the wall and take hold of you by the arms.<.p>
                                           \"Have this intruder shrunk down to the size of a thimble at once and lock him up in the shoe box with the others,\" the Master
                                           says and glances down at his new body with distaste. \"And fetch me my form cube. This body is horribly unsuitable and it\'s
                                           making me ill. Then fetch me a cup of coffee, an aspirin and my newspaper. I\'ve a splitting headache and I wish to read the 
                                           funnies.\"<.p>
                                           \"Yes master,\" the goons say dragging you out of the room.<.p>
                                           You are taken to the backyard and shoved under the shrink ray. You glance up as the entire world around you grows bigger and
                                           bigger as you grow smaller and smaller until you\'re lost in a jungle of grass blades the size of tall buildings. The goons
                                           quickly pluck you up and carry you back in the house where you\'re placed in a shoe box with dozens of other shrunken people.
                                           \"The monster, he\'s back!\" a tiny woman cries retreating from the giant hand.<.p>\"Help us! Don\'t leave us here to die! Have
                                           mercy!\" a tiny man begs on hands and knees but his pleas are ignored as the box lid is closed. You look up at all the tiny air
                                           holes poked in the lid and you look around you at all the frightened people who share your same fate.<.p>\"What will become of
                                           us?\" you wonder aloud but nobody offers any idea or suggestion.<.p>
                                           You almost saved the world but something compelled you to change the Master into a copy of you and he didn\'t react well
                                           afterwards to everything you did. For you it looks like..................<b>The End</b><.p> ";
                                           finishGameMsg(ftFailure,[finishOptionUndo,finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart,finishOptionAmusing]); 
                                           exit;   
                                     }else{
                                           "He quickly sizes up the situation and spots you and laughs,\"Hahaha! How bright of you, little one, to seize the moment and
                                           restore me back again to normal human form.\" ";
                                           if((kimmy.location == gPlayerChar.location) && (kimmy.age == 6)){
                                                   "<.p>The Master spots Kimmy with the wand still in her hand and takes it away from her along with
                                                   the magic book. \"Children shouldn\'t be playing with things made for adults,\" he says placing the objects back
                                                   on the top shelf out of your reach once again. \"You\'re an adorable pair, the two of you, but where did <i>this</i>
                                                   one come from I wonder?\"<.p>
                                                   \"I turned him into a-\" Kimmy starts but you elbow her to be quiet.<.p>\"Shhhhh... quiet,\" you whisper. \"Do you
                                                   want to tell him <i>everything</i>?\"<.p>
                                                   He bends over with hands on his knees to stoop down a bit to your level and asks,\"What\'s your name, dear?\"<.p>
                                                   \"I\'m <<gameMain.femaleFirstName>>,\" you reply with eyes lowered.<.p>
                                                   He reaches out and grabs hold of the hem of your dress and feels the material for a moment, then says,\"I\'d recognize
                                                   this handiwork anywhere. This is the result of the frimp spell. Kimmy, have you been turning people into little girls
                                                   again? You know that\'s not a nice thing to do.\"<.p>";
                                                   inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                   "<HR ALIGN=CENTER NOSHADE><br>";    
                                                   "Kimmy nods and shrugs replying,\"Ah-huh, but only because she asked me to.\"<.p>        
                                                   The Master turns to you now and asks,\"Who were you before? Now don\'t lie to me now, <<gameMain.femaleFirstName>>. 
                                                   I have an easy way to find out and if I find out you\'re lying you\'re going to be in very big trouble. Now out with
                                                   it. Who were you originally?\"<.p>
                                                   \"I was a man,\" you admit blushingly. \"A man named <<gameMain.ProperName>>.\"<.p>
                                                   \"Oh-ho-ho-ho! I see. How very interesting indeed,\" the Master says. \"And what brings you to my island, <<gameMain.ProperName>>?\"<.p> ";
                                                   local iDone = 0; 
                                                   local s0 = '';
                                                   do{
                                                          "<br>1. Tell him you came here to find out if the rumors were true
                                                           <br>2. Tell him you wanted to get changed into a girl 
                                                           <br>3. Tell him you came here to stop his diabolical plans";
                                                          s0 = inputManager.getInputLine(nil, nil);
                                                          if((s0 == '1') || 
                                                             (s0 == '2') ||
                                                             (s0 == '3') 
                                                          ){ 
                                                             iDone++;
                                                          }
                                                  }while(iDone==0);
                                                  if(s0 == '1'){
                                                          "\"I wanted to find out if the rumors I heard were true about all the crazy inventions,\" you explain.
                                                           <.p>He nods thoughtfully and says,\"I certainly hope you\'ve found out what you wanted to know because
                                                           first thing in the morning I\'m dropping you off at the nearest orphanage. That\'s right, I\'m keeping
                                                           you stuck the way you are. Maybe it\'ll serve you a lesson not to intrude on other people\'s property.\"<.p>
                                                           With that he has his servants come and take you away. You\'re locked in a room until morning when bright
                                                           and early you are taken by boat to the shore of the lake and led to the local orphanage.<.p>For you it
                                                           certainly looks like.... <b>The End</b><.p> ";                                                           
                                                  }else if(s0 == '3'){
                                                           "\"I came here to stop you!\" you shout wagging your little fists up at him. 
                                                           <.p>He chuckles at that and says,\"Clever then, you\'re having turned yourself into a little girl and
                                                           then turning me back to a normal human again. I guess I have you at a little disadvantage, don\'t I?
                                                           I\'m much bigger and stronger than you now and there\'s nothing you can do anymore to stop me. So if
                                                           stopping my plans is what you had in mind I fear that you\'ve done a terrible job. A terrible job indeed.
                                                           And now, little one, I must be off to assemble my zombie army for at midnight tonight on Halloween I plan
                                                           on taking over the world. Muwhahahahahahahaha!\"<.p>
                                                           <b>The End</b><.p> ";
                                                  }else{
                                                           "\"I came here because I wanted to get changed into a girl,\" you admit.
                                                           <.p>\"I admire your honesty. I\'ve known men like you,\" he says leaning over and twirling a finger 
                                                           briefly in your blonde hair then flicking out again. He considers you in your pretty pink dress for
                                                           a moment and then dusts off imaginary dust square off your little shoulders and says,\"It\'s good that
                                                           you\'ve been frimped. It\'s one of my more pleasant line of spells in my collection. I\'m almost ashamed
                                                           I don\'t use it more often. It is a bringer spell, you see, and as such the spell caster must be a little
                                                           girl. Therefor I don\'t get much use out of it as I don\'t habitually go around wearing dresses or fancy
                                                           the idea of squatting to urinate or spending a second childhood as the opposite sex. But as I\'ve said, I\'ve
                                                           known men like you. Men who wanted to exchange their sex for that of a girl. I seldom reward them with their
                                                           requests because for the most part I\'d like to keep the women on my island completely apart from the men in
                                                           this regard. I don\'t fancy mixing them up, you see. I like to know who\'s who so I tend to keep the 
                                                           <i>unnaturals</i> apart. That\'s why I have a compound on the western portion of the jungle specifically
                                                           designed as a sort of holding pen for the few women on my island who used to be men. Now as for Kimmy here
                                                           and a few others - I don\'t mind keeping little girls around the house if they might be of some use to the
                                                           servants. You know, helping with the cooking and cleaning and such.\"<.p> ";
                                                           inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                           "<HR ALIGN=CENTER NOSHADE><br>";    
                                                           "He pauses to retrieve your form cube from the slot in the machine. He considers it carefully as he reads
                                                           it then places it in his shirt pocket. \"Now as for you, <<gameMain.ProperName>>, or should I call you <<gameMain.femaleFirstName>> now?
                                                           As for you, I simply have no more room for any more little girls in my household so first thing in the morning
                                                           I think I\'ll have you sent to an orphanage. But back to what I said before. I\'ve known men like you. 
                                                           It always fascinates me when I find one who genuinely wishes to remain permanently a member of the opposite
                                                           sex. But you haven\'t merely been turned into a woman for the purpose of having sex. You\'ve gone and had
                                                           yourself regressed to pre-sexual age so I can see your sincerity for wanting to be female goes far and beyond
                                                           the idea of doing so for the sake of pleasuring yourself. Or maybe I caught you at a bad time. Maybe you hadn\'t
                                                           planned on remaining a little girl at all. Maybe because Kimmy was around it seemed like the frimp spell was the
                                                           only viable option. Though she could have femified you and kept you at an adult age. I wonder if her decision was
                                                           spur of the moment or if she had planned this all along.\"<.p> ";
                                                           inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                           "<HR ALIGN=CENTER NOSHADE><br>";    
                                                           "\"But you don\'t have to keep me stuck this way,\" you tell him. \"I helped turn you back to human. I helped
                                                           you. Why can\'t you help me too?\"<.p>
                                                           \"And what you did was very nice but I question whether or not you were involved in other activities before,\" he
                                                           says. \"At any rate you\'ve been frimped and it\'s too good a spell to waste by turning you back to normal
                                                           again. It\'s a most interesting spell, you see, because it doesn\'t just produce superficial exterior bodily
                                                           changes, it goes beyond that and produces lovely little girls. It leaves your memories mostly untouched except
                                                           it undoes all your education down to grade school level and changes your nature. I bet you didn\'t know that,
                                                           did you <<gameMain.femaleFirstName>>? These things often are hard to detect first hand and easily go unnoticed
                                                           until someone with knowledge and authority over these matters points them out. The frimp spell molded you into
                                                           a good little girl at heart. Maybe that\'s partially to blame for your changing me back to human again. You see,
                                                           your very nature\'s been changed to that of a little girl and if you really think about it you even like boys now 
                                                           instead of girls no matter how your sexual orientation was before.\"<.p>
                                                           You search your thoughts and feelings, discovering with growing concern that everything he\'s said so far about you is
                                                           true. Your love of women has been completely erased, replaced with a kind of puppy love affection for boys. Your
                                                           memory of going to school is there but the knowledge of what you\'d learned is hauntingly absent. What\'s worse, 
                                                           even though this new body seems different, even <i>wrong</i> compared to before, at the same time there\'s a feeling
                                                           of rightness. You\'re not sure if it\'s because you\'ve come to like being this way all of your own free will or if
                                                           the magic spell has somehow tricked you into wanting this.<.p>";
                                                           inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                           "<HR ALIGN=CENTER NOSHADE><br>";    
                                                           "\"You\'re a very bad man,\" you say stomping a foot in protest.<.p>
                                                           The Master chuckles at you and says,\"And you are an obstinate little girl who doesn\'t yet know her place but we
                                                           will soon fix that.\"<.p>
                                                           Kimmy takes your hand and leads you hurriedly to the front door. \"Come on, <<gameMain.femaleFirstName>>. Let\'s run away
                                                           and hide before it\'s too late.\"<.p>
                                                           You both run outside but the Master\'s running after you. He shouts,\"Come back, you fools! Don\'t you know there\'s no
                                                           escaping this island?\"<.p>
                                                           The Master isn\'t quick enough for two sprightly little girls. The edge of the jungle comes rushing up 
                                                           fast as you both run as fast as your little legs can carry you. You hide in the jungle until morning when
                                                           the little boat arrives to pick you up again. The boat captain raises a brow at the two of you and 
                                                           asks,\"Just the two of you? Wasn\'t there a tall brown haired, blue eyed fellow around?\"<.p>
                                                           You both shake your head no.<.p>
                                                           \"Funny,\" the boat captain says. \"Could\'a sworn he said he\'d be back here by morning. I warned him about this
                                                           crazy place.... I warned him. Well, I\'d better get the two of you back to town. This island\'s no place for a 
                                                           couple\'a little girls.\"<.p> ";
                                                           inputManager.pauseForMore(true);// better than using just the morePrompt()
                                                           "<HR ALIGN=CENTER NOSHADE><br>";    
                                                           "You arrive back at civilization but with nowhere really to go.<.p>
                                                           \"Well... what do we do now?\" you ask Kimmy.<.p>
                                                           She shrugs and runs playfully down the sidewalk,\"Anything we 
                                                           want, <<gameMain.femaleFirstName>>. Anything we want!\"<.p>
                                                           <br><b>The End?</b> 
                                                           <.p>Well it seems you didn\'t actually save the whole world but you did slow down the Master\'s plans just enough
                                                           that he only decided to take over a few minor countries here and there. Hardly enough for anyone to take notice before
                                                           the locals overthrew the zombie army after only a few weeks in power. As for you and Kimmy, you go on to have adventures
                                                           of your own, making mischief and getting into trouble along the way and how do you ever explain to anyone what <i>really</i> happened, 
                                                           but that\'s another story. ";
                                                           littleGirlEndingAchievement.awardPointsOnce();
                                                           finishGameMsg(ftVictory,[finishOptionUndo,finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart,finishOptionAmusing]);  
                                                           exit;   
                                                   }
                                           finishGameMsg(ftFailure,[finishOptionScore,finishOptionFullScore,finishOptionRestore,finishOptionRestart]);    
                                           exit;
                                       }// end else
                                }
                                // end if(zombieMaster == oActor)                                                 
                             }else{
                                   gMessageParams(oActor);
                                   local s0 = 'You don\'t need to use the normalizer machine on \^{subj oActor}{the/he}. ';
                                   say(s0);
                                   exit;      
                               }// end if(...oActor checks)
                             }// end if(oActor != nil)
                             gMessageParams(obj);
                             local s1 = 'You can\'t use the machine on {subj obj}{the/he}. ';
                             say(s1); 
                             exit;
                         }// end if(obj != nil)
                    }// end if(normalizerBooth.contents != nil)
                    if(normalizerBooth.hasUsed == nil){
                          /* Let's do it! */
                          if(normalizerBooth.controlsSet != nil){
                               "You\'ve already set the controls. The automatic timer is ticking. Now you\'ve just got to enter the booth and wait
                               for this machine to do its thing. ";
                          }else{
                               "The controls on this machine are rather simple. You set them to normalize a standard human body. The timer\'s set. Now it\'s
                               time for you to enter the booth and restore yourself back to normal. ";
                               normalizerBooth.controlsSet =  true;
                          }
               }else{
                           "You\'ve already turned used the normalizer machine. You don\'t need to use it again. ";
                           exit;
               }

                 }// end action()
         }// end dobjFor(Use)
  
;

/*
+ littleLibDoor : LockableWithKey, Door '(green) (painted) (little) (tiny) (small) (short) (girl\'s) (bedroom) (room) (wood) (wooden) (mansion) door' 'door'
  "A green painted wooden door. "
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  dobjFor(Enter){
        verify(){ logicalRank(120,'likely'); 
                  inherited;
        }
        check(){ inherited; }
        action(){ inherited; }
  }
  dobjFor(TravelVia){
      verify(){ logicalRank(130,'very likely'); 
                // inherited;
      }
      check(){ inherited; }
      action(){ inherited; }
  }
  travelBarrier = [noDoorIfBig]
; 

*/


/*
girlsRoom: Room 'girl\'s bedroom'
  "This is a bedroom for a little girl. Everything\'s little girl sized, even the door. "
;
+ littleLibDoorInner : LockableWithKey, Door -> littleLibDoor
  vocabWords = '(green) (painted) (girl\'s) (little) (tiny) (small) (short) (bedroom) (room) (wood) (wooden) (mansion) door'
  name = 'door'
  desc = "A green painted wooden door. "
  keyList = [gmDmSkeletonKey,maidsRoomKey]
  initiallyLocked = nil
  travelBarrier = [noDoorIfBig]
;
+ Heavy, Bed '(little) (girl\'s) (girl) (sized) bed' 'bed'
  "A little girl\'s bed with pink sheets, blankets and a pillow. "
;
+ Decoration '(pink) sheets sheet blanket blankets covers' 'bed covers'
  "There are some pink sheets and blankets on the bed. "
;
+ Decoration '(pink) pillow case' 'pillow'
  "There is a pink pillow on the bed. "
;
*/


testNPC: Female, CromexxHuman
  name = 'wizard'
  vocabWords = 'wizard'
  desc = "A wizard. "
  location = pixyland // mansionLibrary // change to player location for testing purposes
;
+ wizardWaiting: HermitActorState 
  specialDesc = "A wizard is here. "
  noResponse = 'She seems to be busy spell casting. '
  isInitState = true 
; 
+ changePlayerFem: AgendaItem
  initiallyActive = true
  isReady = (
             (gPlayerChar.canSee(testNPC))
            ) 
  invokeItem {
           
                 "I will feminize you! Hahahaha!";
                 wizardWand.moveInto(testNPC);
                 local tokList = Tokenizer.tokenize('femify <<gameMain.ProperName>> with magic wand');
                 executeCommand(testNPC, testNPC, tokList,nil);// nil = start of sentence (true/nil)   
                 isDone = true;   
                 exit;
  }  
;

magicBook: Consultable, Readable, Thing
 location = libraryTopShelf
 name = 'transformation spell book'  
 disambigName = 'bzenteronian transformation spell book'
 vocabWords = '(bzenteron) (bzenterite) (bzenteronian) (wizard) (wizard\'s) (sorcerer\'s) (sorcerrer\'s) (ancient) (old) (black) (leather) (bound) (magic) (of) transformation transformations transmutations transmutation spells spell book'
 desc { "A black leather bound book of transformation spells. 
        It seems rather old. The pages are yellowed and crumbly along the edges. ";
        if(magicBook.isHeldBy(gPlayerChar)){
             "Someone has partially translated the ancient cryptic writings into English by writing in the
              margins wherever possible. You may <a href=\"read transformation spell book\">read</a> it if you\'d like or
              you may <a href=\"consult transformation spell book about topics\">consult</a> it about something more specific. ";
        }
 }
 readDesc {
        "<i>Such an incredible find. I located the book in the wizard\'s tomb buried deep beneath the catacombs of an 
        underground civilization lost for centuries far below the twisted vines and gnarled old trees of an ancient jungle. The 
        authenticity is questionable due to the fact that
        there is no way this ancient civilization could have bound their books in such a manner. They lacked even the rudimentary
        skills to produce papyrus scrolls and were therefor confined to chisel and stone. Therefor if this is authentic it must have
        originated from an outside civilization at a much later time period and was somehow brought here and laid to rest beside the
        bones of the wizard.<.p>One thing I must do is find the magic wand referred to in the book or there is no way I can verify if
        any of these spells will actually work. I theorize that magic is actually a tapping into an alternate dimemension and that therefor
        there must be a way to scientifically reproduce these spell like effects through the use of instruments other than a magic wand. 
        My goal is to build a series of machines to recreate each transformation and if I can master the zombie spell I will then build an
        army of zombies to take over the world. I will build a fantastic necropolis which will be the seat of power for my throne where I will
        have unlimited resources to expand my research into realms unknown.<.p>I have translated but a handful of spells of various 
        <a href=\"consult book about topics\">topics</a>.</i><.p> ";
 }
 dobjFor(Read){ 
   preCond = inherited + touchObj + objHeld; 
 }   
 dobjFor(Consult){ 
   preCond = inherited + touchObj + objHeld; 
 } 
;
+ ConsultTopic [genericTopicTopic] 
  "Topics you may consult are: <a href=\"consult magic book about normalization\">normalization</a><br>
  <a href=\"consult magic book about turning into a girl\">changing a man into a woman</a><br>
  <a href=\"consult magic book about turning into a boy\">changing a woman into a man</a><br>
  <a href=\"consult magic book about becomming a little girl\">becomming a little girl</a><.p>"
; 
+ ConsultTopic [genericNormalizationTopic]
  "A general normalization spell which only seems to work to undo certain transformations. Specifically
  zombiefication can be reversed quite well with this. To change back to normal, point the magic wand at
  the target and say the magic words \"<a href=\"frazoltto malitti zafry timtow me with wand\">frazoltto malitti zafry timtow</a>.\" "
;
// turning into a girl
+ ConsultTopic [sexchangeTopic2]
  "This spell will turn any man into a beautiful young woman. She will be fertile and be able to bear children.
  This is a <a href=\"consult magic book about bringer class spells\">bringer class spell</a> and as such the
  spell caster must be female. To change a man into a woman, point the magic wand at the target and say the magic
  word \"<a href=\"femify me with wand\">femify</a>.\" "
;
// turning into a boy
+ ConsultTopic [sexchangeTopic3]
  "This spell will turn any woman into a man but will not affect a woman if she is pregnant. 
  This is a <a href=\"consult magic book about bringer class spells\">bringer class spell</a> and as such the
  spell caster must be male. To change a woman into a man, point the magic wand at the target and say the magic
  word \"<a href=\"boyify me with wand\">boyify</a>.\" "
;
// turning into a little girl
+ ConsultTopic [littleGirlChangeTopic]
  "This spell will turn a man or woman into a little girl. It does not affect a woman if she is pregnant. 
  This is a <a href=\"consult magic book about bringer class spells\">bringer class spell</a> and as such the
  spell caster must be a little girl. To change a man or woman into a little girl, point the magic wand at the target
  and say the magic word \"<a href=\"frimp\">frimp</a>.\" ";
;
+ ConsultTopic [bringerClassSpellTopic]
  "Spells of the \"bringer class\" are spells with which the spell caster must be of the same sex, age, species and so forth
  as the desired transformation of any given target. Good examples are sex change spells where only a woman can <i>bring</i>
  a man over to her sex and vice versa. These are also known as <i>complimentary spells</i> where the target is changed into the likeness
  of the caster in some way. The reason for the limitation is partially so the caster does not accidentally transform him or herself with
  the spell but also so it places a restriction upon the transformed subject so that he or she can not simply cast an opposite spell to
  effectively change back to normal.<.p>The sex change line of spells are notorious for this and were designed so that any male who wished
  to become female had to first consult with a high priestess to first obtain permission to join her sex. If no good reason was presented for
  the requested transformation, often accompanied by money or an expensive gift, the priestess often rejected the request. If the request was
  granted, the priestess used the bringer class spell to bring the male over to the female sex, upon which the new woman was kept at the 
  temple for training and also to ensure proper respect of the female sex. Masturbation and sexual intercourse were prohibited for a certain
  time period to ensure proper respect of the body and new sex and also served as self sacrafice to honor the priestess.<.p>Female to male
  transformation was a rarity in <a href=\"consult spell book about bzenteron\">Bzenteron</a> and there were seldom any high priests who 
  were willing to perform the spell even to change a woman back into a man if her original sex was male. Women were considered <a href=\"consult spell book about women as inferiors\">inferior</a> to men and any
  man who had somehow managed to get himself changed into one was no exception.<.p>Bringer class spells pose restrictions upon the caster and were
  commonly used by high priests and priestesses of Bzenteronian society. "
;
+ ConsultTopic [bzenteronTopic]
  "Bzenteron was the name of an alleged lost continent, much like Atlantis. Their civilization is said to have flourished for thousands of years but vanished almost completely
  near the time of the Aztecs. After the collapse of their civilization the remaining few survivors were said to have retreated underground where they
  occupied previously built underground cities once occupied by another ancient civilization. The Bzenteronians had High Priests and High Priestesses who
  were practicers of black magic which they used to perform transformations upon slaves who were often sometime afterwards sacraficed to their gods.<.p>
  For a price a man could visit the High Priestess and request to become a woman to serve in the temple. This was considered by some a great honor but
  by and large the Bzenteronians shunned the practice. "
;
+ ConsultTopic [womenAsInferiorsTopic]
  "In <a href=\"consult spell book about bzenteron\">Bzenteronian</a> culture women were considered inferior to men. However entire temples were
  constructed where only women were permitted inside and the priestesses within were of an elevated role in society though still considered inferior to their
  male counterparts. Sometimes a man who was rejected for service in the male temple went to a High Priestess and asked for a sex change for the purpose of
  serving in her temple instead. "
;


wizardWand: MagicWand
  name = 'magic wand'
  vocabWords = '(magic) (wizard) (wizard\'s) (witch) (witch\'s) wand'
  desc = "A magic wand. "
  location = libraryTopShelf
  weight = 0
  bulk = 0
;

libraryTopShelf: OutOfReach, Fixture, Surface
  name = 'top shelf'
  vocabWords = '(top) (bookcase) (book) (case) bookshelf/shelf'
  desc = "The top shelf of the bookcase. "
  location = libraryBookCase
   /* Here we override the "cannotPutInMsg" function 
    * to say something than the default "&cannotPutInRestrictedMsg" library message.
    */
   cannotPutInMsg(obj) { return 'You shouldn\'t go putting things on the shelf that don\'t belong. '; }
    /*
     *  DUH!  This is ALL we have to DO to handle CONDITIONAL out of reach objects!
     *  Tads queries this method so you can return true to make *some* objects (i.e.
     *  characters) be able to reach and return nil for everything you DON'T want to
     *  be able to reach! 
     * 
     */
    canObjReachContents(obj) { 
        if((obj == gPlayerChar) && (gPlayerChar.pcHeight == '2\' 8\"')) return nil;
        if((obj == gPlayerChar) && (gameMain.is_a_little_girl == true)) return nil;
        if((obj.ofKind(LittleGirl))) return nil;
        return true;
    }
    tooDistantMsg = 'You\'re too short to reach the top shelf. '
    cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
    cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }   
;





// ------------------------ Non-TG Route --------------------------------------
  
  /*   For the non-tg route, pull the plug (literally and symbolically)
   *
   */

class Weapon: Thing
  getDamage(){
     return 0; // objects and classes must override
  }
  getCritical(){
     return 0; // objects and classes must override
  }
  iobjFor(AttackWith){
    preCond=[objHeld]
    verify(){ logicalRank(100,'likely'); }
    check(){ }
    action(){ 
           // "iobj AttackWith script - action() ... where gDobj == <<gDobj.name>><.p>";
    }
  }
;

class Monster: Person
  dobjFor(Attack){
    verify(){ logicalRank(110,'likely'); }
    check(){ }
    action() { 
          // battleHandler.attack(gActor,self);
          askForIobj(AttackWith); 
    }
  }
  dobjFor(AttackWith){
    verify(){ logicalRank(110,'likely'); }
    check(){ 
          if(!gIobj.ofKind(Weapon)){
                reportFailure('You can\'t attack anything with that. ');
                exit;
          }
    }
    action(){
            battleHandler.attackWith(gActor,self,gIobj); 
            // "gDobj AttackWith script - action()<.p>";
    }    
  }
;

class Fleeable: Room
  fleeLocation = nil // if not nil then this is the room we can flee to
;

battleHandler: object
  contents = [] // fighters = []
  turn = 0
  // using preferred weapon
  attackWith(attacker,defender,weapon){
        // "attacker: <<attacker.name>><br>defender: <<defender.name>><br>weapon: <<weapon.name>><.p> ";
        // each will get a turn
        if(sleepingDragon == defender){
            if(weapon == scythe){
                 battleHandler.dragonBattle.doScript();
            }else{
                 "You\'d rather not wake the dragon like that. It could make him very angry. ";
            }
        }        
  }
  dragonBattle: StopEventList {
        eventList = [
            new function(){
                 "You swing your scythe at the sleeping dragon...<.p>
                 A dark mass of energy cascades outward from your weapon, surrounding the dragon and drawing out
                 tiny wisps of white smoke from within. You hear an evil voice boom out in your head,\"A sumptous treat! A fine and 
                 tasty soul for the taking!\"<.p>The dragon awakes, opening one eye frowning then staring this way
                 and that, unaware immediately of what\'s going on, finally it raises its head and looks right down
                 at you, spotting the scythe in your hands and says,\"Foolish mortal. Do you think you can lifetap
                 a dragon to death with that puny little stick? I\'ve eaten necromancers twice your size for breakfast.\"<.p>
                 Before you can answer the voice that was in your head a moment ago booms out in reply,\"Dragon, hear me and
                 stay your anger. I am no mere necromancer\'s weapon. I am the Pumpkin Eater. A weapon of reconing.\"<.p>
                 The dragon stands tall and stretches its mighty wings out wide and raises its claws at you, roaring and says,\"Fool! I am
                 no pumpkin!\"<.p>Dead silence for a moment, and then the scythe turns to you and says,\"I really think you ought
                 to apologize to him. You see, I only do pumpkins.\"<.p> ";
                 sleepingDragon.setCurState(dragonAwaitingApology);
                 sleepingDragon.woken = true;
                 sleepingDragon.setConvNode('waiting-apology');
                 
            },
            'Now\'s not the time to go making him any angrier with you. You obviously were misinformed about the scythe and had no
             idea it was just a vegetable chopper. That\'s what you get, I guess, for attacking sleeping dragons with strange weapons. '
        ]
  }
  // using no weapon (melee h-2-h or caster) - must prompt
  attack(attacker,defender){
        "attacker: <<attacker.name>><br>defender: <<defender.name>><.p> ";
        // add attacker and defender to our contents list to track fight order and who is fighting
        if(self.contents == nil){
               self.contents += attacker;
               self.contents += defender;
        }else{
               local iDef = nil;
               local iAtt = nil;
               foreach(local obj in self.contents){
                      if(obj == attacker) iAtt = true;
                      if(obj == defender) iDef = true;
               }
               if(iAtt == nil) self.contents += attacker;
               if(iDef == nil) self.contents += defender;
        }
        // add any other monsters in the battle that happen to be in this room as well (if not already)
        foreach(local obj in attacker.location.contents){
               if(obj.ofKind(Monster)){
                      local oMon = nil;
                      foreach(local z in self.contents){
                            if(z == obj) oMon = true;
                      }
                      if(oMon == nil) self.contents += obj;
               }
        }
        // to do: add henchmen into battle (to help player)
        
        // local variables
        local oBatterUp = nil;

        // ** possibly start a do-loop here

        // increment turn counter
        self.turn++;
        if(self.turn > self.contents.length) self.turn = 1;
        oBatterUp = self.contents[self.turn];
        // 
        // "Turn # <<self.turn>> - Attacker this round: <<oBatterUp.name>> <.p>";
        if(oBatterUp.ofKind(Monster)){
               // monsters don't flee by default
        }else if(oBatterUp == gPlayerChar){
               // 1. Flee battle on foot (Y/N) ? NOTE: casters can optionally gate in step 4
               // 2. Use health/mana potion or item
               // 3. Attack with (weapon of choice)
               // 4. Spell: nuke/dot/heal/summon/evac/gate
        }    
        
  }    
;


/*
 *   This begins the non-TG route (but you can girlify yourself and then go through here anyhow)
 *   **** bookmark ****
 */

greenCave: Room 'junk heap'
    desc {
        "This is a large green cave located somewhere beneath the mansion. The walls, floor and ceiling are made of
        a soft spongey material that emits a faint green glow. You are <<gPlayerChar.posture.participle>> on a junk heap
        in the center of the cavern. There is a way to the ";
        if(gameMain.allowHtmlLinks){
                "<a href=\"east\">east</a>";
        }else{
                "east"; 
        }
        " from here. ";
    }
    east = greenCaveEast
;
+ Decoration '(spongey) (spongy) (faint) (green) (glowing) (rubbery) (spongelike) (rubberlike) sponge material' 'spongey material'
  "It\'s got a faint green glow to it and it\'s a bit rubbery. "
;
+ Decoration '(of) pile trash junk heap' 'junk heap'
  "Just a big pile of junk. You can\'t even tell what most of this stuff is anymore. It\'s all smashed, battered, torn apart
   and disfigured as though <i>monsters</i> had gotten to it. "
;

scythe: Weapon, CromexxHuman
  name = 'forlorn scythe'
  properName = 'the pumpkin eater'
  isProperName = nil
  vocabWords = '(the) (vegetable) (chopping) (necromancer\'s) (necromancer) (Draxxar) (Draxxar\'s) (necromatic) (very) (powerful) (forlorn) (abandoned) (grim) (reaper\'s) (reaper) (reaping) (wood) (wooden) (handled) (sharp) (pointy) (pointed) (terrible) (terrable) (Peter) (Peter\'s) (pumpkin) (epic) (not) (what) (I) (seem) (really) (real) (cursed) weapon chopper eater stick scythe'
  desc = "A terrible scythe. "
  location = greenCave
  playerToldAboutTF = nil
  annoyedCounter = 0
  initializeActor(){
       /* We do not want to forget to include
        * the inherited code in this routine.
        */
       inherited; // see class Actor in file: actor.t
       /* Important: We MUST make sure the NPC
        * knows about these other NPC's and objects otherwise
        * even if we refer to them in an AskTopic
        * this NPC will not respond to the question.
        */
       local myList = new List();
       myList = [me,brassLantern,shovel,sexchangeTopic,genericTopicTopic];
       foreach(local obj in myList){
             if(obj !=nil)
                self.setKnowsAbout(obj);
       }       
  }// ...end initializeActor()
  dobjFor(Take){
        preCond = [touchObj, objNotWorn, roomToHoldObj]
        verify(){ logicalRank(110,'likely'); }
        check(){ 
            if(scythe.isHeldBy(gActor)){
                failCheck('You already have the scythe. ');
            }
        }
        action(){
            moveInto(gActor);
            /* issue our default acknowledgment of the command */
            self.okayTakeMsg.doScript();   // defaultReport(&okayTakeMsg);
        }
  }
  // Semi-colon... character 59 is ascii # for semicolon ; ...or 0x3B. or: \u003B
  okayTakeMsg : StopEventList{
           eventList = [
               new function(){
                "As you take the scythe you feel a strange, terrible power surge through the handle into your hands
                and a deep and evil booming voice in your head bellows out,\"<i>Peter, Peter pumpkin eater,
                Had a wife but couldn\'t keep her\u003B He put her in a pumpkin shell And there he kept her very well.</i>\"
                <.p>You begin to think that maybe taking this scythe was a very bad idea. ";
               if(scythe.curState != scytheAware){
                    scythe.setCurState(scytheAware);
               }
                scythe.previousState = scytheSearching;
            // scythe.setConvNode('waiting-for-dungeon-exit');// when talking to an NPC you can go to different nodes and handle topics there instead of defaults
            },
               new function(){
                "You take the scythe. ";
                if(scythe.curState != scytheAware){
                    scythe.setCurState(scytheAware);
                    scythe.previousState = scytheSearching;
               }
            }
           ]
  }
 
    // Actor class acts funny with this so we just copied back Thing class handling and modified a little
    dobjFor(Drop) {
        preCond = [objHeld]
        verify(){
            /* the object must be held by the actor, at least indirectly */
            if (isIn(gActor)){
                /* 
                 *   it's being held, so dropping it makes sense; verify
                 *   transfer from the current container hierarchy to the
                 *   new one 
                 */
                verifyMoveTo(gActor.getDropDestination(self, nil));
            }else{
                /* it's not being held, so this is simply not logical */
                illogicalAlready(&notCarryingMsg);
            }
        }

        action(){
            "You hear the scythe say in your mind: <i>\"I control you... I control you... I control- darn it! It\'s not working!\"</i><.p>
            You drop the forlorn scythe. ";
            /* send the object to the actor's drop destination */
            gActor.getDropDestination(self, nil)
                .receiveDrop(self, dropTypeDrop);
        }
    }

;
+ scytheAware:InConversationState
    specialDesc {
        local s0 = 'A forlorn scythe is lying on the floor. ';
        if(!scythe.isHeldBy(gPlayerChar)){
            local loc = scythe.location.getOutermostRoom();
            // local oWho = scythe;
            // gMessageParams(scythe,loc);
            //"\^\<<oWho>> {subj scythe) is <<scythe.location.inOnThe>> {the loc/him}. ";
            if(loc.name == 'junk heap'){
                "A forlorn scythe is on the junk heap. ";       
            }else{
                "asfsadfa test..asdfadsfd test... ";
                "A forlorn scythe is {in loc}. ";// the room name is 'junk heap' so it'll say: 'A forlorn scythe is in the junk heap.'
             }
        }else{
            say(s0);
        }
    }
  noResponse = 'It\'s probably not wise to go around waking dragons. This one looks pretty tough. You probably wouldn\'t last a minute. '
  isInitState = true 
  nextState = scytheLooking
;
++ scytheLooking: ConversationReadyState
  specialDesc {inherited; stateDesc; } 
  stateDesc = "The scythe pulses with magic. "
;
+++ HelloTopic, StopEventList
  [
      new function(){
         "\"Hi there,\" you say to the scythe.<.p>
         \"I never left,\" the scythe says in your head. ";
      }
  ]
;
+++ ByeTopic, StopEventList 
  [ 
      new function(){
       "\"Bye,\" you say to the scythe.<.p>
       \"For now...,\" the scythe says in your head. ";
      }
  ]  
; 
+++ ImpByeTopic
    topicResponse { " ";
           // "\"Wait!\" the scythe calls out. \"I\'m coming with you!\" ";
   }
;
++ DefaultAskTellTopic
   topicResponse {
     "\"What do you think about <<gTopic.getTopicText>>?\" you ask.<.p>
      \"Sorry. I don\'t know right now,\" the scythe replies in your head.<.p> ";
   }
;
++ AskTellTopic @genericTopicTopic 
   topicResponse {
       "Some things you may talk to the scythe about are:
       <br><a href=\"ask for help\">help</a> ";
   }
;
++ AskTopic, SuggestedAskTopic @scythe
    name = 'itself' // scythe - we use 'itself' here so the suggestion can be: "You could ask it about itself, ...etc." - Cleo Kraft 6/9/2019
    topicResponse {
           if(gPlayerChar.girlType == 'abysmal'){
            switch(scythe.annoyedCounter){
                case 0:
                "You feel a blonde moment overcome you.<.p>
                \"So scythy old pal,\" you say. \"I was wondering about you. So... tell me about yourself... Uh, no, wait. 
                Did you know they put a man on the moon?\"<.p>
                The scythe is oddly quiet for a few moments then says,\"Yeah. What\'s that got to do with anything?\"<.p>
                \"Well I was wondering... how do they deliver the mail to him?\"<.p>
                After a concerned pause the scythe replies,\"I think you\'d best let me do the talking from now on.\" ";
                scythe.annoyedCounter++;
                break;
                default:
                "You ask the scythe,\"So... what\'s your story then, scythee?\"<.p>
                You sense deep annoyance and then the scythe says in your head,\"I am a necromancer\'s weapon (as if you
                couldn\'t guess by my looks). I come from ancient times and... well, as far as you\'re concerned much of
                this is probably going to be above your head so let\'s skip it.\" ";
           }// end switch
          }else if(gPlayerChar.is_A_Girl){
            "You ask the scythe,\"What can you tell me about yourself?\"<.p>
            The scythe replies,\"I am a necromancer\'s epic weapon, very powerful. I once belonged to Draxxar Mictlanticuhtli
            but was stolen by a wizard who turned my powers from pure evil to more simplistic tasks. <i>I am not what I seem.
            I am not what you feel. The fact of the matter is... I\'m not really real.</i> This was the curse put upon me and
            if it can be broken you will have in your hands one of the most powerful weapons in the world at your service.\" ";
          }else{
            // the scythe doesn't trust men so he will not reveal his background in full
            "You ask the scythe,\"What can you tell me about yourself?\"<.p>
            The scythe replies,\"I am an ancient weapon of great power. I do not fully trust you to say any further. Despite
                whatever weaknesses you may see in me I am more powerful than you can imagine... or once was anyway.\" ";
          }           
    }
;
++ TellTopic, SuggestedTellTopic @genericMeTopic
  topicResponse {
     if(gPlayerChar.girlType == 'abysmal'){
            switch(scythe.annoyedCounter){
                case 0:
                "You feel a blonde moment overcome you.<.p>
           \"So scythy old pal,\" you say. \"Let me tell you something about myself.... Uh, no, wait. 
           I could sure go for some seafood right now. I always wanted to try exotic foods. You know, 
           like squid an\' stuff, ya know? Always wondered what those little squiggly things tasted 
           like,\" you say to the scythe.<.p>
           \"I\'ve no idea what you\'re talking about,\" the scythe says in your head.<.p>
           \"You KNOW...,\" you say pondering a word that slips your mind right now but then you think
           you remembered it. \"You know, like their testicals.\"<.p>
           The scythe is oddly silent for a few awkward moments, then says,\"I think you mean tentacles.
           Perhaps it\'s best you let me do most of the talking when we encounter others.\" ";
                scythe.annoyedCounter++;
                break;
                default:
                "\"Scythe, lemme tell you about myself,\" you say to the scythe.<.p>
                \"No, please dear lord, not that!\" the scythe pleads with you. \"I can pretty much guess
                what you\'re going to say next and then something\'s going to distract you and next thing
                you know you\'re telling me about the pretty flowers. ";
                scythe.annoyedCounter++;
            }
     }else if(gPlayerChar.is_A_Girl){
           "You tell the scythe about yourself and how you turned yourself into a girl.<.p>
           The scythe ponders it for a moment and says,\"I sensed there was something different about you.\" ";
           scythe.playerToldAboutTF = true;
     }else{
           "You tell the scythe about your decision to visit this island for adventure. You also tell
           the scythe about your girlfriend troubles back home.<.p>
           \"Well, I\'m just glad you came along to take me away from here. You\'ve no idea how long it\'s 
           been since I had a decent wielder,\" the scythe says in your head. ";
           scythe.playerToldAboutTF = true;
     }
  } 
  timesToSuggest = 1 
  name = 'yourself'
  isActive = (scythe.playerToldABoutTF == nil)
;
++ AskForTopic, SuggestedAskForTopic @genericAskForHelpTopic
    name = 'help'
    goodIdea = nil
    topicResponse {
        "You ask the scythe for help.<.p>";
        if(shovel.isHeldBy(gPlayerChar)){
            if(!self.goodIdea){
                "\"Good idea! You must ALWAYS remember to ask me for help and I\'ll always see what I can do to help you. First of all we must get
                out of here. Whatever you do do NOT talk to the dragon!";
            }else{
                "\"We have got to get out of here.";
            }
            if(!sleepingDragon.woken){
                if(gPlayerChar.canSee(sleepingDragon)){
                    " I suggest we attack the dragon to get through to the north";
                }else{
                    " There\'s a dragon in the next room. I suggest you attack him with me";
                }
                ",\" the scythe says in your head. ";
            }else{
                if(gPlayerChar.canSee(sleepingDragon)){
                    " Be careful... that dragon is awful upset right now";
                    if(!sleepingDragon.pityTheFool){
                        ". I\'ve an idea. Try and do something exceptionally stupid in front of
                        the dragon... like try and eat your shovel. Maybe it\'ll throw him off and
                        he\'ll feel sorry for you";
                    }
                }else if(sleepingDragon.pityTheFool){
                    " Just keep moving. We need to get out of here";
                }else{
                    " Waiting here is no good. We\'ve got to go back and deal with the dragon";
                }
                ",\" the scythe says in your mind. ";
            }
        }else{
            "\"I don\'t have any ideas. We\'d best be careful about the dragon though,\" you hear the scythe say in your head. ";
        }
    }
;
++ AskTopic @genericDraxxarTopic
    topicResponse {
         " <table bgcolor=black>
            <tr><td bgcolor=black><font color=#ffff00>Programmer\'s Note:</font> <font color=#00ff00>You have located
                 a KEY AskTopic for this current plot progression. Unfortunately I haven\'t finished writing
                 it yet but it is a GOOD thing you knew to ask. - Cleo Kraft</font>
            </td></tr>
          </table> ";
    }
;
++ AskTopic @genericCursedScytheTopic
    topicResponse {
         " <table bgcolor=black>
            <tr><td bgcolor=black><font color=#ffff00>Programmer\'s Note:</font> <font color=#00ff00>You have located
                 a KEY AskTopic for this current plot progression. Unfortunately I haven\'t finished writing
                 it yet but it is a GOOD thing you knew to ask. - Cleo Kraft</font>
            </td></tr>
          </table> ";
    }
;
++ AskTopic @genericDancingTopic
   topicResponse {
       "\"Do you like dancing?\" you ask the scythe.<.p>
       \"I\'m a scythe, not a dance instructor,\" the scythe replies in your head. ";
   }
;
++ scytheDAT: DefaultAskTellTopic, ShuffledEventList
  [
     '\"What do you think about ' + gTopic.getTopicText + '?\" you ask the scythe.<.p>
     \"Your guess is as good as mine,\" it replies. ',
     '\"I\'d like to know about ' + gTopic.getTopicText + ',\" you say to the scythe.<.p>
     \"I really don\'t know,\" it replies. '
  ]
;

noPityTheFoolYet: TravelBarrier
   canTravelerPass(traveler) { 
       return (sleepingDragon.pityTheFool == true);
   }
   explainTravelBarrier(traveler) { "The dragon blocks the way. "; 
   }
;

greenCaveEast: Room 'grumpy canyon'
  desc {
    "This is the eastern edge of the green walled cave. It overlooks a vast canyon. Words have been carved into 
    a large boulder here. They read: grumpy canyon. ";
    "The exits are ";
    if(gameMain.allowHtmlLinks){
        "<a href=\"west\">west</a>";
    }else{
        "west"; 
    }
    " and ";
    if(gameMain.allowHtmlLinks){
        "<a href=\"north\">north</a>";
    }else{
        "north"; 
    }
    ". ";
  }
  west = greenCave
  north: TravelWithMessage,OneWayRoomConnector {
        ->canyonNorth
        travelBarrier = noPityTheFoolYet
        travelDesc {
            "You travel through the mirror and emerge in another location. ";
        }
        isConnectorApparent(origin, actor) { return nil; }
   }
;

sleepingDragon: Monster
  name = 'dragon'
  vocabWords = '(large) (sleeping) (red) (scaled) dragon/beast'
  desc = "A large dragon with red scales. "
  location = greenCaveEast  
  woken = nil
  pityTheFool = nil 
;
+ dragonSleeping: HermitActorState 
  specialDesc = "A large red scaled dragon sleeps beside the mouth of the canyon. "
  noResponse = 'It\'s probably not wise to go around waking dragons. This one looks pretty tough. You probably wouldn\'t last a minute. '
  isInitState = true 
; 
+ dragonAwaitingApology: InConversationState 
  specialDesc = "A large red scaled dragon stands towering before you with claws raised, ready to attack. "
  attentionSpan = 999
  nextState = dragonAwaitingApology    
; 
+ ConvNode 'waiting-apology'
  npcContinueMsg = "\"Don\'t leave yet, mortal. I\'m not through with you,\" the dragon says. "
  canEndConversation(actor, reason) { 
    if(reason==endConvTravel) { 
      "If you even flinch wrong that angry dragon\'s going to squash you like a bug and you know it. Better try to reason with him
      if you still can. ";
      return nil; 
    } 
    if(reason== endConvBye){
      "\"Well then, goodbye and sorry about everything,\" you say waving to the dragon.<.p>
      He swoops a claw down blocking your path and says,\"You\'re not going anywhere, mortal. I\'m
      not finished playing with you.\" ";
      return nil;
    }
    return true; 
  }  
  endConversation(actor, reason) { 
    "\"Goodbye and sorry about everything,\" you say waving to the dragon.
    <.p>\"Don\'t push your luck, mortal,\" he snarls back. ";
  } 
; 
++ SpecialTopic 'apologize'  ['apologize', 'to', 'the', 'dragon'] 
  topicResponse { "You gulp and look up at the dragon and say,\"Sorry... I uh... I didn\'t know. This is my first dragon slaying and I had no idea
    what the procdures even were and how was I to know this scythe is useless against dragons? Pretty funny, huh? Jokes on me, right?
    Boy, I bet you\'ll be laughing about this one with all your dragon friends for years and years after you let me go.\"<.p>The dragon
    frowns at you. He doesn\'t look impressed by your speech. He glances down at his right shoulder, there\'s a stream of wispy white
    smoke still streaming out from it. He grimmices and says,\"You\'re still life tapping, you know.\"<.p>";
    if(scythe.isHeldBy(gPlayerChar)){
       "You glance down at your scythe and back up at the dragon and hold out the weapon to him in offer and say,\"Sorry but I don\'t 
       know the commands or how to stop it. Here, you try.\"<.p>The dragon\'s claw comes swooping down, knocking the scythe to the ground 
       and smashing it up into a million pieces. Afterwards he brushes the remains aside and they go tumbling down into the canyon. ";
    }else if(scythe.location == greenCaveEast){
       "The scythe on the ground says,\"Oops. My bad. Sorry.\" and the necromatic energy drain ceases attacking the dragon.<.p>The dragon swoops
       its claw down, smashing the weapon to dust and swipes it aside into the canyon. ";
    }
    scythe.isListed = nil; 
    scythe.moveIntoForTravel(pixyland);
    "The dragon roars, casting an enormous fireball at you. Unfortunately you are a mere level one and that\'s a level eighty fireball and just the
    vapors surrounding it are enough to kill you instantly. You have no time to even feel the pain of death. All you see is the red glare of fire
    and then you are engulfed in darkness. ";
    sleepingDragon.setCurState(dragonSleeping);
    gPlayerChar.moveIntoForTravel(ghostersGrave);
    gPlayerChar.lookAround(true);
  }
; 
/*
 *  This gets set if the player tries to eat the rusty shovel in the presence of the dragon
 */
+ ConvNode 'i-pity-the-fool'
  npcContinueMsg = "\"Mortal, do not test me. I said leave through the north passage and never return,\" the dragon says. "
  canEndConversation(actor, reason) { 
    if(reason==endConvTravel) { 
      return true; 
    } 
    if(reason== endConvBye){
      "\"Well then, goodbye and sorry about everything,\" you say waving to the dragon.<.p>
      The dragon merely nods and points north. ";
      return true;
    }
    return true; 
  }  
  endConversation(actor, reason) { 
    "\"Goodbye,\" you say waving to the dragon.
    <.p>\"The dragon merely points north. ";
  } 
; 
                 
/*
 *   **** bookmark ****
 */
ghostersGrave: Room 'ghoster\'s grave'
  "This is a graveyard in a misty cavern. <br>
  <table bgcolor=black><tr><td bgcolor=black><font color=red>Programmer\'s Note: This is
                 a dead-end room. Exits from here have not been created yet.</font>
         </td></tr>
         <tr><td bgcolor=black><font color=yellow>Please use the \"undo\" command to go back from here</font>
         </td></tr></table> " // the ravine. "
;


/*
 *  **** bookmark ****
 */ 
canyonNorth: Room 'canyon'
    desc {
        "You are at the north end of a vast underground canyon. You know the dragon is to the ";
        if(gameMain.allowHtmlLinks){
            "<a href=\"south\">south</a>";
        }else{
            "south"; 
        }
        " of here. ";
    }
    trainConductor = 0
    south: NoTravelMessage {
         travelDesc { 
                 "You don\'t feel like going back and further angering the dragon. ";
                if(canyonNorth.trainConductor == 0){
                    "<.p>...A funny little guy dressed in black robes suddenly appears in a cloud of orange
                    smoke. He\'s wearing a train engineer\'s hat and smiles at you and says,\"It\'s not my
                    doing. I swear. It\'s not my fault but you must know... there\'s probably only one way
                    out of here.\"<.p>With that he tosses a glass vial to the ground and vanishes in a cloud of
                    orange smoke. ";
                    noDungeonMaster.moveInto(gPlayerChar.location.getOutermostRoom());
                    noCleoKraft.moveInto(gPlayerChar.location.getOutermostRoom()); 
                    noOrangeSmoke.moveInto(gPlayerChar.location.getOutermostRoom());
                    noGlassVial.moveInto(gPlayerChar.location.getOutermostRoom());
                    canyonNorth.trainConductor = 1;// flag so we don't run this part again
                }
         }
    }
    /*
     *   south: TravelWithMessage,OneWayRoomConnector { ->greenCaveEast
     *   travelDesc { "You travel back to the other end of the canyon. "; }
     }*/
;


// ------------------------ removed




gravelRoadOne: OutdoorRoom 'road'
   "On a gravel road. "
;







bodyRestorer: Fixture, Readable, Heavy '(strange) (body) (form) (normalization) normalizer restorer device/machine/invention' 'body restorer'
  "A body restorer. "
  location = pixyland
  
  controlsSet = nil
  hasUsed = nil
;



