#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

#define p1 (glob.parser == human)
#define p2 (glob.parser == alien)
#define p3 (glob.parser == hacman)
#define p23 (glob.parser == alien || glob.parser == hacman)

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// NOTES
// ACTIONS: Smell
// ACTIONS: Sleep
// ACTIONS: Sit, Lie
// ACTIONS: PutIn, PutOn, PutUnder, PutBehind
// ACTIONS: LookUnder, LookBehind, PutUnder, PutBehind
// ACTIONS: Set
// ACTIONS: Insert
// ACTIONS: Say (needed for Twisty/Escape mazes)
// ACTIONS: Yes, No, Hello, Goodbye
// ACTIONS: Ask, Tell, Yes, No, Hello, Goodbye, Topics
// ACTIONS: TalkTo
// ACTIONS: Yell
// ACTIONS: Attack, Hit, Cut
// ACTIONS: ThrowAt, ThrowTo
// ACTIONS: Wake, WakeOther
// ACTIONS: Move
// ACTIONS: Screw, Unscrew
// ACTIONS: Use, UseOn
// ACTIONS: SwimIn
// ACTIONS: KnockOn
// ACTIONS: Run, Execute
// ACTIONS: Play
// ACTIONS: Compile
// ACTIONS: Flush
// ACTIONS: Staple, StapleWith
// ACTIONS: Peel (With a P. not "feel.")
// ACTIONS: Wrap, WrapIn, WrapAround, Unwrap
// ACTIONS: LIQUID ACTIONS: Drink, Eat
// ACTIONS: LIQUID ACTIONS: Moisten, MoistenWith
// ACTIONS: LIQUID ACTIONS: Mix
// ACTIONS: LIQUID ACTIONS: Pour, PourInto, PourOnto
// ACTIONS: LIQUID ACTIONS: ProxyPour, ProxyPourInto, ProxyPourOnto
// ACTIONS: LIQUID ACTIONS: Fill, FillWith
// ACTIONS: SHOOTING ACTIONS: Shoot, ShootAimlessly, ShootWith, ShootWithWhat, Fire
// ACTIONS: WhoIs
// ACTIONS: WhatIs
// ACTIONS: Glist
// ACTIONS: Xyzzy, Plugh, Plover
// ACTIONS: MusicOn, MusicOff
// ACTIONS: Images / ImagesLarge / ImagesSmall
// ACTIONS: Score
// ACTIONS: Turns (for debugging only)
// ACTIONS: Note
// ACTIONS: INNER GAME META-ACTIONS: Info
// ACTIONS: INNER GAME META-ACTIONS: Escape
// ACTIONS: INNER GAME META-ACTIONS: Stop
// ACTIONS: INNER GAME META-ACTIONS: Reset
// ACTIONS: INNER GAME META-ACTIONS: Begin
// ACTIONS: INNER GAME META-ACTIONS: Inner game finish options
// ACTIONS: CLS / CLST (debugging verb useful for getting cleaner screenshots)
// ACTIONS: SpareMe
// ACTIONS: MENU ACTIONS: About, Credits, Copyright
// ACTIONS: MENU ACTIONS: Menu options
// ACTIONS: MENU ACTIONS: Instructions
// ACTIONS: MENU ACTIONS: Hint
// ACTIONS: MENU ACTIONS: Hint menu options

// -------------------------------------------------------------------
// NOTES
// -------------------------------------------------------------------

/*
NOTE TO SELF: Consider including the following items to this file:

Deal with Africa/Mexico directions and any other artificial directions.
Sigh. For some reason I missed the actions in 3guns.t.
Also get the actions in qtalk.t.
*/

// -------------------------------------------------------------------
// ACTIONS: Smell
// -------------------------------------------------------------------

modify playerActionMessages
  thingSmellDescMsg(obj) {
    gMessageParams(obj);
    return '{It obj/he} {does}n<./s>t smell like much. ';
  }
;

// -------------------------------------------------------------------
// ACTIONS: Sleep
// -------------------------------------------------------------------

replace VerbRule(Sleep)
  'sleep' | 'go' 'to' 'sleep'
  : SleepAction
  verbPhrase = 'sleep/sleeping'
;

// -------------------------------------------------------------------
// ACTIONS: Sit, Lie
// -------------------------------------------------------------------

// These modifications are for the sake of the coffin scenario.

// If no TADS309 stuff, add it.

#ifdef TADS308

/*
DefineIAction(Sit)
  execAction() {
    if (gActor.posture == sitting)
      reportFailure(&alreadySittingMsg);
    else
      askForDobj(SitOn);
  }
;
DefineIAction(Lie)
  execAction() {
    if (gActor.posture == lying)
      reportFailure(&alreadyLyingMsg);
    else
      askForDobj(LieOn);
  }
;
*/

/*
modify VerbRule(SitOnWhat)
  ' ' :
;
modify VerbRule(LieOnWhat)
  ' ' :
;
*/
/*
modify VerbRule(Sit)
  'sit' ( | 'down' | 'up')
  :
;
modify VerbRule(Lie)
  'lie' ( | 'down')
  :
;
modify playerActionMessages
  alreadySittingMsg = '{You\'re} already sitting down. '
  alreadyLyingMsg = '{You\'re} already lying down. '
;
*/

#else // TADS308 is not defined -- i.e., we're using 3.0.9 or better

modify VerbRule(Sit)
  'sit' ( | 'down' | 'up')
  :
;

#endif // TADS308

// -------------------------------------------------------------------
// ACTIONS: PutIn, PutOn, PutUnder, PutBehind
// -------------------------------------------------------------------

// Some of these modifications, in particular the ones designed 
// to allow 'set' as a synonym for 'put', are not necessary anymore 
// due to updates in TADS 3. They were necessary when I was developing
// this code using version 3.0.8.

modify VerbRule(PutIn)
    ('put' | 'place' | 'set' | 'insert') dobjList
        ('in' | 'into' | 'in' 'to' | 'inside' | 'inside' 'of') singleIobj
    : 
    //PutInAction
    //verbPhrase = 'put/putting (what) (in what)'
    //askIobjResponseProd = inSingleNoun
;

modify VerbRule(PutOn)
    ('put' | 'place' | 'drop' | 'set') dobjList
        ('on' | 'onto' | 'on' 'to' | 'upon') singleIobj
    | 'put' dobjList 'down' 'on' singleIobj
    : 
    //PutOnAction
    //verbPhrase = 'put/putting (what) (on what)'
    //askIobjResponseProd = onSingleNoun
;

modify VerbRule(PutUnder)
    ('put' | 'place' | 'set') dobjList 'under' singleIobj
    : 
    //PutUnderAction
    //verbPhrase = 'put/putting (what) (under what)'
;

modify VerbRule(PutBehind)
    ('put' | 'place' | 'set') dobjList 'behind' singleIobj
    : 
    //PutBehindAction
    //verbPhrase = 'put/putting (what) (behind what)'
;

modify VerbRule(PutInWhat)
    [badness 500] ('put' | 'place' /*| 'set'*/) dobjList
    : 
    //PutInAction
    //verbPhrase = 'put/putting (what) (in what)'
    //construct()
    //{
    //    iobjMatch = new EmptyNounPhraseProd();
    //    iobjMatch.responseProd = inSingleNoun;
    //}
;

// -------------------------------------------------------------------
// ACTIONS: LookUnder, LookBehind, PutUnder, PutBehind
// -------------------------------------------------------------------

// NOTE: If the above modifications to PutUnder and PutBehind
// are allowed to remain, they must be *above* this code!

replace VerbRule(LookUnder)
  ' '
  : BasicProd
;
replace VerbRule(LookBehind)
  ' '
  : BasicProd
;
replace VerbRule(PutUnder)
  ' '
  : BasicProd
;
replace VerbRule(PutBehind)
  ' '
  : BasicProd
;

DefineIAction(LookUnderUnnecessarily)
  execAction() {
    mainReport('It is not necessary to look under anything 
      in this game. ');
  }
  actionTime = 0
;
DefineIAction(LookBehindUnnecessarily)
  execAction() {
    mainReport('It is not necessary to look behind anything 
      in this game. ');
  }
  actionTime = 0
;
DefineIAction(PutUnderUnnecessarily)
  execAction() {
    mainReport('It is not necessary to put anything under 
      anything else in this game. ');
  }
  actionTime = 0
;
DefineIAction(PutBehindUnnecessarily)
  execAction() {
    mainReport('It is not necessary to put anything behind 
      anything else in this game. ');
  }
  actionTime = 0
;

VerbRule(LookUnderUnnecessarily)
  ('look' | 'l') 'under' (miscWordList | )
  : LookUnderUnnecessarilyAction
  verbPhrase = 'look/looking (under what)'
;
VerbRule(LookBehindUnnecessarily)
  ('look' | 'l') 'behind' (miscWordList | )
  : LookBehindUnnecessarilyAction
  verbPhrase = 'look/looking (behind what)'
;
VerbRule(PutUnderUnnecessarily)
  ('put' | 'place') (miscWordList | ) 'under' (miscWordList | )
  : PutUnderUnnecessarilyAction
  verbPhrase = 'put/putting (under what)'
;
VerbRule(PutBehindUnnecessarily)
  ('put' | 'place') (miscWordList | ) 'behind' (miscWordList | )
  : PutBehindUnnecessarilyAction
  verbPhrase = 'put/putting (behind what)'
;

/*
modify Thing
  dobjFor(PutBehindUnnecessarily) {
    preCond = [touchObj]
    verify() { }
  }
  iobjFor(PutBehindUnnecessarily) {
    preCond = [touchObj]
    verify() { illogical(&cannotPutBehindMsg); }
  }
;
*/

/*
modify LookUnderAction
  actionTime = 0
;
modify LookBehindAction
  actionTime = 0
;
modify playerActionMessages
  nothingUnderMsg = '{You/he} see{s} nothing unusual under {the dobj/him}. '
  nothingBehindMsg =
    '{You/he} see{s} nothing unusual behind {the dobj/him}. '
;
*/

// -------------------------------------------------------------------
// ACTIONS: Set
// -------------------------------------------------------------------

// Set already defined in newer versions of TADS 3 in precisely this way:
/*
DefineTAction(Set)
;
replace VerbRule(Set)
    'set' dobjList
    : SetAction
    verbPhrase = 'set/setting (what)'
;
modify Thing
    dobjFor(Set)
    {
        verify() { }
        action() { askForIobj(PutOn); }
    }
;
modify Settable
    dobjFor(Set)
    {
        verify() { logicalRank(150, 'settable'); }
        action() { askForLiteral(SetTo); }
    }
;
*/

// -------------------------------------------------------------------
// ACTIONS: Insert
// -------------------------------------------------------------------

DefineTAction(Insert)
;
VerbRule(Insert)
  'insert' dobjList
  : InsertAction
  verbPhrase = 'insert/inserting (what)'
;
modify Thing
  dobjFor(Insert) {
    verify() { }
    action() { askForIobj(PutIn); }
  }
;

// -------------------------------------------------------------------
// ACTIONS: Say (needed for Twisty/Escape mazes)
// -------------------------------------------------------------------

///*
//    'yes' | 'affirmative' /*| 'say' 'yes'*/ | 'y'
//    'no' | 'negative' //| 'say' 'no'
//    /*('say' | )*/ ('hello' | 'hallo' | 'hi')
//    /*('say' | ())*/ ('goodbye' | 'good-bye' | 'good' 'bye' | 'bye')
//*/

DefineLiteralAction(Say)
  execAction() {
    if (!gPlayerChar.getOutermostRoom.ofKind(TwistyEscapeRoom)) {
      switch (gLiteral.toLower) {
        case 'yes':
          replaceAction(Yes);
          break;
        case 'no':
          replaceAction(No);
          break;
        case 'hello':
        case 'hallo':
        case 'hi':
          replaceAction(Hello);
          break;
        case 'goodbye':
        case 'good-bye':
        case 'good bye':
        case 'bye':
          replaceAction(Goodbye);
          break;
      }
    }
    if (gPlayerChar != bot)
      say(playerActionMessages.useTalkToMsg);
    else {
      "Sheila cries, 
        <.q>\^<<gLiteral.toLower>>!<./q> ";
      if (!bot.getOutermostRoom.ofKind(TwistyEscapeRoom))
        noResponseToSay();
    }
  }
;

noResponseToSay() {
  "<p>Nobody replies. ";
}

VerbRule(Say)
  'say' singleLiteral
  : SayAction
  verbPhrase = 'say/saying (what)'
;

// -------------------------------------------------------------------
// ACTIONS: Yes, No, Hello, Goodbye
// -------------------------------------------------------------------

// "Yes"

// Changed (1) in order to add 'y' to YesAction vocabulary,
// and (2) in order to eliminate the 'say' 'yes' vocabulary.

replace VerbRule(Yes)
    'yes' | 'affirmative' /*| 'say' 'yes'*/ | 'y'
    : YesAction
    verbPhrase = 'say/saying yes'
;

// "No"

replace VerbRule(No)
    'no' | 'negative' //| 'say' 'no'
    : NoAction
    verbPhrase = 'say/saying no'
;

// "Hello"

replace VerbRule(Hello)
    /*('say' | )*/ ('hello' | 'hallo' | 'hi')
    : HelloAction
    verbPhrase = 'say/saying hello'
;

// "Goodbye"

replace VerbRule(Goodbye)
    /*('say' | ())*/ ('goodbye' | 'good-bye' | 'good' 'bye' | 'bye')
    : GoodbyeAction
    verbPhrase = 'say/saying goodbye'
;

// -------------------------------------------------------------------
// ACTIONS: Ask, Tell, Yes, No, Hello, Goodbye, Topics
// -------------------------------------------------------------------

modify Actor
  dobjFor(Consult) {
    verify {
      illogical(&useTalkToMsg);
    }
  }
  dobjFor(ConsultAbout) asDobjFor(Consult)
;

modify ConsultAction
  actionTime {
    if (gDobj && gDobj.ofKind(Actor))
      return 0;
    else
      return 1;
  }
;

modify ConsultAboutAction
  actionTime {
    if (gDobj && gDobj.ofKind(Actor))
      return 0;
    else
      return 1;
  }
;


// Since these now just produce parser errors,
// they should count as meta-verbs.

//modify AskAction
//  actionTime = 0
//;
//
//modify TellAction
//  actionTime = 0
//;

replace VerbRule(Ask) 
  ('ask' | 'a') (miscWordList | ) 
  : AskAction
  verbPhrase = 'ask/asking'
;

DefineIAction(Ask)
  execAction() { mainReport(&useTalkToMsg); }
  actionTime = 0
;

replace VerbRule(Tell) 
  ('tell') (miscWordList | ) 
  : TellAction
  verbPhrase = 'tell/telling'
;

DefineIAction(Tell)
  execAction() { mainReport(&useTalkToMsg); }
  actionTime = 0
;

modify AskForAction
  actionTime = 0
;

modify AskAboutAction
  actionTime = 0
;

modify TellAboutAction
  actionTime = 0
;

modify HelloAction
  actionTime = 0
;

modify GoodbyeAction
  actionTime = 0
;

modify YesAction
  actionTime = 0
;

modify NoAction
  actionTime = 0
;

modify TopicsAction
  actionTime = 0
;

//modify playerActionMessages
//  useTalkToMsg() {
//    local k = 0; k= k/k;
//    return 'To talk to someone, please type TALK TO
//                   PERSON. ';
//  }
//;

// -------------------------------------------------------------------
// ACTIONS: TalkTo
// -------------------------------------------------------------------

modify VerbRule(TalkTo)
    [badness 10] // In order to make sure that "talk to aliens" gets preference.
    //('greet' | 'say' 'hello' 'to' | 'talk' 'to' | 't' 'to'
    //  | 't') singleDobj
    //('talk' 'to' | 't' 'to' | 't') singleDobj
    ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) singleDobj
    //' '
    : //TalkToAction
    //verbPhrase = 'talk/talking (to whom)'
    //askDobjResponseProd = singleNoun
    construct()
    {
        // set up the empty direct object phrase
        dobjMatch = new EmptyNounPhraseProd();
        dobjMatch.responseProd = singleNoun;
    }
;

modify glob
  pluralTalkers = nil
;

// Just a class; there will be no VerbRule() for this class -- 
// only its subclasses.
DefineIAction(TalkToNpcs)
  execAction {
    local talkers =
      npcList.subset({x: x != gActor && gActor.canSee(x)});
    if (talkers.length) {
      if (talkers.length > 1)
        glob.pluralTalkers = true;
      else
        glob.pluralTalkers = nil;
      replaceAction(TalkTo, talkers[1]);
    }
    else
      playerMessages.noMatch(gActor, pluralWord);
      //"{You/he} see{s} no <<pluralWord>> here. ";
  }
  npcList = []
  pluralWord = '' // override
  actionTime {
    if (npcList.indexWhich({x: x != gActor && gActor.canSee(x)}))
      return 1;
    else
      return 0;
  }
;


DefineAction(Talk, TalkToNpcsAction)
  execAction {
    local talkers =
      npcList.subset({x: x != gActor && gActor.canSee(x)});
    //"Talk talk talk!! Talk talk!! <p>";
    if (glob.isInEndgame) {
      if (TalkToProfsAction.npcList.subset({x: x != gActor && gActor.canSee(x)}).length ==
          TalkToAliensAction.npcList.subset({x: x != gActor && gActor.canSee(x)}).length && 
          TalkToProfsAction.npcList.subset({x: x != gActor && gActor.canSee(x)}).length == 2) {
        "(to the professors) ";
        doTalkBreak();
        nestedAction(TalkToProfs);
        return;
      }
    }
    for (local a = 1; a <= actionList.length; a++) {
      talkers = actionList[a].npcList.subset({x: x != gActor && gActor.canSee(x)});
      if (talkers.length > 1) {
        "(to the <<actionList[a].pluralWord>>) ";
        doTalkBreak();
        _nestedAction(nil, gActor, actionList[a]);
        return;
      }
      if (talkers.length == 1) {
        "(to <<talkers[1].theName>>) ";
        doTalkBreak();
        nestedAction(TalkTo, talkers[1]);
        return;
      }
    }
    askForDobj(TalkTo);
    //if (talkers.length) {
    //  
    //  nestedAction(TalkTo, talkers[1]);
    //}
    //else if () {
    //  playerMessages.noMatch(gActor, pluralWord);
    //  //"{You/he} see{s} no <<pluralWord>> here. ";
    //}
  }
  // sorted by descending order of priority
  npcList = [
    neton, ovan, 
    vicki, diane, 
    adam, bandit, 
    //dragon, copyman, troll, naga, balrog, bat
    bot, 
    youngGuard, oldGuard, assistant
  ]
  actionList {
    if (!glob.isInEndgame || (me.isIn(dreamRoom) && neton.isIn(office)))
      return [
        TalkToProfsAction, TalkToWomenAction, TalkToGuardsAction
      ];
    else
      return [
        TalkToAliensAction, TalkToWomenAction
      ];
  }
  doTalkBreak() {
    "<br>";
  }
  pluralWord = 'people to talk to'
;
DefineAction(TalkToAliens, TalkToNpcsAction)
  npcList = [neton, ovan, youngGuard, oldGuard, assistant]
  pluralWord = 'aliens'
;
DefineAction(TalkToProfs, TalkToNpcsAction)
  npcList = [neton, ovan]
  pluralWord = 'professors'
;
DefineAction(TalkToGuards, TalkToNpcsAction)
  npcList = [youngGuard, oldGuard]
  pluralWord = 'guards'
;
DefineAction(TalkToPeople, TalkToNpcsAction)
  npcList = [
    vicki, diane, adam, bandit
    //, neton, ovan, oldGuard, youngGuard, assistant
    //, me, virtualMe
  ]
  pluralWord = 'people'
;
DefineAction(TalkToHumans, TalkToNpcsAction)
  npcList = [
    vicki, diane, adam, bandit 
    //, me, virtualMe
  ]
  pluralWord = 'humans'
;
DefineAction(TalkToWomen, TalkToNpcsAction)
  npcList = [vicki, diane]
  pluralWord = 'women'
;
DefineAction(TalkToPrisoners, TalkToNpcsAction)
  npcList = [vicki, diane]
  pluralWord = 'prisoners'
;
modify Quip
  breakBeforeOptions {
    local actn = gAction;
    if (!actn)
      return inherited;
    for (;;) {
      if (actn.parentAction == nil)
        break;
      else
        actn = actn.parentAction;
    }
    if (actn.ofKind(TalkAction))
      return nil;
    else
      return inherited;
  }
;

VerbRule(Talk)
  [badness 9] // not sure if this is a good value or not
  ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) ('the' | ) 
  : TalkAction
  verbPhrase = 'talk/talking'
;
VerbRule(TalkToAliens)
  [badness 5]
  ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) ('the' | ) 
    ('aliens' | 'oos')
  : TalkToAliensAction
  verbPhrase = 'talk/talking to the aliens'
;
VerbRule(TalkToProfs)
  [badness 2]
  ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) ('the' | ) 
    ('profs' | 'professors')
  : TalkToProfsAction
  verbPhrase = 'talk/talking to the professors'
;
VerbRule(TalkToGuards)
  [badness 2]
  ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) ('the' | ) 
    ('guards')
  : TalkToGuardsAction
  verbPhrase = 'talk/talking to the guards'
;
VerbRule(TalkToPeople)
  [badness 6]
  ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) ('the' | ) 
    ('people' /*: 'persons'*/)
  : TalkToPeopleAction
  verbPhrase = 'talk/talking to the people'
;
VerbRule(TalkToHumans)
  [badness 5]
  ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) ('the' | ) 
    ('humans')
  : TalkToHumansAction
  verbPhrase = 'talk/talking to the humans'
;
VerbRule(TalkToWomen)
  [badness 2]
  ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) ('the' | ) 
    ('women' | 'gals' | 'ladies')
  : TalkToWomenAction
  verbPhrase = 'talk/talking to the women'
;
VerbRule(TalkToPrisoners)
  [badness 2]
  ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) ('the' | ) 
    ('prisoners')
  : TalkToPrisonersAction
  verbPhrase = 'talk/talking to the prisoners'
;

/*
// TalkToAliens

DefineIAction(TalkToAliens)
  execAction() {
    local profCt = 0;
    local guardCt = 0;
    local alienCt = 0;
    //"TalkToAliensAction is being executed. ";
    if (gActor.canSee(neton     )) profCt++;
    if (gActor.canSee(ovan      )) profCt++;
    if (gActor.canSee(assistant )) profCt++;
    if (gActor.canSee(oldGuard  )) guardCt++;
    if (gActor.canSee(youngGuard)) guardCt++;
    alienCt = profCt + guardCt;
    if (!alienCt)
      "{You/he} see{s} no aliens here. ";
    //else if (isInEndgame)
    //  "<<endgameTalkMsg(alienCt > 1)>>";
    else if (profCt > 1)
      replaceAction(TalkTo, professionalGroup);
    else if (gActor.canSee(neton))
      replaceAction(TalkTo, neton);
    else if (gActor.canSee(ovan))
      replaceAction(TalkTo, ovan);
    else if (gActor.canSee(assistant))
      replaceAction(TalkTo, assistant);
    else if (guardCt > 1)
      replaceAction(TalkTo, guardGroup);
    else if (gActor.canSee(youngGuard))
      replaceAction(TalkTo, youngGuard);
    else if (gActor.canSee(oldGuard))
      replaceAction(TalkTo, oldGuard);
    // If we reach this point, something is wrong.
    else
      "{You/he} see{s} no aliens here. ";
  }
  actionTime {
    if (gPlayerChar.location == nil) // a hack for the first 2 turns
      return 1;
    if (!gActor)
      return 1;
    if (gActor.canSee(neton     ) ||
        gActor.canSee(ovan      ) ||
        gActor.canSee(assistant ) ||
        gActor.canSee(oldGuard  ) ||
        gActor.canSee(youngGuard))
      return 1;
    return 0;
  }
;

VerbRule(TalkToAliens)
  ('talk' | 'speak' | 'chat' | 't') ('with' | 'to' | ) 
    ('the' | ) ('aliens' | 'oos')
  //('talk' 'to' | 't' 'to' | 't') ('aliens' | 'oos')
  //'talk' 'to' 'aliens' | 't' 'to' 'aliens' | 't' 'aliens' |
  //  'talk' 'to' 'oos' | 't' 'to' 'oos' | 't' 'oos'
  : TalkToAliensAction
  verbPhrase = 'talk/talking to the aliens'
;
*/

// -------------------------------------------------------------------
// ACTIONS: Yell
// -------------------------------------------------------------------

// Who needs yell anyway? It's just a programming hassle.
// But wait, on second thought, my testers think I should 
// keep the verb. Grr.

//replace VerbRule(Yell)
//    ' '
//    : YellAction
//    verbPhrase = 'yell/yelling'
//;

// -------------------------------------------------------------------
// ACTIONS: Attack, Hit, Cut
// -------------------------------------------------------------------

// Adding 'stab', 'slash', and 'jab'

modify VerbRule(Attack)
  ('attack' | 'kill' | 'hit' | 'kick' | 'punch'
    | 'stab' | 'slash' | 'jab'
  ) singleDobj
  : 
  //AttackAction
  //verbPhrase = 'attack/attacking (whom)'
  //askDobjResponseProd = singleNoun
;

modify VerbRule(AttackWith)
  ('attack' | 'kill' | 'hit' | 'kick' | 'punch' 
    | 'stab' | 'slash' | 'jab' | 'strike')
    singleDobj
    'with' singleIobj
  :
  //AttackWithAction
  //verbPhrase = 'attack/attacking (whom) (with what)'
  //askDobjResponseProd = singleNoun
  //askIobjResponseProd = withSingleNoun
;

modify Button
  // 'hit button' is logical
  dobjFor(Attack) asDobjFor(Push)
;

// The following has to do with my earlier effort to differentiate
// between hitting and attacking. I think hitting and attacking are
// very different actions; HITting a nail makes sense, whereas 
// KILLing it doesn't. But I decided that the responses to those 
// two actions hardly ever *need* to be different. That is, I don't
// think a game is ever likely to seriously suffer much if "KILL X" 
// produces the same response as "HIT X", whether X is a nail or 
// anything else I can think of. And it's a lot simpler if you don't 
// have to differentiate between four different actions: Hit, 
// HitWith, Attack, and AttackWith.

//replace VerbRule(Attack)
//  ('attack' | 'kill') singleDobj
//  : AttackAction
//  verbPhrase = 'attack/attacking (whom)'
//  askDobjResponseProd = singleNoun
//;
//
//replace VerbRule(AttackWith)
//  ('attack' | 'kill')
//    singleDobj
//    'with' singleIobj
//  : AttackWithAction
//  verbPhrase = 'attack/attacking (whom) (with what)'
//  askDobjResponseProd = singleNoun
//  askIobjResponseProd = withSingleNoun
//;
//
//DefineTAction(Hit);
//
//DefineTIAction(HitWith)
//  getAllIobj(actor, scopeList)
//  {
//    return scopeList.subset({x: x.isIn(actor)});
//  }
//;
//
//VerbRule(Hit)
//  ('hit' | 'kick' | 'punch') singleDobj
//  : HitAction
//  verbPhrase = 'hit/hitting (whom)'
//  askDobjResponseProd = singleNoun
//;
//
//VerbRule(HitWith)
//  ('hit' | 'kick' | 'punch' | 'strike')
//    singleDobj
//    'with' singleIobj
//  : HitWithAction
//  verbPhrase = 'hit/hitting (whom) (with what)'
//  askDobjResponseProd = singleNoun
//  askIobjResponseProd = withSingleNoun
//;


// Hit:
// I was going to create a 'hit' verb, separate from
// 'attack'. But I changed my mind.

DefineTAction(Hit);

DefineTIAction(HitWith)
  getAllIobj(actor, scopeList)
  {
    return scopeList.subset({x: x.isIn(actor)});
  }
;

VerbRule(Hit)
  ' ' // nullifying this verb
  : HitAction
  verbPhrase = 'hit/hitting (whom)'
  askDobjResponseProd = singleNoun
;

VerbRule(HitWith)
  ' ' // nullifying this verb
  : HitWithAction
  verbPhrase = 'hit/hitting (whom) (with what)'
  askDobjResponseProd = singleNoun
  askIobjResponseProd = withSingleNoun
;

modify Thing
  //dobjFor(Strike) asDobjFor(Hit)
  dobjFor(Hit) {
    preCond = [touchObj]
    verify() { }
    action() { mainReport(&uselessToHitMsg); }
  }
  dobjFor(HitWith) {
    preCond = [touchObj]
    verify() { }
    action() { mainReport(&uselessToHitMsg); }
  }
  iobjFor(HitWith) {
    preCond = [objHeld]
    verify() { illogical(&notAHittingInstrumentMsg); }
  }
;

modify Actor
  dobjFor(Strike)  asDobjFor(Attack)
  dobjFor(Hit)     asDobjFor(Attack)
  dobjFor(HitWith) asDobjFor(Attack)
;

modify Thing
  uselessToAttackMsg {
    if (gActor != bot)
      return 'You deliver a solid blow to {the dobj/him}. 
        This hurts your '
        + (gAction.getOrigTokenList[1][1].toLower() == 'kick' ? 'foot' : 'hand')
        + ' a bit, but it does no damage at all to {the dobj/him}. ';
    else
      return 'Sheila bangs her robotic '
        + (gAction.getOrigTokenList[1][1].toLower() == 'kick' ? 'foot' : 'fist')
        + ' at {the dobj/him}, but
        {it/he} just sit{s} there. ';
  }
  uselessToAttackWithMsg {
    if (gActor != bot)
      return 'Wielding {the iobj/him}, you deliver a solid blow to {the dobj/him}. 
        This does no damage at all to {the dobj/him}. ';
    else
      return 'Wielding {the iobj/him}, Sheila bangs away
        at {the dobj/him}, but {it/he dobj} just sit{s} there. ';
  }
  dobjFor(AttackWith) {
    action {
      mainReport(&uselessToAttackWithMsg);
    }
  }
  uselessToHitMsg {
    return uselessToAttackMsg;
  }
  uselessToHitWithMsg {
    return uselessToHitWithMsg;
  }
  dobjFor(HitWith) {
    action {
      mainReport(&uselessToHitWithMsg);
    }
  }
;

modify playerActionMessages
  uselessToHitWithMsg = (uselessToHitMsg)
  uselessToAttackWithMsg = (uselessToAttackMsg)
;


modify Room
  uselessToAttackMsg = nil
  uselessToHitMsg = nil
;

modify Actor
  uselessToAttackMsg = nil
  uselessToHitMsg = nil
;

/*
objects to investigate for Attacking:
me
*/

modify Thing
  isSoft = nil
  isMoist = nil
;

modify Wearable
  isSoft = true
  uselessToAttackMsg = 'Hitting {that dobj/him} would serve no purpose. '
  uselessToHitMsg = 'Hitting {that dobj/him} would serve no purpose. '
  dobjFor(AttackWith) asDobjFor(Attack)
  dobjFor(HitWith) asDobjFor(Hit)
;


class Soft: object
  isSoft = true
  uselessToAttackMsg {
    return 'You deliver a solid blow to {the dobj/him}. 
      This does no damage at all to {the dobj/him}. ';
  }
  uselessToHitMsg {
    return 'You deliver a solid blow to {the dobj/him}. 
      This does no damage at all to {the dobj/him}. ';
  }
;

class Moist: object
  isMoist = true
;

class Unhittable: object
  uselessToHitMsg = nil
  uselessToAttackMsg = nil
;

class BarelyReachable: object
  uselessToAttackMsg = '{The dobj/he} is just barely within reach.
    It<./s>s a little too awkward for you to deliver it any kind of 
    solid blow. '
  uselessToHitMsg = (uselessToAttackMsg)
;

modify playerActionMessages
  cutNoEffectMsg = '{You/he} do{es}n<./s>t see any point in 
    trying to cut into {the dobj/him}. '
;

// -------------------------------------------------------------------
// ACTIONS: ThrowAt, ThrowTo
// -------------------------------------------------------------------

modify VerbRule(ThrowAt)
    ('throw' | 'toss') dobjList ('at' | 'to') singleIobj
    : 
    //ThrowAtAction
    //verbPhrase = 'throw/throwing (what) (at what)'
    //askIobjResponseProd = atSingleNoun
;

modify VerbRule(ThrowTo)
    ' '
    :
    //ThrowToAction
    //verbPhrase = 'throw/throwing (what) (to whom)'
    //askIobjResponseProd = toSingleNoun
;

// -------------------------------------------------------------------
// ACTIONS: Wake, WakeOther
// -------------------------------------------------------------------

DefineIAction(Wake)
  execAction() {
    if (gActor.isIn(coffin)) {
      "You<./s>re awake, all right. But what will you do next? ";
    }
    else if (gActor.getOutermostRoom && 
        gActor.getOutermostRoom.ofKind(AlienRoom)) {
      "Unfortunately, you<./s>re as awake as you<./s>re ever
        going to be. ";
    }
    else if (gActor.getOutermostRoom == vrRoom) {
      replaceAction(TravelVia, goBackToCell);
    }
    else if (gActor.getOutermostRoom is in (beachRoom, vrRoom)) {
      "Good idea, but unfortunately you can<./s>t seem 
        to wake yourself up here by simple force of will. ";
    }
    else if (gPlayerChar == bot) {
      "<.q>If you really want to stop playing the game, you can
        always type STOP,<./q> says Sheila. <.q>Just be aware 
        that you<./s>ll lose all the progress you<./s>ve made 
        here so far.<./q> ";
    }
    // A catch-all for any unforeseen scenario:
    else {
      "Unfortunately, you<./s>re as awake as you<./s>re ever
        going to be. ";
    }
  }
;
VerbRule(Wake)
  'wake' | 'wake' 'up' | 'awake' | 'awaken' | 'waken'
  : WakeAction
  verbPhrase = 'wake/waking up'
;

DefineTAction(WakeOther);
VerbRule(WakeOther)
  ('wake' | 'wake' 'up' | 'awake' | 'awaken' | 'waken') singleDobj
  : WakeOtherAction
  verbPhrase = 'wake/waking up (whom)'
;
modify Thing
  dobjFor(WakeOther) {
    preCond = [touchObj]
    verify()  {
      illogical('{That\'s dobj} not something you can wake up. ');
    }
  }
;
modify Actor
  dobjFor(WakeOther) {
    verify() {
      if (isStunned == nil)
        illogical('{The dobj/he} do{es}n<./s>t appear to be asleep. ');
    }
    // Actual waking up of stunned NPCs is handled in 3npcs.t.
  }
;

// -------------------------------------------------------------------
// ACTIONS: Move
// -------------------------------------------------------------------

replace VerbRule(Move)
    ('move' | 'slide') dobjList
    : MoveAction
    verbPhrase = 'move/moving (what)'
;

// -------------------------------------------------------------------
// ACTIONS: Screw, Unscrew
// -------------------------------------------------------------------

// These actions are totally superfluous for my game.

replace VerbRule(Screw)
    ' '
    : ScrewAction
    verbPhrase = 'screw/screwing (what)'
;

replace VerbRule(ScrewWith)
    ' '
    : ScrewWithAction
    verbPhrase = 'screw/screwing (what) (with what)'
    omitIobjInDobjQuery = true
    askIobjResponseProd = withSingleNoun
;

replace VerbRule(Unscrew)
    ' '
    : UnscrewAction
    verbPhrase = 'unscrew/unscrewing (what)'
;

replace VerbRule(UnscrewWith)
    ' '
    : UnscrewWithAction
    verbPhrase = 'unscrew/unscrewing (what) (with what)'
    omitIobjInDobjQuery = true
    askIobjResponseProd = withSingleNoun
;

// -------------------------------------------------------------------
// ACTIONS: Use, UseOn
// -------------------------------------------------------------------

DefineTAction(Use);

VerbRule(Use)
  ('use' | 'utilize' | 'utilise') singleDobj
  : UseAction
  verbPhrase = 'use/using (what)'
;

modify Thing
  dobjFor(Use) {
    preCond = [touchObj]
    verify() {
      illogical('You<./s>ll have to explain how you want '
        + (gPlayerChar.referralPerson == SecondPerson ? ''
            : '{the actor/him} ')
        + 'to use {the dobj/him}. ');
    }
    //check() {
    //  "{You/he} {will} have to explain how you want to 
    //    use {the dobj/him}. ";
    //  exit;
    //}
  }
;

DefineTIAction(UseOn);

VerbRule(UseOn)
  ('use' | 'utilize' | 'utilise') dobjList ('on' | 'with') singleIobj
  : UseOnAction
  verbPhrase = 'use/using (what) (on what)'
;

modify Thing
  dobjFor(UseOn) asDobjFor(Use)
  //iobjFor(UseOn) {
  //  verify() {
  //    illogical('{That iobj/he} do{es}n<./s>t look very good choice
  //               for something to use {the dobj/him} on. ');
  //  }
  //}
;

// -------------------------------------------------------------------
// ACTIONS: SwimIn
// -------------------------------------------------------------------

// I need no intransitive verb "Swim", since the transitive
// "SwimIn" verb will automatically seek out the most appropriate
// thing to swim in.

DefineTAction(SwimIn);

VerbRule(SwimIn)
  ('swim' | 'dive') (| 'in') singleDobj
  : SwimInAction
  verbPhrase = 'swim/swimming (in what)'
;

modify Thing
  dobjFor(SwimIn) {
    preCond = [touchObj]
    verify() {
      illogical('{You/he} {can\'t} swim in {that dobj/him}. ');
    }
  }
;

// -------------------------------------------------------------------
// ACTIONS: KnockOn
// -------------------------------------------------------------------

DefineTAction(KnockOn)
;

VerbRule(KnockOn)
  ('knock' 'on' | 'knock') singleDobj
  : KnockOnAction
  verbPhrase = 'knock/knocking (on what)'
;

modify Thing
  dobjFor(KnockOn) {
    preCond = [touchObj]
    verify() { 
      illogical('There<./s>s no reason to go knocking on 
        {that dobj/him}. '); 
    }
    action {
      "{You/he} knock{s} on {the dobj/him}, but no one answers. "; 
    }
  }
;

modify Door
  dobjFor(KnockOn) {
    verify() {
      if (!isOpen)
        logicalRank(150, 'closed door');
      else if (gDobj && isOpen)
        illogicalNow('There<./s>s no reason to go knocking 
          on an open door. ');
    }
  }
;

// -------------------------------------------------------------------
// ACTIONS: Run, Execute
// -------------------------------------------------------------------

// Intransitive "Run"

DefineIAction(VagueRun)
  execAction() { replaceAction(VagueTravel); }
;

VerbRule(VagueRun)
  'run'
  : VagueRunAction
  verbPhrase = 'run/running'
;

// Transitive "Run": RUN (direction)

replace VerbRule(Travel)
    ('go' | 'walk' | 'run') singleDir | singleDir
    : TravelAction
    verbPhrase = ('go/going ' + dirMatch.dir.name)
;

// Transitive "Run": RUN (physical object)

DefineTAction(Run);

VerbRule(Run)
  'run' singleDobj
  : RunAction
  verbPhrase = 'run/running (what)'
;

modify Thing
  dobjFor(Run) {
    preCond = [touchObj]
    verify() {
      illogical('{You/he} {can\'t} run {that dobj/him}. ');
    }
  }
;

// "Execute"

DefineTAction(Execute);

VerbRule(Execute)
  'execute' singleDobj
  : ExecuteAction
  verbPhrase = 'execute/executing (what)'
;

modify Thing
  dobjFor(Execute) asDobjFor(Attack)
;

// -------------------------------------------------------------------
// ACTIONS: Play
// -------------------------------------------------------------------

DefineTAction(Play);

VerbRule(Play)
  'play' singleDobj
  : PlayAction
  verbPhrase = 'play/playing (what)'
;

modify Thing
  dobjFor(Play) {
    preCond = [touchObj]
    verify() {
      illogical('{You/he} {can\'t} play {that dobj/him}. ');
    }
  }
;

// -------------------------------------------------------------------
// ACTIONS: Compile
// -------------------------------------------------------------------

DefineTAction(Compile);

VerbRule(Compile)
  ('compile' | 'recompile') singleDobj
  : CompileAction
  verbPhrase = 'compile/compiling (what)'
;

modify Thing
  dobjFor(Compile) {
    verify() {
      illogical('{You/he} {can\'t} compile {that dobj/him}. ');
    }
  }
;

// -------------------------------------------------------------------
// ACTIONS: Flush
// -------------------------------------------------------------------

DefineTAction(Flush);
VerbRule(Flush)
  ('flush') singleDobj
  : FlushAction
  verbPhrase = 'flush/flushing (what)'
;
modify Thing
  dobjFor(Flush) {
    preCond = [touchObj]
    verify() {
      illogical('{You/he} {can\'t} flush {that dobj/him}. ');
    }
  }
;

// -------------------------------------------------------------------
// ACTIONS: Staple, StapleWith
// -------------------------------------------------------------------

DefineTAction(Staple);
VerbRule(Staple)
  'staple' singleDobj
  : StapleAction
  verbPhrase = 'staple/stapling (what)'
;
modify Thing
  dobjFor(Staple) {
    verify() { }
    action() { askForIobj(StapleWith); }
  }
;
DefineTIAction(StapleWith);
VerbRule(StapleWith)
  'staple' singleDobj 'with' singleIobj
  : StapleWithAction
  verbPhrase = 'staple/stapling (what) (with what)'
;
modify Thing
  dobjFor(StapleWith) {
    verify() {
      // illogicalNow is a kludgey way of forcing the "iobj isn't a stapler"
      // message to take precedence.
      illogicalNow('{The dobj/he} do{es}n<./s>t look like 
        {it\'s} worth stapling. ');
    }
    preCond = [touchObj]
  }
  iobjFor(StapleWith) {
    verify() {
      illogical('Use {the iobj/him} as a stapler? I think not. ');
    }
    preCond = [objHeld]
  }
;
modify Actor
  dobjFor(StapleWith) {
    verify {
      illogicalNow('Getting violent with a stapler isn<./s>t the
        answer to this one. ');
    }
  }
;

// -------------------------------------------------------------------
// ACTIONS: Peel (With a P. not "feel.")
// -------------------------------------------------------------------

DefineTAction(Peel);
VerbRule(Peel)
  'peel' singleDobj
  : PeelAction
  verbPhrase = 'peel/peeling (what)'
;
modify Thing
  dobjFor(Peel) {
    verify() {
      illogical('{You/he} {can\'t} peel {that dobj/him}. ');
    }
    preCond = [objHeld]
  }
;

// -------------------------------------------------------------------
// ACTIONS: Wrap, WrapIn, WrapAround, Unwrap
// -------------------------------------------------------------------

DefineTAction(Unwrap);
VerbRule(Unwrap)
  'unwrap' singleDobj
  : UnwrapAction
  verbPhrase = 'unwrap/unwrapping (what)'
;
modify Thing
  dobjFor(Unwrap) {
    verify() {
      illogical('{The dobj/him} {is}n<./s>t wrapped in anything. ');
    }
    preCond = [touchObj]
  }
;

DefineTAction(Wrap);
VerbRule(Wrap)
  'wrap' singleDobj
  : WrapAction
  verbPhrase = 'wrap/wrapping (what)'
;
modify Thing
  dobjFor(Wrap) {
    verify() {
      illogical(&uselessToWrapMsg);
    }
    preCond = [objHeld]
    action {
      askForIobj(WrapIn);
    }
  }
;

DefineTIAction(WrapIn);
VerbRule(WrapIn)
  'wrap' (singleDobj | singleDobj 'up' | 'up' singleDobj) 
    ('with' | 'in' | 'into') singleIobj
  : WrapInAction
  verbPhrase = 'wrap/wrapping (what) (in what)'
;
modify Thing
  dobjFor(WrapIn) {
    verify() {
      // A convenient abuse of illogicalNow, designating that 
      // "impossible wrapping implement" is more objectionable than 
      // "useless thing to wrap up"
      illogicalNow(&uselessToWrapMsg);
    }
    preCond = [objHeld]
  }
  iobjFor(WrapIn) {
    verify() {
      illogical(&cannotWrapInMsg);
    }
    preCond = [objHeld]
  }
;

DefineTIAction(WrapAround)
  resolveFirst = DirectObject
;
VerbRule(WrapAround)
  'wrap' singleDobj 'around' singleIobj
  : WrapAroundAction
  verbPhrase = 'wrap/wrapping (what) (around what)'
;
modify Thing
  dobjFor(WrapAround) {
    verify() {
      illogical(&cannotWrapInMsg);
    }
    preCond = [objHeld]
  }
  iobjFor(WrapAround) {
    verify() {
      // A convenient abuse of illogicalNow, designating that 
      // "impossible wrapping implement" is more objectionable than 
      // "useless thing to wrap up"
      illogicalNow(&uselessToWrapMsg);
    }
    preCond = [objHeld]
  }
;

modify playerActionMessages
  uselessToWrapMsg {
    local obj;
    if (gActionIs(WrapAround)) obj = gIobj;
    else obj = gDobj;
    gMessageParams(obj);
    return 'Wrapping {the obj/him} would serve no purpose. ';
  }
  cannotWrapInMsg {
    local obj;
    if (gActionIs(WrapAround)) obj = gDobj;
    else obj = gIobj;
    gMessageParams(obj);
    return '{You/he} {can\'t} use {the obj/him} to wrap anything. ';
  }
;
modify playerActionMessages
  okayUnwrapMsg(wr, th) {
    gMessageParams(wr, th);
    return '{You/he} unwrap{s} {the wr/him} from {the th/him}. ';
  }
;

// -------------------------------------------------------------------
// ACTIONS: LIQUID ACTIONS: Drink, Eat
// -------------------------------------------------------------------

replace VerbRule(Eat)
  'eat' //('eat' | 'consume') 
    ( | 'from') dobjList
  : EatAction
  verbPhrase = 'eat/eating (what)'
;

replace VerbRule(Drink)
  ('drink' //| 'quaff' | 'imbibe'
    | 'drink' 'from') dobjList
  : DrinkAction
  verbPhrase = 'drink/drinking (what)'
;

modify Thing
  canBeEaten = nil
;

modify Food
  canBeEaten = true
;

modify Container
  // For this kludgey treatment, assume that containers
  // never contain liquid. (Also assume that containers are
  // never themselves drinkable.)
  dobjFor(Drink) {
    verify {
      illogicalNow('There\'s nothing to drink in {the dobj/him}. ');
    }
  }
  dobjFor(Eat) {
    // I allow for containers that contain food. For what it's worth,
    // however, I do assume that there is no such thing as an edible 
    // container.
    verify {
      if (!contentsThatCanBeEaten)
        illogical('There\'s nothing to eat in {the dobj/him}.  ');
    }
    action {
      replaceAction(Eat, contentsThatCanBeEaten);
    }
  }
  contentsThatCanBeEaten {
    local cont;
    cont = contents;
    cont = cont.subset({x: x.canBeEaten});
    if (cont.length() >= 1) return cont;
    else return nil;
  }
;

modify NonPortable
  // If there are, e.g., any containers that can't be picked up, then
  // don't require people to pick them up in order to eat/drink from them.
  dobjFor(Drink) {
    preCond = [touchObj]
  }
  dobjFor(Eat) {
    preCond = [touchObj]
  }
;

// -------------------------------------------------------------------
// ACTIONS: LIQUID ACTIONS: Moisten, MoistenWith
// -------------------------------------------------------------------

DefineTAction(Moisten);
VerbRule(Moisten)
  ('moisten' | 'douse' | 'wet' | 'soak' | 'dampen') dobjList
    | 'get' dobjList 'wet'
  : MoistenAction
  verbPhrase = 'get/getting wet (what)'
;
modify Thing
  dobjFor(Moisten) {
    check() {
      reportFailure('{You/he} {sees} no reason to get {the dobj/him}
        wet. ');
      exit;
    }
    action() {
      askForIobj(MoistenWith);
    }
  }
;

DefineTIAction(MoistenWith)
  resolveFirst = IndirectObject
;
VerbRule(MoistenWith)
  ('moisten' | 'douse' | 'wet' | 'soak' | 'dampen') 
    dobjList
    ('with' | 'in' | 'into' | 'in' 'to') singleIobj
    | 'get' dobjList 'wet' 
    ('with' | 'in' | 'into' | 'in' 'to')  singleIobj
  : MoistenWithAction
  verbPhrase = 'get/getting wet (what) (with what)'
;
modify Thing
  dobjFor(MoistenWith) {
    //preCond = [objHeld]
    check() {
      // I know this is not the intended usage of illogicalNow,
      // but it serves to make sure that this verify result is
      // superceded by the usual verify result of the iobj.
      reportFailure('{You/he} {sees} no reason to get {the dobj/him}
        wet. ');
      exit;
    }
  }
  iobjFor(MoistenWith) {
    verify() {
      illogical('{You/he} {can\'t} use {the iobj/him}
        to get anything wet. ');
    }
  }
;


// -------------------------------------------------------------------
// ACTIONS: LIQUID ACTIONS: Mix
// -------------------------------------------------------------------

DefineIAction(Mix)
  actionTime = 0
;
VerbRule(Mix) ('mix' | 'stir') (miscWordList | ) 
  : MixAction
  execAction() {
    mainReport('You can play this game from start to finish,
      solve all the puzzles, find all the hidden secrets,
      and <i>still</i> never need to mix anything. ');
  }
;

// -------------------------------------------------------------------
// ACTIONS: LIQUID ACTIONS: Pour, PourInto, PourOnto
// -------------------------------------------------------------------

// The verb phrases have been altered because 'empty out' is a more widely
// applicable description of what is going on here. Containers without
// liquids can certainly be "emptied," but does that mean they can
// be "poured"? That's not the best default description.

replace VerbRule(Pour)
  ('pour' | 'spill' | 'empty' | 'dump' | 'drain' | 'clear')
    (singleDobj | 'out' singleDobj | singleDobj 'out') // no dobjList: that would be problematic
  : PourAction
  verbPhrase = 'empty/emptying out (what)'
;
replace VerbRule(PourInto)
  ('pour' | 'spill' | 'empty' | 'dump' | 'drain' | 'clear')
    (singleDobj | 'out' singleDobj | singleDobj 'out') // no dobjList: that would be problematic
    ('to' | 'in' | 'into' | 'in' 'to') singleIobj
  : PourIntoAction
  verbPhrase = 'empty/emptying out (what) (into what)'
  askIobjResponseProd = inSingleNoun
;
replace VerbRule(PourOnto)
  ('pour' | 'spill' | 'empty' | 'dump' | 'drain' | 'clear')
    (singleDobj | 'out' singleDobj | singleDobj 'out') // no dobjList: that would be problematic
    ('on' | 'onto' | 'on' 'to' | 'over') singleIobj
  : PourOntoAction
  verbPhrase = 'empty/emptying out (what) (onto what)'
  // The following line was changed, to prevent an apparent
  // bug in TADS 3.0.9.
  askIobjResponseProd = onSingleNoun
;

modify playerActionMessages
  cannotPourMsg = '{That dobj/he} {is} not something {you/he} can empty out. '
  cannotPourIntoMsg = '{You/he} can\'t empty out anything into {the iobj/him}. '
  cannotPourOntoMsg = '{You/he} can\'t empty out anything onto {the iobj/him}. '
;

modify Thing
  // Pouring/emptying something generally involves taking it.
  dobjFor(Pour) {
    preCond = [objHeld]
  }
  dobjFor(PourOnto) {
    preCond = [objHeld]
  }
  dobjFor(PourInto) {
    preCond = [objHeld]
  }
  iobjFor(PourOnto) {
    // Pouring/emptying stuff onto any given thing is logical.
    verify { }
  }
;

modify NonPortable
  // If something can't be taken, make an exception to the rule
  // that you should take something before pouring/emptying it.
  dobjFor(Pour) {
    preCond = [touchObj]
  }
  dobjFor(PourOnto) {
    preCond = [touchObj]
  }
  dobjFor(PourInto) {
    preCond = [touchObj]
  }
;

modify Floor
  iobjFor(PourOnto) {
    verify { }
  }
;

modify Surface
  iobjFor(PourOnto) {
    verify { }
  }
;

modify Container
  // dobj: Pour, PourInto, PourOnto
  dobjFor(Pour) {
    verify() {
      if (!hasNonFixtures)
        illogicalNow('There\'s nothing to empty out of {the dobj/him}. ');
    }
    check() { }
    action() {
      //"If this were an actual game, I\'d now be emptying the container. ";
      replaceAction(ProxyPour, nonFixtureContents);
    }
  }
  dobjFor(PourInto) {
    verify() { verifyDobjPour; }
    check() { }
    action() {
      // The iobj may have to handle this. This may not be
      // reached.
      //"If this were an actual game, I\'d now be emptying the stuff in
      //  {the dobj/him} into {the iobj/him}. ";
      replaceAction(ProxyPourInto, nonFixtureContents, gIobj);
    }
  }
  dobjFor(PourOnto) {
    verify() {
      if (!hasNonFixtures)
        illogicalNow('There\'s nothing to empty out of {the dobj/him}. ');
      else if (gIobj && !gIobj.ofKind(Surface) 
                     && !gIobj.ofKind(Floor)
                     && !gIobj.ofKind(Container))
        illogical('It seems needlessly awkward to empty the contents 
          of {the dobj/him} out onto {the iobj/him}. ');
    }
    check() { }
    action() {
      //"If this were an actual game, I\'d now be emptying the stuff in
      //  {the dobj/him} onto {the iobj/him}. ";
      replaceAction(ProxyPourOnto, nonFixtureContents, gIobj);
    }
  }
  // iobj: PourInto, PourOnto
  iobjFor(PourInto) {
    verify { }
  }
  iobjFor(PourOnto) asIobjFor(PourInto)
  hasNonFixtures() {
    local cont;
    cont = contents;
    cont = cont.subset({x: !x.ofKind(Fixture)});
    if (cont.length() >= 1) return true;
    else return nil;
  }
  nonFixtureContents() {
    local cont;
    cont = contents;
    cont = cont.subset({x: !x.ofKind(Fixture)});
    if (cont.length() >= 1) return cont;
    else return nil;
  }
;

// -------------------------------------------------------------------
// ACTIONS: LIQUID ACTIONS: ProxyPour, ProxyPourInto, ProxyPourOnto
// -------------------------------------------------------------------

DefineTAction(ProxyPour);
VerbRule(ProxyPour)
  ' '
  : ProxyPourAction
  verbPhrase = 'empty/emptying (what)'
;
DefineTIAction(ProxyPourInto);
VerbRule(ProxyPourInto)
  ' '
  : ProxyPourIntoAction
  verbPhrase = 'empty/emptying (what) (into what)'
  askIobjResponseProd = inSingleNoun
;
DefineTIAction(ProxyPourOnto);
VerbRule(ProxyPourOnto)
  ' '
  : ProxyPourOntoAction
  verbPhrase = 'empty/emptying (what) (onto what)'
  askIobjResponseProd = onSingleNoun
;

modify Thing
  dobjFor(ProxyPour) {
    preCond = [touchObj]
    verify() { }
    check() {
      if (getDropDestination(self, nil) == location) {
        reportFailure('{The dobj/he} {is} already ' 
          + location.objInPrep + ' ' + location.theName + '. ');
        exit;
      }
    }
    action() {
      // If the thing is being dumped out in a floorless room,
      // act accordingly.
      // No attempt is made here (any more than in the standard
      // library) to deal with cases where it would be unmimetic
      // to assume that an object could fall to the next room
      // and be unchanged when it landed.
      if (gDobj.getDropDestination(self, nil).ofKind(Room) 
          && gDobj.getDropDestination(self, nil).ofKind(Floorless)) {
        gDobj.moveInto(getDropDestination(self, nil).bottomRoom);
        defaultReport('{The dobj/he} fall{s} out of sight down below. ');
      }
      // Otherwise, if there is a conventional drop destination,
      // dump the thing onto it.
      else {
        local thingWasInActor = (isIn(gActor));
        local thingWasHeldByActor = (gDobj.location==gActor);
        local thisFloor = location;
        gDobj.moveInto(getDropDestination(self, nil));
        if (location.ofKind(Room) && location.roomParts.length > 0) {
          for (local a = 1; a <= location.roomParts.length; a++) {
            if (location.roomParts[a].ofKind(Floor))
              thisFloor = location.roomParts[a];
          }
        }
        if (thingWasInActor)
          defaultReport(okayProxyPourMsg(thisFloor,
            thingWasHeldByActor));
        else
          defaultReport(okayProxyPourCarefullyMsg(thisFloor,
            thingWasHeldByActor));
      }
    }
  }
  okayProxyPourMsg(where, actorDirectlyHeld) {
    return '{You/he} dump{s} {the dobj/him} ' + where.objInPrep 
      + 'to ' + where.theName + '. ';
  }
  okayProxyPourCarefullyMsg(where, actorDirectlyHeld) {
    if (actorDirectlyHeld)
      return '{You/he} put {the dobj/him} ' 
        + where.objInPrep + 'to ' + where.theName + '. ';
    else
      return '{You/he} pick up {the dobj/him} and put it ' 
        + where.objInPrep + 'to ' + where.theName + '. ';
  }
  // Same as PutIn, but with different preconditions
  dobjFor(ProxyPourInto) {
    preCond = [touchObj]
    verify() { verifyDobjPutIn; }
    check() { checkDobjPutIn; }
    action() { actionDobjPutIn; }
  }
  // Same as PutOn, but with different preconditions
  dobjFor(ProxyPourOnto) {
    preCond = [touchObj]
    verify() { verifyDobjPutOn; }
    check() { checkDobjPutOn; }
    action() { actionDobjPutOn; }
  }
  // Note that Container.iobjFor(ProxyPourInto) is different
  // from this.
  iobjFor(ProxyPourInto) {
    preCond = [touchObj]
    verify() {
      illogical(&cannotEmptyIntoMsg);
    }
  }
  iobjFor(ProxyPourOnto) {
    preCond = [touchObj]
    verify() {
      illogical('It seems needlessly awkward to dump 
         {the dobj/him} onto {the iobj/him}. ');
    }
  }
;

modify Floor
  iobjFor(ProxyPourOnto) {
    verify() { }
    check() { }
    action() {
      local thingWasHeldByActor = (gDobj.location==gActor);
      gDobj.moveInto(gActor.getOutermostRoom);
      defaultReport(gDobj.okayProxyPourMsg(self,
        thingWasHeldByActor));
    }
  }
;

modify Surface
  iobjFor(ProxyPourOnto) {
    verify() { }
    check() { }
    action() {
      local thingWasHeldByActor = (gDobj.location==gActor);
      gDobj.moveInto(self);
      defaultReport(gDobj.okayProxyPourMsg(self,
        thingWasHeldByActor));
    }
  }
  // We make it so surfaces are "picked up and put into" places,
  // rather than being "dumped" there, for the sake of mimesis.
  // A tray containing a bowl of chocolate mousse can hardly be
  // expected to remain in the same state if it is "dumped"
  // somewhere.
  okayProxyPourMsg(where, actorDirectlyHeld) {
    return okayProxyPourCarefullyMsg(where, actorDirectlyHeld);
  }
;

modify Container
  // iobj: ProxyEmptyInto, ProxyEmptyOnto
  iobjFor(ProxyPourInto) {
    verify() { }
    check() { }
    action() {
      local thingWasHeldByActor = (gDobj.location==gActor);
      //local k=0;k=k/k;
      gDobj.moveInto(self);
      defaultReport(gDobj.okayProxyPourMsg(self,
        thingWasHeldByActor));
    }
  }
  iobjFor(ProxyPourOnto) asIobjFor(ProxyPourInto)
  // We make it so containers are "picked up and put into" places,
  // rather than being "dumped" there, for the sake of mimesis.
  // A basin containing a glass of water can hardly 
  // be expected to remain in the same state if it is "dumped"
  // somewhere.
  okayProxyPourMsg(where, actorDirectlyHeld) {
    return okayProxyPourCarefullyMsg(where, actorDirectlyHeld);
  }
;

// -------------------------------------------------------------------
// ACTIONS: LIQUID ACTIONS: Fill, FillWith
// -------------------------------------------------------------------

DefineTAction(Fill);
VerbRule(Fill)
  'fill' singleDobj
  : FillAction
  verbPhrase = 'fill/filling (what)'
;
DefineTIAction(FillWith)
  resolveFirst = DirectObject
;
VerbRule(FillWith)
  'fill' singleDobj ('with' | 'from') singleIobj //no iobjList; that would be problematic
  : FillWithAction
  verbPhrase = 'fill/filling (what) (with what)'
;

modify Thing
  dobjFor(Fill) {
    verify() { 
      illogical('{You/he} {can\'t} fill {that dobj/him}. ');
    }
    action() {
      askForIobj(FillWith);
    }
  }
  dobjFor(FillWith) {
    verify() { 
      illogical('{You/he} {can\'t} fill {that dobj/him}. ');
    }
  }
  iobjFor(FillWith) {
    verify() { }
    //preCond = [objHeld]
    action() {
      replaceAction(ProxyPourInto, gIobj, gDobj);
      //replaceAction(PutIn, gIobj, gDobj);
    }
  }
;

// Should "fill flowing" make sense to the parser?
// "Fill surface"? "Fill floor"?
// I guess not; give no special response to these. 

modify Container
  dobjFor(Fill) {
    verify() { }
  }
  dobjFor(FillWith) {
    verify() { }
  }
  iobjFor(FillWith) {
    action() {
      if (!hasNonFixtures)
        replaceAction(ProxyPourInto, gIobj, gDobj);
      else
        replaceAction(PourInto, gIobj, gDobj);
    }
  }
;


// -------------------------------------------------------------------
// ACTIONS: SHOOTING ACTIONS: 
// Shoot, ShootAimlessly, ShootWith, ShootWithWhat, Fire
// -------------------------------------------------------------------

// The verbs in this section are based on a collaborative exchange
// between me and M.D. Dollahite. They date back to a time at a time
// when I was far from fluent in TADS 3, so most of the work
// here is M.D.'s, but I modified it to suit my needs. Big thanks
// to M.D. Dollahite for doing this, since it was what first made
// me really understand such things as logicalRank.

DefineTAction(Shoot);
DefineTAction(ShootAimlessly);
DefineTIAction(ShootWith);

VerbRule(ShootWith)
  ('shoot' | 'shoot' 'at' | 'fire' 'at') singleDobj 'with' singleIobj
  | ('shoot' | 'fire') singleIobj 'at' singleDobj
  : ShootWithAction
  verbPhrase = 'shoot/shooting (what) (with what)'
;

// If the player types "shoot at <something>" without specifying a 
// weapon, this grammar will pick up the command and map it to a 
// ShootWithAction with a missing iobj. The parser will attempt to
// locate a suitable iobj based on verify() results, failing that
// it will ask the player for one.
VerbRule(ShootWithWhat)
  ('shoot' 'at' | 'fire' 'at') singleDobj
  : ShootWithAction
  verbPhrase = 'shoot/shooting (what) (with what)'
  construct() {
    // This tells the parser that there was no grammar match for the
    // iobj
    iobjMatch = new EmptyNounPhraseProd();
    iobjMatch.responseProd = toSingleNoun;
  }
;

// This handles all ambiguous shoot actions. The Thing handler will 
// remap to a ShootWith action with a missing iobj, the Gun
// handler will treat it as "shoot at nothing in particular". One
// interpretation or the other can be favored by messing with the
// logicalRank() results.
VerbRule(Shoot)
  'shoot' singleDobj
  : ShootAction
  verbPhrase = 'shoot/shooting (what)'
;

// "fire <something>" clearly means the weapon, se we'll handle it
// specially
VerbRule(Fire)
  ('fire' | 'fire' 'with' | 'shoot' 'with') singleDobj
  : ShootAimlesslyAction
  verbPhrase = 'shoot/shooting (what)'
;

// The below shouldn't be necessary; the above grammar should handle
// it. You only need to do that fancy stuff like ShootWithWhat when
// you want to leave out a word that would normally be part of the
// verb grammar. Since all we leave out here is the noun phrase, the
// parser can deal with it on its own.

//VerbRule(ShootWhat)
//  'shoot' | 'fire'
//  : ShootAction
//  verbPhrase = 'shoot/shooting (what)'
//  construct() {
//    dobjMatch = new EmptyNounPhraseProd();
//    dobjMatch.responseProd = toSingleNoun;
//  }
//;

modify Thing
  // Since we're not a valid weapon, we'll assume we're the target
  // for a single-object shoot command.
  dobjFor(Shoot) {
    preCond = [objVisible]
    // If you want to favor a "shoot target" over "shoot weapon"
    // interpretation of a bare "shoot" command, add a
    // logicalRank(150, 'target') result here.
    //
    // If it's obviously risky to go around shooting at things,
    // add a dangerous result here.
    verify() { }
    action() { askForIobj(ShootWith); }
  }
  // We're not a weapon, so we can't handle fire commands
  dobjFor(ShootAimlessly)
  {
    preCond = [objHeld]
    verify() { illogical(&cannotShootWithMsg, self); }
  }
  letsActorShootHimself = nil
  shootingOneselfWithThisIsDeadly = nil
  canShootAtItself = nil
  // The primary handling for shooting at a target
  dobjFor(ShootWith) {
    preCond = [objVisible]
    verify() {
      // illogical to shoot at something that's inside the
      // designated shooting instrument.
      if(gIobj != nil && isIn(gIobj)) {
        illogical(&cannotShootComponentMsg);
        return;
      }
      // Lots of so-called "dangerous" conditions that I'm going to
      // rule illogical, because I want them to pre-empt any
      // preconditions. I don't want to see "(first taking the
      // rifle) You're not about to shoot yourself."
      if ((self == gActor || isComponentOf(gActor)) 
          && gIobj && !gIobj.letsActorShootHimself) {
        illogicalNow(&actorCannotShootHimself);
      }
      else if (isWornBy(gActor)) {
        illogicalNow(&willNotShootWornMsg);
      }
      else if (isIn(gActor)) {
        illogicalNow(&willNotShootCarriedMsg);
        return;
      }
    }
    check() { }
    // The default message for attacking something. This is a
    // default report so that afterAction() and beforeAction()
    // reactions can have something more interesting happen without
    // changing the target's handling. The target may either define
    // the message property or override this method to change the 
    // report.
    action() { }
  }
  // I was going to make it so that "HIT CAT" while you're holding a
  // gun automatically defaults to "HIT CAT WITH GUN". But I'm holding
  // off on this, not sure if I really want to.
  //dobjFor(Hit) {
  //  preCond = [touchObj]
  //  verify() { }
  //  action() {
  //    mainReport(&uselessToAttackMsg);
  //  }
  //}
  //dobjFor(Attack) {
  //  preCond = [touchObj]
  //  verify() { }
  //  action() {
  //    mainReport(&uselessToAttackMsg);
  //  }
  //}
  iobjFor(ShootWith) {
    preCond = [objHeld]
    verify() { illogical(&cannotShootWithMsg, self); }
  }
;

modify Distant
  // distant objects are logical as targets
  dobjFor(Shoot)     { verify() { inherited(); } }
  dobjFor(ShootWith) { verify() { inherited(); } }
  okayShootTargetMsg = &okayShootDistantTargetMsg
;

// It's good practice to implement action results as message object
// properties even if you're not worried about anyone translating
// your code, because that way objects can change them simply by
// defining their own versions, instead of having to override the
// whole action handler.
modify playerActionMessages
  //uselessToHitMsg = '{You/he} cannot hit {that dobj/him}. '
  uselessToHitMsg = 'Hitting {that dobj/him} would serve no purpose. '
  notAHittingInstrumentMsg =
    '{You/he} can<./s>t hit anything with {the iobj/him}. '

  okayShootTargetMsg =
    '{You/he} shoot{s} {the dobj/him} with {the iobj/him}, but it
      has no effect. '
  // Distant says 'shoot at'. A subtle change, but it implies
  // nothing about whether the target has been hit.
  okayShootDistantTargetMsg =
    '{You/he} shoot{s} at {the dobj/him} with {the iobj/him},
      but it has no effect. '
  gunCannotFireAtItself =
    '{You/he} cannot shoot {that dobj/him} with {itself/himself}. '
  okayShootMsg =
    '{You/he} fire{s} {the dobj/him} off aimlessly. '
  cannotShootWithMsg(weapon) {
    gMessageParams(weapon);
    return '{You/he} cannot shoot anything with {that weapon/him}. ';
  }
  cannotShootComponentMsg =
    'You can<./s>t shoot {the iobj/him} at its own components. '
  willNotShootCarriedMsg =
    'It would be dangerous to shoot at {that dobj/him} while
      {you/he} {is} carrying it. '
  actorCannotShootHimself =
    '{You/he} {is}n<./s>t about to shoot {yourself}. '
  willNotShootWornMsg =
    'It would be dangerous to shoot at {that dobj/him}
      while {you/he} {is} wearing it. '
;


// -------------------------------------------------------------------
// ACTIONS: WhoIs
// -------------------------------------------------------------------

// Note to self: This "WHO IS X" command is especially helpful 
// for answering the question "WHO AM I?" during the time when you
// can't remember your identity, but can also be used later for 
// other characters you've met.

VerbRule(WhoIs)
  'who' ('is' | 'am' | 'are' | 'was' | 'were') singleLiteral ( | '?')
  : WhoIsAction
  verbPhrase = 'figure/figuring out who (what) is'
;

DefineLiteralAction(WhoIs)
  alienException {
    if (me.hasSeen(cell)
        || me.hasSeen(dreamRoom) 
        || me.hasSeen(supermazeJ1))
      return true;
    else
      return nil;
  }
  humanException {
    if (me.hasSeen(dreamRoom) 
        || me.hasSeen(supermazeJ1))
      return true;
    else
      return nil;
  }
  // I could make this a meta-verb with actionTime = 0,
  // but that's not how Stephen Granade did it in Arrival, and I 
  // might decide to go with his precedent.
  //actionTime = 0
  execAction() {
    local who;
    who = guessWho(getLiteral);
    
    switch (who) {
      case neton:
        if (!who.hasEnteredConfRoom && !alienException)
          "{You/he} {does}n<./s>t know who that might be. ";
        else if (!who.hasBeenIdentified && !alienException)
          "He<./s>s the alien in the green jacket,
            sitting right across from you. ";
        else
          "Neton <<who.isDead ? 'was' : 'is'>> 
            the director of the Institute of 
            Humanities at the Center for Earthological Studies, 
            Australian Campus. ";
        break;
      case ovan:
        if (!who.hasEnteredConfRoom && !alienException)
          "{You/he} {does}n<./s>t know who that might be. ";
        else if (!who.hasBeenIdentified && !alienException)
          "He<./s>s the alien in the yellow jacket,
            sitting right across from you. ";
        else
          "Ovan <<who.isDead ? 'was' : 'is'>> an assistant professor of 
            interactive fiction at the Center for Earthological Studies, 
            Australian Campus. ";
        break;
      case oldGuard:
      case youngGuard:
        if (!me.hasSeen(confRoom) && !alienException)
          "{You/he} {does}n<./s>t know who that might be. ";
        else if (!neton.hasBeenIdentified && !alienException)
          "He<./s>s one of the guards standing
            in front of you. ";
        else
          "<<who.isDead ? 'He was' : 'He<./s>s'>> a guard 
            at the Center for Earthological Studies, Australian Campus. ";
        break;
      case assistant:
        if (!me.hasSeen(confRoom) && !alienException)
          "{You/he} {does}n<./s>t know who that might be. ";
        else if (!neton.hasBeenIdentified && !alienException)
          "He<./s>s the assistant who led you here. ";
        else
          "<<who.isDead ? 'He was' : 'He<./s>s'>> an assistant 
            at the Center for Earthological Studies, Australian Campus. ";
        break;
      case vicki:
        if (!me.hasSeen(who) && !humanException)
          "{You/he} {does}n<./s>t know who that might be. ";
        else if (!who.hasExplainedProfession)
          "Vicki is one of your fellow prisoners. ";
        else
          "Vicki is one of your fellow prisoners.
            She used to be a history professor at 
            <<vicki.formerUniversity>>. ";
        break;
      case diane:
        if (!me.hasSeen(who) && !humanException)
          "{You/he} {does}n<./s>t know who that might be. ";
        else if (!who.hasExplainedProfession)
          "Diane is one of your fellow prisoners. ";
        else
          "Diane is one of your fellow prisoners.
            She is also a former air traffic controller from 
            Phoenix, Arizona. ";
        break;
      case me:
        if (me.isIn(coffin))
          "That<./s>s a good question. You don<./s>t know
            the answer. ";
        else
          "Your name is <<me.fullName>>. Once you were a software engineer
            from Minneapolis. Now you are <<
              me.knowsMazeGameTitle ? 'a prisoner' : 'a guest'
            >> <<neton.hasBeenIdentified 
              ? 'at the Center for Earthological Studies, Australian Campus' 
              : 'at some alien facility'>>. ";
          //"You are <<me.fullName>>, a former software engineer<<
          //    me.hasExplainedOrigin 
          //    ? ', originally from St. Cloud, Minnesota' : ''
          //  >>. You are also <<
          //    me.knowsMazeGameTitle ? 'a prisoner' : 'a guest'
          //  >> <<neton.hasBeenIdentified 
          //    ? 'at the Center for Earthological Studies, Australian Campus' 
          //    : 'at an alien facility'>>. ";
        break;
      default:
        "You don<./s>t know who that might be. ";
        break;
    }
  }
  guessWho(lit) {
    //local str = '';
    local val = 0;
    //local id = nil;
    local doAgain;
    local count1;
    local count2;
    
    for (;;) {
      doAgain = nil;
      
      val = lit.find(' the ');
      if (val) {
        lit = lit.substr(1, val - 1) + ' ' + lit.substr(val + 5);
        doAgain = true;
      }
      val = lit.find(' an ');
      if (val) {
        lit = lit.substr(1, val - 1) + ' ' + lit.substr(val + 4);
        doAgain = true;
      }
      val = lit.find(' a ');
      if (val) {
        lit = lit.substr(1, val - 1) + ' ' + lit.substr(val + 3);
        doAgain = true;
      }
      
      if (!doAgain) break;
    }
    if (lit.substr(1,4) == 'the ') lit = lit.substr(5);
    if (lit.substr(1,3) == 'an ')  lit = lit.substr(4);
    if (lit.substr(1,2) == 'a ')   lit = lit.substr(3);
    if (lit.substr(lit.length-3) == ' the') lit = lit.substr(1, lit.length-4);
    if (lit.substr(lit.length-2) == ' an')  lit = lit.substr(1, lit.length-3);
    if (lit.substr(lit.length-1) == ' a')   lit = lit.substr(1, lit.length-2);
    
    //"<tt>The string is: [<<lit>>]</tt> ";
    
    // SPECIFIC STRING-MATCHING
    
    switch (lit) {
      case 'i':
      case 'me':
      case 'you':
        return me;
      case 'neton':
      case 'green':
      case 'n':
        return neton;
      case 'ovan':
      case 'yellow':
      case 'o':
        return ovan;
      case 'assistant':
      case 'asst':
      case 'beige':
      case 'tan':
        return assistant;
      case 'young':
      case 'younger':
      case 'muscular':
      case 'youthful':
      case 'youth':
        return youngGuard;
      case 'old':
      case 'older':
      case 'elder':
      case 'elderly':
        return oldGuard;
      case 'vicki':
      case 'murakami':
      case 'vicki murakami':
      case 'v':
      case 'oriental':
      case 'asian':
      case 'black-haired':
      case 'gray-haired':
      case 'grey-haired':
        return vicki;
      case 'diane':
      case 'gadke':
      case 'diane gadke':
      case 'd':
      case 'blonde':
      case 'blond':
      case 'blonde-haired':
      case 'blond-haired':
        return diane;
    }
    
    // ME
    
    if (lit == me.firstName.toLower) return me;
    if (lit == me.lastName.toLower) return me;
    if (lit == me.fullName.toLower) return me;
    
    // NETON, OVAN, ASSISTANT
    
    if (lastSubstr(lit, 'in green'        )) return neton;
    if (lastSubstr(lit, 'in green jacket' )) return neton;
    if (lastSubstr(lit, 'in yellow'       )) return ovan;
    if (lastSubstr(lit, 'in yellow jacket')) return ovan;
    if (lastSubstr(lit, 'in beige'        )) return assistant;
    if (lastSubstr(lit, 'in beige jacket' )) return assistant;
    if (lastSubstr(lit, 'in tan'          )) return assistant;
    if (lastSubstr(lit, 'in tan jacket'   )) return assistant;
    if (firstSubstr(lit, 'green'        )) return neton;
    if (firstSubstr(lit, 'yellow'       )) return ovan;
    if (firstSubstr(lit, 'beige'        )) return assistant;
    if (firstSubstr(lit, 'tan '         )) return assistant;
    
    // YOUNG GUARD, OLD GUARD
    
    count1 = 0;
    count2 = 0;
    if (lit.find('guard')) {
      if (lit.find('young'             )) count1++;
      if (lit.find('younger'           )) count1++;
      if (lit.find('muscular'          )) count1++;
      if (lit.find('youthful'          )) count1++;
      if (lit.find('youth'             )) count1++;
      if (lit.find(' old'              )) count2++;
      if (lit.find(' older'            )) count2++;
      if (lit.find(' elder'            )) count2++;
      if (lit.find('old '              )) count2++;
      if (lit.find('older '            )) count2++;
      if (lit.find('elder '            )) count2++;
      if (lit.find('elderly'           )) count2++;
      
      if (count1 && !count2) return youngGuard;
      if (!count1 && count2) return oldGuard;
    }
    
    count1 = 0;
    count2 = 0;
    if (true) {
      if (lit.find('vicki'        )) count1++;
      if (lit.find('murakami'     )) count1++;
      if (lit.find('oriental'     )) count1++;
      if (lit.find('asian'        )) count1++;
      if (lit.find('black-haired' )) count1++;
      if (lit.find('gray-haired'  )) count1++;
      if (lit.find('grey-haired'  )) count1++;
      if (lit.find('diane'        )) count2++;
      if (lit.find('diana'        )) count2++;
      if (lit.find('gadke'        )) count2++;
      if (lit.find('blonde'       )) count2++;
      if (lit.find('blond'        )) count2++;
      if (lit.find('blonde-haired')) count2++;
      if (lit.find('blond-haired' )) count2++;
      
      if (count1 && !count2) return vicki;
      if (!count1 && count2) return diane;
    }
    
    return nil;
  }
  lastSubstr(bigStr, littleStr) {
    if (bigStr.substr(bigStr.length - littleStr.length + 1) == littleStr)
      return true;
    else
      return nil;
  }
  firstSubstr(bigStr, littleStr) {
    if (bigStr.substr(1, littleStr.length) == littleStr)
      return true;
    else
      return nil;
  }
;

// -------------------------------------------------------------------
// ACTIONS: WhatIs
// -------------------------------------------------------------------

// I was going to allow the player to type "WHAT IS X," but it got too 
// involved, with too many special cases where I found it hard to avoid
// awkward and spoiler-filled answers. E.g., "WHAT IS RED?" might yield
// "Which do you mean, the red folder, or the red bicycle?" where 
// neither the folder nor the bicycle are visible until the endgame.

//DefineTAction(WhatIs)
//  // We want all objects to be in scope, so we always return true
//  // here.
//  objInScope(obj) { return true; }
//  execAction() {
//    if (!gActor.isPlayerChar) {
//      libMessages.systemActionToNPC();
//      exit;
//    }
//    inherited;
//  }
//  actionTime = 0 // Make this a meta-verb, such that it does not
//                 // cause time to transpire.
//;
//
//VerbRule(WhatIs)
//  ('what' | 'who') ('is' | 'are' | 'am') singleDobj
//  : WhatIsAction
//  verbPhrase = 'snarf/snarfing (what)'
//;
//
//modify Thing {
//  whatDesc = "It<./s>s not really important for you to know what that is. "
//  dobjFor(WhatIs) {
//    preCond = []
//    verify() { }
//    //remap() { return remapDobjTake(); }
//    check() { }
//    action() {
//      whatDesc;
//      exit;
//    }
//  }
//}
//
//modify Actor {
//  whatDesc = "It<./s>s not really important for you to know who that is. "
//}

// -------------------------------------------------------------------
// ACTIONS: Glist
// -------------------------------------------------------------------

//#ifdef __DEBUG

DefineTAction(GList)
  actionAllowsAll = true
;

VerbRule(GList)
  'glist' dobjList
  : GListAction
  verbPhrase = 'glist/glisting (what)'
;

modify Thing
  dobjFor(GList) {
    verify { }
    check { }
    action {
      "{the dobj/he} (<<gDobj.theNameOwnerLoc(nil)>>) ";
    }
  }
;

//#endif // __DEBUG


// -------------------------------------------------------------------
// ACTIONS: Xyzzy, Plugh, Plover
// -------------------------------------------------------------------

DefineIAction(Xyzzy)
  execAction() {
    if (gPlayerChar != bot) {
      xyzzyList.doScript;
    }
    else {
      "Nothing happens here. ";
    }
    //mainReport(xyzzyList.doScript);
  }
  actionTime = 0
;
VerbRule(Xyzzy)
  'xyzzy' | 'say' 'xyzzy'
  : XyzzyAction
  verbPhrase = 'say/saying <.q>xyzzy<./q>'
;
xyzzyList: CyclicEventList
  [
    '<.q>Xyzzy<./q>? You zealous Zorkian, you. ',
    '<.q>Xyzzy<./q> yields zip, zero, y<./s>all. '
  ]
;

DefineIAction(Plugh)
  execAction() {
    if (gPlayerChar != bot) {
      plughList.doScript;
    }
    else {
      "Nothing happens here. ";
    }
    //mainReport(plughList.doScript);
  }
  actionTime = 0
;
VerbRule(Plugh)
  'plugh' | 'say' 'plugh'
  : PlughAction
  verbPhrase = 'say/saying <.q>plugh<./q>'
;
plughList: CyclicEventList
  [
    'Please let up, game hound! ',
    'Please, let<./s>s utter good, hey?\b
      (Pardon? Last utterance got hypocritical?) '
  ]
;

DefineIAction(Plover)
  execAction() {
    if (gPlayerChar != bot) {
      ploverList.doScript;
    }
    else {
      "Nothing happens here. ";
    }
    //mainReport(ploverList.doScript);
  }
  actionTime = 0
;
VerbRule(Plover)
  'plover' | 'say' 'plover'
  : PloverAction
  verbPhrase = 'say/saying <.q>plover<./q>'
;
ploverList: StopEventList
  [
    'Okay, look. Last I checked, David Welbourn didn<./s>t have a web page devoted to 
      <.q>plover<./q> responses. I<./s>m not doing this for free, you
      know.',
    //formerly 'typing some clich&eacute;d old word.'
    'Seriously. I don<./s>t have to be at your beck and call just
      because you feel like typing some old word. ',
    'Okay, okay. <.q>' + plov.msg1 + '<./q>\b
      There. Happy now? ',
    'Oh wait, I just thought of another one. <.q>' + plov.msg2
      + '<./q> ',
    ploverList2
  ]
;
ploverList2: CyclicEventList
  [
    plov.msg1 + ' ',
    plov.msg2 + ' '
  ]
;
plov: object // Note that these messages don't end in a space.
  msg1 = 'Please leave off voicing extravagant remarks!'
  //alternatives: efficacious/explicit/earnest
  msg2 = 'Please, let<./s>s only voice explicit requests!'
;

// -------------------------------------------------------------------
// ACTIONS: MusicOn, MusicOff
// -------------------------------------------------------------------

modify glob
  musicOn = true
;

DefineIAction(MusicOn)
  execAction() {
    "Music and sound effects are now turned on. ";
    glob.musicOn = true;
  }
  actionTime = 0
;
VerbRule(MusicOn)
  ('music' | 'sound') 'on'
  : MusicOnAction
  verbPhrase = 'turn/turning the music on'
;

DefineIAction(MusicOff)
  execAction() {
    "Music and sound effects are now turned off. ";
    glob.musicOn = nil;
  }
  actionTime = 0
;
VerbRule(MusicOff)
  ('music' | 'sound') 'off'
  : MusicOffAction
  verbPhrase = 'turn/turning the music off'
;

DefineIAction(Music)
  execAction() {
    "Music and sound are currently <<glob.musicOn ? 'ON' : 'OFF'>>. ";
    "<.p>You can type MUSIC ON or MUSIC OFF to adjust this setting. ";
  }
  actionTime = 0
;
VerbRule(Music)
  ('music' | 'sound') ()
  : MusicOffAction
  verbPhrase = 'turn/turning the music off'
;

// -------------------------------------------------------------------
// ACTIONS: Images / ImagesLarge / ImagesSmall
// -------------------------------------------------------------------

DefineSystemAction(Images)
  execAction() {
    "Images are currently set to <<glob.imageSize == 1 ? 'SMALL' : 'LARGE'>>. ";
    "<.p>SMALL images are suitable for a resolution of 800x600, while LARGE images are 
      suitable for pretty much any resolution larger than that.";
    "<.p>You can type IMAGES SMALL or IMAGES LARGE to adjust this setting. ";
  }
;

VerbRule(Images)
  ('images' | 'image') ('status' |)
  : ImagesAction
  verbPhrase = 'display/displaying the image size'
;

DefineSystemAction(ImagesLarge)
  execAction() {
    "Okay, images are now set to large. ";
    glob.imageSize = 2;
    nbmBanner.updateMe();
  }
;

VerbRule(ImagesLarge)
  ('images' | 'image') ('large' | 'larger' | 'big' | 'bigger')
  : ImagesLargeAction
  verbPhrase = 'set/setting the image size to large'
;

DefineSystemAction(ImagesSmall)
  execAction() {
    "Okay, images are now set to small. ";
    glob.imageSize = 1;
    nbmBanner.updateMe();
  }
;

VerbRule(ImagesSmall)
  ('images' | 'image') ('small' | 'smaller' | 'little' | 'littler')
  : ImagesSmallAction
  verbPhrase = 'set/setting the image size to small'
;

// -------------------------------------------------------------------
// ACTIONS: Score
// -------------------------------------------------------------------

// No score verb. Yay. However, I'll have to change this for the non-IntroComp version

//modify libScore
//  execute { }
//;

//replace VerbRule(Score)
//    ' '
//    : ScoreAction
//    verbPhrase = 'show/showing score'
//;

replace VerbRule(FullScore)
    ' '
    : FullScoreAction
    verbPhrase = 'show/showing full score'
;

replace VerbRule(Notify)
    ' '
    : NotifyAction
    verbPhrase = 'show/showing notification status'
;

replace VerbRule(NotifyOn)
    ' '
    : NotifyOnAction
    verbPhrase = 'turn/turning on score notification'
;

replace VerbRule(NotifyOff)
    ' '
    : NotifyOffAction
    verbPhrase = 'turn/turning off score notification'
;

modify ScoreAction
  execSystemAction() {
    if (gPlayerChar == bot && libScore != nil) {
      libScore.showScore();
      "This gives you the rank of <<glob.scoreRank>>. ";
    }
    else if (!glob.isInEndgame) {
      "There is no score in this part of the game. ";
      //playerMessages.askUnknownWord(gActor, 'score');
    }
    else {
      "There is no score in this part of the game, 
        although if interested you may feel free to type 
        ACHIEVEMENTS. ";
    }
  }
;

modify glob
  scoreRank {
      if      (libScore.totalScore <=   0) "human";
      else if (libScore.totalScore <= 100) "student";
      else if (libScore.totalScore <= 200) "graduate student";
      else if (libScore.totalScore <= 300) "assistant professor";
      else if (libScore.totalScore <= 400) "associate professor";
      else if (libScore.totalScore <= 500) "professor in good standing";
      else if (libScore.totalScore <= 600) "department director";
      else if (libScore.totalScore <= 700) "dean of faculty";
      else if (libScore.totalScore <= 800) "arch-dean of faculty, holdings, and information";
      else if (libScore.totalScore <= 900) "college vice-president";
      else if (libScore.totalScore <= 999) "college president";
      else                                 "college president summa cum laude";
      //else if (libScore.totalScore <=1000) "college president summa cum laude";
      //else if (libScore.totalScore <=1000) "college president <i>summa cum laude.</i> ";
      
      //if      (libScore.totalScore <=   0) "a human. ";
      //else if (libScore.totalScore <= 100) "a lowly CESAC undergraduate. ";
      //else if (libScore.totalScore <= 200) "a graduate student at CESAC. ";
      //else if (libScore.totalScore <= 300) "a first-year assistant professor of earthological studies. ";
      //else if (libScore.totalScore <= 400) "an associate professor of earthological studies. ";
      //else if (libScore.totalScore <= 500) "a tenured professor of earthological studies. ";
      //else if (libScore.totalScore <= 600) "the director of the humanities department at CESAC. ";
      //else if (libScore.totalScore <= 700) "the dean of faculty at CESAC. ";
      //else if (libScore.totalScore <= 800) "the arch-dean of faculty, holdings, and information at CESAC. ";
      //else if (libScore.totalScore <= 900) "the vice-president of CESAC. ";
      //else if (libScore.totalScore <=1000) "the president of CESAC. ";
  }
;

// -------------------------------------------------------------------
// ACTIONS: Turns (for debugging only)
// -------------------------------------------------------------------

#ifdef __DEBUG

DefineSystemAction(Turns)
  execAction() {
    "Turns: <<libGlobal.totalTurns>> ";
  }
;

VerbRule(Turns)
  'turns' | 'moves'
  : TurnsAction
  verbPhrase = 'show/showing the number of turns'
;

#endif // __DEBUG

// -------------------------------------------------------------------
// ACTIONS: Note
// -------------------------------------------------------------------

// GWB, June 2010:
// The following modifications were successfully designed to get 
// the NOTE command to behave in TADS 3.0.8 as in 3.0.16+. 
// This was accomplished by adding Mike Roberts' commentPreParser
// (now modified here rather than added).
// 
// As of this writing I'm not sure why I modified StringPreParser, 
// specialTopicPreParser, and commentPreParser to give them the
// preserveMe property. Maybe I'll look into this later. But for now,
// my plan is to keep this as is, then test out NOTEs and special 
// topics. If testing shows that it ain't broke, then don't fix it.


// Modify this to get rid of the TADS 3.0.8 "NOTE" StringPreParser
// and add the TADS 3.0.16 one. This is a challenge because of
// the fact that the TADS 3.0.8 "NOTE" StringPreParser does not
// have an identifier. But I'm determined. I can do it anyway. 

modify StringPreParser
  registerPreParser(pp) {
    if (pp.preserveMe && regList.indexOf(pp) == nil) {
      regList.append(pp);
      regListSorted = nil;
    }
    else if (!pp.preserveMe) {
      while (regList.indexOf(pp) != nil) {
        regList = regList.removeElementAt(regList.indexOf(pp));
      }
    }
  }
  preserveMe = nil
;

modify specialTopicPreParser
  preserveMe = true
;

// Here is the TADS 3.0.16 "NOTE" StringPreParser, thanks to Mike Roberts.
// I no longer need to include a hack copy of it, but I do need to include a
// quick hack to modify it.

modify commentPreParser
  preserveMe = true
;

/*
// The "comment" pre-parser.  If the command line starts with a special
// prefix string (by default, "*", but this can be changed via our
// commentPrefix property), this pre-parser intercepts the command,
// treating it as a comment from the player and otherwise ignoring the
// entire input line.  The main purpose is to give players a way to put
// comments into recorded transcripts, as notes to themselves when later
// reviewing the transcripts or as notes to the author when submitting
// play-testing feedback.  
commentPreParser: StringPreParser
  doParsing(str, which) {
    // get the amount of leading whitespace, so we can ignore it
    local sp = rexMatch(leadPat, str);
    // if the command line starts with the comment prefix, treat it
    // as a comment 
    if (str.substr(sp + 1, commentPrefix.length()) == commentPrefix) {
      // It's a comment.
      // 
      // If a transcript is being recorded, simply acknowledge the
      // comment; if not, acknowledge it, but with a warning that
      // the comment isn't being saved anywhere 
      if (scriptStatus.scriptFile != nil)
        libMessages.noteWithScript;
      else if (warningCount++ == 0)
        libMessages.noteWithoutScriptWarning;
      else
        libMessages.noteWithoutScript;
      // Otherwise completely ignore the command line.  To do this,
      // simply return nil: this tells the parser that the command
      // has been fully handled by the preparser. 
      return nil;
    }
    else {
      return str;
    }
  }
  // The comment prefix.  You can change this to any character, or to
  // any sequence of characters (longer sequences, such as '//', will
  // work fine).  If a command line starts with this exact string (or
  // starts with whitespace followed by this string), we'll consider
  // the line to be a comment.  
  commentPrefix = '*'
  // The leading-whitespace pattern.  We skip any text that matches
  // this pattern at the start of a command line before looking for the
  // comment prefix.
  // 
  // If you don't want to allow leading whitespace before the comment
  // prefix, you can simply change this to '' - a pattern consisting of
  // an empty string always matches zero characters, so it will prevent
  // us from skipping any leading charactres in the player's input.  
  leadPat = static new RexPattern('<space>*')
  // warning count for entering comments without SCRIPT in effect
  warningCount = 0
  // Use a lower execution order than the default, so that we run
  // before most other pre-parsers.  Most other pre-parsers are written
  // to handle actual commands, so it's usually just a waste of time to
  // have them look at comments at all - and can occasionally be
  // problematic, since the free-form text of a comment could confuse a
  // pre-parser that's expecting a more conventional command format.
  // When the comment pre-parser detects a comment, it halts any
  // further processing of the command - so by running ahead of other
  // pre-parsers, we'll effectively bypass other pre-parsers when we
  // detect a comment.  
  runOrder = 50
  // MY HACK: GWB, NOV. 15, 2008
  preserveMe = true
;
*/


// ---------------------------------------------------

// The following is my previous attempt, which was by no means entirely
// successful.

/*

modify VerbRule(Note)
  ('note' | '!') singleLiteral
  :
;

#ifndef TADS308
modify VerbRule(NoteOnly)
  ('note' | '!')
  :
;
#endif

StringPreParser
  doParsing(str, which) {
    // for non-literal inputs, turn NOTE FOO into NOTE "FOO"
    if (which != rmcAskLiteral
      && rexMatch(notePattern, str) != nil) {
      // Quote the rest of the command line.  If there are any
      // double quotes in the rest of the line, replace them with
      // single quotes, so they don't end the quoted text.  Note
      // that the NOTE command doesn't do anything with the
      // pattern anyway, so we could equally well just leave out
      // the rest of the text, but we'll include it anyway in case
      // the library adds a feature that does something with the
      // text in the future.
      return 'note "'
        + rexGroup(2)[3].findReplace('"', '\'', ReplaceAll, 1)
        + '"';
    }
    // nothing special; return the original string unchanged
    return str;
  }
  notePattern = static new RexPattern(
    '<nocase>(<space>*note(?=<^alphanum>)<space>*)'
    + '(.*(<^alpha|digit|space>|%<and%>).*)$')
;

StringPreParser
  doParsing(str, which) {
    if (which != rmcAskLiteral && rexMatch(notePattern, str) != nil) {
//      return '! "' + str.substr(2).findReplace('"', '\'', ReplaceAll, 1)
//             + '"';
      return '! ';
    }
    return str;
  }
  // BEGIN MY MODIFICATIONS
  //notePattern = static new RexPattern('^(<space>*<star|Punct>)');
  notePattern = static new RexPattern('^(<space>*<star>)');
  // END MY MODIFICATIONS
;

modify libMessages
  noteWithoutNote = "<.p><.notification>You can enter notes into the
    transcript by typing NOTE followed by any text you wish to enter
    as your note.  NOTE without any message text is fine, too, in
    case you simply want to call attention to something immediately
    preceding in the transcript. You can also use any punctuation
    mark or an asterisk (*) instead of NOTE to begin a 
    note.<./notification> "
  // warn about NOTE when logging isn't in effect
  noteWithoutScript = "<.p><.notification>Note that the transcript isn't
    currently being recorded.  NOTE is usually used to provide feedback
    to the author by putting a comment in the transcript, so it's most
    useful when you're saving the transcript to a file.  If you want
    to start saving the transcript, please type <<
      aHref('script', 'SCRIPT', 'Begin saving the transcript')
      >>.<./notification> "
;

#ifndef TADS308
// The following little thing is by me, not Eric Eve, so blame me.
modify NoteIAction
  doActionMain() {
    NoteAction.execAction();
    //if (NoteIAction.noteExplained++ == 0)
    //    libMessages.noteWithoutNote;
  }
;
#endif

*/

// -------------------------------------------------------------------
// ACTIONS: INNER GAME META-ACTIONS: Info
// -------------------------------------------------------------------

modify libMessages
  alienVerbNotUsedMsg =
    "<.parser>That command can<./s>t be used here.<./parser> "
;

VerbRule(Info)
  'info' | 'information'
  : InfoAction
  verbPhrase = 'get/getting info'
;

DefineSystemAction(Info)
  execSystemAction() {
    if (gPlayerChar != bot) {
      libMessages.alienVerbNotUsedMsg;
      return;
    }
    bcInstr.reply;
  }
  //includeInUndo = nil
  //isRepeatable = nil
;

// -------------------------------------------------------------------
// ACTIONS: INNER GAME META-ACTIONS: Escape
// -------------------------------------------------------------------

VerbRule(Escape)
  'escape'
  : EscapeAction
  verbPhrase = 'escape/escaping'
;

DefineSystemAction(Escape)
  execSystemAction() {
    if (gPlayerChar != bot) {
      libMessages.alienVerbNotUsedMsg;
      return;
    }
    if (gPlayerChar.getOutermostRoom.ofKind(BasicSupermazeRoom)) {
      "Sheila cocks her head and says, <.q>I can<./s>t escape from here. 
        If you really want to, you can type STOP to stop playing the game,
        although of course you<./s>ll lose all your progress 
        if you do that.<./q> ";
      return;
    }
    if (gPlayerChar.getOutermostRoom.ofKind(HacRoom)) {
      "Sheila cocks her head and says, <.q>Sorry, but I<./s>m
        not programmed to be able 
        to escape from this maze! Besides, I don<./s>t think it would
        do us much good anyway. As I understand,
        either we solve this maze, or we don<./s>t 
        win the game at all! Of course, you can always RESTORE a saved game,
        or even STOP playing the game, if you<./s>re prepared to lose
        any progress you<./s>ve made.<./q> ";
      return;
    }
    "Sheila cocks her head and says, <.q>Are you sure you want to 
      escape from here? You<./s>ll lose all the 
      progress that you<./s>ve made in ";
    if (bot.getOutermostRoom.ofKind(BookMovieMaze) &&
        bot.getOutermostRoom != starwarsMaze &&
        bot.getOutermostRoom != tolstoyMaze)
      "this set of mazes!<./q> ";
    else
      "this maze!<./q> ";
    //"<p>Type Y or N&gt;&gt;";
    // If the player says no, then...
    if (!sayYesOrNo()) {
      "<.q>No problem,<./q> says Sheila. <.q>Back to the game, then!<./q> ";
    }
    else {
      // The following two lines are RestartAction's idea, not mine.
      // I don't really understand them.
      //commandSequencer.setCommandMode();
      //"<.commandsep>";
      bot.getOutermostRoom.resetThisMazeSet;
      maybeNbmCls(EscapeAction);
      local origin = bot.location;
      bot.moveIntoForTravel(bot.getOutermostRoom.supermazeDestination);
      bot.location.travelerArriving(gPlayerChar, origin, nil, nil);
      //gPlayerChar.lookAround(true);
      nbmBanner.updateMe;
    }
  }
  //includeInUndo = nil
  //isRepeatable = nil
;

sayYesOrNo() {
  "<.p>Type Y or N &gt;&gt; ";
  return yesOrNo();
}

// -------------------------------------------------------------------
// ACTIONS: INNER GAME META-ACTIONS: Stop
// -------------------------------------------------------------------

VerbRule(Stop)
  'stop'
  : StopAction
  verbPhrase = 'stop/stopping'
;

DefineSystemAction(Stop)
  execSystemAction() {
    if (gPlayerChar != bot) {
      libMessages.alienVerbNotUsedMsg;
      return;
    }
    "Sheila cocks her head and says, <.q>Are you sure you 
      want to stop playing this game? You<./s>ll lose all the 
      progress you<./s>ve made!<./q> ";
    //"<p>Type Y or N&gt;&gt;";
    // If the player says no, then...
    if (!sayYesOrNo()) {
      "<.q>No problem,<./q> says Sheila. <.q>Back to the game, then!<./q> ";
    }
    else {
      reallyStop;
    }
  }
  reallyStop {
    local mthd;
    if (virtualMe.isIn(beachRoom))
      mthd = goToBeach;
    else
      mthd = goToEmptyRoom;
    
    // The following two lines are RestartAction's idea, not mine.
    // I don't really understand them.
    //commandSequencer.setCommandMode();
    //"<.commandsep>";
    
    // Move the bot:
    bot.getOutermostRoom.resetAllMazes;
    // Ignore this:
    //local origin = bot.location;
    bot.moveIntoForTravel(supermazeJ1);
    // Ignore this, as it would cause the bot's arrival to be described:
    //bot.location.travelerArriving(gPlayerChar, origin, nil, nil);
    
    // Change the PC. No need to change the PC's clothes or his location
    // or his posture.
    setPlayer(virtualMe);
    gActor = gPlayerChar;
    
    // During actual gameplay, virtualMe should be in beachRoom or emptyRoom
    // by this point. However, during debugging, his location could be nil.
    // If that is the case, move virtualMe into the beachRoom.
    if (virtualMe.location == nil) {
      virtualMe.moveIntoForTravel(beachChair);
      beachPda.moveInto(virtualMe);
      virtualMe.makePosture(sitting);
    }
    
    // Change the status line type and the font, and for what it's worth 
    // change glob.parser.
    glob.parser = alien;
    glob.status = trinity;
    glob.font = courier;
    
    // Change exit lister stuff, if needed.
    if (mthd.hasExitList && !gExitLister) {
      libGlobal.exitListerObj = exitLister;
      retrieveExitSettings();
    }
    if (!mthd.hasExitList && gExitLister) {
      libGlobal.exitListerObj = nil;
      storeExitSettings();
    }
    
    // Clear screen, change font, look around, update banner.
    maybeNbmCls(StopAction);
    if (!actionRequiresCls(StopAction))
      "<.p>";
    "<.nbmfont>";
    gPlayerChar.lookAround(true);
    nbmBanner.updateMe;
  }
  //includeInUndo = nil
  //isRepeatable = nil
;

// -------------------------------------------------------------------
// ACTIONS: INNER GAME META-ACTIONS: Reset
// -------------------------------------------------------------------

VerbRule(Reset)
  'reset'
  : ResetAction
  verbPhrase = 'reset/resetting'
;

DefineSystemAction(Reset)
  execSystemAction() {
    if (gPlayerChar != bot) {
      libMessages.alienVerbNotUsedMsg;
      return;
    }
    if (gPlayerChar.getOutermostRoom.ofKind(BasicSupermazeRoom)) {
      "Sheila cocks her head and says, <.q>Sorry, but 
        this is the one maze that can<./s>t be reset. 
        If I were allowed to reset this maze, it would be equivalent
        to beginning the game all over again! 
        If that is seriously what you intend to do, 
        please signal
        your intention by typing BEGIN instead.<./q> ";
      return;
    }
    "Sheila cocks her head and says, <.q>Are you sure you want to 
      reset this maze? You<./s>ll lose all the 
      progress you<./s>ve made in it so far!<./q> ";
    //"<p>Type Y or N&gt;&gt;";
    // If the player says no, then...
    if (!sayYesOrNo()) {
      "<.q>No problem,<./q> says Sheila. <.q>Back to the game, then!<./q> ";
    }
    else {
      reallyReset;
    }
  }
  reallyReset {
    // The following two lines are RestartAction's idea, not mine.
    // I don't really understand them.
    //commandSequencer.setCommandMode();
    //"<.commandsep>";
    
    // Previously, we called resetThisMaze() here. But now I think
    // we should call it after moveIntoForTravel(), on account of 
    // some particular things in the Net-Hac-Man maze that need to
    // be done a certain way.
    //bot.getOutermostRoom.resetThisMaze;
    
    bot.getOutermostRoom.resetThisMaze;
    glob.pcIsDead = nil;
    maybeNbmCls(ResetAction);
    local origin = bot.location;
    bot.moveIntoForTravel(bot.getOutermostRoom.firstRoomInThisMaze);
    if (gPlayerChar.location && gPlayerChar.location.ofKind(HacRoom)) {
      hacTitle();
    }
    bot.location.travelerArriving(gPlayerChar, origin, nil, nil);
    //gPlayerChar.lookAround(true);
    nbmBanner.updateMe;
  }
  //includeInUndo = nil
  //isRepeatable = nil
;

// -------------------------------------------------------------------
// ACTIONS: INNER GAME META-ACTIONS: Begin
// -------------------------------------------------------------------

VerbRule(Begin)
  'begin'
  : BeginAction
  verbPhrase = 'begin/beginning'
;

DefineSystemAction(Begin)
  execSystemAction() {
    if (gPlayerChar != bot) {
      libMessages.alienVerbNotUsedMsg;
      return;
    }
    "Sheila cocks her head and says, <.q>Are you sure you want 
      to begin the game all over again? You<./s>ll lose all the 
      progress you<./s>ve made!<./q> ";
    //"<p>Type Y or N&gt;&gt;";
    // If the player says no, then...
    if (!sayYesOrNo()) {
      "<.q>No problem,<./q> says Sheila. <.q>Back to the game, then!<./q> ";
    }
    else {
      reallyBegin;
    }
  }
  reallyBegin {
    // The following two lines are RestartAction's idea, not mine.
    // I don't really understand them.
    //commandSequencer.setCommandMode();
    //"<.commandsep>";
    bot.getOutermostRoom.resetAllMazes;
    maybeNbmCls(BeginAction);
    if (!actionRequiresCls(BeginAction))
      "<.p>";
    supermazeBanner();
    "<p>";
    local origin = bot.location;
    bot.moveIntoForTravel(supermazeJ1);
    bot.location.travelerArriving(gPlayerChar, origin, nil, nil);
    //gPlayerChar.lookAround(true);
    nbmBanner.updateMe;
  }
  //includeInUndo = nil
  //isRepeatable = nil
;

// -------------------------------------------------------------------
// ACTIONS: INNER GAME META-ACTIONS: Inner game finish options
// -------------------------------------------------------------------

// MFO = mazes finish option
mfoReset: FinishOption
  desc = "RESET the current maze"
  responseKeyword = 'reset'
  responseChar = 't'
  doOption {
    ResetAction.reallyReset;
  }
;
mfoBegin: FinishOption
  desc = "BEGIN all over again"
  responseKeyword = 'begin'
  responseChar = 'b'
  doOption() {
    BeginAction.reallyBegin;
  }
;
mfoStop: FinishOption
  desc = "STOP playing"
  responseKeyword = 'stop'
  responseChar = 's'
  doOption() {
    StopAction.reallyStop;
  }
;
mfoQuit: finishOptionQuit
  isListed = nil
;
mfoRestart: finishOptionRestart
  responseChar = nil
  isListed = nil
;
mfoRestore: finishOptionRestore
  desc = "RESTORE a game"
;
mfoUndo: finishOptionUndo
  desc = "UNDO the last move"
;

// -------------------------------------------------------------------
// ACTIONS: CLS / CLST (debugging verb useful for getting cleaner screenshots)
// -------------------------------------------------------------------

#ifdef __DEBUG

// -----------------
// CLS

VerbRule(ClearScreen)
  'cls'
  : ClearScreenAction
  verbPhrase = 'clear/clearing the screen'
;

DefineSystemAction(ClearScreen)
  execSystemAction() {
    nbmCls();
    gPlayerChar.lookAround(true);
    //nestedAction(Look);
  }
;

// -----------------
// CLST

VerbRule(ClearScreenTrailer)
  'clst' | ('cls' 'trailer')
  : ClearScreenTrailerAction
  verbPhrase = 'clear/clearing the screen for the trailer'
;

DefineSystemAction(ClearScreenTrailer)
  execSystemAction() {
    nbmCls();
    "<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;";
    gPlayerChar.lookAround(true);
    //nestedAction(Look);
  }
;

#endif // __DEBUG

// -------------------------------------------------------------------
// ACTIONS: SpareMe
// -------------------------------------------------------------------

// No longer necessary because HyperTADS users (the only ones who 
// needed the SPARE ME command) will now not be able to play this game
// anyway.

/*
VerbRule(SpareMe)
  'spareme' | 'spare' 'me'
  : SpareMeAction
  verbPhrase = 'skip/skipping past the current part of the game'
;

DefineSystemAction(SpareMe)
  execSystemAction() {
    if (systemInfo(SysInfoOsName).toLower.startsWith('win')) {
      "[The SPARE ME command was designed to benefit those who played
        this game with an interpreter other than the HTML TADS
        Player Kit for Windows, since other interpreters
        sometimes performed badly in 
        <<gPlayerChar.getOutermostRoom && gPlayerChar.getOutermostRoom.ofKind(HacRoom) 
          ? 'this Net-Hac-Man part of the game' 
          : 'some parts of this game'>>.
        However, you appear to be playing this game with 
        the HTML TADS Player Kit for Windows,
        which most testers agreed performed adequately.
        Therefore, the SPARE ME command 
        is not available for your use.] ";
    }
    else if (gPlayerChar != bot 
        || !bot.getOutermostRoom.ofKind(HacRoom)) {
      "[The SPARE ME command was designed to allow you to
        skip past parts of the game which some non-Windows
        interpreters have had extreme difficulty with. 
        This is not the most troublesome part of the game, 
        so the SPARE ME command is not available here.] ";
    }
    else {
      "[Very well, we shall skip to the end of this segment.] ";
      "<.p>";
      finishHac();
      gAction.actionTime = 1;
    }
  }
  includeInUndo = true
  //isRepeatable = nil
;
*/

// -------------------------------------------------------------------
// ACTIONS: MENU ACTIONS: About, Credits, Copyright
// -------------------------------------------------------------------

modify AboutAction
    execSystemAction() {
        nbmMenu.display();
        nbmBanner.updateMe;
        "Done. ";
        //local anyOutput;
        //// watch for any output while showing module information
        //anyOutput = outputManager.curOutputStream
        //            .watchForOutput(new function()
        //{
        //    // show information for each module
        //    foreach (local cur in ModuleID.getModuleList())
        //        cur.showAbout();
        //});
        //// if we didn't have any ABOUT information to show, display a
        //// message to this effect 
        //if (!anyOutput)
        //    libMessages.noAboutInfo;
    }
;

modify CreditsAction
    execSystemAction()
    {
        nbmMenu.display();
        nbmBanner.updateMe;
        "Done. ";
        //foreach (local cur in ModuleID.getModuleList())
        //    cur.showCredit();
    }
;

DefineSystemAction(Copyright)
    execSystemAction() {
        local origElapsedTime;
        origElapsedTime = realTimeManager.getElapsedTime();
        showInstructions();
        realTimeManager.setElapsedTime(origElapsedTime);
    }
    showInstructions() {
        nbmMenu.display();
        nbmBanner.updateMe;
        "Done. ";
    }
;

VerbRule(Copyright) 'copyright' : CopyrightAction
;

modify MenuItem
  heading = ('<b>' + title + '</b>')
;

// I guess Goal items don't need headings in bold.
//modify MenuTopicItem
//  heading = ('<b>' + title + '</b>')
//;


setHintWarning() {
  topHintMenu.goesWayBack = nil;
  sessionHintStatus.hintWarning = true;
  gameHintStatus.hintWarning = true;
}

// -------------------------------------------------------------------
// ACTIONS: MENU ACTIONS: Menu options
// -------------------------------------------------------------------

nbmMenu: MenuItem 'Nothing but Mazes'
  updateContents() {
    // Preliminaries 1: adjust variables as needed before
    // getting to the main business of updating contents.
    if (sessionHintStatus.hintsDisplayed || sessionHintStatus.hintWarning) {
      setHintWarning();
      //topHintMenu.goesWayBack = nil;
      //sessionHintStatus.hintWarning = true;
      //gameHintStatus.hintWarning = true;
    }
    // Preliminaries 2: update the hint menu's contents
    topHintMenu.updateContents();
    // Update contents
    if (gPlayerChar == bot) {
      contents = mainContentsList + botHintMenu;
    }
    else if (sessionHintStatus.hintsDisabled) {
      //contents = mainContentsList;
      contents = mainContentsList + hintsDisabledInMenu;
    }
    else if (!sessionHintStatus.hintWarning) {
      contents = mainContentsList + hintWarningMenu;
    }
    else if (topHintMenu.contents.length == 0) {
      contents = mainContentsList + noHintsFromNbmMenu;
    }
    else {
      contents = mainContentsList + topHintMenu;
    }
  }
  mainContentsList = [
     aboutMenu
    ,commandsMenu
    ,creditsMenu
    ,multimediaCreditsMenu
    ,quotationCreditsMenu
    //,otherCreditsMenu
    ,copyrightMenu
    ,topInstructionsMenu
  ]
;

aboutMenu: MenuLongTopicItem 'About this game'
  location = nbmMenu
  menuContents =
    'Many thanks for playing <i>Nothing but Mazes.</i>
      <p>For information about game requirements,
        compatibility issues, and so on, please consult
        the file mazes_readme.txt, which you should
        have received with this game.
      <p>You may wish to navigate
        to the <.q>important commands<./q> section
        of this menu for a few helpful tips.
      <p>Also, if you haven<./s>t played this 
        type of game before, you may wish to 
        navigate to the 
        <.q>how to play interactive fiction<./q>
        part of this menu.
      <p>Can this game be put into an unwinnable state?
        Yes. However, when this happens, you 
        should always be able to
        solve the problem by either
        (1) typing UNDO, or (2) typing one of the 
        <.q>special-context<./q> verbs listed in
        the <.q>important commands<./q> part of 
        this menu. 
      <p>Technical note: if you are playing this game 
        with an emulator
        and it crashes after about a dozen turns, 
        this is likely a music issue. Restart
        the game and type MUSIC OFF to fix the problem.
      <p>I<./s>m very grateful to my beta-testers
        and many other people who helped make this game
        as good as it is. For a complete list of 
        such people, please navigate
        to the <.q>credits<./q> part of this menu.
      <p>This game was an entry in IntroComp 2006,
        where it took third place. Many thanks to
        Jacqueline Lott, who organized that competition,
        and to all the people who gave me feedback
        after the competition. For that matter,
        thanks in advance to anyone who gives me
        feedback in the future.
      <p>After you<./s>ve finished this game, why not send me 
        an email telling me what you thought about it? 
        Bug reports and all types of feedback
        are greatly appreciated. Write to 
        ' + glob.authorEmail + '. '
      // play my game comp.
  menuOrder = 10
;

commandsMenu: MenuLongTopicItem 'Important commands'
  location = nbmMenu
  menuContents =
    'Important commands to use in this game:
    <p>Conversation verbs: 
      <br>TALK TO (T) CHARACTER: Talk to a character.
        This is the only conversation verb you<./s>ll need.
    <p>Important traditional verbs:
      <br>SAVE: Save your position in the game.
      <br>RESTORE: Load a previously saved position.
      <br>UNDO: Take back the last move.
      <br>RESTART: Restart the game.
      <br>QUIT: Stop playing the game.
      <br>ABOUT/INSTRUCTIONS: Pull up this menu,
        which gives general information, instructions,
        credits, and copyright information.
      <br>HINT: Seek specific help on a puzzle 
        within the game.
    <p>Special-context verbs:
      <br>(The following verbs are important for 
        certain segments of the game, but cannot be used
        outside of those segments.)
      <br>RESET: Reset the current puzzle to its 
        initial state.
      <br>ESCAPE: Escape the current puzzle and return
        to your previous environment.
      <br>BEGIN: Restart a game-within-a-game.
      <br>STOP: Stop playing a game-within-a-game.
      <br>INFO: Get instructions on a
        game-within-a-game.
      <br>RETRY: Go back to the beginning of 
        a time-sensitive challenge (after the game
        has announced such a challenge).
    <p>Multimedia verbs:
      <br>MUSIC OFF/MUSIC ON: Deactivate or reactivate
        the game<./s>s optional music and other sound effects. 
      <br>IMAGES SMALL/IMAGES LARGE: Adjust the size
        of the game<./s>s illustrations (for smaller/larger monitors). '
//        + '(As explained in the accompanying 
//        .txt file, typing MUSIC OFF 
//        during the game<./s>s first few moves
//        may prevent unexplained crashes that can happen
//        when playing this game with an emulator.) '

//    + '<p>Other verbs:
//      <br>(This is by no means a complete list of the verbs
//        useful to playing this game. For a more complete
//        list, navigate to the part of this menu that says
//        <.q>How to play interactive fiction.<./q>) '

//    'Many thanks for playing the introduction to 
//        <i>Nothing but Mazes.</i> 
//      <p>' +
//     'This is the intro version of <i>Nothing but Mazes.</i>
//        It consists of three files:
//        mazes_intro.t3 (this game file), 
//        mazes_intro.3r0 (optional music), and
//        mazes_readme.txt (about the game). '
//    +'<p>Please consult mazes_readme.txt
//        if you wish to learn more about game requirements, 
//        compatibility issues, and other such matters. '
    +'<p>If you<./s>ve never played this kind of game before,
        you may wish to navigate to the part of this menu that 
        says <.q>how to play interactive fiction.<./q> '
//    +'<p>Also, in case you didn<./s>t already know, this is
//        not a complete game. In July 2006 it was submitted to
//        the <a href=\"http://www.xyzzynews.com/introcomp/\"
//        >IntroComp</a>, a competition for unfinished 
//        interactive fiction games. It took third place.
//        I hope that this intro version of the game
//        whets your appetite for the finished version,
//        which I hope will be released by July 2007. '
//    +'<p>Conversation
//        in this game happens via the TALK TO verb, which can
//        be abbreviated to T. '
//    +'<p>I have also given one-letter abbreviations to the
//        game<./s>s most important characters. Thus,
//        to talk to James, you could type TALK TO J, or just T J. '
//    +'<p>This game contains optional music. 
//        You may deactivate it by typing MUSIC OFF. 
//        To turn it on again, you may type MUSIC ON. '
//    +'<p>If you are playing this game with an emulator or 
//        similar software, and if the game crashes after
//        you see the words <.q>your eyes adjust, and you cannot 
//        believe what you see,<./q> then this is a music-related bug.
//        You may be able to fix it by restarting the game
//        and typing MUSIC OFF before you do anything else. '
    +'<p>Please browse through the contents of this menu
        and read the CREDITS. I<./s>m very grateful to 
        the people mentioned there. You may also
        navigate through the menu for COPYRIGHT information. '
//    +'<p>Also, you may type HINT if you get stuck. '
//    +'<p>For this intro version of the game, 
//        you can<./s>t put the game into an unwinnable state 
//        without committing the kind of blunder
//        that kills you instantly. If this happens,
//        you can always type UNDO. '
    +'<p>After you<./s>ve finished this game, why not send me 
        an email telling me what you thought about it? 
        Bug reports and all types of feedback
        are greatly appreciated. '
    +'<p>You may contact me by writing to 
        ' + glob.authorEmail + '. '
  menuOrder = 15
;

modify glob
  mainCreditsText =
    '<table>
      <tr>
        <td valign="top"><b>Writing/programming:</b></td>
        <td valign="top">Greg Boettcher</td>
      </tr>
      <tr>
        <td valign="top"><b>Artwork:</b></td>
        <td valign="top">Greg Boettcher</td>
      </tr>
      <tr>
        <td valign="top"><b>Music:</b></td>
        <td valign="top">Greg Boettcher</td>
      </tr>
      <tr>
        <td valign="top"><b>Programming&nbsp;assistance:</b></td>
        <td valign="top">Krister Fundin</td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          (Krister improved the AI for one segment of the game. 
          Thanks, Krister!)
        </td>
      </tr>
      <tr>
        <td valign="top"><b>Testing:</b></td>
        <td valign="top">
          <b>Alpha testing:</b><br>
          Daphne Brinkerhoff
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>IntroComp beta testing (2006):</b><br>
          Mara Meijers, 
          Peter Mattsson, 
          Bernard Philie L<./s>Heureux, 
          Chephren, 
          Mike Snyder,
          Matt Funke,
          Michael Martin, 
          Poster
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>Final cut beta testing (2008-19):</b><br>
          Patrick Mooney,
          Krister Fundin, 
          Jim Aikin, 
          Charles Srstka, 
          Nikos Chantziaras, 
          Adam Thornton, 
          Barbara Brinkerhoff
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          (Big thanks to all the testers. Many of them spent numerous 
          hours on testing without anything in return. They helped 
          make this game as good as it is.)
        </td>
      </tr>
      <tr>
        <td valign="top"><b>Technical&nbsp;assistance:</b></td>
        <td valign="top">
          Eric Eve, 
          Mike Roberts, 
          Nikos Chantziaras,
          Krister Fundin, 
          Michel Nizette, 
          Damian Dollahite, 
          tomasb, 
          Steve Breslin, 
          Khelwood, 
          Guilherme de Sousa, 
          Rick Hawk
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          (Thanks to everyone who answered my questions about TADS 3.)
        </td>
      </tr>
      <tr>
        <td valign="top"><b>Programming&nbsp;system:</b></td>
        <td valign="top">
          <b>TADS 3:</b>
          Mike Roberts, et al.
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>TADS 3 documentation:</b>
          Mike Roberts, 
          Eric Eve, 
          et al.
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          (Without Mike Roberts, there<./s>d be no TADS 3, and without Eric Eve, 
          it<./s>d be a lot harder to learn it. Thanks, guys.)
        </td>
      </tr>
      <tr>
        <td valign="top"><b>Programming&nbsp;interpreters:</b></td>
        <td valign="top">
          <b>Player Kit (Windows):</b>
          Mike Roberts
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>QTads (Multi-platform):</b>
          Nikos Chantziaras
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>CocoaTADS (Mac OS X):</b>
          Charles Srstka
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          (Because of these people, this game is not Windows-only. 
          Big thanks to them, especially to Nikos for his technical help.)
        </td>
      </tr>
      <tr>
        <td valign="top"><b>Programming&nbsp;extensions:</b></td>
        <td valign="top">
          <b>qtalk.t:</b>
          Greg Boettcher
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>achievement.t:</b>
          Greg Boettcher
        </td>
      </tr>
      <tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>autosave.t:</b>
          Michel Nizette
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>ncDebugActions.t:</b>
          Nikos Chantziaras
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>ncYesNo.t:</b>
          Nikos Chantziaras
        </td>
      </tr>
      <tr>
        <td valign="top">&nbsp;</td>
        <td valign="top">
          <b>msg_custom.t:</b>
          Greg Boettcher
        </td>
      </tr>
      <tr>
        <td valign="top"><b>Astronomy&nbsp;consultants:</b></td>
        <td valign="top">Jacob Navia, Bill Owen</td>
      </tr>
      <tr>
        <td valign="top"><b>Geography&nbsp;consultant:</b></td>
        <td valign="top">Scott A. Zillmer</td>
      </tr>
      <tr>
        <td valign="top"><b>IntroComp&nbsp;2006&nbsp;organizer:</b></td>
        <td valign="top">Jacqueline A. Lott</td>
      </tr>
    </table>'
  photoCreditsText =
('At one point in this game, there is a set of 42 animal photographs. 
    The credits for these are as listed below. Most of the photos were ones
    which, as far as I know, may be used without permission.
    There are four exceptions, marked <.q>&copy;,<./q> which are copyrighted
    and used with permission. ' +
//'<p>Of these four photos, two were granted for my use free of charge. 
//    Very special thanks to <a href=\"http://www.amazilia.net/\">Allen Chartier</a> 
//    and <a href=\"http://www.ultimateungulate.com/\">Brent Huffman</a>
//    for letting me use photos #32 and #41, respectively. ' +
'<.p>
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
  <tr><td align="right" valign="top" rowspan="42"> <img src="illustrations/photocredits.png" border="0" hspace="9"></td>
      <td align="right" valign="top"> 1.&nbsp;</td><td valign="top">U.S. Fish and Wildlife Service</td></tr>
  <tr><td align="right" valign="top"> 2.&nbsp;</td><td valign="top">National Human Genome Research Institute</td></tr>
  <tr><td align="right" valign="top"> 3.&nbsp;</td><td valign="top">&copy; Jan Tyler (used with permission)</td></tr>
  <tr><td align="right" valign="top"> 4.&nbsp;</td><td valign="top">Maeve Taylor/U.S. Fish and Wildlife Service/Montezuma National Wildlife Refuge</td></tr>
  <tr><td align="right" valign="top"> 5.&nbsp;</td><td valign="top">&copy; Michelle Allen (used with permission)</td></tr>
  <tr><td align="right" valign="top"> 6.&nbsp;</td><td valign="top">NOAA Ocean Explorer</td></tr>
  <tr><td align="right" valign="top"> 7.&nbsp;</td><td valign="top">NOAA Ocean Explorer</td></tr>
  <tr><td align="right" valign="top"> 8.&nbsp;</td><td valign="top">U.S. Fish and Wildlife Service</td></tr>
  <tr><td align="right" valign="top"> 9.&nbsp;</td><td valign="top">Jeff Vanuga/USDA National Resources Conservation Service</td></tr>
  <tr><td align="right" valign="top">10.&nbsp;</td><td valign="top">Kip Evans/NOAA Monterey Bay National Marine Sanctuary</td></tr>
  <tr><td align="right" valign="top">11.&nbsp;</td><td valign="top">Scott Bauer/USDA Agricultural Research Service</td></tr>
  <tr><td align="right" valign="top">12.&nbsp;</td><td valign="top">T. Tuttle/U.S. Bureau of Land Management, Medford District photo archive</td></tr>
  <tr><td align="right" valign="top">13.&nbsp;</td><td valign="top">Catie Drew/U.S. National Park Service</td></tr>
  <tr><td align="right" valign="top">14.&nbsp;</td><td valign="top">Scott Hill/NOAA Corps</td></tr>
  <tr><td align="right" valign="top">15.&nbsp;</td><td valign="top">Jim Ross/NASA</td></tr>
  <tr><td align="right" valign="top">16.&nbsp;</td><td valign="top">Michael MacNeil/U.S. Department of Agriculture</td></tr>
  <tr><td align="right" valign="top">17.&nbsp;</td><td valign="top">NOAA Ocean Explorer</td></tr>
  <tr><td align="right" valign="top">18.&nbsp;</td><td valign="top">Jerry Bauer/U.S. National Park Service</td></tr>
  <tr><td align="right" valign="top">19.&nbsp;</td><td valign="top">Robyn Shaw/Spring Valley Laboratories, Inc./National Human Genome Research Institute</td></tr>
  <tr><td align="right" valign="top">20.&nbsp;</td><td valign="top">Mary Hollinger, NESDIS & NODC biologist/NOAA</td></tr>
  <tr><td align="right" valign="top">21.&nbsp;</td><td valign="top">Jessie Cohen/Smithsonian<./s>s National Zoological Park</td></tr>
  <tr><td align="right" valign="top">22.&nbsp;</td><td valign="top">Lt. Philip Hall/NOAA Corps</td></tr>
  <tr><td align="right" valign="top">23.&nbsp;</td><td valign="top">U.S. Fish and Wildlife Service</td></tr>
  <tr><td align="right" valign="top">24.&nbsp;</td><td valign="top">W. Battaglin/U.S. Geological Survey</td></tr>
  <tr><td align="right" valign="top">25.&nbsp;</td><td valign="top">Dann Blackwood/U.S. Geological Survey</td></tr>
  <tr><td align="right" valign="top">26.&nbsp;</td><td valign="top">Maria Brown/NOAA National Marine Sanctuaries</td></tr>
  <tr><td align="right" valign="top">27.&nbsp;</td><td valign="top">Bill Hickey/U.S. Fish and Wildlife Service</td></tr>
  <tr><td align="right" valign="top">28.&nbsp;</td><td valign="top">Mr. Mohammed Al Momany/NOAA</td></tr>
  <tr><td align="right" valign="top">29.&nbsp;</td><td valign="top">Mike White/Florida Keys National Marine Sanctuary</td></tr>
  <tr><td align="right" valign="top">30.&nbsp;</td><td valign="top">Dr. Louis M. Herman/Hawaiian Is. Humpback Whale National Marine Sanctuary</td></tr>
  <tr><td align="right" valign="top">31.&nbsp;</td><td valign="top">Noreen Marchand/National Human Genome Research Institute</td></tr>
  <tr><td align="right" valign="top">32.&nbsp;</td><td valign="top">&copy; <a href=\"http://www.amazilia.net/\">Allen Chartier</a> (used with permission)</td></tr>
  <tr><td align="right" valign="top">33.&nbsp;</td><td valign="top">Florida Keys National Marine Sanctuary</td></tr>
  <tr><td align="right" valign="top">34.&nbsp;</td><td valign="top">U.S. National Park Service</td></tr>
  <tr><td align="right" valign="top">35.&nbsp;</td><td valign="top">Dave Menke/U.S. Fish and Wildlife Service</td></tr>
  <tr><td align="right" valign="top">36.&nbsp;</td><td valign="top">J. Dreyer/NOAA Ocean Explorer</td></tr>
  <tr><td align="right" valign="top">37.&nbsp;</td><td valign="top">Laura Francis/Florida Keys National Marine Sanctuary</td></tr>
  <tr><td align="right" valign="top">38.&nbsp;</td><td valign="top">Dean Biggins/U.S. Fish and Wildlife Service</td></tr>
  <tr><td align="right" valign="top">39.&nbsp;</td><td valign="top">Susan Scott/NOAA National Marine Sanctuaries</td></tr>
  <tr><td align="right" valign="top">40.&nbsp;</td><td valign="top">Dean Biggins/U.S. Fish and Wildlife Service</td></tr>
  <tr><td align="right" valign="top">41.&nbsp;</td><td valign="top">&copy; <a href=\"http://www.ultimateungulate.com/\">Brent Huffman/www.ultimateungulate.com</a> (used with permission)</td></tr>
  <tr><td align="right" valign="top">42.&nbsp;</td><td valign="top">Gary M. Stolz/U.S. Fish and Wildlife Service</td></tr>
</table>'
+ '(Other illustrations are by Greg Boettcher.)')
  musicCreditsText = 
  'The <i>Ms. Pac-Man</i> opening music is copyrighted by
    Namco, Ltd. It has been modified and included here
    without permission. 
  <p>Other music is by Greg Boettcher.'
  quotationCreditsText() {
    local str;
    str =
      'At one point in this game there are items that 
          mimic the behavior of items previously appearing in
          the games listed below, and thus take quotations
          from those games.
          I don<./s>t think this goes beyond the bounds of fair usage,
          so I haven<./s>t felt obligated to ask for permission
          in all cases.
          But I do want to give credit here.
        <p>Note: where games are asterisked[*], 
          I <i>did</i> ask for permission, 
          and was granted it. Many thanks to the authors
          who granted this request.
        <p>';
    str += '<ul>';
    for (local a = 1; a <= 16; a++) {
      if (glob.artifactList[a] && glob.artifactList[a].isListedInCredits) {
        if (str.substr(-3) != '<p>') {
          //str += '<br>';
        }
        str += '\n<li>';
        str +=
          glob.artifactList[a].attributionForCredits;
      }
    }
    str += '</ul>';
    return str;
  }
;

creditsMenu: MenuLongTopicItem 'Main Credits'
  location = nbmMenu
  menuContents = (glob.mainCreditsText)
  menuOrder = 20
;

// http://www.spaceandmotion.com/copyright-copyleft-gnu-free-license.htm

multimediaCreditsMenu: MenuLongTopicItem 'Multimedia credits'
  location = nbmMenu
  menuOrder = 21
  menuContents =
'<p><b>Photos:</b> 
<p><<glob.photoCreditsText>>
<p><b>Music:</b>
  <p><<glob.musicCreditsText>> '
;

modify glob
  // 16 nil values; will be changed during showIntro().
  artifactList = [
    nil, nil, nil, nil, nil, nil, nil, nil, 
    nil, nil, nil, nil, nil, nil, nil, nil
  ]
  //// will be changed during showIntro().
  //alphabetizedArtifactList = nil 
;

quotationCreditsMenu: MenuLongTopicItem 'Quotation credits'
  location = nbmMenu
  menuOrder = 22
  menuContents {
    return glob.quotationCreditsText();
  }
;

otherCreditsMenu: MenuLongTopicItem 'Other credits'
  location = nbmMenu
  menuContents =
    'The <i>Ms. Pac-Man</i> opening music is copyrighted by
        Namco, Ltd. It has been modified and included here
        without permission.
      <p>Also, one of my game<./s>s illustrations
        is very closely based on an illustration from 
        <i>Gateway II: Homeworld.</i>
        This was done in the spirit of tribute to a fine game,
        but it too was done without permission. '
  menuOrder = 23
;

copyrightMenu: MenuLongTopicItem 'Copyright'
  location = nbmMenu
  menuContents =
    'This game is copyright 2006&ndash;2019 by Greg Boettcher. It is 
        freeware, so you may play it at no charge. 
        You may also copy it and distribute it as much as 
        you want, as long as you don<./s>t charge any
        money for doing so, and as long as you don<./s>t 
        modify the game in any way.
      <p>To contact me for any reason, please write to
        ' + glob.authorEmail + '. '
  menuOrder = 25
;

// -------------------------------------------------------------------
// ACTIONS: MENU ACTIONS: Instructions
// -------------------------------------------------------------------

modify InstructionsAction
  customVerbs = [ ]
  conversationVerbs = [
    'TALK TO WIZARD'
  ]
  conversationAbbr = "\n\t T SUSAN: TALK TO SUSAN"
  allRequiredVerbsDisclosed = nil
  showInstructions() {
    
    //START HACK
    nbmMenu.display();
    nbmBanner.updateMe;
    //END HACK
    
    "Done. ";
  }
  conversationInstructions =
    "In this game, unlike most interactive fiction games, you 
    should talk to characters not by typing ASK or TELL, but using 
    the verb TALK TO; for instance, TALK TO JAMES. This can be 
    abbreviated to T JAMES. (In this particular game, some
    characters also have one-letter abbreviations. Thus,
    with James, you might try typing TALK TO J, or simply T J.)
    
    \bTalking to characters will bring up a menu of 
    conversation options to choose from. Simply type in a number 
    to make your choice.
    
    \bYou can also interact with other characters using physical
    objects.  For example, you might be able to give something to
    another character, as in GIVE MONEY TO CLERK, or show an object
    to someone, as in SHOW IDOL TO PROFESSOR.  You might also be
    able to fight other characters, as in ATTACK TROLL WITH
    SWORD or THROW AXE AT DWARF. "
  showAbbrevChapter() {
    "\b<b>Abbreviations</b>
    \bTo save typing, you can use the following abbreviations:

    \b
    \n\t L: LOOK AROUND
    \n\t I: INVENTORY
    \n\t N, S, E, W, NE, SE, NW, SW: GO NORTH, GO SOUTH, etc.
    \n\t U, D: GO UP, GO DOWN
    \n\t X DISK: EXAMINE DISK 
    <<conversationAbbr>>
    \n\t Z: WAIT
    \n\t G: AGAIN
    \n\t O: OOPS
    \n\t Q: QUIT

    \b<b>A Few More Command Details</b>
    \bWhen you're entering commands, you can use capital or small
    letters in any mixture.  You can use words such as THE and A
    when they're appropriate, but you can omit them if you prefer. ";

    if (truncationLength != nil) {
      "You can abbreviate any word to its first <<
      spellInt(truncationLength)>> letters, but if you choose not
      to abbreviate, the story will pay attention to
      everything you actually type; this means, for example, that you
      can abbreviate SUPERCALIFRAGILISTICEXPIALIDOCIOUS to <<
      'SUPERCALIFRAGILISTICEXPIALIDOCIOUS'.substr(1, truncationLength)
      >> or <<
      'SUPERCALIFRAGILISTICEXPIALIDOCIOUS'.substr(1, truncationLength+2)
      >>, but not to <<
      'SUPERCALIFRAGILISTICEXPIALIDOCIOUS'.substr(1, truncationLength)
      >>SDF. ";
    }
  }
;

modify topInstructionsMenu
  title = 'How to play interactive fiction'
  location = nbmMenu
  menuOrder = 30
;

// -------------------------------------------------------------------
// ACTIONS: MENU ACTIONS: Hint
// -------------------------------------------------------------------

modify VerbRule(About)
  'about' | 'help' | 'menu'
  :
;

//replace VerbRule(Hint)
//    'hint' | 'hints' //| 'help'
//    : HintAction
//    verbPhrase = 'show/showing hints'
//;

modify glob
  rememberedFont = verdana
;

modify HintAction
  execSystemAction() {
    if (gPlayerChar != bot) {
      if (gHintManager != nil)
        gHintManager.showHints();
      else
        mainReport(libMessages.hintsNotPresent);
    }
    else { // bot is player character
      if (sessionHintStatus.botHintsDisabled) {
        "<.q>Sorry I can<./s>t do that,<./q> says Shiela. 
          <.q>Hints have been disabled for this session, 
          at your own request. If you want to change that, you<./s>ll 
          have to close the game, re-open it, and then ask for hints.<./q> ";
        gAction.actionTime = 1;
      }
      else if (!hintManager.showHintWarning()) {
        gAction.actionTime = 1;
      }
      else if (!bot.getOutermostRoom.propDefined(&giveHint)) {
        "<.q>Sorry,<./q> says Sheila, <.q>but I don<./s>t have
          any hints for you now. Feel free to try again later!<./q> ";
        gAction.actionTime = 1;
      }
      else {
        sessionHintStatus.botHintWarning = true;
        gameHintStatus.botHintWarning = true;
        bot.getOutermostRoom.giveHint();
        glob.giveBotHintAdvice();
        gAction.actionTime = 1;
      }
    }
  }
;

// 2019-05-16: I've decided to have completely different hint settings 
// for the middle part of the game vs. the beginning and end parts of 
// the game. I guess some might propose switching out the hint manager for this, 
// but I guess I'm going to opt for saying it seems easier to me just 
// to use one hintManager and a bunch of "if" statements.
modify hintManager
  iveBeenModified = true
  disableHints() {
    // HACK:
    if (gPlayerChar == bot) {
      if (!sessionHintStatus.botHintsDisabled) {
        "<.q>Okay, you got it,<./q> says Shiela. <.q>Hints are now disabled
          for the rest of the session.<./q> ";
      }
      else {
        "<.q>Yep,<./q> says Shiela. <.q>Hints are already disabled
          for the rest of the session.<./q> ";
      }
      sessionHintStatus.botHintsDisabled = true;
    }
    else {
      // STANDARD LIBRARY IMPLEMENTATION:
      sessionHintStatus.hintsDisabled = true;
      mainReport(gLibMessages.hintsDisabled);
    }
  }
  // In this implementation, this is only ever called when 
  // gPlayerChar != bot
  showHints() {
    if (topHintMenuObj == nil) {
      mainReport(libMessages.hintsNotPresent);
      return;
    }
    if (sessionHintStatus.hintsDisabled) {
      mainReport(libMessages.sorryHintsDisabled);
      return;
    }
    topHintMenuObj.updateContents();
    
    
    // START HACK: Change the order of the next two conditions
    if (!showHintWarning()) {
      return;
    }
    if (topHintMenuObj.contents.length() == 0) {
      mainReport(libMessages.currentlyNoHints);
      return;
    }
    // END HACK
    
    
    // START HACK
    nbmMenu.display();
    //topHintMenuObj.display();
    // END HACK
    
    
    mainReport(libMessages.hintsDone);
    
    
    // START YET ANOTHER HACK
    nbmBanner.updateMe;
    // END HACK
        
        
  }
  showHintWarning() {
    if (gPlayerChar == bot) {
      if (!sessionHintStatus.botHintWarning && !gameHintStatus.botHintWarning) {
        libMessages.showShielaHintWarning();
        
        sessionHintStatus.botHintWarning = true;
        gameHintStatus.botHintWarning = true;
        
        // don't proceed to hints now; let them ask again
        return nil;
      }
      sessionHintStatus.botHintWarning = true;
      return true;
    }
    else {
      // If we have previously warned in this session, or if we've
      // warned in a previous session and the same game was later
      // saved and restored, don't warn again.  The transient session
      // object tells us if we've asked in this session; the normal
      // persistent object tells us if we've asked in a previous
      // session that we've since saved and restored. 
      if (!sessionHintStatus.hintWarning && !gameHintStatus.hintWarning) {
        // we haven't asked yet in either the session or the game,
        // so show the warning now 
        libMessages.showHintWarning();
        // note that we've shown the warning
        sessionHintStatus.hintWarning = true;
        gameHintStatus.hintWarning = true;
        // don't proceed to hints now; let them ask again
        return nil;
      }
      // They've already seen the warning before.  It's possible that
      // they've seen it in a past session with the game and not
      // otherwise during this session, but now that we're accessing
      // the hint system once, don't bother with another warning for
      // the rest of this session.  
      sessionHintStatus.hintWarning = true;
      // proceed to the hints
      return true;
    }
  }
;

replace transient sessionHintStatus: object
  // ==================================
  // Outer game, standard (no changes to default value):
  
  // hintsDisabled: library property. Indicates whether 
  // HINTS OFF has been selected.
  hintsDisabled = nil
  // hintWarning: library property. Indicates whether 
  // we have gone past the point where the player no longer
  // needs to be given the hint temptation warning anymore.
  // 
  // For each play session, this will remain nil until
  // AT LEAST ONE of the following two conditions occur:
  // (1) The hint temptation warning is given *in the main 
  //     window*, whether by the parser or by Sheila.
  //     Merely giving the temptation warning in the *menu*
  //     is not sufficient for this condition to be met.
  // (2) The player has actually looked at hints.
  hintWarning = nil
  
  // ==================================
  // Outer game, but custom:
  
  // hintsDisplayed: not a library property. Indicates whether
  // we've looked at hints. We need a different variable for 
  // this because this may sometimes affect how far up in
  // the hierarchy a "P" or "[esc]" key should take us.
  hintsDisplayed = nil
  
  // ==================================
  // Inner game, custom:
  
  botHintsDisabled = nil
  botHintWarning = nil
;

modify gameHintStatus
  // ==================================
  // Outer game, standard (no changes to default value):
  
  hintWarning = nil
  
  // ==================================
  // Inner game, custom
  
  botHintWarning = nil
;

modify glob
  giveBotHintAdvice() {
    if (!botHintAdviceHasBeenGiven) {
      "<p>Then, musing, Sheila adds, <.q>I guess I should also
        explain one other thing. When you ask me for a hint, 
        I start off by giving you only a little piece of information 
        at a time. If you need to know more,
        just type HINT again, and keep typing it until you
        get what you need to know.";
      //" Or, instead of typing HINT,
      //  you can type TALK TO SHEILA and select the appropriate 
      //  menu option.";
      "<./q> ";
    }
    botHintAdviceHasBeenGiven = true;
  }
  botHintAdviceHasBeenGiven = nil
;

//modify hintManager
//    showHints()
//    {
//        if (topHintMenuObj == nil)
//        {
//            mainReport(libMessages.hintsNotPresent);
//            return;
//        }
//        if (sessionHintStatus.hintsDisabled)
//        {
//            mainReport(libMessages.sorryHintsDisabled);
//            return;
//        }
//        topHintMenuObj.updateContents();
//        if (topHintMenuObj.contents.length() == 0)
//        {
//            mainReport(libMessages.currentlyNoHints);
//            return;
//        }
//        if (!showHintWarning())
//            return;
//        topHintMenuObj.display();
//        mainReport(libMessages.hintsDone);
//        
//        
//        //START HACK
//        nbmBanner.updateMe;
//        //END HACK
//        
//        
//    }
//;

modify MenuItem
  updateContents() {
    glob.rememberedFont = glob.font;
    glob.font = verdana;
    "<.nbmfont>";
    glob.font = glob.rememberedFont;
    nbmBanner.removeBanner;
  }
;

modify MenuItem
    display() {
      inherited();
      if (sessionHintStatus.hintsDisplayed || sessionHintStatus.hintWarning) {
        setHintWarning();
        //topHintMenu.goesWayBack = nil;
        //sessionHintStatus.hintWarning = true;
        //gameHintStatus.hintWarning = true;
      }
    }
    doPriorToMenuOptions {
      return nil;
    }
    showMenuHtml(topMenu)
    {
        local len, selection = 1, loc;
        local refreshTitle = true;
        curKeyList = topMenu.keyList;
        updateContents();
        do {
            if (refreshTitle) {
                refreshTopMenuBanner(topMenu);
                refreshTitle = nil;
            }
            len = contents.length();
            if (statusLine.statusDispMode == StatusModeApi) {
                contentsMenuBanner.clearWindow();
                if (fullScreenMode)
                    contentsMenuBanner.setSize(100, BannerSizePercent, nil);
                else
                    contentsMenuBanner.setSize(len + 1, BannerSizeAbsolute,
                                               true);
                "<body bgcolor=<<bgcolor>> text=<<fgcolor>> >";
                
                
                //START HACK
                glob.rememberedFont = glob.font;
                glob.font = verdana;
                "<.nbmfont>";
                glob.font = glob.rememberedFont;
                nbmBanner.removeBanner;
                //END HACK
                
                
            }
            else
            {
                "<banner id=MenuBody align=top
                <<fullScreenMode ? 'height=100%' : 'border'>>
                ><body bgcolor=<<bgcolor>> text=<<fgcolor>> >";
            }
            "<table><tr><td width=<<indent>> > </td><td>";
            
            
            //START HACK
            if (doPriorToMenuOptions) {
              "<p>";
              "</td></tr><tr><td>&nbsp;</td><td>";
            }
            //ANOTHER HACK HERE
            if (selection > len) {
              selection = 1;
            }
            //END HACK
            
            
            for (local i = 1; i <= len; i++)
            {
                if (selection != i)
                    "<font color=<<bgcolor>> >&gt;</font>";
                else
                    "&gt;";
                "<a plain href=<<i>> ><<contents[i].title>></a><br>";
            }
            "</td></tr></table>";
            if (statusLine.statusDispMode == StatusModeApi)
            {
                if (!fullScreenMode)
                    contentsMenuBanner.sizeToContents();
            }
            else
            {
                "</banner>";
            }
            do
            {
                local key, events;
                events = inputManager.getEvent(nil, nil);
                switch (events[1])
                {
                case InEvtHref:
                    if (events[2] == 'previous')
                        loc = M_PREV;
                    else
                    {
                        selection = toInteger(events[2]);
                        loc = M_SEL;
                    }
                    break;

                case InEvtKey:
                    key = events[2].toLower();
                    loc = topMenu.keyList.indexWhich(
                        {x: x.indexOf(key) != nil});
                    break;
                }
                if (loc == M_UP)
                {
                    selection--;
                    if (selection < 1)
                        selection = len;
                }
                else if (loc == M_DOWN)
                {
                    selection++;
                    if (selection > len)
                        selection = 1;
                }
            } while (loc == nil);
            
            
            // START HACK
            if (loc == M_SEL
                && selection != 0
                && selection <= contents.length()
                && contents[selection].selectingMeansGoingBack) {
              loc = M_PREV;
            }
            // END HACK
            
            
            while (loc == M_SEL
                   && selection != 0
                   && selection <= contents.length())
            {
                loc = contents[selection].showMenuHtml(topMenu);
                switch (loc)
                {
                case M_UP:
                    loc = M_SEL;
                    --selection;
                    break;
                case M_DOWN:
                    loc = M_SEL;
                    ++selection;
                    break;
                
                
                // START HACK
                case -2:
                    loc = M_PREV;
                    break;
                // END HACK
                
                
                case M_PREV:
                    loc = nil;
                    updateContents();
                    refreshTitle = true;
                    break;
                }
            }
        } while (loc != M_QUIT && loc != M_PREV);
        
        
        // START HACK
        if (loc == M_PREV && goesWayBack)
          return -2;
        else
          return loc;
        // END HACK
        
        
    }
    goesWayBack = nil
    selectingMeansGoingBack = nil
    refreshTopMenuBanner(topMenu)
    {
        local oldStr;
        switch (statusLine.statusDispMode)
        {
        case StatusModeApi:
            topMenuBanner.clearWindow();
            oldStr = topMenuBanner.setOutputStream();
            "<body bgcolor=<<topbarbg>> text=<<topbarfg>> >";
            break;
        case StatusModeTag:
            "<banner id=MenuTitle align=top><body bgcolor=<<topbarbg>>
            text=<<topbarfg>> >";
            break;
        }
        
        
        //START HACK
        glob.rememberedFont = glob.font;
        glob.font = verdana;
        "<.nbmfont>";
        glob.font = glob.rememberedFont;
        nbmBanner.removeBanner;
        //END HACK
        
        
        say(heading);
        libMessages.menuInstructions(topMenu.keyList, prevMenuLink);
        switch (statusLine.statusDispMode)
        {
        case StatusModeApi:
            outputManager.setOutputStream(oldStr);
            topMenuBanner.sizeToContents();
            break;
        case StatusModeTag:
            "</banner>";
            break;
        }
    }
;

modify MenuTopicItem
    redrawWinHtml(topIdx)
    {
        local len;
        local idx;
        len = menuContents.length();
        if (statusLine.statusDispMode == StatusModeApi)
        {
            contentsMenuBanner.clearWindow();
            if (fullScreenMode)
                contentsMenuBanner.setSize(100, BannerSizePercent, nil);
            else
                contentsMenuBanner.setSize(chunkSize < len ? chunkSize : len,
                                           BannerSizeAbsolute, true);
            "<body bgcolor=<<bgcolor>> text=<<fgcolor>> >";
            
            
            //START HACK
            glob.rememberedFont = glob.font;
            glob.font = verdana;
            "<.nbmfont>";
            glob.font = glob.rememberedFont;
            nbmBanner.removeBanner;
            //END HACK
            
            
        }
        else
        {
            "<banner id=MenuBody align=top
            <<fullScreenMode ? 'height=100%' : 'border'>>
            ><body bgcolor=<<bgcolor>> text=<<fgcolor>>  >";
        }
        "<table><tr><td width=<<self.indent>> > </td><td>";
        for (idx = topIdx ; ; ++idx)
        {
            local isLast;
            isLast = (idx == len
                      || (!fullScreenMode && idx == topIdx + chunkSize - 1)
                      || idx == lastDisplayed);
            displaySubItem(idx, isLast, '<br>');
            if (isLast)
                break;
        }
        "</td></tr></table>";
        switch(statusLine.statusDispMode)
        {
        case StatusModeApi:
            if (!fullScreenMode)
                contentsMenuBanner.sizeToContents();
            break;
        case StatusModeTag:
            "</banner>";
            break;
        }
        return idx;
    }
;

class MenuLongTopicItemThatGoesWayBack: MenuLongTopicItem
  showMenuCommon(topMenu) {
    local evt, key, loc, nxt;
    // update our contents, as needed
    updateContents();
    // show our heading, centered
    "<CENTER><b><<heading>></b></CENTER>\b";
    // show our contents
    "<<menuContents>>\b";
    // check to see if we should offer chapter navigation
    nxt = (isChapterMenu ? location.getNextMenu(self) : nil);
    // if there's a next chapter, show how we can navigate to it
    if (nxt != nil) {
      // show the navigation
      libMessages.menuNextChapter(topMenu.keyList, nxt.title,
                                  'next', 'menu');
    }
    else {
      // no chaptering - just print the ending message
      "<<menuLongTopicEnd>>";
    }
    // wait for an event
    for (;;) {
      evt = inputManager.getEvent(nil, nil);
      switch(evt[1]) {
        case InEvtHref:
          // check for a 'next' or 'prev' command
          
          
          // START HACK
          if (evt[2] == 'next' || evt[2] == 'prev' || evt[2] == 'menu')
            return -2;
          //if (evt[2] == 'next')
          //  return M_DOWN;
          //else if (evt[2] == 'prev')
          //  return M_UP;
          //else if (evt[2] == 'menu')
          //  return M_PREV;
          // END HACK
          
          
          break;
        case InEvtKey:
          // get the key */
          key = evt[2].toLower();
          // if we're in plain text mode, add a blank line after
          // the key input 
          if (statusLine.statusDispMode == StatusModeText)
            "\b";
          // look up the command key
          loc = topMenu.keyList.indexWhich({x: x.indexOf(key) != nil});
          
          
          // START HACK
          if (loc == M_SEL || loc == M_PREV)
            return -2;
          if (loc == M_QUIT)
            return loc;
          //// if it's 'next', either proceed to the next menu or
          //// return to the previous menu, depending on whether
          //// we're in chapter mode or not 
          //if (loc == M_SEL)
          //  return (nxt == nil ? M_PREV : M_DOWN);
          //// if it's 'prev', return to the previous menu
          //if (loc == M_PREV || loc == M_QUIT)
          //  return loc;
          // END HACK
          
          
          // ignore other keys
          break;
      }
    }
  }
  //menuLongTopicEnd = '[Please press any key to exit this menu.]'
;


// This last one doesn't work
//modify MenuLongTopicItem
//    showMenuText(topMenu)
//    {
//        local ret;
//        curKeyList = topMenu.keyList;
//        cls();
//        ret = showMenuCommon(topMenu);
//        cls();
//        
//        
//        //START HACK
//        glob.rememberedFont = glob.font;
//        glob.font = verdana;
//        "<.nbmfont>";
//        glob.font = glob.rememberedFont;
//        nbmBanner.removeBanner;
//        showTopMenuBanner(self);
//        //END HACK
//        
//        
//        return ret;
//    }
//;

modify libMessages
  showHintWarning = _showHintWarning(nil)
  showHintWarningForMenu = _showHintWarning(true)
  _showHintWarning(forMenu) {
    "<.notification>Warning: Getting hints prematurely 
        can sometimes diminish one<./s>s enjoyment of a game. 
        If you want to decrease your temptation to do this, 
        you can disable hints for the
        rest of this session by 
        <<forMenu ? 'selecting' : 'typing'>> 
        <<maybeAHref('hints off', 'HINTS OFF', !forMenu)
        >>. If you still want to see the hints now, 
        <<forMenu ? 'select' : 'type'>>
        <<maybeAHref('hint', 'HINT', !forMenu)>>.";
    "<./notification> ";
  }
  showShielaHintWarning =
    "<.q>I can try to give you a hint,<./q> says Sheila.
        <.q>But first, I should warn you that--well, 
        if you ask for hints before you really need them,
        it might cut down on your enjoyment of the game. 
        If you want to get rid 
        of this temptation, you can type HINTS OFF. 
        Your tablet device will then prevent you from asking me for 
        that kind of help during the remainder of this play session. 
        Now if you still want a hint,
        just type HINT again (or type TALK TO SHEILA and select
        the appropriate option).<./q> "
    //"<p>[Note: typing HINTS OFF will not just disable hints
    //    in the part of this game that contains Sheila, 
    //    but in the entirety of the game.] "
;

maybeAHref(href, txt, doLink) {
  if (doLink)
    return aHref(href, txt);
  else
    return txt;
}

botHintMenu: MenuLongTopicItem
  'Hints'
  location = nbmMenu
  menuContents {
    if (!sessionHintStatus.botHintsDisabled) {
      return
        'In this part of the game, there are indeed hints,
          but they are not accessible via this menu.
          In this part of the game, you<./s>ll have to 
          type HINT at the command prompt 
          (or type TALK TO BOT, and then select 
          the appropriate option). ';
    }
    else { // bot hints disabled
      return
        'In this part of the game, there are indeed hints,
          but they are not accessible via this menu.
          Additionally, you<./s>ve chosen to disable hints 
          for this session, 
          so if you<./s>ve changed your mind, 
          you<./s>ll have to close the game, re-open it,
          and then type HINT at the command prompt 
          (or TALK TO BOT, and then select 
          the appropriate option). ';
    }
  }
;

hintsDisabledInMenu: MenuLongTopicItem
  'Hints'
  location = nbmMenu
  menuContents = (libMessages.sorryHintsDisabled)
;

noHintsFromNbmMenu: MenuLongTopicItem
  'Hints'
  location = nbmMenu
  menuContents = (libMessages.currentlyNoHints)
;

noHintsFromHintWarningMenu: MenuLongTopicItemThatGoesWayBack
  'HINT: Yes, I<./s>m sure. Please give me a hint. '
  heading = 'Hints'
  location = hintWarningMenu
  menuContents {
    sessionHintStatus.hintsDisplayed = true;
    sessionHintStatus.hintWarning = true;
    say(libMessages.currentlyNoHints);
  }
;

hintWarningMenu: MenuItem 'Hints'
  location = nbmMenu
  fgcolor = (location != nil ? location.fgcolor : '#000000')
  bgcolor = (location != nil ? location.bgcolor : '#FFFFFF')
  topbarfg = (location != nil ? location.topbarfg : '#000000')
  topbarbg = (location != nil ? location.topbarbg : '#C0C0C0')
  menuOrder = 41
  doPriorToMenuOptions {
    libMessages.showHintWarningForMenu;
    return true;
  }
  updateContents() {
    topHintMenu.updateContents();
    contents = [
       hintWarningNo
      ,(topHintMenu.contents.length == 0 ? noHintsFromHintWarningMenu : topHintMenu)
      ,hintWarningOff
    ];
  }
;

+ hintWarningNo: MenuLongTopicItemThatGoesWayBack
  'On second thought, let<./s>s hold off on hints for now. '
  heading = 'Hold off on hints for now'
  menuContents {
    "Very well. No hints for now, then! ";
  }
  menuOrder = 10
  selectingMeansGoingBack = true
;

//+ hintWarningYes: MenuLongTopicItem
//  'HINT: Yes, I<./s>m sure. Please give me a hint. '
//  heading = 'Please give me a hint'
//  menuContents =
//    'If this had been an actual menu option, you would 
//      now be getting hints. '
//  menuOrder = 42
//;

+ hintWarningOff: MenuLongTopicItemThatGoesWayBack
  'HINTS OFF: On second thought, please disable hints for this session. '
  heading = 'Disable hints'
  menuContents {
    sessionHintStatus.hintsDisabled = true;
    say(libMessages.hintsDisabled);
  }
  menuOrder = 90
;

/*
copyrightMenu: MenuLongTopicItem 'Copyright'
  location = nbmMenu
  menuContents =
    'This game is copyright 2006 by Greg Boettcher. It is 
        freeware, so you may play it at no charge. 
        You may also copy it and distribute it as much as 
        you want, as long as you don<./s>t charge any
        money for doing so, and as long as you don<./s>t 
        modify the game in any way.
      <p>To contact me for any reason, please write to
        ' + glob.authorEmail + '. '
  menuOrder = 25
;
*/

topHintMenu: TopHintMenu
  title {
    if (goesWayBack)
      return 'HINT: Yes, I<./s>m sure. Please give me a hint. ';
    else
      return 'Hints';
  }
  heading = 'Hints'
  location = nbmMenu
  fgcolor = (location != nil ? location.fgcolor : '#000000')
  bgcolor = (location != nil ? location.bgcolor : '#FFFFFF')
  topbarfg = (location != nil ? location.topbarfg : '#000000')
  topbarbg = (location != nil ? location.topbarbg : '#C0C0C0')
  menuOrder = 40
  goesWayBack = true
  doPriorToMenuOptions {
    if (!sessionHintStatus.hintWarning) {
      sessionHintStatus.hintsDisplayed = true;
    }
    return nil;
  }
;

+ myGoal: Goal 'I<./s>m in the dark. What should I do?'
  [
    'You don<./s>t need to do much. '
   ,'You can try walking off in some direction\ .\ .\ .'
   ,'.\ .\ .\ or standing up\ .\ .\ . '
   ,'.\ .\ .\ or hitting the container you<./s>re in. '
   ,'But all you really need to do is WAIT. '
  ]
  menuOrder = 110
  openWhenSeen = coffin
  closeWhenSeen = confRoom
;

+ Goal 'What should I do in the conference room? '
  [
    'It<./s>s important to listen carefully 
      to the aliens who talk to you here. '
   ,'And when they ask you questions, it is in your
      interest to answer truthfully. '
   ,'Also, don<./s>t forget that you can
      TALK TO ALIENS anytime you want. '
   ,'No matter what you do, the scene ends the same way. 
      The only point here is to gain information. '
  ]
  menuOrder = 120
  //openWhenSeen = confRoom
  //openWhenTrue = (me.isIn(confRoom) && ovan.isIn(confRoom))
  openWhenTrue = (me.hasSeen(confRoom) && !me.hasSeen(dreamRoom))
  closeWhenSeen = cell
;

+ Goal 'What should I do in the cell? '
  [
    'First and foremost, you<./s>ll want to talk to
      your fellow prisoners. There<./s>s a lot you
      can learn from them. '
   ,'Also, investigate all the features of the cell. '
   ,'The bed is there for a reason. You can go to sleep in 
      it\ .\ .\ . '
   ,'.\ .\ .\ but I wouldn<./s>t recommend
      doing that until you<./s>ve done everything else that you
      can do. '
   ,'Also, sooner or later you<./s>ll want to look at 
      the food dispenser. '
  ]
  menuOrder = 130
  openWhenTrue = (me.hasSeen(cell) && !me.hasSeen(dreamRoom))
  //closeWhenSeen = supermazeJ1
  closeWhenTrue = (
    gPlayerChar.hasSeen(beachRoom) ||
    gPlayerChar.hasSeen(emptyRoom)
  )
;

+ Goal 'How can I log in to the food dispensing computer 
         as an administrator? '
  [
    'You<./s>ll never guess the correct password
      on your own. '
   ,'But maybe you could if you had help. '
   ,'Talk to Vicki and Diane. Between the three of you,
      you should be able to guess the right password. '
   //,'Then just USE DISPENSER and log in as an 
   //   administrator. '
  ]
  menuOrder = 140
  openWhenTrue = (glob.knowsAboutFoodLogin)
  closeWhenTrue = (glob.hasLoggedIn)
;

+ Goal 'What should I do in the virtual reality place? '
  [
    'Well, remember that you got into the VR place
      by selecting <.q>Program Nothing but Mazes<./q>
      from the menu. So somehow this area has to do 
      with the creation of Neton and Ovan<./s>s 
      maze game. '
   ,'And it shouldn<./s>t be too hard to figure out 
      that the objects lying around are computer files.
      Try examining them. '
   ,'When you examine the .exe files, you<./s>ll note 
      that you can <.q>run<./q> them. Try it! (But
      save your game first, or be prepared to undo.) '
   ,'As you experiment with the files, bear in mind
      your ultimate goal: either avoid having to play
      the maze game, or else make it so you have a
      reasonable chance of survival once you do play it. '
   ,'If you want, you can leave the VR place and ask
      Vicki and Diane for advice, then come back later.
      However, their knowledge of this place is based
      only on what you tell them, so they can only 
      help you so much. '
   ,'From here on the hints grow progressively more
      spoilerish. '
   ,'Don<./s>t focus on trying to run mazes.exe right
      now. That won<./s>t help. '
   ,'Focus instead on running m9compiler.exe and 
      winnability.exe. Try to figure out what they do. '
   ,'If you try running m9compiler.exe while mazes.m9 
      contains only mazes.m, you<./s>ll only produce 
      the standard, unwinnable version of the game. '
   ,'If, however, you run m9compiler.exe while
      mazes.m9 contains different contents,
      the result will be different. '
   ,'Unfortunately, you can<./s>t compile a version
      of the game that excludes mazes.m.
      If you make a change that radical, the aliens
      will notice the difference later,
      and they<./s>ll know you tampered with the file. '
   ,'But try putting some additional .m files into 
      mazes.m9. Run m9compiler.exe and test the result
      using winnability.exe. '
   ,'Eventually you<./s>ll land on a solution that gives
      you a 30%&ndash;50% chance of victory. That<./s>s
      the best you can hope for. If you can achieve that,
      you will have accomplished your purpose here. '
   ,'The explicit answer follows. '
   ,'GET ALL. PUT ALL IN M9. RUN M9COMPILER.
      RUN WINNABILITY. EXIT. '
  ]
  menuOrder = 150
  openWhenSeen = vrRoom
  //closeWhenSeen = supermazeJ1
  closeWhenTrue = (
    gPlayerChar.hasSeen(beachRoom) ||
    gPlayerChar.hasSeen(emptyRoom)
  )
;

+ Goal 'I got back from the virtual reality place. 
         What should I do now? '
  [
    'First of all, you need to decide if you<./s>ve 
      done all that you need to do in virtual reality. 
      If not, you can always return. '
   ,'After that you need to decide if there<./s>s 
      anything more you need to learn from Vicki and
      Diane. '
   ,'Is there anything else you might need to do
      before you confront the aliens<./s> maze game? '
   ,'No, not really. '
   ,'Once you<./s>ve done all that you intend to do
     for the evening, you need merely LIE ON TOP BUNK
     and SLEEP. '
  ]
  menuOrder = 160
  openWhenTrue = (glob.alreadyReturnedFromVR)
  //closeWhenSeen = supermazeJ1
  closeWhenTrue = (
    gPlayerChar.hasSeen(beachRoom) ||
    gPlayerChar.hasSeen(emptyRoom)
  )
;

+ Goal 
  title =
    ('What should I do ' 
      + (gPlayerChar && gPlayerChar.getOutermostRoom == beachRoom
          ? 'on the beach'
          : 'in the empty room') + '? ')
  menuContents =
  [
    'There<./s>s really only one thing to do:
      use the tablet. '
   ,'Type USE TABLET. '
   ,'Type it again, twice more if necessary, 
      to overcome your character<./s>s
      extreme reluctance to play the aliens<./s>
      maze game. '
  ]
  menuOrder = 164
  openWhenTrue = (
    gPlayerChar.hasSeen(beachRoom) ||
    gPlayerChar.hasSeen(emptyRoom)
  )
  closeWhenSeen = supermazeJ1
;

+ Goal 'Can I get hints on how to solve
         the aliens<./s> maze game? '
  [
    'Yes, but not from this menu. Hints on the
      aliens<./s> maze game are available only by
      talking to Sheila. Type HINT to ask her 
      for a hint. (Or, if you<./s>ve already asked
      for hints, you can also type TALK TO SHEILA
      and select the appropriate conversation 
      option.) '
  ]
  menuOrder = 165
  openWhenSeen = supermazeJ1
  closeWhenSeen = dreamRoom
;

+ Goal 'What special commands are available
         in the aliens<./s> maze game? '
  [
    'You can type RESET (to reset the current puzzle 
        to its initial state), ESCAPE (to escape 
        the current puzzle and return to your 
        previous environment), BEGIN 
        (to restart the aliens<./s> maze game,
        STOP (to stop playing the aliens<./s>
        maze game), or INFO (to get instructions
        on the aliens<./s> maze game. '
  ]
  menuOrder = 166
  openWhenSeen = supermazeJ1
  closeWhenSeen = dreamRoom
;

+ Goal 'How do I avoid getting killed by the aliens?'
  [
    'Your biggest advantage is that you<./s>re in 
      a different room than Neton and Ovan,
      and your room isn<./s>t directly connected to 
      theirs. This gives you a chance to escape. '
   ,'Unfortunately, running away is not enough.
      You have to find a way to fight the aliens. '
   ,'There is one obvious place with more 
      than ample resources with which to fight
      the aliens. '
   ,'You<./s>ll have to find the museum. '
   ,'Some guns in the museum are ineffective, while
      others work quite well. I<./s>ll let you 
      find this out for yourself by examining the 
      various pedestals in the museum. '
   ,'Unfortunately, there<./s>s a problem. 
      Even with all the guns in the museum, 
      you won<./s>t be able to kill the aliens 
      if you don<./s>t have enough time to do so. '
   ,'The challenge, then, is not simply killing 
      all the aliens, but doing so <i>before
      they have a chance to kill you.</i> '
   ,'It is recommended that you make full 
      use of the RETRY command here, or if that fails,
      then save your game when you safely enter the
      dream room, then restore as needed.
      That way, you can feel free to experiment
      and explore. Look at all the things in the rooms 
      you pass through. '
   ,'And don<./s>t just look at the stuff 
      in the museum. Check out the stuff in
      the hallway, too, for example. '
   ,'That button in the southeastern part of the 
      hallway looks interesting. '
   ,'Push it, then type <.q>yes<./q> to confirm
      that you want to activate the slowing field.
      That seems helpful, doesn<./s>t it? '
   ,'With the slowing field activated, the aliens 
      will move only about 1/12 of their previous speed. '
   ,'That will give you a lot more time to pick
      them off with the gun of your choice. Also
      a lot more time to make that choice. '
   ,'Hopefully at this point you will have no problem
      executing all of your would-be alien assassins.
      It<./s>s payback time! '
   ,'I said I wouldn<./s>t help you pick out guns,
      but okay, here goes\ .\ .\ . 
      the most effective guns are the particle gun, 
      the pulse gun, the silenced pistol, 
      and the photonic disrupter. 
      Also effective are the electric pistol,
      shotgun, and phaser.
      But that<./s>s not all. 
      A few other museum artifacts can also be used
      to good effect. In fact, the most entertaining
      methods of execution are not mentioned 
      in this hint menu. '
   ,'Note: Actually, there is one way of killing
      all the aliens without ever turning on the 
      slowing field. I doubt many people will find 
      this solution, but I leave it in the game
      as an Easter egg, one which is entirely logical,
      but will, I suspect, not be found by many people. '
  ]
  menuOrder = 170
  openWhenSeen = dreamRoom
  closeWhenTrue = (
    !neton.realLocation &&
    !ovan.realLocation &&
    !oldGuard.realLocation &&
    !youngGuard.realLocation &&
    !assistant.realLocation
  )
;

+ Goal 'I got rid of all the aliens. What now? '
  [
    'You could always just leave the building\ .\ .\ . '
   ,'. . . but I wouldn<./s>t recommend doing so until
      you make sure there<./s>s nothing important
      you still need to do in the building. '
   ,'Like rescuing Vicki and Diane, for instance. '
   ,'If your exploring still leaves you without
      a clue as to where Vicki and Diane 
      might be, try focusing your search 
      on the southwest part of the building. '
   ,'There is also one more thing you might consider
      doing. '
   ,'You might also consider hunting for Easter eggs
      (that is, hidden game features that are fun to find, 
      but not at all necessary for victory). 
      There are a lot of them in this part of the game. '
  ]
  menuOrder = 180
  openWhenTrue = (
    me.hasSeen(dreamRoom) &&
    !neton.realLocation &&
    !ovan.realLocation &&
    !oldGuard.realLocation &&
    !youngGuard.realLocation &&
    !assistant.realLocation
  )
  //closeWhenTrue = nil
;

+ Goal 'How do I open the locked door in the southwest
         part of the building? '
  [
    'If you examine the door, you<./s>ll find that 
      there is a slot right next to it. '
   ,'It seems reasonable to guess that a keycard 
      might be put in that slot. '
   ,'Where might such a keycard be hidden? '
   ,'Here<./s>s a small hint: you needn<./s>t search
     the aliens<./s> dead bodies for the keycard;
     none of them were carrying it. '
   ,'Try searching the office instead. '
   ,'Try searching the desks. '
   ,'Try searching Ovan<./s>s desk. '
   ,'Try searching the loose papers in Ovan<./s>s desk
      drawer. The keycard should be there. '
  ]
  menuOrder = 190
  openWhenTrue = (cellDoor2.hasClearlyBeenLocked)
  closeWhenTrue = (keycard.obviouslyUnlocks)
;


