/* Copyright (c) 1998 by Michael J. Roberts.  All Rights Reserved. */
/*
Name
  plantwh.t - warehouse section
Function
  
Notes
  
Modified
  08/10/98 MJRoberts  - Creation
*/


/* ------------------------------------------------------------------------ */
/*
 *   Entry to warehouse 
 */

warehouse: room
    sdesc = "Building"
    south = warehouse_door
    out = warehouse_door
    ldesc = "This cavernous space is broken up only by a few vertical
             steel beams supporting the roof high above.  A diffuse yellow
             glow from pale lights suspended from above filters down
             through the thick dust hanging in the air.
             \n\tRows of drab gray metal desks extend off in all
             directions, separated by just enough space to form aisles.
             On each desk is a ragged pile, several feet high, of
             assorted papers, and a small machine of some kind.
             Some of the piles of paper are narrow,
             precariously balanced columns, others are mounds; a few
             have fallen over, scattering papers across the floor.
             \n\tA large door (currently <<
             warehouse_door.isopen ? "open" : "closed" >>) to the south
             leads out of the building.  The area near the door, where
             you're standing, is clear of desks, and instead is mostly
             open, except for a huge workbench.  Several huge burlap
             sacks full of envelopes are piled alongside the workbench. "
    up =
    {
        "There's no way to go up. ";
        return nil;
    }
    down =
    {
        "There's no way to go down. ";
        return nil;
    }
    noexit =
    {
        "The aisles between the desks are so narrow, and the piles of
        papers so precarious, that you don't want to risk disturbing
        anything by wading into the sea of desks. Besides, it doesn't
        look as though there's anything different from one place to
        another in here. ";
        return nil;
    }
;

warehouse_desks: distantItem
    noun = 'desk' 'desks' 'row' 'rows'
    adjective = 'drab' 'gray' 'metal'
    sdesc = "desk"
    location = warehouse
    ldesc = "The desks are arranged in closely-spaced rows stretching
             off in all directions.  Each of the desks has a huge heap
             of papers on one side, and a small machine
             on the other. "
;

warehouse_papers: distantItem
    noun = 'paper' 'papers' 'pile' 'piles' 'heap' 'heaps'
           'columns' 'mound' 'mounds'
    adjective = 'ragged' 'huge'
    location = warehouse
    sdesc = "papers"
    adesc = "papers"
    isThem = true
    ldesc = "The piles look random; they're composed of papers of
             all sizes and colors. "
;

warehouse_machines: distantItem
    noun = 'machines' 'punch' 'keyboards' 'typewriters'
    adjective = 'small' 'card' '335'
    location = warehouse
    sdesc = "machine"
    teeterDescribed = nil
    ldesc =
    {
        "The machines look a little like typewriters, but they have
        strange keyboards, and the paper-feeding mechanisms don't look
        like they're for paper.";

        if (teeterwaller.isIn(self.location) && !self.teeterDescribed)
        {
            self.teeterDescribed := true;
            "\b<q>Those are card punch three-three-five's,</q> Teeterwaller
            says, sounding surprised.  It takes you a moment to figure out
            what he means, then you realize he's talking about a model
            number, something like Card Punch 335&trade;.  <q>I haven't
            seen one of these in <i>years</i>,</q> he says.  You're
            afraid he's going to go off on one of his tangents about the
            good old days of computing when <i>real</i> programmers had
            to key in the operating system in binary with their toes, but
            he just looks fondly at the machines. ";
        }
    }
;

warehouse_door: warehouseDoorClass
    location = warehouse
    doordest = driveway
    otherside = driveway_door
    ldesc =
    {
        inherited.ldesc;
        "\bAbove the door is an electric motor that lifts the
        door, and next to the motor is a small black box. ";
    }
;

warehouse_motor: distantItem
    location = warehouse
    noun = 'motor'
    adjective = 'electric'
    adesc = "an electric motor"
    sdesc = "electric motor"
    ldesc = "It's the device that opens and closes the door.  Next to
             the motor is a small black box. "
;

warehouse_blackbox: barcodeBaseItem, distantItem
    location = warehouse
    noun = 'box' 'antenna' 'wire' 'wires'
    adjective = 'small' 'black'
    ldesc = "Several wires run from the box to the motor, and a short
             antenna sticks up out of the top of the box.  On the side
             of the box is a white adhesive label with a bar code printed
             on it. "
    scanCode = { return warehouse_blackboxBarCode.scanCode; }
;

warehouse_blackboxBarCode: barcodeItem, distantItem
    location = warehouse
    sdesc = "black box bar code"
    noun = 'label'
    adjective = 'white' 'adhesive' 'black' 'box'
    ldesc = "The label is printed with a bar code.  It has no numbers
             or letters, only the series of parallel black lines of
             varying widths. "
    scanCode = '2.57'
;

warehouse_beams: decoration
    noun = 'beam' 'beams'
    adjective = 'steel' 'vertical'
    location = warehouse
    sdesc = "steel beams"
    isThem = true
    adesc = "a steel beam"
;

warehouse_roof: decoration
    noun = 'roof' 'ceiling'
    location = warehouse
    sdesc = "roof"
;

warehouse_lights: decoration
    noun = 'light' 'lights'
    adjective = 'pale' 'yellow'
    location = warehouse
    sdesc = "yellow light"
;

warehouse_sacks: fixeditem
    noun = 'sack' 'sacks' 'bag'
    adjective = 'burlap' 'huge'
    location = warehouse
    sdesc = "burlap sack"
    ldesc = "About ten large burlap sacks are piled haphazardly beside
             the workbench.  They're all filled to overflowing with
             envelopes. "
    verIoPutIn(actor) =
    {
        "The sacks are already full; besides, if you put anything
        in them, it would just get lost among the envelopes. ";
    }
    verDoTake(actor) = { "You don't want to disturb someone else's mail. "; }
    verDoOpen(actor) = { "The sacks are already open. "; }
    verDoClose(actor) = { "You see no reason to disturb them. "; }
    verDoLookin(actor) = { }
    doLookin(actor) =
    {
        "The sacks contain large quantities of envelopes. ";
    }
    doSynonym('Lookin') = 'Search'
;

warehouse_envelopes: fixeditem, readable
    noun = 'envelopes' 'letters'
    sdesc = "envelopes"
    adesc = "any envelopes"
    isThem = true
    location = warehouse
    verDoTake(actor) =
    {
        "You have no use for the envelopes; besides, you wouldn't
        want to steal someone else's mail. ";
    }
    ldesc = "There are far too many envelopes for a thorough examination,
             but you pick a few at random, and find that they're all
             addressed to different products' rebate offers: Healthy
             Concern Low-Fat Cr&egrave;me Br&ucirc;l&eacute;e Frozen
             Dessert $1.51 Rebate Offer, Gazette SonarTrac Razor 3-Pack
             $2.15 Mail-In Rebate Offer, Sergeant Sweet's Peanut Butter
             Sweet with Chocolaty Chips and Macadamia Nuts 44 Ounce
             Breakfast Cereal $3.77 Rebate Offer, ToxiCola
             24-Pack $1.01 Mail-In Rebate Offer, Mrs.\ Palfrey's Olde-Tyme
             Naturally and Artificially Flavoured Snacking Cones $2.35
             Rebate Offer, Blowiger's Very Fine Teas $0.90 Rebate Offer,
             Shane's No-Spill Men's 100% Cotton Briefs $2.80 Mail-In
             Rebate Offer, and many more.  Even though each envelope
             is for a different product's rebate offer, they
             all have the same address: PO Box 2004, Conners City. "
;

warehouse_workbench: fixeditem, surface
    sdesc = "workbench"
    noun = 'workbench' 'bench'
    adjective = 'work' 'huge'
    location = warehouse
    ldesc =
    {
        "The workbench is very wide, and dominates the entire open area
        near the door.  On closer inspection, you see that it's not
        merely a workbench, but is actually a machine of some kind.
        In the center of surface of the workbench is a rectangular
        depression, about the size of a coffee-table book and about
        four inches deep, lined at the bottom with little gears and
        wheels; ";

        /* list the contents of the depression */
        if (itemcnt(warehouse_workbenchDepression.contents) <> 0)
            "it contains <<listcont(warehouse_workbenchDepression)>>. ";
        else
            "it's currently empty. ";

        "Sticking out of the front of the workbench, roughly under the
        top depression, is a metal basket, of roughly the same dimensions
        as the depression, placed in front of a chute coming out of
        the workbench; ";

        /* list the contents of the basket */
        if (itemcnt(warehouse_workbenchBasket.contents) <> 0)
            "the basket contains <<listcont(warehouse_workbenchBasket)>>. ";
        else
            "the basket is empty. ";

        "\bOn top of the workbench, near the depression, is a knob that
        looks like the channel dial on a really old television; the knob
        can be set to values from 0 to 7, and is currently set
        to << warehouse_workbenchKnob.setting >>.  Next to the knob
        is a black push-button. ";
        
        /* 
         *   inherit the default ldesc, which will list anything sitting
         *   on the workbench 
         */
        "\b";
        inherited.ldesc;
    }
;

warehouse_workbenchKnob: dialItem
    location = warehouse_workbench
    noun = 'knob' 'dial'
    sdesc = "knob"
    minsetting = 0
    maxsetting = 7
    setting = 0
    ldesc = "The knob looks like the mechanical channel dials on
             old televisions.  It can be set to positions numbered
             from 0 to 7; it's currently set to << self.setting >>. "
;

warehouse_workbenchButton: buttonitem
    location = warehouse_workbench
    noun = 'button' 'pushbutton' 'push-button'
    adjective = 'black'
    sdesc = "black push-button"
    ldesc = "It's a big, heavy mechanical button. It reminds you of a
             <q>Push For Walk</q> button on a traffic light at a crosswalk. "
    doPush(actor) =
    {
        "The machine inside the workbench grinds into action. ";
        if (warehouse_deck.location = warehouse_workbenchDepression)
        {
            "Waves of motion start rippling through the cards sitting
            in the depression, and they all vibrate rapidly.  The
            machinery makes more and more noise until the whole
            workbench is vibrating wildly.  Suddenly, the cards start
            disappearing into the machinery, and after a few moments
            the entire deck has been sucked inside the workbench.
            \bThe workbench impossibly gets even louder, and starts
            making bangs and clunks at irregular intervals&mdash;<i>clunk...
            whir... bang-bang-bang-clunk... whir... clunk-bang...
            clunk... bang-bang... whir...</i>
            \bSuddenly, the cards start issuing from the chute at
            incredible speed and lining up neatly in the basket.
            It only takes a few seconds before the entire deck has been
            reassembled.
            \bThe noise from the machinery starts to subside, falling
            in both pitch and volume as the gears and flywheels coast
            to a halt within the workbench.  The machine eventually
            becomes quiet and still. ";

            /* move the deck into the basket */
            warehouse_deck.moveInto(warehouse_workbenchBasket);

            /* set the sort column according to our dial setting */
            if (warehouse_workbenchKnob.setting <
                length(warehouse_deck.columnNames))
            {
                /* sort by the column of the knob (noting 0 base for knob) */
                warehouse_deck.sortColumn :=
                    warehouse_workbenchKnob.setting + 1;
            }
            else
            {
                /* invalid column; sort by nothing */
                warehouse_deck.sortColumn := nil;
            }
        }
        else
        {
            "Gears inside the depression on top of the workbench start
            spinning, and little levers and paddles come poking out of
            recessed areas inside the depression.  The machine makes
            a tremendous amount of noise and vibrates wildly.
            \bAfter
            twenty or thirty seconds, the noise starts to subside,
            and the machine gradually shuts itself off.  The noise
            falls to a hum as internal flywheels and gears coast to
            a halt, and finally the machinery is quiet and still. ";
        }
    }
;

warehouse_workbenchBasket: fixeditem, qcontainer
    noun = 'basket'
    adjective = 'workbench' 'metal'
    sdesc = "basket"
    location = warehouse_workbench
    verIoPutIn(actor) =
    {
        if (itemcnt(self.contents) != 0)
            "The basket is only large enough to hold one item at a time. ";
    }
;

warehouse_workbenchDepression: fixeditem, qcontainer
    noun = 'depression' 'hole'
    sdesc = "depression"
    location = warehouse_workbench
    verIoPutIn(actor) =
    {
        if (itemcnt(self.contents) != 0)
            "The depression is only large enough to hold one
            item at a time. ";
    }
;

warehouse_workbenchChute: fixeditem
    noun = 'chute' 'gears' 'gear' 'sprockets' 'wheel' 'wheels'
    sdesc = "chute"
    location = warehouse_workbench
    ldesc = "The chute goes up into the machine. "
    verDoLookin(actor) = { }
    doLookin(actor) =
    {
        "All you can see is a dense array of gears and sprockets. ";
    }
    doSynonym('Lookin') = 'Search'
    verDoPutIn(actor) =
    {
        "The chute is too clogged with machinery to put anything
        into it. ";
    }
;

warehouse_page: readable, barcodeBaseItem
    noun = 'page' 'paper' 'piece'
    adjective = 'looseleaf'
    sdesc = "looseleaf page"
    location = warehouse_workbench
    ldesc = "It's an 8&frac12;-by-11 page with holes punched in the margin;
             it must have fallen out of a three-ring binder. "
    readdesc = "\b\b<tt><center><b>Rebate Processing Manual -- Program
                Details</b></center>
                <br height=3><b>ITEM:</b> Gazette SonarTrack Razor 3-Pack
                \b<b>REBATE AMOUNT:</b> $2.15
                \b<b>UPC:</b> 20300273
                \b\b<b>IMPORTANT:  Verify all UPC bar-code symbols with
                scanner.</b>
                </tt>\bBelow this is a bar code, of the same type that
                you see on packages in the supermarket, with the number
                20300273 written in computer-style block numerals just
                below the vertical bars. "
    scanCode = { return warehouse_page_barcode.scanCode; }
;

warehouse_page_barcode: barcodeItem, fixeditem
    sdesc = "looseleaf page bar code"
    adjective = 'looseleaf' 'page'
    location = warehouse_page
    ldesc = "The bar code consists of a series of vertical bars of
             varying thickness, with the number 20300273 written just below
             the bars in computer-style block numerals. "
    scanCode = '2.15'
;

warehouse_deck: readable
    location = warehouse_workbenchBasket
    noun = 'card' 'cards' 'deck' 'stack' 'hole' 'holes'
    adjective = 'thick' 'punched' 'square' 'neat' 'little'
    sdesc = "deck of punched cards"
    sortColumn = 1
    columnNames = ['first' 'second']
    ldesc =
    {
        "The deck is ten inches thick and must contain
        thousands of cards&mdash;far too many to examine
        individually.  Each card has numerous neat little
        square holes randomly dispersed across the card, and
        a series of numbers printed across the top, corresponding
        to the punched holes.  The numbers are arranged into
        groups: the first group has eight digits; the second group
        has one or two digits, then a decimal point, then two more
        digits.
        \bGlancing through the deck, ";

        if (self.sortColumn = nil)
            "you can detect no apparent ordering; they're just
            randomly arranged in the deck, which would make it
            next to impossible to find a particular number in
            the deck. ";
        else
            "you notice that the cards are sorted by
            the << self.columnNames[self.sortColumn] >> group
            of numbers, which would make it easy to find a
            particular number of that group in the deck. ";

        /* mark myself as seen when first examined */
        self.isseen := true;
    }
    verIoFindIn(actor) = { }
    ioFindIn(actor, dobj) =
    {
        if (self.sortColumn = nil)
        {
            "The cards don't seem to be in any particular order.
            It would take forever to search the deck exhaustively. ";
            return;
        }
        
        if (dobj = strObj)
        {
            local cur, len;
            local ch;
            local has_dot := nil;

            /* ensure that it's a number, possibly with a decimal point */
            len := length(strObj.value);
            for (cur := 1 ; cur < len ; ++cur)
            {
                ch := substr(strObj.value, cur, 1);
                if ((ch < '0' || ch > '9') && ch != '.')
                {
                    "The cards don't appear to contain any information in
                    that format. ";
                    return;
                }
                if (ch = '.')
                    has_dot := true;
            }
             
            /* check the format */
            if (length(strObj.value) = 8)
            {
                self.lookUp8(strObj.value);
            }
            else if (has_dot)
            {
                self.lookUpDot(strObj.value);
            }
            else
            {
                "The cards don't appear to contain any information
                in that format. ";
            }
        }
        else if (dobj = numObj)
        {
            local str;
            
            /* get the original string value they typed in */
            str := objwords(1)[1];

            /* check the format */
            if (length(str) = 8)
            {
                self.lookUp8(str);
            }
            else
            {
                "The cards don't appear to contain any information
                in that format. ";
                return;
            }
        }
        else
            "That doesn't seem to be hidden in the deck of cards anywhere. ";
    }

    /* list of valid card combinations */
    cardCombos = [
                  ['55567562' '2.57']                     /* warehouse door */
                  ['42325515' '4.71']                         /* ditch gate */
                  ['77140503' '1.51']     /* healthy concern frozen dessert */
                  ['20300273' '2.15']                  /* gazette SonarTrac */
                  ['41531454' '3.77']                     /* sergeant sweet */
                  ['55432473' '1.01']                           /* toxicola */
                  ['57513331' '2.35']                     /* mrs. palfrey's */
                  ['33265157' '0.90']                    /* blowiger's teas */
                  ['57263127' '2.80']              /* shane's cotton briefs */
                 ]

    /* look up an 8-digit number */
    lookUp8(str) =
    {
        self.lookUpString(str, 1);
    }

    /* look up a number with a decimal point */
    lookUpDot(str) =
    {
        self.lookUpString(str, 2);
    }

    /* look up a string in the given column */
    lookUpString(str, col) =
    {
        if (self.sortColumn = col)
        {
            local cur;
            local len;
            
            /* scan the "cards" for a match */
            len := length(self.cardCombos);
            for (cur := 1 ; cur <= len ; ++cur)
            {
                /* if this matches the desired column, report it */
                if (self.cardCombos[cur][col] = str)
                {
                    /* report the contents of the card */
                    "The cards are sorted, so you easily flip through the
                    deck to where << str >> should be.  You find a card
                    that looks like this:
                    \b\t<tt><<self.cardCombos[cur][1]>>
                    \t\t<<self.cardCombos[cur][2]>></tt>";
                    
                    /* we're done - no need to look any further */
                    return;
                }
            }

            /* we didn't find it - note the failure */
            "Since the cards are sorted, you easily flip through the
            deck to where << str >> should be, but you don't find
            a card with that value. ";
        }
        else
        {
            /* report that we're not sorted on the column */
            self.lookUpFailed(col);
        }
    }

    /* say that the cards aren't sorted by a particular column */
    lookUpFailed(desiredCol) =
    {
        "That number would go in the <<self.columnNames[desiredCol]>> column,
        but the cards don't appear to be in any particular order on that
        column; ";
        if (self.sortColumn = nil)
            "the cards seem to be randomly arranged in the deck. ";
        else
            "the cards are sorted in ascending order of the <<
            self.columnNames[self.sortColumn]>> column. ";
        "It would take forever to search the cards exhaustively. ";
    }
    
    ioSynonym('FindIn') = 'LookupIn' 'SearchforIn'
    verDoSearchFor(actor, iobj) = { }
    doSearchFor(actor, iobj) = { self.ioFindIn(actor, iobj); }
    verDoSearch(actor) =
    {
        "Given the number of cards, an exhaustive search is out of the
        question.  However, you could probably search for a particular
        number in the cards. ";
    }
;

