
/*****************************************************************************
*													Footnotes
*		To enter footnotes for an item or location, include 
*	<<note(x)>> in the location of the desc that you want
*	the footnote reference to appear. In object 'x' place
* method footnote = {"Footnote text";}. This will be printed
* when player types 'note y'. Numbers are generated 
* automatically. For a hand numbered footnote, add footnum = x 
*	where x = specific footnote number. You may not place multiple
*	footnotes in the same object. Make a reference object 
*	(ie. objnote: object) with a footnote method in it. 
*
****************************************************************************/
 

replace commonInit: function
{
	local o;
	for (o := firstobj(); o <> nil; o := nextobj(o))
	{
		if (defined(o, &footnote))
		{
			global.footnotelist += o;
			if (defined(o, &footnum))
				if (o.footnum <> nil)
					global.footavoid += o.footnum;
		}
	}
}
;

modify global
	footnumber = 1
	footnotelist = []
	footavoid = []
;

modify basicNumObj
	verDoFootnote(actor) = {}
  doFootnote(actor) = 
  {
    printnote(self.value);
  }
;
 
footnoteVerb: sysverb
  sdesc = "get footnote information for"
  verb = 'footnote' 'note'
  doAction = 'Footnote'
;  
	
printnote: function(num)
{
  local i, o, len;
  len := length(global.footnotelist);
  for (i := 1; i <= len; i++) 
  {
    o := global.footnotelist[i];
    if (o.footnum = num)
    {
      "[\(<<num>>\)]:\ <<o.footnote>>";
      return;
    }
  }
  "No such footnote.";
}

note: function(o)
{
  if (o.footnum = nil) 
  {
    for (;;) 
    {
      o.footnum := global.footnumber;
      global.footnumber++;
      if (find(global.footavoid, o.footnum) = nil)
        break;
    }
  }
  "[\(<<o.footnum>>\)]";
  return '';      /* so we can use inside << ... >> */
}

//************************************************************

// For testing purposes only. Comment out during final build

ftnumVerb: sysverb
	verb = 'num' 'notenum'
	sdesc = "get numbers in global.footavoid list"
	action(actor) = 
	{
		"Current global.footnumber : <<global.footnumber>> \n";
		"Current off-limit footnote numbers : \n";
		footlist();
	}
;

footlist: function
{
	local ind;
	local len := length(global.footavoid);
	for (ind := 1; ind <= len; ind++ )
	{
		"<<global.footavoid[ind]>>";
		"\n";
	}
}

//***************************************************************/

