/* --------------------------------------------------------------------

sample.t

A simple sample game to demonstrate outputFilter.t

-------------------------------------------------------------------- */

#define USE_HTML_PROMPT
#define USE_HTML_STATUS

#include <adv.t>
#include <std.t>

#include "outputFilter.t"

#pragma C+

// A simple room which uses some of our fancy formatting stuff.

startroom: room
	sdesc = "Adventurer's Showroom"
	ldesc = "Are \\b's and \\t's driving you batty?
		Are you gnashing your teeth over en- and em-dashes?
		Want curly 'postrophes, but feeling enervated by &entities;?
		^~Well... what you need is an _output filter_!		
		^~And it's your lucky day, 'cos I just happen to have one
		here for you right now. Go on, take her for a spin---and I
		just _know_ you'll be just a-mazed!
		^~(The <q>filter</q> command toggles output filtering,
		so that you can see what's going on. You can also use
		<q>space</q> and <q>indent</q> to adjust the paragraph
		spacing.)" ;
;

replace version: object
	sdesc = "\b<B>Output Filter Sample Game Thingy</B>
		\nAn interactive, uh, sample by Iain Merrick\b\b" ;
;

// Implementation of the 'filter' command.

filterVerb: sysverb
	sdesc = "filter"
	verb = 'filter'
	action(actor) =
	{
		if (global.filter)
		{
			"Output filtering now off.";
			global.indent = nil;
			setOutputFilter (nil) ;
		}
		else
		{
			"Output filtering now on.";
			global.indent = true;
			setOutputFilter (&outputFilter) ;
		}
		abort ;
 	}
;

modify global
	filter = true
;

// commonInit() is called both from init() and
// initRestore(), so it's a handy hook from which
// to hang handy stuff:

replace commonInit: function
{
	"\H+" ;
	
	if (global.filter)
		setOutputFilter (&outputFilter) ;
	else
		setOutputFilter (nil) ;
}

// Modify the basic 'room' class to use our fancy
// paragraph-spacing mechanism, and also to print
// room names in boldface.

modify room
	dispParagraph = "^~"
	dispBeginSdesc = "\("
	dispEndSdesc = "\)"
;

// There's still an annoying double blank line before
// the prompt when doublespacing is on, but I can't
// get rid of that without some rather more complicated
// modifications to adv.t. Bah.
