////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: DarkRoomTravelable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DARK_ROOM_TRAVELABLE_H_
#define _DARK_ROOM_TRAVELABLE_H_

#include <roomtravelable.h>
#include <darktravel.t>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  DarkRoomTravelable: RoomTravelable
 *
 *  Rules for travelling, boarding and unboarding, in a DarkRoom-style
 *  room.
 */
class DarkRoomTravelable: RoomTravelable    
    noExit = {
        if (self.isLit(gActor()))
            pass noExit;
        else {
            darkTravel();
            return nil;
        }
    }
;

#pragma C-

#endif /* _DARK_ROOM_TRAVELABLE_H_ */
