////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Decoration 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DECORATION_H_
#define _DECORATION_H_

#include <fixeditem.h>

#pragma C+

/*
 *  Decoration: FixedItem
 *
 *  An Item that doesn't have any function in the game, apart from
 *  having been mentioned in the room description.  These Items
 *  are immovable and can't be manipulated in any way, but can be
 *  referred to and inspected.  Liberal use of Decoration Items
 *  can improve a game's playability by helping the parser recognize
 *  all the words the game uses in its descriptions of Rooms.
 */
class Decoration: FixedItem
    lDesc = "\^<<self.thatDesc>> <<self.isntDesc>> important."
    dobjGen(a, v, i, p) = {
        if (v != inspectVerb) {
            "\^<<self.theDesc>> <<self.isntDesc>> important.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        "\^<<self.theDesc>> <<self.isntDesc>> important.";
        exit;
    }
;

#pragma C-

#endif /* _DECORATION_H_ */
