////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: EnterableOpenable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ENTERABLE_OPENABLE_H_
#define _ENTERABLE_OPENABLE_H_

#include <enterable.h>
#include <openable.h>

#pragma C+

/*
 *  EnterableOpenable: Enterable, OpenableContainer
 *
 *  This is an object that an actor can board, opening and closing the
 *  object. This class is useful for making boxes, sleeping bags, and 
 *  other locations for the actor that act as independent locations when
 *  closed and like NestedRooms when open.
 */
class EnterableOpenable: Enterable, OpenableContainer
    roomCheck(v) = {   
    	if (v == openVerb)
    		return true;
    	else pass roomCheck;
    }
    roomAction(a, v, d, p, i) = {
        if (v == openVerb && d == self)
            return;
        else pass roomAction;
    }
    doClose(actor) = {
        if (actor.isIn(self)) {
            inherited Openable.doClose(actor);
            "\b";
            self.lookAround(true);
        } else pass doClose;
    }

    doOpen(actor) = {
        if (actor.isIn(self)) {
            inherited Openable.doOpen(actor);
            "\b";
            self.lookAround(true);
        } else pass doOpen;
    }
    verDoBoard(actor) = {
        if (!self.isOpen)
        	"%You%'ll have to open <<self.theDesc>> first!";
    	else pass verDoBoard;
    } 	
    verDoUnboard(actor) = {
        if (!actor.location.isOpen)
    		"%You%'ll have to open <<self.theDesc>> first!";
		else pass verDoUnboard;
    }
    out = {
        if (self.isOpen)
            pass out;
        else {
            "%You%'ll have to open <<self.theDesc>> first!";
            return nil;
        }
    }
;

#pragma C-

#endif /* _ENTERABLE_OPENABLE_H_ */
