////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Fixture 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _FIXTURE_H_
#define _FIXTURE_H_

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy. 
 *--------------------------------------------------------------------*/

/*
 *  Fixture: object
 *
 *  An object that cannot be taken or otherwise moved from its location.
 *  Fixtures do not appear in general listings for rooms or inventories.
 */
class Fixture: object      // An immovable object
    isFixed = true          // Item can't be taken
    isListed = nil          // not listed in room/inventory displays
    verDoDrop(actor) = {
        "%You% can't drop _dobj_. ";
    }
    verDoMove(actor) = {
        "%You% can't move _dobj_. ";
    }
    verDoPutIn(actor, io) = {
        "%You% can't put _dobj_ anywhere. ";
    }
    verDoPutOn(actor, io) = {
        "%You% can't put _dobj_ anywhere. ";
    }
    verDoTake(actor) = {
        "%You% can't have _dobj_. ";
    }
    verDoTakeOff(actor, io) = {
        self.verDoTake(actor);
    }
    verDoTakeOut(actor, io) = {
        self.verDoTake(actor);
    }
    verDoThrowAt(actor, iobj) = {
        "%You% can't throw _dobj_.";
    }
;

#pragma C-

#endif /* _FIXTURE_H_ */
