////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Integer 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _INTEGER_OBJ_H_
#define _INTEGER_H_

#pragma C+

/*
 *  Integer: object
 *
 *  This object provides a default implementation for numObj.
 *  To use this default unchanged in your game, include in your
 *  game this line:  "numObj: Integer".
 */
class Integer: object   // when a number is used in a player command,
    value = 0               //  this is set to its value
    sDesc = "<<value>>"
    aDesc = "a number"
    theDesc = "the number <<value>>"
    verDoTypeOn(actor, io) = {}
    doTypeOn(actor, io) = { "\"Tap, tap, tap, tap...\" "; }
    verIoTurnTo(actor) = {}
    ioTurnTo(actor, dobj) = { dobj.doTurnTo(actor, self); }
;

/*
 *   The numObj object is used to convey a number to the game whenever
 *   the player uses a number in his command.  For example, "turn dial
 *   to 621" results in an indirect object of numObj, with its "value"
 *   property set to 621.
 */
numObj: Integer
;

#pragma C-

#endif /* _INTEGER_H_ */
