////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Stringizer 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _STRINGIZER_H_
#define _STRINGIZER_H_

#pragma C+

/*
 *  The Stringizer class converts a word list to a string. In addition
 *  it handles the conversion of TADS special words and the appending of 
 *  actor vocabulary to the front of the string to create a command
 *  string.
 */
class Stringizer: object
    buildCmdString(actor, cmdWordList) = {
        local actorWordList, actorString, cmdWordString, cmdString;
        
        cmdWordList = self.cvtFromSpec(cmdWordList);
        cmdWordString = self.stringize(cmdWordList);
        cmdWordString = self.cvtFromCompound(cmdWordString);
     
    /*
     *  NOTE: getActorVocab() assumes that the actor isn't numbered. If
     *  you find yourself having difficulty with this option #define 
     *  USE_ACTOR_sDesc.
     */
#ifdef USE_ACTOR_sDesc
     
        actorString = self.getActorsDesc(actor);
        
#else /* USE_ACTOR_sDesc */
        
        actorWordList = self.getActorVocab(actor);
        actorString = self.stringize(actorWordList);
        
#endif /* USE_ACTOR_sDesc */
        
        cmdString = actorString + ', ' + cmdWordString;
        return cmdString;
    }
    cvtFromSpec(wordList) = {
        local i, len;
        
        len = length(wordList);
        for (i = 1; i <= len; ++i) {
            switch(wordList[i]) {
                case ',':
                    wordList[i] = 'and';
                    break;
                case 'A':
                    wordList[i] = 'all';
                    break;
                case 'X':
                    wordList[i] = 'but';
                    break;
                case 'I':
                    wordList[i] = 'it';
                    break;
                case 'T':
                    wordList[i] = 'them';
                    break;
                case 'M':
                    wordList[i] = 'him';
                    break;
                case 'R':
                    wordList[i] = 'her';
                    break;
                case 'Y':
                    wordList[i] = 'any';
                    break;
                case 'B': 
                    wordList[i] = 'both';
                    break;
                case 'N':
                    wordList[i] = 'one';
                    break;
                case 'P':
                    wordList[i] = 'ones';
                    break;
            }
        }
        return wordList;
    }
    cvtFromCompound(str) = {
        str = replaceWith(str, '%<onto%>', 'on to');
        str = replaceWith(str, '%<into%>', 'in to');
        str = replaceWith(str, '%<inbetween%>', 'in between');
        str = replaceWith(str, '%<downin%>', 'down in');
        str = replaceWith(str, '%<downon%>', 'down on');
        str = replaceWith(str, '%<upon%>', 'up on');
        str = replaceWith(str, '%<outof%>', 'out of');
        str = replaceWith(str, '%<offof%>', 'off of');
        str = replaceWith(str, '%<i_wide%>', 'i wide');
        str = replaceWith(str, '%<i_tall%>', 'i tall');
        str = replaceWith(str, '%<waitfor%>', 'wait for');
        str = replaceWith(str, '%<waituntil%>', 'wait until');
        return str;
    }
    stringize(wordList) = {
        local i, len, str = '';
        
        len = length(wordList);
        
        for (i = 1; i <= len; ++i) {
            str += wordList[i];
            if (i != len)
                str += ' ';
        }
        return str;
    }
    getActorsDesc(actor) = {
        local stat, str, actorWordList;
        if (actor == parserGetMe()) {
            actorWordList = self.getActorVocab(actor);
            str = self.stringize(actorWordList);
        } else {
            stat = outcapture(true);
            actor.sDesc;
            str = outcapture(stat);
        }
        return str;
    }
    getActorVocab(actor) = {
        local actorWordList = [];
        
        actorWordList += getwords(actor, &adjective);
        if (actor.isThem)
            actorWordList += getwords(actor, &plural)[1];
        else actorWordList += getwords(actor, &noun)[1];
        return actorWordList;
    }
;

#pragma C-

#endif /* _STRINGIZER_H_ */
