////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Wysiwyg 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _WYSIWYG_H_
#define _WYSIWYG_H_

#include <readableitem.h>

#pragma C+

/*
 *	Wysiwyg: ReadableItem
 *
 *	The Wysiwyg is meant to facilitate the creation of maps and other
 *	signs that the player encounters within a game. The layout of the map
 *	can be entered in the headerText, bodyText, and footerText lists as
 *	(single-quote) string elements, each string being a separate line of 
 *	text in the map. 
 *
 *	Formatting for HTML can be modified through the various Fmt methods.
 *	The size and colour of the box will need to be adjusted to the size 
 *	of your map. For best results Courier New should be used, as it 
 *	provides relatively little distortion.
 */
class Wysiwyg: ReadableItem
    lDesc = {
        if (length(self.headerText) == 0 
        && length(self.bodyText) == 0 
        && length(self.footerText) == 0)
            pass lDesc;

#ifdef USE_HTML_STATUS
           
        if (systemInfo(__SYSINFO_SYSINFO) == true
        and systemInfo(__SYSINFO_HTML) == 1) {
        	self.tableFmtBegin;
        	self.tableBGCOLOR;
        	if (length(self.headerText) > 0)
        		self.displayHeader;
        	if (length(self.bodyText) > 0)
        		self.displayBody;
        	if (length(self.footerText) > 0)
        		self.displayFooter;
        	self.tableFmtEnd;
        } else {
        	if (length(self.headerText) > 0)
        		self.printWysiwyg(self.headerText);
        	if (length(self.bodyText) > 0)
        		self.printWysiwyg(self.bodyText);
        	if (length(self.footerText) > 0)
        		self.printWysiwyg(self.footerText);
		}
    
#else 	/* USE_HTML_STATUS */
    
    	if (length(self.headerText) > 0)
      		self.printWysiwig(self.headerText);
   		if (length(self.bodyText) > 0)
       		self.printWysiwig(self.bodyText);
     	if (length(self.footerText) > 0)
     		self.printWysiwig(self.footerText);

#endif	/* USE_HTML_STATUS */

    }    
    displayHeader = {
        self.headerFont;
        self.headerFmtBegin;
        self.printWysiwyg(self.headerText);
        self.headerFmtEnd;
    }
    displayBody = {
        self.bodyFont;
        self.bodyFmtBegin;
        self.printWysiwyg(self.bodyText);
        self.bodyFmtEnd;        
    }
    displayFooter = {
        self.footerFont;
        self.footerFmtBegin;
        self.printWysiwyg(self.footerText);
        self.footerFmtEnd;        
    }
    tableFmtBegin = {
        "<BR>
        <P>
        <CENTER>
        <TABLE BORDER=1 CELLPADDING=15>";
    }
    tableBGCOLOR = {
        "<TR BGCOLOR=\"#AAAAAA\">
        <TD BGCOLOR=\"#AAAAAA\">";       
    }
    tableFmtEnd = {
       	"</TD>
        </TR>
        </TABLE>
        </CENTER>
        </P>";       
    }
    headerFont = {
        "<FONT COLOR=YELLOW SIZE=\"+1\" FACE=\"Courier New,Courier New\">";
    }
    headerFmtBegin = {
        "<P>
        <B>
        <CENTER>";
    }
    headerFmtEnd = {
        "</CENTER>
        </B>		
        </P>
        </FONT>";
    }
    bodyFont = {
        "<FONT COLOR=WHITE FACE=\"Courier New,Courier New\">";  
    }
    bodyFmtBegin = {
        "<P>";
    }
    bodyFmtEnd = {
        "</P>
        </FONT>";
    }
    footerFont = {
        "<FONT COLOR=YELLOW SIZE=\"-2\" FACE=\"Courier New,Courier New\">";
    }
    footerFmtBegin = {   
        "<P>
        <B>
        <CENTER>";
    }
    footerFmtEnd = {
        "</CENTER>
        </B>		
        </P>
        </FONT>";
    }
    headerText = []
    bodyText = []
    footerText = []
	printWysiwyg(list) = {
	    local i;
	    for (i = 1; i <= length(list); ++i) {
#ifdef USE_HTML_STATUS
            if (systemInfo(__SYSINFO_SYSINFO) == true
            and systemInfo(__SYSINFO_HTML) == 1)
                "<BR>"; 
            else
#endif /* USE_HTML_STATUS */
                "\n";
             
            say(self.noCompress(list[i]));
        }  
    }
    noCompress( str ) = {
    	local i, char, newStr := '';
    	for (i = 1; i <= length(str); ++i) {
    		char = substr(str,i,1);
    		if (char == ' ') {
#ifdef USE_HTML_STATUS
                if (systemInfo(__SYSINFO_SYSINFO) == true
                and systemInfo(__SYSINFO_HTML) == 1)
                    newStr += '&nbsp';
                else
#endif /* USE_HTML_STATUS */
			        newStr += '\ ';		// equivalent to '&nbsp'
		    }
		    else
			    newStr += char;
	    }
	    return newStr;
    }
;

#pragma C-

#endif /* _WYSIWYG_H_ */
