////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: addBulk() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ADD_BULK_T_
#define _ADD_BULK_T_

#pragma C+

/*
 *  addBulk: function(list)
 *
 *  This function returns the sum of the bulks (given by the bulk
 *  property) of each object in list.  The value returned includes
 *  only the bulk of each object in the list, and not of the contents
 *  of the objects, as it is assumed that an object does not change in
 *  size when something is put inside it.  You can easily change this
 *  assumption for special objects (such as a bag that stretches as
 *  things are put inside) by writing an appropriate bulk method
 *  for that object.
 */
addBulk: function(list) {
    local i, tot, totBulk, rem, cur;

    tot = length(list);
    i = 1;
    totBulk = 0;
    while(i <= tot) {
        cur = list[i];
        if (!cur.isWornBy(gActor()))
            totBulk = totBulk + cur.bulk;
        i = i + 1;
    }
    return totBulk;
}

#pragma C-

#endif /* _ADD_BULK_T_ */
