////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: listContCont() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _LIST_CONT_CONT_T_
#define _LIST_CONT_CONT_T_

#include <showcontcont.t>

#pragma C+

/*
 *  listContCont: function(obj)
 *
 *  This function lists the contents of the contents of an object.
 *  It displays full sentences, so no introductory or closing text
 *  is required.  
 *
 *  Any item in the contents list of the object obj whose
 *  canSenseContents(sight, isVantage) property is true has
 *  its contents listed.  An Object whose isQcontainer or
 *  isQsurface property is true will not have its
 *  contents listed.
 */
listContCont: function(obj) {
    local list, i, tot;
    
    /*
     *   Get the list.  If the "obj" parameter is already a list, use it
     *   directly; otherwise, list the contents of the object. 
     */
    switch(datatype(obj)) {
    case 2:
        /* it's an object - list its contents */
        list = obj.contents;
        break;
        
    case 7:
        /* it's already a list */
        list = obj;
        break;

    default:
        /* ignore other types entirely */
        return;
    }

    tot = length(list);
    i = 1;
    while (i <= tot) {
        showContCont(list[i]);
        i = i + 1;
    }
}

#pragma C-

#endif /* _LIST_CONT_CONT_T_ */
