////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: postAction() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _POST_ACTION_T_
#define _POST_ACTION_T_

#include <queue.t>

#pragma C+

postAction: function(actor, verb, dobj, prep, iobj, status) {
    local i, o, scopeList, ret, str, strList = [];
    
    // Set Phase and Stage
    global.setCommandPhase(CP_POSTACTION);
    
    // Set status
    if (gStatus() == 0) gStatus(status);
    
    // Get any outcaptured display from the action methods
    str = nestOutcapture(nil);
    if (str != '')
        strList += str;
    
    // If the command failed then we skip reactions
    if (status != EC_SUCCESS) goto lbl_process;
    
    // Get any outcaptured display from the actor
    nestOutcapture(true);
    ret = nil;
    ret = actor.actorPostAction;
    str = nestOutcapture(nil);
    if (str != '')
        strList += str;
    if (ret == true) {
        strList = [str];
        goto lbl_process;
    }
    
    // Get any outcaptured display from the actor location
    if (actor.location) {
        nestOutcapture(true);
        ret = nil;
        ret = actor.location.locPostAction;
        str = nestOutcapture(nil);
        if (str != '')
            strList += str;
        if (ret == true) {
            strList = [str];
            goto lbl_process;
        }
    }
    
    // Get scopeList based on verb.scopeSense
    scopeList = actor.scope(verb.scopeSense, [], nil, nil);   
    scopeList = intersect(scopeList, global.scopePreActionList);

    // Get any outcaptured display from scope objects
    for (i = 1; i <= length(scopeList); ++i) {
        o = scopeList[i];
        
        if (o == actor||o == actor.location||o == dobj||o == iobj)
            continue;
            
        nestOutcapture(true);
        ret = nil;
        ret = o.scopePostAction;
        str = nestOutcapture(nil);
        if (str != '')
            strList += str;
        if (ret == true) {
            strList = [str];
            goto lbl_process;
        }
    }
    
    // Get any outcaptured display from the indirect-object
    if (iobj) {
        nestOutcapture(true);
        ret = nil;
        ret = iobj.iobjPostAction;
        str = nestOutcapture(nil);
        if (str != '')
            strList += [str];
        if (ret == true) {
            strList = [str];
            goto lbl_process;
        }
    }
    
    // Get any outcaptured display from the direct-object
    if (dobj) {
        nestOutcapture(true);
        ret = nil;
        ret = dobj.dobjPostAction;
        str = nestOutcapture(nil);
        if (str != '')
            strList += str;
        if (ret == true) {
            strList = [str];
            goto lbl_process;
        }
    }
    
lbl_process: ;
    for (i = 1; i <= length(strList); ++i) {
        str = strList[i];
        queue.queueMessage(gActor(), gVerb(), gDobj(), 
            gPrep(), gIobj(), gStatus(), str);
    }
}

#pragma C-

#endif /* _POST_ACTION_T_ */
