////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: preinit() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _PREINIT_T_
#define _PREINIT_T_

#include <global.t>
#include <initsearch.t>

#pragma C+

/*
 *   preinit() is called after compiling the game, before it is written
 *   to the binary game file.  It performs all the initialization that can
 *   be done statically before storing the game in the file, which speeds
 *   loading the game, since all this work has been done ahead of time.
 *
 *   This routine puts all lamp objects (those objects with islamp = true) into
 *   the list global.lamplist.  This list is consulted when determining whether
 *   a dark room contains any light sources.
 */
preinit: function {
    local o;
    
    checkInterface();
    
    initSearch();
    
	// Move Floating objects to their containers
    moveFloating(Me);
    
    // set the story serial number
    story.setSerial;

    global.sensesList = [];
    global.lampList = [];
    global.preparseObjList = [];
    global.scopePreActionList = [];
    global.scopePostActionList = [];
    global.scopeEndCommandList = [];
    
    o = firstobj();
    while(o) {
        if (isclass(o, Sense))
            global.sensesList += o;
        if (o.isLamp)
            global.lampList += o;
        if (o.isPreparseObj)
        	global.preparseObjList += o;
    	if (proptype(o, &scopePreAction) != DTY_NIL)
    	    global.scopePreActionList += o;
	    if (proptype(o, &scopePostAction) != DTY_NIL)
	        global.scopePostActionList += o;
        if (proptype(o, &scopeEndCommand) != DTY_NIL)
            global.scopeEndCommandList += o;
        o = nextobj(o);
    }
}

#pragma C-

#endif /* _PREINIT_T_ */
