////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: sayPrefixCount() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SAY_PREFIX_COUNT_T_
#define _SAY_PREFIX_COUNT_T_

#pragma C+

/*
 *  sayPrefixCount: function(cnt)
 *
 *  This function displays a count (suitable for use in listcont when
 *  showing the number of equivalent items.  We display the count spelled out
 *  if it's a small number, otherwise we just display the digits of the
 *  number.
 */
sayPrefixCount: function(cnt) {
    if (cnt <= 20)
        say(['one' 'two' 'three' 'four' 'five'
            'six' 'seven' 'eight' 'nine' 'ten'
            'eleven' 'twelve' 'thirteen' 'fourteen' 'fifteen'
            'sixteen' 'seventeen' 'eighteen' 'nineteen' 'twenty'][cnt]);
    else say(cnt);
}

#pragma C-

#endif /* _SAY_PREFIX_COUNT_T_ */
